<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 6/11/2015	ELL
// Added ability to handle GIF and PNG images is additon to JPG images.
// Revised: 1/5/2016	ELL
// Added switch to preserve (or not) aspect ratio.
//
function resize_image($filename, $width, $height, $destfile, $supress_message = 0, $preserve_aspect_ratio = 1)
{
	$type = exif_imagetype($filename);
    switch($type)
	{
        case IMAGETYPE_JPEG:
            $image = imagecreatefromjpeg($filename); //jpeg file
        	break;
        case IMAGETYPE_GIF:
            $image = imagecreatefromgif($filename); //gif file
			break;
		case IMAGETYPE_PNG:
		  $image = imagecreatefrompng($filename); //png file
			break;
		default:
			$image = false;
			break;
    }
    if (!$image)
		return 0;

    list($width_orig, $height_orig) = getimagesize($filename);

    if ($width_orig < $width && $height_orig < $height)
    {
		if ($supress_message != 1)
			echo "ORIGINAL IMAGE $filename SIZE ($width_orig, $height_orig) IS TOO SMALL!<br>";
		if ($filename == $destfile)
			return 1;
		else
			return copy($filename, $destfile);
    }
	
	if ($preserve_aspect_ratio == 1)	{
		if (($width / $width_orig) * $height_orig > $height) {
			$width = ($height / $height_orig) * $width_orig;
		} else {
			$height = ($width / $width_orig) * $height_orig;
		}
	}

    // Resample
    $image_p = imagecreatetruecolor($width, $height);
    imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);

    // Output
	switch($type)
	{
        case IMAGETYPE_JPEG:
    		imagejpeg($image_p, $destfile, 90);	// quality 90
			break;
        case IMAGETYPE_GIF:
			imagegif($image_p, $destfile);
			break;
		case IMAGETYPE_PNG:
			imagepng($image_p, $destfile, 0); // 0 -> no compression
			break;
		default:
			return 0;
			break;
	}
    @chmod($destfile, 0644);
    return 1;
}

function crop_image($filename, $crop_percent, $destfile, $crop_area)
{		
	// Create original image
	$type = exif_imagetype($filename);
    switch($type)
	{
        case IMAGETYPE_JPEG:
            $origimg = imagecreatefromjpeg($filename); //jpeg file
        	break;
        case IMAGETYPE_GIF:
            $origimg = imagecreatefromgif($filename); //gif file
			break;
		case IMAGETYPE_PNG:
		  $origimg = imagecreatefrompng($filename); //png file
			break;
		default:
			$origimg = false;
			break;
    }
	if (!$origimg)
		return 0;
		
	// Get the original size
    list($width_orig, $height_orig) = getimagesize($filename);
	
	if (($crop_area == "center") || ($crop_area == ""))
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartY = round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartX = round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
	}
	else if ($crop_area == "top")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartY = round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartY = round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
	}
	else if ($crop_area == "bottom")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartY = $height_orig - $cropH - round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartY = $height_orig - $cropH - round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
	}
	else if ($crop_area == "left")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartX = round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartX = round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
	}
	else if ($crop_area == "right")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartX = $width_orig - $cropW - round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartX = $width_orig - $cropW - round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
	}
	
	// Create image to store cropped image in.
	$cropimg = imagecreatetruecolor($cropW,$cropH);
	
	// Crop
	imagecopyresized($cropimg, $origimg, 0, 0, $cropStartX, $cropStartY, $cropW, $cropH, $cropW, $cropH);

    // Output
	switch($type)
	{
        case IMAGETYPE_JPEG:
    		imagejpeg($cropimg, $destfile, 90);	// quality 90
			break;
        case IMAGETYPE_GIF:
			imagegif($cropimg, $destfile);
			break;
		case IMAGETYPE_PNG:
			imagepng($cropimg, $destfile, 0); // 0 -> no compression
			break;
		default:
			return 0;
			break;
	}
	
    @chmod($destfile, 0644);
    return 1;
}
?>