<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/20/2013	ELL
// New main.php created for version 5 of the BWB.
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
// Revised: 12/22/2013	ELL
// Added ability to check for saved wokspace data and prompt user for action.
// Revised: 3/12/2013	ELL
// Fixed pesky bug with buttons locking up.
// Revised: 4/3/2014	ELL
// Added button for installing plugins into existing pages.
// Revised: 4/14/2014	ELL
// Added ability to present plugin buttons to bloggers and restricted users if plugin access set to blogger or restricted.
// Revised: 11/17/2014	ELL
// Added new button for editing files.
// Revised: 1/13/2015	ELL
// Added NEW SESSION button to allow easy editing of multiple items.
// Revised: 3/2/2015	ELL
// Added use of language files.
// Revised: 7/2/2015	ELL
// Added ability to set workspace thru URL var.
// Revised: 1/18/2016	ELL
// Added ability to put custom in any button group.
// Fixed bug with users and power users not seeing plugin buttons that don't have access level assigned.
// Revised: 4/12/2016	ELL
// Added sub button level to SetPreviousBtnState.
	
	include ("check_session.php");
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'EnableWizard'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$enable_wizard = $row['option_value'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'RunWizardLocal'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$wiz_mode = $row['option_value'];
	
	if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
		$website_file_path = "/index.php";
	elseif (BWB_BASE_DIR == '')
		$website_file_path = "/" . BWB_WEBPAGE_DIR . "/";
	elseif (BWB_WEBPAGE_DIR == '')
		$website_file_path = "/" . BWB_BASE_DIR . "/";
	else
		$website_file_path = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";
		
	/////////// Determine Plugin Buttons ///////////////////////////
	function custom_inArray($needle, $haystack) {
	// $needle is string, but elements of array $haystack are also arrays.  If any element in array element
	// matches string, return true, otherwise false.
		foreach ($haystack as $value) {
			if (in_array($needle, $value)) {
				return true;
			}
		}
		return false;
	}

	if ($access_level == "blogger")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE (AccessLevel='blogger') AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "restricted")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='blogger') OR (AccessLevel='restricted')) AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "user")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='blogger') OR (AccessLevel='restricted') OR (AccessLevel='user') OR (AccessLevel='') OR (AccessLevel IS NULL)) AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "power_user")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='blogger') OR (AccessLevel='restricted') OR (AccessLevel='user') OR (AccessLevel='power_user') OR (AccessLevel='') OR (AccessLevel IS NULL)) AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "admin")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE deployed=1 ORDER BY sort_order";
		
	$plugin_buttons = array();
	$plugin_css = array();
	$result = $bwb_dbh->query($query);
	if (($result->rowCount() < 1) && (($access_level == "restricted") || ($access_level == "blogger")))
		$show_other = false;
	else
		$show_other = true;
	$i = 0;
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$console_path = $row['console_path'];
		if (isset($console_path) && ($console_path != ""))
		{
			$console_link_text = $row['console_link_text'];
			$console_link_image = $row['console_link_image'];
			$console_link_image_mo = $row['console_link_image_mo'];
			$console_link_image_down = $row['console_link_image_down'];
			$language_folder = $row['language_folder'];
			$console_link_text_define = $row['console_link_text_define'];
			if (isset($row['menu_group']) && !is_null($row['menu_group']))
				$menu_group = $row['menu_group'];
			else
				$menu_group = "";
			if (isset($language_folder) && isset($console_link_text_define) && ($console_link_text_define != ""))
			{
				include_once ($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php");
				if (defined($console_link_text_define) && (constant($console_link_text_define) != ""))
					$console_link_text = constant($console_link_text_define);
			}

			if (!custom_inArray($console_path, $plugin_buttons))
			{
				$button_string = "<div class=\"button_top_level\" id=\"btn_custom_" . $i . "\" title=\"" . $console_link_text . "\" onClick=\"SetWorkspaceLocation('" . $console_path . "', this);\"><span class=\"button_text_top_level\">" . $console_link_text . "</span></div>\n";
				
				$css_string = "#btn_custom_" . $i . "	{	background-image:url(" . $console_link_image . ");	}\n";
				$css_string .= "#btn_custom_" . $i . ":hover	{	background-image:url(" . $console_link_image_mo . ");	}\n";
				$css_string .= "#btn_custom_" . $i . ".down	{	background-image:url(" . $console_link_image_down . ");	}\n";
				
				$plugin_buttons[$console_link_text] = array($console_path, $button_string, $menu_group, "$i");
				$plugin_css[$console_link_text] = array($console_path, $css_string);
				$i++;
			}
		}
	}
	$plugin_button_cnt = count($plugin_buttons);
?>
<!doctype html>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style type="text/css">
<?php
	if ($plugin_css)
	{
		foreach ($plugin_css as $key => $value)
			echo $value[1];
	}
?>
#help_button	{
	display:block;
	position:absolute;
	top:10px;
	right:12px;
}

.help_button_main	{
	width:30px;
	height:30px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 0px 1px;
	background-image:url(images/help.png);
}
.help_button_main:hover	{
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 0px 1px;
	background-image:url(images/help_mo.png);
	cursor:pointer;
}

#username	{
	right: <?php if (($access_level == "power_user") || ($access_level == "admin")) echo "350"; else echo "190"; ?>px;
}
</style>

<script language="javascript" type="text/javascript" src="js/ajax.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/main.js"></script>

<script language="JavaScript"  type="text/javascript">
<?php
	echo "	var theme = '$theme';\n";
	echo "	var MAIN_MENU_TIMEOUT_ERR = \"" . MAIN_MENU_TIMEOUT_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
?>
	var cancel_set_prev_btn_state = false;

function InitializePage()
{
	SetAccessLevel();
	ExpandCollapseMenus();
	ResizeWorkspace();
	
<?php
	if (isset($_SESSION['button_group']) && isset($_SESSION['button']))
	{
		$button_group = $_SESSION['button_group'];
		$button = $_SESSION['button'];
		echo "function SetPreviousBtnState()	{\n";
		echo "	if (cancel_set_prev_btn_state)	{\n";
		echo "		cancel_set_prev_btn_state = false;\n";
		echo "		return;\n";
		echo "	}\n";
		echo "	ExpandCollapseMenus('$button_group');\n";
		echo "	var btn_el = document.getElementById('$button');\n";
		echo "	SetBtnDown(btn_el);\n";
		echo "	btn_el.click();\n";
		echo "}\n";
		echo "	var mTimerSPBS = setTimeout(function() { SetPreviousBtnState(); }, 2000);\n";
		unset($_SESSION['button_group']);
		unset($_SESSION['button']);
		if (isset($_SESSION['sub_button']))
		{
			$sub_button = $_SESSION['sub_button'];
			echo "function SetPreviousSubBtnState()	{\n";
			echo "	if (cancel_set_prev_btn_state)	{\n";
			echo "		cancel_set_prev_btn_state = false;\n";
			echo "		return;\n";
			echo "	}\n";
			echo "	var btn_el = window.frames['workspace'].document.getElementById('$sub_button');\n";
			echo "	btn_el.click();\n";
			echo "}\n";
			echo "	var mTimerSPSBS = setTimeout(function() { SetPreviousSubBtnState(); }, 3000);\n";
			unset($_SESSION['sub_button']);
		}
	}
?>
}

function ResizeWorkspace()
{
	if ((browser == "Explorer") && (browser_version <= 7))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		// Roughly 440 pixels added to client height with menus expaned that also needs to be subtracted off.
		document.getElementById("workspace").height = document.body.clientHeight - workspace_top_expanded - 440;
		document.getElementById("workspace").style.top = "145px";
		document.getElementById("btn_horizontal_expand_collapse_menus").style.top = "145px";
	}
	else if ((browser == "Explorer") && (browser_version == 8))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		// Roughly 440 pixels added to client height with menus expaned that also needs to be subtracted off.
		document.getElementById("workspace").height = document.body.clientHeight - workspace_top_expanded - 410;
	}
	else if ((browser == "Explorer") && (browser_version > 8))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		document.getElementById("workspace").height = window.innerHeight - workspace_top_expanded - 10;
	}
	else // if ((browser == "Firefox") || (browser == "Opera") || (browser == "Safari") || (browser == "Chrome"))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		document.getElementById("workspace").height = window.innerHeight - workspace_top_expanded - 20;
	}
//	alert("document.getElementById('workspace').height: " + document.getElementById("workspace").height);
}
	
var access_level = '<?php echo $access_level; ?>';
var enable_wizard = '<?php echo $enable_wizard; ?>';


<?php
	if (isset($plugin_button_cnt))
		echo "	var plugin_button_cnt = $plugin_button_cnt;\n";
	else
		echo "	var plugin_button_cnt = 0;\n";
		
	if ($show_other)
		echo "	var show_other = true;\n";
	else
		echo "	var show_other = false;\n";
		
	echo "	var plugin_buttons = new Array();\n";
	$i = 0;
	foreach ($plugin_buttons as $plugin_button)	{
		echo "	plugin_buttons[$i] = [" . $plugin_button[3] . ", '" . $plugin_button[2] . "'];\n";
		$i++;
	}
	
?>

</script>
</head>

<body onLoad="InitializePage();" class="main">

<div id="logo_div">
<img src="theme/<?php echo $theme; ?>/images/Breeze_header_logo.png" border="0" alt="Breeze Website Builder" style="margin-top:-10px; margin-left:-10px;" onClick="CollapseHeader();" />
</div>

<div class="help_button_main" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div>

<div id="header_divider" onClick="ExpandHeader();">
	<span class="header_divider_text"><?php echo MAIN_MENU_HEADER_DIVIDER; ?>
  <div id="bwb_version">
		<?php include ("version.php"); ?>
	</div>
    </span>
</div>

<img src="theme/<?php echo $theme; ?>/images/icon_collapse-column.png" border="0" onClick="HorizontalExpandCollapseMenuClick();" id="btn_horizontal_expand_collapse_menus" />
<div id="view_buttons">
<div id="content_functions">
<div class="button_heading_top_level" id="btn_heading_content" title="<?php echo MAIN_MENU_CONTENT_HEADING; ?>" onClick="ExpandCollapseMenus('content_functions');"><div class="button_heading_text_top_level"><?php echo MAIN_MENU_CONTENT_HEADING; ?></div></div>
<div class="button_top_level" id="btn_edit_content" title="<?php echo MAIN_MENU_EDIT_PAGE_BTN; ?>" onClick="SetWorkspaceLocation('edit_page_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_PAGE_BTN; ?></span></div>
<div class="button_top_level" id="btn_create_page" title="<?php echo MAIN_MENU_CREATE_PAGE_BTN; ?>" onClick="SetWorkspaceLocation('create_page_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_CREATE_PAGE_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_border_areas" title="<?php echo MAIN_MENU_MANAGE_BORDER_AREAS_BTN; ?>" onClick="SetWorkspaceLocation('manage_border_area_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_MANAGE_BORDER_AREAS_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_images" title="<?php echo MAIN_MENU_MANAGE_IMAGES_BTN; ?>" onClick="SetWorkspaceLocation('/kfm/index.php?startup_folder=<?php echo BWB_IMAGE_DIR; ?>&langCode=<?php echo BWB_LANG; ?>', this);"><span class="button_text_top_level" ><?php echo MAIN_MENU_MANAGE_IMAGES_BTN; ?></span></div>
<div class="button_top_level" id="btn_preview_published_site" title="<?php echo MAIN_MENU_PREVIEW_SITE_BTN; ?>" onClick="SetWorkspaceLocation('<?php echo $website_file_path; ?>', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_PREVIEW_SITE_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_edit_blog" title="<?php echo MAIN_MENU_EDIT_BLOG_BTN; ?>" onClick="SetWorkspaceLocation('edit_blog_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_BLOG_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_file" title="<?php echo MAIN_MENU_EDIT_FILE_BTN; ?>" onClick="SetWorkspaceLocation('edit_file_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_FILE_BTN; ?></span></div>
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $plugin_button)	{
			if ($plugin_button[2] == "content_functions")
				echo $plugin_button[1];
		}
	}
?>
</div>

<div id="menu_functions">
<div class="button_heading_top_level" id="btn_heading_menu" title="<?php echo MAIN_MENU_MENUS_HEADING; ?>" onClick="ExpandCollapseMenus('menu_functions');"><div class="button_heading_text_top_level"><?php echo MAIN_MENU_MENUS_HEADING; ?></div></div>
<div class="button_top_level" id="btn_edit_menu_items" title="<?php echo MAIN_MENU_EDIT_MENUS_BTN; ?>" onClick="SetWorkspaceLocation('edit_menu_items.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_MENUS_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_menu_assignments" title="<?php echo MAIN_MENU_MANAGE_MENUS_BTN; ?>" onClick="SetWorkspaceLocation('manage_menu.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_MANAGE_MENUS_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_css_menu_params" title="<?php echo MAIN_MENU_EDIT_CSS_MENU_PARAMS_BTN; ?>" onClick="SetWorkspaceLocation('edit_css_menu_params.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_CSS_MENU_PARAMS_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_css_menu_styles" title="<?php echo MAIN_MENU_EDIT_CSS_MENU_STYLES_BTN; ?>" onClick="SetWorkspaceLocation('edit_css_menu_styles.php', this);"><span class="button_text_top_level" ><?php echo MAIN_MENU_EDIT_CSS_MENU_STYLES_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_js_menu_params" title="<?php echo MAIN_MENU_EDIT_JS_MENU_PARAMS_BTN_ALT; ?>" onClick="SetWorkspaceLocation('edit_js_menu_params.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_JS_MENU_PARAMS_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_js_menu_styles" title="<?php echo MAIN_MENU_EDIT_JS_MENU_STYLES_BTN_ALT; ?>" onClick="SetWorkspaceLocation('edit_js_menu_styles.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_JS_MENU_STYLES_BTN; ?></span></div>
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $plugin_button)	{
			if ($plugin_button[2] == "menu_functions")
				echo $plugin_button[1];
		}
	}
?>
</div>

<div id="style_functions">
<div class="button_heading_top_level" id="btn_heading_style" title="<?php echo MAIN_MENU_STYLES_HEAD_CONTENT_HEADING_ALT; ?>" onClick="ExpandCollapseMenus('style_functions');"><div class="button_heading_text_top_level" style="letter-spacing:-1px"><?php echo MAIN_MENU_STYLES_HEAD_CONTENT_HEADING; ?></div></div>
<div class="button_top_level" id="btn_edit_styles" title="<?php echo MAIN_MENU_EDIT_STYLES_BTN; ?>" onClick="SetWorkspaceLocation('edit_css_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_STYLES_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_head_code" title="<?php echo MAIN_MENU_EDIT_HEAD_BTN; ?>" onClick="SetWorkspaceLocation('edit_head_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_HEAD_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_head_code" title="<?php echo MAIN_MENU_MANAGE_HEAD_BTN; ?>" onClick="SetWorkspaceLocation('manage_head.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_MANAGE_HEAD_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_favicon" title="<?php echo MAIN_MENU_EDIT_FAVICON_BTN; ?>" onClick="SetWorkspaceLocation('edit_favicon.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_FAVICON_BTN; ?></span></div>
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $plugin_button)	{
			if ($plugin_button[2] == "style_functions")
				echo $plugin_button[1];
		}
	}
?>
</div>

<div id="page_functions">
<div class="button_heading_top_level" id="btn_heading_page" title="<?php echo MAIN_MENU_PAGE_MANAGEMENT_HEADING; ?>" onClick="ExpandCollapseMenus('page_functions');"><div class="button_heading_text_top_level"><?php echo MAIN_MENU_PAGE_MANAGEMENT_HEADING; ?></div></div>
<div class="button_top_level" id="btn_edit_page_titles" title="<?php echo MAIN_MENU_EDIT_PAGE_TITLES_BTN; ?>" onClick="SetWorkspaceLocation('edit_title_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_PAGE_TITLES_BTN; ?></span></div>
<div class="button_top_level" id="btn_edit_meta_tags" title="<?php echo MAIN_MENU_EDIT_META_TAGS_BTN; ?>" onClick="SetWorkspaceLocation('edit_meta_tags.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_EDIT_META_TAGS_BTN; ?></span></div>
<div class="button_top_level" id="btn_delete_page" title="<?php echo MAIN_MENU_DELETE_PAGE_BTN; ?>" onClick="SetWorkspaceLocation('delete_page_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_DELETE_PAGE_BTN; ?></span></div>
<div class="button_top_level" id="btn_copy_rename_page" title="<?php echo MAIN_MENU_COPY_RENAME_BTN; ?>" onClick="SetWorkspaceLocation('copy_rename_page_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_COPY_RENAME_BTN; ?></span></div>
<div class="button_top_level" id="btn_restore_page" title="<?php echo MAIN_MENU_RESTORE_BTN; ?>" onClick="SetWorkspaceLocation('restore_page_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_RESTORE_BTN; ?></span></div>
<div class="button_top_level" id="btn_add_plugin_to_page" title="<?php echo MAIN_MENU_ADD_PLUGIN_TO_PAGE_BTN; ?>" onClick="SetWorkspaceLocation('add_plugin_to_page_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_ADD_PLUGIN_TO_PAGE_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_page_access" title="<?php echo MAIN_MENU_MANAGE_PAGE_ACCESS_BTN; ?>" onClick="SetWorkspaceLocation('manage_page_access.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_MANAGE_PAGE_ACCESS_BTN; ?></span></div>
<div class="button_top_level" id="btn_manage_page_attributes" title="<?php echo MAIN_MENU_MANAGE_PAGE_ATTRIBUTES; ?>" onClick="SetWorkspaceLocation('manage_page_attributes.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_MANAGE_PAGE_ATTRIBUTES; ?></span></div>
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $plugin_button)	{
			if ($plugin_button[2] == "page_functions")
				echo $plugin_button[1];
		}
	}
?>
</div>

<div id="other_functions">
<div class="button_heading_top_level" id="btn_heading_site" title="<?php echo MAIN_MENU_SITE_MANAGEMENT_HEADING; ?>" onClick="ExpandCollapseMenus('other_functions');"><div class="button_heading_text_top_level"><?php echo MAIN_MENU_SITE_MANAGEMENT_HEADING; ?></div></div>
<div id="plugin_buttons_div">
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $plugin_button)	{
			if (($plugin_button[2] == "other_functions") || ($plugin_button[2] == ""))
				echo $plugin_button[1];
		}
	}
?>
</div>

<?php
	if (($access_level != "blogger") && ($access_level != "restricted"))
	{
		if ($enable_wizard == 1)
		{
			if ($wiz_mode == 1)
				echo "<div class=\"button_top_level\" id=\"btn_show_wizard\" title=\"" . MAIN_MENU_RERUN_WIZARD_BTN . "\" onClick=\"SetWorkspaceLocation('run_wizard_confirm.php', this);\"><span class=\"button_text_top_level\">" . MAIN_MENU_RERUN_WIZARD_BTN . "</span></div>\n";
			else
				echo "<div class=\"button_top_level\" id=\"btn_show_wizard\" title=\"" . MAIN_MENU_UPLOAD_TEMPLATE_BTN . "\" onClick=\"SetWorkspaceLocation('upload_template_confirm.php', this);\"><span class=\"button_text_top_level\">" . MAIN_MENU_UPLOAD_TEMPLATE_BTN . "</span></div>\n";
		}
?>

<div class="button_top_level" id="btn_users_site_options" title="<?php echo MAIN_MENU_MANAGE_USERS_SITE_OPTIONS_BTN_ALT; ?>" onClick="SetWorkspaceLocation('admin_function_select.php', this);"><span class="button_text_top_level"><?php echo MAIN_MENU_MANAGE_USERS_SITE_OPTIONS_BTN; ?></span></div>
</div>
<?php } // access_level > restricted and blogger ?>
</div>

<div id="access_level"><?php echo ACCESS_LEVEL_WORD; ?>: <span class="access_level"><?php echo $access_level; ?></span></div>
<div id="username"> <?php echo WELCOME_WORD . " "; if (($first_name != "") || ($last_name != "")) echo $first_name . " " . $last_name; else echo $userid; ?></div>

<?php if (($access_level == "power_user") || ($access_level == "admin"))	{	?>
<div class="button_heading_top_level new_session" id="btn_new_session" onClick="window.open('main.php');"><span class="button_heading_text_top_level new_session"><?php echo MAIN_MENU_NEW_SESSION_BTN; ?></span></div>
<?php }	?>

<div class="button_heading_top_level logout" id="btn_logout" onClick="window.location='index.php';"><span class="button_heading_text_top_level logout"><?php echo MAIN_MENU_LOGOUT_BTN; ?></span></div>


<iframe src="dashboard.php?version_file=<?php echo VERSION; ?>" name="workspace" id="workspace" scrolling="auto" frameborder="0" style="overflow-x:scroll;"></iframe>


<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
//alert(browser + " " + browser_version);

HidePopupMsg();

<?php
if (isset($_GET['module']) && ($_GET['module'] != "") && isset($_GET['btn']) && ($_GET['btn'] != ""))
{
	$module = $_GET['module'];
	$btn = $_GET['btn'];
	echo "var code = \"SetWorkspaceLocation('$module', document.getElementById('$btn'));\";\n";
	echo "var mTimerSWL = setTimeout(code, 3000);\n";
}
?>
</script>
</body>
</html>
