<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/3/2009
// Rezised: 6/29/2009	ELL
// Fixed bug of assignments corrupting templates that do not have all 4: top, bottom, left and right sections.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 5/10/2013	ELL
// Added new areas header and footer.  Headers go above the top cell and footers go below the bottom cell.
// Revised: 6/24/2013	ELL
// Added ability to specify meaningful names.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/18/2013	ELL
// Added visual feedback for assigning border areas to pages.
// Revised: 10/2/2015	ELL
// Modified from searching page template file for bordere area names to looking up border areas in page data table.
// Modified determination of existence of border from searching page template file to searching template name in page data table.
// Revised: 11/12/2015	ELL
// Converted from HTML/PHP POST application to AJAX application.

	
	include ("check_session.php");
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Border Areas | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#manage_custom_border_areas_heading	{	width:300px;	}
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:260px;
	height:31px;
	width:31px;
	z-index:100;
}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/manage_border_area.js"></script>
<script>
<?php 
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETED_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETED_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETED_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETED_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETED_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGN_AREA = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGN_AREA . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_1_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_1_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_2_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_2_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_NO_AREAS_FOUND_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_NO_AREAS_FOUND_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ADDED_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ADDED_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ADDED_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ADDED_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ADDED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ADDED_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var ERROR_WORD = \"" . ERROR_WORD . "\";\n";
	echo "	var CLICK_WORD = \"" . CLICK_WORD . "\";\n";
	echo "	var HERE_WORD = \"" . HERE_WORD . "\";\n";
	echo "	var ASSIGN_WORD = \"" . ASSIGN_WORD . "\";\n";
	echo "	var TO_WORD = \"" . TO_WORD . "\";\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeConsole();">
<table width="90%" border="0" align="center"><tr><td>
<div class="button_heading_sub_level_1" id="manage_custom_border_areas_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_CUSTOM_BORDER_AREA_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<table width="90%" align="center" class="group_box_table"><tr>
  <td>
<span class="sub_title"><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_AREA; ?></span>
<table width="100%" class="layout_box_table" align="center">
<tr>
<td align="center">
right<input type="text" name="suffix" id="right_suffix" style="width:100px;" />
<br />
<div class='button_console' style="width:165px;" onClick="AddBorderArea('right');"><span class='button_console_text'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_RIGHT_BTN; ?></span></div>
</td>
<td align="center">
left<input type="text" name="suffix" id="left_suffix" style="width:100px;" />
<br />
<div class='button_console' style="width:160px;" onClick="AddBorderArea('left');"><span class='button_console_text'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_LEFT_BTN; ?></span></div>
</td>
<td align="center">
top<input type="text" name="suffix" id="top_suffix" style="width:100px;" />
<br />
<div class='button_console' style="width:160px;" onClick="AddBorderArea('top');"><span class='button_console_text'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_TOP_BTN; ?></span></div>
</td>
<td align="center">
bottom<input type="text" name="suffix" id="bottom_suffix" style="width:100px;" />
<br />
<div class='button_console' style="width:175px;" onClick="AddBorderArea('bottom');"><span class='button_console_text'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_BOTTOM_BTN; ?></span></div>
</td>
<td align="center">
header<input type="text" name="suffix" id="header_suffix" style="width:100px;" />
<br />
<div class='button_console' style="width:175px;" onClick="AddBorderArea('header');"><span class='button_console_text'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_HEADER_BTN; ?></span></div>
</td>
<td align="center">
footer<input type="text" name="suffix" id="footer_suffix" style="width:100px;" />
<br />
<div class='button_console' style="width:175px;" onClick="AddBorderArea('footer');"><span class='button_console_text'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_FOOTER_BTN; ?></span></div>
</td>

</tr>
</table>
</td></tr></table>
<br />

<table width="90%" align="center" class="group_box_table"><tr><td>
<div id="border_area_assignment_table">&nbsp;</div>
</td></tr></table>
<br />
	<table width="90%" align="center" class="group_box_table"><tr><td>
    
	<table width="100%" align="center" class="layout_box_table">
      <tr>
        <td>
        	<span class="sub_title"><?php echo MANAGE_CUSTOM_BORDER_AREA_RENAME_AREA; ?></span>
        </td>
        <td>
            <span class="sub_title"><?php echo MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA; ?></span>
        </td>
      </tr>
      <tr>
      	<td>
      	  <table width="100%" align="center" class="layout_box_table">
      		<tr>
              <td align="right"><?php echo MANAGE_CUSTOM_BORDER_AREA_RENAME_AREA_SELECT; ?>: </td>
              <td>
                <select name="area_old_name" id="area_old_name" onChange="var prefix=GetAreaFromName(this.value); document.getElementById('name_prefix_display').innerHTML=prefix; document.getElementById('name_prefix').value=prefix;">
                </select>
              </td>
              <td align="right"><?php echo MANAGE_CUSTOM_BORDER_AREA_NEW_NAME; ?>: </td>
              <td align="right" style="width:60px;">
              <div id="name_prefix_display">&nbsp;</div>
              <input type="hidden" name="name_prefix" id="name_prefix" />
              </td>
              <td><input type="text" name="name_suffix" id="name_suffix" style="width:100px;" /></td>
              <td align="center">
              <div class='button_console_edit' style="width:100px;" onClick="RenameBorderArea();"><span class='button_console_text_w_icon'><?php echo RENAME_WORD; ?></span></div>
              </td>
			</tr>
         </table>
      </td>
      <td>
        <table width="100%" align="center" class="layout_box_table">
      		<tr>
              <td align="right"><?php echo MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_SELECT; ?>: </td>
              <td>
                <select name="area_name" id="area_name_delete">
                </select>
              </td>
              <td align="center">
              <div class='button_console_delete' style="width:100px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
              </td>
            </tr>
        </table>
    
       </td>
     </tr>
    </table>
    
    </td></tr></table>


<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>

</body>
</html>