<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/4/2009
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 10/2/2015	ELL
// Modified from searching page template file for head name to looking up head name in page data table.
// Revised: 11/12/2015	ELL
// Converted from HTML/PHP POST application to AJAX application.
	
	include ("check_session.php");
	
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Head Content | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}
#add_head_btn	{	width:230px;	}
#rename_head_btn	{	width:110px;	}
#delete_head_btn	{	width:110px;	}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/manage_head.js"></script>

<script>
<?php
	echo "	var MANAGE_HEAD_DELETE_HEAD_CONFIRM_1_MSG = \"" . MANAGE_HEAD_DELETE_HEAD_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_HEAD_DELETE_HEAD_CONFIRM_2_MSG = \"" . MANAGE_HEAD_DELETE_HEAD_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_HEAD_DELETED_1_MSG = \"" . MANAGE_HEAD_DELETED_1_MSG . "\";\n";
	echo "	var MANAGE_HEAD_DELETED_2_MSG = \"" . MANAGE_HEAD_DELETED_2_MSG . "\";\n";
	echo "	var MANAGE_HEAD_DELETED_ERR = \"" . MANAGE_HEAD_DELETED_ERR . "\";\n";
	echo "	var MANAGE_HEAD_NO_HEADS_FOUND_ERR = \"" . MANAGE_HEAD_NO_HEADS_FOUND_ERR . "\";\n";
	echo "	var MANAGE_HEAD_ASSIGN_HEAD_CONTENT_TO_PAGE = \"" . MANAGE_HEAD_ASSIGN_HEAD_CONTENT_TO_PAGE . "\";\n";
	echo "	var MANAGE_HEAD_NOT_FOUND_1_ERR = \"" . MANAGE_HEAD_NOT_FOUND_1_ERR . "\";\n";
	echo "	var MANAGE_HEAD_NOT_FOUND_2_ERR = \"" . MANAGE_HEAD_NOT_FOUND_2_ERR . "\";\n";
	echo "	var MANAGE_HEAD_ASSIGNED_1_MSG = \"" . MANAGE_HEAD_ASSIGNED_1_MSG . "\";\n";
	echo "	var MANAGE_HEAD_ASSIGNED_2_MSG = \"" . MANAGE_HEAD_ASSIGNED_2_MSG . "\";\n";
	echo "	var MANAGE_HEAD_ASSIGNED_1_ERR = \"" . MANAGE_HEAD_ASSIGNED_1_ERR . "\";\n";
	echo "	var MANAGE_HEAD_ASSIGNED_2_ERR = \"" . MANAGE_HEAD_ASSIGNED_2_ERR . "\";\n";
	echo "	var MANAGE_HEAD_ASSIGNED_3_ERR = \"" . MANAGE_HEAD_ASSIGNED_3_ERR . "\";\n";
	echo "	var MANAGE_HEAD_ADDED_1_MSG = \"" . MANAGE_HEAD_ADDED_1_MSG . "\";\n";
	echo "	var MANAGE_HEAD_ADDED_2_MSG = \"" . MANAGE_HEAD_ADDED_2_MSG . "\";\n";
	echo "	var MANAGE_HEAD_ADDED_ERR = \"" . MANAGE_HEAD_ADDED_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var ERROR_WORD = \"" . ERROR_WORD . "\";\n";
	echo "	var CLICK_WORD = \"" . CLICK_WORD . "\";\n";
	echo "	var HERE_WORD = \"" . HERE_WORD . "\";\n";
	echo "	var ASSIGN_WORD = \"" . ASSIGN_WORD . "\";\n";
	echo "	var TO_WORD = \"" . TO_WORD . "\";\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeConsole();">
<table width="90%" align="center"><tr><td>
<div class="button_heading_sub_level_1" id="manage_users_site_options_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_HEAD_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<table width="90%" align="center" class="group_box_table"><tr><td>
<span class="sub_title"><?php echo MANAGE_HEAD_ADD_HEAD_CONTENT; ?></span>
<table width="100%" class="layout_box_table" align="center">
<tr>
<td align="center">
  head<input type="text" name="suffix" id="suffix" style="width:100px;" />
<br />
  <div class='button_console_add' id="add_head_btn" onClick="AddHead();"><span class='button_console_text_w_icon'><?php echo MANAGE_HEAD_ADD_HEAD_BTN; ?></span></div>
</td>
</tr>
</table>
</td></tr></table>
<br />

<table width="90%" align="center" class="group_box_table"><tr><td>
<div id="head_assignment_table">&nbsp;</div>
</td></tr></table>
<br />

	<table width="90%" align="center" class="group_box_table"><tr><td>
    
	<table width="100%" align="center" class="layout_box_table">
      <tr>
      	<td class="sub_title"><?php echo MANAGE_HEAD_RENAME_HEAD_CONTENT; ?></td>
      	<td class="sub_title"><?php echo MANAGE_HEAD_DELETE_HEAD_CONTENT; ?></td>
      </tr>
      <tr>
        <td>
      	  <table width="100%" align="center" class="layout_box_table">
      		<tr>
              <td align="right"><?php echo MANAGE_HEAD_SELECT_HEAD_CONTENT_TO_RENAME; ?>: </td>
              <td>
                <select name="head_old_name" id="head_old_name">
                </select>
              </td>
              <td align="right"><?php echo MANAGE_HEAD_NEW_NAME; ?>: </td>
              <td align="right" style="width:60px;">
              <div id="name_prefix_display">head_</div>
              <input type="hidden" name="name_prefix" id="name_prefix" value="head_" />
              </td>
              <td><input type="text" name="name_suffix" id="name_suffix" style="width:100px;" /></td>
              <td align="center">
              <div class='button_console_edit' id="rename_head_btn" onClick="RenameHead();"><span class='button_console_text_w_icon'><?php echo RENAME_WORD; ?></span></div>
              </td>
			</tr>
         </table>
      </td>
      
      <td>
      <table>
      <tr>
      
	  <td align="center"><?php echo MANAGE_HEAD_SELECT_HEAD_CONTENT_TO_DELETE; ?>: </td>
	  <td>
		<select name="head_name" id="head_name_delete">
		</select>
	  </td>
	  <td align="center">
      <div class='button_console_delete' id="delete_head_btn" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
	  </td>
      
      </tr>
      </table>
     </td>
     
	</tr></table>
    
    </td></tr></table>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>
</body>
</html>