<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/12/2009
// Modified: 1/6/2010	ELL
// Revised list to show descriptions as well as names.
// Added ability to update descriptions after the fact.
// Revised: 1/8/2011	ELL
// Added ability to assign either CSS or JavaScript menus.
// Revised: 4/7/2011	ELL
// Fixed bug of adding JavaScript menu code to header even though CSS menu type upon assigning menus.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/18/2013	ELL
// Added visual feedback for assigning menus.
// Revised: 3/23/2015	ELL
// Added creation of mobile menus with names having "_mobile" in them such that page template files can modally use or not use
// moble/desktop menus.
//
	
	include ("check_session.php");
	
	$menu_name_assigned = $_REQUEST['menu_name'];
	$border_area_assigned = $_REQUEST['border_area'];
	$menu_type_assigned = $_REQUEST['menu_type'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Menus | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#manage_menu_assignments_heading	{	width:290px;	}
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:245px;
	height:31px;
	width:31px;
	z-index:100;
}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/manage_menu.js"></script>

<script language="javascript" type="text/javascript" >
function UpdateDescription(menu_name)
{
	if (menu_name == "-not selected-")
		document.getElementById("new_description").value = "";
	else
	{
		var menu_name_arr = new Array();
		var menu_desc_arr = new Array();
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	$i = 0;
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		echo "		menu_name_arr[$i] = '$menu_name';\n";
		echo "		menu_desc_arr[$i] = '$description';\n";
		$i++;
	}
	echo "		var count = $i;\n";
?>
	
		for (i = 0; i < count; i++)
		{
			if (menu_name == menu_name_arr[i])
				document.getElementById("new_description").value = menu_desc_arr[i];
		}
	}
}

function UpdateType(menu_name)
{
	if (menu_name == "-not selected-")
	{
		document.getElementById("menu_type3").value = -1;
		document.getElementById("menu_type3").text = "-not selected-";
	}
	else
	{
		var menu_name_arr = new Array();
		var menu_type_arr = new Array();
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	$i = 0;
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$menu_type = $row['menu_type'];
		echo "		menu_name_arr[$i] = '$menu_name';\n";
		echo "		menu_type_arr[$i] = '$menu_type';\n";
		$i++;
	}
	echo "		var count = $i;\n";
?>
	
		var new_val;
		for (i = 0; i < count; i++)
		{
			if (menu_name == menu_name_arr[i])
			{
				if (menu_type_arr[i] == 0)
					new_val = 1
				else
					new_val = 0;
				document.getElementById("menu_type3").value = new_val;
				if (new_val == 0)
					document.getElementById("menu_type3").text = "CSS";
				else
					document.getElementById("menu_type3").text = "JavaScript";
			}
		}
	}
}

<?php
	echo "	var MANAGE_MENUS_REASSIGN_MENU_TO_COMPLETE_MSG = \"" . MANAGE_MENUS_REASSIGN_MENU_TO_COMPLETE_MSG . "\";\n";
	echo "	var MANAGE_MENUS_DELETE_MENU_CONFIRM_1_MSG = \"" . MANAGE_MENUS_DELETE_MENU_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_MENUS_DELETE_MENU_CONFIRM_2_MSG = \"" . MANAGE_MENUS_DELETE_MENU_CONFIRM_2_MSG . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var _NOT_ASSIGNED_ = \"" . _NOT_ASSIGNED_ . "\";\n";
?>
</script>

</head>

<body id="workspace_body">
<table width="90%" align="center"><tr><td>
<div class="button_heading_sub_level_1" id="manage_menu_assignments_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_MENUS_HEADING; ?></div><div class="help_button" id="help_button" onclick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<table width="90%" align="center" class="group_box_table"><tr>
  <td>
<span class="sub_title"><?php echo MANAGE_MENUS_ADD_MENU; ?></span>
<form name="frmAddMenu" id="frmAddMenu" method="post" action="add_menu.php">
<table width="100%" class="layout_box_table" align="center">
<tr>
<td align="center">
<?php echo MANAGE_MENUS_MENU_TYPE; ?>:
<select name="menu_type" id="menu_type">
  <option value="0">CSS</option>
  <option value="1">JavaScript</option>
</select>
</td>
<td align="center">
  <?php echo DESCRIPTION_WORD; ?>: 
  <input type="text" name="description" id="description" />
</td>
<td align="center"><img src="theme/<?php echo $theme; ?>/images/uploading.gif" alt="<?php echo UPLOAD_TEMPLATE_UPLOADING; ?>" id="uploading_gif" style="display:none;" /></td>
<td align="center">
  <div class='button_console_add' style="width:180px;" onClick="document.getElementById('uploading_gif').style.display='inline'; document.getElementById('frmAddMenu').submit();"><span class='button_console_text_w_icon'><?php echo MANAGE_MENUS_CREATE_NEW_MENU_BTN; ?></span></div>
</td>
</tr>
</table>
</form>
</td></tr></table>
<br />

<table width="90%" align="center" class="group_box_table"><tr><td>
<table width="100%" class="layout_box_table" align="center">
<tr bgcolor="#CCCCCC">
  <td colspan="3"><span class="sub_title"><?php echo MANAGE_MENUS_ASSIGN_MENU_TO_BORDER; ?></span></td></tr>
  <?php
  		$bgcolor = "#EEEEEE";
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special";
		$result = $bwb_dbh->query($query);
		$i = 1;
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_type = -1;
			$border_area = $row["page_name"];
			echo "<form name='frmAssign$i' id='frmAssign$i' method='post' action='assign_menu.php'>\n";
			echo "<tr bgcolor='$bgcolor'>\n";
			echo "<td>$border_area</td>";
			
			echo "<td>\n";
			echo "<select name=\"menu_name\" onChange=\"UpdateMenuType($i);\">\n";
			echo "<option value='" . _NOT_ASSIGNED_ . "'>-not assigned-</option>\n";
			$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE `menu_name` NOT LIKE '%_mobile'";
			$result2 = $bwb_dbh->query($query2);
			while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
			{
				$menu_name = $row2["menu_name"];
				$description = $row2['description'];
				$tmp_menu_type = $row2["menu_type"];
				if ($tmp_menu_type == 1)
					$type_str = "JavaScript";
				else
					$type_str = "CSS";
				
				$query3 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menu_assignments` WHERE menu_name = '$menu_name' AND border_area = '$border_area'";
				$result3 = $bwb_dbh->query($query3);
				if ($result3->rowCount() > 0)
				{
					echo "<option value='$menu_name' selected='selected'>$description ($menu_name) ($type_str)</option>\n";
					$menu_type = $tmp_menu_type;
				}
				else
					echo "<option value='$menu_name'>$description ($menu_name) ($type_str)</option>\n";
			}
			echo "</select>\n";
			echo "</td>\n";
			echo "<td>\n";
			
			echo "<div class='button_console_edit' style='width:110px;' onClick=\"document.getElementById('frmAssign$i').submit();\"><span class='button_console_text_w_icon'>" . ASSIGN_WORD . "</span></div>\n";
			
			echo "<input type='hidden' name='border_area' value='$border_area' />\n";
			echo "<input type='hidden' name='menu_type' value='$menu_type' />\n";
			echo "</td>\n";
			echo "</tr>\n";
			echo "</form>";
			$i++;
			if ($bgcolor == "#EEEEEE")
				$bgcolor = "#DDDDDD";
			else
				$bgcolor = "#EEEEEE";
		}
   ?>
</table>
</td></tr></table>
<br />

	<table width="90%" align="center" class="group_box_table"><tr>
	  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_DELETE_MENU; ?></span>
	<table width="100%" align="center" class="layout_box_table"><tr>
	  <td align="center"><?php echo MANAGE_MENUS_SELECT_MENU_TO_DELETE; ?>: </td>
	  <td>
		<select name="selectMenuDelete" id="selectMenuDelete">
	<?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE (menu_name != 'menu') AND (menu_name != 'menu1') AND (menu_name NOT LIKE '%_mobile') ORDER BY menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			if ($menu_name == $menu)
				echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
			else
				echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
		}
	?>
		</select>
	  </td>
	  <td align="center">
	  <?php if ($row_count > 0) { ?>
      <div class='button_console_delete' style="width:110px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
      <?php } ?>
	  </td>
	</tr></table>
    </td></tr></table>


<br />
	<table width="90%" align="center" class="group_box_table"><tr>
	  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_UPDATE_MENU_DESCRIPTION; ?></span>
    <form name="frmUpdateMenuDesc" id="frmUpdateMenuDesc" method="post" action="update_menu_description.php">
	<table width="100%" align="center" class="layout_box_table"><tr>
	  <td align="center"><?php echo MANAGE_MENUS_SELECT_MENU_TO_REVISE; ?>: </td>
	  <td>
		<select name="selectMenu2" onchange="UpdateDescription(this.value);">
        <option ><?php echo _NOT_SELECTED_; ?></option>
	<?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name NOT LIKE '%_mobile' ORDER BY menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			if ($menu_name == $menu)
				echo "<option value='$menu_name' selected='selected'>$description ($menu_name)</option>\n";
			else
				echo "<option value='$menu_name'>$description ($menu_name)</option>\n";
		}
	?>
		</select>
	  </td>
      <td><?php echo MANAGE_MENUS_NEW_DESCRIPTION; ?>: </td>
      <td><input type="text" name="new_description" id="new_description" /></td>
	  <td align="center">
      <div class='button_console_save' style="width:110px;" onClick="document.getElementById('frmUpdateMenuDesc').submit();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
	  </td>
	</tr></table>
    </form>
    </td></tr></table>
    
    <br />
	<table width="90%" align="center" class="group_box_table"><tr>
	  <td>
    <span class="sub_title"><?php echo MANAGE_MENUS_CHANGE_MENU_TYPE; ?></span>
    <form name="frmUpdateMenuType" method="post" action="update_menu_type.php">
	<table width="100%" align="center" class="layout_box_table"><tr>
	  <td align="center"><?php echo MANAGE_MENUS_SELECT_MENU_TO_REVISE; ?>: </td>
	  <td><select name="selectMenu3" onchange="UpdateType(this.value);">
	    <option ><?php echo _NOT_SELECTED_; ?></option>
	    <?php
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus ORDER BY menu_name";
		$result = $bwb_dbh->query($query);
		$row_count = $result->rowCount();
		while($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$menu_name = $row['menu_name'];
			$description = $row['description'];
			$menu_type = $row['menu_type'];
			if ($menu_type == 1)
				$type_str = "JavaScript";
			else
				$type_str = "CSS";
			echo "<option value='$menu_name'>$description ($menu_name) ($type_str)</option>\n";
		}
	?>
	    </select></td>
      <td>New Menu Type: </td>
      <td>
      <select name="menu_type3" id="menu_type3">
      <option value="-1"><?php echo _NOT_SELECTED_; ?></option>
	  <option value="0">CSS</option>
	  <option value="1">JavaScript</option>
	  </select>
      </td>
	  <td align="center">
      <div class='button_console_save' style="width:110px;" onClick="SubmitUpdateType();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
	  </td>
	</tr></table>
    </form>
    </td></tr></table>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
	
<?php
if (isset($menu_name_assigned) && isset($border_area_assigned) && isset($menu_type_assigned))
{
	if ($menu_type_assigned == 1)
		$menu_type_txt = "JavaScript";
	else
		$menu_type_txt = "CSS";
?>
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "<?php echo MANAGE_MENUS_MENU_ASSIGNED_1_MSG . " " . $menu_type_txt . " " . MANAGE_MENUS_MENU_ASSIGNED_2_MSG . " <b>" . $menu_name_assigned . "</b> " .MANAGE_MENUS_MENU_ASSIGNED_3_MSG . " <b>" . $border_area_assigned . "</b> " . MANAGE_MENUS_MENU_ASSIGNED_4_MSG; ?>";
	popup_msg.popup_timeout = 3000;
	popup_msg.ShowPopupMsg();
<?php	}	?>
</script>
</body>
</html>