<?php
/////////////////////////////////////////////
// Manage Page Access Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/28/2012	ELL
// Revised: 2/12/2013	ELL
// Added paging to user table.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 11/6/2014	ELL
// Overhauled individual user management areas at bottom as AJAX functions.
// Revised: 3/23/2016	ELL
// Added error checking when saving restirect page access.
// Added info links.
// 
// 
//
	include ("check_session.php");
	
	$last_user_table = $_SESSION['last_user_table'];
	$last_user = $_SESSION['last_user'];
	$last_access_level = $_SESSION['last_access_level'];
	
	$username_pass_change = $_REQUEST['user_name'];
	$password_pass_change = $_REQUEST['password'];
	$new_username = $_REQUEST['new_username'];
	$new_user_access_level = $_REQUEST['access_level'];
?>
<!DOCTYPE html>
<html>
<head>
<title>Manage Page Access | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#manage_restricted_pages_users_heading	{	width:400px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:350px;
	height:31px;
	width:31px;
	z-index:100;
}
#add_fields_to_table_btn	{
	width:230px;
	height:60px;
}
#assign_message_page_to_user_table_btn	{
	width:230px;
	height:60px;
}
#add_access_level_btn	{	width:110px;	}
#remove_access_level_btn	{	width:110px;	}
#generate_password_btn	{	width:170px;	}
#add_user_btn	{	width:110px;	}
#generate_password_btn2	{	width:170px;	}
#change_password_btn	{	width:180px;	}
#delete_user_btn	{	width:110px;	}
#edit_user_btn		{	width:110px;	}
.missing _fields	{	color:#F00;	}
.info_btn	{
	display:inline-block;
	margin-left:30px;
}
</style>

<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/ajax.js"></script>
<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/manage_page_access.js"></script>

<script language="javascript" type="text/javascript">
<?php
	echo "	var theme = '$theme';\n\n";
	
	echo "	var MANAGE_PAGE_ACCESS_RESTRICT_PAGE_ACCESS = \"" . MANAGE_PAGE_ACCESS_RESTRICT_PAGE_ACCESS . "\";\n";
	echo "	var PAGE_1ST_CAP_WORD = \"" . PAGE_1ST_CAP_WORD . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_REQUIRE_LOGIN = \"" . MANAGE_PAGE_ACCESS_REQUIRE_LOGIN . "\";\n";
	echo "	var USER_TABLE_WORD = \"" . USER_TABLE_WORD . "\";\n";
	echo "	var ACCESS_LEVEL_WORD = \"" . ACCESS_LEVEL_WORD . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_LOGIN_PAGE = \"" . MANAGE_PAGE_ACCESS_LOGIN_PAGE . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_SHOW_LOGIN_LINKS_ALWAYS = \"" . MANAGE_PAGE_ACCESS_SHOW_LOGIN_LINKS_ALWAYS . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_1_MSG = \"" . MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_2_MSG = \"" . MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_DELETED_1_MSG = \"" . MANAGE_PAGE_ACCESS_USER_DELETED_1_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_DELETED_2_MSG = \"" . MANAGE_PAGE_ACCESS_USER_DELETED_2_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_DELETE_ACCESS_LEVEL_CONFIRM_1_MSG = \"" . MANAGE_PAGE_ACCESS_DELETE_ACCESS_LEVEL_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_DELETE_ACCESS_LEVEL_CONFIRM_2_MSG = \"" . MANAGE_PAGE_ACCESS_DELETE_ACCESS_LEVEL_CONFIRM_2_MSG . "\";\n";
	echo "	var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
	echo "	var QUERY_SENT = \"" . QUERY_SENT . "\";\n";
	echo "	var QUERY_COMPLETE = \"" . QUERY_COMPLETE . "\";\n";
	echo "	var QUERY_COMPLETE_NO_RECORD_FOUND = \"" . QUERY_COMPLETE_NO_RECORD_FOUND . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_LOCATING_PAGE_RESTRICTIONS_MSG = \"" . MANAGE_PAGE_ACCESS_LOCATING_PAGE_RESTRICTIONS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_PAGE_RESTRICTIONS_MSG = \"" . MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_PAGE_RESTRICTIONS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_PAGE_RESTRICTIONS_UPDATED_MSG = \"" . MANAGE_PAGE_ACCESS_PAGE_RESTRICTIONS_UPDATED_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_UPDATING_PAGE_RESTRICTIONS_MSG = \"" . MANAGE_PAGE_ACCESS_UPDATING_PAGE_RESTRICTIONS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_USER_STATUS_MSG = \"" . MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_USER_STATUS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_STATUS_UPDATED_MSG = \"" . MANAGE_PAGE_ACCESS_USER_STATUS_UPDATED_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_UPDATING_USER_STATUS_MSG = \"" . MANAGE_PAGE_ACCESS_UPDATING_USER_STATUS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_COULD_NOT_MODIFY_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_COULD_NOT_MODIFY_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_FIELDS_ADDED_TO_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_FIELDS_ADDED_TO_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_ADDING_FIELDS_TO_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_ADDING_FIELDS_TO_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_WELCOME_MESSAGE_PAGE_ADDED_TO_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_WELCOME_MESSAGE_PAGE_ADDED_TO_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_ADDING_WELCOME_MESSAGE_PAGE_TO_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_ADDING_WELCOME_MESSAGE_PAGE_TO_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_COULD_NOT_ADD_DELETE_ACCESS_LEVEL_MSG = \"" . MANAGE_PAGE_ACCESS_COULD_NOT_ADD_DELETE_ACCESS_LEVEL_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_ACESS_LEVEL_RECORDS_MODIFIED_MSG = \"" . MANAGE_PAGE_ACCESS_ACESS_LEVEL_RECORDS_MODIFIED_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_CHANGING_ACCESS_LEVELS_MSG = \"" . MANAGE_PAGE_ACCESS_CHANGING_ACCESS_LEVELS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_LOCATING_ACCESS_LEVELS_MSG = \"" . MANAGE_PAGE_ACCESS_LOCATING_ACCESS_LEVELS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_LOCATING_USERS_MSG = \"" . MANAGE_PAGE_ACCESS_LOCATING_USERS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_REQUIRED_FIELDS_MSG = \"" . MANAGE_PAGE_ACCESS_REQUIRED_FIELDS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_RETRIEVING_PAGE_RESTRICTIONS_MSG = \"" . MANAGE_PAGE_ACCESS_RETRIEVING_PAGE_RESTRICTIONS_MSG . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_RETRIEVING_ACCESS_LEVELS_MSG = \"" . MANAGE_PAGE_ACCESS_RETRIEVING_ACCESS_LEVELS_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_RETRIEVING_USERS_MSG = \"" . MANAGE_PAGE_ACCESS_RETRIEVING_USERS_MSG . "\";\n";
	echo "	var USER_WORD = \"" . USER_WORD . "\";\n";
	echo "	var ACTIVE_WORD = \"" . ACTIVE_WORD . "\";\n";
	echo "	var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_ADDING_LOGIN_FIELDS_TO_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_ADDING_LOGIN_FIELDS_TO_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_ASSIGNING_WELCOME_MESSAGE_PAGE_TO_TABLE_MSG = \"" . MANAGE_PAGE_ACCESS_ASSIGNING_WELCOME_MESSAGE_PAGE_TO_TABLE_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_ADDING_ACCESS_LEVEL_MSG = \"" . MANAGE_PAGE_ACCESS_ADDING_ACCESS_LEVEL_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_REMOVING_ACCESS_LEVEL_MSG = \"" . MANAGE_PAGE_ACCESS_REMOVING_ACCESS_LEVEL_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NEW_USER_NOT_ADDED_ERR = \"" . MANAGE_PAGE_ACCESS_NEW_USER_NOT_ADDED_ERR . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NEW_USER_CREATED_1_MSG = \"" . MANAGE_PAGE_ACCESS_NEW_USER_CREATED_1_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NEW_USER_CREATED_2_MSG = \"" . MANAGE_PAGE_ACCESS_NEW_USER_CREATED_2_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NEW_USER_CREATED_3_MSG = \"" . MANAGE_PAGE_ACCESS_NEW_USER_CREATED_3_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NEW_USER_CREATED_4_MSG = \"" . MANAGE_PAGE_ACCESS_NEW_USER_CREATED_4_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NEW_USER_CREATED_5_MSG = \"" . MANAGE_PAGE_ACCESS_NEW_USER_CREATED_5_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_PASSWORD_CHANGED_1_MSG = \"" . MANAGE_PAGE_ACCESS_PASSWORD_CHANGED_1_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_PASSWORD_CHANGED_2_MSG = \"" . MANAGE_PAGE_ACCESS_PASSWORD_CHANGED_2_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_CHANGED_1_MSG = \"" . MANAGE_PAGE_ACCESS_USER_CHANGED_1_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_CHANGED_2_MSG = \"" . MANAGE_PAGE_ACCESS_USER_CHANGED_2_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_CHANGED_3_MSG = \"" . MANAGE_PAGE_ACCESS_USER_CHANGED_3_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_USER_CHANGED_4_MSG = \"" . MANAGE_PAGE_ACCESS_USER_CHANGED_4_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NO_DATA_FOUND_FOR_USER_ERR = \"" . MANAGE_PAGE_ACCESS_NO_DATA_FOUND_FOR_USER_ERR . "\";\n";
	echo "	var TOP_1ST_CAP_WORD = \"" . TOP_1ST_CAP_WORD . "\";\n";
	echo "	var HEADER_1ST_CAP_WORD = \"" . HEADER_1ST_CAP_WORD . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NO_TABLE_SELECTED_ERR = \"" . MANAGE_PAGE_ACCESS_NO_TABLE_SELECTED_ERR . "\";\n";
	echo "	var MANAGE_PAGE_ACCESS_NO_LOGIN_PAGE_SELECTED_ERR = \"" . MANAGE_PAGE_ACCESS_NO_LOGIN_PAGE_SELECTED_ERR . "\";\n";
?>

var pages = new Array();
var tables = new Array();
var access_levels = new Array();
var login_pages = new Array();
var bgclr = "#eeeeee";
var update_page_table_mode = 0;
<?php echo "var last_user_table = '$last_user_table';\n"; ?>
<?php echo "var last_user = '$last_user';\n"; ?>
<?php echo "var last_access_level = '$last_access_level';\n"; ?>
var access_level_add = "-not set-";
var access_level_remove = "-not set-";

<?php
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$page_name = $row["page_name"];
		echo "pages[$j] = '$page_name';\n";
	}
	echo "var page_cnt = $j;\n\n";
	
	$query = "SHOW TABLES";
	$result = $bwb_dbh->query($query);
	$tmp_table = "";
	$j = 0;
	$tables = array();
	$rows = $result->fetchAll(PDO::FETCH_NUM);
	foreach ($rows as $row)
	{
	
		$tmp_table = $row[0];
		if ((substr($tmp_table, 0, strlen(BWB_TABLE_PREFIX)) != BWB_TABLE_PREFIX) || (BWB_TABLE_PREFIX == ""))
		{
			// Got table that does not have Breeze prefix. Now check for existence of password field.
			$query = "SHOW COLUMNS FROM " . $tmp_table;
			$result2 = $bwb_dbh->query($query);
			$got_user_table = 0;
			while ($row2 = $result2->fetch(PDO::FETCH_ASSOC))
			{
				if ($row2['Field'] == "password")
					$got_user_table++;
				if ($row2['Field'] == "UserID")
					$got_user_table++;
				if ($row2['Field'] == "email")
					$got_user_table++;
				if ($row2['Field'] == "AccessLevel")
					$got_user_table++;
				if ($row2['Field'] == "Active")
					$got_user_table++;
				if ($row2['Field'] == "Session")
					$got_user_table++;
				if ($row2['Field'] == "IP")
					$got_user_table++;
				if ($row2['Field'] == "welcome_message_page")
					$got_user_table++;
				if ($row2['Field'] == "first_name")
					$got_user_table++;
				if ($row2['Field'] == "last_name")
					$got_user_table++;
			}
			if ($got_user_table > 1)
			{
				echo "tables[$j] = new Array(2);\n";
				echo "tables[$j][0] = '" . $tmp_table . "';\n";
				echo "tables[$j][1] = " . $got_user_table . ";\n";
				$tables[$j] = array($tmp_table, $got_user_table);
				$j++;
			}
		}
	}
	echo "var table_cnt = $j;\n\n";
	$table_cnt = $j;
	
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "access_levels";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$access_level = $row["access_level"];
		echo "access_levels[$j] = '$access_level';\n";
	}
	echo "var access_level_cnt = $j;\n\n";
	
	
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name LIKE '%login%'";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$login_page = $row["page_name"];
		echo "login_pages[$j] = '$login_page';\n";
	}
	echo "var login_page_cnt = $j;\n\n";
?>

</script>

</head>

<body id="workspace_body">
<br>
<div align="center">
<table width="95%" border="0"><tr>
<td>
<div class="button_heading_sub_level_1" id="manage_restricted_pages_users_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_PAGE_ACCESS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow('manage_page_access');">&nbsp;</div></div>
</td>
</tr></table>

<table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
  <div id="PageRestrictionsTable">
	&nbsp;
  </div>
  <input type="hidden" name="nCount" id="nCount" />
  </td></tr></table>
  <br />
  
<table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
<table width="100%" border="0" class="layout_box_table">
  <tr>
    <td class="sub_title"><?php echo MANAGE_PAGE_ACCESS_APPROVE_ACCESSTO_USERS; ?></td>
     <td align="right" class='header_row'><b><?php echo TABLE_WORD; ?>:</b>&nbsp;</td>
    <td>
    <select name="user_table_for_users_table" id="user_table_for_users_table" onChange="RetrieveUserLists(this.value, true);">
    	<option><?php echo _NOT_SELECTED_; ?></option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i][0] == $last_user_table)
			echo "<option value='" . $tables[$i][0] . "' selected='selected'>" . $tables[$i][0] . "</option>";
		else
			echo "<option value='" . $tables[$i][0] . "'>" . $tables[$i][0] . "</option>";
	}
?>
    </select>
    </td>
  </tr>
  
  <tr>
    <td colspan="3">  
     <table border="0" width="95%" align="center">
      <tr id="user_nav_row_top">
        <td width="25%" align="center">
         <img src="./theme/<?php echo $theme; ?>/images/First.gif" id="first_top" border="0" onClick="moveFirst();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./theme/<?php echo $theme; ?>/images/Previous.gif" id="prev_top" border="0" onClick="movePrev();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./theme/<?php echo $theme; ?>/images/Next.gif" id="next_top" border="0" onClick="moveNext();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./theme/<?php echo $theme; ?>/images/Last.gif" id="last_top" border="0" onClick="moveLast();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
      </tr>
    </table>
    </td>
  </tr>
  
  <tr>
  	<td colspan="3"><div id="UsersTable">&nbsp;</div></td>
  </tr>
  
  <tr>
    <td colspan="3">  
     <table border="0" width="95%" align="center">
      <tr id="user_nav_row_bot">
        <td width="25%" align="center">
         <img src="./theme/<?php echo $theme; ?>/images/First.gif" id="first_bot" border="0" onClick="moveFirst();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./theme/<?php echo $theme; ?>/images/Previous.gif" id="prev_bot" border="0" onClick="movePrev();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./theme/<?php echo $theme; ?>/images/Next.gif" id="next_bot" border="0" onClick="moveNext();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./theme/<?php echo $theme; ?>/images/Last.gif" id="last_bot" border="0" onClick="moveLast();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
      </tr>
    </table>
    </td>
  </tr>
  
</table>
</td></tr></table>
  <br />
  
<table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title"><?php echo MANAGE_PAGE_ACCESS_USER_TABLE_SETUP; ?></td>
  </tr>
  <tr>
    <td align="right"><?php echo TABLE_WORD; ?>:&nbsp;</td>
    <td>
    <select name="user_table_for_fields" id="user_table_for_fields" onChange="RetrieveUserLists(this.value);">
      <option><?php echo _NOT_SELECTED_; ?></option>
      <?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i][0] == $last_user_table)
			echo "<option value='" . $tables[$i][0] . "' selected='selected'>" . $tables[$i][0] . "</option>";
		else
			echo "<option value='" . $tables[$i][0] . "'>" . $tables[$i][0] . "</option>";
	}
?>
    </select>
    </td>
    <td>
    <div class='button_console_add' id="add_fields_to_table_btn" onClick="AddFieldsToTable();"><span class='button_console_text_w_icon'><?php echo MANAGE_PAGE_ACCESS_ADD_LOGIN_FIELDS_BTN; ?></span></div>
    </td>
    <td align="right"> <?php echo MANAGE_PAGE_ACCESS_MESSAGE_PAGE; ?>: </td>
     <td>
    <select name="welcome_message_page" id="welcome_message_page">
      <option><?php echo _NOT_SELECTED_; ?></option>
<?php
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name LIKE '%message%' ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row["page_name"];
		echo "<option value='" . $page_name . "'>" . $page_name . "</option>";
	}
?>
    </select>
    </td>
    <td>
    <div class='button_console_edit' id="assign_message_page_to_user_table_btn" onClick="AssignWelcomeMessagePageToTable();"><span class='button_console_text_w_icon'><?php echo MANAGE_PAGE_ACCESS_ASSIGN_WELCOME_MESSAGE_PAGE_BTN; ?></span></div>
    </td>
  </tr>
  </table>
  </td></tr></table>
  <br />
  
  <table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title"><?php echo ACCESS_LEVELS; ?></td>
  </tr>
  <tr>
    <td align="right">
    <input type="text" name="access_level_add" id="access_level_add" />&nbsp;
    </td>
    <td>
    <div class='button_console_add' id="add_access_level_btn" onClick="AddRemoveAccessLevel('add');"><span class='button_console_text_w_icon'><?php echo ADD_WORD; ?></span></div>
    </td>
    <td align="right">
    <div id="AccessLevelRemoveDiv">
    <select name="access_level_remove" id="access_level_remove">
    <option><?php echo _NOT_SELECTED_; ?></option>
	<option value="blogger"><?php echo BLOGGER_WORD; ?></option>
	<option value="restricted"><?php echo RESTRICTED_WORD; ?></option>
    <option value="user"><?php echo USER_WORD; ?></option>
    <option value="power_user" selected><?php echo POWER_USER_WORD; ?></option>
    <option value="admin"><?php echo ADMIN_WORD; ?></option>
    </select>
    </div>
    </td>
    <td>
    <div class='button_console_delete' id="remove_access_level_btn" onClick="DeleteAccessLevelConfirm();"><span class='button_console_text_w_icon'><?php echo REMOVE_WORD; ?></span></div>
    </td>
  </tr>
  </table>
  </td></tr></table>
  <br />
  <hr style="width:95%;" />
  <p class="extra_small_message"><?php echo MANAGE_PAGE_ACCESS_ADDITIONAL_FORMS_NOTE; ?></p>
  
  <table width="95%" class="group_box_table"><tr><td>
<form name="formAddUser" id="formAddUser" method="post" action="add_user.php">
<table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="9" class="sub_title"><?php echo ADD_USER; ?></td>
  </tr>
  <tr>
    <td align="right"><?php echo USERNAME_WORD; ?>: </td>
    <td><input type="text" name="user_name" id="user_name_new_user"></td>
    <td align="right" width="150"><?php echo PASSWORD_WORD; ?>: </td>
    <td> <input type="text" name="password" id="password_new_user"></td>
    <td>
    	 <div class='button_console_generate_password' id="generate_password_btn" onClick="GeneratePassword('new');"><span class='button_console_text_w_icon'><?php echo GENERATE_PASSWORD; ?></span></div>
    </td>
    <td align="right"><?php echo ACCESS_LEVEL_WORD; ?>: </td>
    <td>
    <div id="AccessLevelAddUserDiv">
    <select name="selectAccessLevel" id="selectAccessLevelNewUser">
    <option value="blogger"><?php echo BLOGGER_WORD; ?></option>
	<option value="restricted"><?php echo RESTRICTED_WORD; ?></option>
    <option value="user"><?php echo USER_WORD; ?></option>
    <option value="power_user" selected><?php echo POWER_USER_WORD; ?></option>
    <option value="admin"><?php echo ADMIN_WORD; ?></option>
    </select>
    </div>
    </td>
    <td align="right"><?php echo TABLE_WORD; ?>: </td>
    <td>
    <select name="table" id="table_new_user" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i][0] == $last_user_table)
			echo "<option value='" . $tables[$i][0] . "' selected='selected'>" . $tables[$i][0] . "</option>";
		else
			echo "<option value='" . $tables[$i][0] . "'>" . $tables[$i][0] . "</option>";
	}
?>
    </select>
    </td>
  </tr>
  <tr>
  	<td colspan="9" align="center">
    <table width="90%"><tr>
    <td align="right"><?php echo EMAIL_WORD; ?>:</td>
    <td><input type="text" name="email" id="email_new_user" /></td>
	<td align="right"><?php echo NAME_WORD; ?> <span class="small_message"><?php echo MANAGE_PAGE_ACCESS_FIRST_LAST; ?></span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_new_user" />
    	<input type="text" name="last_name" id="last_name_new_user" />
        <span class="small_message"><?php echo MANAGE_PAGE_ACCESS_OPTIONAL; ?></span>
    </td>
    </tr></table>
    </td>
  </tr>
  <tr>
    <td colspan="9" align="center">
    <div class='button_console_add' id="add_user_btn" onClick="AddUser();"><span class='button_console_text_w_icon'><?php echo ADD_WORD; ?></span></div>
    </td>
  </tr>
  </table>
  <input type="hidden" name="no_prefix" id="no_prefix" value="1" />
  </form>
  </td></tr></table>
  <br />
 
  <table width="95%" class="group_box_table"><tr><td>
  <form name="formChangePassword" id="formChangePassword" method="post" action="change_password.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="7" class="sub_title"><?php echo CHANGE_PASSWORD; ?></td>
  </tr>
  <tr>
  	<td align="right"><?php echo TABLE_WORD; ?>: </td>
    <td>
    <select name="table" id="table_existing_user" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i][0] == $last_user_table)
			echo "<option value='" . $tables[$i][0] . "' selected='selected'>" . $tables[$i][0] . "</option>";
		else
			echo "<option value='" . $tables[$i][0] . "'>" . $tables[$i][0] . "</option>";
	}
?>
    </select>
    </td>
    <td align="right"><?php echo USERNAME_WORD; ?>: </td>
    <td>
    <div id="UsersChangePassword">
    <select name="selectUserName" id="selectUserNameExistingUser">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
    </select>
    </div>
    </td>
    <td align="right"><?php echo NEW_PASSWORD; ?>: </td>
    <td width="150">
    	<input type="text" name="password" id="password_existing_user">
    </td>
    <td>
        <div class='button_console_generate_password' id="generate_password_btn2" onClick="GeneratePassword('existing');"><span class='button_console_text_w_icon'><?php echo GENERATE_PASSWORD; ?></span></div>
	</td>
  </tr>
  <tr><td colspan="7">&nbsp;</td></tr>
  <tr>
    <td colspan="7" align="center">
    <div class='button_console_edit' id="change_password_btn" onClick="ChangePassword();"><span class='button_console_text_w_icon'><?php echo CHANGE_PASSWORD; ?></span></div>
    </td>
  </tr>
  </table>
  <input type="hidden" name="no_prefix" id="no_prefix" value="1" />
  </form>
  </td></tr></table>
  
  <br>
  <table width="95%" class="group_box_table"><tr><td>
	<form name="formModifyUser" id="formModifyUser" method="post" action="modify_user.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title"><?php echo MODIFY_USER; ?></td>
  </tr>
  <tr>
    <td align="right"><?php echo TABLE_WORD; ?>: </td>
    <td>
    <select name="table" id="table_edit" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i][0] == $last_user_table)
			echo "<option value='" . $tables[$i][0] . "' selected='selected'>" . $tables[$i][0] . "</option>";
		else
			echo "<option value='" . $tables[$i][0] . "'>" . $tables[$i][0] . "</option>";
	}
?>
    </select>
    </td>
    <td align="right"><?php echo USERNAME_WORD; ?>: </td>
    <td>
    <div id="UsersEdit">
    <select name="selectUserName" id="selectUserNameEdit" onChange="GetUser(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
    </select>
    </div>
    </td>
    <td align="right"><?php echo ACCESS_LEVEL_WORD; ?>: </td>
    <td>
    <div id="AccessLevelEditUserDiv">
    <select name="selectAccessLevel" id="selectAccessLevelEdit">
    <option value="blogger"><?php echo BLOGGER_WORD; ?></option>
	<option value="restricted"><?php echo RESTRICTED_WORD; ?></option>
    <option value="user"><?php echo USER_WORD; ?></option>
    <option value="power_user" selected><?php echo POWER_USER_WORD; ?></option>
    <option value="admin"><?php echo ADMIN_WORD; ?></option>
    </select>
    </td>
  </tr>
  <tr>
    <td align="right" colspan="3"><?php echo EMAIL_WORD; ?>:</td>
    <td><input type="text" name="email" id="email_edit" /></td>
	<td align="right"><?php echo NAME_WORD; ?> <span class="small_message"><?php echo MANAGE_PAGE_ACCESS_FIRST_LAST; ?></span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_edit" />
        <input type="text" name="last_name" id="last_name_edit" />
    </td>
  </tr>
  <tr><td colspan="6">&nbsp;</td></tr>
  <tr>
    <td colspan="6" align="center">
    <div class='button_console_edit' id="edit_user_btn" onClick="ModifyUser();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
    </td>
  </tr>
</table>
<input type="hidden" name="no_prefix" id="no_prefix" value="1" />
</form>
  </td></tr></table>
  <br>

  <table width="95%" class="group_box_table"><tr><td>

  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title"><?php echo DELETE_USER; ?></td>
  </tr>
  <tr>
  	<td align="right"><?php echo TABLE_WORD; ?>: </td>
    <td>
    <select name="table" id="table_delete_user" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i][0] == $last_user_table)
			echo "<option value='" . $tables[$i][0] . "' selected='selected'>" . $tables[$i][0] . "</option>";
		else
			echo "<option value='" . $tables[$i][0] . "'>" . $tables[$i][0] . "</option>";
	}
?>
    </select>
    </td>
    <td align="right"><?php echo USERNAME_WORD; ?>: </td>
    <td>
    <div id="UsersDelete">
      <select name="selectUserName" id="selectUserNameDelete">
        <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
      </select>
    </div>
    </td>
  </tr>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="center">
    <div class='button_console_delete' id="delete_user_btn" onClick="DeleteUserConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
    </td>
  </tr>
</table>

  </td></tr></table>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language='javascript' type='text/javascript'>
   RetrievePages();
   RetrieveAccessLevels(0);
   if (document.getElementById("user_table_for_fields").value != "")
	last_user_table = document.getElementById("user_table_for_fields").value;
   if (last_user_table != "")
   	RetrieveUserLists(last_user_table);
   else
   	ShowHidePageBtns();
	
	HidePopupMsg();
</script>
</body>
</html>
