<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 11/13/2008	ELL
// Added data type handling for text boxes as well as drop downs.
// Revised: 5/28/2009	ELL
// Added sorting of templates.	
// Revised:  6/17/2009	ELL
// Added third type 2 for checkboxes.  This will first be used for option to force page names to lower case.
// Revised: 8/21/2009	ELL
// Fixed bug with images showing up on line after they are supposed to show up.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
// Revised: 1/17/2015	ELL
// Overhauled to separate dropdown order from opton order and to get these sorts to work.
// Revised:	1/23/2015	ELL
// Modified to refresh main menu only if bit is set to do so in options table for option that was changed.
// Revised: 2/3/2015	ELL
// Converted list selection with images from post and re-write page to selecting image from JS multi-dim array.
// Converted save operation to work as AJAX form post using JQuery.
//
	include ("check_session.php");
	
?>
<!DOCTYPE html>
<html>
<head>
<title>Change Site Options | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#save_options_btn	{	width:110px;	}
</style>

<script type="text/javascript" src="js/jquery.min.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/options.js"></script>
<script>
<?php
	echo "	var MANAGE_SITE_OPTIONS_OPTIONS_SAVED_MSG = \"" . MANAGE_SITE_OPTIONS_OPTIONS_SAVED_MSG . "\";\n";
	echo "	var MANAGE_SITE_OPTIONS_ERROR_SAVING_OPTIONS_ERR = \"" . MANAGE_SITE_OPTIONS_ERROR_SAVING_OPTIONS_ERR . "\";\n";
?>

	var option_image = 
	{
<?php
	//First, create image style list for images in dropdown.
	$option_image = array();
	$last_opt_name = "-not set-";
	$first_el = true;
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_image` IS NOT NULL ORDER BY `option_name`, `dropdown_sort_order`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{	
		//Get record from options table with all possible options.
		$option_name = $row["option_name"];
		$option_value = $row["option_value"];
		$opt_image = $row["option_image"];
		$option_image[$option_name][$option_value] = $opt_image;

		if ($last_opt_name != $option_name)
		{
			if (!$first_el)
				echo "},\n";
			echo "	'$option_name':{'$option_value':'$opt_image'";
		}
		else
			echo ",'$option_value':'$opt_image'";
			
		$last_opt_name = $option_name;
		$first_el = false;
	}
	echo "}\n";
?>
	};
</script>
</head>

<body>
<br>
<form name="frmChangeOptions" id="frmChangeOptions" method="post" action="save_options.php">
<div align="center">

	<table width="80%" border="0"><tr><td>
	<div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_SITE_OPTIONS_HEADING; ?></div><div class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
    </td></tr></table>
    
	<table width="80%" class="layout_box_table">
	<tr bgcolor='#CCCCCC'><td class="sub_title"><?php echo OPTION_WORD; ?></td><td class="sub_title"><?php echo VALUE_WORD; ?></td><td>&nbsp;</td></tr>
<?php
	
	//First, create image style list for images in dropdown.
	$option_image = array();
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_image` IS NOT NULL ORDER BY `dropdown_sort_order`, `option_name`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{	
		//Get record from options table with all possible options.
		$option_name = $row["option_name"];
		$option_value = $row["option_value"];
		$option_image[$option_name][$option_value] = $row["option_image"];
	}
	
	//Open options table and get names, strings and all possible values for each option.
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` ORDER BY `sort_order`, `dropdown_sort_order`, `option_name`";
	$last_option_name = "not_set";
	$last_selected_option_value = "not_set";
	$last_data_type = "not_set";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{	
		//Get record from options table with all possible options.
		$option_name = $row["option_name"];
		$option_string = $row["option_string"];
		$option_string_define = $row["option_string_define"];
		$option_value = $row["option_value"];
		$data_type = $row["data_type"];
		if (($option_name == "RunWizardLocal") && (!file_exists("../wizard")))
			continue;
			
		if (isset($option_string_define) && ($option_string_define != ""))
		{
			if (defined($option_string_define) && (constant($option_string_define) != ""))
				$option_string = constant($option_string_define);
		}
		
		//If this is the 1st time to see this option, write table row and put option string in first cell and dropdown list in 2nd.
		if ($option_name != $last_option_name)
		{
			//If this is the last possible option value for this option, then close drop-down list and finish row.
			if ($last_option_name != "not_set")
			{
				if ($last_data_type == 0)
					echo "   </select>\n";
				if (isset($option_image[$last_option_name][$last_selected_option_value]))
					echo "<td><img src='images/" . $option_image[$last_option_name][$last_selected_option_value] . "' id='" . $last_option_name . "'></td></tr>\n";
				else
					echo "<td>&nbsp;</td></tr>\n";
			}
					
			if ($bgclr == "#DDDDDD")
				$bgclr = "#EEEEEE";
			else
				$bgclr = "#DDDDDD";
			//After finishing last row start new row.
			echo "<tr bgcolor='$bgclr'><td>\n";
			echo "   $option_string:\n";
			echo "</td><td>\n";
			if ($data_type == 0)
				echo "   <select name='$option_name' onChange=\"return dropdown(this)\">\n";
		}
		
		//Find selected option value from options selected table.
		$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = '$option_name'";
		$result2 = $bwb_dbh->query($query2);
		if ($result2->rowCount() > 0)	{
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			$option_value_selected = $row2["option_value"];
		}
		else
			$option_value_selected = "-not set-";
		
		if ($data_type == 1)
		{
			if ($option_value_selected != "-not set-")
				echo "   <input name='$option_name' type='text' value='$option_value_selected' />\n";
			else
				echo "   <input name='$option_name' type='text' value='$option_value' />\n";
		}
		elseif ($data_type == 2)
		{
			if ($option_value_selected == 1)
				echo "   <input name='$option_name' type='checkbox' value='1' checked='checked' />\n";
			elseif ($option_value_selected != "-not set-")
				echo "   <input name='$option_name' type='checkbox' value='1' />\n";
			elseif ($option_value == 1)
				echo "   <input name='$option_name' type='checkbox' value='1' checked='checked' />\n";
			else
				echo "   <input name='$option_name' type='checkbox' value='1' />\n";
		}
		elseif ($data_type == 0)
		{
			// Compare selected option to option from possible options in table.
			//Add option value. If option value is the same as option value selected, the set as selected.
			if ($option_value == $option_value_selected)	{
				echo "      <option value='$option_value' selected>$option_value</option>\n";
				$last_selected_option_value = $option_value_selected;
			}
			else
				echo "      <option value='$option_value'>$option_value</option>\n";
		}	//data type
		
		$last_option_name = $option_name;
		$last_data_type = $data_type;
    }
	
	if (isset($option_image[$last_option_name][$last_selected_option_value]))
		echo "<td><img src='images/" . $option_image[$last_option_name][$last_selected_option_value] . "'></td></tr>\n";
	else
		echo "<td>&nbsp;</td></tr>\n";
?>
	<tr><td colspan="3">&nbsp;</td></tr>
	<tr><td align="center" colspan="3">
        <div class='button_console_save' id="save_options_btn" onClick="SaveOptions();"><span class='button_console_text_w_icon'><?php echo SUBMIT_WORD; ?></span></div>
  	</td>
	</tr>
  </table>
</div>
</form>

<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
	HidePopupMsg();
</script>

</body>
</html>
