<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/4/2016	ELL
//
	
	include ("check_session.php");
	
	$query = "SELECT `language_folder` FROM " . BWB_TABLE_PREFIX . "plugins WHERE `name` = 'Lightbox Photo Gallery'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$language_folder = $row['language_folder'];
	
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (defined("BWB_LANG"))
		include_once ($document_root . "/" . $language_folder . "/" . BWB_LANG . ".php");
	else
		include_once ($document_root . "/" . $language_folder . "/en.php");
		
	$query = "SELECT * FROM gallery_params";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$thumb_width = $row['thumb_width'];
	$thumb_height = $row['thumb_height'];
	$full_width = $row['full_width'];
	$full_height = $row['full_height'];
	$preserve_thumb_aspect = $row['preserve_thumb_aspect'];
	$show_titles = $row['show_titles'];
	$disable_sort = $row['disable_sort'];
	
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Gallery Settings | Breeze Website Builder</title>

<link rel="stylesheet" href="../theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style>
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:275px;
	height:31px;
	width:31px;
	z-index:100;
}

.dim_input	{	width: 60px;	}

.dimensions_table	{
	width: 40%;
    border: 1px solid black;
    margin-top: 50px;
    padding: 10px;
}

.upload_table	{
	width: 30%;
   border: 1px solid black;
    margin-top: 50px;
    padding: 10px;
}

.image_table	{
	min-width: 700px;
    border: none;
    margin-top: 50px;
}

#manage_gallery_params_heading	{	width: 315px;	}

.image_title	{	width: 200px;	}
.sort	{	width: 50px;	}

#uploading_div	{
	width:100%;
    text-align:center;
    margin-top:20px;
    margin-bottom:-40px;
    visibility:hidden;
}

#blowup_div	{
	border: thin #000 solid;
}

#update_sort_btn	{
	width:165px;
    margin-top:10px;
    margin-bottom:10px;
}
</style>

<script src="../js/ajax.js"> </script>
<script src="../js/mouse_position.js"></script>
<script src="../js/popup_msg.js"> </script>
<script src="../js/jquery.min.js"> </script>
<script src="js/manage_gallery.js"> </script>

<script>
	var update_all = false;
    
<?php
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
	$orig_image_path_rel = $userfiles . "/" . BWB_IMAGE_DIR . "/gallery/orig/";
	echo "	var orig_image_path_rel = \"" . $orig_image_path_rel . "\";\n";
	echo "	var theme = \"" . $theme . "\";\n\n";
	
	echo "	var MANAGE_GALLERY_UPDATE_SUCCESS_MSG = \"" . MANAGE_GALLERY_UPDATE_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_UPDATE_FAIL_ERR = \"" . MANAGE_GALLERY_UPDATE_FAIL_ERR . "\";\n";
	echo "	var MANAGE_GALLERY_UPDATE_TITLE_SUCCESS_MSG = \"" . MANAGE_GALLERY_UPDATE_TITLE_SUCCESS_MSG . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var MANAGE_GALLERY_DELETE_IMAGE_CONFIRM_1_MSG = \"" . MANAGE_GALLERY_DELETE_IMAGE_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_DELETE_IMAGE_CONFIRM_2_MSG = \"" . MANAGE_GALLERY_DELETE_IMAGE_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_DELETE_IMAGE_SUCCESS_MSG = \"" . MANAGE_GALLERY_DELETE_IMAGE_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_DELETE_IMAGE_FAIL_ERR = \"" . MANAGE_GALLERY_DELETE_IMAGE_FAIL_ERR . "\";\n";
	echo "	var MANAGE_GALLERY_SAVING_PARAMS_MSG = \"" . MANAGE_GALLERY_SAVING_PARAMS_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_UPLOADING_IMAGES_MSG = \"" . MANAGE_GALLERY_UPLOADING_IMAGES_MSG . "\";\n";
	echo "	var TITLE_WORD = \"" . TITLE_WORD . "\";\n";
	echo "	var SORT_ORDER = \"" . SORT_ORDER . "\";\n";
	echo "	var EDITOR_SAVE = \"" . EDITOR_SAVE . "\";\n";
	echo "	var MANAGE_GALLERY_DELETE_IMAGE = \"" . MANAGE_GALLERY_DELETE_IMAGE . "\";\n";
	echo "	var MANAGE_GALLERY_NOT_SAVED_MSG = \"" . MANAGE_GALLERY_NOT_SAVED_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_SAVE_SORT_ORDER_SUCCESS_MSG = \"" . MANAGE_GALLERY_SAVE_SORT_ORDER_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_GALLERY_SAVE_SORT_ORDER_FAIL_ERR = \"" . MANAGE_GALLERY_SAVE_SORT_ORDER_FAIL_ERR . "\";\n";
?>
</script>

</head>

<body onLoad="GetGalleryImages();">

<table width="80%" align="center" border="0"><tr><td>
<div class="button_heading_sub_level_1" id="manage_gallery_params_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_GALLERY_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<table align="center" class="dimensions_table">
<tr><td><?php echo MANAGE_GALLERY_FULL_WIDTH; ?>:</td><td><input type="text" name="full_width" id="full_width" value="<?php echo $full_width; ?>" class="dim_input" /> px</td></tr>
<tr><td><?php echo MANAGE_GALLERY_FULL_HEIGHT; ?>:</td><td><input type="text" name="full_height" id="full_height" value="<?php echo $full_height; ?>" class="dim_input" /> px</td></tr>
<tr><td><?php echo MANAGE_GALLERY_THUMB_WIDTH; ?>:</td><td><input type="text" name="thumb_width" id="thumb_width" value="<?php echo $thumb_width; ?>" class="dim_input" onChange="ResizeThumbs();" /> px</td></tr>
<tr><td><?php echo MANAGE_GALLERY_THUMB_HEIGHT; ?>:</td><td><input type="text" name="thumb_height" id="thumb_height" value="<?php echo $thumb_height; ?>" class="dim_input" onChange="ResizeThumbs();" /> px</td></tr>
<tr><td><?php echo MANAGE_GALLERY_PRESERVE_THUMB_ASPECT; ?>:</td><td><input type="checkbox" name="preserve_thumb_aspect" id="preserve_thumb_aspect" <?php if ($preserve_thumb_aspect == 1) echo "checked='checked'"; ?> onChange="ResizeThumbs();" /></td></tr>
<tr><td><?php echo MANAGE_GALLERY_SHOW_TITLES; ?>:</td><td><input type="checkbox" name="show_titles" id="show_titles" <?php if ($show_titles == 1) echo "checked='checked'"; ?> /></td></tr>
<tr><td><?php echo MANAGE_GALLERY_DISABLE_SORT; ?>:</td><td><input type="checkbox" name="disable_sort" id="disable_sort" <?php if ($disable_sort == 1) echo "checked='checked'"; ?> /></td></tr>
<tr><td align="right" style="padding-top:20px; padding-right:20px;"><div class="button_console_save" style="width:110px;" onClick="ResizeGallery();"><span class="button_console_text_w_icon"><?php echo UPDATE_WORD; ?></span></div></td>
<td align="right" class="small_message" style="padding-top:20px; text-align:right;"><?php echo MANAGE_GALLERY_PUBLISH_MSG; ?></div></td></tr>
</table>

<div id="uploading_div"><img src="../theme/<?php echo $theme; ?>/images/uploading.gif" alt="Uploading, please wait..." />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span id="uploading_span">...</span></div>

<form name="frm_upload" id="frm_upload" action="upload_gallery_image.php" method="post" enctype="multipart/form-data">
<table align="center" class="upload_table">
<tr><td align="right"><input type="file" name="fileToUpload[]" id="fileToUpload" multiple /></td><td><div class="button_console_upload" style="width:110px;" onClick="ShowUploading(); document.forms['frm_upload'].submit();"><span class="button_console_text_w_icon"><?php echo EDIT_FAVICON_UPLOAD_BTN; ?></span></div></td></tr>
</table>
</form>

<div id="image_table_div">&nbsp;</div>
<input type='hidden' name='nCount' id='nCount' />
<center>
<div class='button_console_save' id="update_sort_btn" <?php if (($menu == "-not selected-") || ($menu == "")) echo " style='display:none;'"; else echo " style='display:block; width:130px;'"; ?> onClick="SaveSortOrder();"><span class='button_console_text_w_icon'><?php echo MANAGE_GALLERY_SAVE_SORT_ORDER; ?></span></div>
</center>

<?php include("../lib/popup_msg.html"); ?>

<div id="blowup_div" style="z-index:1000; cursor:pointer; display:none;"><img src="" id="blowup_img" alt="Photo" onclick='HideLargeImage();' /></div>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
<?php
	if ($_GET['result'] == 1)
	{
		echo "	popup_msg.top_offset = 0;\n";
		echo "	popup_msg.left_offset = 300;\n";
		echo "	popup_msg.popup_msg_type = 1;\n";
		echo "	popup_msg.status_msg = '" . MANAGE_GALLERY_UPLOAD_SUCCESS_MSG . "';\n";
		echo "	popup_msg.popup_timeout = 3000;\n";
		echo "	popup_msg.ShowPopupMsg();\n";
	}
	elseif ($_GET['result'] < 0)
	{
		echo "	popup_msg.top_offset = 0;\n";
		echo "	popup_msg.left_offset = 300;\n";
		echo "	popup_msg.popup_msg_type = 1;\n";
		if ($_GET['result'] == -1)
			echo "	popup_msg.status_msg = '" . MANAGE_GALLERY_UPLOAD_NOT_IMAGE_ERR . "';\n";
		elseif ($_GET['result'] == -2)
			echo "	popup_msg.status_msg = '" . MANAGE_GALLERY_UPLOAD_TOO_BIG_ERR . "';\n";
		elseif ($_GET['result'] == -3)
			echo "	popup_msg.status_msg = '" . MANAGE_GALLERY_UPLOAD_FAIL_ERR . "';\n";
		echo "	popup_msg.popup_timeout = 5000;\n";
		echo "	popup_msg.ShowPopupMsg();\n";
	}
?>
</script>

</body>
</html>