<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/12/2010	ELL
// Revised: 2/8/2012	ELL
// Added references to website files, images, CSS, scripts, media and Flash folder configurations.
// Revised: 8/14/2014	ELL
// Improved to find all backup CSS files.
// Modified: 12/5/2014	ELL
// Added pruning of backup files created when editing files directly (.xxxtimestamp_save), and pruning of preview (pREVIEWxxx) files.
// 
	
	include ("check_session.php");
	
	if (BWB_BASE_DIR == '')
		$userfiles_path = '';
	else
		$userfiles_path = "/" . BWB_BASE_DIR;
		
	if (BWB_WEBPAGE_DIR == '')
		$website_path = $userfiles_path;
	else
		$website_path = $userfiles_path . "/" . BWB_WEBPAGE_DIR;

	$path = ".." . $website_path . "/";
	if ($handle = opendir($path))
	{
		while (false !== ($file = readdir($handle)))
		{
			if ((!(strpos($file, "sitemap.xml") === false) && (strlen($file) > 20)) || ((substr($file, strlen($file) - 5, 5) == "_save") && (substr($file, 0, 1) == ".")) || (substr($file, 0, 7) == "pREVIEW"))
			{
				$file_path = $path . $file;
				unlink($file_path);
			}
		}
		closedir($handle);
	}
	
	$path = ".." . $userfiles_path . "/" . BWB_CSS_DIR . "/";
	if ($handle = opendir($path)) 
	{
		while (false !== ($file = readdir($handle)))
		{
			if ((strpos($file, ".css") !== false) && (strpos($file, ".css") < (strlen($file) - 5)))
			{
				$file_path = $path . $file;
				unlink($file_path);
			}
		}
		closedir($handle);
	}
	
	$path = ".." . $userfiles_path . "/" . BWB_SCRIPTS_DIR . "/";
	if ($handle = opendir($path)) 
	{
		while (false !== ($file = readdir($handle)))
		{
			if ((!(strpos($file, "menu_items.js") === false) || !(strpos($file, "menu_tpl.js") === false)) && (strlen($file) > 20))
			{
				$file_path = $path . $file;
				unlink($file_path);
			}
		}
		closedir($handle);
	}
	
	header("Location: admin_function_select.php?display_pruned_bkup_files_msg=1");
?>
