<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 8/20/09		ELL
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 7/29/2014	ELL
// Converted save functions to JQuery AJAX operations.
// Revised: 11/6/2014	ELL
// Added save to backup everytime save or publish is clicked.
// 
//
//
	include ("check_session.php");
	include("lib/build_css_string.php");

	$style_sheet = $_POST['style_sheet'];
	$site_css_table = $style_sheet . "_css";
	$custom_site_css_table = $_POST['custom_site_css_table'];
	$css_file = $style_sheet. ".css";
	$class_table = $style_sheet . "_classes";
	$action = $_POST['action'];
	
	// Custom CSS
	$custom_css = $_POST['custom_css'];
	$custom_css = addslashes($custom_css);
	
	$today = date("Y-m-d H:i:s");
	
	if ($action == "Preview")
	{
		//Start by deleting all old data in table.
		$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . "custom_site_css_preview";
		$cnt = $bwb_dbh->exec($query);
		
		//Insert new data into table.
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "custom_site_css_preview (custom_css, revised) VALUES ('" . $custom_css . "', '" . $today . "')";
		$cnt = $bwb_dbh->exec($query);
		
		if ((strpos($site_css_table, "site_css") !== false) || (strpos($site_css_table, "site_mobile_css") !== false))
		{
			include ("lib/copy_table.php");
			
			//Start by deleting all old data in table.
			$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . "site_css_preview";
			$cnt = $bwb_dbh->exec($query);
			
			//Get data from live table and move to preview table.
			if (strpos(css_table, "site_mobile_css") === false)
				copy_table(BWB_TABLE_PREFIX . "site_css", BWB_TABLE_PREFIX . "site_css_preview", $bwb_dbh, $bwb_database);
			else
				copy_table(BWB_TABLE_PREFIX . "site_mobile_css", BWB_TABLE_PREFIX . "site_css_preview", $bwb_dbh, $bwb_database);
		}
	}
	else
	{
		// Whether saving draft of publishing, save latest revision to draft table.
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name='$custom_site_css_table' AND `source`=3";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() > 0)	
			$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_draft SET page_content=:custom_css, revised='$today', `source`=3 WHERE page_name='$custom_site_css_table'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_draft SET page_name='$custom_site_css_table', page_content=:custom_css, revised='$today', `source`=3";
		$stmt = $bwb_dbh->prepare($query);
		$cnt = $stmt->execute(array(':custom_css' => $custom_css));
	
		if ($action == "Publish")	// Publish latest changes.
		{
			//Start by deleting all old data in table.
			$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . $custom_site_css_table;
			$cnt = $bwb_dbh->exec($query);
			
			//Insert new data into table.
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . $custom_site_css_table . " (custom_css, revised) VALUES ('" . $custom_css  . "', '" . $today . "')";
			$cnt = $bwb_dbh->exec($query);
		}
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_bkup SET page_name='$custom_site_css_table', page_content=:custom_css, revised='$today', source=3";
		$stmt = $bwb_dbh->prepare($query);
		$stmt->execute(array(':custom_css' => $custom_css));
	}

	/////////////////////////////////////////////
	// Build string for site.css file /////
	if ($action == "Preview")
		$site_css_table = "site_css_preview";
	
	$css_string = BuildCSSString(BWB_TABLE_PREFIX . $site_css_table, BWB_TABLE_PREFIX . $class_table, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX . "fonts");
			

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if ($action == "Publish")
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
	else
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/site_preview.css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo "Could not rename $file_name to $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	
	//////////////////////////////////////////////////////////
	if ($cnt > 0)
		echo "Custom CSS has been saved";
	else
		echo "Save failed";
?>
