<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 9/22/2008	ELL
// Added text shadow effects.
// Revised: 1/9/2011	ELL
// Added capability to handle multiple JavaScript Menus.
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to script folder configuration.
// Revised: 2/10/2013	ELL
// Fixed bug of underline being present even when not selected.
// Revised: 5/15/2013	ELL
// Added text alignment, box shadow, and independent top, bottom, left, right padding.
// Revised: 12/30/2013	ELL
// Added handling of new cursor styles.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 3/12/2015	ELL
// Updated SQL to handle new styles that have been added over last few months.
// Revised: 4/5/2015	ELL
// Added font size units.
// Revised: 9/21/2015	ELL
// Added text-indent attribute.
// Converted save operation to AJAX.
// Revamped preview to show actual popup page.
	
	include ("check_session.php");

	$operation = $_POST['operation'];
	$menu = $_POST['menu'];
	$tmp = str_replace("_mobile", "", $menu);
	$suffix = substr($tmp, 4);
	$class_table = $menu . "_classes";
	
	include ("lib/copy_table.php");
	include ("lib/build_sql_string.php");
	include ("lib/build_css_string.php");
	
	if ($operation == "Preview")
	{
		$site_css_table = "menu_styles_preview";
		$css_file = "menu_styles_preview.css";
		
		$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . $site_css_table;
		$cnt = $bwb_dbh->exec($query);
		$src_table = $menu . "_css";
		copy_table(BWB_TABLE_PREFIX . $src_table, BWB_TABLE_PREFIX . $site_css_table, $bwb_dbh, $bwb_database);
	}
	else
	{
		$site_css_table = $menu . "_css";
		$css_file = $menu . ".css";
	}
	
	$top_level_align = $_POST['top_level_align'];
	$top_level_vertical_align = $_POST['top_level_vertical_align'];
	$top_level_font_out = $_POST['top_level_font_out'];
	$top_level_font_size_out = $_POST['top_level_font_size_out'];
	$top_level_font_size_units_out = $_POST['top_level_font_size_units_out'];
	$top_level_text_color_out = $_POST['top_level_text_color_out'];
	$top_level_padding_top_out = $_POST['top_level_padding_top_out'];
	$top_level_padding_right_out = $_POST['top_level_padding_right_out'];
	$top_level_padding_bottom_out = $_POST['top_level_padding_bottom_out'];
	$top_level_padding_left_out = $_POST['top_level_padding_left_out'];
	$top_level_bold_out = $_POST['top_level_bold_out'];
	$top_level_italic_out = isset($_POST['top_level_italic_out']) ? 1 : 0;
	$top_level_underline_out = isset($_POST['top_level_underline_out']) ? 1 : 0;
	$top_level_overline_out = isset($_POST['top_level_overline_out']) ? 1 : 0;
	$top_level_blink_out = isset($_POST['top_level_blink_out']) ? 1 : 0;
	
	$top_level_shadow_out = isset($_POST['top_level_shadow_out']) ? 1 : 0;
	$top_level_shadow_color_out = isset($_POST['top_level_shadow_color_out']) ? $_POST['top_level_shadow_color_out'] : _NOT_SET_;
	$top_level_shadow_x_offset_out = is_numeric($_POST['top_level_shadow_x_offset_out']) ? $_POST['top_level_shadow_x_offset_out'] : 0;
	$top_level_shadow_y_offset_out = is_numeric($_POST['top_level_shadow_y_offset_out']) ? $_POST['top_level_shadow_y_offset_out'] : 0;
	$top_level_shadow_blur_out = is_numeric($_POST['top_level_shadow_blur_out']) ? $_POST['top_level_shadow_blur_out'] : 0;
	
	$top_level_font_over = $_POST['top_level_font_over'];
	$top_level_font_size_over = $_POST['top_level_font_size_over'];
	$top_level_font_size_units_over = $_POST['top_level_font_size_units_over'];
	$top_level_text_color_over = $_POST['top_level_text_color_over'];
	$top_level_padding_top_over = $_POST['top_level_padding_top_over'];
	$top_level_padding_right_over = $_POST['top_level_padding_right_over'];
	$top_level_padding_bottom_over = $_POST['top_level_padding_bottom_over'];
	$top_level_padding_left_over = $_POST['top_level_padding_left_over'];
	$top_level_bold_over = $_POST['top_level_bold_over'];
	$top_level_italic_over = isset($_POST['top_level_italic_over']) ? 1 : 0;
	$top_level_underline_over = isset($_POST['top_level_underline_over']) ? 1 : 0;
	$top_level_overline_over = isset($_POST['top_level_overline_over']) ? 1 : 0;
	$top_level_blink_over = isset($_POST['top_level_blink_over']) ? 1 : 0;
	
	$top_level_shadow_over = isset($_POST['top_level_shadow_over']) ? 1 : 0;
	$top_level_shadow_color_over = isset($_POST['top_level_shadow_color_over']) ? $_POST['top_level_shadow_color_over'] : _NOT_SET_;
	$top_level_shadow_x_offset_over = is_numeric($_POST['top_level_shadow_x_offset_over']) ? $_POST['top_level_shadow_x_offset_over'] : 0;
	$top_level_shadow_y_offset_over = is_numeric($_POST['top_level_shadow_y_offset_over']) ? $_POST['top_level_shadow_y_offset_over'] : 0;
	$top_level_shadow_blur_over = is_numeric($_POST['top_level_shadow_blur_over']) ? $_POST['top_level_shadow_blur_over'] : 0;
	
	$top_level_bkgd_color_out = $_POST['top_level_bkgd_color_out'];
	$top_level_bkgd_opacity_out = is_numeric($_POST['top_level_bkgd_opacity_out']) ? $_POST['top_level_bkgd_opacity_out'] : -1;
	$top_level_border_out = is_numeric($_POST['top_level_border_out']) ? $_POST['top_level_border_out'] : -1;
	$top_level_border_color_out = $_POST['top_level_border_color_out'];
	$top_level_bkgd_color_over = $_POST['top_level_bkgd_color_over'];
	$top_level_border_over = is_numeric($_POST['top_level_border_over']) ? $_POST['top_level_border_over'] : -1;
	$top_level_border_color_over = $_POST['top_level_border_color_over'];
	
	$top_level_box_shadow_horizontal_out = is_numeric($_POST['top_level_box_shadow_horizontal_out']) ? $_POST['top_level_box_shadow_horizontal_out'] : -1000000;
	$top_level_box_shadow_vertical_out = is_numeric($_POST['top_level_box_shadow_vertical_out']) ? $_POST['top_level_box_shadow_vertical_out'] : -1000000;
	$top_level_box_shadow_blur_out = is_numeric($_POST['top_level_box_shadow_blur_out']) ? $_POST['top_level_box_shadow_blur_out'] : -1;
	$top_level_box_shadow_spread_out = is_numeric($_POST['top_level_box_shadow_spread_out']) ? $_POST['top_level_box_shadow_spread_out'] : -1000000;
	$top_level_box_shadow_color_out = $_POST['top_level_box_shadow_color_out'];
	$top_level_box_shadow_inset_out = isset($_POST['top_level_box_shadow_inset_out']) ? $_POST['top_level_box_shadow_inset_out'] : 0;
	
	$top_level_box_shadow_horizontal_over = is_numeric($_POST['top_level_box_shadow_horizontal_over']) ? $_POST['top_level_box_shadow_horizontal_over'] : -1000000;
	$top_level_box_shadow_vertical_over = is_numeric($_POST['top_level_box_shadow_vertical_over']) ? $_POST['top_level_box_shadow_vertical_over'] : -1000000;
	$top_level_box_shadow_blur_over = is_numeric($_POST['top_level_box_shadow_blur_over']) ? $_POST['top_level_box_shadow_blur_over'] : -1;
	$top_level_box_shadow_spread_over = is_numeric($_POST['top_level_box_shadow_spread_over']) ? $_POST['top_level_box_shadow_spread_over'] : -1000000;
	$top_level_box_shadow_color_over = $_POST['top_level_box_shadow_color_over'];
	$top_level_box_shadow_inset_over = isset($_POST['top_level_box_shadow_inset_over']) ? $_POST['top_level_box_shadow_inset_over'] : 0;
	
	$sub_level_1_align = $_POST['sub_level_1_align'];
	$sub_level_1_vertical_align = $_POST['sub_level_1_vertical_align'];
	$sub_level_1_font_out = $_POST['sub_level_1_font_out'];
	$sub_level_1_font_size_out = $_POST['sub_level_1_font_size_out'];
	$sub_level_1_font_size_units_out = $_POST['sub_level_1_font_size_units_out'];
	$sub_level_1_text_color_out = $_POST['sub_level_1_text_color_out'];
	$sub_level_1_padding_top_out = $_POST['sub_level_1_padding_top_out'];
	$sub_level_1_padding_right_out = $_POST['sub_level_1_padding_right_out'];
	$sub_level_1_padding_bottom_out = $_POST['sub_level_1_padding_bottom_out'];
	$sub_level_1_padding_left_out = $_POST['sub_level_1_padding_left_out'];
	$sub_level_1_bold_out = $_POST['sub_level_1_bold_out'];
	$sub_level_1_italic_out = isset($_POST['sub_level_1_italic_out']) ? 1 : 0;
	$sub_level_1_underline_out = isset($_POST['sub_level_1_underline_out']) ? 1 : 0;
	$sub_level_1_overline_out = isset($_POST['sub_level_1_overline_out']) ? 1 : 0;
	$sub_level_1_blink_out = isset($_POST['sub_level_1_blink_out']) ? 1 : 0;
	
	$sub_level_1_shadow_out = isset($_POST['sub_level_1_shadow_out']) ? 1 : 0;
	$sub_level_1_shadow_color_out = isset($_POST['sub_level_1_shadow_color_out']) ? $_POST['sub_level_1_shadow_color_out'] : _NOT_SET_;
	$sub_level_1_shadow_x_offset_out = is_numeric($_POST['sub_level_1_shadow_x_offset_out']) ? $_POST['sub_level_1_shadow_x_offset_out'] : 0;
	$sub_level_1_shadow_y_offset_out = is_numeric($_POST['sub_level_1_shadow_y_offset_out']) ? $_POST['sub_level_1_shadow_y_offset_out'] : 0;
	$sub_level_1_shadow_blur_out = is_numeric($_POST['sub_level_1_shadow_blur_out']) ? $_POST['sub_level_1_shadow_blur_out'] : 0;
	
	$sub_level_1_font_over = $_POST['sub_level_1_font_over'];
	$sub_level_1_font_size_over = $_POST['sub_level_1_font_size_over'];
	$sub_level_1_font_size_units_over = $_POST['sub_level_1_font_size_units_over'];
	$sub_level_1_text_color_over = $_POST['sub_level_1_text_color_over'];
	$sub_level_1_padding_top_over = $_POST['sub_level_1_padding_top_over'];
	$sub_level_1_padding_right_over = $_POST['sub_level_1_padding_right_over'];
	$sub_level_1_padding_bottom_over = $_POST['sub_level_1_padding_bottom_over'];
	$sub_level_1_padding_left_over = $_POST['sub_level_1_padding_left_over'];
	$sub_level_1_bold_over = $_POST['sub_level_1_bold_over'];
	$sub_level_1_italic_over = isset($_POST['sub_level_1_italic_over']) ? 1 : 0;
	$sub_level_1_underline_over = isset($_POST['sub_level_1_underline_over']) ? 1 : 0;
	$sub_level_1_overline_over = isset($_POST['sub_level_1_overline_over']) ? 1 : 0;
	$sub_level_1_blink_over = isset($_POST['sub_level_1_blink_over']) ? 1 : 0;
	
	$sub_level_1_shadow_over = isset($_POST['sub_level_1_shadow_over']) ? 1 : 0;
	$sub_level_1_shadow_color_over = isset($_POST['sub_level_1_shadow_color_over']) ? $_POST['sub_level_1_shadow_color_over'] : _NOT_SET_;
	$sub_level_1_shadow_x_offset_over = is_numeric($_POST['sub_level_1_shadow_x_offset_over']) ? $_POST['sub_level_1_shadow_x_offset_over'] : 0;
	$sub_level_1_shadow_y_offset_over = is_numeric($_POST['sub_level_1_shadow_y_offset_over']) ? $_POST['sub_level_1_shadow_y_offset_over'] : 0;
	$sub_level_1_shadow_blur_over = is_numeric($_POST['sub_level_1_shadow_blur_over']) ? $_POST['sub_level_1_shadow_blur_over'] : 0;
	
	$sub_level_1_bkgd_color_out = $_POST['sub_level_1_bkgd_color_out'];
	$sub_level_1_bkgd_opacity_out = is_numeric($_POST['sub_level_1_bkgd_opacity_out']) ? $_POST['sub_level_1_bkgd_opacity_out'] : -1;
	$sub_level_1_border_out = is_numeric($_POST['sub_level_1_border_out']) ? $_POST['sub_level_1_border_out'] : -1;
	$sub_level_1_border_color_out = $_POST['sub_level_1_border_color_out'];
	$sub_level_1_bkgd_color_over = $_POST['sub_level_1_bkgd_color_over'];
	$sub_level_1_border_over = is_numeric($_POST['sub_level_1_border_over']) ? $_POST['sub_level_1_border_over'] : -1;
	$sub_level_1_border_color_over = $_POST['sub_level_1_border_color_over'];
	
	$sub_level_1_box_shadow_horizontal_out = is_numeric($_POST['sub_level_1_box_shadow_horizontal_out']) ? $_POST['sub_level_1_box_shadow_horizontal_out'] : -1000000;
	$sub_level_1_box_shadow_vertical_out = is_numeric($_POST['sub_level_1_box_shadow_vertical_out']) ? $_POST['sub_level_1_box_shadow_vertical_out'] : -1000000;
	$sub_level_1_box_shadow_blur_out = is_numeric($_POST['sub_level_1_box_shadow_blur_out']) ? $_POST['sub_level_1_box_shadow_blur_out'] : -1;
	$sub_level_1_box_shadow_spread_out = is_numeric($_POST['sub_level_1_box_shadow_spread_out']) ? $_POST['sub_level_1_box_shadow_spread_out'] : -1000000;
	$sub_level_1_box_shadow_color_out = $_POST['sub_level_1_box_shadow_color_out'];
	$sub_level_1_box_shadow_inset_out = isset($_POST['sub_level_1_box_shadow_inset_out']) ? $_POST['sub_level_1_box_shadow_inset_out'] : 0;
	
	$sub_level_1_box_shadow_horizontal_over = is_numeric($_POST['sub_level_1_box_shadow_horizontal_over']) ? $_POST['sub_level_1_box_shadow_horizontal_over'] : -1000000;
	$sub_level_1_box_shadow_vertical_over = is_numeric($_POST['sub_level_1_box_shadow_vertical_over']) ? $_POST['sub_level_1_box_shadow_vertical_over'] : -1000000;
	$sub_level_1_box_shadow_blur_over = is_numeric($_POST['sub_level_1_box_shadow_blur_over']) ? $_POST['sub_level_1_box_shadow_blur_over'] : -1;
	$sub_level_1_box_shadow_spread_over = is_numeric($_POST['sub_level_1_box_shadow_spread_over']) ? $_POST['sub_level_1_box_shadow_spread_over'] : -1000000;
	$sub_level_1_box_shadow_color_over = $_POST['sub_level_1_box_shadow_color_over'];
	$sub_level_1_box_shadow_inset_over = isset($_POST['sub_level_1_box_shadow_inset_over']) ? $_POST['sub_level_1_box_shadow_inset_over'] : 0;
	
	$sub_level_2_align = $_POST['sub_level_2_align'];
	$sub_level_2_vertical_align = $_POST['sub_level_2_vertical_align'];
	$sub_level_2_font_out = $_POST['sub_level_2_font_out'];
	$sub_level_2_font_size_out = $_POST['sub_level_2_font_size_out'];
	$sub_level_2_font_size_units_out = $_POST['sub_level_2_font_size_units_out'];
	$sub_level_2_text_color_out = $_POST['sub_level_2_text_color_out'];
	$sub_level_2_padding_top_out = $_POST['sub_level_2_padding_top_out'];
	$sub_level_2_padding_right_out = $_POST['sub_level_2_padding_right_out'];
	$sub_level_2_padding_bottom_out = $_POST['sub_level_2_padding_bottom_out'];
	$sub_level_2_padding_left_out = $_POST['sub_level_2_padding_left_out'];
	$sub_level_2_bold_out = $_POST['sub_level_2_bold_out'];
	$sub_level_2_italic_out = isset($_POST['sub_level_2_italic_out']) ? 1 : 0;
	$sub_level_2_underline_out = isset($_POST['sub_level_2_underline_out']) ? 1 : 0;
	$sub_level_2_overline_out = isset($_POST['sub_level_2_overline_out']) ? 1 : 0;
	$sub_level_2_blink_out = isset($_POST['sub_level_2_blink_out']) ? 1 : 0;
	
	$sub_level_2_shadow_out = isset($_POST['sub_level_2_shadow_out']) ? 1 : 0;
	$sub_level_2_shadow_color_out = isset($_POST['sub_level_2_shadow_color_out']) ? $_POST['sub_level_2_shadow_color_out'] : _NOT_SET_;
	$sub_level_2_shadow_x_offset_out = is_numeric($_POST['sub_level_2_shadow_x_offset_out']) ? $_POST['sub_level_2_shadow_x_offset_out'] : 0;
	$sub_level_2_shadow_y_offset_out = is_numeric($_POST['sub_level_2_shadow_y_offset_out']) ? $_POST['sub_level_2_shadow_y_offset_out'] : 0;
	$sub_level_2_shadow_blur_out = is_numeric($_POST['sub_level_2_shadow_blur_out']) ? $_POST['sub_level_2_shadow_blur_out'] : 0;
	
	$sub_level_2_font_over = $_POST['sub_level_2_font_over'];
	$sub_level_2_font_size_over = $_POST['sub_level_2_font_size_over'];
	$sub_level_2_font_size_units_over = $_POST['sub_level_2_font_size_units_over'];
	$sub_level_2_text_color_over = $_POST['sub_level_2_text_color_over'];
	$sub_level_2_padding_top_over = $_POST['sub_level_2_padding_top_over'];
	$sub_level_2_padding_right_over = $_POST['sub_level_2_padding_right_over'];
	$sub_level_2_padding_bottom_over = $_POST['sub_level_2_padding_bottom_over'];
	$sub_level_2_padding_left_over = $_POST['sub_level_2_padding_left_over'];
	$sub_level_2_bold_over = $_POST['sub_level_2_bold_over'];
	$sub_level_2_italic_over = isset($_POST['sub_level_2_italic_over']) ? 1 : 0;
	$sub_level_2_underline_over = isset($_POST['sub_level_2_underline_over']) ? 1 : 0;
	$sub_level_2_overline_over = isset($_POST['sub_level_2_overline_over']) ? 1 : 0;
	$sub_level_2_blink_over = isset($_POST['sub_level_2_blink_over']) ? 1 : 0;
	
	$sub_level_2_shadow_over = isset($_POST['sub_level_2_shadow_over']) ? 1 : 0;
	$sub_level_2_shadow_color_over = isset($_POST['sub_level_2_shadow_color_over']) ? $_POST['sub_level_2_shadow_color_over'] : _NOT_SET_;
	$sub_level_2_shadow_x_offset_over = is_numeric($_POST['sub_level_2_shadow_x_offset_over']) ? $_POST['sub_level_2_shadow_x_offset_over'] : 0;
	$sub_level_2_shadow_y_offset_over = is_numeric($_POST['sub_level_2_shadow_y_offset_over']) ? $_POST['sub_level_2_shadow_y_offset_over'] : 0;
	$sub_level_2_shadow_blur_over = is_numeric($_POST['sub_level_2_shadow_blur_over']) ? $_POST['sub_level_2_shadow_blur_over'] : 0;
	
	$sub_level_2_bkgd_color_out = $_POST['sub_level_2_bkgd_color_out'];
	$sub_level_2_bkgd_opacity_out = is_numeric($_POST['sub_level_2_bkgd_opacity_out']) ? $_POST['sub_level_2_bkgd_opacity_out'] : -1;
	$sub_level_2_border_out = is_numeric($_POST['sub_level_2_border_out']) ? $_POST['sub_level_2_border_out'] : -1;
	$sub_level_2_border_color_out = $_POST['sub_level_2_border_color_out'];
	$sub_level_2_bkgd_color_over = $_POST['sub_level_2_bkgd_color_over'];
	$sub_level_2_border_over = is_numeric($_POST['sub_level_2_border_over']) ? $_POST['sub_level_2_border_over'] : -1;
	$sub_level_2_border_color_over = $_POST['sub_level_2_border_color_over'];
	
	$sub_level_2_box_shadow_horizontal_out = is_numeric($_POST['sub_level_2_box_shadow_horizontal_out']) ? $_POST['sub_level_2_box_shadow_horizontal_out'] : -1000000;
	$sub_level_2_box_shadow_vertical_out = is_numeric($_POST['sub_level_2_box_shadow_vertical_out']) ? $_POST['sub_level_2_box_shadow_vertical_out'] : -1000000;
	$sub_level_2_box_shadow_blur_out = is_numeric($_POST['sub_level_2_box_shadow_blur_out']) ? $_POST['sub_level_2_box_shadow_blur_out'] : -1;
	$sub_level_2_box_shadow_spread_out = is_numeric($_POST['sub_level_2_box_shadow_spread_out']) ? $_POST['sub_level_2_box_shadow_spread_out'] : -1000000;
	$sub_level_2_box_shadow_color_out = $_POST['sub_level_2_box_shadow_color_out'];
	$sub_level_2_box_shadow_inset_out = isset($_POST['sub_level_2_box_shadow_inset_out']) ? $_POST['sub_level_2_box_shadow_inset_out'] : 0;
	
	$sub_level_2_box_shadow_horizontal_over = is_numeric($_POST['sub_level_2_box_shadow_horizontal_over']) ? $_POST['sub_level_2_box_shadow_horizontal_over'] : -1000000;
	$sub_level_2_box_shadow_vertical_over = is_numeric($_POST['sub_level_2_box_shadow_vertical_over']) ? $_POST['sub_level_2_box_shadow_vertical_over'] : -1000000;
	$sub_level_2_box_shadow_blur_over = is_numeric($_POST['sub_level_2_box_shadow_blur_over']) ? $_POST['sub_level_2_box_shadow_blur_over'] : -1;
	$sub_level_2_box_shadow_spread_over = is_numeric($_POST['sub_level_2_box_shadow_spread_over']) ? $_POST['sub_level_2_box_shadow_spread_over'] : -1000000;
	$sub_level_2_box_shadow_color_over = $_POST['sub_level_2_box_shadow_color_over'];
	$sub_level_2_box_shadow_inset_over = isset($_POST['sub_level_2_box_shadow_inset_over']) ? $_POST['sub_level_2_box_shadow_inset_over'] : 0;
	
	
	// Check numerical values for null.
	if (!isset($top_level_font_size_out) || ($top_level_font_size_out == ""))  $top_level_font_size_out = -1;
	if (!isset($top_level_padding_top_out) || ($top_level_padding_top_out == ""))  $top_level_padding_top_out = -1;
	if (!isset($top_level_padding_right_out) || ($top_level_padding_right_out == ""))  $top_level_padding_right_out = -1;
	if (!isset($top_level_padding_bottom_out) || ($top_level_padding_bottom_out == ""))  $top_level_padding_bottom_out = -1;
	if (!isset($top_level_padding_left_out) || ($top_level_padding_left_out == ""))  $top_level_padding_left_out = -1;
	
	if (!isset($top_level_font_size_over) || ($top_level_font_size_over == ""))  $top_level_font_size_over = -1;
	if (!isset($top_level_padding_top_over) || ($top_level_padding_top_over == ""))  $top_level_padding_top_over = -1;
	if (!isset($top_level_padding_right_over) || ($top_level_padding_right_over == ""))  $top_level_padding_right_over = -1;
	if (!isset($top_level_padding_bottom_over) || ($top_level_padding_bottom_over == ""))  $top_level_padding_bottom_over = -1;
	if (!isset($top_level_padding_left_over) || ($top_level_padding_left_over == ""))  $top_level_padding_left_over = -1;
	
	if (!isset($top_level_bkgd_opacity_out) || ($top_level_bkgd_opacity_out == ""))  $top_level_bkgd_opacity_out = -1;
	if (!isset($top_level_border_out) || ($top_level_border_out == ""))  $top_level_border_out = -1;
	if (!isset($top_level_border_over) || ($top_level_border_over == ""))  $top_level_border_over = -1;
	
	if (!isset($top_level_box_shadow_horizontal_out) || ($top_level_box_shadow_horizontal_out == ""))  $top_level_box_shadow_horizontal_out = -1000000;
	if (!isset($top_level_box_shadow_vertical_out) || ($top_level_box_shadow_vertical_out == ""))  $top_level_box_shadow_vertical_out = -1000000;
	if (!isset($top_level_box_shadow_blur_out) || ($top_level_box_shadow_blur_out == ""))  $top_level_box_shadow_blur_out = -1;
	if (!isset($top_level_box_shadow_spread_out) || ($top_level_box_shadow_spread_out == ""))  $top_level_box_shadow_spread_out = -1000000;
	if (!isset($top_level_box_shadow_inset_out) || ($top_level_box_shadow_inset_out == ""))  $top_level_box_shadow_inset_out = 0;
	
	if (!isset($top_level_box_shadow_horizontal_over) || ($top_level_box_shadow_horizontal_over == ""))  $top_level_box_shadow_horizontal_over = -1000000;
	if (!isset($top_level_box_shadow_vertical_over) || ($top_level_box_shadow_vertical_over == ""))  $top_level_box_shadow_vertical_over = -1000000;
	if (!isset($top_level_box_shadow_blur_over) || ($top_level_box_shadow_blur_over == ""))  $top_level_box_shadow_blur_over = -1;
	if (!isset($top_level_box_shadow_spread_over) || ($top_level_box_shadow_spread_over == ""))  $top_level_box_shadow_spread_over = -1000000;
	if (!isset($top_level_box_shadow_inset_over) || ($top_level_box_shadow_inset_over == ""))  $top_level_box_shadow_inset_over = 0;

	if (!isset($sub_level_1_font_size_out) || ($sub_level_1_font_size_out == ""))  $sub_level_1_font_size_out = -1;
	if (!isset($sub_level_1_padding_top_out) || ($sub_level_1_padding_top_out == ""))  $sub_level_1_padding_top_out = -1;
	if (!isset($sub_level_1_padding_right_out) || ($sub_level_1_padding_right_out == ""))  $sub_level_1_padding_right_out = -1;
	if (!isset($sub_level_1_padding_bottom_out) || ($sub_level_1_padding_bottom_out == ""))  $sub_level_1_padding_bottom_out = -1;
	if (!isset($sub_level_1_padding_left_out) || ($sub_level_1_padding_left_out == ""))  $sub_level_1_padding_left_out = -1;
	
	if (!isset($sub_level_1_font_size_over) || ($sub_level_1_font_size_over == ""))  $sub_level_1_font_size_over = -1;
	if (!isset($sub_level_1_padding_top_over) || ($sub_level_1_padding_top_over == ""))  $sub_level_1_padding_top_over = -1;
	if (!isset($sub_level_1_padding_right_over) || ($sub_level_1_padding_right_over == ""))  $sub_level_1_padding_right_over = -1;
	if (!isset($sub_level_1_padding_bottom_over) || ($sub_level_1_padding_bottom_over == ""))  $sub_level_1_padding_bottom_over = -1;
	if (!isset($sub_level_1_padding_left_over) || ($sub_level_1_padding_left_over == ""))  $sub_level_1_padding_left_over = -1;
	
	if (!isset($sub_level_1_bkgd_opacity_out) || ($sub_level_1_bkgd_opacity_out == ""))  $sub_level_1_bkgd_opacity_out = -1;
	if (!isset($sub_level_1_border_out) || ($sub_level_1_border_out == ""))  $sub_level_1_border_out = -1;
	if (!isset($sub_level_1_border_over) || ($sub_level_1_border_over == ""))  $sub_level_1_border_over = -1;
	
	if (!isset($sub_level_1_box_shadow_horizontal) || ($sub_level_1_box_shadow_horizontal == ""))  $sub_level_1_box_shadow_horizontal = -1000000;
	if (!isset($sub_level_1_box_shadow_vertical) || ($sub_level_1_box_shadow_vertical == ""))  $sub_level_1_box_shadow_vertical = -1000000;
	if (!isset($sub_level_1_box_shadow_blur) || ($sub_level_1_box_shadow_blur == ""))  $sub_level_1_box_shadow_blur = -1;
	if (!isset($sub_level_1_box_shadow_spread) || ($sub_level_1_box_shadow_spread == ""))  $sub_level_1_box_shadow_spread = -1000000;
	if (!isset($sub_level_1_box_shadow_inset) || ($sub_level_1_box_shadow_inset == ""))  $sub_level_1_box_shadow_inset = 0;

	if (!isset($sub_level_2_font_size_out) || ($sub_level_2_font_size_out == ""))  $sub_level_2_font_size_out = -1;
	if (!isset($sub_level_2_padding_top_out) || ($sub_level_2_padding_top_out == ""))  $sub_level_2_padding_top_out = -1;
	if (!isset($sub_level_2_padding_right_out) || ($sub_level_2_padding_right_out == ""))  $sub_level_2_padding_right_out = -1;
	if (!isset($sub_level_2_padding_bottom_out) || ($sub_level_2_padding_bottom_out == ""))  $sub_level_2_padding_bottom_out = -1;
	if (!isset($sub_level_2_padding_left_out) || ($sub_level_2_padding_left_out == ""))  $sub_level_2_padding_left_out = -1;

	if (!isset($sub_level_2_font_size_over) || ($sub_level_2_font_size_over == ""))  $sub_level_2_font_size_over = -1;
	if (!isset($sub_level_2_padding_top_over) || ($sub_level_2_padding_top_over == ""))  $sub_level_2_padding_top_over = -1;
	if (!isset($sub_level_2_padding_right_over) || ($sub_level_2_padding_right_over == ""))  $sub_level_2_padding_right_over = -1;
	if (!isset($sub_level_2_padding_bottom_over) || ($sub_level_2_padding_bottom_over == ""))  $sub_level_2_padding_bottom_over = 0;
	if (!isset($sub_level_2_padding_left_over) || ($sub_level_2_padding_left_over == ""))  $sub_level_2_padding_left_over = -1;
	
	if (!isset($sub_level_2_bkgd_opacity_out) || ($sub_level_2_bkgd_opacity_out == ""))  $sub_level_2_bkgd_opacity_out = -1;
	if (!isset($sub_level_2_border_out) || ($sub_level_2_border_out == ""))  $sub_level_2_border_out = -1;
	if (!isset($sub_level_2_border_over) || ($sub_level_2_border_over == ""))  $sub_level_2_border_over = -1;
	
	if (!isset($sub_level_2_box_shadow_horizontal_out) || ($sub_level_2_box_shadow_horizontal_out == ""))  $sub_level_2_box_shadow_horizontal_out = -1000000;
	if (!isset($sub_level_2_box_shadow_vertical_out) || ($sub_level_2_box_shadow_vertical_out == ""))  $sub_level_2_box_shadow_vertical_out = -1000000;
	if (!isset($sub_level_2_box_shadow_blur_out) || ($sub_level_2_box_shadow_blur_out == ""))  $sub_level_2_box_shadow_blur_out = -1;
	if (!isset($sub_level_2_box_shadow_spread_out) || ($sub_level_2_box_shadow_spread_out == ""))  $sub_level_2_box_shadow_spread_out = -1000000;
	if (!isset($sub_level_2_box_shadow_inset_out) || ($sub_level_2_box_shadow_inset_out == ""))  $sub_level_2_box_shadow_inset_out = 0;
	
	if (!isset($sub_level_2_box_shadow_horizontal_over) || ($sub_level_2_box_shadow_horizontal_over == ""))  $sub_level_2_box_shadow_horizontal_over = -1000000;
	if (!isset($sub_level_2_box_shadow_vertical_over) || ($sub_level_2_box_shadow_vertical_over == ""))  $sub_level_2_box_shadow_vertical_over = -1000000;
	if (!isset($sub_level_2_box_shadow_blur_over) || ($sub_level_2_box_shadow_blur_over == ""))  $sub_level_2_box_shadow_blur_over = -1;
	if (!isset($sub_level_2_box_shadow_spread_over) || ($sub_level_2_box_shadow_spread_over == ""))  $sub_level_2_box_shadow_spread_over = -1000000;
	if (!isset($sub_level_2_box_shadow_inset_over) || ($sub_level_2_box_shadow_inset_over == ""))  $sub_level_2_box_shadow_inset_over = 0;
	

	/////////////////////////////////////////////////////////////////
	if (($top_level_underline_out == 0) && ($top_level_overline_out == 0) && ($top_level_blink_out == 0))
		$top_level_no_text_dec_out = 1;
	else
		$top_level_no_text_dec_out = 0;
		
	if (($top_level_underline_over == 0) && ($top_level_overline_over == 0) && ($top_level_blink_over == 0))
		$top_level_no_text_dec_over = 1;
	else
		$top_level_no_text_dec_over = 0;
		
	if (($sub_level_1_underline_over == 0) && ($sub_level_1_overline_over == 0) && ($sub_level_1_blink_over == 0))
		$sub_level_1_no_text_dec_over = 1;
	else
		$sub_level_1_no_text_dec_over = 0;
		
	if (($sub_level_1_underline_out == 0) && ($sub_level_1_overline_out == 0) && ($sub_level_1_blink_out == 0))
		$sub_level_1_no_text_dec_out = 1;
	else
		$sub_level_1_no_text_dec_out = 0;
		
	if (($sub_level_2_underline_over == 0) && ($sub_level_2_overline_over == 0) && ($sub_level_2_blink_over == 0))
		$sub_level_2_no_text_dec_over = 1;
	else
		$sub_level_2_no_text_dec_over = 0;
		
	if (($sub_level_2_underline_out == 0) && ($sub_level_2_overline_out == 0) && ($sub_level_2_blink_out == 0))
		$sub_level_2_no_text_dec_out = 1;
	else
		$sub_level_2_no_text_dec_out = 0;
		
	////////////////////////////////////////////////////////////////////////
	if ($top_level_border_out > 0)
		$top_level_border_style_out = "solid";
	else
		$top_level_border_style_out = "-not selected-";
		
	if ($top_level_border_over > 0)
		$top_level_border_style_over = "solid";
	else
		$top_level_border_style_over = "-not selected-";
		
	if ($sub_level_1_border_out > 0)
		$sub_level_1_border_style_out = "solid";
	else
		$sub_level_1_border_style_out = "-not selected-";
		
	if ($sub_level_1_border_over > 0)
		$sub_level_1_border_style_over = "solid";
	else
		$sub_level_1_border_style_over = "-not selected-";
		
	if ($sub_level_2_border_out > 0)
		$sub_level_2_border_style_out = "solid";
	else
		$sub_level_2_border_style_out = "-not selected-";
		
	if ($sub_level_2_border_over > 0)
		$sub_level_2_border_style_over = "solid";
	else
		$sub_level_2_border_style_over = "-not selected-";
		
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l0iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
		
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l0iout" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l0iout" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, $top_level_font_out, "-not selected-", "-not selected-", 
	$top_level_font_size_out, $top_level_font_size_units_out,
	$top_level_text_color_out, $top_level_padding_top_out, $top_level_padding_right_out, $top_level_padding_bottom_out, $top_level_padding_left_out, 
	0, 0, 0, 0, $top_level_bold_out, $top_level_italic_out,
	$top_level_underline_out, $top_level_overline_out, $top_level_blink_out, 0, 0, 0,
	0, 0, $top_level_no_text_dec_out, $top_level_shadow_out, $top_level_shadow_color_out, $top_level_shadow_x_offset_out,
	$top_level_shadow_y_offset_out, $top_level_shadow_blur_out, -1, 0, $top_level_align, $top_level_vertical_align, -1000000, -1, "-not set-", -1, -1,
	0, 0, "-not set-", "-not selected-", "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-",
	-1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	-1000000, -1000000, -1, -1000000, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "query: $query<br><br>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l0iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l0iover" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l0iover" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, $top_level_font_over, "-not selected-", "-not selected-", 
	$top_level_font_size_over, $top_level_font_size_units_over,		
	$top_level_text_color_over, $top_level_padding_top_over, $top_level_padding_right_over, $top_level_padding_bottom_over, $top_level_padding_left_over,
	0, 0, 0, 0,	$top_level_bold_over, $top_level_italic_over, $top_level_underline_over, $top_level_overline_over, $top_level_blink_over, 0, 
	0, 0, 0, 0, $top_level_no_text_dec_over, $top_level_shadow_over, $top_level_shadow_color_over, $top_level_shadow_x_offset_over,
	$top_level_shadow_y_offset_over, $top_level_shadow_blur_over, -1, 0, $top_level_align, $top_level_vertical_align, -1000000, -1, "-not set-", -1, -1, 
	0, 0, "-not set-",	"-not selected-", "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-",
	-1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	-1000000, -1000000, -1, -1000000, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "query: $query<br><br>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l0oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l0oout" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l0oout" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, "-not selected-", "-not selected-", "-not selected-", -1, 					
	"px", "-not set-", -1, -1, -1, -1, 0, 0, 0, 0, "-not selected-", 0,	0, 0, 0, 0, 0, 0, 0, 0, $top_level_no_text_dec_out, 0, "-not set-", 0,
	0, 0, -1, 0, "-not selected-", "-not selected-", -1000000, -1, $top_level_bkgd_color_out, -1, $top_level_bkgd_opacity_out, $top_level_border_out, 
	0, $top_level_border_color_out,	$top_level_border_style_out, "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	$top_level_box_shadow_horizontal_out, $top_level_box_shadow_vertical_out, $top_level_box_shadow_blur_out, $top_level_box_shadow_spread_out, $top_level_box_shadow_color_out,
	$top_level_box_shadow_inset_out, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "query: $query<br><br>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l0oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l0oover" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l0oover" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, "-not selected-", "-not selected-", "-not selected-", -1,
	"px", "-not set-", -1, -1, -1, -1, 0, 0, 0, 0, "-not selected-", 0,	0, 0, 0, 0, 0,
	0, 0, 0, $top_level_no_text_dec_over, 0, "-not set-", 0,
	0, 0, -1, 0, "-not selected-", "-not selected-", -1000000, -1, $top_level_bkgd_color_over,  -1, -1, $top_level_border_over, 
	0, $top_level_border_color_over, $top_level_border_style_out, "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-",
	-1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	$top_level_box_shadow_horizontal_over, $top_level_box_shadow_vertical_over, $top_level_box_shadow_blur_over, $top_level_box_shadow_spread_over,
	$top_level_box_shadow_color_over, $top_level_box_shadow_inset_over, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");	
//	echo "query: $query<br><br>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l1iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l1iout" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l1iout" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, $sub_level_1_font_out, "-not selected-", "-not selected-", 
	$sub_level_1_font_size_out,	$sub_level_1_font_size_units_out,	
	$sub_level_1_text_color_out, $sub_level_1_padding_top_out, $sub_level_1_padding_right_out, $sub_level_1_padding_bottom_out, $sub_level_1_padding_left_out, 
	0, 0, 0, 0,	$sub_level_1_bold_out, $sub_level_1_italic_out, $sub_level_1_underline_out, $sub_level_1_overline_out, $sub_level_1_blink_out, 0, 
	0, 0, 0, 0, $sub_level_1_no_text_dec_out, $sub_level_1_shadow_out, $sub_level_1_shadow_color_out, $sub_level_1_shadow_x_offset_out,
	$sub_level_1_shadow_y_offset_out, $sub_level_1_shadow_blur_out, -1, 0, $sub_level_1_align, $sub_level_1_vertical_align, -1000000, -1, "-not set-", -1, -1, 
	0, 0, "-not set-",	"-not selected-", "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-",  "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	-1000000, -1000000, -1, -1000000, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l1iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l1iover" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l1iover" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, $sub_level_1_font_over, "-not selected-", "-not selected-", 
	$sub_level_1_font_size_over, $sub_level_1_font_size_units_over,
	$sub_level_1_text_color_over, $sub_level_1_padding_top_over, $sub_level_1_padding_right_over, $sub_level_1_padding_bottom_over, $sub_level_1_padding_left_over, 
	0, 0, 0, 0,	$sub_level_1_bold_over, $sub_level_1_italic_over, $sub_level_1_underline_over, $sub_level_1_overline_over, $sub_level_1_blink_over, 0, 
	0, 0, 0, 0, $sub_level_1_no_text_dec_over, $sub_level_1_shadow_over, $sub_level_1_shadow_color_over, $sub_level_1_shadow_x_offset_over,
	$sub_level_1_shadow_y_offset_over, $sub_level_1_shadow_blur_over, -1, 0, $sub_level_1_align, $sub_level_1_vertical_align, -1000000, -1, "-not set-", -1, -1, 
	0, 0, "-not set-",	"-not selected-", "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	-1000000, -1000000, -1, -1000000, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l1oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l1oout" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l1oout" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, "-not selected-", "-not selected-", "-not selected-", -1, 
	"px", "-not set-", -1, -1, -1, -1, 0, 0, 0, 0, "-not selected-", 0, 0, 0, 0, 0, 0,
	0, 0, 0, $sub_level_1_no_text_dec_out, 0, "-not set-", 0,
	0, 0, -1, 0, "-not selected-", "-not selected-", -1000000, -1, $sub_level_1_bkgd_color_out, -1, $sub_level_1_bkgd_opacity_out, $sub_level_1_border_out,
	0, $sub_level_1_border_color_out, $sub_level_1_border_style_out, "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	$sub_level_1_box_shadow_horizontal_out, $sub_level_1_box_shadow_vertical_out, $sub_level_1_box_shadow_blur_out, $sub_level_1_box_shadow_spread_out, 
	$sub_level_1_box_shadow_color_out, $sub_level_1_box_shadow_inset_out, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l1oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l1oover" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l1oover" . $suffix . "', ";
	}
		
		$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, "-not selected-", "-not selected-", "-not selected-", -1, 					
		"px", "-not set-", -1, -1, -1, -1, 0, 0, 0, 0, "-not selected-", 0,	0, 0, 0, 0, 0,
		0, 0, 0, $sub_level_1_no_text_dec_over, 0, "-not set-", 0,
		0, 0, -1, 0, "-not selected-", "-not selected-", -1000000, -1, $sub_level_1_bkgd_color_over, -1, -1, $sub_level_1_border_over, 
		0, $sub_level_1_border_color_over, $sub_level_1_border_style_out, "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
		0, -1000000, 0, 0, -1000000, 0, 0,
		"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
		-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
		"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
		0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
		$sub_level_1_box_shadow_horizontal_over, $sub_level_1_box_shadow_vertical_over, $sub_level_1_box_shadow_blur_over, $sub_level_1_box_shadow_spread_over, 
		$sub_level_1_box_shadow_color_over,	$sub_level_1_box_shadow_inset_over, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
		"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l2iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l2iout" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l2iout" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, $sub_level_2_font_out, "-not selected-", "-not selected-", 
	$sub_level_2_font_size_out, $sub_level_2_font_size_units_out,	
	$sub_level_2_text_color_out, $sub_level_2_padding_top_out, $sub_level_2_padding_right_out, $sub_level_2_padding_bottom_out, $sub_level_2_padding_left_out, 
	0, 0, 0, 0,	$sub_level_2_bold_out, $sub_level_2_italic_out, $sub_level_2_underline_out, $sub_level_2_overline_out, $sub_level_2_blink_out, 0, 
	0, 0, 0, 0, $sub_level_2_no_text_dec_out, $sub_level_2_shadow_out, $sub_level_2_shadow_color_out, $sub_level_2_shadow_x_offset_out,
	$sub_level_2_shadow_y_offset_out, $sub_level_2_shadow_blur_out, -1, 0, $sub_level_2_align, $sub_level_2_vertical_align, -1000000, -1, "-not set-", -1, -1, 
	0, 0, "-not set-",	"-not selected-", "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	-1000000, -1000000, -1, -1000000, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l2iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l2iover" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l2iover" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, $sub_level_2_font_over, "-not selected-", "-not selected-", 
	$sub_level_2_font_size_over, $sub_level_2_font_size_units_over,
	$sub_level_2_text_color_over, $sub_level_2_padding_top_over, $sub_level_2_padding_right_over, $sub_level_2_padding_bottom_over, $sub_level_2_padding_left_over, 
	0, 0, 0, 0,	$sub_level_2_bold_over, $sub_level_2_italic_over,
	$sub_level_2_underline_over, $sub_level_2_overline_over, $sub_level_2_blink_over, 0, 0,
	0, 0, 0, $sub_level_2_no_text_dec_over, $sub_level_2_shadow_over, $sub_level_2_shadow_color_over, $sub_level_2_shadow_x_offset_over,
	$sub_level_2_shadow_y_offset_over, $sub_level_2_shadow_blur_over, -1, 0, $sub_level_2_align, $sub_level_2_vertical_align, -1000000, -1, "-not set-", -1, -1, 
	0, 0, "-not set-",	"-not selected-", "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-", -1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	-1000000, -1000000, -1, -1000000, '', 0, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l2oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l2oout" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l2oout" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, "-not selected-", "-not selected-", "-not selected-", -1,
	"px", "-not set-", -1, -1, -1, -1, 0, 0, 0, 0, "-not selected-", 0,	0, 0, 0, 0, 0,
	0, 0, 0, $sub_level_2_no_text_dec_out, 0, "-not set-", 0,
	0, 0, -1, 0, "-not selected-", "-not selected-", -1000000, -1, $sub_level_2_bkgd_color_out, -1, $sub_level_2_bkgd_opacity_out, $sub_level_2_border_out, 
	0, $sub_level_2_border_color_out, $sub_level_2_border_style_out, "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-",
	-1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	$sub_level_2_box_shadow_horizontal_out, $sub_level_2_box_shadow_vertical_out, $sub_level_2_box_shadow_blur_out, $sub_level_2_box_shadow_spread_out, 
	$sub_level_2_box_shadow_color_out,
	$sub_level_2_box_shadow_inset_out, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '.m0l2oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if ($row_count > 0)
	{
		//Update class record.
		$verb = "UPDATE";
		$condition = "`class` = '.m0l2oover" . $suffix . "'";
		$insert_key = "";
	}
	else
	{
		//Insert new data into table.
		$verb = "INSERT INTO";
		$condition = "";
		$insert_key = "class='.m0l2oover" . $suffix . "', ";
	}
		
	$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, $verb, $condition, $insert_key, 1, "-not selected-", "-not selected-", "-not selected-", -1, 
	"px", "-not set-", -1, -1, -1, -1, 0, 0, 0, 0, "-not selected-", 0,	0, 0, 0, 0, 0,
	0, 0, 0, $sub_level_2_no_text_dec_over, 0, "-not set-", 0,
	0, 0, -1, 0, "-not selected-", "-not selected-", -1000000, -1, $sub_level_2_bkgd_color_over, -1, -1, $sub_level_2_border_over, 
	0, $sub_level_2_border_color_over,
	$sub_level_2_border_style_out, "-not selected-", "-not selected-", 15, -1000000, 0, 0, -1000000, 0,
	0, -1000000, 0, 0, -1000000, 0, 0,
	"-not selected-", -1, 0, "-not selected-", -1, 0, "-not selected-", "-not selected-", -1000000, 0, -1000000, 0,
	-1000000, 0, -1000000, 0, -1000000, "-not selected-", "-not selected-", "-not selected-",
	-1, 0, -1, 0, -1, 0, -1, 0,
	"-not selected-", "-not selected-", "-not selected-", "-not selected-", 0, 0,
	0, "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-", "-not selected-",
	$sub_level_2_box_shadow_horizontal_over, $sub_level_2_box_shadow_vertical_over, $sub_level_2_box_shadow_blur_over, $sub_level_2_box_shadow_spread_over, 
	$sub_level_2_box_shadow_color_over,
	$sub_level_2_box_shadow_inset_over, 0, 0, 0, 0, 0, 0, 0, 0, "-not selected-", "-not selected-", -1, 0, -1, 0,
	"-not selected-");
//	echo "$query<br/><br/>\n\n";
	try {
		$cnt = $bwb_dbh->exec($query);
	} catch (Exception $e) {
		echo JS_MENU_STYLES_ERROR_SAVING_RECORD_ERR . ': ',  $e->getMessage(), "\n";
	}
	
	/////////////////////////////////////////////
	// Build string for menu.css file /////
	$css_string = BuildCSSString(BWB_TABLE_PREFIX . $site_css_table, BWB_TABLE_PREFIX . $class_table, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX . "fonts");


	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo GENERATE_SITE_MAP_COULD_NOT_RENAME_1_ERR . " $file_name " . TO_WORD . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0755);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(UPLOAD_TEMPLATE_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0755);
	
	echo 1;
?>
