<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Completely re-engineered: 12/17/2010	ELL
// Revised: 1/9/2011	ELL
// Added ability to work with multiple JavaScript menus.
// Revised: 10/11/2011	ELL
// Added ability to handle URL unfriendly characters in menu-item text.
// Revised: 11/4/2011	ELL
// Discovered that menu_item class was missing . and added it.
// Revised: 2/10/2012	ELL
// Added table prefix handling.
// Revised: 3/1/2012	ELL
// Adding trimming of spaces to keep indent spaces from adding up and making display look whacky while editing.
// Revised: 10/15/2012	ELL
// Added link styles for each menu item to give more control.
// Added filtering of item text for & codes and storage of filtered results to `name` field.  This is to fix bug
// of 'name' attribute changing menu spacing when & codes are present.
// Revised: 5/14/2013	ELL
// Added URL escaping and unescaping of URL itself.
// Revised: 7/19/2015	ELL
// Fixed bug with saving mobile menu items.
//
//

	include ("check_session.php");
	include("lib/unescape_url.php");

	$menu = $_POST['menu'];
	$cnt = $_POST['cnt'];

	// Build item arrays from POST variables.
	$tmp = str_replace("_mobile", "", $menu);
	$suffix = substr($tmp, 4);
	if (strpos($menu, "_mobile") !== false)
		$mobile = "_mobile";
	else
		$mobile = "";
	$menu_items_table = "menu"  . $suffix . $mobile . "_items";
	$menu_item_classes_table = "menu"  . $suffix . $mobile . "_item_classes";
	
	for ($i = 0; $i < $cnt; $i++)
	{
		$item_text_str = "item_text" . $i;
		$level_str = "level" . $i;
		$URL_str = "URL" . $i;
		$target_str = "target" . $i;
		
		$item_text[$i] = $_POST[$item_text_str];
		$item_text[$i] = trim(UnescapeURL($item_text[$i]));
		$level[$i] = $_POST[$level_str];
		$URL[$i] = $_POST[$URL_str];
		$URL[$i] = trim(UnescapeURL($URL[$i]));
		$target[$i] = $_POST[$target_str];
		$sort_order[$i] = 10 * ($i + 1);
	}
	
	//Start by deleting all old data in table.
	$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . $menu_items_table;
	$cnt = $bwb_dbh->exec($query);
	
	$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . $menu_item_classes_table;
	$cnt = $bwb_dbh->exec($query);
	
	//Insert new data into table.
	for ($j = 0; $j < $i; $j++)
	{
		$name[$j] = $item_text[$j];
		$item_text[$j] = str_replace("'", "&#39;", $item_text[$j]);
		$item_text[$j] = str_replace("\"", "&quot;", $item_text[$j]);
//		$item_text[$j] = str_replace(chr(194), '&', $item_text[$j]);
//		$item_text[$j] = str_replace(chr(195), '&', $item_text[$j]);
//		$item_text[$j] = str_replace(chr(196), '&', $item_text[$j]);
//		$item_text[$j] = str_replace('&', 'AMPERSAND', $item_text[$j]);
//		$item_text[$j] = str_replace(';', 'SEMICOLON', $item_text[$j]);
		$item_text[$j] = addslashes($item_text[$j]);
		
		$level[$j]=addslashes($level[$j]);
		$URL[$j]=addslashes($URL[$j]);
		$target[$j]=addslashes($target[$j]);
		$name[$j] = str_replace("'", "", $name[$j]);
		$name[$j] = str_replace("\"", "", $name[$j]);
		$name[$j] = trim(str_replace(" ", "_", $name[$j]));
		$name[$j] = trim(str_replace("\\", "", $name[$j]));
		$pos1 = strpos($name[$j], "&");
		if ($pos1 !== false)	// Remove & codes from name.
		{
			$pos2 = strpos($name[$j], ";");
			if ($pos2 === false)
				$name[$j] = str_replace("&", "", $name[$j]);
			else
				$name[$j] = substr($name[$j], 0, $pos1) . substr($name[$j], ($pos2 + 1));
		}
		$k = $j + 1;
		$item_class = ".menu" . $suffix . "_item" . $k;
		$item_class_hover = $item_class . ":hover";
		$item_class_active = $item_class . ":active";
		$item_class_link = $item_class . " A";
		$item_class_link_visited = $item_class . " A:visited";
		$item_class_link_hover = $item_class . " A:hover";
		$item_class_link_active = $item_class . " A:active";
		$description = $item_text[$j];
		$description_hover = $description . " (Hover)";
		$description_active = $description . " (Active)";
		$description_link = $description . " (Link)";
		$description_link_visited = $description . " (Link:visited)";
		$description_link_hover = $description . " (Link:hover)";
		$description_link_active = $description . " (Link:active)";
		
		$nid = $j + 1;
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_items_table . " (ID, item_text, level, URL, target, `name`, sort_order) VALUES('".$nid."','".$item_text[$j]."','".$level[$j]."','".$URL[$j]."','".$target[$j]."','".$name[$j]."','".$sort_order[$j]."')";
		$cnt = $bwb_dbh->exec($query);
//		$debug .= $query . "<br><br>";
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class."','".$description."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class_hover."','".$description_hover."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class_active."','".$description_active."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class_link."','".$description_link."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class_link_visited."','".$description_link_visited."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class_link_hover."','".$description_link_hover."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . $menu_item_classes_table . " (class, description, sort_order, subclass_sort_order, custom) VALUES('".$item_class_link_active."','".$description_link_active."',".$j.",0,0)";
		$cnt = $bwb_dbh->exec($query);
	}
	
	////////////////////////////////////////////////////////////
	// Re-write menu_items.js with new references.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '$menu'";
	$result = $bwb_dbh->query($query);
	$row = $row = $result->fetch(PDO::FETCH_ASSOC);
	$menu_type = $row['menu_type'];
	if ($menu_type == 1)
		include("save_menu_items_file.php");
	// Re-write sitemap.xml for web crawlers.
	include("generate_site_map.php");
	
//	echo $debug;
	header("Location: populate_menu_items.php?menu=$menu");

?>
