<?php
// "mime_mail.inc"
// Generic MIME mailer module created by Ed Lemmers, Silver Dolphin Solutions, LLC.
// For licensing, see license.txt.
// This module has the capability of sending attachments and creating either htlm or text messages.
// Other header information has been broken out from the original module including html, cc and bc
// for easier usage.  The intent is to provide easy email creating and handling without any further
// customization of this module.

class mime_mail
{
   var $to;
   var $from;
   var $headers;
   var $subject;
   var $body;
   var $replyto;
   var $cc;
   var $bc;
   var $html;			// Set equal to something for html message.  Leave undefined for plain text.
   						// If plain text, the /n causes new line.  If html, then use <br> for new line.
						
   var $encode_type;	//Content Transfer Encoding:
   						// 1 -- "7bit"
						// 2 -- "quoted-printable"
						// 3 -- "base64"
						// 4 -- "8bit"
						// 5 -- "binary"
						// 0 or not set -- server default.
	
	var $no_mime;		// Some mail servers such as GoDaddy don't support mime.
	var $name;			// Name of file if adding attachment.
	var $octet_stream;	// Overrides HTML.  Use for adding attachments.
	var $attachment;	// Data to be sent as binary attachment.
	

   /*
    *     void mime_mail()
    *     class constructor
    */

   function mime_mail() {
      $this->to =  "";
      $this->from =  "";
      $this->subject =  "";
      $this->body =  "";
      $this->headers =  "";
	  $this->replyto =  "";
	  $this->cc =  "";
	  $this->bc =  "";
	  $this->html =  "";
	  $this->encode_type = "";
	  $this->no_mime = "";
	  $this->name = "";
	  $this->octet_stream = "";
	  $this->attachment = array();
   }
   
   /*
    *     get_attachment()
    *     Add an attachment to the mail object
    */

   function get_attachment($attachment) {
   		$file = $attachment;
		$file_size = filesize($file);
		$handle = fopen($file, "r");
		$content = fread($handle, $file_size);
		fclose($handle);
		$content = chunk_split(base64_encode($content));
		return $content;
   }
   
   /*
    *	build_header()
	*/
	
	function build_header()	{
		$msg_params = "";
		// a random hash will be necessary to send mixed content
    	$separator = md5(time());
    	// carriage return type (we use a PHP end of line constant)
    	$eol = PHP_EOL;

		if (!empty($this->from))
			$msg_params .=  "From: " . $this->from . $eol;
		if (!empty($this->replyto))
			$msg_params .=  "Reply-To: " . $this->replyto . $eol; 
		if (!empty($this->cc))
			$msg_params .= "CC: " . $this->cc . $eol;
		if (!empty($this->bc))
			$msg_params .= "BC: " . $this->bc . $eol;
		if (!empty($this->headers))
			$msg_params .= $this->headers . $eol;
		 
		if (($this->no_mime != 1) || (!empty($this->attachment)))
		{
			$this->headers = $msg_params;
			$pre = 'MIME-Version: 1.0' . $eol;
			if (!empty($this->attachment))	{
				// main header (multipart mandatory)
				$this->headers .= "Content-Type: multipart/mixed; boundary=\"" . $separator . "\"" . $eol;
				
				// message
				$this->headers .= "--" . $separator . $eol;
				if ($this->html)
					$this->headers .= "Content-Type: text/html; charset=\"iso-8859-1\"" . $eol;
				else
					$this->headers .= "Content-Type: text/plain; charset=\"iso-8859-1\"" . $eol;
//				$this->headers .= "Content-Type: text/plain; charset=\"UTF-8\"" . $eol;
//				$this->headers .= "Content-Transfer-Encoding: 8bit" . $eol;
				$this->headers .= "Content-Transfer-Encoding: 7bit" . $eol;
				$this->headers .= $this->body . $eol;
				
				// attachment
				foreach($this->attachment as $attachment)
				{
					$this->headers .= "--" . $separator . $eol;
					$filename_parts = explode("/", $attachment);
					$filename = $filename_parts[count($filename_parts) - 1];
					$this->headers .= "Content-Type: application/octet-stream; name=\"" . $filename . "\"" . $eol;
					if (!isset($this->encode_type) || ($this->encode_type == 0))
						$encoding =  "base64";
					elseif ($this->encode_type == 1)
						$encoding = "7bit";
					elseif ($this->encode_type == 2)
						$encoding =  "quoted-printable";
					elseif ($this->encode_type == 3)
						$encoding =  "base64";
					elseif ($this->encode_type == 4)
						$encoding =  "8bit";
					elseif ($this->encode_type == 5)
						$encoding =  "binary";
					else
						$encoding =  "base64";
					$this->headers .= "Content-Transfer-Encoding: " . $encoding . $eol;
	//				$this->headers .= "Content-Disposition: attachment" . $eol;
					$this->headers .= "Content-Disposition: attachment; filename=\"" . $filename . "\"" . $eol;
					$this->headers .= $this->get_attachment($attachment) . $eol;
				}
				$this->headers .= "--" . $separator . "--";
			}
			elseif ($this->html)
				$pre .= 'Content-type: text/html; charset=iso-8859-1' . $eol;
			else
				$pre .= 'Content-type: text/plain; charset=iso-8859-1' . $eol;
			$this->headers = $pre . $this->headers;
		}
		else
			$this->headers = $msg_params;
	}
	

   /*
    *      void send()
    *      Send the mail (last class-function to be called)
    */

   function send() {
   		$this->build_header();
		if (!empty($this->attachment))
			mail($this->to, $this->subject, "", $this->headers);
		else
			mail($this->to, $this->subject, $this->body, $this->headers);
   }
};  // end of class

?>
