/////////////////////////////////////////////
// Change Password /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2016	ELL
//
function ReadGetVar(variable)
{
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
	   var pair = vars[i].split("=");
	   if(pair[0] == variable)	{
		   return pair[1];
	   }
	}
	return("");
}

function replaceAll(txt, search_str, replace_str) {
	return txt.replace(new RegExp(search_str, 'g'),replace_str);
}

//////////////////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{
	var php_path_rel = php_dir_rel + "change_password.php";
	if (document.getElementById("frmChangePasswordForm").action == "")
		document.getElementById("frmChangePasswordForm").action = php_path_rel;
	
	var redirect_path = document.getElementById("redirect").value;
	if (redirect_path == "")
		redirect_path = redirect;
	var redirect_path_arr = redirect_path.split("/");
	var redirect_file = "";
	for(var i in redirect_path_arr)
	{
		if ((redirect_path_arr[i].indexOf(".php")) > 0)
			redirect_file = redirect_path_arr[i];
	}
	redirect_path = webpage_dir + redirect_file;
	document.getElementById("redirect").value = redirect_path;
	
	var alt_go_back = webpage_dir + this_page;
	if (document.getElementById("alt_go_back").value == "")
		document.getElementById("alt_go_back").value = alt_go_back;
	
	if (document.getElementById("user_table").value == "")
		document.getElementById("user_table").value = user_table;
	document.getElementById("UserID").value = userid;
	
	// Go thru all forms and get all elements and check for go-back values to re-populate.
	var frm_cnt = document.forms.length;
	var el_cnt = 0;
	var el;
	var tmp;
	for (i = 0; i < frm_cnt; i++)
	{
		el_cnt = document.forms[i].elements.length;
		for (j = 0; j < el_cnt; j++)
		{
			el = document.forms[i].elements[j];
			if ((el.type == "text") && (el.name != "password") && (el.name != "password_confirm"))	{
				tmp = ReadGetVar(el.name);
				el.value = replaceAll(tmp, "%20", " ");
				// Special patch for email_confirm.
				if (el.name == "email_confirm")	{
					var tmperr = ReadGetVar("err");
					if(tmperr != "email")	{
						tmp = ReadGetVar("email");
						el.value = replaceAll(tmp, "%20", "");
					}
				}
			}
			else if (el.type == "textarea")	{
				tmp = ReadGetVar(el.name);
				el.innerHTML = replaceAll(tmp, "%20", " ");
			}
			else if (el.type == "checkbox")	{
				if (ReadGetVar(el.name) != "")
					el.checked = true;
			}
			else if ((el.type == "select-one") || (el.type == "select-multiple"))	{
				tmp = ReadGetVar(el.name);
				el.value = replaceAll(tmp, "%20", " ");
			}
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////
	var err = ReadGetVar("err");
	
	if ((err != undefined) && (err != ""))
	{
		if (err == "too_short")	{
			var password_length = ReadGetVar("password_length");
			document.getElementById("password_length").innerHTML = password_length;
			document.getElementById("ErrTooShort").style.display = "block";
			document.getElementById("password").focus();
			document.getElementById("password").className = "field_highlight";
		}
		else if (err == "too_weak") {
			var password_strength = ReadGetVar("password_strength");
			if (password_strength == "medium")
				document.getElementById("password_strength").innerHTML = "Please fill in a password contaning both letters and numbers.";
			else
				document.getElementById("password_strength").innerHTML = "Please fill in a password contaning letters, numbers and symbols.";
			document.getElementById("ErrTooWeak").style.display = "block";
			document.getElementById("password").focus();
			document.getElementById("password").className = "field_highlight";
		}
		else if (err == "no_match")	{
			document.getElementById("ErrNoMatch").style.display = "block";
			document.getElementById("password").focus();
			document.getElementById("password").className = "field_highlight";
			document.getElementById("password_confirm").className = "field_highlight";
		}
		else if (err == "no_error")	{
			document.getElementById("ErrSuccess").style.display = "block";
			document.getElementById("frmChangePasswordForm").style.display = "none";
		}
	}
}