/////////////////////////////////////////////
// Mail Contact Form /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2016	ELL
//
function ReadGetVar(variable)
{
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
	   var pair = vars[i].split("=");
	   if(pair[0] == variable)	{
		   return pair[1];
	   }
	}
	return("");
}

function replaceAll(txt, search_str, replace_str) {
	return txt.replace(new RegExp(search_str, 'g'),replace_str);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{ 
	var php_path_rel = php_dir_rel + "formmail.php";
	if ((login_required === false) || (logged_in === true))	{
		if (document.getElementById("frmMailForm").action == "")
			document.getElementById("frmMailForm").action = php_path_rel;
	}
	
	var redirect_path = document.getElementById("redirect").value;
	if (redirect_path == "")
		redirect_path = redirect;
	var redirect_path_arr = redirect_path.split("/");
	var redirect_file = "";
	for(var i in redirect_path_arr)
	{
		if ((redirect_path_arr[i].indexOf(".php")) > 0)
			redirect_file = redirect_path_arr[i];
	}
	redirect_path = webpage_dir + redirect_file;
	document.getElementById("redirect").value = redirect_path;
	
	var alt_go_back = webpage_dir + this_page;
	if (document.getElementById("alt_go_back").value == "")
		document.getElementById("alt_go_back").value = alt_go_back;
		
	document.getElementById("recaptcha_row").style.display = "none";
	document.getElementById("recaptcha2_row").style.display = "none";
	document.getElementById("wscaptcha_row").style.display = "none";
	document.getElementById("mollomcaptcha_row").style.display = "none";
	if (document.getElementById("use_captcha").value == 1)
	{
		if (document.getElementById("captcha_type").value == "recaptcha")
			document.getElementById("recaptcha_row").style.display = "table-row";
		else if (document.getElementById("captcha_type").value == "recaptcha2")
	        document.getElementById("recaptcha2_row").style.display = "table-row";
		else if (document.getElementById("captcha_type").value == "wscaptcha")
			document.getElementById("wscaptcha_row").style.display = "table-row";
		else if (document.getElementById("captcha_type").value == "mollom")
			document.getElementById("mollomcaptcha_row").style.display = "table-row";
	}
	
	// Go thru all forms and get all elements and check for go-back values to re-populate.
	var frm_cnt = document.forms.length;
	var el_cnt = 0;
	var el;
	for (i = 0; i < frm_cnt; i++)
	{
		el_cnt = document.forms[i].elements.length;
		for (j = 0; j < el_cnt; j++)
		{
			el = document.forms[i].elements[j];
			if ((el.type == "text") && (el.name != "password") && (el.name != "password_confirm"))	{
				tmp = ReadGetVar(el.name);
				el.value = replaceAll(tmp, "%20", " ");
				// Special patch for email_confirm.
				if (el.name == "email_confirm")	{
					var tmperr = ReadGetVar("err");
					if(tmperr != "email")	{
						tmp = ReadGetVar("email");
						el.value = replaceAll(tmp, "%20", "");
					}
				}
			}
			else if (el.type == "textarea")	{
				tmp = ReadGetVar(el.name);
				el.innerHTML = replaceAll(tmp, "%20", " ");
			}
			else if (el.type == "checkbox")	{
				if (ReadGetVar(el.name) != "")
					el.checked = true;
			}
			else if ((el.type == "select-one") || (el.type == "select-multiple"))	{
				tmp = ReadGetVar(el.name);
				el.value = replaceAll(tmp, "%20", " ");
			}
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////////////////
	var err = ReadGetVar("err");
	var field;

	if ((err != undefined) && (err != ""))
	{
		if (err == "required")	{
			document.getElementById("ErrRequired").style.display = "block";
			field = ReadGetVar("field");
			document.getElementById(field).focus();
			document.getElementById(field).className = "field_highlight";
		}
		else if(err == "email")	{
			document.getElementById("ErrEmail").style.display="block";
			document.getElementById("email").focus();
			document.getElementById("email").className = "field_highlight";
			document.getElementById("email_confirm").className = "field_highlight";
		}
		else if(err == "bad_email")	{
			document.getElementById("ErrBadEmail").style.display="block";
			document.getElementById("email").focus();
			document.getElementById("email").className = "field_highlight";
		}
		else if(err == "duplicate")	{
			document.getElementById("ErrDuplicate").style.display="block";
			field = ReadGetVar("field");
			document.getElementById(field).focus();
			document.getElementById(field).className = "field_highlight";
		}
		else if(err == "captcha")	{
			document.getElementById("ErrCaptcha").style.display="block";
			var captcha_type = document.getElementById("captcha_type").value;
			if (captcha_type == "recaptcha")
				document.getElementById("recaptcha_td").className = "field_highlight";
			else  if (captcha_type == "recaptcha2")
				document.getElementById("recaptcha2_td").className = "field_highlight";
			else if (captcha_type == "wscaptcha")
				document.getElementById("wsp_code").className = "field_highlight";
			else if (captcha_type == "mollom")
				document.getElementById("captcha_response_field").className = "field_highlight";
		}
		else if(err == "file_size")	{
			document.getElementById("ErrFileSize").style.display="block";
			document.getElementById("upload_file").focus();
			document.getElementById("upload_file").className = "field_highlight";
		}
		else if(err == "file_type")	{
			document.getElementById("ErrFileType").style.display="block";
			document.getElementById("upload_file").focus();
			document.getElementById("upload_file").className = "field_highlight";
		}
		else if(err == "upload")	{
			document.getElementById("ErrUpload").style.display="block";
			document.getElementById("upload_file").focus();
			document.getElementById("upload_file").className = "field_highlight";
		}
	}
}