<!--
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/30/2013	ELL
-->
<!DOCTYPE html>
<html>
  <head>
    <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
    <title>Breeze Website Builder Install</title>
    <link type="text/css" href="/manage/theme/classic/manager.css" rel="stylesheet" />
    <link type="image/x-icon" href="/manage/images/favicon.ico" rel="shortcut icon" />
    
    <style>
	.requires_input	{
		border-style:solid;
		border-color:#FFFF00;
		border-width:medium;
	}
	.usually_requires_input	{
		border-style:solid;
		border-color:#00FFFF;
		border-width:medium;
	}
	.may_require_input	{
		border-style:solid;
		border-color:#000066;
		border-width:medium;
	}
	p	{
		margin-left:10px;
		margin-right:10px;
	}
    </style>
    <script>
	function Initialize()
	{
		GenerateSalts();
		var prefix = GeneratePrefix('table_prefix');
		if (prefix != "bwb_")
		{
<?php
	$search_error = false;
	try	{
		$sql = file_get_contents("../SQL/database.sql");
	} catch (Exception $e) {
		unset($e);
		$search_error = true;
	}
	if (!$search_error)
	{
		$sql = strip_tags($sql);
		$bad_chars = array("\"", "\n", "\r", "'");
		$sql = str_replace($bad_chars, "", $sql);
		echo "	var sql = \"" . $sql . "\";\n";
?>
			if (sql.indexOf(prefix) > -1)
				document.getElementById('table_prefix').value = 'bwb_';
<?php
	}
	else
		echo "	document.getElementById('table_prefix').value = 'bwb_';\n";
?>
		}
	}
	
	function GeneratePassword(ele_id)
	{
		var password = "";
		var password_length = rand(6,10);
		var i;
		var assci_segment;
		
		for (i = 0; i < password_length; i++)
		{
			assci_segment = rand(1,3);
			if (assci_segment == 1)
				password = password + String.fromCharCode(rand(48,57));	// numeric
			else if (assci_segment == 2)
				password = password + String.fromCharCode(rand(65,90));	// alpha upper case
			else
				password = password + String.fromCharCode(rand(97,122));	// alpha lower case
		}
		password = password.replace('I', 'i');
		password = password.replace('O', 'o');
		password = password.replace('l', 'L');
		
		var frm_obj = document.getElementById(ele_id);
			
		frm_obj.value = password;
			
		return password;
	}
	
	// Equivalent to PHP rand(min, max);
	function rand ( n, m )
	{
	  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );
	}
	
	function GenerateSalts()
	{
		GeneratePassword('user_salt');
		GeneratePassword('public_salt');
	}

	function OpenHelpWindow()
	{
		window.open("http://breezewebsitebuilder.com/docs/cms/help.html#install", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
	}
	
	function GeneratePrefix(ele_id)
	{
		var prefix = "";
		var prefix_length = rand(3,4);
		var i;
		var assci_segment;
		
		for (i = 0; i < prefix_length; i++)
		{
			assci_segment = rand(1,4);
			if (assci_segment == 1)
				prefix = prefix + String.fromCharCode(rand(48,57));	// numeric
			else
				prefix = prefix + String.fromCharCode(rand(97,122));	// alpha lower case
		}
		prefix = prefix + "_";
		
		var frm_obj = document.getElementById (ele_id);
			
		frm_obj.value = prefix;
			
		return prefix;
	}
	
	</script>
  </head>
<body onLoad="Initialize();">
    <div align="center" id="login_logo"><img alt="Breeze Website Builder" src="/manage/theme/classic/images/Breeze_header_logo.png" /></div>
  <div id="header_divider_login"> </div>
    <p>Thank you for downloading the Breeze™ Website Builder. If you are reading
      this page from your computer, you have successfully unzipped the Breeze™
      Website Builder files, but you will need to FTP all of the extracted
      files to the web root of your hosting account. Your web server will need
      to be running <strong>PHP 5 or later</strong>, and <strong>MySQL 5 or
        later</strong>. Then go to <strong>http://<em>mydomain.com</em>/install/install.php</strong>
      (where <em>mydomain.com</em> is your domain name) to access this page. If
      you are already viewing this page from your hosting account, you are
      almost ready to go. You will need to <strong>create a database</strong>
      and a <strong>database user with read and write privileges</strong> to
      that database before your can continue. Please do that first
      before continuing. If you have already created a database,
    enter the information requested below. The fields that you need to fill in are <span class="requires_input" style="padding-left:5px; padding-right:5px;">highlighted</span>. Typically, you will need to fill in the <span class="usually_requires_input" style="padding-left:5px; padding-right:5px;">database prefix</span>, but not always. If your database is running on a different server from your website server, you will need to provide the IP address or server name of your <span class="may_require_input" style="padding-left:5px; padding-right:5px;">database server</span>. You may leave the default values in the other fields.</p>
    <form action="do_install.php" method="post" name="form1" id="form1">
      <table align="center" width="90%" border="0">
        <tbody>
          <tr>
            <td><span class="sub_title">Database Server (Host): </span></td>
            <td><input type="text" value="localhost" id="db_server" name="db_server" class="may_require_input" /></td>
            <td width="50%"> <span class="medium_message">Leave as <em>localhost</em> if
                running off of the same server that your website is hosted on.
                Otherwise enter IP or server name of database server.</span> </td>
          </tr>
          <tr>
            <td><span class="sub_title">Database Prefix: </span></td>
            <td><input type="text" id="db_prefix" name="db_prefix" class="usually_requires_input" /></td>
            <td><span class="medium_message">On many servers including CPanel
                servers the database and the database username will be prefixed
                by the CPanel or hosting account
                name. For CPanel hosting, this is usually the first 8 characters
                of your domain name. This prefix will be prepended to both the database name and the username.</span></td>
          </tr>
          <tr>
            <td><span class="sub_title">Database: </span></td>
            <td><input type="text" id="db_name" name="db_name" class="requires_input" /></td>
            <td> </td>
          </tr>
          <tr>
            <td><span class="sub_title">Database User: </span></td>
            <td><input type="text" id="db_user" name="db_user" class="requires_input" /></td>
            <td class="medium_message">(Must have read and write privileges to
              the database)</td>
          </tr>
          <tr>
            <td><span class="sub_title">Password: </span></td>
            <td><input type="text" id="db_password" name="db_password" class="requires_input" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Table Prefix: </span></td>
            <td><input type="text" id="table_prefix" name="table_prefix" value="bwb_" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td colspan="3"> </td>
          </tr>
          <tr>
            <td><span class="sub_title">Base Website Folder: </span></td>
            <td><input type="text" id="base_website_folder" name="base_website_folder" /></td>
            <td class="medium_message">(Starting from web root)</td>
          </tr>
          <tr>
            <td><span class="sub_title">Web Page Folder: </span></td>
            <td><input type="text" id="files" name="files" /></td>
            <td class="medium_message">Leave <em>Base Website Folder</em> and <em>Web Page Folder</em> blank to have pages at web root.</td>
          </tr>
          <tr>
            <td><span class="sub_title">Images Folder: </span></td>
            <td><input type="text" id="images" name="images" value="images" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Media Folder: </span></td>
            <td><input type="text" id="medai" name="media" value="media" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Flash Folder: </span></td>
            <td><input type="text" id="flash" name="flash" value="flash" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">CSS Folder: </span></td>
            <td><input type="text" id="css" name="css" value="css" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Scripts Folder: </span></td>
            <td><input type="text" id="scripts" name="scripts" value="scripts" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Fonts Folder: </span></td>
            <td><input type="text" id="fonts" name="fonts" value="fonts" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td colspan="3">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Admin Password: </span></td>
            <td>
            <input type="text" id="admin_password" name="admin_password" class="requires_input" />
            <input type="button" name="generate_password" value="Generate Password" onClick="GeneratePassword('admin_password');">
            </td>
            <td class="medium_message">Use a strong password of at least 8 characters. (Password for user account <em>admin</em>)</td>
          </tr>
          <tr>
            <td><span class="sub_title">Require SSL: </span></td>
            <td><input type="checkbox" name="require_ssl" id="require_ssl" /></td>
            <td class="medium_message">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Session Save Path: </span></td>
            <td><input type="text" name="session_save_path" id="session_save_path" value="/tmp" /></td>
            <td class="medium_message">This field is ignored unless the session save path is not defined on your server.</td>
          </tr>
          <tr>
            <td colspan="3">&nbsp;</td>
          </tr>
          <tr>
            <td><span class="sub_title">Email: </span></td>
            <td><input type="text" name="email" id="email" style="width:200px;" class="requires_input" /></td>
            <td class="medium_message">Email for password reset.</td>
          </tr>
          <tr>
            <td><span class="sub_title">Name: </span></td>
            <td>
            	<input type="text" name="first_name" id="first_name" style="width:130px;" />
                <input type="text" name="last_name" id="last_name" />
            </td>
            <td class="medium_message">(first last)</td>
          </tr>
          
          <tr>
            <td><span class="sub_title">Language: </span></td>
            <td>
            	<select name="language" id="language">
<?php
	$languages = array();
	$path = "languages.txt";
	$fh = fopen($path, "r");
	$contents = fread($fh, filesize($path));
	fclose($fh);
	
	$rows = explode("\n", $contents);
	foreach($rows as $row)
	{
		$lang_pair = explode(";", $row);
		$lang_pair[0] = trim($lang_pair[0]);
		$lang_pair[1] = trim($lang_pair[1]);
		$languages[] = $lang_pair;
	}
	foreach($languages as $language)
	{
		if ($language[0] == "en")
			$selected = " selected='selected'";
		else
			$selected = "";
		echo "		<option value='" . $language[0] . "'" . $selected . ">" . $language[1] . "</option>\n";
	}
?>
                </select>
            </td>
            <td class="medium_message">Laguage used for management side.</td>
          </tr>
          
          
          <tr>
          	<td colspan="2" align="right">
           	  <input type="hidden" id="user_salt" name="user_salt" value="ouik(*()66?OEUoo7" />
              <input type="hidden" id="public_salt" name="public_salt" value="Thoc76@+-zgwgww" />
            	<input type="submit" name="submit" id="sumbit" value="Continue" />
            </td>
            <td align="right">
            	<div id="help_button_sm" class="help_button" onClick="OpenHelpWindow();">&nbsp;</div>
            </td>
          </tr>
        </tbody>
      </table>
    </form>
</body>
</html>
