<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 8/18/09	ELL
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 7/29/2014	ELL
// Converted save functions to JQuery AJAX operations.
// Revised: 10/19/2014	ELL
// Converted editor for simple text area to CKEditor is source view.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Revised: 1/22/2015	ELL
// Updated CKEditor from version 4.4.5 to version 4.4.6.
// Revised: 11/10/2016	ELL
// Modified custom CSS editing to allow for any number of custom CSS records associated with custom style sheets.
// 
//
	include ("check_session.php");
		
	$style_sheet = $_REQUEST['style_sheet'];
	
	if (BWB_BASE_DIR == '')
		$path = "../" . BWB_WEBPAGE_DIR . "/index.php";
	else
		$path = "../" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/index.php";
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "options_selected WHERE option_name='CodeMirrorTheme'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))	{
		$CodeMirrorTheme = $row['option_value'];
		if (strpos($CodeMirrorTheme, "solarized") !== false)
			$CodeMirrorCSS = "solarized";
		else
			$CodeMirrorCSS = $row['option_value'];
	}
	else	{
		$CodeMirrorTheme = "rubyblue";
		$CodeMirrorCSS = "rubyblue";
	}	
?>
<html>
<head>
<title>Custom <?php echo $style_sheet; ?> CSS - Editing | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="../ckeditor/plugins/codemirror/theme/<?php echo $CodeMirrorCSS; ?>.css">

<script type="text/javascript" src="js/jquery.min.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/edit_custom_css.js"></script>
<script language="javascript" type="text/javascript" src="../ckeditor/ckeditor.js"></script>

<script>
	var style_sheet = "<?php echo $style_sheet; ?>";
	var saved = true;
	var browser = BrowserDetect.browser;
	var browser_version = BrowserDetect.version;
	
<?php
	echo "	var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "	var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
	echo "	var EDITOR_REVERT_CSS_CONFIRM_1_MSG = \"" . EDITOR_REVERT_CSS_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_REVERT_CSS_CONFIRM_2_MSG = \"" . EDITOR_REVERT_CSS_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_REVERTING_MSG = \"" . EDITOR_REVERTING_MSG . "\";\n";
	echo "	var EDITOR_REVERT_COMPLETE_MSG = \"" . EDITOR_REVERT_COMPLETE_MSG . "\";\n";
	echo "	var EDITOR_REVERT_ERR = \"" . EDITOR_REVERT_ERR . "\";\n";
	echo "	var EDITOR_CSS_NOT_SAVED_MSG = \"" . EDITOR_FILE_NOT_SAVED_MSG . "\";\n";
	echo "	var SAVE_AS_WORD = \"" . SAVE_AS_WORD . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var CANCEL_WORD = \"" . CANCEL_WORD . "\";\n";
?>
</script>

</head>

<body id="workspace_body">
<div style='text-align:center;'>

   <form action="save_custom_css.php" method="post" enctype="multipart/form-data" name="frm_site_styles" id="frm_site_styles">
    
     <div style="height:93%; width:100%;" id="editorContainer" name="editorContainer"></div>

	<script type="text/javascript" language="javascript">
    //<![CDATA[
		CKEDITOR_BASEPATH = '../ckeditor/';
		
		CKEDITOR.replace( 'editorContainer', { contentsCss : ['/ckeditor/contents.css'] });

		CKEDITOR.config.language = '<?php echo BWB_LANG; ?>';
		CKEDITOR.config.extraPlugins = 'codemirror';
		CKEDITOR.config.skin = 'kama';
		CKEDITOR.config.allowedContent = true;
		
		CKEDITOR.config.toolbarGroups = [
    { name: 'document',    groups: [ 'mode', 'document', 'doctools' ] },
    { name: 'editing',     groups: [ 'find', 'selection' ] },
    { name: 'tools' },
    { name: 'others' },
    { name: 'about' }
];
		
	CKEDITOR.config.removePlugins = 'newpage,print,templates,showblocks';
	CKEDITOR.config.removeButtons = 'Source';
	
	var editorElem = document.getElementById("editorContainer");
	CKEDITOR.config.width = '99%';

	if ((browser == "Explorer") && (browser_version <= 7))
		CKEDITOR.config.height = document.body.clientHeight - 164;
	else if ((browser == "Opera") && (browser_version < 13))
		CKEDITOR.config.height = window.innerHeight - 139;
	else if ((browser == "Explorer") && (browser_version == 8))
		CKEDITOR.config.height = document.body.clientHeight - 139;
	else
		CKEDITOR.config.height = editorElem.clientHeight - 69;
	CKEDITOR.config.resize_enabled = false;

	CKEDITOR.config.startupMode = 'source';

	CKEDITOR.config.codemirror = {
		 // Set this to the theme you wish to use (codemirror themes)
		theme: '<?php echo $CodeMirrorTheme; ?>',
		// Whether or not you want Brackets to automatically close themselves
		autoCloseBrackets: true,
		 // Whether or not you want tags to automatically close themselves
		autoCloseTags: true,
		 // Whether or not to automatically format code should be done when the editor is loaded
		autoFormatOnStart: true, 
		// Whether or not to automatically format code which has just been uncommented
		autoFormatOnUncomment: true,
		// Whether or not to continue a comment when you press Enter inside a comment block
		continueComments: true,
		 // Whether or not you wish to enable code folding (requires 'lineNumbers' to be set to 'true')
		enableCodeFolding: true,
		// Whether or not to enable code formatting
		enableCodeFormatting: true,
		// Whether or not to enable search tools, CTRL+F (Find), CTRL+SHIFT+F (Replace), CTRL+SHIFT+R (Replace All), CTRL+G (Find Next), CTRL+SHIFT+G (Find Previous)
		enableSearchTools: true,
		// Whether or not to highlight all matches of current word/selection
		highlightMatches: true,
		 // Whether, when indenting, the first N*tabSize spaces should be replaced by N tabs
		indentWithTabs: false,
		 // Whether or not you want to show line numbers
		lineNumbers: true,
		// Whether or not you want to use line wrapping
		lineWrapping: true,
		 // Define the language specific mode 'htmlmixed' for html  including (css, xml, javascript), 'application/x-httpd-php' for php mode including html, or 'text/javascript' for using java script only 
		mode: 'text/css',
		// Whether or not you want to highlight matching braces
		matchBrackets: true,
		// Whether or not you want to highlight matching tags
		matchTags: true,
		// Whether or not to show the showAutoCompleteButton   button on the toolbar
		showAutoCompleteButton: true,
		 // Whether or not to show the comment button on the toolbar
		showCommentButton: true,
		// Whether or not to show the format button on the toolbar
		showFormatButton: true,
		 // Whether or not to show the search Code button on the toolbar
		showSearchButton: true,
		 // Whether or not to show Trailing Spaces
		showTrailingSpace: true,
		// Whether or not to show the uncomment button on the toolbar
		showUncommentButton: true,
		 // Whether or not to highlight the currently active line
		styleActiveLine: true,
		// "Whether or not to use Beautify for auto formatting
		useBeautify: false
	};
		
	var bwb_ckeditor = CKEDITOR.instances['editorContainer'];

	function somethingChanged()	{
		if ( bwb_ckeditor.checkDirty() && !lockoutChangeCheck )
		{
			saved = false;
			window.parent.SetWorkSavedNotSaved(saved);
			try	{
				bwb_ckeditor.commands.save.enable();
			}
			catch(err)	{
				err = 0;
			}
		}
	}

	function somethingHappened(e)	{
//			alert(e.data.name);
		if ( bwb_ckeditor.checkDirty() && !lockoutChangeCheck )
			window.parent.SetWorkSavedNotSaved(true);
			
		if (e.data.name == "newpage")
		{
			e.data.command = null;
			//ClearContent();
		}
		else if (e.data.name == "preview")
		{
			e.data.command = null;
			Save('Preview');
		}
		else if (e.data.name == "save")
		{
			e.data.command = null;
			Save('Update');
			try	{
				bwb_ckeditor.commands.save.disable();
			}
			catch(err)	{
				err = 0;
			}
			bwb_ckeditor.resetDirty();
		}
		else if (e.data.name == "source")
		{
			e.data.command = null;
		}
	}
	
	bwb_ckeditor.on( 'saveSnapshot', function(e) { somethingChanged(); });
	bwb_ckeditor.on( 'beforeCommandExec', function(e) { somethingHappened(e); });
	
//]]>
</script>
	   
   <table width="90%" border="0" cellspacing="0" cellpadding="0" id="btn_table">
	 <tr>
	 <td align="left" class="small_message" width="9%">
	  <span id="page_name_label"><?php echo EDITOR_STYLE_SHEET; ?>:<br /><?php echo $style_sheet; //echo $custom_site_css_table; ?></span>
	 </td>
	 <td align="center">
		<div class='button_console_preview' style="width:110px;" onClick="PreviewPageSelect();"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
	  </td>
	   <td align="center">
		<div class='button_console_save' style="width:110px;" onClick="Save('Save');"><span class='button_console_text_w_icon'><?php echo EDITOR_SAVE; ?></span></div>
	   </td>
	   <td align="center">
		<div class='button_console_save' style="width:110px;" onClick="Save('Publish');"><span class='button_console_text_w_icon'><?php echo EDITOR_PUBLISH; ?></span></div>
	   </td>
	   <td align="center">
		<div class='button_console_cancel' style="width:110px;" onClick="RevertConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_REVERT; ?></span></div>
	   </td>
	   <td align="center">
		<div class='button_console_preview' style="width:110px;" onClick="window.open('<?php echo $path; ?>', '_blank');"><span class='button_console_text_w_icon'><?php echo EDITOR_SEE_SITE; ?></span></div>
	   </td>
       <td align="center" style="min-width:100px;">
      <div class='button_console_back_sm' style="width:140px;" onClick="window.location='edit_css_select.php';"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_BACK_TO_SELECT; ?></span></div>
      </td>
		<td align="right" width="10%"><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></td>
	 </tr>
   </table>
   </form>

</div>

<div id="page_select_div" style="display:none;">
<?php echo EDIT_CSS_SELECT_PAGE_FOR_PREVIEW; ?>:<br />
<select id="page_select" onChange="Preview(this.value, 0);">
<?php
	$query = "SELECT page_name FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "		<option value='$page_name'>$page_name</option>\n";
	}
?>
</select>
<div id="preview_go" onClick="Preview(document.getElementById('page_select').value, 0);">&nbsp;</div>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
	mTimer3 = setTimeout("LoadCSS();", 1000);
	
	if (document.body.scrollWidth > document.body.clientWidth)
		CKEDITOR.config.height = CKEDITOR.config.height - 30;
</script>

</body>
</html>