/////////////////////////////////////////////
// Add Plugin To Page Select /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2014	ELL
// Modified: 10/15/2014	ELL
// Added grouping of plugins by category and sub categories.
// Modified: 11/9/2014	ELL
// Fix bugs with not being able to select plugin.
// Modified: 10/6/2017	ELL
// Fixed bug with sub categories that have no plugins display div of next sub category.
// Added message on where to get plugins when category or sub category contions no plugin.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#install_plugin_into_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else
		return false;
}

function SelectPage(page_name, i)
{
	document.getElementById('page_name').value = page_name;
	
	var page_name_select_ctl = "";
	var page_cnt = document.getElementById('page_cnt').value;
	for (var n = 0; n <page_cnt; n++)
	{
		page_name_select_ctl = "page_name_select" + n;
		document.getElementById(page_name_select_ctl).className = "button_sub_level_1";
	}
	page_name_select_ctl = "page_name_select" + i;
	document.getElementById(page_name_select_ctl).className = "button_sub_level_1 down_sub";
	
	document.getElementById('selected_page').innerHTML = "<b><em>" + page_name + "</em></b> " + ADD_PLUGIN_TO_PAGE_PAGE_SELECTED;
	CheckForm();
}

function SelectPlugin(plugin, i)
{
	document.getElementById('plugin').value = plugin;
	
	var plugin_name_select_ctl = "";
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n <plugin_cnt; n++)
	{
		plugin_name_select_ctl = "plugin_select" + n;
		if (ElExists(plugin_name_select_ctl))
			document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1";
	}
	plugin_name_select_ctl = "plugin_select" + i;
	document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1 down_sub";
	
	document.getElementById('selected_plugin').innerHTML = "<b><em>" + plugins[plugin] + "</em></b> " + ADD_PLUGIN_TO_PAGE_PLUGIN_SELECTED;
	CheckForm();
}

function SelectPluginCategory(category, cat_id, parent_cat_id)
{
	var cat_cnt = document.getElementById("cat_cnt").value;
	var cat_div_str;
	var cat_id_str = "div_" + cat_id;
	var cat_select;
	var n;
	for (var i = 0; i < cat_cnt; i++)
	{
		if (i != parent_cat_id)	{
			cat_div_str = "div_" + i;
			if (ElExists(cat_div_str))
				document.getElementById(cat_div_str).style.display = "none";
			cat_select = "cat_select" + i;
			if (ElExists(cat_select))
				document.getElementById(cat_select).className = "button_sub_level_1";
		}
	}
	cat_select = "cat_select" + cat_id;
	document.getElementById(cat_select).className = "button_sub_level_1 down_sub";
	
	if (ElExists(cat_id_str))
		document.getElementById(cat_id_str).style.display = "block";
	else
		DisplayNoPluginsInSubCatMsg(category, cat_id, parent_cat_id)
}

function CheckForm()
{
	if ((document.getElementById('page_name').value != "") && (document.getElementById('plugin').value != ""))
		document.getElementById("install_plugin_btn").className = "button_console_add";
}

function AddPluginToPage()
{
	if (document.getElementById("install_plugin_btn").className == "button_console_add_disabled")
		return;
		
	document.getElementById('frmAddPluginToPage').submit();
}

function DisplayNoPluginsInSubCatMsg(sub_category, cat_id, parent_cat_id)
{
	var cat_cnt = document.getElementById("cat_cnt").value;
	var cat_div_str;
	var cat_select;
	var n;
	for (var i = 0; i < cat_cnt; i++)
	{
		if (i != parent_cat_id)	{
			cat_div_str = "div_" + i;
			if (ElExists(cat_div_str))
				document.getElementById(cat_div_str).style.display = "none";
			cat_select = "cat_select" + i;
			if (ElExists(cat_select))
				document.getElementById(cat_select).className = "button_sub_level_1";
		}
	}
	cat_select = "cat_select" + cat_id;
	document.getElementById(cat_select).className = "button_sub_level_1 down_sub";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_1 + " <b>'" + sub_category + "'</b>. " + CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_2 + " <b>'" + GET_MORE_PLUGINS_BTN + "'</b> " + CREATE_PAGE_SELECT_NO_PLUGIN_EXISTS_FOR_CAT_3;
	popup_msg.popup_timeout = 6000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 0;
	popup_msg.ShowPopupMsg();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}