/////////////////////////////////////////////
// Main Menu Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/29/2013	ELL
// Revised: 11/20/2014	ELL
// Added "redirect", "folder" and separated "page_name" from "file_name" such that this module can be used in more than one place.
//
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function DeleteConfirm(delete_mode)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	
	if (delete_mode == "blog")
	{
		var list = document.getElementById('selectBlogToDelete');
		var blog = list.options[list.selectedIndex].innerHTML;
		popup_msg.popup_msg_cell = DELETE_PAGE_OR_BLOG_DELETE_BLOG_CONFIRM_1_MSG + " <b>" + blog + "</b>" + DELETE_PAGE_OR_BLOG_DELETE_BLOG_CONFIRM_2_MSG;
		document.getElementById("popup_button_2_span").onclick = function() { DeleteBlog(); };
	}
	else if (delete_mode == "recall_plugin")
	{
		var list = document.getElementById('recall_plugin');
		var plugin_name = list.options[list.selectedIndex].innerHTML;
		var plugin_name_arr = plugin_name.split("-");
		plugin_name = plugin_name_arr[0];
		popup_msg.popup_msg_cell = DELETE_PAGE_OR_BLOG_RECALL_PLUGIN_CONFIRM_1_MSG + " <b>" + plugin_name + "</b> " + DELETE_PAGE_OR_BLOG_RECALL_PLUGIN_CONFIRM_2_MSG;
		document.getElementById("popup_button_2_span").onclick = function() { RecallPlugin(); };
	}
	else	// page
	{
		popup_msg.popup_msg_cell = DELETE_PAGE_OR_BLOG_DELETE_PAGE_CONFIRM_1_MSG + " <b>" + document.getElementById("selectPageToDelete").value + "</b> " + DELETE_PAGE_OR_BLOG_DELETE_PAGE_CONFIRM_2_MSG;
		document.getElementById("popup_button_2_span").onclick = function() { DeletePage(); };
	}
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}

function DeletePage()
{
	var folder = "";
	if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
		folder = 'root';
	else if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR != ''))
		folder = BWB_WEBPAGE_DIR;
	else if ((BWB_BASE_DIR != '') && (BWB_WEBPAGE_DIR == ''))
		folder = BWB_BASE_DIR;
	else if ((BWB_BASE_DIR != '') && (BWB_WEBPAGE_DIR == ''))
		folder = BWB_BASE_DIR + "%2F" + BWB_WEBPAGE_DIR;
		
	var page_name = document.getElementById("selectPageToDelete").value;
	popup_msg.HidePopupMsg();
	var url = "delete_page.php?page_name=" + page_name + "&file_name=" + page_name + ".php&folder=" + folder + "&redirect=delete_page_select.php";
	window.location = url;
}

function DeleteBlog()
{
	var blog_id = document.getElementById("selectBlogToDelete").value;
	popup_msg.HidePopupMsg();
	var url = "delete_blog.php?blog_id=" + blog_id + "&redirect=delete_page_select.php";
	window.location = url;
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#delete_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}