///////////////////////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	6/25/2013	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 11/21/2014	ELL
// Added "redirect" to DeletePage call.
// Revised: 11/12/2015	ELL
// Converted from HTML/PHP POST application to AJAX application.
// Revised: 12/2/2015	ELL
// Fixed bug save not working when not all border areas are present on a page.
// Revised: 10/28/2016	ELL
// Added list of pages to auto-populate suffix for new border areas to make creating border areas with meaningful names as default behavior,
// and to allow for automatic assignment at border area creation.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var area_names = new Array();

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_special", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function UpdateSuffix(suffix)
{
	document.getElementById("suffix").value = suffix;
	if (suffix == "")
		GetNextIndex(border_area);
}

function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_1_MSG + " <b>" + document.getElementById("area_name_delete").value + "</b> " + MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeletePage(); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeletePage()
{
	var area_name = document.getElementById("area_name_delete").value;
	popup_msg.HidePopupMsg();
	$.post( "delete_border_area.php", { area_name: area_name, redirect: "-no redirect-" } ).done(CompleteDeletePage) ;
}
function CompleteDeletePage(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_DELETED_1_MSG + " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_DELETED_2_MSG;
	else
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_DELETED_ERR + " <b>" + data_arr[1] + "</b>.";
		
	popup_msg.ShowPopupMsg();
	
	var area_type = GetAreaFromName(data_arr[1]);
	area_type = area_type.replace("_", "");
	GetNextIndex(area_type);
	GetBorderAreas();
	GetBorderAreaAssignments();
}

function GetAreaFromName(page_name)
{
	var initial_prefix;

	switch (page_name.substr(0, 1))	{
	case 't':
		initial_prefix = "top_";
		break;
	case 'b':
		initial_prefix = "bottom_";
		break;
	case 'l':
		initial_prefix = "left_";
		break;
	case 'r':
		initial_prefix = "right_";
		break;
	case 'h':
		initial_prefix = "header_";
		break;
	case 'f':
		initial_prefix = "footer_";
		break;
	}
	
	return(initial_prefix);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetBorderAreas()
{
	$.post( "get_rows.php", { table: "page_data_special", order_by: "page_name", where: "page_name NOT LIKE 'mm_%'" } ).done(PopulateBorderAreas) ;
}
function PopulateBorderAreas(data)
{
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")
		alert(MANAGE_CUSTOM_BORDER_AREA_NO_AREAS_FOUND_ERR);
	else
	{
		area_names = [];
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			area_names[i] = JSON_row.page_name;
		}
		
		area_old_name_el = document.getElementById("area_old_name");
		area_name_delete_el = document.getElementById("area_name_delete");
		for (i = area_old_name_el.length - 1; i >= 0; i--)	{
			  area_old_name_el.remove(i);
		}
		for (i = area_name_delete_el.length - 1; i >= 0; i--)	{
			  area_name_delete_el.remove(i);
		}

		for (var i in area_names)
		{
			if ((area_names[i] != "top") && (area_names[i] != "bottom") && (area_names[i] != "left") && (area_names[i] != "right") && (area_names[i] != "header") && (area_names[i] != "footer"))
			{
				var elOpt1 = document.createElement('option');
				elOpt1.text = area_names[i];
				elOpt1.value = area_names[i];
				
				try {
					area_old_name_el.add(elOpt1, null); // standards compliant; doesn't work in IE
				}
				catch(ex) {
					area_old_name_el.add(elOpt1); // IE only
				}
				
				var elOpt2 = document.createElement('option');
				elOpt2.text = area_names[i];
				elOpt2.value = area_names[i];
				
				try {
					area_name_delete_el.add(elOpt2, null); // standards compliant; doesn't work in IE
				}
				catch(ex) {
					area_name_delete_el.add(elOpt2); // IE only
				}
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetBorderAreaAssignments()
{
	$.post( "get_border_area_assignments.php", { } ).done(PopulateBorderAreaAssignmentTable) ;
}
function PopulateBorderAreaAssignmentTable(data)
{
	var rows = new Array();
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")
		alert(MANAGE_CUSTOM_BORDER_AREA_NO_AREAS_FOUND_ERR);
	else
	{	
		var html = "<table width='100%' class='layout_box_table' align='center'>\n";
		html = html + "<tr bgcolor='#CCCCCC'>\n";
  		html = html + "<td colspan='8'><span class='sub_title'>" + MANAGE_CUSTOM_BORDER_AREA_ASSIGN_AREA + "</span></td></tr>\n";
		var bgcolor = "#EEEEEE";
  
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			html = html +  "<tr bgcolor='" + bgcolor + "'>\n";
			html = html +  "<td>" + JSON_row.page_name + "</td>";
			
			/////////////////////////////////////////
			//Test to see if file already exists.
			if (JSON_row.file_exists == 0)
			{
				html = html + ERROR_WORD + ": " + JSON_row.file_name + " " + CLICK_WORD + " " + MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_1_ERR + " <a href=\"manage_border_area.php\" title=\"" + HERE_WORD + "\">" + HERE_WORD + "</a> " + MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_2_ERR;
			}
			/////////////////////////////////////////
				
			if (JSON_row.template.indexOf("top") < 0)
				JSON_row.top_name = "-na-";
			if (JSON_row.template.indexOf("left") < 0)
				JSON_row.left_name = "-na-";
			if (JSON_row.template.indexOf("right") < 0)
				JSON_row.right_name = "-na-";
			if (JSON_row.template.indexOf("bottom") < 0)
				JSON_row.bottom_name = "-na-";
				
			html = html + "<td>\n";
			if (JSON_row.right_name != "-na-")
			{
				html = html + "<select name='right_area_name' id='right_area_name" + i + "'>\n";
				for (var j in area_names)
				{
					if (area_names[j] == JSON_row.right_name)
						html = html + "<option value='" + area_names[j] + "' selected='selected'>" + area_names[j] + "</option>\n";
					else if(area_names[j].indexOf("right") == 0)
						html = html +  "<option value='" + area_names[j] + "'>" + area_names[j] + "</option>\n";
				}
				html = html +  "</select>\n";
			}
			else
				html = html +  "-na-\n<input type='hidden' name='right_area_name' id='right_area_name" + i + "' value='right' />\n";
			html = html +  "</td>\n";
			
			html = html +  "<td>\n";
			if (JSON_row.left_name != "-na-")
			{
				html = html + "<select name='left_area_name' id='left_area_name" + i + "'>\n";
				for (var j in area_names)
				{
					if (area_names[j] == JSON_row.left_name)
						html = html + "<option value='" + area_names[j] + "' selected='selected'>" + area_names[j] + "</option>\n";
					else if(area_names[j].indexOf("left") == 0)
						html = html + "<option value='" + area_names[j] + "'>" + area_names[j] + "</option>\n";
				}
				html = html + "</select>\n";
			}
			else
				html = html + "-na-\n<input type='hidden' name='left_area_name' id='left_area_name" + i + "' value='left' />\n";
			html = html + "</td>\n";
			
			html = html + "<td>\n";
			if (JSON_row.top_name != "-na-")
			{
				html = html + "<select name='top_area_name' id='top_area_name" + i + "'>\n";
				for (var j in area_names)
				{
					if (area_names[j] == JSON_row.top_name)
						html = html + "<option value='" + area_names[j] + "' selected='selected'>" + area_names[j] + "</option>\n";
					else if(area_names[j].indexOf("top") == 0)
						html = html + "<option value='" + area_names[j] + "'>" + area_names[j] + "</option>\n";
				}
				html = html + "</select>\n";
			}
			else
				html = html + "-na-\n<input type='hidden' name='top_area_name' id='top_area_name" + i + "' value='top' />\n";
			html = html + "</td>\n";
			
			html = html + "<td>\n";
			if (JSON_row.bottom_name != "-na-")
			{
				html = html + "<select name='bottom_area_name' id='bottom_area_name" + i + "'>\n";
				for (var j in area_names)
				{
					if (area_names[j] == JSON_row.bottom_name)
						html = html + "<option value='" + area_names[j] + "' selected='selected'>" + area_names[j] + "</option>\n";
					else if(area_names[j].indexOf("bottom") == 0)
						html = html + "<option value='" + area_names[j] + "'>" + area_names[j] + "</option>\n";
				}
				html = html + "</select>\n";
			}
			else
				html = html + "-na-\n<input type='hidden' name='bottom_area_name' id='bottom_area_name" + i + "' value='bottom' />\n";
			html = html + "</td>\n";
			
			html = html + "<td>\n";
			if (JSON_row.header_name != "-na-")
			{
				html = html + "<select name='header_area_name' id='header_area_name" + i + "'>\n";
				for (var j in area_names)
				{
					if (area_names[j] == JSON_row.header_name)
						html = html + "<option value='" + area_names[j] + "' selected='selected'>" + area_names[j] + "</option>\n";
					else if(area_names[j].indexOf("header") == 0)
						html = html + "<option value='" + area_names[j] + "'>" + area_names[j] + "</option>\n";
				}
				html = html + "</select>\n";
			}
			else
				html = html + "-na-\n<input type='hidden' name='header_area_name' id='header_area_name" + i + "' value='header' />\n";
			html = html + "</td>\n";
			
			html = html + "<td>\n";
			if (JSON_row.footer_name != "-na-")
			{
				html = html + "<select name='footer_area_name' id='footer_area_name" + i + "'>\n";
				for (var j in area_names)
				{
					if (area_names[j] == JSON_row.footer_name)
						html = html + "<option value='" + area_names[j] + "' selected='selected'>" + area_names[j] + "</option>\n";
					else if(area_names[j].indexOf("footer") == 0)
						html = html + "<option value='" + area_names[j] + "'>" + area_names[j] + "</option>\n";
				}
				html = html + "</select>\n";
			}
			else
				html = html + "-na-\n<input type='hidden' name='footer_area_name' id='footer_area_name" + i + "' value='footer' />\n";
			html = html + "</td>\n";
			
			html = html + "<td>\n";
			
			html = html + "<div class='button_console_edit' style='width:110px;' onClick=\"AssignBorders('" + JSON_row.page_name + "', " + i + ");\"><span class='button_console_text_w_icon'>" + ASSIGN_WORD + "</span></div>\n";
			
			html = html + "</td>\n";
			html = html + "</tr>\n";
			if (bgcolor == "#EEEEEE")
				bgcolor = "#DDDDDD";
			else
				bgcolor = "#EEEEEE";
		}
		html = html + "</table>\n";
		
		document.getElementById("border_area_assignment_table").innerHTML = html;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function AssignBorders(page_name, i)
{
	var right_area_name_el = "right_area_name" + i;
	var leftt_area_name_el = "left_area_name" + i;
	var top_area_name_el = "top_area_name" + i;
	var bottom_area_name_el = "bottom_area_name" + i;
	var header_area_name_el = "header_area_name" + i;
	var footer_area_name_el = "footer_area_name" + i;
	
	var right_area_name = document.getElementById(right_area_name_el).value;
	var left_area_name = document.getElementById(leftt_area_name_el).value;
	var top_area_name = document.getElementById(top_area_name_el).value;
	var bottom_area_name = document.getElementById(bottom_area_name_el).value;
	var header_area_name = document.getElementById(header_area_name_el).value;
	var footer_area_name = document.getElementById(footer_area_name_el).value;
	
	$.post( "assign_border_area.php", { page_name: page_name, right_area_name: right_area_name, left_area_name: left_area_name, top_area_name: top_area_name, bottom_area_name: bottom_area_name, header_area_name: header_area_name, footer_area_name: footer_area_name } ).done(AssignBordersComplete) ;
}
function AssignBordersComplete(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_MSG + " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_MSG;
	else if (data_arr[0] == 0)
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_ALREADY_ASSIGNED_1_ERR + " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_ALREADY_ASSIGNED_3_ERR;
	else
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_ERR + " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_ERR;
		
	popup_msg.ShowPopupMsg();

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetNextIndex(area_type)
{
	if ((document.getElementById("suffix").value == "") || !isNaN(parseFloat(document.getElementById("suffix").value)))
		$.post( "get_next_index.php", { area_type: area_type } ).done(PopulateIndex) ;
}
function PopulateIndex(data)
{
	var data_arr = new Array();
	data_arr = data.split("@@@@@");
	var next_index = data_arr[0];
	document.getElementById("suffix").value = next_index;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function AddBorderArea()
{
	if (document.getElementById("btn_add_border_area").className == "button_console_add_disabled")
		return;

	if (document.getElementById("suffix").value == "")	{
		document.getElementById("suffix").className = "highlight";
		return;
	}

	var area_type_els = document.getElementsByName("area_type");
	var area_type = "";
	for (var i = 0; i < area_type_els.length; i++)
	{
		if (area_type_els[i].checked == true)
			area_type = area_type_els[i].value;
	}
	
	var suffix = document.getElementById("suffix").value;
	var assign_border = 0;
	if (document.getElementById("suffix").value == document.getElementById("new_suffix").value)
		assign_border = 1;
	$.post( "add_border_area.php", { area_type: area_type, suffix: suffix, assign_border: assign_border } ).done(CompleteAddBorderArea) ;
}
function CompleteAddBorderArea(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_ADDED_1_MSG + " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_ADDED_2_MSG;
	else
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_ADDED_ERR + " <b>" + data_arr[1] + "</b>.";
		
	popup_msg.ShowPopupMsg();
	GetNextIndex(data_arr[2]);
	GetBorderAreas();
	GetBorderAreaAssignments();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function RenameBorderArea()
{
	var area_old_name = document.getElementById("area_old_name").value;
	var name_prefix = document.getElementById("name_prefix").value;
	var name_suffix = document.getElementById("name_suffix").value;
	$.post( "rename_border_area.php", { area_old_name: area_old_name, name_prefix: name_prefix, name_suffix: name_suffix } ).done(CompleteRenameBorderArea) ;
}
function CompleteRenameBorderArea(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG + " <b>" + data_arr[2] + data_arr[3] + "</b>.";
	else
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR + " <b>" + data_arr[1] + "</b> " + TO_WORD + " <b>" + data_arr[2] + data_arr[3] + "</b>.";
		
	popup_msg.ShowPopupMsg();
	var area_type = data_arr[2];
	area_type = area_type.replace("_", "");
	GetNextIndex(area_type);
	GetBorderAreas();
	GetBorderAreaAssignments();
}

function SetBtnDownState(down_btn)
{
	var area_type_els = document.getElementsByName("area_type");
	for (var i = 0; i < area_type_els.length; i++)
	{
		if (area_type_els[i].checked == true)
			area_type_els[i].parentNode.className = "radio_button checked";
		else
			area_type_els[i].parentNode.className = "radio_button";
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function InitializeConsole()
{
	GetBorderAreas();
	GetBorderAreaAssignments();
	setTimeout("InitializePrefix();", 500);
	
}
function InitializePrefix()
{
	if (area_names[0] == undefined)
		setTimeout("InitializePrefix();", 500);
	else
	{
		var first_custom_area = "";
		for (i in area_names)
		{
			if ((area_names[i] != "top") && (area_names[i] != "bottom") && (area_names[i] != "left") && (area_names[i] != "right") && (area_names[i] != "header") && (area_names[i] != "footer"))
			{
				first_custom_area = area_names[i];
				break;
			}
		}
		if (first_custom_area != "")	{
			prefix=GetAreaFromName(first_custom_area);
			document.getElementById('name_prefix_display').innerHTML=prefix;
			document.getElementById('name_prefix').value=prefix;
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {
}

function DisplayNotSavedMessage(btn)	{
// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}