////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 5/10/2015	ELL

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

popup_msg.msg_width = 300;

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#custom_fonts", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetCustomFonts()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 200;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 1000;
	popup_msg.status_msg = MANAGE_CUSTOM_FONTS_GET_FONTS_MSG;
	popup_msg.ShowPopupMsg();
	
	$.post( "get_custom_fonts.php", { } ).done(CompleteGetCustomFonts) ;
}
function CompleteGetCustomFonts(data)
{
	var row_delim = "@@@@@";
	var font_rows = data.split(row_delim);
	
	var html = "<select name='font_delete' id='font_delete' onChange='UpdateSRC(this.value);'>\n";
	html = html + "<option value='-not selected-'>-not selected-</option>\n";
	for (var i = 0; i < font_rows.length; i++)
	{
		try	{
			JSON_font_row = JSON.parse(font_rows[i]);
		} catch(err)	{
			document.getElementById("delete_font_td").innerHTML = "<span class='no_custom_class'>" + MANAGE_CUSTOM_FONTS_NO_FONTS + "</span>";
			return(err);
		}
		if (JSON_font_row.src == null)
			JSON_font_row.src = "";
		html = html + "<option value='" + JSON_font_row.font + "'>" + JSON_font_row.font + "</option>\n";
	}
	document.getElementById("delete_font_td").innerHTML = html;
	
	popup_msg.popup_timeout = 1000;
	popup_msg.status_msg = MANAGE_CUSTOM_FONTS_GET_FONTS_COMPLETE_MSG;
	popup_msg.ShowPopupMsg();
}

function AddFont()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 200;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 10000;
	popup_msg.status_msg = MANAGE_CUSTOM_FONTS_ADDING_FONT_MSG;
	popup_msg.ShowPopupMsg();
	document.getElementById('frmAddFont').submit();
}

function CompleteAddFont(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 200;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (response == 1)
		popup_msg.status_msg = MANAGE_CUSTOM_FONTS_ADDING_FONT_COMPLETE_MSG;
	else
		popup_msg.status_msg = response;
	popup_msg.ShowPopupMsg();
}

function UpdateSRC(font)
{
	$.post( "get_rows.php", { table: "fonts", where: "`font` = '" + font + "'" } ).done(CompleteUpdateSRC) ;
}
function CompleteUpdateSRC(data)
{
	var srcs = data.split("@@@@@");
	if (srcs[0] == "-no data-")
	{
		document.getElementById("delete_src_td").innerHTML = "&nbsp;";
		document.getElementById("stretch_div").innerHTML = "&nbsp;";
		document.getElementById("style_div").innerHTML = "&nbsp;";
		document.getElementById("weight_div").innerHTML = "&nbsp;";
	}
	else
	{
		var html = "<select id='src' name='src' onChange='UpdateParams();'>\n";
		var JSON_row;
		var src;
		for (var i = 0; i < srcs.length; i++)
		{
			JSON_row = JSON.parse(srcs[i]);
			src = JSON_row.src;
			src = src.replace(/'/g, "");
			html = html + "<option value='" + src + "'>" + src + "</option>\n";
		}
		var html = html + "</select>\n";
		document.getElementById("delete_src_td").innerHTML = html;
		
		UpdateParams();
	}
}

function UpdateParams()
{
	var font = document.getElementById("font_delete").value;
	var src = document.getElementById("src").value;
	$.post( "get_rows.php", { table: "fonts", where: "(`font` = '" + font + "') AND (`src` = '" + src + "')" } ).done(CompleteUpdateParams) ;
}
function CompleteUpdateParams(data)
{
	if (data == "-no data-")
		return -1;
		
	try	{
		JSON_font_row = JSON.parse(data);
	} catch(err)	{
		return err;
	}
	document.getElementById("stretch_div").innerHTML = JSON_font_row.stretch;
	document.getElementById("style_div").innerHTML = JSON_font_row.style;
	document.getElementById("weight_div").innerHTML = JSON_font_row.weight;
}

//////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	var font = document.getElementById("font_delete").value;
	var src = document.getElementById("src").value;
	popup_msg.popup_msg_cell = MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_1_MSG + " <b>" + font + "</b> " + MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_2_MSG + " <b>" + src + "</b> " + MANAGE_CUSTOM_FONTS_DELETE_FONT_CONFIRM_3_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteFont(); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteFont()
{
	var font = document.getElementById("font_delete").value;
	var src = document.getElementById("src").value;
	popup_msg.HidePopupMsg();
	
	$.post( "delete_custom_font.php", { font: font, src: src } ).done(CompleteDeleteFont) ;
}
function CompleteDeleteFont(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (data == 1)
		popup_msg.status_msg = MANAGE_CUSTOM_FONTS_DELETE_FONT_COMPLETE_MSG;
	else
		popup_msg.status_msg = response;
	popup_msg.ShowPopupMsg();
	
	GetCustomFonts();
	document.getElementById("delete_src_td").innerHTML = "";
	document.getElementById("stretch_div").innerHTML = "";
	document.getElementById("style_div").innerHTML = "";
	document.getElementById("weight_div").innerHTML = "";
}

function ChangeSRC(mode)
{
	if (mode == "upload")	{
		document.getElementById("src_file").style.display = "inline";
		document.getElementById("src_url").style.display = "none";
	}
	else	{
		document.getElementById("src_file").style.display = "none";
		document.getElementById("src_url").style.display = "inline";
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}