/////////////////////////////////////////////
// Manage Menu /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 7/1/2013	ELL
// Revised: 2/17/2018	ELL
// Added ability to copy one menu into a new menu.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_menu", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function AddMenu()
{
	if (document.getElementById("add_menu_btn").className != "button_console_add_disabled")
	{
		document.getElementById('uploading_gif').style.display='inline';
		document.getElementById('frmAddMenu').submit();
	}
}

function EnableDisableAddMenuBtn(description)
{
	if (description != "")
		document.getElementById("add_menu_btn").className = "button_console_add";
	else
		document.getElementById("add_menu_btn").className = "button_console_add_disabled";
}

function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_MENUS_DELETE_MENU_CONFIRM_1_MSG + " <b>" + document.getElementById("selectMenuDelete").value + "</b> " + MANAGE_MENUS_DELETE_MENU_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteMenu(); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteMenu()
{
	var menu = document.getElementById("selectMenuDelete").value;
	popup_msg.HidePopupMsg();
	var url = "delete_menu.php?menu=" + menu;
	window.location = url;
}

function SaveDescription()
{
	if (document.getElementById("update_desc_btn").className != "button_console_save_disabled")
	{
		document.getElementById('frmUpdateMenuDesc').submit();
	}
}

function CopyMenuConfirm()
{
	if (document.getElementById("copy_menu_btn").className != "button_console_copy_disabled")
	{
		if (document.getElementById("copy_to_menu").value == "-new-")
			CopyMenu();
		else	{
			popup_msg.top_offset = 0;
			popup_msg.left_offset = 300;
			popup_msg.popup_msg_type = 3;
			popup_msg.popup_btn_cnt = 2;
			popup_msg.popup_msg_cell = MANAGE_MENUS_COPY_MENU_CONFIRM_1_MSG + " <b>" + document.getElementById("copy_from_menu").value + "</b> " + MANAGE_MENUS_COPY_MENU_CONFIRM_2_MSG + " <b>" + document.getElementById("copy_to_menu").value + "</b> " + MANAGE_MENUS_COPY_MENU_CONFIRM_3_MSG;
			popup_msg.popup_button_2_span = YES_WORD;
			popup_msg.popup_button_1_span = NO_WORD;
			popup_msg.popup_timeout = -1;
			popup_msg.ShowPopupMsg();
			document.getElementById("popup_button_2_span").onclick = function () { CopyMenu(); };
			document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
		}
	}
}
function CopyMenu()
{
	document.getElementById('uploading_gif2').style.display='inline';
	document.getElementById('frmCopyMenu').submit();
}

function EnableDisableCopyCntls(copy_to_menu)
{
	if (copy_to_menu == "-new-")
		document.getElementById("copy_to_description").disabled = false;
	else
		document.getElementById("copy_to_description").disabled = true;
}

function EnableDisableCopyMenuBtn(copy_from_menu)
{
	if (copy_from_menu == "")
		document.getElementById("copy_menu_btn").className = "button_console_copy_disabled";
	else
		document.getElementById("copy_menu_btn").className = "button_console_copy";
}

function CopyMenuItemsToMobileConfirm()
{
	if (document.getElementById("copy_menu_items_btn").className != "button_console_copy_disabled")
	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 300;
		popup_msg.popup_msg_type = 3;
		popup_msg.popup_btn_cnt = 2;
		var source_menu = document.getElementById("source_menu").value;
		var source_menu_parts = source_menu.split("_");
		var destination_menu_type = document.getElementById("destination_menu_type").value;
		var destination_menu;
		if (destination_menu_type == "desktop")
			destination_menu = source_menu_parts[0];
		else
			destination_menu = source_menu_parts[0] + "_" + destination_menu_type;
		popup_msg.popup_msg_cell = MANAGE_MENUS_COPY_MENU_CONFIRM_1_MSG + " <b>" + source_menu + "</b> " + MANAGE_MENUS_COPY_MENU_ITEMS_CONFIRM_2_MSG + " <b>" + destination_menu + "</b> " + MANAGE_MENUS_COPY_MENU_CONFIRM_3_MSG;
		popup_msg.popup_button_2_span = YES_WORD;
		popup_msg.popup_button_1_span = NO_WORD;
		popup_msg.popup_timeout = -1;
		popup_msg.ShowPopupMsg();
		document.getElementById("popup_button_2_span").onclick = function () { CopyMenuItemsToMobile(); };
		document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
	}
}
function CopyMenuItemsToMobile()
{
	document.getElementById('frmCopyMenuItemsToMobile').submit();
}

function EnableDisableCopyMenuItemsBtn()
{
	var source_menu = document.getElementById("source_menu").value;
	var destination_menu_type = document.getElementById("destination_menu_type").value;
	if ((source_menu == "") || (destination_menu_type == ""))
		document.getElementById("copy_menu_items_btn").className = "button_console_copy_disabled";
	else
		document.getElementById("copy_menu_items_btn").className = "button_console_copy";
}

function EnableDisableDestMenuTypeOptions(source_menu)
{
	var destination_menu_type;
	if (source_menu.indexOf("_mobile") > -1)
		destination_menu_type = "mobile";
	else if (source_menu.indexOf("_touchscreen") > -1)
		destination_menu_type = "touchscreen";
	else
		destination_menu_type = "desktop";
	var op = document.getElementById("destination_menu_type").getElementsByTagName("option");
	for (var i = 0; i < op.length; i++) {
	  (op[i].value.toLowerCase() == destination_menu_type) 
		? op[i].disabled = true 
		: op[i].disabled = false ;
	}
	
	EnableDisableCopyMenuItemsBtn();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}