<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	3/9/2013	ELL
// Revised: 5/14/2013	ELL
// Added prepend and postpend for header and footer.
// Revised: 5/23/2013	ELL
// Changed header and footer prepend and postpend to HTML 5 tags.
// Revised: 1/28/2014	ELL
// Trapped error of null data for page content causing HTML encaplusation to be missing.
// Added content sensitive help for relevant plugins.
// Revised: 9/21/2014	ELL
// Upgraded CKEditor for 4.0.2 to 4.4.4.
// Revised: 10/16/2014	ELL
// Added ability to turn off site styles when disable_site_styles flag is set.
// Revised: 1/6/2015	ELL
// Fixed bug with page not saving to backing table and thus not loading due to single quotes.

	include ("check_session.php");

	$page_name = $_REQUEST['page_name'];
	$blog_id = $_REQUEST['blog_id'];
	$special = $_REQUEST['special'];	//Flag to tell if editing special page (header, footer, side panel...).
	$mode = $_REQUEST['mode'];
	$disable_site_styles = $_REQUEST['disable_site_styles'];

	$encap_delim = "<!-- WYSIWYG Encapsulation. Modify HTML inside of these comments only.  All code outside of these comments is discarded. -->";
	if ($mode == "blog")
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs_draft WHERE blog_id='$blog_id'";		
		$result = $bwb_dbh->query($query);
		if ($row = $result->fetch(PDO::FETCH_ASSOC))
			$page_content = $row["post"];
		else	// Some reason no draft exits.  Just use actual page data.
		{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs WHERE id='$blog_id'";
			$result = $bwb_dbh->query($query);
			if ($row = $result->fetch(PDO::FETCH_ASSOC))
				$page_content = $row["post"];
			else
				$page_content = "";
				
			if (!isset($page_name) || ($page_name == ""))
				$page_name = $row['page_name'];
		}
		if (!isset($page_name) || ($page_name == ""))
		{
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs WHERE id='$blog_id'";
			$result = $bwb_dbh->query($query);
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$page_name = $row['page_name'];
		}
	}
	else
	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name='$page_name' AND `source`=$special";
		$result = $bwb_dbh->query($query);
		if ($row = $result->fetch(PDO::FETCH_ASSOC))
			$page_content = $row["page_content"];
		else	// Some reason no draft exits.  Just use actual page data.
		{
			if ($special == 1)
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name='$page_name'";
			else
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='$page_name'";
			$result = $bwb_dbh->query($query);
			
			if ($row = $result->fetch(PDO::FETCH_ASSOC))
				$page_content = $row["page_content"];
			else
				$page_content = "";
		}
	}

	$page_content = addslashes(stripslashes($page_content));
			
	// Before we go any farther, back this puppy up!
	$revised = $row["revised"];
	if ($mode == "blog")
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "blogs_bkup SET blog_id='$blog_id', page_name='$page_name', post='$page_content', `owner`='$userid', revised='$revised'";
	else
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_bkup SET page_name='$page_name', page_content='$page_content', revised='$revised', `source`=$special";
		
	$result = $bwb_dbh->query($query);
	// Pull extra slashes so that slash codes don't start adding up.
	$page_content = stripslashes($page_content);
	
	// Encapsulate page data with template table cell and div so that built-in styles will se seen in the editing environment as well.
	if ($special != 1)
		$prepend = "<div class='wrap' id='wrap'><table style='height:100%; width:100%'><tbody><tr><td style='vertical-align:top' class='content_td' id='content_td'><div class='content_div' id='content_div'>";
	elseif (substr($page_name, 0, 3) == "top")
		$prepend = "<div class='wrap' id='wrap'><table style='height:100%; width:100%'><tbody><tr><td class='top_td' id='top_td'><div class='top_div' id='top_div'>";
	elseif (substr($page_name, 0, 6) == "bottom")
		$prepend = "<div class='wrap' id='wrap'><table style='height:100%; width:100%'><tbody><tr><td class='bottom_td' id='bottom_td'><div class='bottom_div' id='bottom_div'>";
	elseif (substr($page_name, 0, 4) == "left")
		$prepend = "<div class='wrap' id='wrap'><table style='height:100%; width:100%'><tbody><tr><td style='vertical-align:top' class='left_td' id='left_td'><div class='left_div' id='left_div'>";
	elseif (substr($page_name, 0, 5) == "right")
		$prepend = "<div class='wrap' id='wrap'><table style='height:100%; width:100%'><tbody><tr><td style='vertical-align:top' class='right_td' id='right_td'><div class='right_div' id='right_div'>";
	elseif (substr($page_name, 0, 6) == "header")
	{
		$prepend = "<header>";
		$postpend = "</header>";
	}
	elseif (substr($page_name, 0, 6) == "footer")
	{
		$prepend = "<footer>";
		$postpend = "</footer>";
	}
	if ( (substr($page_name, 0, 6) != "header") && (substr($page_name, 0, 6) != "footer") )
		$postpend = "</div></td></tr></tbody></table></div>";
	
	if ($disable_site_styles != 1)
		$page_content = $prepend . $encap_delim . $page_content . $encap_delim . $postpend;
	
	echo $page_content;
?>