<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/3/2009
// Rezised: 6/29/2009	ELL
// Fixed bug of assignments corrupting templates that do not have all 4: top, bottom, left and right sections.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 5/10/2013	ELL
// Added new areas header and footer.  Headers go above the top cell and footers go below the bottom cell.
// Revised: 6/24/2013	ELL
// Added ability to specify meaningful names.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/18/2013	ELL
// Added visual feedback for assigning border areas to pages.
// Revised: 10/2/2015	ELL
// Modified from searching page template file for bordere area names to looking up border areas in page data table.
// Modified determination of existence of border from searching page template file to searching template name in page data table.
// Revised: 11/12/2015	ELL
// Converted from HTML/PHP POST application to AJAX application.
// Revised: 10/28/2016	ELL
// Added list of pages to auto-populate suffix for new border areas to make creating border areas with meaningful names as default behavior,
// and to allow for automatic assignment at border area creation.
	
	include ("check_session.php");
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Border Areas | Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#manage_custom_border_areas_heading	{	width:300px;	}
#help_button	{
	position:relative;
	display:block;
	top:-15px;
	left:260px;
	height:31px;
	width:31px;
	z-index:100;
}

.radio_button	{		width:100px;	}
.radio_button_text	{	left:0px;	}

#btn_add_border_area	{
	width:220px;
	margin-top:5px;
}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/manage_border_area.js"></script>
<script>
<?php 
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_CONFIRM_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETED_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETED_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETED_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETED_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_DELETED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_DELETED_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGN_AREA = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGN_AREA . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_1_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_1_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_2_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_NOT_FOUND_2_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_NO_AREAS_FOUND_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_NO_AREAS_FOUND_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_1_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ASSIGNED_2_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ADDED_1_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ADDED_1_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ADDED_2_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_ADDED_2_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ADDED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ADDED_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG = \"" . MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var ERROR_WORD = \"" . ERROR_WORD . "\";\n";
	echo "	var CLICK_WORD = \"" . CLICK_WORD . "\";\n";
	echo "	var HERE_WORD = \"" . HERE_WORD . "\";\n";
	echo "	var ASSIGN_WORD = \"" . ASSIGN_WORD . "\";\n";
	echo "	var TO_WORD = \"" . TO_WORD . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ALREADY_ASSIGNED_1_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ALREADY_ASSIGNED_1_ERR . "\";\n";
	echo "	var MANAGE_CUSTOM_BORDER_AREA_ALREADY_ASSIGNED_3_ERR = \"" . MANAGE_CUSTOM_BORDER_AREA_ALREADY_ASSIGNED_3_ERR . "\";\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeConsole();">

<div class='button_console_go_back' style="width:250px; position:absolute; right:40px; top:0px;" onClick="window.location.href='manage_border_area_select.php'"><span class='button_console_text_w_icon'><?php echo MANAGE_CUSTOM_BORDER_AREA_BACK_BTN; ?></span></div>

<table width="90%" border="0" align="center"><tr><td>
<div class="button_heading_sub_level_1" id="manage_custom_border_areas_heading"><div class="button_heading_text_sub_level_1"><?php echo MANAGE_CUSTOM_BORDER_AREA_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<table width="90%" align="center" class="group_box_table"><tr>
  <td>
<span class="sub_title"><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_AREA; ?></span>
<table width="100%" class="layout_box_table" align="center">
<tr>

<td align="center">
<div class="radio_button" id="right_radio_btn" onClick="document.getElementById('area_type[0]').checked = true; document.getElementById('btn_add_border_area').className = 'button_console_add'; GetNextIndex('right'); SetBtnDownState(this);">
	<span class='radio_button_text'><?php echo RIGHT_1ST_CAP_WORD; ?></span>
    <input name="area_type" id="area_type[0]" type="radio" value="right" style="left:0px;" />
</div>

<div class="radio_button" id="left_radio_btn" onClick="document.getElementById('area_type[1]').checked = true; document.getElementById('btn_add_border_area').className = 'button_console_add'; GetNextIndex('left'); SetBtnDownState(this);">
	<span class='radio_button_text'><?php echo LEFT_1ST_CAP_WORD; ?></span>
    <input name="area_type" id="area_type[1]" type="radio" value="left" style="left:0px;" />
</div>

<div class="radio_button" id="top_radio_btn" onClick="document.getElementById('area_type[2]').checked = true; document.getElementById('btn_add_border_area').className = 'button_console_add'; GetNextIndex('top'); SetBtnDownState(this);">
	<span class='radio_button_text'><?php echo TOP_1ST_CAP_WORD; ?></span>
    <input name="area_type" id="area_type[2]" type="radio" value="top" style="left:0px;" />
</div>

<div class="radio_button" id="bottom_radio_btn" onClick="document.getElementById('area_type[3]').checked = true; document.getElementById('btn_add_border_area').className = 'button_console_add'; GetNextIndex('bottom'); SetBtnDownState(this);">
	<span class='radio_button_text'><?php echo BOTTOM_1ST_CAP_WORD; ?></span>
    <input name="area_type" id="area_type[3]" type="radio" value="bottom" style="left:0px;" />
</div>

<div class="radio_button" id="header_radio_btn" onClick="document.getElementById('area_type[4]').checked = true; document.getElementById('btn_add_border_area').className = 'button_console_add'; GetNextIndex('header'); SetBtnDownState(this);">
	<span class='radio_button_text'><?php echo HEADER_1ST_CAP_WORD; ?></span>
    <input name="area_type" id="area_type[4]" type="radio" value="header" style="left:0px;" />
</div>

<div class="radio_button" id="footer_radio_btn" onClick="document.getElementById('area_type[5]').checked = true; document.getElementById('btn_add_border_area').className = 'button_console_add'; GetNextIndex('footer'); SetBtnDownState(this);">
	<span class='radio_button_text'><?php echo FOOTER_1ST_CAP_WORD; ?></span>
    <input name="area_type" id="area_type[5]" type="radio" value="footer" style="left:0px;" />
</div>
        
<select id="new_suffix" name="new_suffix" onChange="UpdateSuffix(this.value);">
  <option value=""><?php echo _NOT_SELECTED_; ?></option>
<?php
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "	<option value='$page_name'>$page_name</option>\n";
	}
?>
  </select>
<input type="text" name="suffix" id="suffix" style="width:100px;" onKeyPress="this.className = '';" />
<br />
<div class='button_console_add_disabled' id="btn_add_border_area" onClick="AddBorderArea();"><span class='button_console_text_w_icon'><?php echo MANAGE_CUSTOM_BORDER_AREA_ADD_AREA_BTN; ?></span></div>
</td>

</tr>
</table>
</td></tr></table>
<br />

<table width="90%" align="center" class="group_box_table"><tr><td>
<div id="border_area_assignment_table">&nbsp;</div>
</td></tr></table>
<br />
	<table width="90%" align="center" class="group_box_table"><tr><td>
    
	<table width="100%" align="center" class="layout_box_table">
      <tr>
        <td>
        	<span class="sub_title"><?php echo MANAGE_CUSTOM_BORDER_AREA_RENAME_AREA; ?></span>
        </td>
        <td>
            <span class="sub_title"><?php echo MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA; ?></span>
        </td>
      </tr>
      <tr>
      	<td>
      	  <table width="100%" align="center" class="layout_box_table">
      		<tr>
              <td align="right"><?php echo MANAGE_CUSTOM_BORDER_AREA_RENAME_AREA_SELECT; ?>: </td>
              <td>
                <select name="area_old_name" id="area_old_name" onChange="var prefix=GetAreaFromName(this.value); document.getElementById('name_prefix_display').innerHTML=prefix; document.getElementById('name_prefix').value=prefix;">
                </select>
              </td>
              <td align="right"><?php echo MANAGE_CUSTOM_BORDER_AREA_NEW_NAME; ?>: </td>
              <td align="right" style="width:60px;">
              <div id="name_prefix_display">&nbsp;</div>
              <input type="hidden" name="name_prefix" id="name_prefix" />
              </td>
              <td><input type="text" name="name_suffix" id="name_suffix" style="width:100px;" /></td>
              <td align="center">
              <div class='button_console_edit' style="width:100px;" onClick="RenameBorderArea();"><span class='button_console_text_w_icon'><?php echo RENAME_WORD; ?></span></div>
              </td>
			</tr>
         </table>
      </td>
      <td>
        <table width="100%" align="center" class="layout_box_table">
      		<tr>
              <td align="right"><?php echo MANAGE_CUSTOM_BORDER_AREA_DELETE_AREA_SELECT; ?>: </td>
              <td>
                <select name="area_name" id="area_name_delete">
                </select>
              </td>
              <td align="center">
              <div class='button_console_delete' style="width:100px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
              </td>
            </tr>
        </table>
    
       </td>
     </tr>
    </table>
    
    </td></tr></table>


<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
</script>

</body>
</html>