<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/4/2016	ELL
// 
// 

	include ("check_session.php");

	$last_style_sheet_edited = $_SESSION['last_style_sheet_edited'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Style Sheet Attributes | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style>
.group_box_div	{
	border:#585858 thin solid;
	padding:5px;
	margin-bottom:30px;
}

.sub_group_box_div	{
	padding:5px;
	margin-bottom:20px;
}
	
#btn_save_attributes	{
	position:relative;
	display:block;
	top:0px;
	left:400px; 
	width:110px;
}

#btn_add_style_sheet	{
	position:relative;
	display:block;
	top:0px;
	left:400px; 
	width:110px;
}
#btn_delete_style_sheet	{
	position:relative;
	display:block;
	top:0px;
	left:400px; 
	width:110px;
}
#rename_copy_btn_grp	{
	position:relative;
	display:block;
	top:0px;
	left:400px; 
	width:0px;
	height:0px;
}
#btn_rename_style_sheet	{
	width:110px;
	position:absolute;
	top:0px;
	left:0px;
}
#btn_copy_style_sheet	{
	width:110px;
	position:absolute;
	top:0px;
	left:120px;
}

#mobile_label	{	color:#DDD;	}

#sort_checkbox_div	{
	position:relative;
	left:70px;
	top:50px;
}

#button_heading_help	{	left:300px;	}
</style>

<script src="js/json2.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/manage_style_sheet_attrib.js"></script>

<script>
<?php
	echo "	var last_style_sheet_edited = \"" . $last_style_sheet_edited . "\";\n";
	if (isset($_SESSION['style_sheet_sort_method']) && ($_SESSION['style_sheet_sort_method'] == 1))
		$style_sheet_sort_method = 1;
	else
		$style_sheet_sort_method = 0;
	echo "	var sort_alpha = $style_sheet_sort_method;\n";
	
	echo "	var MANAGE_STYLE_SHEET_ATT_HEADING = \"" . MANAGE_STYLE_SHEET_ATT_HEADING . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_SAVE_SUCCESS_MSG = \"" . MANAGE_STYLE_SHEET_ATT_SAVE_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_SAVE_ERROR_ERR = \"" . MANAGE_STYLE_SHEET_ATT_SAVE_ERROR_ERR . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_ADD_SUCCESS_MSG = \"" . MANAGE_STYLE_SHEET_ATT_ADD_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_ADD_SHEET_ALREADY_EXISTS_ERR = \"" . MANAGE_STYLE_SHEET_ATT_ADD_SHEET_ALREADY_EXISTS_ERR . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_ADD_ERROR_ERR = \"" . MANAGE_STYLE_SHEET_ATT_ADD_ERROR_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var EDITOR_STYLE_SHEET = \"" . EDITOR_STYLE_SHEET . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_DELETE_CONFIRM_MSG = \"" . MANAGE_STYLE_SHEET_ATT_DELETE_CONFIRM_MSG . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_DELETE_SUCCESS_MSG = \"" . MANAGE_STYLE_SHEET_ATT_DELETE_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_DELETE_ERROR_ERR = \"" . MANAGE_STYLE_SHEET_ATT_DELETE_ERROR_ERR . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_RENAME_SUCCESS_MSG = \"" . MANAGE_STYLE_SHEET_ATT_RENAME_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_RENAME_ERROR_ERR = \"" . MANAGE_STYLE_SHEET_ATT_RENAME_ERROR_ERR . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_COPY_SUCCESS_MSG = \"" . MANAGE_STYLE_SHEET_ATT_COPY_SUCCESS_MSG . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_ATT_COPY_ERROR_ERR = \"" . MANAGE_STYLE_SHEET_ATT_COPY_ERROR_ERR . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_SET_SORT_ORDER = \"" . MANAGE_STYLE_SHEET_SET_SORT_ORDER . "\";\n";
	echo "	var MANAGE_STYLE_SHEET_NAME_DESCRIPTION = \"" . MANAGE_STYLE_SHEET_NAME_DESCRIPTION . "\";\n";
	echo "	var SORT_ORDER = \"" . SORT_ORDER . "\";\n";
	echo "	var CUSTOM_WORD = \"" . CUSTOM_WORD . "\";\n";
	echo "	var UPDATE_WORD = \"" . UPDATE_WORD . "\";\n";
	echo "	var CLASSES_UPDATE_SORT_ORDER_COMPLETE_MSG = \"" . CLASSES_UPDATE_SORT_ORDER_COMPLETE_MSG . "\";\n";
	echo "	var CLASSES_UPDATE_SORT_ORDER_UPDATE_ERR = \"" . CLASSES_UPDATE_SORT_ORDER_UPDATE_ERR . "\";\n";
?>
</script>
</head>

<body onLoad="InitializeConsole();">
	<div class='button_console_go_back' style="width:220px; position:absolute; right:20px; top:0px;" onClick="window.location.href='edit_css_select.php'"><span class='button_console_text_w_icon'><?php echo MANAGE_STYLE_SHEET_ATT_BACK_TO_EDIT_CSS_SELECT; ?></span></div>

 <div id="sub_level_1_buttons">&nbsp;</div>
 
<div id="sort_checkbox_div">
<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_style_sheet" name="sort_alpha_style_sheet" <?php if ($style_sheet_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeStyleSheetSort(this.checked);" />
</div>
 
<div style="position:absolute; top:50px; left:400px;">
<form name="frmStyleSheetAttrib" id="frmStyleSheetAttrib" action="save_style_sheet_attrib.php" method="post">
 <div class="group_box_div">
  <div class="sub_group_box_div">
	<h3><?php echo MANAGE_STYLE_SHEET_ATT_CHARSET; ?></h3>
    <?php echo MANAGE_STYLE_SHEET_ATT_CHARSET; ?>:
    <select name="charset" id="charset" onChange="EnableUpdateBtn(true);">
    	<option value=""><?php echo _NOT_SELECTED_; ?></option>
        <option value="UTF-8">UTF-8</option>
        <option value="ISO-8859-1">ISO-8859-1</option>
        <option value="ISO-8859-2">ISO-8859-2</option>
        <option value="ISO-8859-3">ISO-8859-3</option>
        <option value="ISO-8859-4">ISO-8859-4</option>
        <option value="ISO-8859-5">ISO-8859-5</option>
        <option value="ISO-8859-6">ISO-8859-6</option>
        <option value="ISO-8859-6-E">ISO-8859-6-E</option>
        <option value="ISO-8859-6-I">ISO-8859-6-I</option>
        <option value="ISO-8859-7">ISO-8859-7</option>
        <option value="ISO-8859-8">ISO-8859-8</option>
        <option value="ISO-8859-8-E">ISO-8859-8-E</option>
        <option value="ISO-8859-8-I">ISO-8859-8-I</option>
        <option value="ISO-8859-9">ISO-8859-9</option>
        <option value="ISO-8859-10">ISO-8859-10</option>
        <option value="US-ASCII">US-ASCII</option>
        <option value="Shift_JIS">Shift_JIS</option>
        <option value="EUC-JP">EUC-JP</option>
        <option value="ISO-2022-KR">ISO-2022-KR</option>
        <option value="EUC-KR">EUC-KR</option>
        <option value="ISO-2022-JP">ISO-2022-JP</option>
        <option value="ISO-2022-JP-2">ISO-2022-JP-2</option>
        <option value="GB2312">GB2312</option>
        <option value="Big5">Big5</option>
        <option value="KOI8-R">KOI8-R</option>
    </select>
  </div>
  <div class="sub_group_box_div">
	<h3><?php echo MANAGE_STYLE_SHEET_ATT_IMPORT; ?></h3>
    <?php echo EDIT_MENU_ITEMS_URL; ?>:
    <input type="text" name="import" id="import" style="width:240px;" onChange="EnableUpdateBtn(true);" />
  </div>
  <div class="sub_group_box_div" style="position:relative;">
    <h3 style="margin-bottom:30px;"><?php echo MANAGE_STYLE_SHEET_ATT_MEDIA; ?></h3>
    <select name="media_type_modifier" id="media_type_modifier" onChange="EnableUpdateBtn(true);">
    	<option value=""></option>
        <option value="not"><?php echo NOT_WORD; ?></option>
        <option value="only"><?php echo ONLY_WORD; ?></option>
    </select>
    <div style="position:absolute; top:55px; left:70px;"><?php echo MANAGE_STYLE_SHEET_ATT_MEDIA_TYPE; ?>:</div>
    <select name="media_type" id="media_type" onChange="EnableUpdateBtn(true);">
    	<option value=""><?php echo _NOT_SELECTED_; ?></option>
        <option value="all"><?php echo ALL_WORD; ?></option>
        <option value="print"><?php echo PRINT_WORD; ?></option>
        <option value="screen"><?php echo SCREEN_WORD; ?></option>
        <option value="speech"><?php echo SPEECH_WORD; ?></option>
    </select>
    <?php echo AND_WORD; ?>
    <div style="position:absolute; top:55px; left:210px;"><?php echo MANAGE_STYLE_SHEET_ATT_MEDIA_FEATURE; ?>:</div>
    <select name="media_feature" id="media_feature" onChange="EnableUpdateBtn(true);">
    	<option value=""><?php echo _NOT_SELECTED_; ?></option>
        <option value="aspect-ratio">aspect-ratio</option>
        <option value="color">color</option>
        <option value="color-index">color-index</option>
        <option value="device-aspect-ratio">device-aspect-ratio</option>
        <option value="device-height">device-height</option>
        <option value="adevice-width">device-width</option>
        <option value="grid">grid</option>
        <option value="height">height</option>
        <option value="max-aspect-ratio">max-aspect-ratio</option>
        <option value="max-color">max-color</option>
        <option value="max-color-index">max-color-index</option>
        <option value="max-device-aspect-ratio">max-device-aspect-ratio</option>
        <option value="max-device-height">max-device-height</option>
        <option value="max-device-width">max-device-width</option>
        <option value="max-height">max-height</option>
        <option value="max-monochrome">max-monochrome</option>
        <option value="max-resolution">max-resolution</option>
        <option value="max-width">max-width</option>
        <option value="min-aspect-ratio">min-aspect-ratio</option>
        <option value="min-color">min-color</option>
        <option value="min-color-index">min-color-index</option>
        <option value="min-device-aspect-ratio">min-device-aspect-ratio</option>
        <option value="min-device-height">min-device-height</option>
        <option value="min-device-width">min-device-width</option>
        <option value="min-height">min-height</option>
        <option value="min-monochrome">min-monochrome</option>
        <option value="min-resolution">min-resolution</option>
        <option value="min-width">min-width</option>
        <option value="monochrome">monochrome</option>
        <option value="orientation">orientation</option>
        <option value="overflow-block">overflow-block</option>
        <option value="overflow-inline">overflow-inline</option>
        <option value="resolution">resolution</option>
        <option value="scan">scan</option>
        <option value="update-frequency">update-frequency</option>
        <option value="width">width</option>
    </select>
    <div style="position:absolute; top:55px; left:377px;"><?php echo MANAGE_STYLE_SHEET_ATT_MEDIA_FEATURE_VALUE; ?>:</div>
    <input type="text" name="media_feature_value" id="media_feature_value" onChange="EnableUpdateBtn(true);" />
  </div>
  <input type="hidden" name="style_sheet" id="style_sheet" />
  
  <div class='button_console_save_disabled' onClick="SaveStyleSheetAttributes();" id="btn_save_attributes"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
 </div>
</form>

<hr /><br />

<div class="group_box_div">
<div class="sub_group_box_div" style="position:relative;">
<h3 style="margin-bottom:30px;"><?php echo MANAGE_STYLE_SHEET_ATT_ADD_STYLE_SHEET; ?></h3>
<div style="position:absolute; top:55px; left:10px;"><?php echo NAME_WORD; ?>:</div>
<input type="text" name="name" id="name" onChange="EnableDisableAddBtn();" onKeyPress="CheckName(this);" />
<span id="mobile_label">_mobile</span>
<div style="position:absolute; top:55px; left:240px;"><?php echo DESCRIPTION_WORD; ?>:</div>
<input type="text" name="description" id="description" onChange="EnableDisableAddBtn();" onKeyPress="EnableDisableAddBtn();" />
<select name="style_sheet_types" id="style_sheet_types" onChange="EnableDisableAddBtn(); SetMobileLabelStyle(this.value);">
	<option value="desktop"><?php echo DESKTOP_WORD; ?></option>
    <option value="mobile"><?php echo MOBILE_WORD; ?></option>
    <option value="touchscreen"><?php echo TOUCHSCREEN_WORD; ?></option>
    <option value="all"><?php echo ALL_WORD; ?></option>
</select>
<br />
<div style="margin-top:10px; margin-left:40px; margin-bottom:-10px;">
<input type="checkbox" name="exclude" id="exclude" value="1" />
<?php echo MANAGE_STYLE_SHEET_ATT_EXCLUDE_FROM_LIST; ?>
</div>
</div>
<div class='button_console_add_disabled' id="btn_add_style_sheet" onClick="AddStyleSheet();"><span class='button_console_text_w_icon'><?php echo ADD_WORD; ?></span></div>
</div>

<div class="group_box_div">
<div class="sub_group_box_div">
<h3><?php echo MANAGE_STYLE_SHEET_ATT_DELETE_STYLE_SHEET; ?></h3>
<?php echo EDITOR_STYLE_SHEET; ?>: 
<select name="style_sheet_delete" id="style_sheet_delete" onChange="EnableDisableDeleteBtn();">
</select>
</div>
<div class='button_console_delete_disabled' id="btn_delete_style_sheet" onClick="DeleteStyleSheetConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
</div>

<div class="group_box_div">
<div class="sub_group_box_div">
<h3 style="margin-bottom:30px;"><?php echo MANAGE_STYLE_SHEET_ATT_RENAME_STYLE_SHEET; ?></h3>
<table>
	<tr>
    	<td><?php echo EDITOR_STYLE_SHEET; ?>:</td>
        <td><?php echo MANAGE_STYLE_SHEET_ATT_NEW_NAME; ?>:</td>
        <td><?php echo MANAGE_STYLE_SHEET_ATT_NEW_DESC; ?>:</td>
	</tr>
    <tr>
		<td><select name="style_sheet_old_name" id="style_sheet_old_name" onChange="PopulateDescription(this);">
</select></td>
		<td><input type="text" name="style_sheet_new_name" id="style_sheet_new_name" onChange="EnableDisableRenameBtn();" onKeyPress="CheckName(this);" /></td>
		<td><input type="text" name="new_description" id="new_description" onChange="EnableDisableRenameBtn();" /></td>
	</tr>
</table>


<div style="margin-top:10px; margin-left:40px; margin-bottom:-10px;">
<input type="checkbox" name="new_exclude" id="new_exclude" value="1" />
<?php echo MANAGE_STYLE_SHEET_ATT_EXCLUDE_FROM_LIST; ?>
<br />
<input type="checkbox" name="new_show_custom_styles" id="new_show_custom_styles" value="1" />
<?php echo MANAGE_STYLE_SHEET_ATT_SHOW_CUSTOM_STYLES; ?>
<br />
<input type="checkbox" name="show_all" id="show_all" value="1" onChange="PopulateRenameStyleSheetList(document.getElementById('sort_alpha_style_sheet').checked);" style="margin-top:40px; margin-bottom:-80px;" />
<span class="small_message"><?php echo MANAGE_STYLE_SHEET_ATT_SHOW_ALL; ?></span>
</div>
</div>
<div id="rename_copy_btn_grp">
<div class='button_console_edit_disabled' id="btn_rename_style_sheet" onClick="RenameCopyStyleSheet('rename');" style="margin-top:-50px;"><span class='button_console_text_w_icon'><?php echo RENAME_WORD; ?></span></div>
<div class='button_console_copy_disabled' id="btn_copy_style_sheet" onClick="RenameCopyStyleSheet('copy');" style="margin-top:-50px;"><span class='button_console_text_w_icon'><?php echo COPY_WORD; ?></span></div>
</div>
</div>


<div class="group_box_div">
<form name="formSortStyleSheets" id="formSortStyleSheets" method="post" action="set_style_sheet_sort_order.php">
<div id="style_sheet_sort_div">
</div>
</form>
</div>

</div>
     
     <?php include("lib/popup_msg.html"); ?>
     
<script>
	popup_msg.HidePopupMsg();
</script>
</body>
</html>