////////////////////////////////////////////////////////////////////////
// EB Content Management System
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// Created: 4/9/2013	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 4/24/2014	ELL
// Added ability to set target for event URL.


var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_schedule", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

//////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(desc_remove, ID, y_offset)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_1_MSG + desc_remove + CALENDAR_EVENTS_DELETE_EVENT_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.msg_width = 450;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteEvent(ID, desc_remove, y_offset); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteEvent(event_ID, desc_remove, row_to_delete)
{
	var params = "";

	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDIT_MENU_ITEMS_STARTING_DELETE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","delete_event.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "DeleteEvent", row_to_delete);
		params = "ID=" + event_ID;
		params = params + "&desc_remove=" + desc_remove;
		xmlhttp.send(params);
	}

	popup_msg.HidePopupMsg();
}

//////////////////////////////////////////////////////////////////////////////////////
function Update(j)
{
	if (!chkForm(j))
		return;
	var params = "";
	var ID_str = "ID" + j;
	var Description_str = "Description" + j;
	var EventDate_str = "EventDate" + j;
	var StartTime_str = "StartTime" + j;
	var EndTime_str = "EndTime" + j;
	var URL_str = "URL" + j;
	var target_str = "target" + j;
	var Active_str = "Active" + j;
	var user_table_str = "selectUserTable" + j;
	var UserID_str = "selectUserID" + j;
	var AccessLevel_str = "selectAccessLevel" + j;

	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_event.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Update");
		params = "ID=" + document.getElementById(ID_str).value;
		params = params + "&Description=" + document.getElementById(Description_str).value;
		params = params + "&EventDate=" + document.getElementById(EventDate_str).value;
		params = params + "&StartTime=" + document.getElementById(StartTime_str).value;
		params = params + "&EndTime=" + document.getElementById(EndTime_str).value;
		params = params + "&URL=" + document.getElementById(URL_str).value;
		params = params + "&target=" + document.getElementById(target_str).value;
		if (document.getElementById(Active_str).checked == true) params = params + "&Active=1";
		else params = params + "&Active=0";
		params = params + "&user_table=" + document.getElementById(user_table_str).value;
		params = params + "&UserID=" + document.getElementById(UserID_str).value;
		params = params + "&AccessLevel=" + document.getElementById(AccessLevel_str).value;
//		alert(params);
		xmlhttp.send(params);
	}
}

function chkForm(j)
{
	var bOKtoSend = true;
	var strItem;
	var dateField;
	var strDateField;
	
	strItem = "EventDate" + j;
	dateField = document.getElementById(strItem);
	//Remove white space for fair cheking of length.
	dateField.value = (dateField.value).replace(/^\s*|\s*$/g,'');
	strDateField = dateField.value;
	// Check for blank, incorrect legnth, or slashes not found in correct spot.
//		if ((strDateField == "") || (strDateField.length != 10) || (strDateField.indexOf("/") != 2) || (strDateField.lastIndexOf("/") != 5))
	if ((strDateField == "") || (strDateField.length != 10) || (strDateField.indexOf("-") != 4) || (strDateField.lastIndexOf("-") != 7))
	{
//			alert("Please fill in the date in the format of 'mm/dd/yyyy'.");
		alert(CALENDAR_EVENTS_DATE_FORMAT_MSG);
		dateField.focus();
		bOKtoSend = false;
	}
	return(bOKtoSend);
}

//////////////////////////////////////////////////////////////////////////////////////
	function UpdateMessage(xmlhttp, Source, row_to_delete)
	{
		var query_complete_no_record = QUERY_COMPLETE_NO_RECORD_FOUND;
		var query_complete = "<b>" + QUERY_COMPLETE + "</b><br/>";
		var query_read_to_send = QUERY_READY_TO_SEND;
		var query_sent = QUERY_SENT;
		var query_starting = CALENDAR_EVENTS_LOCATING_EVENTS_MSG;
		if (Source == "DeleteEvent")
		{
			query_complete_no_record = CALENDAR_EVENTS_COULD_NOT_DELETE_EVENT_MSG;
			query_complete = "<b>" + CALENDAR_EVENTS_EVENT_DELETED_MSG + "</b><br/>";
			query_starting = CALENDAR_EVENTS_DELETING_EVENT_MSG;
		}
		else if (Source == "Update")
		{
			query_complete_no_record = CALENDAR_EVENTS_COULD_NOT_UPDATE_EVENT_MSG;
			query_complete = "<b>" + CALENDAR_EVENTS_EVENT_UPDATED_MSG + "</b><br/>";
			query_starting = CALENDAR_EVENTS_UPDATING_EVENT_MSG;
		}
		else if (Source == "Populate")
		{
			query_complete_no_record = CALENDAR_EVENTS_COULD_NOT_UPDATE_USER_LISTS_MSG;
			query_complete = "<b>" + CALENDAR_EVENTS_USER_LIST_UPDATED_MSG + "</b><br/>";
			query_starting = CALENDAR_EVENTS_UPDATING_USER_LIST_MSG;
		}
		
		xmlhttp.onreadystatechange=function()
		{
			if (xmlhttp.readyState==4)
			{
				if (xmlhttp.responseText.length > 0)
				{
					var rows_str = xmlhttp.responseText;
					if (rows_str == "-no data-")
						popup_msg.status_msg = query_complete_no_record;
					else
					{
						popup_msg.status_msg = query_complete;
						if (Source == "DeleteEvent")
						{
							popup_msg.status_msg = rows_str;
							var tr_j = "tr_" + row_to_delete;
							document.getElementById(tr_j).style.display = "none";
						}
						else if (Source == "Update")
						{
							popup_msg.status_msg = rows_str;
							// Look for insert.
							if ((rows_str.indexOf("has been added.", 5)) > 0)
							{
								var id_arr = rows_str.split("[");
								var id = id_arr[1];
								id_arr = "";
								id_arr = id.split("]");
								id = id_arr[0];
								j = document.getElementById("rec_cnt").value - 1;
								var ID_str = "ID" + j;
								document.getElementById(ID_str).value = id;
								var tr_j = "tr_" + j;
								if (j%2)
									document.getElementById(tr_j).bgColor = "#EEEEEE";
								else
									document.getElementById(tr_j).bgColor = "#DDDDDD";
							}
						}
						else if (Source == "Populate")
						{	PopulateUsers(rows_str);	}
					}
				}
				else
					popup_msg.status_msg = query_complete_no_record;

				popup_msg.popup_timeout = 2000;
			}
			else if (xmlhttp.readyState==1)
				popup_msg.status_msg = query_read_to_send;
			else if (xmlhttp.readyState==2)
				popup_msg.status_msg = query_sent;
			else if (xmlhttp.readyState==3)
				popup_msg.status_msg = query_starting;
				
			popup_msg.ShowPopupMsg();
		}
		return (xmlhttp);
	}

////////////////////////////////////////////////////////////////////////////////////
function AddEvent()
{
	var j = document.getElementById("rec_cnt").value;
	var k = document.getElementById("row_cnt").value;
	var tr_j = "tr_" + j;
	document.getElementById(tr_j).style.display = "table-row";
	document.getElementById(tr_j).bgColor = "#FFFF99";

	/////////// Increment record count //////////////////
	j++;
	document.getElementById("rec_cnt").value = j;
	
	///// Check for spare rows, and if all used up, recommend save and refresh. /////
	if (j >= k)
	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 300;
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = CALENDAR_EVENTS_MEMORY_LIMIT_ERR;
		popup_msg.popup_timeout = -1;
		popup_msg.ShowPopupMsg();
	}
}

//////////////////////////////////////////////////////////////////////////////////////
var selected_row = -1;

function RetrieveUsers(user_table, i)
{	
	selected_row = i;

	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CALENDAR_EVENTS_STARTING_USER_QUERY_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","../populate_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Populate");
		params = "user_table=" + user_table + "&page=0&max_rec=10000";
//		alert(params);
		xmlhttp.send(params);
	}
}

function PopulateUsers(rows_str)
{
	var rows = new Array();

	var output_str = "<select name='selectUserID" + selected_row + "' id='selectUserID" + selected_row + "'>\n";
	output_str = output_str + "<option>-not selected-</option>\n";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
		var i = 0;
	else	// Create options for access level list.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			if (JSON_row.UserID)
				output_str = output_str + "<option value='" + JSON_row.UserID + "'>" + JSON_row.UserID + "</option>\n";
		}
	}
	output_str = output_str + "<\/select>\n";
	
	var UserID_td_str = "UserID" + selected_row + "_td";
	document.getElementById(UserID_td_str).innerHTML = output_str;
}

function PopulateTarget(i)
{
	var target_select_ctl = "target_select" + i;
	var target_ctl = "target" + i;
	var target = document.getElementById(target_select_ctl).value;
	document.getElementById(target_ctl).value = target;
	
	if ((target != "_self") && (target != "_blank"))
		document.getElementById(target_ctl).type = "text";
	else
		document.getElementById(target_ctl).type = "hidden";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}
