<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 8/20/09		ELL
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 7/29/2014	ELL
// Converted save functions to JQuery AJAX operations.
// Revised: 11/6/2014	ELL
// Added save to backup everytime save or publish is clicked.
// Revised: 11/10/2016	ELL
// Modified custom CSS editing to allow for any number of custom CSS records associated with custom style sheets.
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// 
//
//
	include ("check_session.php");
	include("lib/build_css_string.php");

	$style_sheet = $_POST['style_sheet'];
	$css_file = $style_sheet. ".css";
	$action = $_POST['action'];
	
	// Custom CSS
	$custom_css = $_POST['custom_css'];
	$custom_css = addslashes($custom_css);
	
	$today = date("Y-m-d H:i:s");
	
	if ($action == "Preview")
	{
		//Insert new data into table.
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE name = 'site_css_preview'";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() > 0)
			$query = "UPDATE " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "', revised = '" . $today . "' WHERE name = 'site_css_preview'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "', revised = '" . $today . "', name = 'site_css_preview'";
		$cnt = $bwb_dbh->exec($query);
		
			//Start by deleting all old data in table.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = 'site_css_preview'";
		$cnt = $bwb_dbh->exec($query);
			
			//Get data from live table and move to preview table.
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '$style_sheet'";
		$result = $bwb_dbh->query($query);
		$comma = ", ";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = 'site_css_preview'";
			foreach ($row as $field => $val)
			{
				if ($field != "style_sheet")	{
					$sql .= $comma . "`" . $field . "` = '" . $val . "'";
				}
			}
			$cnt = $bwb_dbh->exec($sql);
		}
	}
	else
	{
		// Whether saving draft of publishing, save latest revision to draft table.
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name='$style_sheet' AND `source`=3";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() > 0)	
			$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_draft SET page_content=:custom_css, revised='$today', `source`=3 WHERE page_name='$style_sheet'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_draft SET page_name='$style_sheet', page_content=:custom_css, revised='$today', `source`=3";
		$stmt = $bwb_dbh->prepare($query);
		$cnt = $stmt->execute(array(':custom_css' => $custom_css));
	
		if ($action == "Publish")	// Publish latest changes.
		{
			//Insert new data into table.
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE name = '" . $style_sheet . "'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)
				$query = "UPDATE " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "', revised = '" . $today . "' WHERE name = '" . $style_sheet . "'";
			else
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "', revised = '" . $today . "', name = '" . $style_sheet . "'";
			$cnt = $bwb_dbh->exec($query);
		}
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_bkup SET page_name='$style_sheet', page_content=:custom_css, revised='$today', source=3";
		$stmt = $bwb_dbh->prepare($query);
		$stmt->execute(array(':custom_css' => $custom_css));
	}

	/////////////////////////////////////////////
	// Build string for site.css file /////
	if ($action == "Preview")
		$style_sheet = "site_css_preview";
	
	$css_string = BuildCSSString($style_sheet, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX);
			

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if ($action == "Publish")
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
	else
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/site_preview.css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo "Could not rename $file_name to $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	
	//////////////////////////////////////////////////////////
	if ($cnt > 0)
		echo "Custom CSS has been saved";
	else
		echo "Save failed";
?>
