<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 9/1/2015	ELL

require_once('getid3/getid3.php');

$player = $_POST['player'];
$folder = $_POST['folder'];
$media_dir = $_POST['media_dir'];

function BuildAudioArray($player, $folder, $media_dir)
{
	// Build playlist elements string.
	$audio_files = array();
	$video_files = array();
	$audio_types = array("mp3", "m4a", "m4b", "m4p", "m4r", "aac", "wav", "ogg", "oga", "flac", "spx", "opus", "fla", "f4a", "f4b");
	$video_types = array("mp4", "m4v", "3gp", "3g2", "ogv", "ogx", "webm", "flv", "swf", "f4v", "f4p", "rtmp");
	$image_types = array("jpg", "png", "gif", "jpeg", "apng", "svg", "bmp", "dib", "ico");
	// Equivalents
	// Audio
	// .M4A = .m4b = .m4p = .m4r = .aac
	// .OGA = .ogg = .flac = .spx = .opus
	// .FLV = .f4a = .f4b
	// Video
	// .M4V = .mp4 = .3gp = .3g2
	// .OGV = .ogx
	// .FLV = .swf
	$m4a = array("m4b", "m4p", "m4r", "aac", "f4a", "f4b");
	$oga = array("ogg", "flac", "spx", "opus");
	$m4v = array("mp4", "3gp", "3g2");
	$fla = array("fla", "f4a", "f4b");
	
	$path = ".." . $media_dir . $folder;
	
	if ($handle = opendir($path)) 
	{
		$file_arr = array();
		while (false !== ($file = readdir($handle)))
		{
			if (($file != ".") && ($file != ".."))
			{
				$file_parts = explode(".", $file);
				$ext = strtolower($file_parts[count($file_parts) - 1]);
				if (in_array($ext, $audio_types) || in_array($ext, $video_types))
				{
					$file_arr[] = $file;
				}
			}
		}
		closedir($handle);
		
		sort($file_arr);
		$audio_row_delim = "";
		$video_row_delim = "";
		$audio_files_str = "";
		$video_files_str = "";
		foreach ($file_arr as $file)
		{
			$file_parts = explode(".", $file);
			$ext = strtolower($file_parts[count($file_parts) - 1]);
			if (in_array($ext, $image_types))
				continue;
			elseif (in_array($ext, $m4a))
				$ext = "m4a";
			elseif (in_array($ext, $oga))
				$ext = "oga";
			elseif (in_array($ext, $m4v))
				$ext = "m4v";
			elseif ($ext == 'ogx')
				$ext = "ogv";
			elseif ($ext == 'swf')
				$ext = "flv";
			elseif (in_array($ext, $fla))
				$ext = "fla";
			
			$getID3 = new getID3;

			$media_file = $path . "/" . $file;
			$FileInfo = $getID3->analyze($media_file);
			getid3_lib::CopyTagsToComments($FileInfo);

			$album = htmlentities(!empty($FileInfo['comments_html']['album'])  ? implode(',', $FileInfo['comments_html']['album']) : "");
			$artist = htmlentities(!empty($FileInfo['comments_html']['artist']) ? implode(',', $FileInfo['comments_html']['artist']) : "");
			$title = htmlentities(!empty($FileInfo['comments_html']['title'])  ? implode(',', $FileInfo['comments_html']['title']) : "");
			$genre = htmlentities(!empty($FileInfo['comments_html']['genre'])  ? implode(',', $FileInfo['comments_html']['genre']) : "");
			$time = htmlentities(!empty($FileInfo['playtime_string']) ? $FileInfo['playtime_string'] : "");
			if ($album == "")
				$album = htmlentities(!empty($FileInfo['comments']['album']) ? implode(',', $FileInfo['comments']['album']) : "");
			if ($artist == "")
				$artist = htmlentities(!empty($FileInfo['comments']['artist']) ? implode(',', $FileInfo['comments']['artist']) : "");
			if ($title == "")
				$title = htmlentities(!empty($FileInfo['comments']['title'])  ? implode(',', $FileInfo['comments']['title']) : "");
			if ($genre == "")
				$genre = htmlentities(!empty($FileInfo['comments']['genre'])  ? implode(',', $FileInfo['comments']['genre']) : "");
			if ($album == "")
				$album = htmlentities(!empty($FileInfo['asf']['comments']['album']) ? implode(',', $FileInfo['asf']['comments']['album']) : "");
			if ($artist == "")
				$artist = htmlentities(!empty($FileInfo['asf']['comments']['artist']) ? implode(',', $FileInfo['asf']['comments']['artist']) : "");
			if ($title == "")
				$title = htmlentities(!empty($FileInfo['asf']['comments']['title'])  ? implode(',', $FileInfo['asf']['comments']['title']) : "");
			if ($genre == "")
				$genre = htmlentities(!empty($FileInfo['asf']['comments']['genre'])  ? implode(',', $FileInfo['asf']['comments']['genre']) : "");
			$poster = htmlentities(!empty($FileInfo['lyrics3']['images'][0]['filename']) ? $FileInfo['lyrics3']['images'][0]['filename'] : "");
			if (!file_exists($path . "/" . $poster) && (substr($poster, 0, 4) != "http") && (substr($poster, 0, 10) != "data:image"))
				$poster = "";
			elseif (file_exists($path . "/" . $poster) && is_file($path . "/" . $poster))
				$poster = $path . "/" . $poster;
			$poster2 = htmlentities(!empty($FileInfo['comments']['picture'][0]['data']) ? $FileInfo['comments']['picture'][0]['data'] : "");
			if (($poster2 != "") && (strlen($poster2) > 100))
				$poster = $poster2;
			
			if (!isset($title) || ($title == ""))
				$title = $file_parts[count($file_parts) - 2];
			
			if (in_array($ext, $audio_types))	{
				$audio_files[$title] = array(player => $player, file => $file, ext => $ext, title => $title, artist => $artist, poster => $poster);
				$audio_files_str .= $audio_row_delim . json_encode($audio_files[$title]);
				$audio_row_delim = "@@@@@";
			}
			elseif (in_array($ext, $video_types))	{
				$video_files[$title] = array(player => $player, file => $file, ext => $ext, title => $title, artist => $artist, poster => $poster);
				$video_files_str .= $video_row_delim . json_encode($video_files[$title]);
				$video_row_delim = "@@@@@";
			}
		}
		echo $audio_files_str . ":::::" . $video_files_str;
		return(1);
	}
	else
	{
		return(0);
	}
}

BuildAudioArray($player, $folder, $media_dir);
?>