CREATE TABLE `bwb_version` (
`version` VARCHAR( 32 ) NOT NULL ,
PRIMARY KEY ( `version` )
) ENGINE = MYISAM ;

INSERT INTO `bwb_version` (`version`) VALUES ('6.5.02');


CREATE TABLE IF NOT EXISTS `bwb_access_levels` (
  `access_level` varchar(64) NOT NULL,
  PRIMARY KEY  (`access_level`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_access_levels` (`access_level`) VALUES
('admin'),
('power_user'),
('restricted'),
('user');


CREATE TABLE IF NOT EXISTS `bwb_blogs` (
  `id` bigint(20) NOT NULL auto_increment,
  `post` longtext,
  `page_name` varchar(255) NOT NULL,
  `owner` varchar(255) default NULL,
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_blogs_bkup` (
  `ID` bigint(20) NOT NULL auto_increment,
  `blog_id` bigint(20) NOT NULL,
  `page_name` varchar(255) default NULL,
  `post` longtext,
  `owner` varchar(255) default NULL,
  `revised` datetime default NULL,
  `deleted` datetime default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_blogs_draft` (
  `id` bigint(20) NOT NULL auto_increment,
  `blog_id` bigint(20) NOT NULL,
  `post` longtext,
  `revised` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_captcha` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `challenge` varchar(255) NOT NULL,
  `response` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=96 ;

INSERT INTO `bwb_captcha` (`id`, `challenge`, `response`) VALUES
(7, 'captcha1.png', 'KY5Y'),
(8, 'captcha2.png', 'thtmxs'),
(9, 'captcha3.png', '12444'),
(10, 'captcha4.png', 'gousme'),
(11, 'captcha5.png', 'methro'),
(12, 'captcha6.png', '8AJPRPHV'),
(13, 'captcha7.png', '7W3I'),
(14, 'captcha8.png', 'Pne6F'),
(15, 'captcha9.png', '8BVM'),
(16, 'captcha10.png', 'PhfK8'),
(17, 'captcha11.png', '0K9XB'),
(18, 'captcha12.png', '28iVW'),
(19, 'captcha13.png', 'k4ez'),
(20, 'captcha14.png', 'jw62k'),
(21, 'captcha15.png', 'FH2DE'),
(22, 'captcha16.png', 'gwprp'),
(23, 'captcha17.png', '4D7YS'),
(24, 'captcha18.png', 'e5hb'),
(25, 'captcha19.png', 'xmqki'),
(26, 'captcha20.png', '6ne3'),
(27, 'captcha21.png', 'XDHYN'),
(28, 'captcha22.png', 'q98p'),
(29, 'captcha23.png', 'HRAI'),
(30, 'captcha24.png', '4R3A'),
(31, 'captcha25.png', 'ZYPEB'),
(32, 'captcha26.png', 'N65X'),
(33, 'captcha27.png', 'DYZB2'),
(34, 'captcha28.png', '4ZUDA'),
(35, 'captcha29.png', '243424'),
(36, 'captcha30.png', 'DOGY'),
(37, 'captcha31.png', 'TICA'),
(38, 'captcha32.png', 'AKOF'),
(39, 'captcha33.png', 'IXYCO'),
(40, 'captcha34.png', 'Ministry'),
(41, 'captcha35.png', 'Tried'),
(42, 'captcha36.png', 'ZSf69'),
(43, 'captcha37.png', 'CS6T5'),
(44, 'captcha38.png', 'SXGPT'),
(45, 'captcha39.png', '5GC6R'),
(46, 'captcha40.png', '5S4UG'),
(47, 'captcha41.png', 'RJ28Q'),
(48, 'captcha42.png', '4P3X4'),
(49, 'captcha43.png', 'NOW'),
(50, 'captcha44.png', 'lengrat&'),
(51, 'captcha45.png', 'ideas'),
(52, 'captcha46.png', 'is easy'),
(53, 'captcha47.png', 'just'),
(54, 'captcha48.png', 'use'),
(55, 'captcha49.png', 'Captcha'),
(56, 'captcha50.png', 'Code'),
(57, 'captcha51.png', 'fhrc'),
(58, 'captcha52.png', 'cralsist'),
(59, 'captcha53.png', 'unrexc'),
(60, 'captcha54.png', 'vohte'),
(61, 'captcha55.png', 'dutne'),
(62, 'captcha56.png', 'sondted'),
(63, 'captcha57.png', 'pliaom'),
(64, 'captcha58.png', 'unbadnar'),
(65, 'captcha59.png', 'aphxleci'),
(66, 'captcha60.png', 'tegunt'),
(67, 'captcha61.png', 'ejuje'),
(68, 'captcha62.png', 'unnedou'),
(69, 'captcha63.png', 'vedsho'),
(70, 'captcha64.png', 'trapperb'),
(71, 'captcha65.png', 'wans'),
(72, 'captcha66.png', 'py8894'),
(73, 'captcha67.png', '4TEF'),
(74, 'captcha68.png', 'leopard'),
(75, 'captcha69.png', 'Marks'),
(76, 'captcha70.png', 'nsuldGW'),
(77, 'captcha71.png', 'natural'),
(78, 'captcha72.png', 'Brook'),
(79, 'captcha73.png', 'Reports'),
(80, 'captcha74.png', 'overlooks'),
(81, 'captcha75.png', 'inquiry'),
(82, 'captcha76.png', 'storsce'),
(83, 'captcha77.png', 'Theretr'),
(84, 'captcha78.png', 'them'),
(85, 'captcha79.png', 'urethras'),
(86, 'captcha80.png', 'Mr blocked'),
(88, 'captcha82.png', 'rehiring it'),
(89, 'captcha83.png', 'G5RRP'),
(90, 'captcha84.png', 'KK3J6'),
(91, 'captcha85.png', 'F64FE'),
(92, 'captcha86.png', 'BSXJY'),
(93, 'captcha87.png', 'WZHWR'),
(94, 'captcha88.png', 'VHMB2'),
(95, 'captcha89.png', 'polthed'),
(96, 'captcha11.png', '9K9XB'),
(97, 'captcha11.png', 'QK9XB'),
(98, 'captcha8.png', 'PNe6f'),
(99, 'captcha10.png', 'Phfk8'),
(100, 'captcha10.png', 'phfK8'),
(101, 'captcha10.png', 'phfk8'),
(102, 'captcha12.png', '28ivw'),
(103, 'captcha14.png', 'jw62K'),
(104, 'captcha19.png', 'xmqKi'),
(105, 'captcha19.png', 'xmgki'),
(106, 'captcha19.png', 'xmgKi'),
(107, 'captcha28.png', 'AZUDA'),
(108, 'captcha36.png', 'zsf69'),
(109, 'captcha44.png', 'lencrat&'),
(110, 'captcha44.png', 'lenerat&'),
(111, 'captcha48.png', 'usa'),
(112, 'captcha51.png', 'flirc'),
(113, 'captcha54.png', 'valite'),
(114, 'captcha55.png', 'dultne'),
(115, 'captcha56.png', 'sonated'),
(116, 'captcha57.png', 'plicrom'),
(117, 'captcha58.png', 'unbachar'),
(118, 'captcha61.png', 'ejujle'),
(119, 'captcha65.png', 'wrans'),
(120, 'captcha76.png', 'Storsce'),
(121, 'captcha10.png', 'PhfKB'),
(122, 'captcha10.png', 'PhfkB'),
(123, 'captcha10.png', 'phfKB'),
(124, 'captcha10.png', 'phfkB');


CREATE TABLE `bwb_custom_site_css` (
  `name` varchar(64) NOT NULL default '',
  `custom_css` longtext,
  `revised` DATETIME NULL,
  PRIMARY KEY  (`name`)
) ;


CREATE TABLE IF NOT EXISTS `bwb_fonts` (
  `font` varchar(255) NOT NULL default '',
  `websafe` tinyint(4) NOT NULL default '0',
  `src` varchar(255) NULL,
  `stretch` VARCHAR( 32 ) NULL,
  `style` VARCHAR( 16 ) NULL,
  `weight` VARCHAR( 16 ) NULL,
  PRIMARY KEY  (`font`, `src`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_fonts` (`font`, `websafe`) VALUES
('Alba', 0),
('Algerian', 0),
('Arial', 1),
('Arial Rounded MT Bold', 0),
('Bangle', 0),
('Baskerville Old Face', 0),
('Bodini MT', 0),
('Britannic Bold', 0),
('Broadway', 0),
('Comic Sans MS', 1),
('Edwardian Script ITC', 0),
('Geneva', 0),
('Helvetica', 1),
('Helvetica Neue', 0),
('Rockwell Condensed', 0),
('Tahoma', 1),
('Vivaldi', 0),
('Times New Roman', 1),
('Verdana', 1),
('Papyrus', 0),
('Garamond', 0),
('Bradley Hand ITC', 0),
('Brush Script MT', 0),
('BRADDON', 0),
('Amaze', 0),
('Bookman Old Style', 0),
('Century Gothic', 0),
('Cooper Black', 0),
('Courier New', 1),
('Elephant', 0),
('Engravers MT', 0),
('Franklin Gothic Book', 0),
('Georgia', 1),
('sans-serif', 1),
('serif', 1),
('monospace', 1),
('cursive', 1),
('fantasy', 1),
('Trebuchet MS', 1),
('Lucida Sans', 1),
('Arial Black', 1),
('Courier', 1),
('Impact', 1),
('Charcoal', 1),
('Lucida Console', 1),
('Monaco', 1),
('Lucida Sans Unicode', 1),
('Lucida Grande', 1),
('Palatino Linotype', 1),
('Book Antiqua', 1),
('Palatino', 1),
('Symbol', 1),
('Webdings', 1),
('Wingdings', 1),
('Zapf Dingbats', 1),
('New York', 1),
('MS Serif', 1),
('Felix', 0),
('Felix Titling', 0),
('Monotype Corsiva', 0),
('Rage Italic', 0),
('Agency FB', 0),
('Haettenschweiler', 0),
('Forte', 0),
('Lucida Calligraphy', 0),
('Lucida Handwriting', 0),
('Magneto', 0),
('Mistral', 0),
('Old English Text MT', 0),
('Short Hand', 0),
('Stencil', 0),
('Westminster', 0),
('Berlin Sans FB', 0),
('BalloonEFDropShadow', 0),
('Tempus Sans ITC', 0),
('Pussycat', 0),
('Script MT Bold', 0),
('Calibri', 0),
('Ravie', 0);


CREATE TABLE `bwb_head` (
  `id` int(11) NOT NULL auto_increment,
  `head_name` varchar(255) default NULL,
  `head_content` longtext,
  `plugins` VARCHAR(64) NULL,
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_head` (`id`, `head_name`, `head_content`, `revised`) VALUES
(1, 'head', '<STYLE TYPE=\\"text/css\\">\r\n.pagebreak { page-break-after: always;}\r\n</STYLE>\r\n\r\n', '0000-00-00 00:00:00');


CREATE TABLE IF NOT EXISTS `bwb_login_attempts` (
  `id` bigint(20) NOT NULL auto_increment,
  `UserID` varchar(50) NOT NULL,
  `IP` varchar(40) NOT NULL,
  `AttemptTimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `Success` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_menus` (
  `menu_name` varchar(64) NOT NULL,
  `description` varchar(255) default NULL,
  `proportional` tinyint(4) NOT NULL default '0',
  `proportional_sub` tinyint(4) NOT NULL default '0',
  `top_down_on_sub_down` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`menu_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_menus` (`menu_name`, `description`, `proportional`, `proportional_sub`, `top_down_on_sub_down`) VALUES
('menu1', 'Menu 1', 0, 0, 0),
('menu1_mobile', 'Menu 1 Mobile', 0, 0, 0),
('menu1_touchscreen', 'Menu 1 Touchscreen', 0, 0, 0),
('menu2', 'Menu 2', 0, 0, 0),
('menu2_mobile', 'Menu 2 Mobile', 0, 0, 0),
('menu2_touchscreen', 'Menu 2 Touchscreen', 0, 0, 0);


CREATE TABLE IF NOT EXISTS `bwb_menu_assignments` (
  `menu_name` varchar(64) NOT NULL,
  `border_area` varchar(64) NOT NULL,
  PRIMARY KEY  (`menu_name`,`border_area`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE `bwb_menu_items` (
  `ID` int(11) NOT NULL auto_increment,
  `menu` varchar(64) NOT NULL default '',
  `item_text` varchar(64) NOT NULL default '',
  `level` int(11) default NULL,
  `URL` varchar(255) default NULL,
  `target` varchar(32) default NULL,
  `name` VARCHAR( 64 ) default NULL,
  `mega_menu` VARCHAR( 255 ) NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
)  AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_meta_tags` (
  `page_name` varchar(255) NOT NULL default '',
  `owner` varchar(255) default NULL,
  `author` varchar(255) default NULL,
  `lanquage` varchar(255) default NULL,
  `copyright` varchar(255) default NULL,
  `description` longtext,
  `abstract` longtext,
  `keywords` longtext,
  `subject` longtext,
  `robots_index` tinyint(4) default NULL,
  `robots_follow` tinyint(4) default NULL,
  `robots_revisit` int(11) default NULL,
  PRIMARY KEY  (`page_name`)
) ;

CREATE TABLE `bwb_meta_tags_template` (
  `id` int(11) NOT NULL auto_increment,
  `meta_tags_template` longtext NOT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

INSERT INTO `bwb_meta_tags_template` (`id`, `meta_tags_template`) VALUES
(1, '<?php\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "meta_tags WHERE page_name = ''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$owner = $row["owner"];\r\n		$author = $row["author"];\r\n		$lanquage = $row["lanquage"];\r\n		$copyright = $row["copyright"];\r\n		$description = $row["description"];\r\n		$abstract = $row["abstract"];\r\n		$keywords = $row["keywords"];\r\n		$subject = $row["subject"];\r\n		$robots_index = $row["robots_index"];\r\n		$robots_follow = $row["robots_follow"];\r\n		$robots_revisit = $row["robots_revisit"];\r\n		\r\n		if ($lanquage)\r\n			echo "<META HTTP-EQUIV=\\"LANGUAGE\\" CONTENT=\\"$lanquage\\">\\r\\n";\r\n		if ($owner)\r\n			echo "<meta name=\\"OWNER\\" content=\\"$owner\\">\\r\\n";\r\n		if ($author)\r\n			echo "<META NAME=\\"AUTHOR\\" CONTENT=\\"$author\\">\\r\\n";\r\n			\r\n		if (($robots_index == 1) && ($robots_follow == 1))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"INDEX, FOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 1) && ($robots_follow == 0))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"INDEX, NOFOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 0) && ($robots_follow == 1))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"NOINDEX, FOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 0) && ($robots_follow == 0))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"NOINDEX, NOFOLLOW\\">\\r\\n";\r\n	\r\n		if ($robots_revisit)\r\n			echo "<META NAME=\\"REVISIT-AFTER\\" CONTENT=\\"$robots_revisit days\\">\\r\\n";\r\n		if ($copyright)\r\n			echo "<META NAME=\\"COPYRIGHT\\" CONTENT=\\"$copyright\\">\\r\\n";\r\n		if ($description)\r\n			echo "<META NAME=\\"DESCRIPTION\\" CONTENT=\\"$description\\">\\r\\n";\r\n		if ($abstract)\r\n			echo "<META NAME=\\"ABSTACT\\" CONTENT=\\"$abstract\\">\\r\\n";\r\n		if ($keywords)\r\n			echo "<META NAME=\\"KEYWORDS\\" CONTENT=\\"$keywords\\">\\r\\n";\r\n		if ($subject)\r\n			echo "<META NAME=\\"SUBJECT\\" CONTENT=\\"$subject\\">\\r\\n";\r\n\r\n	}\r\n?>');



CREATE TABLE IF NOT EXISTS `bwb_options` (
  `id` int(11) NOT NULL auto_increment,
  `option_name` varchar(63) NOT NULL default '',
  `option_string` varchar(255) NOT NULL default '',
  `option_string_define` varchar(128) NULL,
  `option_value` varchar(63) NOT NULL default '',
  `option_image` varchar(255) default NULL,
  `data_type` int(11) NOT NULL default '0',
  `sort_order` int(11) NOT NULL default '0',
  `dropdown_sort_order` int(11) NOT NULL default '0',
  `refresh_main` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_options` (`id`, `option_name`, `option_string`, `option_string_define`, `option_value`, `option_image`, `data_type`, `sort_order`, `dropdown_sort_order`, `refresh_main`) VALUES
(3, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left_right', 'top_bottom_left_right.jpg', 0, 5, 110, 0),
(4, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_left_right', 'top_left_right.jpg', 0, 5, 130, 0),
(5, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top', 'top.jpg', 0, 5, 145, 0),
(6, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_left', 'top_left.jpg', 0, 5, 135, 0),
(7, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'basic', 'basic.jpg', 0, 5, 155, 0),
(8, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom', 'top_bottom.jpg', 0, 5, 140, 0),
(9, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'left', 'left.jpg', 0, 5, 150, 0),
(10, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left', 'top_bottom_left.jpg', 0, 5, 125, 0),
(11, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left_right_alt', 'top_bottom_left_right_alt.jpg', 0, 5, 115, 0),
(21, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left_right_alt2', 'top_bottom_left_right_alt2.jpg', 0, 5, 120, 0),
(24, 'ForcePageNameToLowerCase', 'Force Page Name To Lower Case', 'OPTIONS_FORCE_PAGE_NAME_TO_LOWER_CASE', '0', NULL, 2, 50, 0, 0),
(26, 'EnableWizard', 'Enable Wizard', 'OPTIONS_ENABLE_WIZARD', '1', NULL, 2, 20, 0, 1),
(28, 'RunWizardLocal', 'Run Wizard Local (Check only if template repository and Breeze installation are on same server.)', 'OPTIONS_RUN_WIZARD_LOCAL', '0', NULL, 2, 25, 0, 1),
(29, 'EnableFileManager', 'Enable File Manager for Restricted Users', 'OPTIONS_ENABLE_FILE_MANAGER_FOR_RESTRICTED_USERS', '0', NULL, 2, 30, 0, 0),
(30, 'ActivateNewUsersAutomatically', 'Activate New Users Automatically', 'OPTIONS_ACTIVATE_NEW_USERS_AUTOMATICALLY', '0', NULL, 2, 40, 0, 0),
(32, 'UseTableStructure', 'Use Table Structure', 'OPTIONS_USE_TABLE_STRUCTURES', '1', NULL, 2, 10, 0, 0),
(33, 'UseTableStructureMobile', 'Use Table Structure on Mobile', 'OPTIONS_USE_TABLE_STRUCTURES_ON_MOBILE', '0', NULL, 2, 15, 0, 0),
(34, 'CreateAcctLinkTxt', 'Create Account Link Text', 'OPTIONS_CREATE_ACCOUNT_LINK_TEXT', 'Create Account', NULL, 1, 100, 0, 0),
(35, 'LoginLinkTxt', 'Login Link Text', 'OPTIONS_LOGIN_LINK_TEXT', 'Login', NULL, 1, 110, 0, 0),
(36, 'MyAcctLinkTxt', 'My Account Link Text', 'OPTIONS_MY_ACCOUNT_LINK_TEXT', 'My Account', NULL, 1, 120, 0, 0),
(37, 'LogoutLinkTxt', 'Logout Link Text', 'OPTIONS_LOGOUT_LINK_TEXT', 'Logout', NULL, 1, 130, 0, 0),
(38, 'CreateAcctLink', 'Create Account Link', 'OPTIONS_CREATE_ACCOUNT_LINK', 'create_account.php', NULL, 1, 140, 0, 0),
(39, 'LoginLink', 'Login Link', 'OPTIONS_LOGIN_LINK', 'login.php', NULL, 1, 150, 0, 0),
(40, 'MyAcctLink', 'My Account Link', 'OPTIONS_MY_ACCOUNT_LINK', 'my_account.php', NULL, 1, 160, 0, 0),
(42, 'LogoutRedirectOverride', 'Logout Redirect Override', 'OPTIONS_LOGOUT_REDIRECT_OVERRIDE', '', NULL, 1, 135, 0, 0),
(45, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'default', 'default.jpg', 0, 160, 10, 0),
(46, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', '3024-day', '3024-day.jpg', 0, 170, 20, 0),
(47, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', '3024-night', '3024-night.jpg', 0, 170, 20, 0),
(48, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'ambiance', 'ambiance.jpg', 0, 180, 30, 0),
(49, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'base16-dark', 'base16-dark.jpg', 0, 190, 40, 0),
(50, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'base16-light', 'base16-light.jpg', 0, 200, 50, 0),
(51, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'blackboard', 'blackboard.jpg', 0, 210, 60, 0),
(52, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'cobalt', 'cobalt.jpg', 0, 220, 70, 0),
(53, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'eclipse', 'eclipse.jpg', 0, 230, 80, 0),
(54, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'elegant', 'elegant.jpg', 0, 240, 90, 0),
(55, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'erlang-dark', 'erlang-dark.jpg', 0, 250, 100, 0),
(56, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'lesser-dark', 'lesser-dark.jpg', 0, 270, 110, 0),
(57, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'mbo', 'mbo.jpg', 0, 280, 120, 0),
(58, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'mdn-like', 'mdn-like.jpg', 0, 290, 130, 0),
(59, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'midnight', 'midnight.jpg', 0, 300, 140, 0),
(60, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'monokai', 'monokai.jpg', 0, 310, 150, 0),
(61, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'neat', 'neat.jpg', 0, 320, 160, 0),
(62, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'neo', 'neo.jpg', 0, 330, 170, 0),
(63, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'night', 'night.jpg', 0, 340, 180, 0),
(64, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'paraiso-dark', 'paraiso-dark.jpg', 0, 350, 190, 0),
(65, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'paraiso-light', 'paraiso-light.jpg', 0, 360, 200, 0),
(66, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'pastel-on-dark', 'pastel-on-dark.jpg', 0, 370, 210, 0),
(67, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'rubyblue', 'rubyblue.jpg', 0, 380, 220, 0),
(68, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'solarized dark', 'solarized-dark.jpg', 0, 390, 230, 0),
(69, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'solarized light', 'solarized-light.jpg', 0, 400, 240, 0),
(70, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'the-matrix', 'the-matrix.jpg', 0, 410, 250, 0),
(71, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'tomorrow-night-bright', 'tomorrow-night-bright.jpg', 0, 420, 260, 0),
(72, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'tomorrow-night-eighties', 'tomorrow-night-eighties.jpg', 0, 430, 270, 0),
(73, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'twilight', 'twilight.jpg', 0, 440, 280, 0),
(74, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'vibrant-ink', 'vibrant-ink.jpg', 0, 450, 290, 0),
(75, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'xq-dark', 'xq-dark.jpg', 0, 460, 300, 0),
(76, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'xq-light', 'xq-light.jpg', 0, 470, 310, 0),
(77, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'zenburn', 'zenburn.jpg', 0, 480, 320, 0),
(78, 'Theme', 'Breeze Website Builder Theme', 'OPTIONS_BREEZE_WEBSITE_BUILDER_THEME', 'classic', 'classic_theme.jpg', 0, 500, 5, 0),
(79, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer', 'header_footer.jpg', 0, 5, 55, 0),
(80, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header', 'header.jpg', 0, 5, 105, 0),
(81, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left_right', 'header_footer_top_bottom_left_right.jpg', 0, 5, 10, 0),
(82, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_left_right', 'header_footer_top_left_right.jpg', 0, 5, 30, 0),
(83, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top', 'header_footer_top.jpg', 0, 5, 45, 0),
(84, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_left', 'header_footer_top_left.jpg', 0, 5, 35, 0),
(85, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom', 'header_footer_top_bottom.jpg', 0, 5, 40, 0),
(86, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left_right_alt', 'header_footer_top_bottom_left_right_alt.jpg', 0, 5, 15, 0),
(87, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left_right_alt2', 'header_footer_top_bottom_left_right_alt2.jpg', 0, 5, 20, 0),
(88, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left_right', 'header_top_bottom_left_right.jpg', 0, 5, 60, 0),
(89, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_left_right', 'header_top_left_right.jpg', 0, 5, 80, 0),
(90, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top', 'header_top.jpg', 0, 5, 95, 0),
(91, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_left', 'header_top_left.jpg', 0, 5, 85, 0),
(92, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom', 'header_top_bottom.jpg', 0, 5, 90, 0),
(93, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left_right_alt', 'header_top_bottom_left_right_alt.jpg', 0, 5, 65, 0),
(94, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left_right_alt2', 'header_top_bottom_left_right_alt2.jpg', 0, 5, 70, 0),
(95, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_left', 'header_footer_left.jpg', 0, 5, 50, 0),
(96, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_left', 'header_left.jpg', 0, 5, 100, 0),
(97, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left', 'header_footer_top_bottom_left.jpg', 0, 5, 25, 0),
(98, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left', 'header_top_bottom_left.jpg', 0, 5, 75, 0),
(99, 'LockoutClearAllCustomCSSClasses', 'Lockout Clear All Custom CSS Classes', 'OPTIONS_LOCKOUT_CLEAR_ALL_CUSTOM_CSS_CLASSES', '1', NULL, 2, 60, 0, 0),
(100, 'LockoutCopyStyleSheetToMobile', 'Lockout Copy Style Sheet to Mobile', 'OPTIONS_LOCKOUT_COPY_STYLE_SHEET_TO_MOBILE', '0', NULL, 2, 70, 0, 0);


CREATE TABLE `bwb_options_selected` (
  `option_name` varchar(63) NOT NULL default '0',
  `option_value` varchar(63) default NULL,
  PRIMARY KEY  (`option_name`)
) ;

INSERT INTO `bwb_options_selected` (`option_name`, `option_value`) VALUES
('EnableWizard', '1'),
('EnableFileManager', '0'),
('CreateAcctLinkTxt', 'Create Account'),
('CreateAcctLink', 'create_account.php'),
('ActivateNewUsersAutomatically', '0'),
('ForcePageNameToLowerCase', '1'),
('LoginLink', 'login.php'),
('LoginLinkTxt', 'Login'),
('LogoutLinkTxt', 'Logout'),
('MyAcctLink', 'my_account.php'),
('MyAcctLinkTxt', 'My Account'),
('RunWizardLocal', '0'),
('Template', 'header_footer_top_bottom_left_right'),
('UseTableStructure', '1'),
('UseTableStructureMobile', '0'),
('LogoutRedirectOverride', ''),
('CodeMirrorTheme', 'rubyblue'),
('Theme', 'classic'),
('LockoutClearAllCustomCSSClasses', '1'),
('LockoutCopyStyleSheetToMobile', '0');


CREATE TABLE `bwb_page_cache` (
  `id` int(11) NOT NULL default '0',
  `tmp_page_data` longtext,
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE `bwb_page_data` (
  `id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `template` VARCHAR( 64 ) NULL DEFAULT 'top_bottom_left_right',
  `use_table_structure` TINYINT NOT NULL DEFAULT '0',
  `use_table_structure_mobile` TINYINT NOT NULL DEFAULT '0',
  `login_required` TINYINT NOT NULL DEFAULT '0',
  `user_table` VARCHAR(64) NULL,
  `AccessLevel` VARCHAR(64) NULL,
  `login_page` VARCHAR(255) NULL,
  `show_login_links` TINYINT NOT NULL DEFAULT '0',
  `plugins` VARCHAR(64) NULL,
  `disable_site_styles` TINYINT NOT NULL DEFAULT '0',
  `body_onload` TINYINT NOT NULL DEFAULT '0',
  `body_onload_function` VARCHAR( 255 ) NULL,
  `head_name` VARCHAR( 255 ) NOT NULL DEFAULT 'head',
  `header_name` VARCHAR( 255 ) NOT NULL DEFAULT 'header',
  `top_name` VARCHAR( 255 ) NOT NULL DEFAULT 'top',
  `left_name` VARCHAR( 255 ) NOT NULL DEFAULT 'left',
  `right_name` VARCHAR( 255 ) NOT NULL DEFAULT 'right',
  `bottom_name` VARCHAR( 255 ) NOT NULL DEFAULT 'bottom',
  `footer_name` VARCHAR( 255 ) NOT NULL DEFAULT 'footer',
  `insert_default_head` TINYINT NOT NULL DEFAULT '0',
  `insert_default_header` TINYINT NOT NULL DEFAULT '0',
  `insert_default_top` TINYINT NOT NULL DEFAULT '0',
  `insert_default_left` TINYINT NOT NULL DEFAULT '0',
  `insert_default_right` TINYINT NOT NULL DEFAULT '0',
  `insert_default_bottom` TINYINT NOT NULL DEFAULT '0',
  `insert_default_footer` TINYINT NOT NULL DEFAULT '0',
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_page_data_bkup` (
  `ID` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `revised` DATETIME NULL DEFAULT NULL,
  `deleted` DATETIME NULL DEFAULT NULL,
  `source` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_page_data_special` (
  `id` int(11) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `plugins` VARCHAR(64) NULL,
  `disable_site_styles` tinyint(4) NOT NULL DEFAULT '0',
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `bwb_page_data_draft` (
  `id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `revised` datetime default NULL,
  `source` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_page_data_special` (`id`, `page_name`, `page_content`) VALUES (1, 'top', 'Top'),
 (2, 'bottom', 'Bottom'),
 (3, 'left', 'Left'),
 (4, 'right', 'Right'),
 (5, 'header', ''),
 (6, 'footer', '');


CREATE TABLE `bwb_page_titles` (
  `page_name` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`page_name`)
) ;


CREATE TABLE IF NOT EXISTS `bwb_plugins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL UNIQUE,
  `description` varchar(255) DEFAULT NULL,
  `category` VARCHAR(255) DEFAULT NULL,
  `parent` VARCHAR( 64 ) NULL,
  `default_page_name` VARCHAR( 64 ) NULL,
  `page_name_suffix` VARCHAR( 64 ) NULL,
  `style_sheet` varchar(64) DEFAULT NULL,
  `style_sheet_description` varchar(255) DEFAULT NULL,
  `class_sql` longtext,
  `css_sql` longtext,
  `custom_css_sql` longtext,
  `head_code` longtext,
  `head_html` longtext,
  `header_code` longtext,
  `header_html` longtext,
  `top_code` longtext,
  `top_html` longtext,
  `left_code` longtext,
  `left_html` longtext,
  `content_code` longtext,
  `content_html` longtext,
  `right_code` longtext,
  `right_html` longtext,
  `bottom_code` longtext,
  `bottom_html` longtext,
  `footer_code` longtext,
  `footer_html` longtext,
  `console_path` varchar(255) DEFAULT NULL,
  `console_link_text` varchar(128) DEFAULT NULL,
  `console_link_image` varchar(255) DEFAULT NULL,
  `console_link_image_mo` varchar(255) DEFAULT NULL,
  `console_link_image_down` varchar(255) DEFAULT NULL,
  `help_path` varchar(255) DEFAULT NULL,
  `language_folder` varchar(255) DEFAULT NULL,
  `console_link_text_define` varchar(128) DEFAULT NULL,
  `menu_group` varchar(64) DEFAULT NULL,
  `plugin_sql` longtext,
  `AccessLevel` varchar(20) DEFAULT NULL,
  `available` tinyint(4) NOT NULL DEFAULT '1',
  `disable_site_styles` tinyint(4) NOT NULL DEFAULT '0',
  `body_onload` tinyint(4) NOT NULL DEFAULT '0',
  `body_onload_function` varchar(255) NULL,
  `sort_order` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=30 ;

INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(1, 'Events Grid', 'Table of events from top oldest to bottom newest.', 'Calendars and Events', NULL, 'events', NULL, 'calendar', 'Calendar and Event Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'calendar\', \'.events_div\', \'Surrounding Event Grid Div\', 10, 0, 0),\r\n(\'calendar\', \'.events_table\', \'Event Table\', 20, 0, 0),\r\n(\'calendar\', \'.events_tr_head\', \'Event Grid Header Row\', 30, 0, 0),\r\n(\'calendar\', \'.events_td_head\', \'Event Grid Header Cells\', 40, 0, 0),\r\n(\'calendar\', \'.events_tr\', \'Event Grid Rows\', 50, 0, 0),\r\n(\'calendar\', \'.events_td\', \'Event Grid Cells\', 60, 0, 0),\r\n(\'calendar\', \'.calendar_div\', \'Surrounding Calendar Grid Div\', 70, 0, 0),\r\n(\'calendar\', \'.calendar_table\', \'Calendar Grid Table\', 80, 0, 0),\r\n(\'calendar\', \'.calendar_tr_head\', \'Calendar Grid Month Header Row\', 90, 0, 0),\r\n(\'calendar\', \'.calendar_td_head\', \'Calendar Grid Month Header Cells\', 100, 0, 0),\r\n(\'calendar\', \'.calendar_tr_head2\', \'Calendar Grid Days Header Row\', 110, 0, 0),\r\n(\'calendar\', \'.calendar_td_head2\', \'Calendar Grid Days Header Cells\', 120, 0, 0),\r\n(\'calendar\', \'.calendar_tr\', \'Calendar Grid Rows\', 130, 0, 0),\r\n(\'calendar\', \'.calendar_td\', \'Calendar Grid Cells\', 140, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a\', \'Calendar Grid Month Header Cells A\', 150, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a:link\', \'Calendar Grid Month Header Cells A:Link\', 160, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a:hover\', \'Calendar Grid Month Header Cells A:Hover\', 170, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a:visited\', \'Calendar Grid Month Header Cells A:Visited\', 180, 0, 0),\r\n(\'calendar\', \'.calendar_td a\', \'Calendar Grid Cells A\', 190, 0, 0),\r\n(\'calendar\', \'.calendar_td a:link\', \'Calendar Grid Cells A:Link\', 200, 0, 0),\r\n(\'calendar\', \'.calendar_td a:hover\', \'Calendar Grid Cells A:Hover\', 210, 0, 0),\r\n(\'calendar\', \'.calendar_td a:visited\', \'Calendar Grid Cells A:Visited\', 220, 0, 0),\r\n(\'calendar\', \'.events_td a\', \'Event Grid Cells A\', 61, 0, 0),\r\n(\'calendar\', \'.events_td a:link\', \'Event Grid Cells A:Link\', 62, 0, 0),\r\n(\'calendar\', \'.events_td a:hover\', \'Event Grid Cells A:Hover\', 63, 0, 0),\r\n(\'calendar\', \'.events_td a:visited\', \'Event Grid Cells A:Visited\', 64, 0, 0),\r\n(\'calendar\', \'.events_tr > .events_td:first-child\', \'Event Descripton Cell\', 65, 0, 0),\r\n(\'calendar\', \'.calendar_hebrew\', \'Calendar Hebrew Text\', 240, 0, 0),\r\n(\'calendar\', \'.calendar_hebrew_header\', \'Calendar Hebrew Header Text\', 230, 0, 0),\r\n(\'calendar\', \'.calendar_nav_links\', \'Nav Links\', 250, 500, 0),\r\n(\'calendar\', \'.calendar_nav_table\', \'Nav Links Table\', 260, 500, 0),\r\n(\'calendar\', \'.calendar_month_year\', \'Month/Year Heading\', 255, 500, 0),\r\n(\'calendar\', \'.calendar_event\', \'Calendar Event\', 270, 500, 0),\r\n(\'calendar\', \'.events_tr_a\', \'Row A Background Color\', 280, 500, 0),\r\n(\'calendar\', \'.events_tr_b\', \'Row B Background Color\', 285, 500, 0),\r\n(\'calendar_mobile\', \'.events_table\', \'Event Table\', 20, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_div\', \'Surrounding Calendar Grid Div\', 70, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_event\', \'Calendar Event\', 270, 500, 1),\r\n(\'calendar_mobile\', \'.calendar_hebrew\', \'Calendar Hebrew Text\', 240, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_hebrew_header\', \'Calendar Hebrew Header Text\', 230, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_nav_links\', \'Nav Links\', 250, 500, 1),\r\n(\'calendar_mobile\', \'.calendar_nav_table\', \'Nav Links Table\', 260, 500, 1),\r\n(\'calendar_mobile\', \'.calendar_table\', \'Calendar Grid Table\', 80, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td\', \'Calendar Grid Cells\', 140, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a\', \'Calendar Grid Cells A\', 190, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a:hover\', \'Calendar Grid Cells A:Hover\', 210, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a:link\', \'Calendar Grid Cells A:Link\', 200, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a:visited\', \'Calendar Grid Cells A:Visited\', 220, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head\', \'Calendar Grid Month Header Cells\', 100, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a\', \'Calendar Grid Month Header Cells A\', 150, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:hover\', \'Calendar Grid Month Header Cells A:Hover\', 170, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:link\', \'Calendar Grid Month Header Cells A:Link\', 160, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:visited\', \'Calendar Grid Month Header Cells A:Visited\', 180, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head2\', \'Calendar Grid Days Header Cells\', 120, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_tr\', \'Calendar Grid Rows\', 130, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head\', \'Calendar Grid Month Header Row\', 90, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head2\', \'Calendar Grid Days Header Row\', 110, 0, 0),\r\n(\'calendar_mobile\', \'.events_div\', \'Surrounding Event Grid Div\', 10, 0, 0),\r\n(\'calendar_mobile\', \'.events_td\', \'Event Grid Cells\', 60, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a\', \'Event Grid Cells A\', 61, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a:hover\', \'Event Grid Cells A:Hover\', 63, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a:link\', \'Event Grid Cells A:Link\', 62, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a:visited\', \'Event Grid Cells A:Visited\', 64, 0, 0),\r\n(\'calendar_mobile\', \'.events_tr > .events_td:first-child\', \'Event Descripton Cell\', 65, 0, 0),\r\n(\'calendar_mobile\', \'.events_td_head\', \'Event Grid Header Cells\', 40, 0, 0),\r\n(\'calendar_mobile\', \'.events_tr\', \'Event Grid Rows\', 50, 0, 0),\r\n(\'calendar_mobile\', \'.events_tr_head\', \'Event Grid Header Row\', 30, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_month_year\', \'Month/Year Heading\', 255, 500, 0),\r\n(\'calendar_mobile\', \'.events_tr_a\', \'Row A Background Color\', 280, 500, 0),\r\n(\'calendar_mobile\', \'.events_tr_b\', \'Row B Background Color\', 285, 500, 0);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`) VALUES\r\n(\'calendar\', \'.calendar_td a:visited\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td a:hover\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#8900F2\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_td a:link\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.events_td a:visited\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.events_td a:hover\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#8900F2\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_td_head a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_td_head a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_hebrew_header\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFF00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td a\', 0, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head a:hover\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFDDDD\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_hebrew\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#000088\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head a\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_tr_head2\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#CDCCF4\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_tr_head\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.events_tr_head\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0);\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`) VALUES\r\n(\'calendar\', \'.events_tr_a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#DDDDDD\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_tr_b\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#EEEEEE\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr_a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#DDDDDD\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr_b\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#EEEEEE\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'8.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0);\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`) VALUES\r\n(\'calendar\', \'.events_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'32.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_tr > .events_td:first-child\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'8.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr > .events_td:first-child\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'1.00\', 0, \'#3e51b7\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'8.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'1.00\', 0, \'#cdccf4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_nav_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'4.00\', 0, \'#3e51b7\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#CDCCF4\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'32.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'4.00\', 0, \'#cdccf4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'14.000\', 1, \'-not selected-\', \'-1.000\', 0, \'150.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFDDDD\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFDDDD\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#8900F2\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_hebrew_header\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFF00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_hebrew\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#000088\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_nav_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'36.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<?php\r\n///////////// Schedule Code ///////////////////////////////////////////\r\n// Breeze Website Builder\r\n// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.\r\n// Last revised: 6/15/2007\r\n// Revised: 9/10/2008  Added active flag.	ELL\r\n// Revised: 8/1/2009  ELL\r\n// Added class hooks for styling.\r\n// Revised: 3/25/2010	ELL\r\n// Combined standard and hebrew calendars into one.  Setting show_hebrew = 1 causes calendar to show Hebrew dates.\r\n// Revised: 9/1/2010	ELL\r\n// Added show_past switch to show or hide past dates.  Past dates will now be hidden by default.  Set show_past=1 to override default.\r\n// Revised: 2/6/2012	ELL\r\n// Added table prefix option.\r\n// Revised: 7/6/2012	ELL\r\n// Added filtering by users and groups.\r\n// Revised: 4/24/2014	ELL\r\n// Added ability to set target for event URL.\r\n// Revised: 10/5/2017	ELL\r\n// Removed all hard-coded styles which are now handled with CSS.\r\n// Added row A and row B classes to allow alternating rows to be colored by CSS.\r\n// Added ability to etract GET params from SEF URLs which is switched on or off in the config file.\r\n// Changed reference for $UserID to $userid to mahch current page-template layout file.\r\n//\r\n\r\n	if (SEF_URL == 1)\r\n		include($php_dir_rel . \"get_params_from_sef_url.php\");\r\n	\r\n	$show_hebrew = $_GET[\'show_hebrew\'];\r\n	if (!isset($show_hebrew)) $show_hebrew = 0;\r\n	$show_past = $_GET[\'show_past\'];\r\n	if (!isset($show_past)) $show_past = 0;\r\n	$events_user_table = $_GET[\'user_table\'];\r\n	$events_UserID = $_GET[\'UserID\'];\r\n	$events_AccessLevel = $_GET[\'AccessLevel\'];\r\n	$use_logged_in_credentials = $_GET[\'use_logged_in_credentials\'];\r\n	if ($_GET[\'descending\'])\r\n		$descending = \"DESC\";\r\n	\r\n	$where = \" WHERE (`Active` = 1)\";\r\n	$today = date(\"Y-m-d\");\r\n	if ($show_past != 1)\r\n		$where .= \" AND (EventDateSort >= \'$today\')\";\r\n	\r\n	if ($use_logged_in_credentials)\r\n	{\r\n		if ($events_user_table)\r\n			$where .= \" AND (user_table = \'$user_table\')\";\r\n		if ($events_UserID)\r\n			$where .= \" AND (UserID = \'$userid\')\";\r\n		if ($events_AccessLevel)\r\n			$where .= \" AND (AccessLevel = \'$AccessLevel\')\";\r\n	}\r\n	else\r\n	{\r\n		if ($events_user_table != 1)\r\n			$user_table = $events_user_table;\r\n		if ($events_UserID != 1)\r\n			$userid = $events_UserID;\r\n		if ($events_AccessLevel != 1)\r\n			$AccessLevel = $events_AccessLevel;\r\n			\r\n		if (($events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND ((user_table = \'$user_table\') AND ((UserID = \'$userid\') OR (AccessLevel = \'$AccessLevel\')))\";\r\n		elseif (($events_user_table) && (!$events_UserID) && (!$events_AccessLevel))\r\n			$where .= \" AND (user_table = \'$user_table\')\";\r\n		elseif ((!$events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= \" AND (UserID = \'$userid\')\";\r\n		elseif ((!$events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND (AccessLevel = \'$AccessLevel\')\";\r\n		elseif (($events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= \" AND (user_table = \'$user_table\') AND (UserID = \'$userid\')\";\r\n		elseif (($events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND (user_table = \'$user_table\') AND (AccessLevel = \'$AccessLevel\')\";\r\n		elseif ((!$events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND ((UserID = \'$userid\') OR (AccessLevel = \'$AccessLevel\'))\";\r\n	}\r\n	\r\n	$query = \"SELECT * FROM \" . BWB_TABLE_PREFIX . \"schedule\" . $where . \" ORDER BY `EventDateSort`\";\r\n	if ($descending) $query .= \" $descending\";\r\n	\r\n	$result = $bwb_dbh->query($query);\r\n	$num_results = $result->rowCount();\r\n	echo \"<div class=\'events_div\'>\\n\";\r\n	echo \"<table class=\'events_table\'>\\n\";\r\n	echo \"<tr class=\'events_tr_head\'>\\n\";\r\n	echo \"<td class=\'events_td_head\'>Description</td>\\n\";\r\n	echo \"<td class=\'events_td_head\'>Date</td>\\n\";\r\n	echo \"<td class=\'events_td_head\'>Start Time</td>\\n\";\r\n	echo \"<td class=\'events_td_head\'>End Time</td>\\n\";\r\n	if ($show_hebrew == 1)\r\n		echo \"<td class=\'events_td_head\'>Hebrew Date</td>\\n\";\r\n	echo \"</tr>\\n\";\r\n	for ($i = 0; $i < $num_results; $i++)\r\n	{\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	\r\n		$Description = $row[\"Description\"];\r\n		$EventDate = $row[\"EventDate\"];\r\n		$StartTime = $row[\"StartTime\"];\r\n		$EndTime = $row[\"EndTime\"];\r\n		$URL = $row[\"URL\"];\r\n		$target = $row[\"target\"];\r\n		$Description = stripslashes($Description);\r\n		$EventDate = stripslashes($EventDate);\r\n		$StartTime = stripslashes($StartTime);\r\n		$EndTime = stripslashes($EndTime);\r\n		$URL = stripslashes($URL);\r\n		$target = stripslashes($target);\r\n		\r\n		if ($show_hebrew == 1)\r\n		{\r\n			list($month, $day, $year) = split(\'[/.-]\', $EventDate);\r\n			// Get Jewish date\r\n			$julian_date = gregoriantojd($month, $day, $year);\r\n			$jewishdate = jdtojewish($julian_date);\r\n			// Find the Jewish calendar date and parse out the day and year values\r\n			list ($jc_month, $jc_day, $jc_year) = explode (\'/\', $jewishdate);\r\n			// Find the Jewish calendar month name\r\n			$jc_month = jdmonthname ($julian_date, 4);\r\n			$HebrewDate = \"$jc_day $jc_month\";\r\n		}\r\n		\r\n		if ($bgclr_class == \"events_tr_a\")\r\n			$bgclr_class = \"events_tr_b\";\r\n		else\r\n			$bgclr_class = \"events_tr_a\";\r\n		\r\n		echo \"<tr class=\'events_tr $bgclr_class\'>\\n\";\r\n		if ($URL)\r\n			echo \"<td class=\'events_td\'><a href=\'$URL\' target=\'$target\'>$Description</a></td>\\n\";\r\n		else\r\n			echo \"<td class=\'events_td\'>$Description</td>\\n\";\r\n			\r\n		echo \"<td class=\'events_td\'>$EventDate</td>\\n\";\r\n		echo \"<td class=\'events_td\'>$StartTime</td>\\n\";\r\n		echo \"<td class=\'events_td\'>$EndTime</td>\\n\";\r\n		if ($show_hebrew == 1)\r\n			echo \"<td class=\'events_td\'>$HebrewDate</td>\\n\";\r\n		echo \"</tr>\\n\";\r\n	}\r\n	echo \"</table>\\n\";\r\n	echo \"</div>\\n\";\r\n	/////////////////////////////////////////////////////////////////////////\r\n?>', '<span style=\"color: rgb(255, 0, 0);\">{*** delete *** \r\n<p>The events grid is not edited here. To add events to the events grid, go back to the main menu and click the <b><em>Revise Schedule</em></b> button.  The change the look and colors of your events grid, Click the <b><em>Edit Styles</em></b> button and select <b><em>Calendar and Event Styles</em></b>.</p>\r\n</span>\r\n<p><span style=\"color: rgb(255, 0, 0);\">You can pass parameters in the URL to this page to control certain aspects of this events grid. For instance, sending <strong>show_past=1</strong> will cause the events grid to show dates that are in the past. By default, only events on this day or later will be displayed. As an extra bonus, you can also display Hebrew dates by sending <strong>show_hebrew=1</strong>.</span></p>\r\n<span style=\"color: rgb(255, 0, 0);\">\r\n\r\n<p>You may also setup events to be private to a single user or to a group. To do that, add the following parameters to your URL:<strong> user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong>. You may also add <strong>use_logged_in_credentials</strong> to your URL and set its value to <strong>1</strong>. If you send <strong>use_logged_in_credentials</strong>, then the variabless <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> which of the credentials are used from the logged-in session to filter the events using and <strong>AND</strong> comparator. i.e. if <strong>user_table</strong> and <strong>UserID</strong> are set, then all events with the user <strong>UserID</strong> from the table <strong>user_table</strong> will be selected, but <u>not</u> the same <strong>UserID</strong> from <u>another</u> <strong>user_table</strong>. The formula for this is:</p>\r\n</span>\r\n<p><span style=\"color: rgb(255, 0, 0);\">(<strong>user_table</strong>) AND (<strong>UserID)</strong> AND (<strong>AccessLevel</strong>) where any one or two of these variables may be ommitted.</span></p>\r\n<span style=\"color: rgb(255, 0, 0);\">\r\n<p>An example of a  complete URL might be:</p>\r\n</span>\r\n<p><span style=\"color: rgb(255, 0, 0);\">events.php?show_past=1&amp;user_table=1&amp;AccessLevel=1&amp;UserID=1</span></p>\r\n\r\n<p><span style=\"color: rgb(255, 0, 0);\">If <strong>use_logged_in_credentials</strong> is not set, then <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are handled in a different manner. Instead, the values passed in these variables are to be used explicitly, and not those of any logged in session. They are also combined somewhat differently. i.e., if all three variables <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then all events assigned to users of user ID <strong>UserID</strong>, and all users of access level <strong>AccessLevel</strong> from and only from the user table user_table will be shown. If only <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then events assigned to user <strong>UserID</strong>, or with access level <strong>AccessLevel</strong> will be selected reguardless of which user table they may be in. The  formula is:</span></p><span style=\"color: rgb(255, 0, 0);\">\r\n<p> (<strong>user_table</strong>) AND ((<strong>UserID</strong> OR (<strong>AccessLevel</strong>)) where any one or two of these variables may be ommitted.</p>\r\n<p>If for some reason you desire to display your events grid from lastest at the to to oldest at the bottom, simple add<strong> descending=1</strong> to your URL. An example of a complete URL might be:</p>\r\n<p>events.php?user_table=accounts_form&amp;AccessLevel=user&amp;UserID=Joe&amp;descending=1</p>\r\n\r\n*** delete *** }</span>', NULL, NULL, NULL, NULL, NULL, NULL, './plugins/edit_schedule.php', 'Revise Schedule', './plugins/images/icon_Edit-Events.png', './plugins/images/icon_Edit-Events_mo.png', './plugins/images/icon_Edit-Events_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#events_grid', 'manage/plugins/lang/calendar_events', 'CALENDAR_EVENTS_REVISE_SCHEDULE_BTN', 'content_functions', NULL, 'user', 1, 0, 0, NULL, 10);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(12, 'MP3 Audio Player, Standard', 'Premiumbeat music player, for single of multiple tracks', 'Audio', NULL, 'audio', NULL, NULL, NULL, NULL, NULL, NULL, '<?php\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$playlist_path = $doc_root . "/" . BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	else\r\n	{\r\n		$needle = "/" . BWB_BASE_DIR . "/";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$playlist_path = $path_start . "/" . BWB_BASE_DIR . "/" .BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = "../" . BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	\r\n	// Build xml playlist string.\r\n	$playlist = "<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n\\n";\r\n	$playlist .= "<playlist>\\n";\r\n	$indent = "   ";\r\n	$srch = array(".mp3", ".MP3", ".Mp3");\r\n	if ($handle = opendir("$playlist_path")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != ".") && ($file != ".."))\r\n			{\r\n				if (!(stripos($file, ".mp3") === false))\r\n				{\r\n					$title = str_replace($srch, "", $file);\r\n					$playlist .= $indent . "<item>\\n";\r\n					$playlist .= $indent . $indent . "<title>" . $title . "</title>\\n";\r\n					$playlist .= $indent . $indent . "<artist></artist>\\n";\r\n					$playlist .= $indent . $indent . "<path>" . $playlist_path_rel . $file . "</path>\\n";\r\n					$playlist .= $indent . "</item>\\n";\r\n				}\r\n			}\r\n		}\r\n		closedir($handle);\r\n	}\r\n	$playlist .= "</playlist>\\n";\r\n	\r\n	// Save xml playlist.\r\n	$file_name = $playlist_path . "/playlist.xml";\r\n	\r\n	// Delete old file.\r\n	if (file_exists($file_name))\r\n	{\r\n		if (!unlink($file_name))\r\n			echo "Could not delete old playlist.<br>";\r\n	}\r\n	\r\n	// Create new file.\r\n	$fh = fopen($file_name, ''x'') or die("Can''t create $file_name: $php_errormsg");\r\n	$result = (fputs($fh, $playlist));\r\n	fclose($fh) or die($php_errormsg);\r\n	@chmod($file_name, 0755);\r\n?>', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<div align="center">\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/OriginalMusicPlayer.swf" height="86" id="player1" type="application/x-shockwave-flash" width="225">\r\n<param name="movie" id="movie" value="../flash/OriginalMusicPlayer.swf" />\r\n<param name="FlashVars" id="FlashVars" value="mediaPath=../media/sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object> \r\n</div>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n// Note:  This probably only works in Opera.  You may need to manually change the data path to player1.\r\n	var player_path = flash_dir_rel + "OriginalMusicPlayer.swf";\r\n	document.getElementById("player1").setAttribute("data", player_path);\r\n	document.getElementById("movie").value = player_path;\r\n	var media_path = "mediaPath=" + media_dir_rel + "sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999";\r\n	document.getElementById("FlashVars").value = media_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 65);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(3, 'Calendar Grid', 'Monthly Calendar Grid, includes Hebrew as well as Gregorian.', 'Calendars and Events', NULL, 'calendar', NULL, 'calendar', 'Calendar and Event Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'calendar\', \'.events_div\', \'Surrounding Event Grid Div\', 10, 0, 0),\r\n(\'calendar\', \'.events_table\', \'Event Table\', 20, 0, 0),\r\n(\'calendar\', \'.events_tr_head\', \'Event Grid Header Row\', 30, 0, 0),\r\n(\'calendar\', \'.events_td_head\', \'Event Grid Header Cells\', 40, 0, 0),\r\n(\'calendar\', \'.events_tr\', \'Event Grid Rows\', 50, 0, 0),\r\n(\'calendar\', \'.events_td\', \'Event Grid Cells\', 60, 0, 0),\r\n(\'calendar\', \'.calendar_div\', \'Surrounding Calendar Grid Div\', 70, 0, 0),\r\n(\'calendar\', \'.calendar_table\', \'Calendar Grid Table\', 80, 0, 0),\r\n(\'calendar\', \'.calendar_tr_head\', \'Calendar Grid Month Header Row\', 90, 0, 0),\r\n(\'calendar\', \'.calendar_td_head\', \'Calendar Grid Month Header Cells\', 100, 0, 0),\r\n(\'calendar\', \'.calendar_tr_head2\', \'Calendar Grid Days Header Row\', 110, 0, 0),\r\n(\'calendar\', \'.calendar_td_head2\', \'Calendar Grid Days Header Cells\', 120, 0, 0),\r\n(\'calendar\', \'.calendar_tr\', \'Calendar Grid Rows\', 130, 0, 0),\r\n(\'calendar\', \'.calendar_td\', \'Calendar Grid Cells\', 140, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a\', \'Calendar Grid Month Header Cells A\', 150, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a:link\', \'Calendar Grid Month Header Cells A:Link\', 160, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a:hover\', \'Calendar Grid Month Header Cells A:Hover\', 170, 0, 0),\r\n(\'calendar\', \'.calendar_td_head a:visited\', \'Calendar Grid Month Header Cells A:Visited\', 180, 0, 0),\r\n(\'calendar\', \'.calendar_td a\', \'Calendar Grid Cells A\', 190, 0, 0),\r\n(\'calendar\', \'.calendar_td a:link\', \'Calendar Grid Cells A:Link\', 200, 0, 0),\r\n(\'calendar\', \'.calendar_td a:hover\', \'Calendar Grid Cells A:Hover\', 210, 0, 0),\r\n(\'calendar\', \'.calendar_td a:visited\', \'Calendar Grid Cells A:Visited\', 220, 0, 0),\r\n(\'calendar\', \'.events_td a\', \'Event Grid Cells A\', 61, 0, 0),\r\n(\'calendar\', \'.events_td a:link\', \'Event Grid Cells A:Link\', 62, 0, 0),\r\n(\'calendar\', \'.events_td a:hover\', \'Event Grid Cells A:Hover\', 63, 0, 0),\r\n(\'calendar\', \'.events_td a:visited\', \'Event Grid Cells A:Visited\', 64, 0, 0),\r\n(\'calendar\', \'.events_tr > .events_td:first-child\', \'Event Descripton Cell\', 65, 0, 0),\r\n(\'calendar\', \'.calendar_hebrew\', \'Calendar Hebrew Text\', 240, 0, 0),\r\n(\'calendar\', \'.calendar_hebrew_header\', \'Calendar Hebrew Header Text\', 230, 0, 0),\r\n(\'calendar\', \'.calendar_nav_links\', \'Nav Links\', 250, 500, 0),\r\n(\'calendar\', \'.calendar_nav_table\', \'Nav Links Table\', 260, 500, 0),\r\n(\'calendar\', \'.calendar_month_year\', \'Month/Year Heading\', 255, 500, 0),\r\n(\'calendar\', \'.calendar_event\', \'Calendar Event\', 270, 500, 0),\r\n(\'calendar\', \'.events_tr_a\', \'Row A Background Color\', 280, 500, 0),\r\n(\'calendar\', \'.events_tr_b\', \'Row B Background Color\', 285, 500, 0),\r\n(\'calendar_mobile\', \'.events_table\', \'Event Table\', 20, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_div\', \'Surrounding Calendar Grid Div\', 70, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_event\', \'Calendar Event\', 270, 500, 1),\r\n(\'calendar_mobile\', \'.calendar_hebrew\', \'Calendar Hebrew Text\', 240, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_hebrew_header\', \'Calendar Hebrew Header Text\', 230, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_nav_links\', \'Nav Links\', 250, 500, 1),\r\n(\'calendar_mobile\', \'.calendar_nav_table\', \'Nav Links Table\', 260, 500, 1),\r\n(\'calendar_mobile\', \'.calendar_table\', \'Calendar Grid Table\', 80, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td\', \'Calendar Grid Cells\', 140, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a\', \'Calendar Grid Cells A\', 190, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a:hover\', \'Calendar Grid Cells A:Hover\', 210, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a:link\', \'Calendar Grid Cells A:Link\', 200, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td a:visited\', \'Calendar Grid Cells A:Visited\', 220, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head\', \'Calendar Grid Month Header Cells\', 100, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a\', \'Calendar Grid Month Header Cells A\', 150, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:hover\', \'Calendar Grid Month Header Cells A:Hover\', 170, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:link\', \'Calendar Grid Month Header Cells A:Link\', 160, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:visited\', \'Calendar Grid Month Header Cells A:Visited\', 180, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_td_head2\', \'Calendar Grid Days Header Cells\', 120, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_tr\', \'Calendar Grid Rows\', 130, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head\', \'Calendar Grid Month Header Row\', 90, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head2\', \'Calendar Grid Days Header Row\', 110, 0, 0),\r\n(\'calendar_mobile\', \'.events_div\', \'Surrounding Event Grid Div\', 10, 0, 0),\r\n(\'calendar_mobile\', \'.events_td\', \'Event Grid Cells\', 60, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a\', \'Event Grid Cells A\', 61, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a:hover\', \'Event Grid Cells A:Hover\', 63, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a:link\', \'Event Grid Cells A:Link\', 62, 0, 0),\r\n(\'calendar_mobile\', \'.events_td a:visited\', \'Event Grid Cells A:Visited\', 64, 0, 0),\r\n(\'calendar_mobile\', \'.events_tr > .events_td:first-child\', \'Event Descripton Cell\', 65, 0, 0),\r\n(\'calendar_mobile\', \'.events_td_head\', \'Event Grid Header Cells\', 40, 0, 0),\r\n(\'calendar_mobile\', \'.events_tr\', \'Event Grid Rows\', 50, 0, 0),\r\n(\'calendar_mobile\', \'.events_tr_head\', \'Event Grid Header Row\', 30, 0, 0),\r\n(\'calendar_mobile\', \'.calendar_month_year\', \'Month/Year Heading\', 255, 500, 0),\r\n(\'calendar_mobile\', \'.events_tr_a\', \'Row A Background Color\', 280, 500, 0),\r\n(\'calendar_mobile\', \'.events_tr_b\', \'Row B Background Color\', 285, 500, 0);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`) VALUES\r\n(\'calendar\', \'.calendar_td a:visited\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td a:hover\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#8900F2\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_td a:link\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.events_td a:visited\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.events_td a:hover\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#8900F2\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_td_head a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_td_head a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_hebrew_header\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFF00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td a\', 0, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head a:hover\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFDDDD\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_hebrew\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#000088\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head a\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_tr_head2\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#CDCCF4\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.calendar_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_tr_head\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0),\r\n(\'calendar\', \'.events_tr_head\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'0.00\', -1, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0);\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`) VALUES\r\n(\'calendar\', \'.events_tr_a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#DDDDDD\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_tr_b\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#EEEEEE\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr_a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#DDDDDD\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr_b\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#EEEEEE\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'8.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0);\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`) VALUES\r\n(\'calendar\', \'.events_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'32.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.events_tr > .events_td:first-child\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'8.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr > .events_td:first-child\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'1.00\', 0, \'#3e51b7\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'8.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'1.00\', 0, \'#cdccf4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.events_tr_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar\', \'.calendar_nav_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'4.00\', 0, \'#3e51b7\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#3e51b7\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_tr_head2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#CDCCF4\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'32.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'left\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'4.00\', 0, \'#cdccf4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'14.000\', 1, \'-not selected-\', \'-1.000\', 0, \'150.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFFFF\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFDDDD\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFDDDD\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#8900F2\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#442C8C\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_hebrew_header\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#FFFF00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_hebrew\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#000088\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_nav_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0),\r\n(\'calendar_mobile\', \'.calendar_td_head2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'36.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<?php\r\n///////////// Calendar Code ///////////////////////////////////////////\r\n// Breeze Website Builder\r\n// Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.\r\n// Revised: 6/15/2007\r\n// Revised: 8/6/2007	Added pagebreak div.\r\n// Revised: 9/10/2008  Added active flag.	ELL\r\n// Revised: 8/1/2009  ELL\r\n// Added class hooks for styling.\r\n// Revised: 3/25/2010	ELL\r\n// Added ability to scroll thru months on a single calendar grid.  Added switch to go back and forth betmeen \r\n// showing all grids as before, or using new single grid with nav links on top. Default is new single grid view.\r\n// Combined standard and hebrew calendars into one.  Setting show_hebrew = 1 causes calendar to show Hebrew dates.\r\n// Revised: 6/1/2010	ELL\r\n// Modified to go to this (as in now) month if going to calender first time.  (No forwards/backwards clicked yet.)\r\n// Revised: 9/1/2010	ELL\r\n// Added show_past switch to show or hide past dates.  Past dates will now be hidden by default.  Set show_past=1 to override default.\r\n// Revised: 2/6/2012	ELL\r\n// Added table prefix option.\r\n// Revised: 7/7/2012	ELL\r\n// Added filtering by users and groups.\r\n// Revised: 4/24/2014	ELL\r\n// Added ability to set target for event URL.\r\n// Revised: 2/1/2017	ELL\r\n// Replaced inline stlyes with style hooks to make mobile-ready styles easier to implement.\r\n// Revised: 10/5/2017	ELL\r\n// Removed hard-coded styles which are now handled with CSS.\r\n// Added ability to etract GET params from SEF URLs which is switched on or off in the config file.\r\n// Changed reference for $UserID to $userid to mahch current page-template layout file.\r\n	\r\n	$month_count = 0;\r\n	$month = array();\r\n	$day = array();\r\n	$year = array();\r\n	$Description = array();\r\n	$EventDate = array();\r\n	$StartTime = array();\r\n	$EndTime = array();\r\n    $URL = array();\r\n	$target = array();\r\n	\r\n	if (SEF_URL == 1)\r\n		include($php_dir_rel . \"get_params_from_sef_url.php\");\r\n	\r\n	$curr_mth = $_GET[\'curr_mth\'];\r\n	if (!isset($curr_mth)) $curr_mth = 0;\r\n	$mth_change = $_GET[\'mth_change\'];\r\n	$show_all = $_GET[\'show_all\'];\r\n	if (!isset($show_all)) $show_all = 0;\r\n	$show_hebrew = $_GET[\'show_hebrew\'];\r\n	if (!isset($show_hebrew)) $show_hebrew = 0;\r\n	$script_name = $_SERVER[\'SCRIPT_FILENAME\'];\r\n	if (SEF_URL == 1)	$script_name = str_replace(\".php\", \"\", $this_page);\r\n	$pos = strrpos(\"$script_name\", \"/\");\r\n	if ($pos !== false)	$script_name = substr($script_name, ($pos + 1));\r\n	$show_past = $_GET[\'show_past\'];\r\n	if (!isset($show_past)) $show_past = 0;\r\n	$events_user_table = $_GET[\'user_table\'];\r\n	$events_UserID = $_GET[\'UserID\'];\r\n	$events_AccessLevel = $_GET[\'AccessLevel\'];\r\n	$use_logged_in_credentials = $_GET[\'use_logged_in_credentials\'];\r\n	\r\n	$where = \" WHERE (`Active` = 1)\";\r\n	$today = date(\"Y-m-d\");\r\n	if ($show_past != 1)\r\n		$where .= \" AND (EventDateSort >= \'$today\')\";\r\n	\r\n	if ($use_logged_in_credentials)\r\n	{\r\n		if ($events_user_table)\r\n			$where .= \" AND (user_table = \'$user_table\')\";\r\n		if ($events_UserID)\r\n			$where .= \" AND (UserID = \'$userid\')\";\r\n		if ($events_AccessLevel)\r\n			$where .= \" AND (AccessLevel = \'$AccessLevel\')\";\r\n	}\r\n	else\r\n	{\r\n		if ($events_user_table != 1)\r\n			$user_table = $events_user_table;\r\n		if ($events_UserID != 1)\r\n			$userid = $events_UserID;\r\n		if ($events_AccessLevel != 1)\r\n			$AccessLevel = $events_AccessLevel;\r\n			\r\n		if (($events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND ((user_table = \'$user_table\') AND ((UserID = \'$userid\') OR (AccessLevel = \'$AccessLevel\')))\";\r\n		elseif (($events_user_table) && (!$events_UserID) && (!$events_AccessLevel))\r\n			$where .= \" AND (user_table = \'$user_table\')\";\r\n		elseif ((!$events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= \" AND (UserID = \'$userid\')\";\r\n		elseif ((!$events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND (AccessLevel = \'$AccessLevel\')\";\r\n		elseif (($events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= \" AND (user_table = \'$user_table\') AND (UserID = \'$userid\')\";\r\n		elseif (($events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND (user_table = \'$user_table\') AND (AccessLevel = \'$AccessLevel\')\";\r\n		elseif ((!$events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= \" AND ((UserID = \'$userid\') OR (AccessLevel = \'$AccessLevel\'))\";\r\n	}\r\n	\r\n	$query = \"SELECT * FROM \" . BWB_TABLE_PREFIX . \"schedule\" . $where . \" ORDER BY `EventDateSort`\";\r\n	\r\n	$result = $bwb_dbh->query($query);\r\n	$num_results = $result->rowCount();\r\n\r\n	for ($i = 0; $i < $num_results; $i++)\r\n	{\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$Description[$i] = stripslashes($row[\"Description\"]);\r\n		$EventDate[$i] = $row[\"EventDate\"];\r\n		$StartTime[$i] = $row[\"StartTime\"];\r\n		$EndTime[$i] = $row[\"EndTime\"];\r\n		$URL[$i] = $row[\"URL\"];\r\n		$target[$i] = $row[\"target\"];\r\n		list($month[$i], $day[$i], $year[$i]) = split(\'[/.-]\', $EventDate[$i]);\r\n		if ($month[$i] != $month[$i-1])\r\n			$month_count++; \r\n	}\r\n\r\n	//////////////////////////////////////////////////\r\n	if ($show_all != 1)\r\n	{\r\n		if (isset($mth_change))\r\n		{\r\n			switch($mth_change)	{\r\n				case -1:\r\n					$curr_mth = $curr_mth - 1;\r\n					if ($curr_mth < 0)\r\n						$curr_mth = 0;\r\n					break;\r\n				case 1:\r\n					$curr_mth = $curr_mth + 1;\r\n					if ($curr_mth > $month_count - 1)\r\n						$curr_mth = $month_count - 1;\r\n					break;\r\n				case -10:\r\n					$curr_mth = 0;\r\n					break;\r\n				case 10:\r\n					$curr_mth = $month_count - 1;\r\n					break;\r\n			}\r\n		}\r\n		else\r\n		{\r\n			// If $curr_mth not set, then first time. Need to default to this month and set $curr_mth which is just index into months\r\n			// by count of total valid months.  If this month is not one of the valid months, then got to first valid month.\r\n			$m = 0;\r\n			$this_month = date(\"n\");\r\n			$valid_mth_found = false;\r\n			for ($k = 0; $k < $month_count; $k++)\r\n			{				\r\n				$grid_month = $month[$m];\r\n				if($grid_month != $this_month)\r\n				{\r\n					while($month[$m] == $grid_month)\r\n						$m++;\r\n					continue;\r\n				}\r\n				else\r\n				{\r\n					$curr_mth = $k;\r\n					$valid_mth_found = true;\r\n					break;\r\n				}\r\n			}\r\n			if (!$valid_mth_found)\r\n				$curr_mth = 0;\r\n		}\r\n	}\r\n\r\n$m = 0;\r\nfor ($k = 0; $k < $month_count; $k++)\r\n{\r\n	$grid_month = $month[$m];\r\n	$current_year = $year[$m];\r\n	if(($show_all != 1) && ($k != $curr_mth))\r\n	{\r\n		while($month[$m] == $grid_month)\r\n			$m++;\r\n		continue;\r\n	}\r\n	$start_timestamp = mktime(0, 0, 0, $month[$m], 1, $year[$m]);\r\n	$on_the_1st_day_of_week = date(\"w\", $start_timestamp) + 1;	// 1 = Sunday, 7 = Saturday\r\n	$days_in_month = date(\"t\", $start_timestamp);\r\n	$month_name = date(\"F\", $start_timestamp);\r\n	$year_string = date(\"Y\", $start_timestamp);\r\n	\r\n	if ($show_hebrew == 1)\r\n	{\r\n		// Get Jewish date\r\n		$julian_date = gregoriantojd($grid_month, 1, $current_year);\r\n		$jewishdate = jdtojewish($julian_date);\r\n		// Find the Jewish calendar date and parse out the day and year values\r\n		list ($jc_month, $jc_day, $jc_year) = explode (\'/\', $jewishdate);\r\n		// Get Jewish month name\r\n		$jc_month_string = jdmonthname ($julian_date, 4);\r\n		// Get second Jewish date\r\n		$julian_date_2 = gregoriantojd($grid_month, $days_in_month, $current_year);\r\n		$jewishdate_2 = jdtojewish($julian_date_2);\r\n		// Find the Jewish calendar date and parse out the day and year values\r\n		list ($jc_month_2, $jc_day_2, $jc_year_2) = explode (\'/\', $jewishdate_2);\r\n		// Get Jewish month name\r\n		$jc_month_string_2 = jdmonthname ($julian_date_2, 4);\r\n		// In case this month spans the Jewish year, make year adjustment for heading.\r\n		if ($jc_year != $jc_year_2)\r\n			$jc_year = $jc_year . \" - \" . $jc_year_2;\r\n	}\r\n?>\r\n\r\n<DIV CLASS=\"pagebreak\">\r\n<div class=\"calendar_div\">\r\n<table class=\"calendar_table\">\r\n<tr class=\"calendar_tr_head\">\r\n	<td colspan=\"7\">\r\n    <table class=\"calendar_nav_table\">\r\n    	<tr>\r\n        <?php if ($show_all != 1) {	?>\r\n        	<td align=\"left\" class=\"calendar_td_head\">\r\n            <?php \r\n			if ($curr_mth > 0)	{\r\n				if (SEF_URL == 1)\r\n					echo \"<a href=\'/$script_name/mth_change/-10/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past\' title=\'First\'>\";\r\n				else\r\n					echo \"<a href=\'$script_name?mth_change=-10&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past\' title=\'First\'>\";\r\n			}\r\n			?>\r\n            <span class=\"calendar_nav_links\">&lt;&lt;</span>\r\n			<?php if ($curr_mth > 0) echo \"</a>\"; ?>\r\n            </td>\r\n            <td align=\"left\" class=\"calendar_td_head\">\r\n            <?php\r\n            if ($curr_mth > 0)	{\r\n				if (SEF_URL == 1)\r\n					echo \"<a href=\'/$script_name/mth_change/-1/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past\' title=\'Previous\'>\";\r\n                else\r\n	                echo \"<a href=\'$script_name?mth_change=-1&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past\' title=\'Previous\'>\";\r\n			}\r\n			?>\r\n            <span class=\"calendar_nav_links\">&lt;</span>\r\n            <?php if ($curr_mth > 0) echo \"</a>\"; ?>\r\n            </td>\r\n        <?php } ?>\r\n    		<td align=\"center\" class=\"calendar_td_head\">\r\n            <a <?php \r\n			if ($show_all == 1)	{\r\n				if (SEF_URL == 1)\r\n					echo \"href=\'$script_name/show_all/0/curr_mth/$k/show_hebrew/$show_hebrew/show_past/$show_past\' title=\'Show Current Month Only\'\"; \r\n				else\r\n					echo \"href=\'$script_name?show_all=0&curr_mth=$k&show_hebrew=$show_hebrew&show_past=$show_past\' title=\'Show Current Month Only\'\"; \r\n			}\r\n			else	{\r\n				if (SEF_URL == 1)\r\n					echo \"href=\'$script_name/show_all/1/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past\' title=\'Show All Months\'\";\r\n                else\r\n                	echo \"href=\'$script_name?show_all=1&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past\' title=\'Show All Months\'\";\r\n			}\r\n			?>><span class=\"calendar_nav_links calendar_month_year\">\r\n                    \r\n			<?php \r\n			if ($show_hebrew != 1)\r\n				echo \"$month_name, $year_string\";\r\n			else\r\n				echo \"$month_name, $year_string<br><span class=\'calendar_hebrew_header\'>$jc_month_string - $jc_month_string_2, $jc_year</span>\";\r\n			?>\r\n            </a>\r\n            </td>\r\n        <?php if ($show_all != 1) {	?>\r\n            <td align=\"right\" class=\"calendar_td_head\">\r\n            <?php\r\n            if ($curr_mth < $month_count - 1)	{\r\n				if (SEF_URL == 1)\r\n					echo \"<a href=\'/$script_name/mth_change/1/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past\' title=\'Next\'>\";\r\n                else\r\n                	echo \"<a href=\'$script_name?mth_change=1&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past\' title=\'Next\'>\";\r\n			}\r\n			?>\r\n            <span class=\"calendar_nav_links\">&gt;</span>\r\n            <?php if ($curr_mth < $month_count - 1) echo \"</a>\"; ?>\r\n            </td>\r\n            <td align=\"right\" class=\"calendar_td_head\">\r\n            <?php\r\n            if ($curr_mth < $month_count - 1)	{\r\n				if (SEF_URL == 1)\r\n					echo \"<a href=\'/$script_name/mth_change/10/curr_mth/$curr_mth/show_hebrew/$show_hebrew/show_past/$show_past\' title=\'Last\'>\";\r\n				else\r\n					echo \"<a href=\'$script_name?mth_change=10&curr_mth=$curr_mth&show_hebrew=$show_hebrew&show_past=$show_past\' title=\'Last\'>\";\r\n			}\r\n			?>\r\n            <span class=\"calendar_nav_links\">&gt;&gt;</span>\r\n            <?php if ($curr_mth < $month_count -1 ) echo \"</a>\"; ?>\r\n            </td>\r\n         <?php } ?>\r\n    	</tr>\r\n    </table>\r\n    </td>\r\n</tr>\r\n<tr class=\"calendar_tr_head2\">\r\n	<td class=\"calendar_td_head2\">S</td>\r\n	<td class=\"calendar_td_head2\">M</td>\r\n	<td class=\"calendar_td_head2\">T</td>\r\n	<td class=\"calendar_td_head2\">W</td>\r\n	<td class=\"calendar_td_head2\">T</td>\r\n	<td class=\"calendar_td_head2\">F</td>\r\n	<td class=\"calendar_td_head2\">S</td>\r\n</tr>\r\n<tr class=\"calendar_tr\">\r\n\r\n<?php\r\n	$got_1st_day = false;\r\n	$got_last_day = false;\r\n	$j = 1;\r\n	for ($i = 1; $i < 43; $i++)\r\n	{\r\n		if ($i == $on_the_1st_day_of_week)\r\n			$got_1st_day = true;\r\n\r\n		echo \" <td class=\'calendar_td\'>\";\r\n		if (($got_1st_day == true) && ($got_last_day == false))\r\n		{\r\n			if ($show_hebrew == 1)\r\n			{\r\n				// Get Jewish date\r\n				$julian_date = gregoriantojd($grid_month, $j, $current_year);\r\n				$jewishdate = jdtojewish($julian_date);\r\n				// Find the Jewish calendar date and parse out the day and year values\r\n				list ($jc_month, $jc_day, $jc_year) = explode (\'/\', $jewishdate);\r\n				// Find the Jewish calendar month name\r\n				$jc_month = jdmonthname ($julian_date, 4);\r\n				echo \"$j &nbsp;&nbsp;&nbsp; <span class=\'calendar_hebrew\'>$jc_day $jc_month</span>\";	// Print day.\r\n			}\r\n			else\r\n				echo $j;	// Print day.\r\n			/////////////////////////////////////////////////////////\r\n			// Print event if one exists for this day.\r\n			while (($day[$m] == $j) && ($month[$m] == $grid_month))\r\n			{\r\n				if ($EndTime[$m] == \"\")\r\n					$EndTimeStr = \"\";\r\n				else\r\n					$EndTimeStr = \"- $EndTime[$m]\";\r\n				if ($URL[$m])\r\n					echo \"<br><br><span class=\'calendar_event\'><a href=\'$URL[$m]\' target=\'$target[$m]\'>$Description[$m]<br>$StartTime[$m] $EndTimeStr</a></span>\";\r\n				else\r\n					echo \"<br><br><span class=\'calendar_event\'>$Description[$m]<br>$StartTime[$m] $EndTimeStr</span>\";\r\n				$m++;\r\n			}\r\n			/////////////////////////////////////////////////////////\r\n			$j++;\r\n			if ($j > $days_in_month)\r\n				$got_last_day = true;\r\n		}\r\n		else\r\n			echo \"&nbsp;\";\r\n\r\n		echo \"</td>\";\r\n\r\n		if (($i == 35) && ($got_last_day == true))	//All done, don\'t need another row.\r\n			$i = 50;\r\n		else if (!($i % 7))	//If Saturday, start new row.\r\n			echo \"</tr><tr>\";\r\n	}\r\n?>\r\n\r\n</tr>\r\n</table>\r\n<br>\r\n</div>\r\n</DIV>\r\n\r\n<?php\r\n}	//month count\r\n/////////////////////////////////////////////////////////////////////////////////////\r\n?>', '<span style=\"color: rgb(255, 0, 0);\">{*** delete *** \r\n<p>The calender is not edited here. To add events to the calendar, go back to the main menu and click the <b><em>Revise Schedule</em></b> button.  The change the look and colors of your calendar, Click the <b><em>Edit Styles</em></b> button and select <b><em>Calendar and Event Styles</em></b>.</p>\r\n</span>\r\n<p><span style=\"color: rgb(255, 0, 0);\">You can pass parameters in the URL to this page to control certain aspects of this calendar grid. For instance, sending <strong>show_past=1</strong> will cause the events grid to show dates that are in the past. By default, only events on this day or later will be displayed. As an extra bonus, you can also display Hebrew dates by sending <strong>show_hebrew=1</strong>.</span></p>\r\n<p style=\"color: rgb(255, 0, 0);\">By default, the calendar grid shows one calendar grid for one month with navigation links across the top to display other months across the top. Clicking on the month/year in the header toggles the view between displaying only one month and all of the months that contain events. Showing all of the months is particularly useful of the user would like to print the entire calendar with all months that contain events. You may make all-months view the default by adding <strong>show_all=1</strong> to the link to the calendar page. i.e. <strong>calendar.php?show_all=1</strong></p>\r\n\r\n<p><span style=\"color: rgb(255, 0, 0);\">You may also setup events to be private to a single user or to a group. To do that, add the following parameters to your URL:<strong> user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong>. You may also add <strong>use_logged_in_credentials</strong> to your URL and set its value to <strong>1</strong>. If you send <strong>use_logged_in_credentials</strong>, then the variabless <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> which of the credentials are used from the logged-in session to filter the events using and <strong>AND</strong> comparator. i.e. if <strong>user_table</strong> and <strong>UserID</strong> are set, then all events with the user <strong>UserID</strong> from the table <strong>user_table</strong> will be selected, but <u>not</u> the same <strong>UserID</strong> from <u>another</u> <strong>user_table</strong>. The formula for this is:</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\">(<strong>user_table</strong>) AND (<strong>UserID)</strong> AND (<strong>AccessLevel</strong>) where any one or two of these variables may be ommitted.</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\">An example of a  complete URL might be:</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\">calendar.php?show_past=1&amp;user_table=1&amp;AccessLevel=1&amp;UserID=1</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\">If <strong>use_logged_in_credentials</strong> is not set, then <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are handled in a different manner. Instead, the values passed in these variables are to be used explicitly, and not those of any logged in session. They are also combined somewhat differently. i.e., if all three variables <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then all events assigned to users of user ID <strong>UserID</strong>, and all users of access level <strong>AccessLevel</strong> from and only from the user table user_table will be shown. If only <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then events assigned to user <strong>UserID</strong>, or with access level <strong>AccessLevel</strong> will be selected reguardless of which user table they may be in. The  formula is:</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\"> (<strong>user_table</strong>) AND ((<strong>UserID</strong> OR (<strong>AccessLevel</strong>)) where any one or two of these variables may be ommitted.</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\"> An example of a complete URL might be:</span></p>\r\n<p><span style=\"color: rgb(255, 0, 0);\">calendar.php?show_hebrew=1&amp;user_table=accounts_form&amp;AccessLevel=user&amp;UserID=Joe</span></p>\r\n<span style=\"color: rgb(255, 0, 0);\"> *** delete *** }</span>', NULL, NULL, NULL, NULL, NULL, NULL, './plugins/edit_schedule.php', 'Revise Schedule', './plugins/images/icon_Edit-Events.png', './plugins/images/icon_Edit-Events_mo.png', './plugins/images/icon_Edit-Events_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#calendar_grid', 'manage/plugins/lang/calendar_events', 'CALENDAR_EVENTS_REVISE_SCHEDULE_BTN', 'content_functions', NULL, 'user', 1, 0, 0, NULL, 20);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(13, 'MP3 Audio Player, Mini', 'Premiumbeat music player', 'Audio', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<div align="center">\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/LWMusicPlayer.swf" height="21" id="player1" type="application/x-shockwave-flash" width="65">\r\n<param name="movie" value="../flash/LWMusicPlayer.swf" />\r\n<param name="FlashVars" value="mediaPath=../media/sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object> \r\n</div>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 70),
(15, 'Simple Slide Show', 'Simple Slide Show with no navigation controls', 'Slideshows', NULL, NULL, NULL, NULL, '', '<script type="text/javascript">\r\n// Opacity and Fade in script.\r\n// Script copyright (C) 2008 http://www.cryer.co.uk/.\r\n// Script is free to use provided this copyright header is included.\r\nfunction SetOpacity(object,opacityPct)\r\n{\r\n  // IE.\r\n  object.style.filter = "alpha(opacity=" + opacityPct + ")";\r\n  // Old mozilla and firefox\r\n  object.style.MozOpacity = opacityPct/100;\r\n  // Everything else.\r\n  object.style.opacity = opacityPct/100;\r\n}\r\n\r\nfunction ChangeOpacity(id,msDuration,msStart,fromO,toO)\r\n{\r\n  var element=document.getElementById(id);\r\n  var opacity = element.style.opacity * 100;\r\n  var msNow = (new Date()).getTime();\r\n  opacity = fromO + (toO - fromO) * (msNow - msStart) / msDuration;\r\n  if (opacity<0) \r\n    SetOpacity(element,0)\r\n  else if (opacity>100)\r\n    SetOpacity(element,100)\r\n  else\r\n  {\r\n    SetOpacity(element,opacity);\r\n    element.timer = window.setTimeout("ChangeOpacity(''" + id + "''," + msDuration + "," + msStart + "," + fromO + "," + toO + ")",1);\r\n  }\r\n}\r\n\r\nfunction FadeIn(id)\r\n{\r\n  var element=document.getElementById(id);\r\n  if (element.timer) window.clearTimeout(element.timer); \r\n  var startMS = (new Date()).getTime();\r\n  element.timer = window.setTimeout("ChangeOpacity(''" + id + "'',1000," + startMS + ",0,100)",1);\r\n}\r\n\r\nfunction FadeOut(id)\r\n{\r\n  var element=document.getElementById(id);\r\n  if (element.timer) window.clearTimeout(element.timer); \r\n  var startMS = (new Date()).getTime();\r\n  element.timer = window.setTimeout("ChangeOpacity(''" + id + "'',1000," + startMS + ",100,0)",1);\r\n}\r\n\r\nfunction FadeInImage(foregroundID,newImage,backgroundID)\r\n{\r\n  var foreground=document.getElementById(foregroundID);\r\n  if (backgroundID)\r\n  {\r\n    var background=document.getElementById(backgroundID);\r\n    if (background)\r\n    {\r\n      background.style.backgroundImage = ''url('' + foreground.src + '')'';\r\n      background.style.backgroundRepeat = ''no-repeat'';\r\n    }\r\n  }\r\n  SetOpacity(foreground,0);\r\n  foreground.src = newImage;\r\n  if (foreground.timer) window.clearTimeout(foreground.timer); \r\n  var startMS = (new Date()).getTime();\r\n  foreground.timer = window.setTimeout("ChangeOpacity(''" + foregroundID + "'',1000," + startMS + ",0,100)",10);\r\n}\r\n\r\n</script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<script type="text/javascript">\r\nvar last_image = 1;\r\nvar image_cnt = 2;\r\nvar img_width = "500px";\r\nvar img_height = "366px";\r\nvar delay = 7000;\r\n\r\nfunction ChangeImage()\r\n{\r\n   var base_image_name = "slide";\r\n   var image_str;\r\n\r\n   last_image++;\r\n\r\n   image_str = image_dir + base_image_name + last_image + ".jpg";\r\n   FadeInImage("image_banner", image_str, "image_banner_bkg");\r\n   \r\n   if (last_image == image_cnt)\r\n      last_image = 0;\r\n\r\n   mTimer = setTimeout(ChangeImage, delay);\r\n}\r\n\r\nmTimer = setTimeout(ChangeImage, delay);\r\n  \r\n</script>\r\n\r\n<div id="image_banner_bkg" style="background-image: url("../image/slide1.jpg");">\r\n <img id="image_banner" src="/images/slide1.jpg" style="border-width: 0px; border-style: solid; margin: 0px;" />	\r\n</div>\r\n\r\n<script type="text/javascript">\r\ndocument.getElementById("image_banner").style.width = img_width;\r\ndocument.getElementById("image_banner").style.height = img_height;\r\ndocument.getElementById("image_banner_bkg").style.width = img_width;\r\n</script>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n	var start_image_path_rel = image_dir_rel + "slide1.jpg";\r\n	var start_image_path = image_dir + "slide1.jpg";\r\n	document.getElementById("image_banner_bkg").setAttribute("url", start_image_path);\r\n	document.getElementById("image_banner").src = start_image_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#slide_show', NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 50);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(14, 'Flash Video Player', 'JW Player', 'Video', NULL, NULL, NULL, NULL, '<script src="<?php echo $scripts_dir_rel; ?>swfobject.js"></script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My Video</b></p>\r\n\r\n<div id="my_video_div" align="center" >This text will be replaced by the Flash player.</div>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\nvar player_path = flash_dir + "player.swf";\r\nvar so = new SWFObject(player_path,"mpl","360","288","9");\r\nso.addParam("allowscriptaccess","always");\r\nso.addParam("allowfullscreen","true");\r\n\r\nvar flv_path = media_dir + "sample.flv";\r\nvar image_path = image_dir + "sample.jpg";\r\nso.addParam("flashvars","author=Me&description=My Video&file=" + flv_path + "&title=My Video&autostart=false&stretching=exactfit&image=" + image_path);\r\n\r\nso.write("my_video_div");\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#flash_video', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 90);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(16, 'MP3 Audio Player, Thin', 'Premiumbeat music player', 'Audio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/OriginalThinMusicPlayer.swf" height="21" id="player1" type="application/x-shockwave-flash" width="220">\r\n<param name="movie" value="../flash/OriginalThinMusicPlayer.swf" />\r\n<param name="FlashVars" value="mediaPath=../media/sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object> ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 75),
(17, 'MP3 Audio Player, Deluxe', 'Premiumbeat music player, for multiple tracks with menu', 'Audio', NULL, NULL, NULL, NULL, '<?php\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$playlist_path = $doc_root . "/" . BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	else\r\n	{\r\n		$needle = "/" . BWB_BASE_DIR . "/";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$playlist_path = $path_start . "/" . BWB_BASE_DIR . "/" .BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = "../" . BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	\r\n	// Build xml playlist string.\r\n	$playlist = "<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n\\n";\r\n	$playlist .= "<playlist>\\n";\r\n	$indent = "   ";\r\n	$srch = array(".mp3", ".MP3", ".Mp3");\r\n	if ($handle = opendir("$playlist_path")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != ".") && ($file != ".."))\r\n			{\r\n				if (!(stripos($file, ".mp3") === false))\r\n				{\r\n					$title = str_replace($srch, "", $file);\r\n					$playlist .= $indent . "<item>\\n";\r\n					$playlist .= $indent . $indent . "<title>" . $title . "</title>\\n";\r\n					$playlist .= $indent . $indent . "<artist></artist>\\n";\r\n					$playlist .= $indent . $indent . "<path>" . $playlist_path_rel . $file . "</path>\\n";\r\n					$playlist .= $indent . "</item>\\n";\r\n				}\r\n			}\r\n		}\r\n		closedir($handle);\r\n	}\r\n	$playlist .= "</playlist>\\n";\r\n	\r\n	// Save xml playlist.\r\n	$file_name = $playlist_path . "/playlist.xml";\r\n	\r\n	// Delete old file.\r\n	if (file_exists($file_name))\r\n	{\r\n		if (!unlink($file_name))\r\n			echo "Could not delete old playlist.<br>";\r\n	}\r\n	\r\n	// Create new file.\r\n	$fh = fopen($file_name, ''x'') or die("Can''t create $file_name: $php_errormsg");\r\n	$result = (fputs($fh, $playlist));\r\n	fclose($fh) or die($php_errormsg);\r\n	@chmod($file_name, 0755);\r\n?>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<div align="center">\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/OriginalMusicPlayerPlaylist.swf" height="250" id="player1" type="application/x-shockwave-flash" width="260">\r\n<param name="movie" id="movie" value="../flash/OriginalMusicPlayerPlaylist.swf" />\r\n<param name="FlashVars" id="FlashVars" value="playlistXmlPath=../media/playlist/playlist.xml&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object>\r\n</div>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n// Note:  This probably only works in Opera.  You may need to manually change the data path to player1.\r\n	var player_path = flash_dir_rel + "OriginalMusicPlayerPlaylist.swf";\r\n	document.getElementById("player1").setAttribute("data", player_path);\r\n	document.getElementById("movie").value = player_path;\r\n	var playlist_path = "playlistXmlPath=" + media_dir_rel + "playlist/playlist.xml&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999";\r\n	document.getElementById("FlashVars").value = playlist_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 80);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(10, 'Lightbox Photo Gallery', 'Lightbox Photo Gallery', 'Photo Galleries', NULL, 'gallery', NULL, 'photo_gallery', 'Photo Gallery Styles', 'INSERT INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''photo_gallery_mobile'', ''#caption'', ''Caption'', 245, 500, 1),\r\n(''photo_gallery_mobile'', ''#numberDisplay'', ''Number Display'', 250, 500, 1),\r\n(''photo_gallery_mobile'', ''#bottomNavClose'', ''Close Btn'', 255, 500, 1),\r\n(''photo_gallery_mobile'', ''#imageDetails'', ''Image Details'', 260, 500, 1),\r\n(''photo_gallery_mobile'', ''#imageDataContainer'', ''Image Data Container'', 265, 500, 1),\r\n(''photo_gallery_mobile'', ''#bottomNavClose img'', ''Close Btn: Image'', 256, 500, 1),\r\n(''photo_gallery_mobile'', ''img'', ''Image'', 270, 500, 1),\r\n(''photo_gallery'', ''#imageDetails'', ''Image Details'', 260, 500, 1),\r\n(''photo_gallery'', ''#imageDataContainer'', ''Image Data Container'', 265, 500, 1),\r\n(''photo_gallery_mobile'', ''#lightboxImage'', ''Lightbox Image'', 275, 500, 1),\r\n(''photo_gallery_mobile'', ''#nextLink:hover, #nextLink:visited:hover'', ''Next Button'', 280, 500, 1),\r\n(''photo_gallery_mobile'', ''#prevLink:hover, #prevLink:visited:hover'', ''Prev Button'', 285, 500, 1),\r\n(''photo_gallery_mobile'', ''#gallery_container img'', ''Gallery Container: Image'', 291, 500, 1),\r\n(''photo_gallery_mobile'', ''#gallery_container'', ''Gallery Container'', 290, 500, 1);', 'INSERT INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`) VALUES\r\n(''photo_gallery_mobile'', ''#caption'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''32.00'', ''pt'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', 35, 5, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#numberDisplay'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''26.00'', ''pt'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', 28, 5, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#bottomNavClose'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''40.00'', ''pt'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', 42, 5, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#imageDetails'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''790.000'', 0, ''min'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#imageDataContainer'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''800.000'', 0, ''min'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery'', ''#imageDataContainer'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''250.000'', 0, ''min'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery'', ''#imageDetails'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''240.000'', 0, ''min'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#bottomNavClose img'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''180.000'', 0, ''min'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''relative'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''180.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#lightboxImage'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''500.000'', 0, ''min'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#nextLink:hover, #nextLink:visited:hover'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''scale'', ''120.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#gallery_container img'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''200.000'', 0, ''-not selected-'', ''-1.000'', 0, ''200.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-''),\r\n(''photo_gallery_mobile'', ''#prevLink:hover, #prevLink:visited:hover'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-1.00'', ''px'', ''-not set-'', ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-1.00'', 0, ''-not selected-'', 0, 0, 0, 0, 0, ''-1000000.00'', -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-1000000.00'', -1, ''-not set-'', -1, 0, ''-1.00'', 0, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-1000000.00'', 0, 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-1.000'', 0, ''-not selected-'', ''-1.000'', 0, ''-not selected-'', ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, ''-1000000.000'', 0, -1000000, ''-not selected-'', ''-not selected-'', ''-not selected-'', NULL, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-1.00'', -1, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''0.000'', ''0.000'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''0.00'', 0, ''-not selected-'', ''scale'', ''120.000'', 0, ''-1.000'', 0, ''-not selected-'');', 'INSERT INTO `bwb_custom_site_css` (`name`, `custom_css`, `revised`) VALUES\r\n(''photo_gallery_mobile'', ''#prevLink:hover, #prevLink:visited:hover {\\n  background: url(../images/lightbox/prevlabel.gif) left 15% no-repeat;\\n  background-size: 150px !important;\\n}\\n\\n#nextLink:hover, #nextLink:visited:hover {\\n  background: url(../images/lightbox/nextlabel.gif) right 15% no-repeat;\\n  background-size: 150px !important;\\n}'', ''2017-01-31 21:13:01'');', '<script src="<?php echo $scripts_dir_rel; ?>prototype.js"></script>\r\n<script src="<?php echo $scripts_dir_rel; ?>scriptaculous.js?load=effects,builder"></script>\r\n<script src="<?php echo $scripts_dir_rel; ?>lightbox.js"></script>\r\n\r\n<link rel="stylesheet" href="<?php echo $css_dir_rel; ?>lightbox.css" type="text/css" media="screen" />', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id="gallery_container">\r\n<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$full_gallery_path_fs = $doc_root . "/" .BWB_IMAGE_DIR . "/gallery/fs";\r\n		\r\n		$gallery_path_fs = BWB_IMAGE_DIR . "/gallery/fs";\r\n		$gallery_path_tn = BWB_IMAGE_DIR . "/gallery/tn";\r\n	}\r\n	else\r\n	{\r\n		$needle = "/" . BWB_BASE_DIR . "/";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$full_gallery_path_fs = $path_start . "/" . BWB_BASE_DIR . "/" .BWB_IMAGE_DIR . "/gallery/fs";\r\n		\r\n		$gallery_path_fs = "../" . BWB_IMAGE_DIR . "/gallery/fs";\r\n		$gallery_path_tn = "../" . BWB_IMAGE_DIR . "/gallery/tn";\r\n	}\r\n	\r\n	$files = array();\r\n	$srch = array(".jpg", ".JPG", ".Jpg", ".gif", ".GIF", ".Gif", ".png", ".PNG", ".Png");\r\n	if ($handle = opendir("$full_gallery_path_fs")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != ".") && ($file != "..") && (!is_dir("$full_gallery_path_fs/" . $file)))\r\n				$files[] = $file;\r\n		}\r\n		closedir($handle);\r\n	}\r\n	\r\n	$query = "SELECT * FROM gallery_params";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$show_titles = $row[''show_titles''];\r\n	$disable_sort = $row[''disable_sort''];\r\n	\r\n	if ($disable_sort != 1)\r\n		sort($files);\r\n	$images = array();\r\n	$next_sort = 1000000;\r\n	foreach ($files as $file)\r\n	{\r\n		$query = "SELECT * FROM gallery_titles WHERE image = ''" . $file . "''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($result->rowCount() > 0)	{\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$title = $row[''title''];\r\n			if ($row[''sort_order''] > -1)\r\n				$sort_order = $row[''sort_order''];\r\n			else	{\r\n				$sort_order = $next_sort;\r\n				$next_sort++;\r\n			}\r\n		}\r\n		else	{\r\n			$title = "";\r\n			$sort_order = $next_sort;\r\n			$next_sort++;\r\n		}\r\n		\r\n		$images[$sort_order] = array($file, $title);\r\n	}\r\n	\r\n	if ($disable_sort != 1)\r\n		ksort($images);\r\n	foreach ($images as $image)\r\n	{\r\n		$file = $image[0];\r\n		$title = $image[1];\r\n		$alt = str_replace($srch, "", $file);\r\n		if ($show_titles == 1)	{\r\n			if ($title == "")	{\r\n				$file_parts = explode(".", $file);\r\n				$file_str = str_replace("." . $file_parts[count($file_parts) - 1], "", $file);\r\n				$tile_str = " title=\\"" . str_replace("_", " ", $file_str) . "\\"";\r\n			}\r\n			else\r\n				$tile_str = " title=\\"" . $title . "\\"";\r\n		}\r\n		echo "<a href=''" . $gallery_path_fs . "/" . $file . "'' rel=''lightbox[group]''" . $tile_str . "><img src=''" . $gallery_path_tn . "/" . $file . "'' alt=''" . $alt . "'' border=''0'' /></a>\\n";\r\n	}\r\n?>\r\n</div>', '<h3>The code below is an example on how to build a slide show manually. If you have any more than a few images, it is recommended that you <em>Clear</em> this content and <em>Publish</em> this page.  Then use the <em>Manage Gallery</em> console under <em>SITE MANAGEMENT</em> to create your gallery.</h3>\r\n<p>Single Image</p>\r\n<a href="../images/sample1.jpg" rel="lightbox" title="my caption"><img src="../images/sample1_tn.jpg" alt="" border="0" /></a>\r\n<br>\r\n<br>\r\n<p>Multiple Images</p>\r\n<a href="../images/sample1.jpg" rel="lightbox[group]"><img src="../images/sample1_tn.jpg" alt="" border="0" /></a>\r\n<a href="../images/sample2.jpg" rel="lightbox[group]"><img src="../images/sample2_tn.jpg" alt="" border="0" /></a>\r\n<a href="../images/sample3.jpg" rel="lightbox[group]"><img src="../images/sample3_tn.jpg" alt="" border="0" /></a>\r\n<br>', NULL, NULL, NULL, NULL, NULL, NULL, './plugins/manage_gallery.php', 'Manage Gallery', './plugins/images/icon_gallery.png', './plugins/images/icon_gallery_mo.png', './plugins/images/icon_gallery_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#photo_gallery', 'manage/plugins/lang/gallery', 'MANAGE_GALLERY_MANAGE_GALLERY_BTN', 'content_functions', 'CREATE TABLE IF NOT EXISTS `gallery_params` (\r\n  `id` int(11) NOT NULL AUTO_INCREMENT,\r\n  `thumb_width` int(11) NOT NULL DEFAULT ''100'',\r\n  `thumb_height` int(11) NOT NULL DEFAULT ''100'',\r\n  `full_width` int(11) NOT NULL DEFAULT ''1024'',\r\n  `full_height` int(11) NOT NULL DEFAULT ''768'',\r\n  `preserve_thumb_aspect` tinyint(4) NOT NULL DEFAULT ''0'',\r\n  `show_titles` tinyint(4) NOT NULL DEFAULT ''0'',\r\n  `disable_sort` tinyint(4) NOT NULL DEFAULT ''0'',\r\n  PRIMARY KEY (`id`)\r\n) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;\r\n\r\nINSERT INTO `gallery_params` (`id`, `thumb_width`, `thumb_height`, `full_width`, `full_height`, `preserve_thumb_aspect`, `show_titles`, `disable_sort`) VALUES\r\n(1, 100, 100, 1024, 768, 0, 0, 0);\r\n\r\nCREATE TABLE IF NOT EXISTS `gallery_titles` (\r\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `image` varchar(255) NOT NULL,\r\n  `title` TEXT NOT NULL DEFAULT '''',\r\n  `sort_order` bigint(20) NOT NULL DEFAULT ''-1'',\r\n  PRIMARY KEY (`id`)\r\n) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;', NULL, 1, 0, 0, NULL, 40);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(21, 'Blog Template', 'Template used for blogging.  This plugin is used automatically when the blog button is clicked.', NULL, NULL, NULL, NULL, 'blog', 'Blog Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.blog'', ''.blog_subject'', ''Blog Subject'', 10, 0, 0),\r\n(''.blog'', ''.blog_timestamp'', ''Blog Timestamp'', 20, 0, 0),\r\n(''.blog'', ''.blog_message'', ''Blog Message'', 30, 0, 0),\r\n(''.blog'', ''.blog_author'', ''Blog Author'', 40, 0, 0),\r\n(''.blog'', ''.blog_hr'', ''Blog Horizontal Rule'', 50, 0, 0);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.blog'', ''.blog_subject'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.blog'', ''.blog_timestamp'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 10, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''inline-block'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''relative'', -1000000, 0, -40, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.blog'', ''.blog_message'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, 5, 0, 0, 5, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.blog'', ''.blog_author'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3 class="blog_subject">Subject</h3> <div class="blog_timestamp">mm/dd/yyyy hh:ii:ss PM</div>\r\n<p class="blog_message">Message</p>\r\n<div class="blog_author">Username</div>\r\n<br />\r\n<hr class="blog_hr" />', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, NULL, 200),
(22, 'HTML Contact Return Message', 'Page template for HTML contact return message.', 'Contact Forms', 'Contact/Mail Form with CAPTCHA', 'contact_return_message', '_return_message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Request for Information</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Thank you for inquiring about our services.  Someone will get back to you shortly.</p>\r\n<p>Best regards,<br/>\r\nThe Contact Response Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mail_form', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 32),
(23, 'HTML Account Create Return Message', 'Page template for HTML account create return message.', 'User Access Forms', 'Account Creation Form', 'create_account_return_message', '_return_message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Creation of New Account</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Thank you for signing up with our company.  Your request for an account will be reviewed by our staff shortly.</p>\r\n<p>Best regards,<br/>\r\nThe Account Management Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 35),
(24, 'HTML New Account Welcome Message', 'Page template for HTML new account welcome message.', 'User Access Forms', 'Account Creation Form', 'create_account_welcome_message', '_welcome_message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Account Approved</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Your account has been activated.  You can now login and access your account. Your user ID is [USER_ID] and your password is [PASSWORD].</p>\r\n<p>Best regards,<br/>\r\nThe Account Management Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 36);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(18, 'Login Form', 'Login form with hidden password reset form that appears upon request.', 'User Access Forms', 'Account Creation Form', 'login', '_login', 'mail_form', 'Mail Form Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', \'Reveal Password Icon: Hover\', 413, 500, 1);\r\n\r\nREPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form_mobile\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form_mobile\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form_mobile\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form_mobile\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form_mobile\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form_mobile\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form_mobile\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form_mobile\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form_mobile\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form_mobile\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form_mobile\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form_mobile\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form_mobile\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form_mobile\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form_mobile\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form_mobile\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form_mobile\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form_mobile\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', \'Reveal Password Icon: Hover\', 413, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'18.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'24.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'15.000\', 0, \'-not selected-\', \'-1.000\', 0, \'15.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_title_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'min\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'10.00\', 0, 0, \'inline-block\', \'75.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-not selected-\', \'-1.000\', 0, \'30.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#recaptcha_td *\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'325.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'34.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'relative\', \'500.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'6.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'6.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'500.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'34.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'40.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form_mobile\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'10.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'50.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.field_title_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'12.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-not selected-\', \'-1.000\', 0, \'30.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form_mobile\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-not selected-\', \'-1.000\', 0, \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'25.00\', 1, 0, \'10.00\', 0, 0, \'inline-block\', \'250.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'5.00\', 0, \'-1.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.mollom_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'700.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"file\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"radio\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"checkbox\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-not selected-\', \'-1.000\', 0, \'400.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#city\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'400.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-130.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'110.000\', 0, \'-not selected-\', \'-1.000\', 0, \'relative\', \'200.000\', 0, \'-130.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'16.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'50.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'100.00\', 0, 0, \'30.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'200.00\', 0, 0, \'60.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'70.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');', 'REPLACE INTO `bwb_custom_site_css` (`name`, `custom_css`, `revised`) VALUES (\'mail_form\', \'.recaptcha_r7_c1,.recaptcha_r8_c1	{\\r\\n  	display: none	!important;\\r\\n}\', NULL);', '<?php\r\nif (($login_required != 1) || ($show_login !== true))	{\r\n	include_once($captcha_includes_path);\r\n	echo \"\\n\\n<script src=\'\" . $scripts_dir_rel . \"hash.js\'> </script>\\n\\n\";\r\n}\r\n?>', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"ErrEmail\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    You must fill in the email address. Please try again.\r\n</div>\r\n<div id=\"ErrBadEmail\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    The email address you entered is not a valid email address. Please try again.\r\n</div>\r\n<div id=\"ErrCaptcha\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your CAPTCHA entry is incorrect. Please try again.\r\n</div>\r\n<div id=\"ErrBadPassword\" style=\" display:none;\" class=\"form_submit_error_txt\">\r\n    The password you entered is incorrect. Please try again.\r\n</div>\r\n<div id=\"ErrBadUser\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    The username you entered was not found in our system. Please check it and try again.\r\n</div>\r\n<div id=\"ErrAccessLevel\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    Your account does not have the required access level to access this page. Please contact the system administrator.\r\n</div>\r\n<div id=\"ErrNotActive\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    Your account has not been activated. Please contact the system administrator\r\n</div>\r\n<div id=\"PasswordReset\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    A new password has been sent to the email address you provided. Please use it to login.\r\n</div>\r\n            \r\n<form name=\"frmLoginForm\" id=\"frmLoginForm\" method=\"post\" action=\"/php/login_verify.php\">\r\n  <div class=\"mail_form_div\" id=\"login_form\">\r\n    <span class=\"mail_form_heading\">Enter your user ID and password to login.</span>\r\n    <br />\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">User ID: </span></div>\r\n    <input type=\"text\" name=\"userid\" id=\"userid\" class=\"long_txt_field\" />\r\n    <br />\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Password: </span></div>\r\n	<input type=\"password\" name=\"password_input\" id=\"password_input\" class=\"long_txt_field\" onKeyDown=\"checkForEnter(event);\" />\r\n    <input type=\"hidden\" name=\"password\" id=\"password\" />\r\n    <br />\r\n    <br />\r\n    <div id=\"login_div_button\" class=\"btn_div\" onClick=\"SubmitLogin();\"><span id=\"login_button_txt\" class=\"btn_txt\">Submit</span></div>\r\n	\r\n    			<input type=\"hidden\" name=\"redirect\" id=\"redirect\" />\r\n                <input type=\"hidden\" name=\"user_table\" id=\"user_table\" value=\"accounts\" />\r\n                <input type=\"hidden\" name=\"AccessLevel\" id=\"AccessLevel\" />\r\n                <input id=\"alt_go_back\" name=\"alt_go_back\" type=\"hidden\" />\r\n			    <input id=\"redirect_err_to_src\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n    <br />\r\n    <br />\r\n    <span class=\"mail_form_small_text\" onclick=\"ShowPasswordReset();\" id=\"forgot_password_msg\">Click <u style=\"cursor:pointer;\">here</u> if you forgot your password.</span>\r\n  </div>\r\n</form>\r\n\r\n    <br />\r\n    <br />\r\n    <br />\r\n<form name=\"frmResetPassword\" id=\"frmResetPassword\" method=\"post\" action=\"/php/reset_password.php\">\r\n  <div class=\"mail_form_div\" id=\"reset_password_form\" style=\"display:none;\" >\r\n    <span class=\"mail_form_heading\">Enter your email address to reset your password.  Your new temporary password will be sent to your email.</span>\r\n    <br />\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Email: </span></div>\r\n    <input type=\"text\" name=\"email\" id=\"email\" class=\"long_txt_field\" />\r\n    <br />\r\n  	<br />\r\n    <div id=\"recaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"recaptcha_td\">\r\n      <script type=\"text/javascript\" src=\"https://www.google.com/recaptcha/api/challenge?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT\" id=\"recaptcha_script\">\r\n      </script>\r\n      <noscript>\r\n        <iframe src=\"https://www.google.com/recaptcha/api/noscript?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT\"\r\n                height=\"300\" width=\"500\" frameborder=\"0\" id=\"captcha_iframe\">\r\n        </iframe>\r\n        <br>\r\n        <textarea name=\"recaptcha_challenge_field\" rows=\"3\" cols=\"40\">\r\n        </textarea>\r\n        <input type=\"hidden\" name=\"recaptcha_response_field\" id=\"recaptcha_response_field\" value=\"manual_challenge\">\r\n      </noscript>\r\n    </div>\r\n  </div>\r\n  <div id=\"recaptcha2_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"recaptcha2_td\">\r\n      <div class=\"g-recaptcha\" data-sitekey=\"\" id=\"recaptcha2_div\">\r\n      </div>\r\n      <script type=\"text/javascript\" src=\"https://www.google.com/recaptcha/api.js?hl=en\">\r\n      </script>\r\n    </div>\r\n  </div>\r\n  <div id=\"wscaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <table>\r\n      <tr>\r\n        <td width=\"200\">\r\n          <img alt=\"wspcaptcha\" border=\"0\" id=\"wspcaptcha\" src=\"wspcaptcha.php\" /> \r\n        </td>\r\n        <td valign=\"bottom\" align=\"left\" width=\"100%\">\r\n          <a href=\"javascript:void(0);\" onclick=\"document.getElementById(\'wspcaptcha\').src=\'wspcaptcha.php?t=\'+(new Date()).getTime(); return false;\">\r\n            <img alt=\"Reload\" border=\"0\" src=\"/images/reload.gif\" /></a>\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td style=\"vertical-align: bottom;\" colspan=\"2\">\r\n          <input name=\"wsp_code\" id=\"wsp_code\" style=\"width:120px;\" type=\"text\" value=\"\" class=\"text_box\" />\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan=\"2\">\r\n          Type in the letters you see <span class=\"mail_form_large_text\"><span class=\"required_fields\"><b>*</b></span></span>\r\n        </td>\r\n      </tr>\r\n    </table>\r\n  </div>\r\n  <div id=\"mollomcaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"mollom_captcha\">&nbsp;\r\n    </div>\r\n    <input type=\"hidden\" name=\"mollom_session\" id=\"mollom_session\" />\r\n    <input type=\"text\" name=\"captcha_response_field\" id=\"captcha_response_field\" value=\"\" autocomplete=\"off\" />\r\n    <br />\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <span class=\"mail_form_small_text mollom_instructions\">Type the characters you see in this picture</span>\r\n  </div>\r\n  <br />\r\n  <br />\r\n\r\n  <div id=\"reset_pass_div_btn\" class=\"btn_div\" onClick=\"document.getElementById(\'frmResetPassword\').submit();\"><span id=\"reset_pass_btn_txt\" class=\"btn_txt\">Submit</span></div>\r\n  \r\n				<input type=\"hidden\" name=\"redirect\" id=\"redirect2\" />\r\n                <input type=\"hidden\" name=\"user_table\" id=\"user_table2\" value=\"accounts\" />\r\n                <input type=\"hidden\" name=\"subject\" id=\"subject\" value=\"Password Reset Request\" />\r\n                <input type=\"hidden\" name=\"reply_to\" id=\"reply_to\" />\r\n                <input type=\"hidden\" name=\"from\" id=\"from\" />\r\n                <input type=\"hidden\" name=\"html\" id=\"html\" value=\"1\" />\r\n                <input type=\"hidden\" name=\"use_captcha\" id=\"use_captcha\" value=\"1\" />\r\n			    <input type=\"hidden\" name=\"captcha_type\" id=\"captcha_type\" value=\"recaptcha\" />\r\n                <input id=\"alt_go_back2\" name=\"alt_go_back\" type=\"hidden\" />\r\n			    <input id=\"redirect_err_to_src2\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n                <input id=\"email_link_page\" name=\"email_link_page\" type=\"hidden\" />\r\n                \r\n  </div>\r\n</form>\r\n\r\n<div align=\"center\" class=\"warning_text\" id=\"javascript_warning\">WARNING: JavaScript must be enabled to use this system. Please turn on JavaScipt in your browser.</div>', NULL, NULL, NULL, NULL, '<?php\r\n	if (($login_required != 1) || ($show_login !== true))	{\r\n		include_once($captcha_includes_path2);\r\n		echo \"\\n\\n<script src=\'\" . $scripts_dir_rel . \"acct_mgmt.js\'> </script>\\n\\n\";\r\n		echo \"<script src=\'\" . $scripts_dir_rel . \"acct_mgmt_custom.js\'> </script>\\n\\n\";\r\n	}\r\n?>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#login_form', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 37);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(20, 'Change Password Form', 'Change Password Form.', 'User Access Forms', 'Account Creation Form', 'change_password', '_change_password', 'mail_form', 'Mail Form Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', \'Reveal Password Icon: Hover\', 413, 500, 1);\r\n\r\nREPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form_mobile\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form_mobile\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form_mobile\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form_mobile\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form_mobile\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form_mobile\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form_mobile\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form_mobile\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form_mobile\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form_mobile\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form_mobile\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form_mobile\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form_mobile\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form_mobile\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form_mobile\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form_mobile\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form_mobile\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form_mobile\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', \'Reveal Password Icon: Hover\', 413, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'18.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'24.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'15.000\', 0, \'-not selected-\', \'-1.000\', 0, \'15.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_title_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'min\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'10.00\', 0, 0, \'inline-block\', \'75.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-not selected-\', \'-1.000\', 0, \'30.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#recaptcha_td *\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'325.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'34.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'relative\', \'500.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'6.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'6.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'500.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'34.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'40.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form_mobile\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'10.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'50.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.field_title_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'12.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-not selected-\', \'-1.000\', 0, \'30.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form_mobile\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-not selected-\', \'-1.000\', 0, \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'25.00\', 1, 0, \'10.00\', 0, 0, \'inline-block\', \'250.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'5.00\', 0, \'-1.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form_mobile\', \'.mollom_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'700.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"file\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"radio\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"checkbox\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'50.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-not selected-\', \'-1.000\', 0, \'400.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#city\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'400.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-130.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'110.000\', 0, \'-not selected-\', \'-1.000\', 0, \'relative\', \'200.000\', 0, \'-130.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'16.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'50.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'100.00\', 0, 0, \'30.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'200.00\', 0, 0, \'60.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'20.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'70.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');', 'REPLACE INTO `bwb_custom_site_css` (`name`, `custom_css`, `revised`) VALUES (\'mail_form\', \'.recaptcha_r7_c1,.recaptcha_r8_c1	{\\r\\n  	display: none	!important;\\r\\n}\', NULL);', '<script src=\"<?php echo $scripts_dir_rel; ?>generate_password.js\"></script>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>change_password.js\"></script>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"ErrTooShort\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password must be at least <span id=\"password_length_msg\">8</span> characters long. Please try again.\r\n</div>\r\n<div id=\"ErrTooWeak\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password is too weak.  <span id=\"password_strength_msg\">Please fill in a password contaning both letters and numbers.</span>\r\n</div>\r\n<div id=\"ErrNoMatch\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password is blank or does not match the confirmation password. Please try again.\r\n</div>\r\n<div id=\"ErrSuccess\" style=\"display: none;\" class=\"form_submit_success_txt\">\r\n    Your password has been successfully changed.\r\n</div>\r\n<div id=\"ErrPassBlank\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password is blank. Please try again.\r\n</div>\r\n<div id=\"ErrPassNoMatch\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password doesn&#39;t match the confirm. Please try again.\r\n</div>\r\n\r\n<form name=\"frmChangePasswordForm\" id=\"frmChangePasswordForm\" method=\"post\" action=\"/php/change_password.php\">\r\n  <div class=\"mail_form_div\">\r\n  <span class=\"mail_form_heading\">Enter your new password and re-type it to confirm.  Then click &#39;Submit&#39; to save it:</span>\r\n      <br />\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Password, Confirm: </span></div>\r\n    <input type=\"password\" name=\"password\" id=\"password\" autocomplete=\"off\" class=\"medium_txt_field\" />\r\n    <input type=\"password\" name=\"password_confirm\" id=\"password_confirm\" autocomplete=\"off\" class=\"medium_txt_field\" />\r\n    <div onclick=\"convertType(document.getElementById(\'password\')); convertType(document.getElementById(\'password_confirm\'));\" class=\"reveal_pass_icon\">\r\n      &nbsp;\r\n    </div>\r\n    <div onclick=\"convertToTxt(document.getElementById(\'password\')); convertToTxt(document.getElementById(\'password_confirm\')); GeneratePassword();\" class=\"gen_pass_icon\">\r\n      &nbsp;\r\n    </div>\r\n	<br />\r\n    <br />\r\n    <div id=\"reset_pass_div_btn\" class=\"btn_div\" onClick=\"SubmitForm(\'frmChangePasswordForm\');\"><span id=\"reset_pass_btn_txt\" class=\"btn_txt\">Submit</span></div>\r\n    <input type=\"submit\" id=\"reset_pass_submit_btn\" value=\"Submit\" class=\"submit_btn\" />\r\n    \r\n    <input type=\"hidden\" name=\"redirect\" id=\"redirect\" value=\"/change_password_return.php\" />\r\n    <input type=\"hidden\" name=\"UserID\" id=\"UserID\" />\r\n    <input type=\"hidden\" name=\"user_table\" id=\"user_table\" value=\"accounts\" />\r\n    <input type=\"hidden\" name=\"subject\" id=\"subject\" value=\"Change Password\" />\r\n    <input type=\"hidden\" name=\"from\" id=\"from\" value=\"changepasswordform@example.com\" />\r\n    <input type=\"hidden\" name=\"html\" id=\"html\" value=\"1\" />\r\n    <input type=\"hidden\" name=\"password_length\" id=\"password_length\" value=\"8\" />\r\n    <input type=\"hidden\" name=\"password_strength\" id=\"password_strength\" value=\"medium\" />\r\n    <input id=\"alt_go_back\" name=\"alt_go_back\" type=\"hidden\" />\r\n    <input id=\"redirect_err_to_src\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n  </div>\r\n</form>', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#password_change_form', NULL, NULL, NULL, NULL, NULL, 1, 0, 1, 'InitializeForm();', 38);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(26, 'Contact/Mail Form with CAPTCHA', 'Contact/Mail Form with CAPTCHA, auto-table creation and custom response email and return page.', 'Contact Forms', 'Contact/Mail Form with CAPTCHA', 'contact', NULL, 'mail_form', 'Mail Form Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', \'Reveal Password Icon: Hover\', 413, 500, 1);\r\n\r\nREPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form_mobile\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form_mobile\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form_mobile\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form_mobile\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form_mobile\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form_mobile\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form_mobile\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form_mobile\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form_mobile\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form_mobile\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form_mobile\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form_mobile\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form_mobile\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form_mobile\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form_mobile\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form_mobile\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form_mobile\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form_mobile\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', \'Reveal Password Icon: Hover\', 413, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'18.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'24.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL),\r\n(\'mail_form\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'15.000\', 0, \'-not selected-\', \'-1.000\', 0, \'15.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_title_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'min\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'10.00\', 0, 0, \'inline-block\', \'75.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-not selected-\', \'-1.000\', 0, \'100.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\'),\r\n(\'mail_form\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\'),\r\n(\'mail_form\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-not selected-\', \'-1.000\', 0, \'30.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\');\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `max_width`, `max_width_units`, `height`, `height_units`, `height_prefix`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`) VALUES\r\n(\'mail_form\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1.000\', 0, \'60.000\', 0, \'-not selected-\', \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', 