<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/30/2013	ELL
// Modified: 3/18/2013	ELL
// Modified: 3/22/2014	ELL
// Added graceful handling of allow_url_fopen not set.
// Modified: 12/13/2016	ELL
// Added auto-login and auto-cleanup.

session_start();
$userid = "admin";
$_SESSION['userid'] = $userid;
$session = md5(session_id());
$_SESSION['enable_file_manager'] = "100";
	
ini_set("track_errors", 1);

$db_server = $_POST["db_server"];
$db_prefix = $_POST["db_prefix"];
if ((isset($db_prefix)) && ($db_prefix != ""))	{
	if (strpos($db_prefix, "_", 2) < 1)
		$db_prefix .= "_";
}
$db_name = $_POST["db_name"];
$db_user = $_POST["db_user"];
$db_password = $_POST["db_password"];
if ((isset($db_prefix)) && ($db_prefix != ""))	{
	if (strpos($db_name, $db_prefix) == 0)
		$db_name = str_replace($db_prefix, "", $db_name);
	if (strpos($db_user, $db_prefix) == 0)
		$db_user = str_replace($db_prefix, "", $db_user);
}

$table_prefix = $_POST["table_prefix"];
if ((isset($table_prefix)) && ($table_prefix != ""))	{
	if (strpos($table_prefix, "_", 2) < 1)
		$table_prefix .= "_";
}
$base_website_folder = $_POST["base_website_folder"];
$files = $_POST["files"];
$images = $_POST["images"];

$media = $_POST["media"];
$flash = $_POST["flash"];
$css = $_POST["css"];
$scripts = $_POST["scripts"];
$fonts = $_POST["fonts"];

$password = $_POST['admin_password'];
if (isset($_POST["require_ssl"]))
	$require_ssl = 1;
else
	$require_ssl = 0;
$session_save_path = $_POST["session_save_path"];
$user_salt = $_POST["user_salt"];
$public_salt = $_POST["public_salt"];

if (isset($_POST['email']) && ($_POST['email'] != ""))
	$email = $_POST['email'];
else
	$email = "";
if (isset($_POST['first_name']) && ($_POST['first_name'] != ""))
	$first_name = $_POST['first_name'];
else
	$first_name = "";
if (isset($_POST['last_name']) && ($_POST['last_name'] != ""))
	$last_name = $_POST['last_name'];
else
	$last_name = "";

$language = $_POST["language"];

$document_root = $_SERVER['DOCUMENT_ROOT'];
$stock_connect_file = $document_root . "/install/db_connect.php";
$stock_config_file = $document_root . "/install/config.php";
$connect_file = $document_root . "/connect/db_connect.php";
$config_file = $document_root . "/connect/config.php";

if ((ini_get("allow_url_fopen") == 1) || (ini_get("allow_url_fopen") === true) || (strtolower(ini_get("allow_url_fopen")) == "on"))
{
	$ip = (isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : "");
	$website = (isset($_SERVER['SERVER_NAME']) ? $_SERVER['SERVER_NAME'] : "");
	$url = 'http://breezewebsitebuilder.com/php/generate_license.php';
	$delim = "?";
	if (isset($website) && ($website != ""))	{
		$url .= $delim . "website=" . $website;
		$delim = "&";
	}
	if (isset($email) && ($email != ""))	{
		$url .= $delim . "email=" . $email;
		$delim = "&";
	}
	if (isset($first_name) && ($first_name != ""))	{
		$url .= $delim . "first_name=" . $first_name;
		$delim = "&";
	}
	if (isset($last_name) && ($last_name != ""))	{
		$url .= $delim . "last_name=" . $last_name;
		$delim = "&";
	}
	if (isset($ip) && ($ip != ""))	{
		$url .= $delim . "ip=" . $ip;
		$delim = "&";
	}
	if (isset($language) && ($language != ""))	{
		$url .= $delim . "language=" . $language;
		$delim = "&";
	}
	$sn = file_get_contents($url);
}
else
	$sn = time();

///////////////////////////////////////////////////////////
function doEncrypt($Data, $Key)
{
// encrypting  a[] with key k[] into e[]
// a[] = array to be encrypted
// k[] = key of truly random gibberish
// e[] = encrypted data

	for( $i = 0; $i < strlen($Data); $i++)
	{
		$c = substr($Data, $i, 1);
		$a[$i] = ord($c);
	}
	
	for( $i = 0; $i < strlen($Data); $i++)
	{
		if ($i < strlen($Key))
		{
			$c = substr($Key, $i, 1);
			$k[$i] = ord($c);
		}
		else
			$k[$i] = 65 + $i;
	}
	
	for ( $i=0; $i < strlen($Data); $i++ )
   	{
   		$e[$i] = $k[$i] ^ $a[$i];
   	}
	
	$encrypted = "";
	for ( $i = 0; $i < strlen($Data); $i++ )
	{
		$encrypted = $encrypted. decToHex($e[$i]);
	}
	return($encrypted);
	
}

function decToHex($dec)
{
	$hexStr = "0123456789ABCDEF";
	$low = $dec % 16;
	$high = ($dec - $low)/16;
	$hex = "";
	$hex = substr($hexStr, $high, 1) . substr($hexStr, $low, 1);
	return $hex;
}

function ChangePassword($user_name, $salted_password, $password, $email, $first_name, $last_name, $db_prefix, $dbh)
{
	$encrypt_password = doEncrypt($salted_password, $user_name);
	// Change password.
	$query = "UPDATE `" . $db_prefix . "users` SET `password`='$encrypt_password', `email`='$email', `first_name`='$first_name', `last_name`='$last_name' WHERE `UserID`='$user_name'";
	$cnt = $dbh->exec($query);
	echo "The password for <b>$user_name</b> has been set to <b>$password</b>.<br><br>\n";
}

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder Install</title>
<link type="text/css" href="/manage/theme/classic/manager.css" rel="stylesheet" />
<link type="image/x-icon" href="/manage/images/favicon.ico" rel="shortcut icon" />
<style type="text/css">
#login_btn	{
	border-style:solid;
	border-width:medium;
	border-color:#0000FF;
	background-color:#00FFFF;
	text-decoration:none;
	font-size:18px;
	font-weight:bold;
	display:inline;
	padding:5px;
	line-height:18px;
	position:relative;
	top:-8px;
}
#login_btn A:link	{
	text-decoration:none;
}
#login_btn:hover	{
	cursor:pointer;
	color:#FFFFFF;
	background-color:#FFFF00;
}
	
.content_div	{
	padding-left:10px;
	padding-right:10px;
}
</style>
</head>

<body>
	<div align="center" id="login_logo"><img alt="Breeze Website Builder" src="/manage/theme/classic/images/Breeze_header_logo.png" /></div>
    <div id="header_divider_login"> </div>
    <div class="content_div">
<?php

// Setup connect file.
echo "Installation starting.  Scroll to bottom of this screen after installations is complete.<br><br>\n";
echo "Configuring database connection...<br><br>\n";

if (!($fh = fopen($stock_connect_file, 'r'))) {
	echo "Error opening original connect file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}

$contents = (fread($fh, filesize($stock_connect_file)));
fclose($fh);

$contents = str_replace("localhost", $db_server, $contents);
$contents = str_replace("cpanelid_cms", $db_prefix . $db_name, $contents);
$contents = str_replace("cpanelid_website", $db_prefix . $db_user, $contents);
$contents = str_replace("xxxxx", $db_password, $contents);

if (!($fh2 = fopen($connect_file, 'w'))) {
	echo "Error opening connect file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}

if (!fwrite($fh2, $contents)) {
			echo "Error updating connect file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
			exit;
		}
if (!fclose($fh2)) {
	echo "Error closing connect file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}
@chmod($connect_file, 0644);


// Setup config file.
echo "\n<br />Saving configuration...<br><br>\n";

$contents = "";

if (!($fh3 = fopen($stock_config_file, 'r'))) {
	echo "Error opening original config file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}

$contents = (fread($fh3, filesize($stock_config_file)));
fclose($fh3);

$contents = str_replace("define('BWB_BASE_DIR', '');", "define('BWB_BASE_DIR', '" . $base_website_folder . "');", $contents);
$contents = str_replace("define('BWB_WEBPAGE_DIR', '');", "define('BWB_WEBPAGE_DIR', '" . $files . "');", $contents);
$contents = str_replace("define('BWB_IMAGE_DIR', 'images');", "define('BWB_IMAGE_DIR', '" . $images . "');", $contents);
$contents = str_replace("define('BWB_CSS_DIR', 'css');", "define('BWB_CSS_DIR', '" . $css . "');", $contents);
$contents = str_replace("define('BWB_FLASH_DIR', 'flash');", "define('BWB_FLASH_DIR', '" . $flash . "');", $contents);
$contents = str_replace("define('BWB_MEDIA_DIR', 'media');", "define('BWB_MEDIA_DIR', '" . $media . "');", $contents);
$contents = str_replace("define('BWB_SCRIPTS_DIR', 'scripts');", "define('BWB_SCRIPTS_DIR', '" . $scripts . "');", $contents);
$contents = str_replace("define('BWB_FONTS_DIR', 'fonts');", "define('BWB_FONTS_DIR', '" . $fonts . "');", $contents);
$contents = str_replace("define('BWB_TABLE_PREFIX', 'bwb_');", "define('BWB_TABLE_PREFIX', '" . $table_prefix . "');", $contents);
$contents = str_replace("define('BWB_REQUIRE_SSL', 0);", "define('BWB_REQUIRE_SSL', '" . $require_ssl . "');", $contents);
$contents = str_replace("define('BWB_SALT', '!oegTGFhFD87@');", "define('BWB_SALT', '" . $user_salt . "');", $contents);
$contents = str_replace("define('BWB_PUB_SALT', '#uePYd%3f78C');", "define('BWB_PUB_SALT', '" . $public_salt . "');", $contents);
$contents = str_replace("define('BWB_SN', '255.255.255.255-1');", "define('BWB_SN', '" . $sn . "');", $contents);
$contents = str_replace("define('SESSION_SAVE_PATH', '/tmp');", "define('SESSION_SAVE_PATH', '" . $session_save_path . "');", $contents);
$contents = str_replace("define('BWB_LANG', 'en');", "define('BWB_LANG', '" . $language . "');", $contents);

if (!($fh4 = fopen($config_file, 'w'))) {
	echo "Error opening config file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}

if (!fwrite($fh4, $contents)) {
			echo "Error updating config file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
			exit;
		}
if (!fclose($fh4)) {
	echo "Error closing config file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}
@chmod($config_file, 0644);

// Setup table structures.
echo "Reading SQL file...<br><br>\n";

$sql_file = $document_root . "/SQL/database.sql";
if (!($fh5 = fopen($sql_file, 'r'))) {
	echo "Error opening SQL file.  Please contact your system administrator.  Click <a href=\"install.php\" title=\"here\">here</a> to return to the installation start.\n$php_errormsg";
	exit;
}

$sql_string = (fread($fh5, filesize($sql_file)));
fclose($fh5);

for ($i = 0; $i < 1000; $i++)	// Delay to make shure config files are ready for SQL routine.
{
	echo ".";
	if ($i % 200 == 0)
		echo "<br />\n";
}

echo "\n<br />Creating table structures...<br><br>\n";

include ("run_sql_install.php");


/////////////////////////////////////////////////////////////////
// Insert salt into password.
	$pos = rand(0, (strlen($password)-1) );
	$pass1 = substr($password, 0, $pos);
	$pass2 = substr($password, $pos);
	$salted_pass = $pass1 . $user_salt . $pass2;
	
	//Encrypt password using user name as key.
	ChangePassword("admin", $salted_pass, $password, $email, $first_name, $last_name, BWB_TABLE_PREFIX, $bwb_dbh);
	ChangePassword("power_user", $salted_pass, $password, $email, $first_name, $last_name, BWB_TABLE_PREFIX, $bwb_dbh);
	ChangePassword("user", $salted_pass, $password, $email, $first_name, $last_name, BWB_TABLE_PREFIX, $bwb_dbh);
	ChangePassword("restricted", $salted_pass, $password, $email, $first_name, $last_name, BWB_TABLE_PREFIX, $bwb_dbh);
	ChangePassword("blogger", $salted_pass, $password, $email, $first_name, $last_name, BWB_TABLE_PREFIX, $bwb_dbh);
	
	$ip = $_SERVER['REMOTE_ADDR'];
	$query = "UPDATE `" . BWB_TABLE_PREFIX . "users` SET `Session`='$session', `IP`='$ip' WHERE `UserID` = :userid";
	$stmt = $bwb_dbh->prepare($query);
	$stmt->execute(array(':userid' => $userid));	
?>
<p><b>Installation complete.</b>  Click here <a href="finish_install.php"><span id="login_btn">Log into Breeze Website Builder</span></a> to login and start using the Breeze Website Builder&#8482;. You will be logged is as <em>admin</em> automatically the first time.  Bookmark that page and use <em>admin</em> for the username and the password you entered to log in at a later time. You may create other user accounts after logging in.</p>
<p>Thanks for using the Breeze Website Builder&#8482;!</p>
</div>
<script>
	var bottom = document.body.scrollHeight;
	var from_height = 0;
	var step = parseInt(bottom/100);
	var to_height = 0;
	var code = "AnimateScroll();";
	
	function AnimateScroll()
	{
		if (to_height < bottom)
		{
			to_height = to_height + step;
			window.scrollTo(from_height, to_height);
			setTimeout(code, 10);
			from_height = to_height;
		}
	}
	AnimateScroll();
</script>
</body>
</html>