<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	12/15/2015	ELL
// Revised: 2/5/2018	ELL
// Filtered out fonts style sheet as this is created soley under custom fonts management and thus should not be edited in the CSS editor, 
// has no attributes that should be altered, and has no reason to be modified for mobile.
// Revised: 3/1/2018	ELL
// Added ability to copy from any of Desktop, Mobile or Touchscreen to any of Desktop, Mobile or Touchscreen.
// 

	include ("check_session.php");
	
	$last_style_sheet_edited = $_SESSION['last_style_sheet_edited'];
	
	if (isset($_SESSION['style_sheet_sort_method']) && ($_SESSION['style_sheet_sort_method'] == 1))
		$style_sheet_sort_method = 1;
	else
		$style_sheet_sort_method = 0;
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Copy CSS to Mobile CSS | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style>
#sub_level_1_buttons {
    display: block;
    position: absolute;
    top: 25px;
    left: 150px;
}

#copy_to_mobile_heading	{
	height: 50px;
}

#sort_checkbox_div	{
	position:absolute;
	left:440px;
	top:60px;
}

#copy_to_mobile_note	{
	display:block;
	position:absolute;
	top:100px;
	left:490px;
	width:50%;
}
</style>

<script src="js/jquery.min.js"></script>
<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/copy_css_to_mobile_select.js"></script>

<script>
<?php
	echo "	var COPY_STYLE_TO_MOBILE_CONFIRM_1_MSG = \"" . COPY_STYLE_TO_MOBILE_CONFIRM_1_MSG . "\";\n";
	echo "	var COPY_STYLE_TO_MOBILE_CONFIRM_2_MSG = \"" . COPY_STYLE_TO_MOBILE_CONFIRM_2_MSG . "\";\n";
	echo "	var COPY_STYLE_TO_MOBILE_CONFIRM_3_MSG = \"" . COPY_STYLE_TO_MOBILE_CONFIRM_3_MSG . "\";\n";	
	echo "	var COPY_STYLE_TO_MOBILE_COMPLETE_MSG = \"" . COPY_STYLE_TO_MOBILE_COMPLETE_MSG . "\";\n";
	echo "	var COPY_STYLE_TO_MOBILE_COMPLETE_ERR = \"" . COPY_STYLE_TO_MOBILE_COMPLETE_ERR . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var TO_WORD = \"" . TO_WORD . "\";\n\n";
	echo "	var EDIT_CSS_SELECT_DESTINATION_TYPE_NOT_SELECTED = \"" . EDIT_CSS_SELECT_DESTINATION_TYPE_NOT_SELECTED . "\";\n\n";
	
	echo "	var last_style_sheet_edited = '$last_style_sheet_edited';\n";
?>
</script>
</head>

<body>
<div class='button_console_go_back' style="width:250px; position:absolute; right:40px; top:0px;" onClick="window.location.href='edit_css_select.php'"><span class='button_console_text_w_icon'><?php echo COPY_STYLE_TO_MOBILE_BACK_TO_EDIT_CSS_SELECT_BTN; ?></span></div>

<br />
<?php echo COPY_STYLE_TO_MOBILE_SOURCE_TYPE; ?>:<br />
<select name="source_type" id="source_type" onChange="PopulateStyleSheetList(this.value); EnableDisableDestTypeOptions(this.value);">
	<option value=""><?php echo _NOT_SELECTED_; ?></option>
    <option value="desktop"><?php echo DESKTOP_WORD; ?></option>
    <option value="mobile"><?php echo MOBILE_WORD; ?></option>
    <option value="touchscreen"><?php echo TOUCHSCREEN_WORD; ?></option>
</select>
<br /><br />
<?php echo MANAGE_MENUS_DESTINATION_TYPE; ?>:<br />
<select name="destination_type" id="destination_type">
	<option value=""><?php echo _NOT_SELECTED_; ?></option>
	<option value="desktop"><?php echo DESKTOP_WORD; ?></option>
    <option value="mobile"><?php echo MOBILE_WORD; ?></option>
    <option value="touchscreen"><?php echo TOUCHSCREEN_WORD; ?></option>
</select>

<div id="sub_level_1_buttons">
        
        <div class="button_heading_sub_level_1" id="copy_to_mobile_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_SELECT_COPY_STYLES_TO_MOBILE_BTN; ?></div><div class="button_heading_help" onClick="OpenHelpWindow();" style="left:210px;">&nbsp;</div></div>
        <div id="style_sheet_list">
        </div>
</div>

<div id="sort_checkbox_div">
<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_style_sheet" name="sort_alpha_style_sheet" <?php if ($style_sheet_sort_method == 1) echo "checked='checked'"; ?> disabled='disabled' onClick="ChangeStyleSheetSort(this.checked);" />
</div>

<div id="copy_to_mobile_note"><?php echo COPY_STYLE_TO_MOBILE_NOTE; ?></div>

<?php include("lib/popup_msg.html"); ?>

<script>
	popup_msg.HidePopupMsg();
</script>

</body>
</html>