<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 9/9/2008
// Revised: 2/10/2012	ELL
// Added table prefix handling.
// Revised:	2/2/2012	ELL
// Fixed bug of "Save As" not creating new file.
// Revised: 1/12/2016	ELL
// Modified error handling for attempting to rename page to existing page to have nice AJAX-like experience.
	
	include ("check_session.php");
	
	$err_msg = $_REQUEST['err_msg'];
	$return_page_name = $_REQUEST['page_name'];
	$new_name = $_REQUEST['new_name'];
	$copy_mode = $_REQUEST['copy_mode'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Copy/Rename Page Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

#copy_rename_btn	{	width:130px;	}

#copy_radio_btn	{	
	width:130px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 5px 1px;
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Copy_Pg.png);
}
#copy_radio_btn:hover	{	
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Copy_Pg_mo.png);
}
#rename_radio_btn	{
	width:130px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 5px 1px;
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Edit-Content.png);
}
#rename_radio_btn:hover	{
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Edit-Content_mo.png);
}
</style>

<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/copy_rename_page_select.js"></script>
</head>

<body>
<div class="button_heading_sub_level_1" id="copy_rename_pages_heading"><div class="button_heading_text_sub_level_1"><?php echo COPY_RENAME_PAGE_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>

 <div style="text-align:center; margin-top:20px;">
	<form name="frmRenamePage" id="frmRenamePage" method="post" action="copy_rename_page.php">
    	<div class="radio_button" id="copy_radio_btn" onClick="document.getElementById('copy_mode[0]').checked = true; EnableDisableCreateNewTemplateCheckbox(document.getElementById('copy_mode[0]').value);">
        <span class='radio_button_text'><?php echo COPY_WORD; ?></span>
        <input name="copy_mode" id="copy_mode[0]" type="radio" value="copy" checked="checked" />
        </div>
        <?php echo OR_WORD; ?> 
        <div class="radio_button" id="rename_radio_btn" onClick="document.getElementById('copy_mode[1]').checked = true; EnableDisableCreateNewTemplateCheckbox(document.getElementById('copy_mode[1]').value);">
        <span class='radio_button_text'><?php echo RENAME_WORD; ?></span>
        <input name="copy_mode" id="copy_mode[1]" type="radio" value="rename" />
        </div>
	   <?php echo PAGE_WORD; ?>
	  <select name="page_name" id="page_name" class="page_dropdown">
		<?php
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				$selected = "";
				if (isset($return_page_name) && ($page_name == $return_page_name))
					$selected = " selected";
				echo "<option value='$page_name'$selected>$page_name</option>";
			}
		?>
	  </select>
		<?php echo TO_WORD; ?>	
		<input type="text" name="new_name" id="new_name" onKeyUp="CheckPageName(this.value);" onSelect="CheckPageName(this.value);"<?php if (isset($new_name) && ($new_name != "")) echo "value='$new_name'"; ?> />
	      <br>
          <label id="create_new_template_label">
	      <input type="checkbox" name="create_new_template_check" id="create_new_template_check" onChange="TransferPageNameOnCheck(this);" />
          <input type="hidden" name="create_new_template" id="create_new_template" value="0" />
	      <?php echo COPY_RENAME_PAGE_DISCARD_TEMPLATE_NOTE; ?>
          </label>
		<center style="margin-top:20px;">
          <div class="button_console_edit_disabled" id="copy_rename_btn" onClick="CopyRenamePage();">
          	<span class='button_console_text_w_icon'><?php echo COPY_RENAME_PAGE_COPY_RENAME_BTN; ?></span>
          </div>
		</center>
        <input type="hidden" name="overwrite" value="0" />
        <input type="hidden" name="overwrite_content_only" value="0" />
	  </form>
      <br /><br /><br /><br /><br /><br /><br />
	<span class="small_message"><?php echo COPY_RENAME_PAGE_RENAME_PAGE_LINK_NOTE; ?></span>
</div>

<?php include("lib/popup_msg.html"); ?>

<script>
	popup_msg.HidePopupMsg();
<?php if (isset($err_msg) && ($err_msg != ""))	{	?>
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.status_msg = "<?php echo $err_msg; ?>";
	popup_msg.ShowPopupMsg();
	
	document.getElementById("<?php echo $copy_mode; ?>_radio_btn").click();
	document.getElementById("new_name").className = "highlight";
<?php }	?>
</script>
</body>
</html>