<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/28/2013	ELL
// Revised: 11/21/2014	ELL
// Off-loaded JavaScript.
// 

	include ("check_session.php");

	$last_page_edited = $_SESSION['last_page_edited'];
	$last_blog_edited = $_SESSION['last_blog_edited'];
?>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Edit Blog Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<style>
.blog_page_links	{	width:300px;	}
.blog_page_links_heading	{	width:302px;	}
.blog_links	{	width:350px;	}
.blog_links_heading	{	width:352px;	}
.blog_page_link_help	{	left:250px;	}
.blog_link_help	{	left:300px;	}
.status_msg	{
	font-size:10px;
	display:inline;
	float:right;
	margin-right:5px;
}
</style>

<script src="js/edit_blog_select.js"></script>

</head>

<body>
<div id="sub_level_1_buttons">
<table border="0"><tr><td valign="top">
	
        <div class="button_heading_sub_level_1 blog_page_links_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_BLOG_SELECT_CREATE_HEADING; ?></div><div class="button_heading_help blog_page_link_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
		<?php
			if (($access_level == "restricted") || ($access_level == "blogger"))		{
				$query = "SELECT pages FROM " . BWB_TABLE_PREFIX . "users WHERE UserID = '" . $userid . "'";
				$result = $bwb_dbh->query($query);
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$pages_str = $row["pages"];
				$pages = explode(",", $pages_str);
			}
			else	{
				$pages = array();
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
				$result = $bwb_dbh->query($query);
				while ($row = $result->fetch(PDO::FETCH_ASSOC))
				{
					$pages[] = $row["page_name"];
				}
			}
			
			$query = "SELECT DISTINCT(page_name) FROM " . BWB_TABLE_PREFIX . "blogs ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$blog_pages = array();
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$blog_pages[] = $row["page_name"];
			}

			foreach ($pages as $page_name)
			{
				if ($page_name == $last_page_edited)
					$selected = " down_sub_add";
				elseif (in_array($page_name, $blog_pages) && ($access_level != "blogger"))
					$selected = " blog_page";
				else
					$selected = "";
				if ($page_name == "index")
					$home = " (Home)";
				else
					$home = "";
					
				if (in_array($page_name, $blog_pages) && ($access_level != "blogger"))
					$status = BLOG_PAGE;
				else
					$status = "";
				
				echo "<div class='button_sub_level_1_add$selected blog_page_links' onClick=\"window.location='create_blog.php?page_name=$page_name&mode=blog';\"><span class='button_text_sub_level_1_add'>$page_name$home</span><span class='status_msg'>$status</span></div>\n";
			}
			
		?>
		
     </td><td valign="top">
    
         <div class="button_heading_sub_level_1 blog_links_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_BLOG_SELECT_EDIT_HEADING; ?></div><div class="button_heading_help blog_link_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
		<?php
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs WHERE `owner`='" . $userid . "' ORDER BY revised";
			$result = $bwb_dbh->query($query);
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$blog_id = $row["id"];
				$blog_page = $row["page_name"];
				$blog_revised = $row["revised"];
				
				$srch = "<!-- Post locate string for blog ID " . $blog_id . ". Do not remove this line. -->";
				$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='" . $blog_page . "'";
				$result2 = $bwb_dbh->query($query);
				$row2 = $result2->fetch(PDO::FETCH_ASSOC);
				$page_content = $row2['page_content'];

				if ($blog_id == $last_blog_edited)
					$selected = " down_sub_edit";
				elseif (strpos($page_content, $srch) === false)
					$selected = " blog_draft";
				else
					$selected = "";
					
				if (strpos($page_content, $srch) === false)
					$status = DRAFT_WORD;
				else
					$status = PUBLISHED_WORD;
				
				echo "<div class='button_sub_level_1_edit$selected blog_links' onClick=\"window.location='edit_page.php?blog_id=$blog_id&mode=blog';\"><span class='button_text_sub_level_1_edit'>$blog_page $blog_revised</span><span class='status_msg'>$status</span></div>\n";
			}
			
		?>
        
     </td></tr></table>
</div>
</body>
</html>