<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/18/2009	ELL
// Modified: 1/7/2010		ELL
// Changed the way hover text color is handled.  Was able to add separate user-electable sublevel 2 hover text color.
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 1/10/2011	ELL
// Added preview mode.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// Revised: 7/21/2013	ELL
// Added background opacity.
// Revised: 3/10/2015	ELL
// Converted deprecated font stretch to letter spacing.
// Revised: 4/5/2015	ELL
// Added font size units.
// Revised: 1/20/2016	ELL
// Converted save operation to AJAX.
// Revamped preview to show actual popup page.
// Modified: 12/2/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Modified: 2/15/2017	ELL
// Added ability to specify whether or not to pair up and leave out adjacent item borders.
// Modified: 3/23/2017	ELL
// Added ability to style button down states as well as complete implementation of background and item border colors in hover and active states.
// Revised: 8/29/2017	ELL
// Added background gradient capability.
// Revised: 9/12/2017	ELL
// Added ability to turn on or off text shadow for any of normal, hover and down states independently selectable in all 3 levels.
// Revised: 3/13/2018	ELL
// Added ability to specify sublevel 1 and sublevel 2 block borders independently.
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
	$result = $bwb_dbh->query($query);
	$fonts = array();
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$fonts[] = array('font' => $row['font'], 'websafe' => $row['websafe']);
	}
		
?>
<!DOCTYPE html>
<html>
<head>
<title>Editing <?php echo $menu; ?> CSS Menu Styles | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#css_menu_styles_heading	{	width:350px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:310px;
	height:31px;
	width:31px;
	z-index:100;
}

#page_select_div	{
	left: 250px;
}
</style>

<script src="js/check_color_str.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/edit_css_menu_styles.js"></script>

<script>
<?php
	echo "	var EDIT_CSS_MENU_STYLES_LETTER_SPACING_MSG = \"" . EDIT_CSS_MENU_STYLES_LETTER_SPACING_MSG . "\";\n";
	echo "	var EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG = \"" . EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG . "\";\n";
	echo "	var EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR = \"" . EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var _NOT_SET_ = \"" . _NOT_SET_ . "\";\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeForm();">

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td>
<div class="button_heading_sub_level_1" id="css_menu_styles_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_MENU_STYLES_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td class="bold" width="40%">
<?php echo EDIT_CSS_MENU_STYLES_SELECT_MENU; ?>:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	$menus_not_found = true;
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` ORDER BY description, menu_name";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)	{
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
			$menus_not_found = false;
		}
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
	
	if ($menus_not_found === true)
		$menu = _NOT_SELECTED_;
?>
</select>
</td>
</tr>
</table>

<?php
	if (($menu == _NOT_SELECTED_) || ($menu == ""))
	{
		echo EDIT_CSS_MENU_STYLES_SELECT_MENU_MSG;
		exit;
	}
	else
	{
		$suffix = substr($menu, 4);
		$search = array("_mobile", "_touchscreen");
		$suffix = str_replace($search, "", $suffix);
	}
	
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count < 1)
	{
		echo EDIT_CSS_MENU_STYLES_PARAMS_NOT_SET_ERR_1 . " <a href='edit_css_menu_params.php'>" . HERE_WORD . "</a> " . EDIT_CSS_MENU_STYLES_PARAMS_NOT_SET_ERR_2;
		exit;
	}
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] == -2)
		$load_defaults = 1;
	else
		$load_defaults = 0;
	
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$top_level_font = $row["font"];
	else
		$top_level_font = _NOT_SET_;		
	if (!is_null($row["font2"]) && ($row["font2"] != ""))
		$top_level_font_2 = $row["font2"];
	else
		$top_level_font_2 = _NOT_SET_;
	if (!is_null($row["font3"]) && ($row["font3"] != ""))
		$top_level_font_3 = $row["font3"];
	else
		$top_level_font_3 = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$top_level_font_size = $row["font_size"];
	else
		$top_level_font_size = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$top_level_font_size_units = $row["font_size_units"];
	else
		$top_level_font_size_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$top_level_weight = $row["weight"];
	elseif ($load_defaults == 1)
		$top_level_weight = "bold";
	else
		$top_level_weight = _NOT_SET_;
	if (!is_null($row["letter_spacing"]))
		$top_level_letter_spacing = $row["letter_spacing"];
	else
		$top_level_letter_spacing = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$top_level_letter_spacing_units = $row["letter_spacing_units"];
	else
		$top_level_letter_spacing_units = "-not selected-";	
	if (!is_null($row["italic"]))
		$top_level_italic = $row["italic"];
	else
		$top_level_italic = 0;
	if (!is_null($row["oblique"]))
		$top_level_oblique = $row["oblique"];
	else
		$top_level_oblique = 0;
	if (!is_null($row["small_caps"]))
		$top_level_small_caps = $row["small_caps"];
	else
		$top_level_small_caps = 0;
	if (!is_null($row["shadow"]))
		$top_level_shadow = $row["shadow"];
	else
		$top_level_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$top_level_shadow_color = $row["shadow_color"];
	else
		$top_level_shadow_color = _NOT_SET_;
	if ((!is_null($row["shadow_x_offset"])) && ($row["shadow_x_offset"] != 0))	{
		$top_level_shadow_x_offset = $row["shadow_x_offset"];
		if ((float)$top_level_shadow_x_offset == (int)$top_level_shadow_x_offset)
			$top_level_shadow_x_offset = intval($top_level_shadow_x_offset);
		else
			$top_level_shadow_x_offset = floatval($top_level_shadow_x_offset);
	}
	else
		$top_level_shadow_x_offset = _NOT_SET_;
	if ((!is_null($row["shadow_y_offset"])) && ($row["shadow_y_offset"] != 0))	{
		$top_level_shadow_y_offset = $row["shadow_y_offset"];
		if ((float)$top_level_shadow_y_offset == (int)$top_level_shadow_y_offset)
			$top_level_shadow_y_offset = intval($top_level_shadow_y_offset);
		else
			$top_level_shadow_y_offset = floatval($top_level_shadow_y_offset);
	}
	else
		$top_level_shadow_y_offset = _NOT_SET_;
	if ((!is_null($row["shadow_blur"])) && ($row["shadow_blur"] != 0))	{
		$top_level_shadow_blur = $row["shadow_blur"];
		if ((float)$shadow_blur == (int)$shadow_blur)
			$shadow_blur = intval($shadow_blur);
		else
			$shadow_blur = floatval($shadow_blur);
	}
	else
		$top_level_shadow_blur = _NOT_SET_;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color = $row["text_color"];
	elseif ($load_defaults == 1)
		$top_level_text_color = "#336699";
	else
		$top_level_text_color = _NOT_SET_;
		
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$top_level_background_color = "#FFFFFF";
	else
		$top_level_background_color = _NOT_SET_;
		
	if (!is_null($row["bkgd_opacity"]) && ($row["bkgd_opacity"] > 0))
		$top_level_background_opacity = $row["bkgd_opacity"];
	else
		$top_level_background_opacity = _NOT_SET_;
		
	if ($row["border"] > -1)
		$top_level_item_border_width = $row["border"];
	else
		$top_level_item_border_width = _NOT_SET_;
		
	if ($row["border_units"] > -1)
		$top_level_item_border_units = $row["border_units"];
	else
		$top_level_item_border_units = 0;
		
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color = $row["border_color"];
	else
		$top_level_item_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$top_level_item_border_top = 1;
		else
			$top_level_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$top_level_item_border_bottom = 1;
		else
			$top_level_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$top_level_item_border_left = 1;
		else
			$top_level_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$top_level_item_border_right = 1;
		else
			$top_level_item_border_right = 0;
	}
	else
	{
		$top_level_item_border_top = 1;
		$top_level_item_border_bottom = 1;
		$top_level_item_border_left = 1;
		$top_level_item_border_right = 1;
	}

	if (!is_null($row["border_style"]) && ($row["border_style"] != ""))
		$top_level_item_border_style = $row["border_style"];
	else
		$top_level_item_border_style = "-not selected-";
		

	if (!is_null($row["radius_top_left"]) && ($row["radius_top_left"] != 0))
		$top_level_radius_top_left = $row["radius_top_left"];
	else
		$top_level_radius_top_left = _NOT_SET_;
	if (!is_null($row["radius_top_left_units"]))
		$top_level_radius_top_left_units = $row["radius_top_left_units"];
	else
		$top_level_radius_top_left_units = 0;
		
	if (!is_null($row["radius_top_right"]) && ($row["radius_top_right"] != 0))
		$top_level_radius_top_right = $row["radius_top_right"];
	else
		$top_level_radius_top_right = _NOT_SET_;
	if (!is_null($row["radius_top_right_units"]))
		$top_level_radius_top_right_units = $row["radius_top_right_units"];
	else
		$top_level_radius_top_right_units = 0;
		
	if (!is_null($row["radius_bottom_right"]) && ($row["radius_bottom_right"] != 0))
		$top_level_radius_bottom_right = $row["radius_bottom_right"];
	else
		$top_level_radius_bottom_right = _NOT_SET_;
	if (!is_null($row["radius_bottom_right_units"]))
		$top_level_radius_bottom_right_units = $row["radius_bottom_right_units"];
	else
		$top_level_radius_bottom_right_units = 0;
		
	if (!is_null($row["radius_bottom_left"]) && ($row["radius_bottom_left"] != 0))
		$top_level_radius_bottom_left = $row["radius_bottom_left"];
	else
		$top_level_radius_bottom_left = _NOT_SET_;
	if (!is_null($row["radius_bottom_left_units"]))
		$top_level_radius_bottom_left_units = $row["radius_bottom_left_units"];
	else
		$top_level_radius_bottom_left_units = 0;
		
	if ($orientation == "horizontal")	{
		if (!is_null($row["margin_right"]) && ($row["margin_right"] != -1000000))
			$top_level_item_spacing = $row["margin_right"];
		else
			$top_level_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_right_units"]))
			$top_level_item_spacing_units = $row["margin_right_units"];
		else
			$top_level_item_spacing_units = 0;
	}
	else	{
		if (!is_null($row["margin_bottom"]) && ($row["margin_bottom"] != -1000000))
			$top_level_item_spacing = $row["margin_bottom"];
		else
			$top_level_item_spacing = _NOT_SET_;
		if (!is_null($row["margin_bottom_units"]))
			$top_level_item_spacing_units = $row["margin_bottom_units"];
		else
			$top_level_item_spacing_units = 0;
	}
	
	if (!is_null($row["box_shadow_horizontal"]) && ($row["box_shadow_horizontal"] != -1000000))	{
		$top_level_box_shadow_horizontal = $row["box_shadow_horizontal"];
		if ((float)$top_level_box_shadow_horizontal == (int)$top_level_box_shadow_horizontal)
			$top_level_box_shadow_horizontal = intval($top_level_box_shadow_horizontal);
		else
			$top_level_box_shadow_horizontal = floatval($top_level_box_shadow_horizontal);
	}
	else
		$top_level_box_shadow_horizontal = _NOT_SET_;
	if (!is_null($row["box_shadow_vertical"]) && ($row["box_shadow_vertical"] != -1000000))	{
		$top_level_box_shadow_vertical = $row["box_shadow_vertical"];
		if ((float)$top_level_box_shadow_vertical == (int)$top_level_box_shadow_vertical)
			$top_level_box_shadow_vertical = intval($top_level_box_shadow_vertical);
		else
			$top_level_box_shadow_vertical = floatval($top_level_box_shadow_vertical);
	}
	else
		$top_level_box_shadow_vertical = _NOT_SET_;
	if (!is_null($row["box_shadow_blur"]) && ($row["box_shadow_blur"] != -1))	{
		$top_level_box_shadow_blur = $row["box_shadow_blur"];
		if ((float)$top_level_box_shadow_blur == (int)$top_level_box_shadow_blur)
			$top_level_box_shadow_blur = intval($top_level_box_shadow_blur);
		else
			$top_level_box_shadow_blur = floatval($top_level_box_shadow_blur);
	}
	else
		$top_level_box_shadow_blur = _NOT_SET_;
	if (!is_null($row["box_shadow_spread"]) && ($row["box_shadow_spread"] != -1000000))	{
		$top_level_box_shadow_spread = $row["box_shadow_spread"];
		if ((float)$top_level_box_shadow_spread == (int)$top_level_box_shadow_spread)
			$top_level_box_shadow_spread = intval($top_level_box_shadow_spread);
		else
			$top_level_box_shadow_spread = floatval($top_level_box_shadow_spread);
	}
	else
		$top_level_box_shadow_spread = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$top_level_box_shadow_color = $row["box_shadow_color"];
	else
		$top_level_box_shadow_color = _NOT_SET_;
	if (!is_null($row["box_shadow_inset"]) && ($row["box_shadow_inset"] != ""))
		$top_level_box_shadow_inset = $row["box_shadow_inset"];
	else
		$top_level_box_shadow_inset = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$top_level_gradient_type = $row["gradient_type"];
	else
		$top_level_gradient_type = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$top_level_gradient_angle = $row["gradient_angle"];
	else
		$top_level_gradient_angle = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$top_level_gradient_colors = $row["gradient_colors"];
	else
		$top_level_gradient_colors = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$top_level_gradient_opacities = $row["gradient_opacities"];
	else
		$top_level_gradient_opacities = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$top_level_gradient_repeat = $row["gradient_repeat"];
	else
		$top_level_gradient_repeat = 0;
		
	if (!is_null($top_level_gradient_colors) && ($top_level_gradient_colors != "-not set-") && ($top_level_gradient_colors != ""))	{
		$gradient_color_arr = explode(",", $top_level_gradient_colors);
		if (!is_null($gradient_color_arr[0]))
			$top_level_gradient_color_1 = $gradient_color_arr[0];
		else
			$top_level_gradient_color_1 = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$top_level_gradient_color_2 = $gradient_color_arr[1];
		else
			$top_level_gradient_color_2 = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$top_level_gradient_color_3 = $gradient_color_arr[2];
		else
			$top_level_gradient_color_3 = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$top_level_gradient_color_4 = $gradient_color_arr[3];
		else
			$top_level_gradient_color_4 = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$top_level_gradient_color_1 = _NOT_SET_;
		$top_level_gradient_color_2 = _NOT_SET_;
		$top_level_gradient_color_3 = _NOT_SET_;
		$top_level_gradient_color_4 = _NOT_SET_;
	}
	
	if (!is_null($top_level_gradient_opacities) && ($top_level_gradient_opacities != "-not set-") && ($top_level_gradient_opacities != ""))	{
		$gradient_opacity_arr = explode(",", $top_level_gradient_opacities);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$top_level_gradient_opacity_1 = $gradient_opacity_arr[0];
		else
			$top_level_gradient_opacity_1 = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$top_level_gradient_opacity_2 = $gradient_opacity_arr[1];
		else
			$top_level_gradient_opacity_2 = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$top_level_gradient_opacity_3 = $gradient_opacity_arr[2];
		else
			$top_level_gradient_opacity_3 = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$top_level_gradient_opacity_4 = $gradient_opacity_arr[3];
		else
			$top_level_gradient_opacity_4 = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$top_level_gradient_opacity_1 = 100;
		$top_level_gradient_opacity_2 = 100;
		$top_level_gradient_opacity_3 = 100;
		$top_level_gradient_opacity_4 = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$top_level_underline = $row["underline"];
	else
		$top_level_underline = 0;
	if (!is_null($row["overline"]))
		$top_level_overline = $row["overline"];
	else
		$top_level_overline = 0;
	if (!is_null($row["blink"]))
		$top_level_blink = $row["blink"];
	else
		$top_level_blink = 0;
			
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$sub_level_1_font = $row["font"];
	elseif ($load_defaults == 1)
		$sub_level_1_font = "Arial";
	else
		$sub_level_1_font = _NOT_SET_;
	if (!is_null($row["font2"]) && ($row["font2"] != ""))
		$sub_level_1_font_2 = $row["font2"];
	else
		$sub_level_1_font_2 = _NOT_SET_;
	if (!is_null($row["font3"]) && ($row["font3"] != ""))
		$sub_level_1_font_3 = $row["font3"];
	else
		$sub_level_1_font_3 = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_1_font_size = $row["font_size"];
	else
		$sub_level_1_font_size = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_1_font_size_units = $row["font_size_units"];
	else
		$sub_level_1_font_size_units = "px";
	if (!is_null($row["weight"]))
		$sub_level_1_weight = $row["weight"];
	else
		$sub_level_1_weight = "bold";	
	if (!is_null($row["letter_spacing"]))
		$sub_level_1_letter_spacing = $row["letter_spacing"];
	else
		$sub_level_1_letter_spacing = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_1_letter_spacing_units = $row["letter_spacing_units"];
	else
		$sub_level_1_letter_spacing_units = "-not selected-";	
	if (!is_null($row["italic"]))
		$sub_level_1_italic = $row["italic"];
	else
		$sub_level_1_italic = 0;
	if (!is_null($row["oblique"]))
		$sub_level_1_oblique = $row["oblique"];
	else
		$sub_level_1_oblique = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_1_small_caps = $row["small_caps"];
	else
		$sub_level_1_small_caps = 0;
	if (!is_null($row["shadow"]))
		$sub_level_1_shadow = $row["shadow"];
	else
		$sub_level_1_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_1_shadow_color = $row["shadow_color"];
	else
		$sub_level_1_shadow_color = _NOT_SET_;
	if ((!is_null($row["shadow_x_offset"])) && ($row["shadow_x_offset"] != 0))	{
		$sub_level_1_shadow_x_offset = $row["shadow_x_offset"];
		if ((float)$sub_level_1_shadow_x_offset == (int)$sub_level_1_shadow_x_offset)
			$sub_level_1_shadow_x_offset = intval($sub_level_1_shadow_x_offset);
		else
			$sub_level_1_shadow_x_offset = floatval($sub_level_1_shadow_x_offset);
	}
	else
		$sub_level_1_shadow_x_offset = _NOT_SET_;
	if ((!is_null($row["shadow_y_offset"])) && ($row["shadow_y_offset"] != 0))	{
		$sub_level_1_shadow_y_offset = $row["shadow_y_offset"];
		if ((float)$sub_level_1_shadow_y_offset == (int)$sub_level_1_shadow_y_offset)
			$sub_level_1_shadow_y_offset = intval($sub_level_1_shadow_y_offset);
		else
			$sub_level_1_shadow_y_offset = floatval($sub_level_1_shadow_y_offset);
	}
	else
		$sub_level_1_shadow_y_offset = _NOT_SET_;
	if ((!is_null($row["shadow_blur"])) && ($row["shadow_blur"] != 0))	{
		$sub_level_1_shadow_blur = $row["shadow_blur"];
		if ((float)$sub_level_1_shadow_blur == (int)$sub_level_1_shadow_blur)
			$sub_level_1_shadow_blur = intval($sub_level_1_shadow_blur);
		else
			$sub_level_1_shadow_blur = floatval($sub_level_1_shadow_blur);
	}
	else
		$sub_level_1_shadow_blur = _NOT_SET_;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_text_color = "#336699";
	else
		$sub_level_1_text_color = _NOT_SET_;
		
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_1_background_color = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_background_color = "#FFFFFF";
	else
		$sub_level_1_background_color = _NOT_SET_;
		
	if (!is_null($row["bkgd_opacity"]) && ($row["bkgd_opacity"] > 0))
		$sub_level_1_background_opacity = $row["bkgd_opacity"];
	else
		$sub_level_1_background_opacity = _NOT_SET_;

	if ($row["border"] > -1)
		$sub_level_1_item_border_width = $row["border"];
	else
		$sub_level_1_item_border_width = _NOT_SET_;
		
	if ($row["border_units"] > -1)
		$sub_level_1_item_border_units = $row["border_units"];
	else
		$sub_level_1_item_border_units = 0;
		
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_1_item_border_color = $row["border_color"];
	else
		$sub_level_1_item_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_1_item_border_top = 1;
		else
			$sub_level_1_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_1_item_border_bottom = 1;
		else
			$sub_level_1_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_1_item_border_left = 1;
		else
			$sub_level_1_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_1_item_border_right = 1;
		else
			$sub_level_1_item_border_right = 0;
	}
	else
	{
		$sub_level_1_item_border_top = 1;
		$sub_level_1_item_border_bottom = 1;
		$sub_level_1_item_border_left = 1;
		$sub_level_1_item_border_right = 1;
	}
	
	if (!is_null($row["border_style"]) && ($row["border_style"] != ""))
		$sub_level_1_item_border_style = $row["border_style"];
	else
		$sub_level_1_item_border_style = "-not selected-";
		
	if (!is_null($row["radius_top_left"]) && ($row["radius_top_left"] != 0))
		$sub_level_1_radius_top_left = $row["radius_top_left"];
	else
		$sub_level_1_radius_top_left = _NOT_SET_;
	if (!is_null($row["radius_top_left_units"]))
		$sub_level_1_radius_top_left_units = $row["radius_top_left_units"];
	else
		$sub_level_1_radius_top_left_units = 0;
		
	if (!is_null($row["radius_top_right"]) && ($row["radius_top_right"] != 0))
		$sub_level_1_radius_top_right = $row["radius_top_right"];
	else
		$sub_level_1_radius_top_right = _NOT_SET_;
	if (!is_null($row["radius_top_right_units"]))
		$sub_level_1_radius_top_right_units = $row["radius_top_right_units"];
	else
		$sub_level_1_radius_top_right_units = 0;
		
	if (!is_null($row["radius_bottom_right"]) && ($row["radius_bottom_right"] != 0))
		$sub_level_1_radius_bottom_right = $row["radius_bottom_right"];
	else
		$sub_level_1_radius_bottom_right = _NOT_SET_;
	if (!is_null($row["radius_bottom_right_units"]))
		$sub_level_1_radius_bottom_right_units = $row["radius_bottom_right_units"];
	else
		$sub_level_1_radius_bottom_right_units = 0;
		
	if (!is_null($row["radius_bottom_left"]) && ($row["radius_bottom_left"] != 0))
		$sub_level_1_radius_bottom_left = $row["radius_bottom_left"];
	else
		$sub_level_1_radius_bottom_left = _NOT_SET_;
	if (!is_null($row["radius_bottom_left_units"]))
		$sub_level_1_radius_bottom_left_units = $row["radius_bottom_left_units"];
	else
		$sub_level_1_radius_bottom_left_units = 0;
		
	if (!is_null($row["box_shadow_horizontal"]) && ($row["box_shadow_horizontal"] != -1000000))	{
		$sub_level_1_box_shadow_horizontal = $row["box_shadow_horizontal"];
		if ((float)$sub_level_1_box_shadow_horizontal == (int)$sub_level_1_box_shadow_horizontal)
			$sub_level_1_box_shadow_horizontal = intval($sub_level_1_box_shadow_horizontal);
		else
			$sub_level_1_box_shadow_horizontal = floatval($sub_level_1_box_shadow_horizontal);
	}
	else
		$sub_level_1_box_shadow_horizontal = _NOT_SET_;
	if (!is_null($row["box_shadow_vertical"]) && ($row["box_shadow_vertical"] != -1000000))	{
		$sub_level_1_box_shadow_vertical = $row["box_shadow_vertical"];
		if ((float)$sub_level_1_box_shadow_vertical == (int)$sub_level_1_box_shadow_vertical)
			$sub_level_1_box_shadow_vertical = intval($sub_level_1_box_shadow_vertical);
		else
			$sub_level_1_box_shadow_vertical = floatval($sub_level_1_box_shadow_vertical);
	}
	else
		$sub_level_1_box_shadow_vertical = _NOT_SET_;
	if (!is_null($row["box_shadow_blur"]) && ($row["box_shadow_blur"] != -1))	{
		$sub_level_1_box_shadow_blur = $row["box_shadow_blur"];
		if ((float)$sub_level_1_box_shadow_blur == (int)$sub_level_1_box_shadow_blur)
			$sub_level_1_box_shadow_blur = intval($sub_level_1_box_shadow_blur);
		else
			$sub_level_1_box_shadow_blur = floatval($sub_level_1_box_shadow_blur);
	}
	else
		$sub_level_1_box_shadow_blur = _NOT_SET_;
	if (!is_null($row["box_shadow_spread"]) && ($row["box_shadow_spread"] != -1000000))	{
		$sub_level_1_box_shadow_spread = $row["box_shadow_spread"];
		if ((float)$sub_level_1_box_shadow_spread == (int)$sub_level_1_box_shadow_spread)
			$sub_level_1_box_shadow_spread = intval($sub_level_1_box_shadow_spread);
		else
			$sub_level_1_box_shadow_spread = floatval($sub_level_1_box_shadow_spread);
	}
	else
		$sub_level_1_box_shadow_spread = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_1_box_shadow_color = $row["box_shadow_color"];
	else
		$sub_level_1_box_shadow_color = _NOT_SET_;
	if (!is_null($row["box_shadow_inset"]) && ($row["box_shadow_inset"] != ""))
		$sub_level_1_box_shadow_inset = $row["box_shadow_inset"];
	else
		$sub_level_1_box_shadow_inset = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_1_gradient_type = $row["gradient_type"];
	else
		$sub_level_1_gradient_type = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_1_gradient_angle = $row["gradient_angle"];
	else
		$sub_level_1_gradient_angle = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_1_gradient_colors = $row["gradient_colors"];
	else
		$sub_level_1_gradient_colors = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_1_gradient_opacities = $row["gradient_opacities"];
	else
		$sub_level_1_gradient_opacities = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_1_gradient_repeat = $row["gradient_repeat"];
	else
		$sub_level_1_gradient_repeat = 0;
		
	if (!is_null($sub_level_1_gradient_colors) && ($sub_level_1_gradient_colors != "-not set-") && ($sub_level_1_gradient_colors != ""))	{
		$gradient_color_arr = explode(",", $sub_level_1_gradient_colors);
		if (!is_null($gradient_color_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_1_gradient_color_1 = $gradient_color_arr[0];
		else
			$sub_level_1_gradient_color_1 = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_1_gradient_color_2 = $gradient_color_arr[1];
		else
			$sub_level_1_gradient_color_2 = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_1_gradient_color_3 = $gradient_color_arr[2];
		else
			$sub_level_1_gradient_color_3 = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_1_gradient_color_4 = $gradient_color_arr[3];
		else
			$sub_level_1_gradient_color_4 = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_1_gradient_color_1 = _NOT_SET_;
		$sub_level_1_gradient_color_2 = _NOT_SET_;
		$sub_level_1_gradient_color_3 = _NOT_SET_;
		$sub_level_1_gradient_color_4 = _NOT_SET_;
	}
	
	if (!is_null($sub_level_1_gradient_opacities) && ($sub_level_1_gradient_opacities != "-not set-") && ($sub_level_1_gradient_opacities != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_1_gradient_opacities);
		if (!is_null($gradient_opacity_arr[0]))
			$sub_level_1_gradient_opacity_1 = $gradient_opacity_arr[0];
		else
			$sub_level_1_gradient_opacity_1 = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_1_gradient_opacity_2 = $gradient_opacity_arr[1];
		else
			$sub_level_1_gradient_opacity_2 = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_1_gradient_opacity_3 = $gradient_opacity_arr[2];
		else
			$sub_level_1_gradient_opacity_3 = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_1_gradient_opacity_4 = $gradient_opacity_arr[3];
		else
			$sub_level_1_gradient_opacity_4 = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_1_gradient_opacity_1 = 100;
		$sub_level_1_gradient_opacity_2 = 100;
		$sub_level_1_gradient_opacity_3 = 100;
		$sub_level_1_gradient_opacity_4 = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$sub_level_1_underline = $row["underline"];
	else
		$sub_level_1_underline = 0;
	if (!is_null($row["overline"]))
		$sub_level_1_overline = $row["overline"];
	else
		$sub_level_1_overline = 0;
	if (!is_null($row["blink"]))
		$sub_level_1_blink = $row["blink"];
	else
		$sub_level_1_blink = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$sub_level_2_font = $row["font"];
	elseif ($load_defaults == 1)
		$sub_level_2_font = "Arial";
	else
		$sub_level_2_font = _NOT_SET_;
	if (!is_null($row["font2"]) && ($row["font2"] != ""))
		$sub_level_2_font_2 = $row["font2"];
	else
		$sub_level_2_font_2 = _NOT_SET_;
	if (!is_null($row["font3"]) && ($row["font3"] != ""))
		$sub_level_2_font_3 = $row["font3"];
	else
		$sub_level_2_font_3 = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_2_font_size = $row["font_size"];
	else
		$sub_level_2_font_size = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_2_font_size_units = $row["font_size_units"];
	else
		$sub_level_2_font_size_units = "px";
	if (!is_null($row["weight"]))
		$sub_level_2_weight = $row["weight"];
	else
		$sub_level_2_weight = "bold";
	if (!is_null($row["letter_spacing"]))
		$sub_level_2_letter_spacing = $row["letter_spacing"];
	else
		$sub_level_2_letter_spacing = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_2_letter_spacing_units = $row["letter_spacing_units"];
	else
		$sub_level_2_letter_spacing_units = "-not selected-";	
	if (!is_null($row["italic"]))
		$sub_level_2_italic = $row["italic"];
	else
		$sub_level_2_italic = 0;
	if (!is_null($row["oblique"]))
		$sub_level_2_oblique = $row["oblique"];
	else
		$sub_level_2_oblique = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_2_small_caps = $row["small_caps"];
	else
		$sub_level_2_small_caps = 0;
	if (!is_null($row["shadow"]))
		$sub_level_2_shadow = $row["shadow"];
	else
		$sub_level_2_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_2_shadow_color = $row["shadow_color"];
	else
		$sub_level_2_shadow_color = _NOT_SET_;
	if ((!is_null($row["shadow_x_offset"])) && ($row["shadow_x_offset"] != 0))	{
		$sub_level_2_shadow_x_offset = $row["shadow_x_offset"];
		if ((float)$sub_level_2_shadow_x_offset == (int)$sub_level_2_shadow_x_offset)
			$sub_level_2_shadow_x_offset = intval($sub_level_2_shadow_x_offset);
		else
			$sub_level_2_shadow_x_offset = floatval($sub_level_2_shadow_x_offset);
	}
	else
		$sub_level_2_shadow_x_offset = _NOT_SET_;
	if ((!is_null($row["shadow_y_offset"])) && ($row["shadow_y_offset"] != 0))	{
		$sub_level_2_shadow_y_offset = $row["shadow_y_offset"];
		if ((float)$sub_level_2_shadow_y_offset == (int)$sub_level_2_shadow_y_offset)
			$sub_level_2_shadow_y_offset = intval($sub_level_2_shadow_y_offset);
		else
			$sub_level_2_shadow_y_offset = floatval($sub_level_2_shadow_y_offset);
	}
	else
		$sub_level_2_shadow_y_offset = _NOT_SET_;
	if ((!is_null($row["shadow_blur"])) && ($row["shadow_blur"] != 0))	{
		$sub_level_2_shadow_blur = $row["shadow_blur"];
		if ((float)$sub_level_2_shadow_blur == (int)$sub_level_2_shadow_blur)
			$sub_level_2_shadow_blur = intval($sub_level_2_shadow_blur);
		else
			$sub_level_2_shadow_blur = floatval($sub_level_2_shadow_blur);
	}
	else
		$sub_level_2_shadow_blur = _NOT_SET_;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_text_color = "#336699";
	else
		$sub_level_2_text_color = _NOT_SET_;
		
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_2_background_color = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_background_color = "#FFFFFF";
	else
		$sub_level_2_background_color = _NOT_SET_;
		
	if (!is_null($row["bkgd_opacity"]) && ($row["bkgd_opacity"] > 0))
		$sub_level_2_background_opacity = $row["bkgd_opacity"];
	else
		$sub_level_2_background_opacity = _NOT_SET_;

	if ($row["border"] > -1)
		$sub_level_2_item_border_width = $row["border"];
	else
		$sub_level_2_item_border_width = _NOT_SET_;
		
	if ($row["border_units"] > -1)
		$sub_level_2_item_border_units = $row["border_units"];
	else
		$sub_level_2_item_border_units = 0;
		
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_2_item_border_color = $row["border_color"];
	else
		$sub_level_2_item_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_2_item_border_top = 1;
		else
			$sub_level_2_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_2_item_border_bottom = 1;
		else
			$sub_level_2_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_2_item_border_left = 1;
		else
			$sub_level_2_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_2_item_border_right = 1;
		else
			$sub_level_2_item_border_right = 0;
	}
	else
	{
		$sub_level_2_item_border_top = 1;
		$sub_level_2_item_border_bottom = 1;
		$sub_level_2_item_border_left = 1;
		$sub_level_2_item_border_right = 1;
	}
	
	if (!is_null($row["border_style"]) && ($row["border_style"] != ""))
		$sub_level_2_item_border_style = $row["border_style"];
	else
		$sub_level_2_item_border_style = "-not selected-";
		
	if (!is_null($row["radius_top_left"]) && ($row["radius_top_left"] != 0))
		$sub_level_2_radius_top_left = $row["radius_top_left"];
	else
		$sub_level_2_radius_top_left = _NOT_SET_;
	if (!is_null($row["radius_top_left_units"]))
		$sub_level_2_radius_top_left_units = $row["radius_top_left_units"];
	else
		$sub_level_2_radius_top_left_units = 0;
		
	if (!is_null($row["radius_top_right"]) && ($row["radius_top_right"] != 0))
		$sub_level_2_radius_top_right = $row["radius_top_right"];
	else
		$sub_level_2_radius_top_right = _NOT_SET_;
	if (!is_null($row["radius_top_right_units"]))
		$sub_level_2_radius_top_right_units = $row["radius_top_right_units"];
	else
		$sub_level_2_radius_top_right_units = 0;
		
	if (!is_null($row["radius_bottom_right"]) && ($row["radius_bottom_right"] != 0))
		$sub_level_2_radius_bottom_right = $row["radius_bottom_right"];
	else
		$sub_level_2_radius_bottom_right = _NOT_SET_;
	if (!is_null($row["radius_bottom_right_units"]))
		$sub_level_2_radius_bottom_right_units = $row["radius_bottom_right_units"];
	else
		$sub_level_2_radius_bottom_right_units = 0;
		
	if (!is_null($row["radius_bottom_left"]) && ($row["radius_bottom_left"] != 0))
		$sub_level_2_radius_bottom_left = $row["radius_bottom_left"];
	else
		$sub_level_2_radius_bottom_left = _NOT_SET_;
	if (!is_null($row["radius_bottom_left_units"]))
		$sub_level_2_radius_bottom_left_units = $row["radius_bottom_left_units"];
	else
		$sub_level_2_radius_bottom_left_units = 0;
		
	if (!is_null($row["box_shadow_horizontal"]) && ($row["box_shadow_horizontal"] != -1000000))	{
		$sub_level_2_box_shadow_horizontal = $row["box_shadow_horizontal"];
		if ((float)$sub_level_2_box_shadow_horizontal == (int)$sub_level_2_box_shadow_horizontal)
			$sub_level_2_box_shadow_horizontal = intval($sub_level_2_box_shadow_horizontal);
		else
			$sub_level_2_box_shadow_horizontal = floatval($sub_level_2_box_shadow_horizontal);
	}
	else
		$sub_level_2_box_shadow_horizontal = _NOT_SET_;
	if (!is_null($row["box_shadow_vertical"]) && ($row["box_shadow_vertical"] != -1000000))	{
		$sub_level_2_box_shadow_vertical = $row["box_shadow_vertical"];
		if ((float)$sub_level_2_box_shadow_vertical == (int)$sub_level_2_box_shadow_vertical)
			$sub_level_2_box_shadow_vertical = intval($sub_level_2_box_shadow_vertical);
		else
			$sub_level_2_box_shadow_vertical = floatval($sub_level_2_box_shadow_vertical);
	}
	else
		$sub_level_2_box_shadow_vertical = _NOT_SET_;
	if (!is_null($row["box_shadow_blur"]) && ($row["box_shadow_blur"] != -1))	{
		$sub_level_2_box_shadow_blur = $row["box_shadow_blur"];
		if ((float)$sub_level_2_box_shadow_blur == (int)$sub_level_2_box_shadow_blur)
			$sub_level_2_box_shadow_blur = intval($sub_level_2_box_shadow_blur);
		else
			$sub_level_2_box_shadow_blur = floatval($sub_level_2_box_shadow_blur);
	}
	else
		$sub_level_2_box_shadow_blur = _NOT_SET_;
	if (!is_null($row["box_shadow_spread"]) && ($row["box_shadow_spread"] != -1000000))	{
		$sub_level_2_box_shadow_spread = $row["box_shadow_spread"];
		if ((float)$sub_level_2_box_shadow_spread == (int)$sub_level_2_box_shadow_spread)
			$sub_level_2_box_shadow_spread = intval($sub_level_2_box_shadow_spread);
		else
			$sub_level_2_box_shadow_spread = floatval($sub_level_2_box_shadow_spread);
	}
	else
		$sub_level_2_box_shadow_spread = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_2_box_shadow_color = $row["box_shadow_color"];
	else
		$sub_level_2_box_shadow_color = _NOT_SET_;
	if (!is_null($row["box_shadow_inset"]) && ($row["box_shadow_inset"] != ""))
		$sub_level_2_box_shadow_inset = $row["box_shadow_inset"];
	else
		$sub_level_2_box_shadow_inset = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_2_gradient_type = $row["gradient_type"];
	else
		$sub_level_2_gradient_type = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_2_gradient_angle = $row["gradient_angle"];
	else
		$sub_level_2_gradient_angle = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_2_gradient_colors = $row["gradient_colors"];
	else
		$sub_level_2_gradient_colors = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_2_gradient_opacities = $row["gradient_opacities"];
	else
		$sub_level_2_gradient_opacities = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_2_gradient_repeat = $row["gradient_repeat"];
	else
		$sub_level_2_gradient_repeat = 0;
		
	if (!is_null($sub_level_2_gradient_colors) && ($sub_level_2_gradient_colors != "-not set-") && ($sub_level_2_gradient_colors != ""))	{
		$gradient_color_arr = explode(",", $sub_level_2_gradient_colors);
		if (!is_null($gradient_color_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_2_gradient_color_1 = $gradient_color_arr[0];
		else
			$sub_level_2_gradient_color_1 = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_2_gradient_color_2 = $gradient_color_arr[1];
		else
			$sub_level_2_gradient_color_2 = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_2_gradient_color_3 = $gradient_color_arr[2];
		else
			$sub_level_2_gradient_color_3 = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_2_gradient_color_4 = $gradient_color_arr[3];
		else
			$sub_level_2_gradient_color_4 = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_2_gradient_color_1 = _NOT_SET_;
		$sub_level_2_gradient_color_2 = _NOT_SET_;
		$sub_level_2_gradient_color_3 = _NOT_SET_;
		$sub_level_2_gradient_color_4 = _NOT_SET_;
	}
	
	if (!is_null($sub_level_2_gradient_opacities) && ($sub_level_2_gradient_opacities != "-not set-") && ($sub_level_2_gradient_opacities != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_2_gradient_opacities);
		if (!is_null($gradient_opacity_arr[0]))
			$sub_level_2_gradient_opacity_1 = $gradient_opacity_arr[0];
		else
			$sub_level_2_gradient_opacity_1 = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_2_gradient_opacity_2 = $gradient_opacity_arr[1];
		else
			$sub_level_2_gradient_opacity_2 = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_2_gradient_opacity_3 = $gradient_opacity_arr[2];
		else
			$sub_level_2_gradient_opacity_3 = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_2_gradient_opacity_4 = $gradient_opacity_arr[3];
		else
			$sub_level_2_gradient_opacity_4 = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_2_gradient_opacity_1 = 100;
		$sub_level_2_gradient_opacity_2 = 100;
		$sub_level_2_gradient_opacity_3 = 100;
		$sub_level_2_gradient_opacity_4 = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$sub_level_2_underline = $row["underline"];
	else
		$sub_level_2_underline = 0;
	if (!is_null($row["overline"]))
		$sub_level_2_overline = $row["overline"];
	else
		$sub_level_2_overline = 0;
	if (!is_null($row["blink"]))
		$sub_level_2_blink = $row["blink"];
	else
		$sub_level_2_blink = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color_hover = $row["text_color"];
	elseif ($load_defaults == 1)
		$top_level_text_color_hover = "#FFFFFF";
	else
		$top_level_text_color_hover = _NOT_SET_;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_hover = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$top_level_background_color_hover = "#336699";
	else
		$top_level_background_color_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_hover = $row["border_color"];
	else
		$top_level_item_border_color_hover = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$top_level_font_size_hover = $row["font_size"];
	else
		$top_level_font_size_hover = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$top_level_font_size_hover_units = $row["font_size_units"];
	else
		$top_level_font_size_hover_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$top_level_weight_hover = $row["weight"];
	elseif ($load_defaults == 1)
		$top_level_weight_hover = "bold";
	if (!is_null($row["letter_spacing"]))
		$top_level_letter_spacing_hover = $row["letter_spacing"];
	else
		$top_level_letter_spacing_hover = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$top_level_letter_spacing_hover_units = $row["letter_spacing_units"];
	else
		$top_level_letter_spacing_hover_units = "-not selected-";
	if (!is_null($row["italic"]))
		$top_level_italic_hover = $row["italic"];
	else
		$top_level_italic_hover = 0;
	if (!is_null($row["oblique"]))
		$top_level_oblique_hover = $row["oblique"];
	else
		$top_level_oblique_hover = 0;
	if (!is_null($row["small_caps"]))
		$top_level_small_caps_hover = $row["small_caps"];
	else
		$top_level_small_caps_hover = 0;
		
	if ((!is_null($row["shadow"])) && ($top_level_shadow == 1) && ($row["shadow"] == 1) && ($row["shadow_x_offset"] == 0) && ($row["shadow_y_offset"] == 0) && ($row["shadow_blur"] == 0))
		$top_level_shadow_hover = 0;
	elseif (!is_null($row["shadow"]))
		$top_level_shadow_hover = $row["shadow"];
	else
		$top_level_shadow_hover = 0;
	if (!is_null($row["shadow_color"]))
		$top_level_shadow_color_hover = $row["shadow_color"];
	else
		$top_level_shadow_color_hover = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$top_level_box_shadow_color_hover = $row["box_shadow_color"];
	else
		$top_level_box_shadow_color_hover = _NOT_SET_;
		
	
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$top_level_gradient_type_hover = $row["gradient_type"];
	else
		$top_level_gradient_type_hover = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$top_level_gradient_angle_hover = $row["gradient_angle"];
	else
		$top_level_gradient_angle_hover = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$top_level_gradient_colors_hover = $row["gradient_colors"];
	else
		$top_level_gradient_colors_hover = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$top_level_gradient_opacities_hover = $row["gradient_opacities"];
	else
		$top_level_gradient_opacities_hover = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$top_level_gradient_repeat_hover = $row["gradient_repeat"];
	else
		$top_level_gradient_repeat_hover = 0;
		
	if (!is_null($top_level_gradient_colors_hover) && ($top_level_gradient_colors_hover != "-not set-") && ($top_level_gradient_colors_hover != ""))	{
		$gradient_color_arr = explode(",", $top_level_gradient_colors_hover);
		if (!is_null($gradient_color_arr[0]))
			$top_level_gradient_color_1_hover = $gradient_color_arr[0];
		else
			$top_level_gradient_color_1_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$top_level_gradient_color_2_hover = $gradient_color_arr[1];
		else
			$top_level_gradient_color_2_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$top_level_gradient_color_3_hover = $gradient_color_arr[2];
		else
			$top_level_gradient_color_3_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$top_level_gradient_color_4_hover = $gradient_color_arr[3];
		else
			$top_level_gradient_color_4_hover = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$top_level_gradient_color_1_hover = _NOT_SET_;
		$top_level_gradient_color_2_hover = _NOT_SET_;
		$top_level_gradient_color_3_hover = _NOT_SET_;
		$top_level_gradient_color_4_hover = _NOT_SET_;
	}
	
	if (!is_null($top_level_gradient_opacities_hover) && ($top_level_gradient_opacities_hover != "-not set-") && ($top_level_gradient_opacities_hover != ""))	{
		$gradient_opacity_arr = explode(",", $top_level_gradient_opacities_hover);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$top_level_gradient_opacity_1_hover = $gradient_opacity_arr[0];
		else
			$top_level_gradient_opacity_1_hover = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$top_level_gradient_opacity_2_hover = $gradient_opacity_arr[1];
		else
			$top_level_gradient_opacity_2_hover = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$top_level_gradient_opacity_3_hover = $gradient_opacity_arr[2];
		else
			$top_level_gradient_opacity_3_hover = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$top_level_gradient_opacity_4_hover = $gradient_opacity_arr[3];
		else
			$top_level_gradient_opacity_4_hover = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$top_level_gradient_opacity_1_hover = 100;
		$top_level_gradient_opacity_2_hover = 100;
		$top_level_gradient_opacity_3_hover = 100;
		$top_level_gradient_opacity_4_hover = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$top_level_underline_hover = $row["underline"];
	else
		$top_level_underline_hover = 0;
	if (!is_null($row["overline"]))
		$top_level_overline_hover = $row["overline"];
	else
		$top_level_overline_hover = 0;
	if (!is_null($row["blink"]))
		$top_level_blink_hover = $row["blink"];
	else
		$top_level_blink_hover = 0;

	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color_active = $row["text_color"];
	elseif ($load_defaults == 1)
		$top_level_text_color_active = "#880000";
	else
		$top_level_text_color_active = _NOT_SET_;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_active = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$top_level_background_color_active = "#000088";
	else
		$top_level_background_color_active = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_active = $row["border_color"];
	else
		$top_level_item_border_color_active = _NOT_SET_;
	if (!is_null($row["shadow_color"]))
		$top_level_shadow_color_active = $row["shadow_color"];
	else
		$top_level_shadow_color_active = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$top_level_box_shadow_color_active = $row["box_shadow_color"];
	else
		$top_level_box_shadow_color_active = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$top_level_gradient_type_active = $row["gradient_type"];
	else
		$top_level_gradient_type_active = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$top_level_gradient_angle_active = $row["gradient_angle"];
	else
		$top_level_gradient_angle_active = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$top_level_gradient_colors_active = $row["gradient_colors"];
	else
		$top_level_gradient_colors_active = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$top_level_gradient_opacities_active = $row["gradient_opacities"];
	else
		$top_level_gradient_opacities_active = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$top_level_gradient_repeat_active = $row["gradient_repeat"];
	else
		$top_level_gradient_repeat_active = 0;
		
	if (!is_null($top_level_gradient_colors_active) && ($top_level_gradient_colors_active != "-not set-") && ($top_level_gradient_colors_active != ""))	{
		$gradient_color_arr = explode(",", $top_level_gradient_colors_active);
		if (!is_null($gradient_color_arr[0]))
			$top_level_gradient_color_1_active = $gradient_color_arr[0];
		else
			$top_level_gradient_color_1_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$top_level_gradient_color_2_active = $gradient_color_arr[1];
		else
			$top_level_gradient_color_2_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$top_level_gradient_color_3_active = $gradient_color_arr[2];
		else
			$top_level_gradient_color_3_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$top_level_gradient_color_4_active = $gradient_color_arr[3];
		else
			$top_level_gradient_color_4_active = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$top_level_gradient_color_1_active = _NOT_SET_;
		$top_level_gradient_color_2_active = _NOT_SET_;
		$top_level_gradient_color_3_active = _NOT_SET_;
		$top_level_gradient_color_4_active = _NOT_SET_;
	}
	
	if (!is_null($top_level_gradient_opacities_active) && ($top_level_gradient_opacities_active != "-not set-") && ($top_level_gradient_opacities_active != ""))	{
		$gradient_opacity_arr = explode(",", $top_level_gradient_opacities_active);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$top_level_gradient_opacity_1_active = $gradient_opacity_arr[0];
		else
			$top_level_gradient_opacity_1_active = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$top_level_gradient_opacity_2_active = $gradient_opacity_arr[1];
		else
			$top_level_gradient_opacity_2_active = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$top_level_gradient_opacity_3_active = $gradient_opacity_arr[2];
		else
			$top_level_gradient_opacity_3_active = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$top_level_gradient_opacity_4_active = $gradient_opacity_arr[3];
		else
			$top_level_gradient_opacity_4_active = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$top_level_gradient_opacity_1_active = 100;
		$top_level_gradient_opacity_2_active = 100;
		$top_level_gradient_opacity_3_active = 100;
		$top_level_gradient_opacity_4_active = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_hover = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_text_color_hover = "#FFFFFF";
	else
		$sub_level_1_text_color_hover = _NOT_SET_;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_1_background_color_hover = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_background_color_hover = "#336699";
	else
		$sub_level_1_background_color_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_1_item_border_color_hover = $row["border_color"];
	else
		$sub_level_1_item_border_color_hover = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_1_font_size_hover = $row["font_size"];
	else
		$sub_level_1_font_size_hover = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_1_font_size_hover_units = $row["font_size_units"];
	else
		$sub_level_1_font_size_hover_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$sub_level_1_weight_hover = $row["weight"];
	elseif ($load_defaults == 1)
		$sub_level_1_weight_hover = "bold";	
	if (!is_null($row["letter_spacing"]))
		$sub_level_1_letter_spacing_hover = $row["letter_spacing"];
	else
		$sub_level_1_letter_spacing_hover = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_1_letter_spacing_hover_units = $row["letter_spacing_units"];
	else
		$sub_level_1_letter_spacing_hover_units = "-not selected-";
	if (!is_null($row["italic"]))
		$sub_level_1_italic_hover = $row["italic"];
	else
		$sub_level_1_italic_hover = 0;
	if (!is_null($row["oblique"]))
		$sub_level_1_oblique_hover = $row["oblique"];
	else
		$sub_level_1_oblique_hover = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_1_small_caps_hover = $row["small_caps"];
	else
		$sub_level_1_small_caps_hover = 0;
		
	if ((!is_null($row["shadow"])) && ($sub_level_1_shadow == 1) && ($row["shadow"] == 1) && ($row["shadow_x_offset"] == 0) && ($row["shadow_y_offset"] == 0) && ($row["shadow_blur"] == 0))
		$sub_level_1_shadow_hover = 0;
	elseif (!is_null($row["shadow"]))
		$sub_level_1_shadow_hover = $row["shadow"];
	else
		$sub_level_1_shadow_hover = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_1_shadow_color_hover = $row["shadow_color"];
	else
		$sub_level_1_shadow_color_hover = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_1_box_shadow_color_hover = $row["box_shadow_color"];
	else
		$sub_level_1_box_shadow_color_hover = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_1_gradient_type_hover = $row["gradient_type"];
	else
		$sub_level_1_gradient_type_hover = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_1_gradient_angle_hover = $row["gradient_angle"];
	else
		$sub_level_1_gradient_angle_hover = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_1_gradient_colors_hover = $row["gradient_colors"];
	else
		$sub_level_1_gradient_colors_hover = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_1_gradient_opacities_hover = $row["gradient_opacities"];
	else
		$sub_level_1_gradient_opacities_hover = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_1_gradient_repeat_hover = $row["gradient_repeat"];
	else
		$sub_level_1_gradient_repeat_hover = 0;
		
	if (!is_null($sub_level_1_gradient_colors_hover) && ($sub_level_1_gradient_colors_hover != "-not set-") && ($sub_level_1_gradient_colors_hover != ""))	{
		$gradient_color_arr = explode(",", $sub_level_1_gradient_colors_hover);
		if (!is_null($gradient_color_arr[0]))
			$sub_level_1_gradient_color_1_hover = $gradient_color_arr[0];
		else
			$sub_level_1_gradient_color_1_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_1_gradient_color_2_hover = $gradient_color_arr[1];
		else
			$sub_level_1_gradient_color_2_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_1_gradient_color_3_hover = $gradient_color_arr[2];
		else
			$sub_level_1_gradient_color_3_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_1_gradient_color_4_hover = $gradient_color_arr[3];
		else
			$sub_level_1_gradient_color_4_hover = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_1_gradient_color_1_hover = _NOT_SET_;
		$sub_level_1_gradient_color_2_hover = _NOT_SET_;
		$sub_level_1_gradient_color_3_hover = _NOT_SET_;
		$sub_level_1_gradient_color_4_hover = _NOT_SET_;
	}
	
	if (!is_null($sub_level_1_gradient_opacities_hover) && ($sub_level_1_gradient_opacities_hover != "-not set-") && ($sub_level_1_gradient_opacities_hover != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_1_gradient_opacities_hover);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_1_gradient_opacity_1_hover = $gradient_opacity_arr[0];
		else
			$sub_level_1_gradient_opacity_1_hover = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_1_gradient_opacity_2_hover = $gradient_opacity_arr[1];
		else
			$sub_level_1_gradient_opacity_2_hover = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_1_gradient_opacity_3_hover = $gradient_opacity_arr[2];
		else
			$sub_level_1_gradient_opacity_3_hover = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_1_gradient_opacity_4_hover = $gradient_opacity_arr[3];
		else
			$sub_level_1_gradient_opacity_4_hover = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_1_gradient_opacity_1_hover = 100;
		$sub_level_1_gradient_opacity_2_hover = 100;
		$sub_level_1_gradient_opacity_3_hover = 100;
		$sub_level_1_gradient_opacity_4_hover = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_a" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$sub_level_1_underline_hover = $row["underline"];
	else
		$sub_level_1_underline_hover = 0;
	if (!is_null($row["overline"]))
		$sub_level_1_overline_hover = $row["overline"];
	else
		$sub_level_1_overline_hover = 0;
	if (!is_null($row["blink"]))
		$sub_level_1_blink_hover = $row["blink"];
	else
		$sub_level_1_blink_hover = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_active = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_text_color_active = "#880000";
	else
		$sub_level_1_text_color_active = _NOT_SET_;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_1_background_color_active = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_background_color_active = "#000088";
	else
		$sub_level_1_background_color_active = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_1_item_border_color_active = $row["border_color"];
	else
		$sub_level_1_item_border_color_active = _NOT_SET_;
	if (!is_null($row["shadow_color"]))
		$sub_level_1_shadow_color_active = $row["shadow_color"];
	else
		$sub_level_1_shadow_color_active = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_1_box_shadow_color_active = $row["box_shadow_color"];
	else
		$sub_level_1_box_shadow_color_active = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_1_gradient_type_active = $row["gradient_type"];
	else
		$sub_level_1_gradient_type_active = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_1_gradient_angle_active = $row["gradient_angle"];
	else
		$sub_level_1_gradient_angle_active = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_1_gradient_colors_active = $row["gradient_colors"];
	else
		$sub_level_1_gradient_colors_active = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_1_gradient_opacities_active = $row["gradient_opacities"];
	else
		$sub_level_1_gradient_opacities_active = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_1_gradient_repeat_active = $row["gradient_repeat"];
	else
		$sub_level_1_gradient_repeat_active = 0;
		
	if (!is_null($sub_level_1_gradient_colors_active) && ($sub_level_1_gradient_colors_active != "-not set-") && ($sub_level_1_gradient_colors_active != ""))	{
		$gradient_color_arr = explode(",", $sub_level_1_gradient_colors_active);
		if (!is_null($gradient_color_arr[0]))
			$sub_level_1_gradient_color_1_active = $gradient_color_arr[0];
		else
			$sub_level_1_gradient_color_1_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_1_gradient_color_2_active = $gradient_color_arr[1];
		else
			$sub_level_1_gradient_color_2_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_1_gradient_color_3_active = $gradient_color_arr[2];
		else
			$sub_level_1_gradient_color_3_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_1_gradient_color_4_active = $gradient_color_arr[3];
		else
			$sub_level_1_gradient_color_4_active = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_1_gradient_color_1_active = _NOT_SET_;
		$sub_level_1_gradient_color_2_active = _NOT_SET_;
		$sub_level_1_gradient_color_3_active = _NOT_SET_;
		$sub_level_1_gradient_color_4_active = _NOT_SET_;
	}
	
	if (!is_null($sub_level_1_gradient_opacities_active) && ($sub_level_1_gradient_opacities_active != "-not set-") && ($sub_level_1_gradient_opacities_active != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_1_gradient_opacities_active);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_1_gradient_opacity_1_active = $gradient_opacity_arr[0];
		else
			$sub_level_1_gradient_opacity_1_active = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_1_gradient_opacity_2_active = $gradient_opacity_arr[1];
		else
			$sub_level_1_gradient_opacity_2_active = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_1_gradient_opacity_3_active = $gradient_opacity_arr[2];
		else
			$sub_level_1_gradient_opacity_3_active = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_1_gradient_opacity_4_active = $gradient_opacity_arr[3];
		else
			$sub_level_1_gradient_opacity_4_active = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_1_gradient_opacity_1_active = 100;
		$sub_level_1_gradient_opacity_2_active = 100;
		$sub_level_1_gradient_opacity_3_active = 100;
		$sub_level_1_gradient_opacity_4_active = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color_hover = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_text_color_hover = "#FFFFFF";
	else
		$sub_level_2_text_color_hover = _NOT_SET_;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_2_background_color_hover = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_background_color_hover = "#336699";
	else
		$sub_level_2_background_color_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_2_item_border_color_hover = $row["border_color"];
	else
		$sub_level_2_item_border_color_hover = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_2_font_size_hover = $row["font_size"];
	else
		$sub_level_2_font_size_hover = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_2_font_size_hover_units = $row["font_size_units"];
	else
		$sub_level_2_font_size_hover_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$sub_level_2_weight_hover = $row["weight"];
	elseif ($load_defaults == 1)
		$sub_level_2_weight_hover = "bold";
	if (!is_null($row["letter_spacing"]))
		$sub_level_2_letter_spacing_hover = $row["letter_spacing"];
	else
		$sub_level_2_letter_spacing_hover = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_2_letter_spacing_hover_units = $row["letter_spacing_units"];
	else
		$sub_level_2_letter_spacing_hover_units = "-not selected-";
	if (!is_null($row["italic"]))
		$sub_level_2_italic_hover = $row["italic"];
	else
		$sub_level_2_italic_hover = 0;
	if (!is_null($row["oblique"]))
		$sub_level_2_oblique_hover = $row["oblique"];
	else
		$sub_level_2_oblique_hover = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_2_small_caps_hover = $row["small_caps"];
	else
		$sub_level_2_small_caps_hover = 0;
		
	if ((!is_null($row["shadow"])) && ($sub_level_2_shadow == 1) && ($row["shadow"] == 1) && ($row["shadow_x_offset"] == 0) && ($row["shadow_y_offset"] == 0) && ($row["shadow_blur"] == 0))
		$sub_level_2_shadow_hover = 0;
	elseif (!is_null($row["shadow"]))
		$sub_level_2_shadow_hover = $row["shadow"];
	else
		$sub_level_2_shadow_hover = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_2_shadow_color_hover = $row["shadow_color"];
	else
		$sub_level_2_shadow_color_hover = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_2_box_shadow_color_hover = $row["box_shadow_color"];
	else
		$sub_level_2_box_shadow_color_hover = _NOT_SET_;
		
	
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_2_gradient_type_hover = $row["gradient_type"];
	else
		$sub_level_2_gradient_type_hover = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_2_gradient_angle_hover = $row["gradient_angle"];
	else
		$sub_level_2_gradient_angle_hover = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_2_gradient_colors_hover = $row["gradient_colors"];
	else
		$sub_level_2_gradient_colors_hover = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_2_gradient_opacities_hover = $row["gradient_opacities"];
	else
		$sub_level_2_gradient_opacities_hover = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_2_gradient_repeat_hover = $row["gradient_repeat"];
	else
		$sub_level_2_gradient_repeat_hover = 0;
		
	if (!is_null($sub_level_2_gradient_colors_hover) && ($sub_level_2_gradient_colors_hover != "-not set-") && ($sub_level_2_gradient_colors_hover != ""))	{
		$gradient_color_arr = explode(",", $sub_level_2_gradient_colors_hover);
		if (!is_null($gradient_color_arr[0]))
			$sub_level_2_gradient_color_1_hover = $gradient_color_arr[0];
		else
			$sub_level_2_gradient_color_1_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_2_gradient_color_2_hover = $gradient_color_arr[1];
		else
			$sub_level_2_gradient_color_2_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_2_gradient_color_3_hover = $gradient_color_arr[2];
		else
			$sub_level_2_gradient_color_3_hover = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_2_gradient_color_4_hover = $gradient_color_arr[3];
		else
			$sub_level_2_gradient_color_4_hover = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_2_gradient_color_1_hover = _NOT_SET_;
		$sub_level_2_gradient_color_2_hover = _NOT_SET_;
		$sub_level_2_gradient_color_3_hover = _NOT_SET_;
		$sub_level_2_gradient_color_4_hover = _NOT_SET_;
	}
	
	if (!is_null($sub_level_2_gradient_opacities_hover) && ($sub_level_2_gradient_opacities_hover != "-not set-") && ($sub_level_2_gradient_opacities_hover != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_2_gradient_opacities_hover);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_2_gradient_opacity_1_hover = $gradient_opacity_arr[0];
		else
			$sub_level_2_gradient_opacity_1_hover = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_2_gradient_opacity_2_hover = $gradient_opacity_arr[1];
		else
			$sub_level_2_gradient_opacity_2_hover = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_2_gradient_opacity_3_hover = $gradient_opacity_arr[2];
		else
			$sub_level_2_gradient_opacity_3_hover = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_2_gradient_opacity_4_hover = $gradient_opacity_arr[3];
		else
			$sub_level_2_gradient_opacity_4_hover = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_2_gradient_opacity_1_hover = 100;
		$sub_level_2_gradient_opacity_2_hover = 100;
		$sub_level_2_gradient_opacity_3_hover = 100;
		$sub_level_2_gradient_opacity_4_hover = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$sub_level_2_underline_hover = $row["underline"];
	else
		$sub_level_2_underline_hover = 0;
	if (!is_null($row["overline"]))
		$sub_level_2_overline_hover = $row["overline"];
	else
		$sub_level_2_overline_hover = 0;
	if (!is_null($row["blink"]))
		$sub_level_2_blink_hover = $row["blink"];
	else
		$sub_level_2_blink_hover = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . " A:active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color_active = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_text_color_active = "#880000";
	else
		$sub_level_2_text_color_active = _NOT_SET_;
	
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li" . $suffix . ":active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_2_background_color_active = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_background_color_active = "#000088";
	else
		$sub_level_2_background_color_active = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_2_item_border_color_active = $row["border_color"];
	else
		$sub_level_2_item_border_color_active = _NOT_SET_;
	if (!is_null($row["shadow_color"]))
		$sub_level_2_shadow_color_active = $row["shadow_color"];
	else
		$sub_level_2_shadow_color_active = _NOT_SET_;
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_2_box_shadow_color_active = $row["box_shadow_color"];
	else
		$sub_level_2_box_shadow_color_active = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_2_gradient_type_active = $row["gradient_type"];
	else
		$sub_level_2_gradient_type_active = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_2_gradient_angle_active = $row["gradient_angle"];
	else
		$sub_level_2_gradient_angle_active = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_2_gradient_colors_active = $row["gradient_colors"];
	else
		$sub_level_2_gradient_colors_active = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_2_gradient_opacities_active = $row["gradient_opacities"];
	else
		$sub_level_2_gradient_opacities_active = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_2_gradient_repeat_active = $row["gradient_repeat"];
	else
		$sub_level_2_gradient_repeat_active = 0;
		
	if (!is_null($sub_level_2_gradient_colors_active) && ($sub_level_2_gradient_colors_active != "-not set-") && ($sub_level_2_gradient_colors_active != ""))	{
		$gradient_color_arr = explode(",", $sub_level_2_gradient_colors_active);
		if (!is_null($gradient_color_arr[0]))
			$sub_level_2_gradient_color_1_active = $gradient_color_arr[0];
		else
			$sub_level_2_gradient_color_1_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_2_gradient_color_2_active = $gradient_color_arr[1];
		else
			$sub_level_2_gradient_color_2_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_2_gradient_color_3_active = $gradient_color_arr[2];
		else
			$sub_level_2_gradient_color_3_active = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_2_gradient_color_4_active = $gradient_color_arr[3];
		else
			$sub_level_2_gradient_color_4_active = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_2_gradient_color_1_active = _NOT_SET_;
		$sub_level_2_gradient_color_2_active = _NOT_SET_;
		$sub_level_2_gradient_color_3_active = _NOT_SET_;
		$sub_level_2_gradient_color_4_active = _NOT_SET_;
	}
	
	if (!is_null($sub_level_2_gradient_opacities_active) && ($sub_level_2_gradient_opacities_active != "-not set-") && ($sub_level_2_gradient_opacities_active != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_2_gradient_opacities_active);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_2_gradient_opacity_1_active = $gradient_opacity_arr[0];
		else
			$sub_level_2_gradient_opacity_1_active = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_2_gradient_opacity_2_active = $gradient_opacity_arr[1];
		else
			$sub_level_2_gradient_opacity_2_active = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_2_gradient_opacity_3_active = $gradient_opacity_arr[2];
		else
			$sub_level_2_gradient_opacity_3_active = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_2_gradient_opacity_4_active = $gradient_opacity_arr[3];
		else
			$sub_level_2_gradient_opacity_4_active = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_2_gradient_opacity_1_active = 100;
		$sub_level_2_gradient_opacity_2_active = 100;
		$sub_level_2_gradient_opacity_3_active = 100;
		$sub_level_2_gradient_opacity_4_active = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] > -1)
		$top_level_block_border_width = $row["border"];
	elseif ($load_defaults == 1)
		$top_level_block_border_width = 1;
	else
		$top_level_block_border_width = _NOT_SET_;
		
	if ($row["border_units"] > -1)
		$top_level_block_border_units = $row["border_units"];
	else
		$top_level_block_border_units = 0;
	
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_block_border_color = $row["border_color"];
	elseif ($load_defaults == 1)
		$top_level_block_border_color = "#336699";
	else
		$top_level_block_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$top_level_block_border_top = 1;
		else
			$top_level_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$top_level_block_border_bottom = 1;
		else
			$top_level_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$top_level_block_border_left = 1;
		else
			$top_level_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$top_level_block_border_right = 1;
		else
			$top_level_block_border_right = 0;
	}
	else
	{
		$top_level_block_border_top = 1;
		$top_level_block_border_bottom = 1;
		$top_level_block_border_left = 1;
		$top_level_block_border_right = 1;
	}
	
	if (!is_null($row["border_style"]) && ($row["border_style"] != ""))
		$top_level_block_border_style = $row["border_style"];
	else
		$top_level_block_border_style = "-not selected-";
		
	/////////////////////////////////////////////////////////////////////////////////////////
//	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = 'ul.nav" . $suffix . " li>ul'";
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] > -1)
		$sub_level_1_block_border_width = $row["border"];
	elseif ($load_defaults == 1)
		$sub_level_1_block_border_width = 1;
	else
		$sub_level_1_block_border_width = _NOT_SET_;
		
	if ($row["border_units"] > -1)
		$sub_level_1_block_border_units = $row["border_units"];
	else
		$sub_level_1_block_border_units = 0;
		
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_1_block_border_color = $row["border_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_block_border_color = "#336699";
	else
		$sub_level_1_block_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_1_block_border_top = 1;
		else
			$sub_level_1_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_1_block_border_bottom = 1;
		else
			$sub_level_1_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_1_block_border_left = 1;
		else
			$sub_level_1_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_1_block_border_right = 1;
		else
			$sub_level_1_block_border_right = 0;
	}
	else
	{
		$sub_level_1_block_border_top = 1;
		$sub_level_1_block_border_bottom = 1;
		$sub_level_1_block_border_left = 1;
		$sub_level_1_block_border_right = 1;
	}
	
	if (!is_null($row["border_style"]) && ($row["border_style"] != ""))
		$sub_level_1_block_border_style = $row["border_style"];
	else
		$sub_level_1_block_border_style = "-not selected-";
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] > -1)
		$sub_level_2_block_border_width = $row["border"];
	elseif ($load_defaults == 1)
		$sub_level_2_block_border_width = 1;
	else
		$sub_level_2_block_border_width = _NOT_SET_;
		
	if ($row["border_units"] > -1)
		$sub_level_2_block_border_units = $row["border_units"];
	else
		$sub_level_2_block_border_units = 0;
		
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_2_block_border_color = $row["border_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_block_border_color = "#336699";
	else
		$sub_level_2_block_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_2_block_border_top = 1;
		else
			$sub_level_2_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_2_block_border_bottom = 1;
		else
			$sub_level_2_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_2_block_border_left = 1;
		else
			$sub_level_2_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_2_block_border_right = 1;
		else
			$sub_level_2_block_border_right = 0;
	}
	else
	{
		$sub_level_2_block_border_top = 1;
		$sub_level_2_block_border_bottom = 1;
		$sub_level_2_block_border_left = 1;
		$sub_level_2_block_border_right = 1;
	}
	
	if (!is_null($row["border_style"]) && ($row["border_style"] != ""))
		$sub_level_2_block_border_style = $row["border_style"];
	else
		$sub_level_2_block_border_style = "-not selected-";
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_down = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$top_level_background_color_down = "#FFFFFF";
	else
		$top_level_background_color_down = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_down = $row["border_color"];
	else
		$top_level_item_border_color_down = _NOT_SET_;
		
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color_down = $row["text_color"];
	elseif ($load_defaults == 1)
		$top_level_text_color_down = "#336699";
	else
		$top_level_text_color_down = _NOT_SET_;
		
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$top_level_font_size_down = $row["font_size"];
	else
		$top_level_font_size_down = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$top_level_font_size_down_units = $row["font_size_units"];
	else
		$top_level_font_size_down_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$top_level_weight_down = $row["weight"];
	elseif ($load_defaults == 1)
		$top_level_weight_down = "bold";
	if (!is_null($row["letter_spacing"]))
		$top_level_letter_spacing_down = $row["letter_spacing"];
	else
		$top_level_letter_spacing_down = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$top_level_letter_spacing_down_units = $row["letter_spacing_units"];
	else
		$top_level_letter_spacing_down_units = "-not selected-";
	if (!is_null($row["italic"]))
		$top_level_italic_down = $row["italic"];
	else
		$top_level_italic_down = 0;
	if (!is_null($row["oblique"]))
		$top_level_oblique_down = $row["oblique"];
	else
		$top_level_oblique_down = 0;
	if (!is_null($row["small_caps"]))
		$top_level_small_caps_down = $row["small_caps"];
	else
		$top_level_small_caps_down = 0;
		
	if (!is_null($row["shadow"]))
		$top_level_shadow_down = $row["shadow"];
	else
		$top_level_shadow_down = 0;
	if (!is_null($row["shadow_color"]))
		$top_level_shadow_color_down = $row["shadow_color"];
	else
		$top_level_shadow_color_down = _NOT_SET_;
		
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$top_level_box_shadow_color_down = $row["box_shadow_color"];
	else
		$top_level_box_shadow_color_down = _NOT_SET_;
		
	
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$top_level_gradient_type_down = $row["gradient_type"];
	else
		$top_level_gradient_type_down = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$top_level_gradient_angle_down = $row["gradient_angle"];
	else
		$top_level_gradient_angle_down = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$top_level_gradient_colors_down = $row["gradient_colors"];
	else
		$top_level_gradient_colors_down = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$top_level_gradient_opacities_down = $row["gradient_opacities"];
	else
		$top_level_gradient_opacities_down = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$top_level_gradient_repeat_down = $row["gradient_repeat"];
	else
		$top_level_gradient_repeat_down = 0;
		
	if (!is_null($top_level_gradient_colors_down) && ($top_level_gradient_colors_down != "-not set-") && ($top_level_gradient_colors_down != ""))	{
		$gradient_color_arr = explode(",", $top_level_gradient_colors_down);
		if (!is_null($gradient_color_arr[0]))
			$top_level_gradient_color_1_down = $gradient_color_arr[0];
		else
			$top_level_gradient_color_1_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$top_level_gradient_color_2_down = $gradient_color_arr[1];
		else
			$top_level_gradient_color_2_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$top_level_gradient_color_3_down = $gradient_color_arr[2];
		else
			$top_level_gradient_color_3_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$top_level_gradient_color_4_down = $gradient_color_arr[3];
		else
			$top_level_gradient_color_4_down = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$top_level_gradient_color_1_down = _NOT_SET_;
		$top_level_gradient_color_2_down = _NOT_SET_;
		$top_level_gradient_color_3_down = _NOT_SET_;
		$top_level_gradient_color_4_down = _NOT_SET_;
	}
	
	if (!is_null($top_level_gradient_opacities_down) && ($top_level_gradient_opacities_down != "-not set-") && ($top_level_gradient_opacities_down != ""))	{
		$gradient_opacity_arr = explode(",", $top_level_gradient_opacities_down);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$top_level_gradient_opacity_1_down = $gradient_opacity_arr[0];
		else
			$top_level_gradient_opacity_1_down = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$top_level_gradient_opacity_2_down = $gradient_opacity_arr[1];
		else
			$top_level_gradient_opacity_2_down = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$top_level_gradient_opacity_3_down = $gradient_opacity_arr[2];
		else
			$top_level_gradient_opacity_3_down = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$top_level_gradient_opacity_4_down = $gradient_opacity_arr[3];
		else
			$top_level_gradient_opacity_4_down = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$top_level_gradient_opacity_1_down = 100;
		$top_level_gradient_opacity_2_down = 100;
		$top_level_gradient_opacity_3_down = 100;
		$top_level_gradient_opacity_4_down = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	
	if (!is_null($row["underline"]))
		$top_level_underline_down = $row["underline"];
	else
		$top_level_underline_down = 0;
	if (!is_null($row["overline"]))
		$top_level_overline_down = $row["overline"];
	else
		$top_level_overline_down = 0;
	if (!is_null($row["blink"]))
		$top_level_blink_down = $row["blink"];
	else
		$top_level_blink_down = 0;

	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_down = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_text_color_down = "#336699";
	else
		$sub_level_1_text_color_down = _NOT_SET_;
		
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_1_background_color_down = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_background_color_down = "#FFFFFF";
	else
		$sub_level_1_background_color_down = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_1_item_border_color_down = $row["border_color"];
	else
		$sub_level_1_item_border_color_down = _NOT_SET_;
		
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_1_font_size_down = $row["font_size"];
	else
		$sub_level_1_font_size_down = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_1_font_size_down_units = $row["font_size_units"];
	else
		$sub_level_1_font_size_down_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$sub_level_1_weight_down = $row["weight"];
	elseif ($load_defaults == 1)
		$sub_level_1_weight_down = "bold";	
	if (!is_null($row["letter_spacing"]))
		$sub_level_1_letter_spacing_down = $row["letter_spacing"];
	else
		$sub_level_1_letter_spacing_down = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_1_letter_spacing_down_units = $row["letter_spacing_units"];
	else
		$sub_level_1_letter_spacing_down_units = "-not selected-";
	if (!is_null($row["italic"]))
		$sub_level_1_italic_down = $row["italic"];
	else
		$sub_level_1_italic_down = 0;
	if (!is_null($row["oblique"]))
		$sub_level_1_oblique_down = $row["oblique"];
	else
		$sub_level_1_oblique_down = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_1_small_caps_down = $row["small_caps"];
	else
		$sub_level_1_small_caps_down = 0;
		
	if (!is_null($row["shadow"]))
		$sub_level_1_shadow_down = $row["shadow"];
	else
		$sub_level_1_shadow_down = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_1_shadow_color_down = $row["shadow_color"];
	else
		$sub_level_1_shadow_color_down = _NOT_SET_;
		
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_1_box_shadow_color_down = $row["box_shadow_color"];
	else
		$sub_level_1_box_shadow_color_down = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_1_gradient_type_down = $row["gradient_type"];
	else
		$sub_level_1_gradient_type_down = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_1_gradient_angle_down = $row["gradient_angle"];
	else
		$sub_level_1_gradient_angle_down = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_1_gradient_colors_down = $row["gradient_colors"];
	else
		$sub_level_1_gradient_colors_down = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_1_gradient_opacities_down = $row["gradient_opacities"];
	else
		$sub_level_1_gradient_opacities_down = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_1_gradient_repeat_down = $row["gradient_repeat"];
	else
		$sub_level_1_gradient_repeat_down = 0;
		
	if (!is_null($sub_level_1_gradient_colors_down) && ($sub_level_1_gradient_colors_down != "-not set-") && ($sub_level_1_gradient_colors_down != ""))	{
		$gradient_color_arr = explode(",", $sub_level_1_gradient_colors_down);
		if (!is_null($gradient_color_arr[0]))
			$sub_level_1_gradient_color_1_down = $gradient_color_arr[0];
		else
			$sub_level_1_gradient_color_1_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_1_gradient_color_2_down = $gradient_color_arr[1];
		else
			$sub_level_1_gradient_color_2_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_1_gradient_color_3_down = $gradient_color_arr[2];
		else
			$sub_level_1_gradient_color_3_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_1_gradient_color_4_down = $gradient_color_arr[3];
		else
			$sub_level_1_gradient_color_4_down = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_1_gradient_color_1_down = _NOT_SET_;
		$sub_level_1_gradient_color_2_down = _NOT_SET_;
		$sub_level_1_gradient_color_3_down = _NOT_SET_;
		$sub_level_1_gradient_color_4_down = _NOT_SET_;
	}
	
	if (!is_null($sub_level_1_gradient_opacities_down) && ($sub_level_1_gradient_opacities_down != "-not set-") && ($sub_level_1_gradient_opacities_down != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_1_gradient_opacities_down);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_1_gradient_opacity_1_down = $gradient_opacity_arr[0];
		else
			$sub_level_1_gradient_opacity_1_down = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_1_gradient_opacity_2_down = $gradient_opacity_arr[1];
		else
			$sub_level_1_gradient_opacity_2_down = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_1_gradient_opacity_3_down = $gradient_opacity_arr[2];
		else
			$sub_level_1_gradient_opacity_3_down = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_1_gradient_opacity_4_down = $gradient_opacity_arr[3];
		else
			$sub_level_1_gradient_opacity_4_down = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_1_gradient_opacity_1_down = 100;
		$sub_level_1_gradient_opacity_2_down = 100;
		$sub_level_1_gradient_opacity_3_down = 100;
		$sub_level_1_gradient_opacity_4_down = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$sub_level_1_underline_down = $row["underline"];
	else
		$sub_level_1_underline_down = 0;
	if (!is_null($row["overline"]))
		$sub_level_1_overline_down = $row["overline"];
	else
		$sub_level_1_overline_down = 0;
	if (!is_null($row["blink"]))
		$sub_level_1_blink_down = $row["blink"];
	else
		$sub_level_1_blink_down = 0;


	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color_down = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_text_color_down = "#336699";
	else
		$sub_level_2_text_color_down = _NOT_SET_;
		
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_2_background_color_down = $row["bkgd_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_background_color_down = "#FFFFFF";
	else
		$sub_level_2_background_color_down = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_2_item_border_color_down = $row["border_color"];
	else
		$sub_level_2_item_border_color_down = _NOT_SET_;
		
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_2_font_size_down = $row["font_size"];
	else
		$sub_level_2_font_size_down = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_2_font_size_down_units = $row["font_size_units"];
	else
		$sub_level_2_font_size_down_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$sub_level_2_weight_down = $row["weight"];
	elseif ($load_defaults == 1)
		$sub_level_2_weight_down = "bold";
	if (!is_null($row["letter_spacing"]))
		$sub_level_2_letter_spacing_down = $row["letter_spacing"];
	else
		$sub_level_2_letter_spacing_down = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_2_letter_spacing_down_units = $row["letter_spacing_units"];
	else
		$sub_level_2_letter_spacing_down_units = "-not selected-";
	if (!is_null($row["italic"]))
		$sub_level_2_italic_down = $row["italic"];
	else
		$sub_level_2_italic_down = 0;
	if (!is_null($row["oblique"]))
		$sub_level_2_oblique_down = $row["oblique"];
	else
		$sub_level_2_oblique_down = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_2_small_caps_down = $row["small_caps"];
	else
		$sub_level_2_small_caps_down = 0;
		
	if (!is_null($row["shadow"]))
		$sub_level_2_shadow_down = $row["shadow"];
	else
		$sub_level_2_shadow_down = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_2_shadow_color_down = $row["shadow_color"];
	else
		$sub_level_2_shadow_color_down = _NOT_SET_;
		
	if (!is_null($row["box_shadow_color"]) && ($row["box_shadow_color"] != "-not set-") && ($row["box_shadow_color"] != ""))
		$sub_level_2_box_shadow_color_down = $row["box_shadow_color"];
	else
		$sub_level_2_box_shadow_color_down = _NOT_SET_;
		
		
	if (!is_null($row["gradient_type"]) && ($row["gradient_type"] != ""))
		$sub_level_2_gradient_type_down = $row["gradient_type"];
	else
		$sub_level_2_gradient_type_down = 0;
	if (!is_null($row["gradient_angle"]) && ($row["gradient_angle"] != ""))
		$sub_level_2_gradient_angle_down = $row["gradient_angle"];
	else
		$sub_level_2_gradient_angle_down = 180;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_2_gradient_colors_down = $row["gradient_colors"];
	else
		$sub_level_2_gradient_colors_down = _NOT_SET_;
	if (!is_null($row["gradient_opacities"]) && ($row["gradient_opacities"] != ""))
		$sub_level_2_gradient_opacities_down = $row["gradient_opacities"];
	else
		$sub_level_2_gradient_opacities_down = _NOT_SET_;
	if (!is_null($row["gradient_repeat"]) && ($row["gradient_repeat"] != ""))
		$sub_level_2_gradient_repeat_down = $row["gradient_repeat"];
	else
		$sub_level_2_gradient_repeat_down = 0;
		
	if (!is_null($sub_level_2_gradient_colors_down) && ($sub_level_2_gradient_colors_down != "-not set-") && ($sub_level_2_gradient_colors_down != ""))	{
		$gradient_color_arr = explode(",", $sub_level_2_gradient_colors_down);
		if (!is_null($gradient_color_arr[0]))
			$sub_level_2_gradient_color_1_down = $gradient_color_arr[0];
		else
			$sub_level_2_gradient_color_1_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[1]))
			$sub_level_2_gradient_color_2_down = $gradient_color_arr[1];
		else
			$sub_level_2_gradient_color_2_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[2]))
			$sub_level_2_gradient_color_3_down = $gradient_color_arr[2];
		else
			$sub_level_2_gradient_color_3_down = _NOT_SET_;
		if (!is_null($gradient_color_arr[3]))
			$sub_level_2_gradient_color_4_down = $gradient_color_arr[3];
		else
			$sub_level_2_gradient_color_4_down = _NOT_SET_;
		unset($gradient_color_arr);
	}
	else {
		$sub_level_2_gradient_color_1_down = _NOT_SET_;
		$sub_level_2_gradient_color_2_down = _NOT_SET_;
		$sub_level_2_gradient_color_3_down = _NOT_SET_;
		$sub_level_2_gradient_color_4_down = _NOT_SET_;
	}
	
	if (!is_null($sub_level_2_gradient_opacities_down) && ($sub_level_2_gradient_opacities_down != "-not set-") && ($sub_level_2_gradient_opacities_down != ""))	{
		$gradient_opacity_arr = explode(",", $sub_level_2_gradient_opacities_down);
		if (!is_null($gradient_opacity_arr[0]) && ($gradient_opacity_arr[0] != "-not set-"))
			$sub_level_2_gradient_opacity_1_down = $gradient_opacity_arr[0];
		else
			$sub_level_2_gradient_opacity_1_down = 100;
		if (!is_null($gradient_opacity_arr[1]))
			$sub_level_2_gradient_opacity_2_down = $gradient_opacity_arr[1];
		else
			$sub_level_2_gradient_opacity_2_down = 100;
		if (!is_null($gradient_opacity_arr[2]))
			$sub_level_2_gradient_opacity_3_down = $gradient_opacity_arr[2];
		else
			$sub_level_2_gradient_opacity_3_down = 100;
		if (!is_null($gradient_opacity_arr[3]))
			$sub_level_2_gradient_opacity_4_down = $gradient_opacity_arr[3];
		else
			$sub_level_2_gradient_opacity_4_down = 100;
		unset($gradient_opacity_arr);
	}
	else {
		$sub_level_2_gradient_opacity_1_down = 100;
		$sub_level_2_gradient_opacity_2_down = 100;
		$sub_level_2_gradient_opacity_3_down = 100;
		$sub_level_2_gradient_opacity_4_down = 100;
	}
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_a_down" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["underline"]))
		$sub_level_2_underline_down = $row["underline"];
	else
		$sub_level_2_underline_down = 0;
	if (!is_null($row["overline"]))
		$sub_level_2_overline_down = $row["overline"];
	else
		$sub_level_2_overline_down = 0;
	if (!is_null($row["blink"]))
		$sub_level_2_blink_down = $row["blink"];
	else
		$sub_level_2_blink_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color_down_hover = $row["text_color"];
	elseif ($load_defaults == 1)
		$top_level_text_color_down_hover = "#FFFFFF";
	else
		$top_level_text_color_down_hover = _NOT_SET_;
		
	if (($top_level_text_color_hover == $top_level_text_color_down_hover) || ($load_defaults == 1))
		$top_level_txt_color_hover_on_down = 1;
	else
		$top_level_txt_color_hover_on_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_down_hover = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_1_text_color_down_hover = "#FFFFFF";
	else
		$sub_level_1_text_color_down_hover = _NOT_SET_;
		
	if (($sub_level_1_text_color_hover == $sub_level_1_text_color_down_hover) || ($load_defaults == 1))
		$sub_level_1_txt_color_hover_on_down = 1;
	else
		$sub_level_1_txt_color_hover_on_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li_down" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color_down_hover = $row["text_color"];
	elseif ($load_defaults == 1)
		$sub_level_2_text_color_down_hover = "#FFFFFF";
	else
		$sub_level_2_text_color_down_hover = _NOT_SET_;
		
	if (($sub_level_2_text_color_hover == $sub_level_2_text_color_down_hover) || ($load_defaults == 1))
		$sub_level_2_txt_color_hover_on_down = 1;
	else
		$sub_level_2_txt_color_hover_on_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.top_level_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_down_hover = $row["bkgd_color"];
	else
		$top_level_background_color_down_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_down_hover = $row["border_color"];
	else
		$top_level_item_border_color_down_hover = _NOT_SET_;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$top_level_gradient_colors_down_hover = $row["gradient_colors"];
	else
		$top_level_gradient_colors_down_hover = _NOT_SET_;
		
	if (($top_level_background_color_hover == $top_level_background_color_down_hover) || ($load_defaults == 1))
		$top_level_bkgd_color_hover_on_down = 1;
	else
		$top_level_bkgd_color_hover_on_down = 0;

	if (($top_level_item_border_color_hover == $top_level_item_border_color_down_hover) || ($load_defaults == 1))
		$top_level_border_hover_on_down = 1;
	else
		$top_level_border_hover_on_down = 0;
		
	if (($top_level_gradient_colors_hover == $top_level_gradient_colors_down_hover) || ($load_defaults == 1))
		$top_level_bkgd_gradient_hover_on_down = 1;
	else
		$top_level_bkgd_gradient_hover_on_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_1_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_1_background_color_down_hover = $row["bkgd_color"];
	else
		$sub_level_1_background_color_down_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_1_item_border_color_down_hover = $row["border_color"];
	else
		$sub_level_1_item_border_color_down_hover = _NOT_SET_;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_1_gradient_colors_down_hover = $row["gradient_colors"];
	else
		$sub_level_1_gradient_colors_down_hover = _NOT_SET_;
		
	if (($sub_level_1_background_color_hover == $sub_level_1_background_color_down_hover) || ($load_defaults == 1))
		$sub_level_1_bkgd_color_hover_on_down = 1;
	else
		$sub_level_1_bkgd_color_hover_on_down = 0;

	if (($sub_level_1_item_border_color_hover == $sub_level_1_item_border_color_down_hover) || ($load_defaults == 1))
		$sub_level_1_border_hover_on_down = 1;
	else
		$sub_level_1_border_hover_on_down = 0;
		
	if (($sub_level_1_gradient_colors_hover == $sub_level_1_gradient_colors_down_hover) || ($load_defaults == 1))
		$sub_level_1_bkgd_gradient_hover_on_down = 1;
	else
		$sub_level_1_bkgd_gradient_hover_on_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.sub_level_2_li_down" . $suffix . ":hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_2_background_color_down_hover = $row["bkgd_color"];
	else
		$sub_level_2_background_color_down_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_2_item_border_color_down_hover = $row["border_color"];
	else
		$sub_level_2_item_border_color_down_hover = _NOT_SET_;
	if (!is_null($row["gradient_colors"]) && ($row["gradient_colors"] != ""))
		$sub_level_2_gradient_colors_down_hover = $row["gradient_colors"];
	else
		$sub_level_2_gradient_colors_down_hover = _NOT_SET_;
		
	if (($sub_level_2_background_color_hover == $sub_level_2_background_color_down_hover) || ($load_defaults == 1))
		$sub_level_2_bkgd_color_hover_on_down = 1;
	else
		$sub_level_2_bkgd_color_hover_on_down = 0;

	if (($sub_level_2_item_border_color_hover == $sub_level_2_item_border_color_down_hover) || ($load_defaults == 1))
		$sub_level_2_border_hover_on_down = 1;
	else
		$sub_level_2_border_hover_on_down = 0;
		
	if (($sub_level_2_gradient_colors_hover == $sub_level_2_gradient_colors_down_hover) || ($load_defaults == 1))
		$sub_level_2_bkgd_gradient_hover_on_down = 1;
	else
		$sub_level_2_bkgd_gradient_hover_on_down = 0;
		
	/////////////////////////////////////////////////////////////////////////////////////////
	// Get omit adjacent border selection.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.menu_div" . $suffix . " .top_level_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (($row["use_table_data"] == 1) && ($row["border_style"] != "-not selected-") && ($row["border_style"] != ""))	{
		$top_level_item_omit_adjacent_border = 1;
		$top_level_item_border_top = 1;
		$top_level_item_border_bottom = 1;
		$top_level_item_border_left = 1;
		$top_level_item_border_right = 1;
	}
	else
		$top_level_item_omit_adjacent_border = 0;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.menu_div" . $suffix . " .sub_level_1_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (($row["use_table_data"] == 1) && ($row["border_style"] != "-not selected-") && ($row["border_style"] != ""))	{
		$sub_level_1_item_omit_adjacent_border = 1;
		$sub_level_1_item_border_top = 1;
		$sub_level_1_item_border_bottom = 1;
		$sub_level_1_item_border_left = 1;
		$sub_level_1_item_border_right = 1;
	}
	else
		$sub_level_1_item_omit_adjacent_border = 0;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '" . $menu . "' AND class = '.menu_div" . $suffix . " .sub_level_2_ul" . $suffix . " > li:last-child'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (($row["use_table_data"] == 1) && ($row["border_style"] != "-not selected-") && ($row["border_style"] != ""))	{
		$sub_level_2_item_omit_adjacent_border = 1;
		$sub_level_2_item_border_top = 1;
		$sub_level_2_item_border_bottom = 1;
		$sub_level_2_item_border_left = 1;
		$sub_level_2_item_border_right = 1;
	}
	else
		$sub_level_2_item_omit_adjacent_border = 0;
?>

<form name="frm_menu_styles" id="frm_menu_styles" action="save_css_menu_styles.php" method="post">
<table width="90%" class="group_box_table">
  <tr>
    <td bgcolor="#aaffff">
      <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_FONT; ?></td>
          <td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td>
          </tr>
        <tr>
          <td colspan="2">
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo FONT_WORD; ?>:</td>
                <td>
                  <select name="top_level_font" id="top_level_font">
					<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $top_level_font)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
                    <br>
                    <select name="top_level_font_2" id="top_level_font_2">
                    	<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $top_level_font_2)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                    <br>
                    <select name="top_level_font_3" id="top_level_font_3">
                    	<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $top_level_font_3)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                  </td>
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="top_level_font_size" type="text" id="top_level_font_size" size="10" value="<?php echo $top_level_font_size; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="top_level_font_size_units" id="top_level_font_size_units" onChange="enable_disable_font_size('top_level_font_size', 'top_level_font_size_units');">
                    <option value="px"<?php if ($top_level_font_size_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($top_level_font_size_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($top_level_font_size_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($top_level_font_size_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($top_level_font_size_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($top_level_font_size_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($top_level_font_size_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($top_level_font_size_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($top_level_font_size_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($top_level_font_size_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($top_level_font_size_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($top_level_font_size_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($top_level_font_size_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($top_level_font_size_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($top_level_font_size_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($top_level_font_size_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($top_level_font_size_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($top_level_font_size_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($top_level_font_size_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($top_level_font_size_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($top_level_font_size_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($top_level_font_size_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($top_level_font_size_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($top_level_font_size_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($top_level_font_size_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="top_level_weight" id="top_level_weight">
                    <option value="-not selected-" <?php if ($top_level_weight == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($top_level_weight == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($top_level_weight == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($top_level_weight == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($top_level_weight == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($top_level_weight == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($top_level_weight == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($top_level_weight == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($top_level_weight == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($top_level_weight == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($top_level_weight == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($top_level_weight == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($top_level_weight == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($top_level_weight == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="top_level_letter_spacing" type="text" id="top_level_letter_spacing" value="<?php if ($top_level_letter_spacing_units < 3) echo intval($top_level_letter_spacing); else echo $top_level_letter_spacing; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="top_level_letter_spacing_units" id="top_level_letter_spacing_units" onChange="CheckLetterSpacing(this, 'top_level_letter_spacing');">
                    <option value="-1"<?php if ($top_level_letter_spacing_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($top_level_letter_spacing_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($top_level_letter_spacing_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($top_level_letter_spacing_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($top_level_letter_spacing_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($top_level_letter_spacing_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($top_level_letter_spacing_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($top_level_letter_spacing_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($top_level_letter_spacing_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($top_level_letter_spacing_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($top_level_letter_spacing_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($top_level_letter_spacing_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($top_level_letter_spacing_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($top_level_letter_spacing_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($top_level_letter_spacing_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($top_level_letter_spacing_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($top_level_letter_spacing_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($top_level_letter_spacing_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td colspan="2">
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="top_level_italic" type="checkbox" id="top_level_italic" value="1" <?php if ($top_level_italic == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_underline" type="checkbox" id="top_level_underline" value="1" <?php if ($top_level_underline == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_overline" type="checkbox" id="top_level_overline" value="1" <?php if ($top_level_overline == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="top_level_blink" type="checkbox" id="top_level_blink" value="1" <?php if ($top_level_blink == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="top_level_oblique" type="checkbox" id="top_level_oblique" value="1" <?php if ($top_level_oblique == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="top_level_small_caps" type="checkbox" id="top_level_small_caps" value="1" <?php if ($top_level_small_caps == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" colspan="2"><table class="layout_box_table" width="100%">
            <tr>
              <td align="center"><?php echo SHADOW_WORD; ?>:
                <input name="top_level_shadow" type="checkbox" id="top_level_shadow" value="1" <?php if ($top_level_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level');" /></td>
                <td align="center">
                <input name="top_level_shadow_hover" type="checkbox" id="top_level_shadow_hover" value="1" <?php if ($top_level_shadow_hover == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level');" /></td>
                <td align="center">
                <input name="top_level_shadow_down" type="checkbox" id="top_level_shadow_down" value="1" <?php if ($top_level_shadow_down == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level');" /></td>
              <td align="center"><?php echo COLOR_WORD; ?>:
                <input name="top_level_shadow_color" type="text" id="top_level_shadow_color" value="<?php echo $top_level_shadow_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color');" class="small_message fake_link"><?php echo RGB_WORD; ?></span></td>
              <td align="center"><?php echo X_OFFSET_WORD; ?>:
                <input name="top_level_shadow_x_offset" type="text" id="top_level_shadow_x_offset" value="<?php echo $top_level_shadow_x_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                px </td>
              <td align="center"><?php echo Y_OFFSET_WORD; ?>:
                <input name="top_level_shadow_y_offset" type="text" id="top_level_shadow_y_offset" value="<?php echo $top_level_shadow_y_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                px </td>
              <td align="center"><?php echo BLUR_WORD; ?>:
                <input name="top_level_shadow_blur" type="text" id="top_level_shadow_blur" value="<?php echo $top_level_shadow_blur; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                px </td>
            </tr>
            <tr>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo NORMAL_WORD; ?></td>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo HOVER_WORD; ?></td>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo DOWN_WORD; ?></td>
                <td colspan="4">&nbsp;</td>
            </tr>
          </table></td>
        </tr>
        </table>
        
        <hr>
        <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold" style="text-align:center;"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="top_level_font_size_hover" type="text" id="top_level_font_size_hover" size="10" value="<?php echo $top_level_font_size_hover; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="top_level_font_size_hover_units" id="top_level_font_size_hover_units" onChange="enable_disable_font_size('top_level_font_size_hover', 'top_level_font_size_hover_units');">
                    <option value="px"<?php if ($top_level_font_size_hover_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($top_level_font_size_hover_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($top_level_font_size_hover_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($top_level_font_size_hover_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($top_level_font_size_hover_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($top_level_font_size_hover_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($top_level_font_size_hover_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($top_level_font_size_hover_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($top_level_font_size_hover_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($top_level_font_size_hover_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($top_level_font_size_hover_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($top_level_font_size_hover_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($top_level_font_size_hover_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($top_level_font_size_hover_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($top_level_font_size_hover_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($top_level_font_size_hover_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($top_level_font_size_hover_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($top_level_font_size_hover_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($top_level_font_size_hover_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($top_level_font_size_hover_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($top_level_font_size_hover_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($top_level_font_size_hover_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($top_level_font_size_hover_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($top_level_font_size_hover_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($top_level_font_size_hover_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="top_level_weight_hover" id="top_level_weight_hover">
                    <option value="-not selected-" <?php if ($top_level_weight_hover == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($top_level_weight_hover == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($top_level_weight_hover == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($top_level_weight_hover == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($top_level_weight_hover == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($top_level_weight_hover == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($top_level_weight_hover == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($top_level_weight_hover == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($top_level_weight_hover == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($top_level_weight_hover == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($top_level_weight_hover == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($top_level_weight_hover == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($top_level_weight_hover == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($top_level_weight_hover == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="top_level_letter_spacing_hover" type="text" id="top_level_letter_spacing_hover" value="<?php if ($top_level_letter_spacing_hover_units < 3) echo intval($top_level_letter_spacing_hover); else echo $top_level_letter_spacing_hover; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="top_level_letter_spacing_hover_units" id="top_level_letter_spacing_hover_units" onChange="CheckLetterSpacing(this, 'top_level_letter_spacing_hover');">
                    <option value="-1"<?php if ($top_level_letter_spacing_hover_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($top_level_letter_spacing_hover_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($top_level_letter_spacing_hover_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($top_level_letter_spacing_hover_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($top_level_letter_spacing_hover_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($top_level_letter_spacing_hover_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($top_level_letter_spacing_hover_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($top_level_letter_spacing_hover_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($top_level_letter_spacing_hover_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($top_level_letter_spacing_hover_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($top_level_letter_spacing_hover_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($top_level_letter_spacing_hover_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($top_level_letter_spacing_hover_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($top_level_letter_spacing_hover_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($top_level_letter_spacing_hover_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($top_level_letter_spacing_hover_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($top_level_letter_spacing_hover_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($top_level_letter_spacing_hover_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="top_level_italic_hover" type="checkbox" id="top_level_italic_hover" value="1" <?php if ($top_level_italic_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_underline_hover" type="checkbox" id="top_level_underline_hover" value="1" <?php if ($top_level_underline_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_overline_hover" type="checkbox" id="top_level_overline_hover" value="1" <?php if ($top_level_overline_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="top_level_blink_hover" type="checkbox" id="top_level_blink_hover" value="1" <?php if ($top_level_blink_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="top_level_oblique_hover" type="checkbox" id="top_level_oblique_hover" value="1" <?php if ($top_level_oblique_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="top_level_small_caps_hover" type="checkbox" id="top_level_small_caps_hover" value="1" <?php if ($top_level_small_caps_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><table class="layout_box_table" width="100%">
            <tr>
              <td align="center"><?php echo EDIT_CSS_MENU_STYLES_SHADOW_COLOR; ?>: </td>
              <td align="center">
			  	<?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?>:
                <input name="top_level_shadow_color_hover" type="text" id="top_level_shadow_color_hover" value="<?php echo $top_level_shadow_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_hover');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
                </td>
              <td align="center">
              	<?php echo EDIT_CSS_MENU_STYLES_DOWN; ?>:
                <input name="top_level_shadow_color_down" type="text" id="top_level_shadow_color_down" value="<?php echo $top_level_shadow_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_down');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
                </td>
              <td align="center">
              	<?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?>:
                <input name="top_level_shadow_color_active" type="text" id="top_level_shadow_color_active" value="<?php echo $top_level_shadow_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_active');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
               </td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>
        
        <hr>
        <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold" style="text-align:center;"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="top_level_font_size_down" type="text" id="top_level_font_size_down" size="10" value="<?php echo $top_level_font_size_down; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="top_level_font_size_down_units" id="top_level_font_size_down_units" onChange="enable_disable_font_size('top_level_font_size_down', 'top_level_font_size_down_units');">
                    <option value="px"<?php if ($top_level_font_size_down_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($top_level_font_size_down_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($top_level_font_size_down_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($top_level_font_size_down_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($top_level_font_size_down_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($top_level_font_size_down_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($top_level_font_size_down_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($top_level_font_size_down_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($top_level_font_size_down_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($top_level_font_size_down_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($top_level_font_size_down_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($top_level_font_size_down_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($top_level_font_size_down_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($top_level_font_size_down_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($top_level_font_size_down_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($top_level_font_size_down_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($top_level_font_size_down_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($top_level_font_size_down_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($top_level_font_size_down_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($top_level_font_size_down_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($top_level_font_size_down_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($top_level_font_size_down_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($top_level_font_size_down_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($top_level_font_size_down_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($top_level_font_size_down_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="top_level_weight_down" id="top_level_weight_down">
                    <option value="-not selected-" <?php if ($top_level_weight_down == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($top_level_weight_down == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($top_level_weight_down == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($top_level_weight_down == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($top_level_weight_down == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($top_level_weight_down == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($top_level_weight_down == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($top_level_weight_down == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($top_level_weight_down == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($top_level_weight_down == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($top_level_weight_down == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($top_level_weight_down == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($top_level_weight_down == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($top_level_weight_down == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="top_level_letter_spacing_down" type="text" id="top_level_letter_spacing_down" value="<?php if ($top_level_letter_spacing_down_units < 3) echo intval($top_level_letter_spacing_down); else echo $top_level_letter_spacing_down; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="top_level_letter_spacing_down_units" id="top_level_letter_spacing_down_units" onChange="CheckLetterSpacing(this, 'top_level_letter_spacing_down');">
                    <option value="-1"<?php if ($top_level_letter_spacing_down_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($top_level_letter_spacing_down_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($top_level_letter_spacing_down_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($top_level_letter_spacing_down_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($top_level_letter_spacing_down_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($top_level_letter_spacing_down_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($top_level_letter_spacing_down_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($top_level_letter_spacing_down_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($top_level_letter_spacing_down_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($top_level_letter_spacing_down_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($top_level_letter_spacing_down_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($top_level_letter_spacing_down_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($top_level_letter_spacing_down_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($top_level_letter_spacing_down_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($top_level_letter_spacing_down_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($top_level_letter_spacing_down_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($top_level_letter_spacing_down_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($top_level_letter_spacing_down_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="top_level_italic_down" type="checkbox" id="top_level_italic_down" value="1" <?php if ($top_level_italic_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_underline_down" type="checkbox" id="top_level_underline_down" value="1" <?php if ($top_level_underline_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_overline_down" type="checkbox" id="top_level_overline_down" value="1" <?php if ($top_level_overline_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="top_level_blink_down" type="checkbox" id="top_level_blink_down" value="1" <?php if ($top_level_blink_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="top_level_oblique_down" type="checkbox" id="top_level_oblique_down" value="1" <?php if ($top_level_oblique_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="top_level_small_caps_down" type="checkbox" id="top_level_small_caps_down" value="1" <?php if ($top_level_small_caps_down == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>

      </td>
  </tr>
  
  
  <tr>
    <td bgcolor="#ffffaa">
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_FONT; ?></td>
             <td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td>
		  </tr>
		  <tr>
		    <td colspan="2">
            <table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo FONT_WORD; ?>:</td>
		        <td>
                <select name="sub_level_1_font" id="sub_level_1_font">
                	<option value='-not selected-' class='not_set'>-not selected-</option>
		          <?php
						foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $sub_level_1_font)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
				?>
		          </select>
                  <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
                  <br>
                    <select name="sub_level_1_font_2" id="sub_level_1_font_2">
                    	<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $sub_level_1_font_2)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                    <br>
                    <select name="sub_level_1_font_3" id="sub_level_1_font_3">
                    	<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $sub_level_1_font_3)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                </td>
		        <td align="right"><?php echo SIZE_WORD; ?>: </td>
		        <td>
                <input name="sub_level_1_font_size" type="text" id="sub_level_1_font_size" size="10" value="<?php echo $sub_level_1_font_size; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          <select name="sub_level_1_font_size_units" id="sub_level_1_font_size_units" onChange="enable_disable_font_size('sub_level_1_font_size', 'sub_level_1_font_size_units');">
                    <option value="px"<?php if ($sub_level_1_font_size_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_1_font_size_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_1_font_size_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_1_font_size_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_1_font_size_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_1_font_size_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_1_font_size_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_1_font_size_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_1_font_size_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_1_font_size_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_1_font_size_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_1_font_size_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_1_font_size_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_1_font_size_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_1_font_size_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_1_font_size_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_1_font_size_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_1_font_size_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_1_font_size_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_1_font_size_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_1_font_size_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_1_font_size_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_1_font_size_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_1_font_size_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_1_font_size_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
		        <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
		        <td><select name="sub_level_1_weight" id="sub_level_1_weight">
		          <option value="-not selected-" <?php if ($sub_level_1_weight == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
		          <option value="normal" <?php if ($sub_level_1_weight == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
		          <option value="bold" <?php if ($sub_level_1_weight == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
		          <option value="bolder" <?php if ($sub_level_1_weight == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
		          <option value="lighter" <?php if ($sub_level_1_weight == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
		          <option value="100" <?php if ($sub_level_1_weight == "100") echo " selected='selected'"; ?>>100</option>
		          <option value="200" <?php if ($sub_level_1_weight == "200") echo " selected='selected'"; ?>>200</option>
		          <option value="300" <?php if ($sub_level_1_weight == "300") echo " selected='selected'"; ?>>300</option>
		          <option value="400" <?php if ($sub_level_1_weight == "400") echo " selected='selected'"; ?>>400</option>
		          <option value="500" <?php if ($sub_level_1_weight == "500") echo " selected='selected'"; ?>>500</option>
		          <option value="600" <?php if ($sub_level_1_weight == "600") echo " selected='selected'"; ?>>600</option>
		          <option value="700" <?php if ($sub_level_1_weight == "700") echo " selected='selected'"; ?>>700</option>
		          <option value="800" <?php if ($sub_level_1_weight == "800") echo " selected='selected'"; ?>>800</option>
		          <option value="900" <?php if ($sub_level_1_weight == "900") echo " selected='selected'"; ?>>900</option>
		          </select></td>
		        <td align="right"><?php echo LETTER_SPACING; ?>:</td>
		        <td> 
                  <input name="sub_level_1_letter_spacing" type="text" id="sub_level_1_letter_spacing" value="<?php if ($sub_level_1_letter_spacing_units < 3) echo intval($sub_level_1_letter_spacing); else echo $sub_level_1_letter_spacing; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_1_letter_spacing_units" id="sub_level_1_letter_spacing_units" onChange="CheckLetterSpacing(this, 'sub_level_1_letter_spacing');">
                    <option value="-1"<?php if ($sub_level_1_letter_spacing_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_1_letter_spacing_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_1_letter_spacing_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_1_letter_spacing_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_1_letter_spacing_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_1_letter_spacing_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_1_letter_spacing_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_1_letter_spacing_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_1_letter_spacing_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_1_letter_spacing_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_1_letter_spacing_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_1_letter_spacing_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_1_letter_spacing_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_1_letter_spacing_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_1_letter_spacing_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_1_letter_spacing_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_1_letter_spacing_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_1_letter_spacing_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td colspan="2">
            <table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo ITALIC_WORD; ?>:</td>
		        <td><input name="sub_level_1_italic" type="checkbox" id="sub_level_1_italic" value="1" <?php if ($sub_level_1_italic == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_1_underline" type="checkbox" id="sub_level_1_underline" value="1" <?php if ($sub_level_1_underline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_1_overline" type="checkbox" id="sub_level_1_overline" value="1" <?php if ($sub_level_1_overline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo BLINK_WORD; ?>:</td>
		        <td><input name="sub_level_1_blink" type="checkbox" id="sub_level_1_blink" value="1" <?php if ($sub_level_1_blink == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
		        <td><input name="sub_level_1_oblique" type="checkbox" id="sub_level_1_oblique" value="1" <?php if ($sub_level_1_oblique == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo SMALL_CAPS; ?>:</td>
		        <td><input name="sub_level_1_small_caps" type="checkbox" id="sub_level_1_small_caps" value="1" <?php if ($sub_level_1_small_caps == 1) echo "checked='checked'"; ?>></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message" colspan="2">
            <table class="layout_box_table" width="100%">
		      <tr>
		        <td align="center"><?php echo SHADOW_WORD; ?>:
		          <input name="sub_level_1_shadow" type="checkbox" id="sub_level_1_shadow" value="1" <?php if ($sub_level_1_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1');"></td>
                  <td align="center">
                <input name="sub_level_1_shadow_hover" type="checkbox" id="sub_level_1_shadow_hover" value="1" <?php if ($sub_level_1_shadow_hover == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1');" /></td>
                <td align="center">
                <input name="sub_level_1_shadow_down" type="checkbox" id="sub_level_1_shadow_down" value="1" <?php if ($sub_level_1_shadow_down == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1');" /></td>
		        <td align="center"><?php echo COLOR_WORD; ?>:
		          <input name="sub_level_1_shadow_color" type="text" id="sub_level_1_shadow_color" value="<?php echo $sub_level_1_shadow_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
<span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color');" class="small_message fake_link"><?php echo RGB_WORD; ?></span></td>
		        <td align="center"><?php echo X_OFFSET_WORD; ?>:
		          <input name="sub_level_1_shadow_x_offset" type="text" id="sub_level_1_shadow_x_offset" value="<?php echo $sub_level_1_shadow_x_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo Y_OFFSET_WORD; ?>:
		          <input name="sub_level_1_shadow_y_offset" type="text" id="sub_level_1_shadow_y_offset" value="<?php echo $sub_level_1_shadow_y_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo BLUR_WORD; ?>:
		          <input name="sub_level_1_shadow_blur" type="text" id="sub_level_1_shadow_blur" value="<?php echo $sub_level_1_shadow_blur; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        </tr>
                <tr>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo NORMAL_WORD; ?></td>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo HOVER_WORD; ?></td>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo DOWN_WORD; ?></td>
                <td colspan="4">&nbsp;</td>
            </tr>
		      </table></td>
		    </tr>
	   </table>
       
       <hr>
        <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold" style="text-align:center;"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="sub_level_1_font_size_hover" type="text" id="sub_level_1_font_size_hover" size="10" value="<?php echo $sub_level_1_font_size_hover; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="sub_level_1_font_size_hover_units" id="sub_level_1_font_size_hover_units" onChange="enable_disable_font_size('sub_level_1_font_size_hover', 'sub_level_1_font_size_hover_units');">
                    <option value="px"<?php if ($sub_level_1_font_size_hover_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_1_font_size_hover_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_1_font_size_hover_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_1_font_size_hover_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_1_font_size_hover_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_1_font_size_hover_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_1_font_size_hover_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_1_font_size_hover_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_1_font_size_hover_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_1_font_size_hover_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_1_font_size_hover_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_1_font_size_hover_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_1_font_size_hover_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_1_font_size_hover_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_1_font_size_hover_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_1_font_size_hover_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_1_font_size_hover_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_1_font_size_hover_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_1_font_size_hover_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_1_font_size_hover_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_1_font_size_hover_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_1_font_size_hover_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_1_font_size_hover_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_1_font_size_hover_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_1_font_size_hover_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="sub_level_1_weight_hover" id="sub_level_1_weight_hover">
                    <option value="-not selected-" <?php if ($sub_level_1_weight_hover == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($sub_level_1_weight_hover == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($sub_level_1_weight_hover == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($sub_level_1_weight_hover == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($sub_level_1_weight_hover == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($sub_level_1_weight_hover == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($sub_level_1_weight_hover == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($sub_level_1_weight_hover == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($sub_level_1_weight_hover == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($sub_level_1_weight_hover == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($sub_level_1_weight_hover == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($sub_level_1_weight_hover == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($sub_level_1_weight_hover == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($sub_level_1_weight_hover == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="sub_level_1_letter_spacing_hover" type="text" id="sub_level_1_letter_spacing_hover" value="<?php if ($sub_level_1_letter_spacing_hover_units < 3) echo intval($sub_level_1_letter_spacing_hover); else echo $sub_level_1_letter_spacing_hover; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_1_letter_spacing_hover_units" id="sub_level_1_letter_spacing_hover_units" onChange="CheckLetterSpacing(this, 'sub_level_1_letter_spacing_hover');">
                    <option value="-1"<?php if ($sub_level_1_letter_spacing_hover_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_1_letter_spacing_hover_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_1_letter_spacing_hover_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_1_letter_spacing_hover_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_1_letter_spacing_hover_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_1_letter_spacing_hover_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_1_letter_spacing_hover_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_1_letter_spacing_hover_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_1_letter_spacing_hover_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_1_letter_spacing_hover_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_1_letter_spacing_hover_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_1_letter_spacing_hover_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_1_letter_spacing_hover_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_1_letter_spacing_hover_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_1_letter_spacing_hover_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_1_letter_spacing_hover_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_1_letter_spacing_hover_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_1_letter_spacing_hover_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_italic_hover" type="checkbox" id="sub_level_1_italic_hover" value="1" <?php if ($sub_level_1_italic_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_underline_hover" type="checkbox" id="sub_level_1_underline_hover" value="1" <?php if ($sub_level_1_underline_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_overline_hover" type="checkbox" id="sub_level_1_overline_hover" value="1" <?php if ($sub_level_1_overline_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_blink_hover" type="checkbox" id="sub_level_1_blink_hover" value="1" <?php if ($sub_level_1_blink_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_oblique_hover" type="checkbox" id="sub_level_1_oblique_hover" value="1" <?php if ($sub_level_1_oblique_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="sub_level_1_small_caps_hover" type="checkbox" id="sub_level_1_small_caps_hover" value="1" <?php if ($sub_level_1_small_caps_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><table class="layout_box_table" width="100%">
            <tr>
              <td align="center"><?php echo EDIT_CSS_MENU_STYLES_SHADOW_COLOR; ?>: </td>
              <td align="center">
			  	<?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?>:
                <input name="sub_level_1_shadow_color_hover" type="text" id="sub_level_1_shadow_color_hover" value="<?php echo $sub_level_1_shadow_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_hover');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
                </td>
              <td align="center">
              	<?php echo EDIT_CSS_MENU_STYLES_DOWN; ?>:
                <input name="sub_level_1_shadow_color_down" type="text" id="sub_level_1_shadow_color_down" value="<?php echo $sub_level_1_shadow_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_down');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
                </td>
              <td align="center">
              	<?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?>:
                <input name="sub_level_1_shadow_color_active" type="text" id="sub_level_1_shadow_color_active" value="<?php echo $sub_level_1_shadow_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_active');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
               </td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>
        
        <hr>
        <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold" style="text-align:center;"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="sub_level_1_font_size_down" type="text" id="sub_level_1_font_size_down" size="10" value="<?php echo $sub_level_1_font_size_down; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="sub_level_1_font_size_down_units" id="sub_level_1_font_size_down_units" onChange="enable_disable_font_size('sub_level_1_font_size_down', 'sub_level_1_font_size_down_units');">
                    <option value="px"<?php if ($sub_level_1_font_size_down_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_1_font_size_down_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_1_font_size_down_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_1_font_size_down_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_1_font_size_down_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_1_font_size_down_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_1_font_size_down_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_1_font_size_down_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_1_font_size_down_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_1_font_size_down_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_1_font_size_down_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_1_font_size_down_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_1_font_size_down_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_1_font_size_down_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_1_font_size_down_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_1_font_size_down_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_1_font_size_down_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_1_font_size_down_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_1_font_size_down_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_1_font_size_down_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_1_font_size_down_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_1_font_size_down_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_1_font_size_down_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_1_font_size_down_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_1_font_size_down_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="sub_level_1_weight_down" id="sub_level_1_weight_down">
                    <option value="-not selected-" <?php if ($sub_level_1_weight_down == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($sub_level_1_weight_down == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($sub_level_1_weight_down == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($sub_level_1_weight_down == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($sub_level_1_weight_down == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($sub_level_1_weight_down == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($sub_level_1_weight_down == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($sub_level_1_weight_down == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($sub_level_1_weight_down == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($sub_level_1_weight_down == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($sub_level_1_weight_down == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($sub_level_1_weight_down == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($sub_level_1_weight_down == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($sub_level_1_weight_down == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="sub_level_1_letter_spacing_down" type="text" id="sub_level_1_letter_spacing_down" value="<?php if ($sub_level_1_letter_spacing_down_units < 3) echo intval($sub_level_1_letter_spacing_down); else echo $sub_level_1_letter_spacing_down; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_1_letter_spacing_down_units" id="sub_level_1_letter_spacing_down_units" onChange="CheckLetterSpacing(this, 'sub_level_1_letter_spacing_down');">
                    <option value="-1"<?php if ($sub_level_1_letter_spacing_down_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_1_letter_spacing_down_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_1_letter_spacing_down_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_1_letter_spacing_down_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_1_letter_spacing_down_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_1_letter_spacing_down_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_1_letter_spacing_down_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_1_letter_spacing_down_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_1_letter_spacing_down_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_1_letter_spacing_down_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_1_letter_spacing_down_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_1_letter_spacing_down_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_1_letter_spacing_down_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_1_letter_spacing_down_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_1_letter_spacing_down_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_1_letter_spacing_down_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_1_letter_spacing_down_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_1_letter_spacing_down_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_italic_down" type="checkbox" id="sub_level_1_italic_down" value="1" <?php if ($sub_level_1_italic_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_underline_down" type="checkbox" id="sub_level_1_underline_down" value="1" <?php if ($sub_level_1_underline_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_overline_down" type="checkbox" id="sub_level_1_overline_down" value="1" <?php if ($sub_level_1_overline_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_blink_down" type="checkbox" id="sub_level_1_blink_down" value="1" <?php if ($sub_level_1_blink_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_1_oblique_down" type="checkbox" id="sub_level_1_oblique_down" value="1" <?php if ($sub_level_1_oblique_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="sub_level_1_small_caps_down" type="checkbox" id="sub_level_1_small_caps_down" value="1" <?php if ($sub_level_1_small_caps_down == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>
        
	</td>
  </tr>
  
  <tr>
    <td bgcolor="#ffaaff">
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_FONT; ?></td>
             <td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td>
		  </tr>
		  <tr>
		    <td colspan="2">
            <table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo FONT_WORD; ?>:</td>
		        <td>
                  <select name="sub_level_2_font" id="sub_level_2_font">
                  	<option value='-not selected-' class='not_set'>-not selected-</option>
		          <?php
						foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $sub_level_2_font)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
				?>
		          </select>
                  <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
                  <br>
                    <select name="sub_level_2_font_2" id="sub_level_2_font_2">
                    	<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $sub_level_2_font_2)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                    <br>
                    <select name="sub_level_2_font_3" id="sub_level_2_font_3">
                    	<option value='-not selected-' class='not_set'>-not selected-</option>
                    <?php
					 	foreach ($fonts as $font)
						{
							echo "<option value='" . $font['font'] . "' style='font-family:" . $font['font'] . ";'";
							if ($font['font'] == $sub_level_2_font_3)
								echo " selected='selected'";
							echo ">" . $font['font'];
							if ($font['websafe'] == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                </td>
		        <td align="right"><?php echo SIZE_WORD; ?>: </td>
		        <td>
                <input name="sub_level_2_font_size" type="text" id="sub_level_2_font_size" size="10" value="<?php echo $sub_level_2_font_size; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          <select name="sub_level_2_font_size_units" id="sub_level_2_font_size_units" onChange="enable_disable_font_size('sub_level_2_font_size', 'sub_level_2_font_size_units');">
                    <option value="px"<?php if ($sub_level_2_font_size_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_2_font_size_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_2_font_size_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_2_font_size_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_2_font_size_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_2_font_size_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_2_font_size_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_2_font_size_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_2_font_size_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_2_font_size_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_2_font_size_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_2_font_size_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_2_font_size_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_2_font_size_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_2_font_size_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_2_font_size_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_2_font_size_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_2_font_size_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_2_font_size_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_2_font_size_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_2_font_size_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_2_font_size_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_2_font_size_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_2_font_size_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_2_font_size_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
		        <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
		        <td><select name="sub_level_2_weight" id="sub_level_2_weight">
		          <option value="-not selected-" <?php if ($sub_level_2_weight == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
		          <option value="normal" <?php if ($sub_level_2_weight == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
		          <option value="bold" <?php if ($sub_level_2_weight == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
		          <option value="bolder" <?php if ($sub_level_2_weight == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
		          <option value="lighter" <?php if ($sub_level_2_weight == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
		          <option value="100" <?php if ($sub_level_2_weight == "100") echo " selected='selected'"; ?>>100</option>
		          <option value="200" <?php if ($sub_level_2_weight == "200") echo " selected='selected'"; ?>>200</option>
		          <option value="300" <?php if ($sub_level_2_weight == "300") echo " selected='selected'"; ?>>300</option>
		          <option value="400" <?php if ($sub_level_2_weight == "400") echo " selected='selected'"; ?>>400</option>
		          <option value="500" <?php if ($sub_level_2_weight == "500") echo " selected='selected'"; ?>>500</option>
		          <option value="600" <?php if ($sub_level_2_weight == "600") echo " selected='selected'"; ?>>600</option>
		          <option value="700" <?php if ($sub_level_2_weight == "700") echo " selected='selected'"; ?>>700</option>
		          <option value="800" <?php if ($sub_level_2_weight == "800") echo " selected='selected'"; ?>>800</option>
		          <option value="900" <?php if ($sub_level_2_weight == "900") echo " selected='selected'"; ?>>900</option>
		          </select></td>
		        <td align="right"><?php echo LETTER_SPACING; ?>:</td>
		        <td>             
                  <input name="sub_level_2_letter_spacing" type="text" id="sub_level_2_letter_spacing" value="<?php if ($sub_level_2_letter_spacing_units < 3) echo intval($sub_level_2_letter_spacing); else echo $sub_level_2_letter_spacing; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_2_letter_spacing_units" id="sub_level_2_letter_spacing_units" onChange="CheckLetterSpacing(this, 'sub_level_2_letter_spacing');">
                    <option value="-1"<?php if ($sub_level_2_letter_spacing_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_2_letter_spacing_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_2_letter_spacing_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_2_letter_spacing_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_2_letter_spacing_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_2_letter_spacing_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_2_letter_spacing_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_2_letter_spacing_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_2_letter_spacing_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_2_letter_spacing_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_2_letter_spacing_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_2_letter_spacing_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_2_letter_spacing_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_2_letter_spacing_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_2_letter_spacing_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_2_letter_spacing_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_2_letter_spacing_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_2_letter_spacing_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
		          </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td colspan="2">
            <table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo ITALIC_WORD; ?>:</td>
		        <td><input name="sub_level_2_italic" type="checkbox" id="sub_level_2_italic" value="1" <?php if ($sub_level_2_italic == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_2_underline" type="checkbox" id="sub_level_2_underline" value="1" <?php if ($sub_level_2_underline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_2_overline" type="checkbox" id="sub_level_2_overline" value="1" <?php if ($sub_level_2_overline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo BLINK_WORD; ?>:</td>
		        <td><input name="sub_level_2_blink" type="checkbox" id="sub_level_2_blink" value="1" <?php if ($sub_level_2_blink == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
		        <td><input name="sub_level_2_oblique" type="checkbox" id="sub_level_2_oblique" value="1" <?php if ($sub_level_2_oblique == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo SMALL_CAPS; ?>:</td>
		        <td><input name="sub_level_2_small_caps" type="checkbox" id="sub_level_2_small_caps" value="1" <?php if ($sub_level_2_small_caps == 1) echo "checked='checked'"; ?>></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message" colspan="2">
            <table class="layout_box_table" width="100%">
		      <tr>
		        <td align="center"><?php echo SHADOW_WORD; ?>:		          
		          <input name="sub_level_2_shadow" type="checkbox" id="sub_level_2_shadow" value="1" <?php if ($sub_level_2_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2');"></td>
                  <td align="center">
                <input name="sub_level_2_shadow_hover" type="checkbox" id="sub_level_2_shadow_hover" value="1" <?php if ($sub_level_2_shadow_hover == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2');" /></td>
                <td align="center">
                <input name="sub_level_2_shadow_down" type="checkbox" id="sub_level_2_shadow_down" value="1" <?php if ($sub_level_2_shadow_down == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2');" /></td>
		        <td align="center"><?php echo COLOR_WORD; ?>:
		          <input name="sub_level_2_shadow_color" type="text" id="sub_level_2_shadow_color" value="<?php echo $sub_level_2_shadow_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		          <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color');" class="small_message fake_link"><?php echo RGB_WORD; ?></span></td>
		        <td align="center"><?php echo X_OFFSET_WORD; ?>:
		          <input name="sub_level_2_shadow_x_offset" type="text" id="sub_level_2_shadow_x_offset" value="<?php echo $sub_level_2_shadow_x_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo Y_OFFSET_WORD; ?>:
		          <input name="sub_level_2_shadow_y_offset" type="text" id="sub_level_2_shadow_y_offset" value="<?php echo $sub_level_2_shadow_y_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo BLUR_WORD; ?>:
		          <input name="sub_level_2_shadow_blur" type="text" id="sub_level_2_shadow_blur" value="<?php echo $sub_level_2_shadow_blur; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        </tr>
                <tr>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo NORMAL_WORD; ?></td>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo HOVER_WORD; ?></td>
                <td class="small_message" style="text-align:right; vertical-align:top;"><?php echo DOWN_WORD; ?></td>
                <td colspan="4">&nbsp;</td>
            </tr>
		      </table></td>
		    </tr>
	   </table>
       
       <hr>
        <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold" style="text-align:center;"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="sub_level_2_font_size_hover" type="text" id="sub_level_2_font_size_hover" size="10" value="<?php echo $sub_level_2_font_size_hover; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="sub_level_2_font_size_hover_units" id="sub_level_2_font_size_hover_units" onChange="enable_disable_font_size('sub_level_2_font_size_hover', 'sub_level_2_font_size_hover_units');">
                    <option value="px"<?php if ($sub_level_2_font_size_hover_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_2_font_size_hover_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_2_font_size_hover_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_2_font_size_hover_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_2_font_size_hover_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_2_font_size_hover_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_2_font_size_hover_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_2_font_size_hover_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_2_font_size_hover_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_2_font_size_hover_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_2_font_size_hover_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_2_font_size_hover_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_2_font_size_hover_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_2_font_size_hover_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_2_font_size_hover_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_2_font_size_hover_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_2_font_size_hover_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_2_font_size_hover_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_2_font_size_hover_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_2_font_size_hover_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_2_font_size_hover_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_2_font_size_hover_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_2_font_size_hover_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_2_font_size_hover_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_2_font_size_hover_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="sub_level_2_weight_hover" id="sub_level_2_weight_hover">
                    <option value="-not selected-" <?php if ($sub_level_2_weight_hover == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($sub_level_2_weight_hover == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($sub_level_2_weight_hover == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($sub_level_2_weight_hover == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($sub_level_2_weight_hover == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($sub_level_2_weight_hover == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($sub_level_2_weight_hover == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($sub_level_2_weight_hover == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($sub_level_2_weight_hover == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($sub_level_2_weight_hover == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($sub_level_2_weight_hover == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($sub_level_2_weight_hover == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($sub_level_2_weight_hover == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($sub_level_2_weight_hover == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="sub_level_2_letter_spacing_hover" type="text" id="sub_level_2_letter_spacing_hover" value="<?php if ($sub_level_2_letter_spacing_hover_units < 3) echo intval($sub_level_2_letter_spacing_hover); else echo $sub_level_2_letter_spacing_hover; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_2_letter_spacing_hover_units" id="sub_level_2_letter_spacing_hover_units" onChange="CheckLetterSpacing(this, 'sub_level_2_letter_spacing_hover');">
                    <option value="-1"<?php if ($sub_level_2_letter_spacing_hover_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_2_letter_spacing_hover_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_2_letter_spacing_hover_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_2_letter_spacing_hover_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_2_letter_spacing_hover_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_2_letter_spacing_hover_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_2_letter_spacing_hover_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_2_letter_spacing_hover_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_2_letter_spacing_hover_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_2_letter_spacing_hover_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_2_letter_spacing_hover_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_2_letter_spacing_hover_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_2_letter_spacing_hover_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_2_letter_spacing_hover_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_2_letter_spacing_hover_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_2_letter_spacing_hover_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_2_letter_spacing_hover_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_2_letter_spacing_hover_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_italic_hover" type="checkbox" id="sub_level_2_italic_hover" value="1" <?php if ($sub_level_2_italic_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_underline_hover" type="checkbox" id="sub_level_2_underline_hover" value="1" <?php if ($sub_level_2_underline_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_overline_hover" type="checkbox" id="sub_level_2_overline_hover" value="1" <?php if ($sub_level_2_overline_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_blink_hover" type="checkbox" id="sub_level_2_blink_hover" value="1" <?php if ($sub_level_2_blink_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_oblique_hover" type="checkbox" id="sub_level_2_oblique_hover" value="1" <?php if ($sub_level_2_oblique_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="sub_level_2_small_caps_hover" type="checkbox" id="sub_level_2_small_caps_hover" value="1" <?php if ($sub_level_2_small_caps_hover == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><table class="layout_box_table" width="100%">
            <tr>
              <td align="center"><?php echo EDIT_CSS_MENU_STYLES_SHADOW_COLOR; ?>: </td>
              <td align="center">
			  	<?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?>:
                <input name="sub_level_2_shadow_color_hover" type="text" id="sub_level_2_shadow_color_hover" value="<?php echo $sub_level_2_shadow_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_hover');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
                </td>
              <td align="center">
              	<?php echo EDIT_CSS_MENU_STYLES_DOWN; ?>:
                <input name="sub_level_2_shadow_color_down" type="text" id="sub_level_2_shadow_color_down" value="<?php echo $sub_level_2_shadow_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_down');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
                </td>
              <td align="center">
              	<?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?>:
                <input name="sub_level_2_shadow_color_active" type="text" id="sub_level_2_shadow_color_active" value="<?php echo $sub_level_2_shadow_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <span onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_active');" class="small_message fake_link"><?php echo RGB_WORD; ?></span>
               </td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>
        
        <hr>
        <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold" style="text-align:center;"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="sub_level_2_font_size_down" type="text" id="sub_level_2_font_size_down" size="10" value="<?php echo $sub_level_2_font_size_down; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="sub_level_2_font_size_down_units" id="sub_level_2_font_size_down_units" onChange="enable_disable_font_size('sub_level_2_font_size_down', 'sub_level_2_font_size_down_units');">
                    <option value="px"<?php if ($sub_level_2_font_size_down_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_2_font_size_down_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_2_font_size_down_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_2_font_size_down_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_2_font_size_down_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_2_font_size_down_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_2_font_size_down_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_2_font_size_down_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_2_font_size_down_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_2_font_size_down_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_2_font_size_down_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_2_font_size_down_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_2_font_size_down_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_2_font_size_down_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_2_font_size_down_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_2_font_size_down_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_2_font_size_down_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_2_font_size_down_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_2_font_size_down_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_2_font_size_down_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_2_font_size_down_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_2_font_size_down_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_2_font_size_down_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_2_font_size_down_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_2_font_size_down_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="sub_level_2_weight_down" id="sub_level_2_weight_down">
                    <option value="-not selected-" <?php if ($sub_level_2_weight_down == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($sub_level_2_weight_down == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($sub_level_2_weight_down == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($sub_level_2_weight_down == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($sub_level_2_weight_down == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($sub_level_2_weight_down == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($sub_level_2_weight_down == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($sub_level_2_weight_down == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($sub_level_2_weight_down == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($sub_level_2_weight_down == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($sub_level_2_weight_down == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($sub_level_2_weight_down == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($sub_level_2_weight_down == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($sub_level_2_weight_down == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="sub_level_2_letter_spacing_down" type="text" id="sub_level_2_letter_spacing_down" value="<?php if ($sub_level_2_letter_spacing_down_units < 3) echo intval($sub_level_2_letter_spacing_down); else echo $sub_level_2_letter_spacing_down; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_2_letter_spacing_down_units" id="sub_level_2_letter_spacing_down_units" onChange="CheckLetterSpacing(this, 'sub_level_2_letter_spacing_down');">
                    <option value="-1"<?php if ($sub_level_2_letter_spacing_down_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_2_letter_spacing_down_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_2_letter_spacing_down_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_2_letter_spacing_down_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_2_letter_spacing_down_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_2_letter_spacing_down_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_2_letter_spacing_down_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_2_letter_spacing_down_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_2_letter_spacing_down_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_2_letter_spacing_down_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_2_letter_spacing_down_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_2_letter_spacing_down_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_2_letter_spacing_down_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_2_letter_spacing_down_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_2_letter_spacing_down_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_2_letter_spacing_down_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_2_letter_spacing_down_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_2_letter_spacing_down_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_italic_down" type="checkbox" id="sub_level_2_italic_down" value="1" <?php if ($sub_level_2_italic_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_underline_down" type="checkbox" id="sub_level_2_underline_down" value="1" <?php if ($sub_level_2_underline_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_overline_down" type="checkbox" id="sub_level_2_overline_down" value="1" <?php if ($sub_level_2_overline_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_blink_down" type="checkbox" id="sub_level_2_blink_down" value="1" <?php if ($sub_level_2_blink_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="sub_level_2_oblique_down" type="checkbox" id="sub_level_2_oblique_down" value="1" <?php if ($sub_level_2_oblique_down == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="sub_level_2_small_caps_down" type="checkbox" id="sub_level_2_small_caps_down" value="1" <?php if ($sub_level_2_small_caps_down == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>
        
	</td>
  </tr>
  
  <tr>
    <td bgcolor="#ccffcc">
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td colspan="10" class="bold"><?php echo EDIT_CSS_MENU_STYLES_COLORS_BACKGROUND; ?></td>
		  </tr>
		  <tr>
          	<td>&nbsp;</td>
			<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td>
			<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td>
            <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td>
			<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?></td>
            <td class="bold">
			<?php echo EDIT_CSS_MENU_STYLES_HOVER_ON_DOWN; ?>
            <input name="hover_on_down_select_all" type="checkbox" id="hover_on_down_select_all" onClick="CheckUncheckAllHoverOnDown(this.checked);" />
            </td>
			<td class="bold">&nbsp;</td>
            <td align="center" rowspan="9" valign="bottom" class="bold"><?php echo MANAGE_CUSTOM_FONTS_STYLE; ?></td>
            <td align="center" rowspan="9" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_TOP_BORDER_VERTICAL; ?></td>
            <td  align="center" rowspan="9" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_BOTTOM_BORDER_VERTICAL; ?></td>
            <td align="center" rowspan="9" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_LEFT_BORDER_VERTICAL; ?></td>
            <td  align="center" rowspan="9" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_RIGHT_BORDER_VERTICAL; ?></td>
            <td  align="center" rowspan="11" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_OMIT_ADJACENT_BORDERS; ?></td>
		  </tr>
		  <tr>
			<td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_TEXT_COLOR; ?>: </td>
            <td align="left"><input name="top_level_text_color" type="text" id="top_level_text_color" value="<?php echo $top_level_text_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color');"><?php echo RGB_WORD; ?></span>
            </td>
			<td><input name="top_level_text_color_hover" type="text" id="top_level_text_color_hover" value="<?php echo $top_level_text_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_hover');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="top_level_text_color_down" type="text" id="top_level_text_color_down" value="<?php echo $top_level_text_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_down');"><?php echo RGB_WORD; ?></span></td>
			<td><input name="top_level_text_color_active" type="text" id="top_level_text_color_active" value="<?php echo $top_level_text_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_active');"><?php echo RGB_WORD; ?></span></td>
              <td>
              	<input name="top_level_txt_color_hover_on_down" type="checkbox" id="top_level_txt_color_hover_on_down" value="1" <?php if ($top_level_txt_color_hover_on_down == 1) echo "checked='checked'"; ?>>
              </td>
			<td>&nbsp;</td>
		  </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_TEXT_COLOR; ?>: </td>
		    <td align="left"><input name="sub_level_1_text_color" type="text" id="sub_level_1_text_color" value="<?php echo $sub_level_1_text_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="sub_level_1_text_color_hover" type="text" id="sub_level_1_text_color_hover" value="<?php echo $sub_level_1_text_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_hover');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="sub_level_1_text_color_down" type="text" id="sub_level_1_text_color_down" value="<?php echo $sub_level_1_text_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_down');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="sub_level_1_text_color_active" type="text" id="sub_level_1_text_color_active" value="<?php echo $sub_level_1_text_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_active');"><?php echo RGB_WORD; ?></span></td>
              <td>
              	<input name="sub_level_1_txt_color_hover_on_down" type="checkbox" id="sub_level_1_txt_color_hover_on_down" value="1" <?php if ($sub_level_1_txt_color_hover_on_down == 1) echo "checked='checked'"; ?>>
              </td>
		    <td>&nbsp;</td>
            
		    </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_TEXT_COLOR; ?>: </td>
		    <td align="left"><input name="sub_level_2_text_color" type="text" id="sub_level_2_text_color" value="<?php echo $sub_level_2_text_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="sub_level_2_text_color_hover" type="text" id="sub_level_2_text_color_hover" value="<?php echo $sub_level_2_text_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_hover');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="sub_level_2_text_color_down" type="text" id="sub_level_2_text_color_down" value="<?php echo $sub_level_2_text_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_down');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="sub_level_2_text_color_active" type="text" id="sub_level_2_text_color_active" value="<?php echo $sub_level_2_text_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_active');"><?php echo RGB_WORD; ?></span></td>
              <td>
              	<input name="sub_level_2_txt_color_hover_on_down" type="checkbox" id="sub_level_2_txt_color_hover_on_down" value="1" <?php if ($sub_level_2_txt_color_hover_on_down == 1) echo "checked='checked'"; ?>>
              </td>
		    <td>&nbsp;</td>
            
		  </tr>
          <tr>
          	<td colspan="6">&nbsp;</td>
            <td><span class="bold"><?php echo OPACITY_WORD; ?></span></td>
          </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_BACKGROUND_COLOR; ?>:</td>
		    <td><input name="top_level_background_color" type="text" id="top_level_background_color" value="<?php echo $top_level_background_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="top_level_background_color_hover" type="text" id="top_level_background_color_hover" value="<?php echo $top_level_background_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_hover');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="top_level_background_color_down" type="text" id="top_level_background_color_down" value="<?php echo $top_level_background_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_down');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="top_level_background_color_active" type="text" id="top_level_background_color_active" value="<?php echo $top_level_background_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_active');"><?php echo RGB_WORD; ?></span></td>
              <td>
              	<input name="top_level_bkgd_color_hover_on_down" type="checkbox" id="top_level_bkgd_color_hover_on_down" value="1" <?php if ($top_level_bkgd_color_hover_on_down == 1) echo "checked='checked'"; ?>>
              </td>
		    <td><input name="top_level_background_opacity" type="text" id="top_level_background_opacity" value="<?php echo $top_level_background_opacity; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		    %</td>
            
		    </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_BACKGROUND_COLOR; ?>: </td>
		    <td><input name="sub_level_1_background_color" type="text" id="sub_level_1_background_color" value="<?php echo $sub_level_1_background_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_background_color');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="sub_level_1_background_color_hover" type="text" id="sub_level_1_background_color_hover" value="<?php echo $sub_level_1_background_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_background_color_hover');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="sub_level_1_background_color_down" type="text" id="sub_level_1_background_color_down" value="<?php echo $sub_level_1_background_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_background_color_down');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="sub_level_1_background_color_active" type="text" id="sub_level_1_background_color_active" value="<?php echo $sub_level_1_background_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_background_color_active');"><?php echo RGB_WORD; ?></span>
             </td>
             <td>
              	<input name="sub_level_1_bkgd_color_hover_on_down" type="checkbox" id="sub_level_1_bkgd_color_hover_on_down" value="1" <?php if ($sub_level_1_bkgd_color_hover_on_down == 1) echo "checked='checked'"; ?>>
              </td>
		    <td><input name="sub_level_1_background_opacity" type="text" id="sub_level_1_background_opacity" value="<?php echo $sub_level_1_background_opacity; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		      %</td>
           
		    </tr>
          <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_BACKGROUND_COLOR; ?>: </td>
		    <td><input name="sub_level_2_background_color" type="text" id="sub_level_2_background_color" value="<?php echo $sub_level_2_background_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_background_color');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="sub_level_2_background_color_hover" type="text" id="sub_level_2_background_color_hover" value="<?php echo $sub_level_2_background_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_background_color_hover');"><?php echo RGB_WORD; ?></span></td>
              <td><input name="sub_level_2_background_color_down" type="text" id="sub_level_2_background_color_down" value="<?php echo $sub_level_2_background_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_background_color_down');"><?php echo RGB_WORD; ?></span></td>
		    <td><input name="sub_level_2_background_color_active" type="text" id="sub_level_2_background_color_active" value="<?php echo $sub_level_2_background_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_background_color_active');"><?php echo RGB_WORD; ?></span></td>
              <td>
              	<input name="sub_level_2_bkgd_color_hover_on_down" type="checkbox" id="sub_level_2_bkgd_color_hover_on_down" value="1" <?php if ($sub_level_2_bkgd_color_hover_on_down == 1) echo "checked='checked'"; ?>>
              </td>
		    <td><input name="sub_level_2_background_opacity" type="text" id="sub_level_2_background_opacity" value="<?php echo $sub_level_2_background_opacity; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		      %</td>
           
		    </tr>
          <tr>
          	<td colspan="6">&nbsp;</td>
            <td><span class="bold"><?php echo WIDTH_WORD; ?></span></td>
          </tr>
          <tr>
            <td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_BLOCK_BORDER_COLOR; ?>:</td>
            <td><input name="top_level_block_border_color" type="text" id="top_level_block_border_color" value="<?php echo $top_level_block_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_block_border_color');"><?php echo RGB_WORD; ?></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_NORMAL_NOTE; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><input name="top_level_block_border_width" type="text" id="top_level_block_border_width" value="<?php echo $top_level_block_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
              <select name="top_level_block_border_units" id="top_level_block_border_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_block_border_width');">
                    <option value="0"<?php if ($top_level_block_border_units == 0) echo " selected"; ?>>px</option>
                    <option value="1"<?php if ($top_level_block_border_units == 1) echo " selected"; ?>>%</option>
                    <option value="2"<?php if ($top_level_block_border_units == 2) echo " selected"; ?>>em</option>
                    <option value="3"<?php if ($top_level_block_border_units == 4) echo " selected"; ?>>pt</option>
                    <option value="4"<?php if ($top_level_block_border_units == 5) echo " selected"; ?>>pc</option>
                    <option value="5"<?php if ($top_level_block_border_units == 6) echo " selected"; ?>>cm</option>
                    <option value="6"<?php if ($top_level_block_border_units == 7) echo " selected"; ?>>mm</option>
                    <option value="7"<?php if ($top_level_block_border_units == 8) echo " selected"; ?>>in</option>
                    <option value="8"<?php if ($top_level_block_border_units == 9) echo " selected"; ?>>rem</option>
                    <option value="9"<?php if ($top_level_block_border_units == 10) echo " selected"; ?>>vw</option>
                    <option value="10"<?php if ($top_level_block_border_units == 11) echo " selected"; ?>>vh</option>
                    <option value="11"<?php if ($top_level_block_border_units == 12) echo " selected"; ?>>vmin</option>
                    <option value="12"<?php if ($top_level_block_border_units == 13) echo " selected"; ?>>vmax</option>
                    <option value="13"<?php if ($top_level_block_border_units == 14) echo " selected"; ?>>ch</option>
                </select>
              </td>
              <td>
	             <select name="top_level_block_border_style" id="top_level_block_border_style">
                 <option value="-not selected-" class="not_set"<?php if ($top_level_block_border_style == "-not selected-") echo " selected"; ?>><?php echo _NOT_SELECTED_; ?></option>
                 <option value="none"<?php if ($top_level_block_border_style == "none") echo " selected"; ?>><?php echo NONE_WORD; ?></option>
                 <option value="hidden"<?php if ($top_level_block_border_style == "hidden") echo " selected"; ?>><?php echo HIDDEN_WORD; ?></option>
                 <option value="dotted"<?php if ($top_level_block_border_style == "dotted") echo " selected"; ?>><?php echo DOTTED_WORD; ?></option>
                 <option value="dashed"<?php if ($top_level_block_border_style == "dashed") echo " selected"; ?>><?php echo DASHED_WORD; ?></option>
                 <option value="solid"<?php if ($top_level_block_border_style == "solid") echo " selected"; ?>><?php echo SOLID_WORD; ?></option>
                 <option value="double"<?php if ($top_level_block_border_style == "double") echo " selected"; ?>><?php echo DOUBLE_WORD; ?></option>
                 <option value="groove"<?php if ($top_level_block_border_style == "groove") echo " selected"; ?>><?php echo GROOVE_WORD; ?></option>
                 <option value="ridge"<?php if ($top_level_block_border_style == "ridge") echo " selected"; ?>><?php echo RIDGE_WORD; ?></option>
                 <option value="inset"<?php if ($top_level_block_border_style == "inset") echo " selected"; ?>><?php echo INSET_WORD; ?></option>
                 <option value="outset"<?php if ($top_level_block_border_style == "outset") echo " selected"; ?>><?php echo OUTSET_WORD; ?></option>
                 <option value="initial"<?php if ($top_level_block_border_style == "initial") echo " selected"; ?>><?php echo INITIAL_WORD; ?></option>
                 <option value="inherit"<?php if ($top_level_block_border_style == "inherit") echo " selected"; ?>><?php echo INHERIT_WORD; ?></option>
                 </select>
              </td>
              <td>
              	<input name="top_level_block_border_top" type="checkbox" id="top_level_block_border_top" value="1" <?php if ($top_level_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_bottom" type="checkbox" id="top_level_block_border_bottom" value="1" <?php if ($top_level_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_left" type="checkbox" id="top_level_block_border_left" value="1" <?php if ($top_level_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_right" type="checkbox" id="top_level_block_border_right" value="1" <?php if ($top_level_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
          </tr>
          
          
          
          
           <tr>
          	<td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_BLOCK_BORDER_COLOR; ?>:</td>
            <td><input name="sub_level_1_block_border_color" type="text" id="sub_level_1_block_border_color" value="<?php echo $sub_level_1_block_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_block_border_color');"><?php echo RGB_WORD; ?></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_NORMAL_NOTE; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><input name="sub_level_1_block_border_width" type="text" id="sub_level_1_block_border_width" value="<?php echo $sub_level_1_block_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              <select name="sub_level_1_block_border_units" id="sub_level_1_block_border_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_block_border_width');">
                    <option value="0"<?php if ($sub_level_1_block_border_units == 0) echo " selected"; ?>>px</option>
                    <option value="1"<?php if ($sub_level_1_block_border_units == 1) echo " selected"; ?>>%</option>
                    <option value="2"<?php if ($sub_level_1_block_border_units == 2) echo " selected"; ?>>em</option>
                    <option value="3"<?php if ($sub_level_1_block_border_units == 4) echo " selected"; ?>>pt</option>
                    <option value="4"<?php if ($sub_level_1_block_border_units == 5) echo " selected"; ?>>pc</option>
                    <option value="5"<?php if ($sub_level_1_block_border_units == 6) echo " selected"; ?>>cm</option>
                    <option value="6"<?php if ($sub_level_1_block_border_units == 7) echo " selected"; ?>>mm</option>
                    <option value="7"<?php if ($sub_level_1_block_border_units == 8) echo " selected"; ?>>in</option>
                    <option value="8"<?php if ($sub_level_1_block_border_units == 9) echo " selected"; ?>>rem</option>
                    <option value="9"<?php if ($sub_level_1_block_border_units == 10) echo " selected"; ?>>vw</option>
                    <option value="10"<?php if ($sub_level_1_block_border_units == 11) echo " selected"; ?>>vh</option>
                    <option value="11"<?php if ($sub_level_1_block_border_units == 12) echo " selected"; ?>>vmin</option>
                    <option value="12"<?php if ($sub_level_1_block_border_units == 13) echo " selected"; ?>>vmax</option>
                    <option value="13"<?php if ($sub_level_1_block_border_units == 14) echo " selected"; ?>>ch</option>
                </select>
              </td>
              <td>
	             <select name="sub_level_1_block_border_style" id="sub_level_1_block_border_style">
                 <option value="-not selected-" class="not_set"<?php if ($sub_level_1_block_border_style == "-not selected-") echo " selected"; ?>><?php echo _NOT_SELECTED_; ?></option>
                 <option value="none"<?php if ($sub_level_1_block_border_style == "none") echo " selected"; ?>><?php echo NONE_WORD; ?></option>
                 <option value="hidden"<?php if ($sub_level_1_block_border_style == "hidden") echo " selected"; ?>><?php echo HIDDEN_WORD; ?></option>
                 <option value="dotted"<?php if ($sub_level_1_block_border_style == "dotted") echo " selected"; ?>><?php echo DOTTED_WORD; ?></option>
                 <option value="dashed"<?php if ($sub_level_1_block_border_style == "dashed") echo " selected"; ?>><?php echo DASHED_WORD; ?></option>
                 <option value="solid"<?php if ($sub_level_1_block_border_style == "solid") echo " selected"; ?>><?php echo SOLID_WORD; ?></option>
                 <option value="double"<?php if ($sub_level_1_block_border_style == "double") echo " selected"; ?>><?php echo DOUBLE_WORD; ?></option>
                 <option value="groove"<?php if ($sub_level_1_block_border_style == "groove") echo " selected"; ?>><?php echo GROOVE_WORD; ?></option>
                 <option value="ridge"<?php if ($sub_level_1_block_border_style == "ridge") echo " selected"; ?>><?php echo RIDGE_WORD; ?></option>
                 <option value="inset"<?php if ($sub_level_1_block_border_style == "inset") echo " selected"; ?>><?php echo INSET_WORD; ?></option>
                 <option value="outset"<?php if ($sub_level_1_block_border_style == "outset") echo " selected"; ?>><?php echo OUTSET_WORD; ?></option>
                 <option value="initial"<?php if ($sub_level_1_block_border_style == "initial") echo " selected"; ?>><?php echo INITIAL_WORD; ?></option>
                 <option value="inherit"<?php if ($sub_level_1_block_border_style == "inherit") echo " selected"; ?>><?php echo INHERIT_WORD; ?></option>
                 </select>
              </td>
              <td>
              	<input name="sub_level_1_block_border_top" type="checkbox" id="sub_level_1_block_border_top" value="1" <?php if ($sub_level_1_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_1_block_border_bottom" type="checkbox" id="sub_level_1_block_border_bottom" value="1" <?php if ($sub_level_1_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_1_block_border_left" type="checkbox" id="sub_level_1_block_border_left" value="1" <?php if ($sub_level_1_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_1_block_border_right" type="checkbox" id="sub_level_1_block_border_right" value="1" <?php if ($sub_level_1_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
       	  </tr>
          
          
          
          <tr>
          	<td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_BLOCK_BORDER_COLOR; ?>:</td>
            <td><input name="sub_level_2_block_border_color" type="text" id="sub_level_2_block_border_color" value="<?php echo $sub_level_2_block_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_block_border_color');"><?php echo RGB_WORD; ?></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_NORMAL_NOTE; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><input name="sub_level_2_block_border_width" type="text" id="sub_level_2_block_border_width" value="<?php echo $sub_level_2_block_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              <select name="sub_level_2_block_border_units" id="sub_level_2_block_border_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_block_border_width');">
                    <option value="0"<?php if ($sub_level_2_block_border_units == 0) echo " selected"; ?>>px</option>
                    <option value="1"<?php if ($sub_level_2_block_border_units == 1) echo " selected"; ?>>%</option>
                    <option value="2"<?php if ($sub_level_2_block_border_units == 2) echo " selected"; ?>>em</option>
                    <option value="3"<?php if ($sub_level_2_block_border_units == 4) echo " selected"; ?>>pt</option>
                    <option value="4"<?php if ($sub_level_2_block_border_units == 5) echo " selected"; ?>>pc</option>
                    <option value="5"<?php if ($sub_level_2_block_border_units == 6) echo " selected"; ?>>cm</option>
                    <option value="6"<?php if ($sub_level_2_block_border_units == 7) echo " selected"; ?>>mm</option>
                    <option value="7"<?php if ($sub_level_2_block_border_units == 8) echo " selected"; ?>>in</option>
                    <option value="8"<?php if ($sub_level_2_block_border_units == 9) echo " selected"; ?>>rem</option>
                    <option value="9"<?php if ($sub_level_2_block_border_units == 10) echo " selected"; ?>>vw</option>
                    <option value="10"<?php if ($sub_level_2_block_border_units == 11) echo " selected"; ?>>vh</option>
                    <option value="11"<?php if ($sub_level_2_block_border_units == 12) echo " selected"; ?>>vmin</option>
                    <option value="12"<?php if ($sub_level_2_block_border_units == 13) echo " selected"; ?>>vmax</option>
                    <option value="13"<?php if ($sub_level_2_block_border_units == 14) echo " selected"; ?>>ch</option>
                </select>
              </td>
              <td>
	             <select name="sub_level_2_block_border_style" id="sub_level_2_block_border_style">
                 <option value="-not selected-" class="not_set"<?php if ($sub_level_2_block_border_style == "-not selected-") echo " selected"; ?>><?php echo _NOT_SELECTED_; ?></option>
                 <option value="none"<?php if ($sub_level_2_block_border_style == "none") echo " selected"; ?>><?php echo NONE_WORD; ?></option>
                 <option value="hidden"<?php if ($sub_level_2_block_border_style == "hidden") echo " selected"; ?>><?php echo HIDDEN_WORD; ?></option>
                 <option value="dotted"<?php if ($sub_level_2_block_border_style == "dotted") echo " selected"; ?>><?php echo DOTTED_WORD; ?></option>
                 <option value="dashed"<?php if ($sub_level_2_block_border_style == "dashed") echo " selected"; ?>><?php echo DASHED_WORD; ?></option>
                 <option value="solid"<?php if ($sub_level_2_block_border_style == "solid") echo " selected"; ?>><?php echo SOLID_WORD; ?></option>
                 <option value="double"<?php if ($sub_level_2_block_border_style == "double") echo " selected"; ?>><?php echo DOUBLE_WORD; ?></option>
                 <option value="groove"<?php if ($sub_level_2_block_border_style == "groove") echo " selected"; ?>><?php echo GROOVE_WORD; ?></option>
                 <option value="ridge"<?php if ($sub_level_2_block_border_style == "ridge") echo " selected"; ?>><?php echo RIDGE_WORD; ?></option>
                 <option value="inset"<?php if ($sub_level_2_block_border_style == "inset") echo " selected"; ?>><?php echo INSET_WORD; ?></option>
                 <option value="outset"<?php if ($sub_level_2_block_border_style == "outset") echo " selected"; ?>><?php echo OUTSET_WORD; ?></option>
                 <option value="initial"<?php if ($sub_level_2_block_border_style == "initial") echo " selected"; ?>><?php echo INITIAL_WORD; ?></option>
                 <option value="inherit"<?php if ($sub_level_2_block_border_style == "inherit") echo " selected"; ?>><?php echo INHERIT_WORD; ?></option>
                 </select>
              </td>
              <td>
              	<input name="sub_level_2_block_border_top" type="checkbox" id="sub_level_2_block_border_top" value="1" <?php if ($sub_level_2_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_2_block_border_bottom" type="checkbox" id="sub_level_2_block_border_bottom" value="1" <?php if ($sub_level_2_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_2_block_border_left" type="checkbox" id="sub_level_2_block_border_left" value="1" <?php if ($sub_level_2_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_2_block_border_right" type="checkbox" id="sub_level_2_block_border_right" value="1" <?php if ($sub_level_2_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
       	  </tr>
          
          
          
            <tr>
            <td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_ITEM_BORDER_COLOR; ?>:</td>
            <td><input name="top_level_item_border_color" type="text" id="top_level_item_border_color" value="<?php echo $top_level_item_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color');"><?php echo RGB_WORD; ?></span></td>
            <td><input name="top_level_item_border_color_hover" type="text" id="top_level_item_border_color_hover" value="<?php echo $top_level_item_border_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="top_level_item_border_color_hover_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_hover');"><?php echo RGB_WORD; ?></span></td>
              
              <td><input name="top_level_item_border_color_down" type="text" id="top_level_item_border_color_down" value="<?php echo $top_level_item_border_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="top_level_item_border_color_down_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_down');"><?php echo RGB_WORD; ?></span></td>
              
            <td><input name="top_level_item_border_color_active" type="text" id="top_level_item_border_color_active" value="<?php echo $top_level_item_border_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="top_level_item_border_color_active_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_active');"><?php echo RGB_WORD; ?></span></td>
            <td>
              	<input name="top_level_border_hover_on_down" type="checkbox" id="top_level_border_hover_on_down" value="1" <?php if ($top_level_border_hover_on_down == 1) echo "checked='checked'"; ?>>
            </td>
            <td><input name="top_level_item_border_width" type="text" id="top_level_item_border_width" value="<?php echo $top_level_item_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              <select name="top_level_item_border_units" id="top_level_item_border_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_item_border_width');">
                <option value="0"<?php if ($top_level_item_border_units == 0) echo " selected"; ?>>px</option>
                    <option value="1"<?php if ($top_level_item_border_units == 1) echo " selected"; ?>>%</option>
                    <option value="2"<?php if ($top_level_item_border_units == 2) echo " selected"; ?>>em</option>
                    <option value="3"<?php if ($top_level_item_border_units == 4) echo " selected"; ?>>pt</option>
                    <option value="4"<?php if ($top_level_item_border_units == 5) echo " selected"; ?>>pc</option>
                    <option value="5"<?php if ($top_level_item_border_units == 6) echo " selected"; ?>>cm</option>
                    <option value="6"<?php if ($top_level_item_border_units == 7) echo " selected"; ?>>mm</option>
                    <option value="7"<?php if ($top_level_item_border_units == 8) echo " selected"; ?>>in</option>
                    <option value="8"<?php if ($top_level_item_border_units == 9) echo " selected"; ?>>rem</option>
                    <option value="9"<?php if ($top_level_item_border_units == 10) echo " selected"; ?>>vw</option>
                    <option value="10"<?php if ($top_level_item_border_units == 11) echo " selected"; ?>>vh</option>
                    <option value="11"<?php if ($top_level_item_border_units == 12) echo " selected"; ?>>vmin</option>
                    <option value="12"<?php if ($top_level_item_border_units == 13) echo " selected"; ?>>vmax</option>
                    <option value="13"<?php if ($top_level_item_border_units == 14) echo " selected"; ?>>ch</option>
              </select></td>
              <td>
	             <select name="top_level_item_border_style" id="top_level_item_border_style">
                 <option value="-not selected-" class="not_set"<?php if ($top_level_item_border_style == "-not selected-") echo " selected"; ?>><?php echo _NOT_SELECTED_; ?></option>
                 <option value="none"<?php if ($top_level_item_border_style == "none") echo " selected"; ?>><?php echo NONE_WORD; ?></option>
                 <option value="hidden"<?php if ($top_level_item_border_style == "hidden") echo " selected"; ?>><?php echo HIDDEN_WORD; ?></option>
                 <option value="dotted"<?php if ($top_level_item_border_style == "dotted") echo " selected"; ?>><?php echo DOTTED_WORD; ?></option>
                 <option value="dashed"<?php if ($top_level_item_border_style == "dashed") echo " selected"; ?>><?php echo DASHED_WORD; ?></option>
                 <option value="solid"<?php if ($top_level_item_border_style == "solid") echo " selected"; ?>><?php echo SOLID_WORD; ?></option>
                 <option value="double"<?php if ($top_level_item_border_style == "double") echo " selected"; ?>><?php echo DOUBLE_WORD; ?></option>
                 <option value="groove"<?php if ($top_level_item_border_style == "groove") echo " selected"; ?>><?php echo GROOVE_WORD; ?></option>
                 <option value="ridge"<?php if ($top_level_item_border_style == "ridge") echo " selected"; ?>><?php echo RIDGE_WORD; ?></option>
                 <option value="inset"<?php if ($top_level_item_border_style == "inset") echo " selected"; ?>><?php echo INSET_WORD; ?></option>
                 <option value="outset"<?php if ($top_level_item_border_style == "outset") echo " selected"; ?>><?php echo OUTSET_WORD; ?></option>
                 <option value="initial"<?php if ($top_level_item_border_style == "initial") echo " selected"; ?>><?php echo INITIAL_WORD; ?></option>
                 <option value="inherit"<?php if ($top_level_item_border_style == "inherit") echo " selected"; ?>><?php echo INHERIT_WORD; ?></option>
                 </select>
              </td>
              <td>
              	<input name="top_level_item_border_top" type="checkbox" id="top_level_item_border_top" value="1" <?php if ($top_level_item_border_top == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'top_level');">
              </td>
              <td>
              	<input name="top_level_item_border_bottom" type="checkbox" id="top_level_item_border_bottom" value="1" <?php if ($top_level_item_border_bottom == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'top_level');">
              </td>
              <td>
              	<input name="top_level_item_border_left" type="checkbox" id="top_level_item_border_left" value="1" <?php if ($top_level_item_border_left == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'top_level');">
              </td>
              <td>
              	<input name="top_level_item_border_right" type="checkbox" id="top_level_item_border_right" value="1" <?php if ($top_level_item_border_right == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'top_level');">
              </td>
              <td>
              	<input name="top_level_item_omit_adjacent_border" type="checkbox" id="top_level_item_omit_adjacent_border" value="1" <?php if ($top_level_item_omit_adjacent_border == 1) echo "checked='checked'"; ?> onChange="CheckItemBorderSettings('top_level');">
              </td>
          </tr>
           <tr>
          	<td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_ITEM_BORDER_COLOR; ?>:</td>
            <td><input name="sub_level_1_item_border_color" type="text" id="sub_level_1_item_border_color" value="<?php echo $sub_level_1_item_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_1_item_border_color_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_item_border_color');"><?php echo RGB_WORD; ?></span></td>
            <td><input name="sub_level_1_item_border_color_hover" type="text" id="sub_level_1_item_border_color_hover" value="<?php echo $sub_level_1_item_border_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_1_item_border_color_hover_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_item_border_color_hover');"><?php echo RGB_WORD; ?></span></td>
            
            <td><input name="sub_level_1_item_border_color_down" type="text" id="sub_level_1_item_border_color_down" value="<?php echo $sub_level_1_item_border_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_1_item_border_color_down_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_item_border_color_down');"><?php echo RGB_WORD; ?></span></td>
              
            <td><input name="sub_level_1_item_border_color_active" type="text" id="sub_level_1_item_border_color_active" value="<?php echo $sub_level_1_item_border_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_1_item_border_color_active_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_item_border_color_active');"><?php echo RGB_WORD; ?></span></td>
            <td>
              	<input name="sub_level_1_border_hover_on_down" type="checkbox" id="sub_level_1_border_hover_on_down" value="1" <?php if ($sub_level_1_border_hover_on_down == 1) echo "checked='checked'"; ?>>
            </td>

            <td><input name="sub_level_1_item_border_width" type="text" id="sub_level_1_item_border_width" value="<?php echo $sub_level_1_item_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              <select name="sub_level_1_item_border_units" id="sub_level_1_item_border_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_item_border_width');">
                    <option value="0"<?php if ($sub_level_1_item_border_units == 0) echo " selected"; ?>>px</option>
                    <option value="1"<?php if ($sub_level_1_item_border_units == 1) echo " selected"; ?>>%</option>
                    <option value="2"<?php if ($sub_level_1_item_border_units == 2) echo " selected"; ?>>em</option>
                    <option value="3"<?php if ($sub_level_1_item_border_units == 4) echo " selected"; ?>>pt</option>
                    <option value="4"<?php if ($sub_level_1_item_border_units == 5) echo " selected"; ?>>pc</option>
                    <option value="5"<?php if ($sub_level_1_item_border_units == 6) echo " selected"; ?>>cm</option>
                    <option value="6"<?php if ($sub_level_1_item_border_units == 7) echo " selected"; ?>>mm</option>
                    <option value="7"<?php if ($sub_level_1_item_border_units == 8) echo " selected"; ?>>in</option>
                    <option value="8"<?php if ($sub_level_1_item_border_units == 9) echo " selected"; ?>>rem</option>
                    <option value="9"<?php if ($sub_level_1_item_border_units == 10) echo " selected"; ?>>vw</option>
                    <option value="10"<?php if ($sub_level_1_item_border_units == 11) echo " selected"; ?>>vh</option>
                    <option value="11"<?php if ($sub_level_1_item_border_units == 12) echo " selected"; ?>>vmin</option>
                    <option value="12"<?php if ($sub_level_1_item_border_units == 13) echo " selected"; ?>>vmax</option>
                    <option value="13"<?php if ($sub_level_1_item_border_units == 14) echo " selected"; ?>>ch</option>
                </select>
              </td>
              <td>
	             <select name="sub_level_1_item_border_style" id="sub_level_1_item_border_style">
                 <option value="-not selected-" class="not_set"<?php if ($sub_level_1_item_border_style == "-not selected-") echo " selected"; ?>><?php echo _NOT_SELECTED_; ?></option>
                 <option value="none"<?php if ($sub_level_1_item_border_style == "none") echo " selected"; ?>><?php echo NONE_WORD; ?></option>
                 <option value="hidden"<?php if ($sub_level_1_item_border_style == "hidden") echo " selected"; ?>><?php echo HIDDEN_WORD; ?></option>
                 <option value="dotted"<?php if ($sub_level_1_item_border_style == "dotted") echo " selected"; ?>><?php echo DOTTED_WORD; ?></option>
                 <option value="dashed"<?php if ($sub_level_1_item_border_style == "dashed") echo " selected"; ?>><?php echo DASHED_WORD; ?></option>
                 <option value="solid"<?php if ($sub_level_1_item_border_style == "solid") echo " selected"; ?>><?php echo SOLID_WORD; ?></option>
                 <option value="double"<?php if ($sub_level_1_item_border_style == "double") echo " selected"; ?>><?php echo DOUBLE_WORD; ?></option>
                 <option value="groove"<?php if ($sub_level_1_item_border_style == "groove") echo " selected"; ?>><?php echo GROOVE_WORD; ?></option>
                 <option value="ridge"<?php if ($sub_level_1_item_border_style == "ridge") echo " selected"; ?>><?php echo RIDGE_WORD; ?></option>
                 <option value="inset"<?php if ($sub_level_1_item_border_style == "inset") echo " selected"; ?>><?php echo INSET_WORD; ?></option>
                 <option value="outset"<?php if ($sub_level_1_item_border_style == "outset") echo " selected"; ?>><?php echo OUTSET_WORD; ?></option>
                 <option value="initial"<?php if ($sub_level_1_item_border_style == "initial") echo " selected"; ?>><?php echo INITIAL_WORD; ?></option>
                 <option value="inherit"<?php if ($sub_level_1_item_border_style == "inherit") echo " selected"; ?>><?php echo INHERIT_WORD; ?></option>
                 </select>
              </td>
              <td>
              	<input name="sub_level_1_item_border_top" type="checkbox" id="sub_level_1_item_border_top" value="1" <?php if ($sub_level_1_item_border_top == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_1');">
              </td>
              <td><input name="sub_level_1_item_border_bottom" type="checkbox" id="sub_level_1_item_border_bottom" value="1" <?php if ($sub_level_1_item_border_bottom == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_1');">
              </td>
              <td>
              	<input name="sub_level_1_item_border_left" type="checkbox" id="sub_level_1_item_border_left" value="1" <?php if ($sub_level_1_item_border_left == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_1');">
              </td>
              <td>
              	<input name="sub_level_1_item_border_right" type="checkbox" id="sub_level_1_item_border_right" value="1" <?php if ($sub_level_1_item_border_right == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_1');">
              </td>
              <td>
              	<input name="sub_level_1_item_omit_adjacent_border" type="checkbox" id="sub_level_1_item_omit_adjacent_border" value="1" <?php if ($sub_level_1_item_omit_adjacent_border == 1) echo "checked='checked'"; ?> onChange="CheckItemBorderSettings('sub_level_1');">
              </td>
       	  </tr>
          <tr>
          	<td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_ITEM_BORDER_COLOR; ?>:</td>
            <td><input name="sub_level_2_item_border_color" type="text" id="sub_level_2_item_border_color" value="<?php echo $sub_level_2_item_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_2_item_border_color_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_item_border_color');"><?php echo RGB_WORD; ?></span></td>
            <td><input name="sub_level_2_item_border_color_hover" type="text" id="sub_level_2_item_border_color_hover" value="<?php echo $sub_level_2_item_border_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_2_item_border_color_hover_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_item_border_color_hover');"><?php echo RGB_WORD; ?></span></td>
            
            <td><input name="sub_level_2_item_border_color_down" type="text" id="sub_level_2_item_border_color_down" value="<?php echo $sub_level_2_item_border_color_down; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_2_item_border_color_down_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_item_border_color_down');"><?php echo RGB_WORD; ?></span></td>
              
            <td><input name="sub_level_2_item_border_color_active" type="text" id="sub_level_2_item_border_color_active" value="<?php echo $sub_level_2_item_border_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message fake_link" id="sub_level_2_item_border_color_active_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_item_border_color_active');"><?php echo RGB_WORD; ?></span></td>
            <td>
              	<input name="sub_level_2_border_hover_on_down" type="checkbox" id="sub_level_2_border_hover_on_down" value="1" <?php if ($sub_level_2_border_hover_on_down == 1) echo "checked='checked'"; ?>>
            </td>
              
            <td><input name="sub_level_2_item_border_width" type="text" id="sub_level_2_item_border_width" value="<?php echo $sub_level_2_item_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              <select name="sub_level_2_item_border_units" id="sub_level_2_item_border_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_item_border_width');">
                    <option value="0"<?php if ($sub_level_2_item_border_units == 0) echo " selected"; ?>>px</option>
                    <option value="1"<?php if ($sub_level_2_item_border_units == 1) echo " selected"; ?>>%</option>
                    <option value="2"<?php if ($sub_level_2_item_border_units == 2) echo " selected"; ?>>em</option>
                    <option value="3"<?php if ($sub_level_2_item_border_units == 4) echo " selected"; ?>>pt</option>
                    <option value="4"<?php if ($sub_level_2_item_border_units == 5) echo " selected"; ?>>pc</option>
                    <option value="5"<?php if ($sub_level_2_item_border_units == 6) echo " selected"; ?>>cm</option>
                    <option value="6"<?php if ($sub_level_2_item_border_units == 7) echo " selected"; ?>>mm</option>
                    <option value="7"<?php if ($sub_level_2_item_border_units == 8) echo " selected"; ?>>in</option>
                    <option value="8"<?php if ($sub_level_2_item_border_units == 9) echo " selected"; ?>>rem</option>
                    <option value="9"<?php if ($sub_level_2_item_border_units == 10) echo " selected"; ?>>vw</option>
                    <option value="10"<?php if ($sub_level_2_item_border_units == 11) echo " selected"; ?>>vh</option>
                    <option value="11"<?php if ($sub_level_2_item_border_units == 12) echo " selected"; ?>>vmin</option>
                    <option value="12"<?php if ($sub_level_2_item_border_units == 13) echo " selected"; ?>>vmax</option>
                    <option value="13"<?php if ($sub_level_2_item_border_units == 14) echo " selected"; ?>>ch</option>
                </select>
              </td>
              <td>
	             <select name="sub_level_2_item_border_style" id="sub_level_2_item_border_style">
                 <option value="-not selected-" class="not_set"<?php if ($sub_level_2_item_border_style == "-not selected-") echo " selected"; ?>><?php echo _NOT_SELECTED_; ?></option>
                 <option value="none"<?php if ($sub_level_2_item_border_style == "none") echo " selected"; ?>><?php echo NONE_WORD; ?></option>
                 <option value="hidden"<?php if ($sub_level_2_item_border_style == "hidden") echo " selected"; ?>><?php echo HIDDEN_WORD; ?></option>
                 <option value="dotted"<?php if ($sub_level_2_item_border_style == "dotted") echo " selected"; ?>><?php echo DOTTED_WORD; ?></option>
                 <option value="dashed"<?php if ($sub_level_2_item_border_style == "dashed") echo " selected"; ?>><?php echo DASHED_WORD; ?></option>
                 <option value="solid"<?php if ($sub_level_2_item_border_style == "solid") echo " selected"; ?>><?php echo SOLID_WORD; ?></option>
                 <option value="double"<?php if ($sub_level_2_item_border_style == "double") echo " selected"; ?>><?php echo DOUBLE_WORD; ?></option>
                 <option value="groove"<?php if ($sub_level_2_item_border_style == "groove") echo " selected"; ?>><?php echo GROOVE_WORD; ?></option>
                 <option value="ridge"<?php if ($sub_level_2_item_border_style == "ridge") echo " selected"; ?>><?php echo RIDGE_WORD; ?></option>
                 <option value="inset"<?php if ($sub_level_2_item_border_style == "inset") echo " selected"; ?>><?php echo INSET_WORD; ?></option>
                 <option value="outset"<?php if ($sub_level_2_item_border_style == "outset") echo " selected"; ?>><?php echo OUTSET_WORD; ?></option>
                 <option value="initial"<?php if ($sub_level_2_item_border_style == "initial") echo " selected"; ?>><?php echo INITIAL_WORD; ?></option>
                 <option value="inherit"<?php if ($sub_level_2_item_border_style == "inherit") echo " selected"; ?>><?php echo INHERIT_WORD; ?></option>
                 </select>
              </td>
              <td>
              	<input name="sub_level_2_item_border_top" type="checkbox" id="sub_level_2_item_border_top" value="1" <?php if ($sub_level_2_item_border_top == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_2');">
              </td>
              <td><input name="sub_level_2_item_border_bottom" type="checkbox" id="sub_level_2_item_border_bottom" value="1" <?php if ($sub_level_2_item_border_bottom == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_2');">
              </td>
              <td>
              	<input name="sub_level_2_item_border_left" type="checkbox" id="sub_level_2_item_border_left" value="1" <?php if ($sub_level_2_item_border_left == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_2');">
              </td>
              <td>
              	<input name="sub_level_2_item_border_right" type="checkbox" id="sub_level_2_item_border_right" value="1" <?php if ($sub_level_2_item_border_right == 1) echo "checked='checked'"; ?> onChange="CheckItemBorder(this.checked, 'sub_level_2');">
              </td>
              <td>
              	<input name="sub_level_2_item_omit_adjacent_border" type="checkbox" id="sub_level_2_item_omit_adjacent_border" value="1" <?php if ($sub_level_2_item_omit_adjacent_border == 1) echo "checked='checked'"; ?> onChange="CheckItemBorderSettings('sub_level_2');">
              </td>
       	  </tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td bgcolor="#99BBFF">
    <table width="100%" class="layout_box_table">
      <tr>
      	<td class="bold" colspan="5"><?php echo BORDER_RADIUS; ?></td>
      </tr>
      
      <tr>
        <td>&nbsp;</td>
        <td class="bold"><?php echo EDIT_CSS_TOP_LEFT; ?></td>
         <td class="bold"><?php echo EDIT_CSS_TOP_RIGHT; ?></td>
         <td class="bold"><?php echo EDIT_CSS_BOTTOM_RIGHT; ?></td>
         <td class="bold"><?php echo EDIT_CSS_BOTTOM_LEFT; ?></td>
         </tr>
         
      <tr>
        <td align="right"><?php echo EDIT_MENU_ITEMS_TOP_LEVEL; ?>:</td>
        <td>
            <input name="top_level_radius_top_left" type="text" id="top_level_radius_top_left" value="<?php echo $top_level_radius_top_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="top_level_radius_top_left_units" id="top_level_radius_top_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_radius_top_left', 0);">
                <option value="0"<?php if ($top_level_radius_top_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_radius_top_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_radius_top_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_radius_top_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_radius_top_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_radius_top_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_radius_top_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_radius_top_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_radius_top_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_radius_top_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_radius_top_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_radius_top_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_radius_top_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_radius_top_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="top_level_radius_top_right" type="text" id="top_level_radius_top_right" value="<?php echo $top_level_radius_top_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="top_level_radius_top_right_units" id="top_level_radius_top_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_radius_top_right', 0);">
                <option value="0"<?php if ($top_level_radius_top_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_radius_top_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_radius_top_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_radius_top_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_radius_top_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_radius_top_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_radius_top_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_radius_top_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_radius_top_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_radius_top_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_radius_top_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_radius_top_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_radius_top_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_radius_top_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="top_level_radius_bottom_right" type="text" id="top_level_radius_bottom_right" value="<?php echo $top_level_radius_bottom_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="top_level_radius_bottom_right_units" id="top_level_radius_bottom_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_radius_bottom_right', 0);">
                <option value="0"<?php if ($top_level_radius_bottom_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_radius_bottom_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_radius_bottom_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_radius_bottom_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_radius_bottom_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_radius_bottom_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_radius_bottom_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_radius_bottom_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_radius_bottom_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_radius_bottom_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_radius_bottom_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_radius_bottom_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_radius_bottom_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_radius_bottom_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="top_level_radius_bottom_left" type="text" id="top_level_radius_bottom_left" value="<?php echo $top_level_radius_bottom_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="top_level_radius_bottom_left_units" id="top_level_radius_bottom_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'top_level_radius_bottom_left', 0);">
                <option value="0"<?php if ($top_level_radius_bottom_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($top_level_radius_bottom_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($top_level_radius_bottom_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($top_level_radius_bottom_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($top_level_radius_bottom_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($top_level_radius_bottom_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($top_level_radius_bottom_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($top_level_radius_bottom_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($top_level_radius_bottom_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($top_level_radius_bottom_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($top_level_radius_bottom_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($top_level_radius_bottom_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($top_level_radius_bottom_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($top_level_radius_bottom_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         </tr>
         
         <tr>
        <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1; ?>:</td>
        <td>
            <input name="sub_level_1_radius_top_left" type="text" id="sub_level_1_radius_top_left" value="<?php echo $sub_level_1_radius_top_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_1_radius_top_left_units" id="sub_level_1_radius_top_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_radius_top_left', 0);">
                <option value="0"<?php if ($sub_level_1_radius_top_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_radius_top_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_radius_top_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_radius_top_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_radius_top_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_radius_top_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_radius_top_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_radius_top_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_radius_top_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_radius_top_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_radius_top_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_radius_top_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_radius_top_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_radius_top_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="sub_level_1_radius_top_right" type="text" id="sub_level_1_radius_top_right" value="<?php echo $sub_level_1_radius_top_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_1_radius_top_right_units" id="sub_level_1_radius_top_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_radius_top_right', 0);">
                <option value="0"<?php if ($sub_level_1_radius_top_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_radius_top_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_radius_top_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_radius_top_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_radius_top_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_radius_top_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_radius_top_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_radius_top_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_radius_top_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_radius_top_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_radius_top_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_radius_top_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_radius_top_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_radius_top_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="sub_level_1_radius_bottom_right" type="text" id="sub_level_1_radius_bottom_right" value="<?php echo $sub_level_1_radius_bottom_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_1_radius_bottom_right_units" id="sub_level_1_radius_bottom_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_radius_bottom_right', 0);">
                <option value="0"<?php if ($sub_level_1_radius_bottom_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_radius_bottom_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_radius_bottom_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_radius_bottom_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_radius_bottom_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_radius_bottom_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_radius_bottom_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_radius_bottom_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_radius_bottom_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_radius_bottom_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_radius_bottom_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_radius_bottom_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_radius_bottom_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_radius_bottom_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="sub_level_1_radius_bottom_left" type="text" id="sub_level_1_radius_bottom_left" value="<?php echo $sub_level_1_radius_bottom_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_1_radius_bottom_left_units" id="sub_level_1_radius_bottom_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_1_radius_bottom_left', 0);">
                <option value="0"<?php if ($sub_level_1_radius_bottom_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_1_radius_bottom_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_1_radius_bottom_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_1_radius_bottom_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_1_radius_bottom_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_1_radius_bottom_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_1_radius_bottom_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_1_radius_bottom_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_1_radius_bottom_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_1_radius_bottom_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_1_radius_bottom_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_1_radius_bottom_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_1_radius_bottom_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_1_radius_bottom_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         </tr>
         
         <tr>
        <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2; ?>:</td>
        <td>
            <input name="sub_level_2_radius_top_left" type="text" id="sub_level_2_radius_top_left" value="<?php echo $sub_level_2_radius_top_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
            <select name="sub_level_2_radius_top_left_units" id="sub_level_2_radius_top_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_radius_top_left', 0);">
                <option value="0"<?php if ($sub_level_2_radius_top_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_radius_top_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_radius_top_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_radius_top_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_radius_top_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_radius_top_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_radius_top_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_radius_top_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_radius_top_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_radius_top_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_radius_top_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_radius_top_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_radius_top_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_radius_top_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="sub_level_2_radius_top_right" type="text" id="sub_level_2_radius_top_right" value="<?php echo $sub_level_2_radius_top_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_2_radius_top_right_units" id="sub_level_2_radius_top_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_radius_top_right', 0);">
                <option value="0"<?php if ($sub_level_2_radius_top_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_radius_top_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_radius_top_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_radius_top_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_radius_top_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_radius_top_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_radius_top_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_radius_top_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_radius_top_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_radius_top_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_radius_top_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_radius_top_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_radius_top_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_radius_top_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="sub_level_2_radius_bottom_right" type="text" id="sub_level_2_radius_bottom_right" value="<?php echo $sub_level_2_radius_bottom_right; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_2_radius_bottom_right_units" id="sub_level_2_radius_bottom_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_radius_bottom_right', 0);">
                <option value="0"<?php if ($sub_level_2_radius_bottom_right_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_radius_bottom_right_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_radius_bottom_right_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_radius_bottom_right_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_radius_bottom_right_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_radius_bottom_right_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_radius_bottom_right_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_radius_bottom_right_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_radius_bottom_right_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_radius_bottom_right_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_radius_bottom_right_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_radius_bottom_right_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_radius_bottom_right_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_radius_bottom_right_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         <td>
          <input name="sub_level_2_radius_bottom_left" type="text" id="sub_level_2_radius_bottom_left" value="<?php echo $sub_level_2_radius_bottom_left; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
          <select name="sub_level_2_radius_bottom_left_units" id="sub_level_2_radius_bottom_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'sub_level_2_radius_bottom_left', 0);">
                <option value="0"<?php if ($sub_level_2_radius_bottom_left_units == 0) echo " selected='selected'"; ?>>px</option>
                <option value="1"<?php if ($sub_level_2_radius_bottom_left_units == 1) echo " selected='selected'"; ?>>%</option>
                <option value="2"<?php if ($sub_level_2_radius_bottom_left_units == 2) echo " selected='selected'"; ?>>em</option>
                <option value="3"<?php if ($sub_level_2_radius_bottom_left_units == 3) echo " selected='selected'"; ?>>pt</option>
                <option value="4"<?php if ($sub_level_2_radius_bottom_left_units == 4) echo " selected='selected'"; ?>>pc</option>
                <option value="5"<?php if ($sub_level_2_radius_bottom_left_units == 5) echo " selected='selected'"; ?>>cm</option>
                <option value="6"<?php if ($sub_level_2_radius_bottom_left_units == 6) echo " selected='selected'"; ?>>mm</option>
                <option value="7"<?php if ($sub_level_2_radius_bottom_left_units == 7) echo " selected='selected'"; ?>>in</option>
                <option value="8"<?php if ($sub_level_2_radius_bottom_left_units == 8) echo " selected='selected'"; ?>>rem</option>
                <option value="9"<?php if ($sub_level_2_radius_bottom_left_units == 9) echo " selected='selected'"; ?>>vw</option>
                <option value="10"<?php if ($sub_level_2_radius_bottom_left_units == 10) echo " selected='selected'"; ?>>vh</option>
                <option value="11"<?php if ($sub_level_2_radius_bottom_left_units == 11) echo " selected='selected'"; ?>>vmin</option>
                <option value="12"<?php if ($sub_level_2_radius_bottom_left_units == 12) echo " selected='selected'"; ?>>vmax</option>
                <option value="13"<?php if ($sub_level_2_radius_bottom_left_units == 13) echo " selected='selected'"; ?>>ch</option>
            </select>
         </td>
         </tr>
        </table> 
    </td>
  </tr>
  <tr>
    <td bgcolor="#FFBB99">
    
    
    <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
      <tr>
        <td class="bold" colspan="5"><?php echo BOX_SHADOW; ?></td>
        <td class="bold" colspan="4" style="text-align:center; border-top:#000 thin solid; border-left:#000 thin solid; border-right:#000 thin solid;"><?php echo COLOR_WORD; ?></td>
        <td>&nbsp;</td>
      </tr>
      <tr>
        <td>&nbsp;</td>
        <td class="bold"><?php echo HORIZONTAL_OFFSET; ?></td>
        <td class="bold"><?php echo VERTICAL_OFFSET; ?></td>
        <td class="bold"><?php echo BLUR_WORD; ?></td>
        <td class="bold"><?php echo SPREAD_WORD; ?></td>
        <td><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td>
        <td><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td>
        <td><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td>
        <td><?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?></td>
        <td class="bold"><?php echo INSET_WORD; ?></td>
      </tr>
      
      <tr>
        <td align="right"><?php echo EDIT_MENU_ITEMS_TOP_LEVEL; ?>:</td>
        <td><input type="text" name="top_level_box_shadow_horizontal" id="top_level_box_shadow_horizontal" value="<?php echo $top_level_box_shadow_horizontal; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="top_level_box_shadow_vertical" id="top_level_box_shadow_vertical" value="<?php echo $top_level_box_shadow_vertical; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="top_level_box_shadow_blur" id="top_level_box_shadow_blur" value="<?php echo $top_level_box_shadow_blur; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="top_level_box_shadow_spread" id="top_level_box_shadow_spread" value="<?php echo $top_level_box_shadow_spread; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td>
        <input type="text" name="top_level_box_shadow_color" id="top_level_box_shadow_color" value="<?php echo $top_level_box_shadow_color; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_box_shadow_color');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="top_level_box_shadow_color_hover" id="top_level_box_shadow_color_hover" value="<?php echo $top_level_box_shadow_color_hover; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_box_shadow_color_hover');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="top_level_box_shadow_color_down" id="top_level_box_shadow_color_down" value="<?php echo $top_level_box_shadow_color_down; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_box_shadow_color_down');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="top_level_box_shadow_color_active" id="top_level_box_shadow_color_active" value="<?php echo $top_level_box_shadow_color_active; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_box_shadow_color_active');"><?php echo RGB_WORD; ?></span>
         </td>
        <td><input type="checkbox" name="top_level_box_shadow_inset" id="top_level_box_shadow_inset" value="1"<?php if ($top_level_box_shadow_inset == 1) echo " checked='checked'"; ?> /></td>
      </tr>
      
      <tr>
        <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1; ?>:</td>
        <td><input type="text" name="sub_level_1_box_shadow_horizontal" id="sub_level_1_box_shadow_horizontal" value="<?php echo $sub_level_1_box_shadow_horizontal; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="sub_level_1_box_shadow_vertical" id="sub_level_1_box_shadow_vertical" value="<?php echo $sub_level_1_box_shadow_vertical; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="sub_level_1_box_shadow_blur" id="sub_level_1_box_shadow_blur" value="<?php echo $sub_level_1_box_shadow_blur; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="sub_level_1_box_shadow_spread" id="sub_level_1_box_shadow_spread" value="<?php echo $sub_level_1_box_shadow_spread; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td>
        <input type="text" name="sub_level_1_box_shadow_color" id="sub_level_1_box_shadow_color" value="<?php echo $sub_level_1_box_shadow_color; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_box_shadow_color');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="sub_level_1_box_shadow_color_hover" id="sub_level_1_box_shadow_color_hover" value="<?php echo $sub_level_1_box_shadow_color_hover; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_box_shadow_color_hover');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="sub_level_1_box_shadow_color_down" id="sub_level_1_box_shadow_color_down" value="<?php echo $sub_level_1_box_shadow_color_down; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_box_shadow_color_down');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="sub_level_1_box_shadow_color_active" id="sub_level_1_box_shadow_color_active" value="<?php echo $sub_level_1_box_shadow_color_active; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_box_shadow_color_active');"><?php echo RGB_WORD; ?></span>
         </td>
        <td><input type="checkbox" name="sub_level_1_box_shadow_inset" id="sub_level_1_box_shadow_inset" value="1"<?php if ($sub_level_1_box_shadow_inset == 1) echo " checked='checked'"; ?> /></td>
      </tr>
      
      <tr>
        <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2; ?>:</td>
        <td><input type="text" name="sub_level_2_box_shadow_horizontal" id="sub_level_2_box_shadow_horizontal" value="<?php echo $sub_level_2_box_shadow_horizontal; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="sub_level_2_box_shadow_vertical" id="sub_level_2_box_shadow_vertical" value="<?php echo $sub_level_2_box_shadow_vertical; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="sub_level_2_box_shadow_blur" id="sub_level_2_box_shadow_blur" value="<?php echo $sub_level_2_box_shadow_blur; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td><input type="text" name="sub_level_2_box_shadow_spread" id="sub_level_2_box_shadow_spread" value="<?php echo $sub_level_2_box_shadow_spread; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
        px</td>
        <td>
        <input type="text" name="sub_level_2_box_shadow_color" id="sub_level_2_box_shadow_color" value="<?php echo $sub_level_2_box_shadow_color; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_box_shadow_color');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="sub_level_2_box_shadow_color_hover" id="sub_level_2_box_shadow_color_hover" value="<?php echo $sub_level_2_box_shadow_color_hover; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_box_shadow_color_hover');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="sub_level_2_box_shadow_color_down" id="sub_level_2_box_shadow_color_down" value="<?php echo $sub_level_2_box_shadow_color_down; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_box_shadow_color_down');"><?php echo RGB_WORD; ?></span>
         </td>
         <td>
        <input type="text" name="sub_level_2_box_shadow_color_active" id="sub_level_2_box_shadow_color_active" value="<?php echo $sub_level_2_box_shadow_color_active; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
         <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_box_shadow_color_active');"><?php echo RGB_WORD; ?></span>
         </td>
        <td><input type="checkbox" name="sub_level_2_box_shadow_inset" id="sub_level_2_box_shadow_inset" value="1"<?php if ($sub_level_2_box_shadow_inset == 1) echo " checked='checked'"; ?> /></td>
      </tr>
    </table>
                
    </td>
  </tr>
  
  <tr>
    <td bgcolor="#FF99BB">
    
    <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
      <tr>
        <td colspan="8" class="bold"><?php echo BACKGROUND_GRADIENT; ?></td>
      </tr>
      
      <tr>
          <td colspan="8" class="bold" style="text-align:center; border-top:thin #000 solid; border-left:thin #000 solid; border-right:thin #000 solid;"><?php echo EDIT_MENU_ITEMS_TOP_LEVEL; ?></td>
      </tr>
      
      <tr>
      	<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td><td colspan="2">&nbsp;</td>
        <td style="padding-left:25px;" class="bold">1</td><td style="padding-left:25px;" class="bold">2</td><td style="padding-left:25px;" class="bold">3</td><td style="padding-left:25px;" class="bold">4</td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="top_level_gradient_type" id="top_level_gradient_type" onChange="enable_disable_gradient('top_level_', '');">
                <option value="0" class="not_set"<?php if ($top_level_gradient_type == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($top_level_gradient_type == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($top_level_gradient_type == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="top_level_gradient_angle" id="top_level_gradient_angle">
                <option value="180"<?php if ($top_level_gradient_angle == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($top_level_gradient_angle == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($top_level_gradient_angle == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($top_level_gradient_angle == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($top_level_gradient_angle == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($top_level_gradient_angle == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($top_level_gradient_angle == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($top_level_gradient_angle == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($top_level_gradient_angle == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($top_level_gradient_angle == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($top_level_gradient_angle == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($top_level_gradient_angle == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($top_level_gradient_angle == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($top_level_gradient_angle == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($top_level_gradient_angle == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($top_level_gradient_angle == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($top_level_gradient_angle == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($top_level_gradient_angle == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($top_level_gradient_angle == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($top_level_gradient_angle == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($top_level_gradient_angle == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($top_level_gradient_angle == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($top_level_gradient_angle == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($top_level_gradient_angle == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($top_level_gradient_angle == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($top_level_gradient_angle == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($top_level_gradient_angle == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($top_level_gradient_angle == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($top_level_gradient_angle == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($top_level_gradient_angle == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($top_level_gradient_angle == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($top_level_gradient_angle == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="top_level_gradient_color_1" id="top_level_gradient_color_1" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_1; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_1');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_2" id="top_level_gradient_color_2" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_2; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_2');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_3" id="top_level_gradient_color_3" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_3; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_3');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_4" id="top_level_gradient_color_4" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_4; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_4');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="top_level_gradient_repeat" id="top_level_gradient_repeat">
                <option value="0" class="not_set"<?php if ($top_level_gradient_repeat == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($top_level_gradient_repeat == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($top_level_gradient_repeat == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($top_level_gradient_repeat == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($top_level_gradient_repeat == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($top_level_gradient_repeat == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($top_level_gradient_repeat == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($top_level_gradient_repeat == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($top_level_gradient_repeat == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($top_level_gradient_repeat == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($top_level_gradient_repeat == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($top_level_gradient_repeat == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($top_level_gradient_repeat == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($top_level_gradient_repeat == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($top_level_gradient_repeat == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($top_level_gradient_repeat == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="top_level_gradient_opacity_1" id="top_level_gradient_opacity_1">
                <option value="100"<?php if ($top_level_gradient_opacity_1 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_1 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_1 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_1 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_1 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_1 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_1 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_1 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_1 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_1 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_1 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_2" id="top_level_gradient_opacity_2">
                <option value="100"<?php if ($top_level_gradient_opacity_2 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_2 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_2 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_2 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_2 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_2 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_2 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_2 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_2 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_2 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_2 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_3" id="top_level_gradient_opacity_3">
                <option value="100"<?php if ($top_level_gradient_opacity_3 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_3 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_3 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_3 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_3 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_3 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_3 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_3 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_3 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_3 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_3 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_4" id="top_level_gradient_opacity_4">
                <option value="100"<?php if ($top_level_gradient_opacity_4 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_4 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_4 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_4 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_4 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_4 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_4 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_4 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_4 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_4 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_4 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="top_level_gradient_type_hover" id="top_level_gradient_type_hover" onChange="enable_disable_gradient('top_level_', '_hover');">
                <option value="0" class="not_set"<?php if ($top_level_gradient_type_hover == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($top_level_gradient_type_hover == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($top_level_gradient_type_hover == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="top_level_gradient_angle_hover" id="top_level_gradient_angle_hover">
                <option value="180"<?php if ($top_level_gradient_angle_hover == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($top_level_gradient_angle_hover == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($top_level_gradient_angle_hover == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($top_level_gradient_angle_hover == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($top_level_gradient_angle_hover == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($top_level_gradient_angle_hover == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($top_level_gradient_angle_hover == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($top_level_gradient_angle_hover == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($top_level_gradient_angle_hover == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($top_level_gradient_angle_hover == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($top_level_gradient_angle_hover == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($top_level_gradient_angle_hover == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($top_level_gradient_angle_hover == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($top_level_gradient_angle_hover == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($top_level_gradient_angle_hover == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($top_level_gradient_angle_hover == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($top_level_gradient_angle_hover == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($top_level_gradient_angle_hover == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($top_level_gradient_angle_hover == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($top_level_gradient_angle_hover == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($top_level_gradient_angle_hover == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($top_level_gradient_angle_hover == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($top_level_gradient_angle_hover == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($top_level_gradient_angle_hover == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($top_level_gradient_angle_hover == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($top_level_gradient_angle_hover == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($top_level_gradient_angle_hover == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($top_level_gradient_angle_hover == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($top_level_gradient_angle_hover == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($top_level_gradient_angle_hover == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($top_level_gradient_angle_hover == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($top_level_gradient_angle_hover == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="top_level_gradient_color_1_hover" id="top_level_gradient_color_1_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_1_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_1_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_2_hover" id="top_level_gradient_color_2_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_2_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_2_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_3_hover" id="top_level_gradient_color_3_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_3_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_3_hover');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_4_hover" id="top_level_gradient_color_4_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_4_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_4_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="top_level_gradient_repeat_hover" id="top_level_gradient_repeat_hover">
                <option value="0" class="not_set"<?php if ($top_level_gradient_repeat_hover == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($top_level_gradient_repeat_hover == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($top_level_gradient_repeat_hover == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($top_level_gradient_repeat_hover == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($top_level_gradient_repeat_hover == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($top_level_gradient_repeat_hover == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($top_level_gradient_repeat_hover == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($top_level_gradient_repeat_hover == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($top_level_gradient_repeat_hover == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($top_level_gradient_repeat_hover == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($top_level_gradient_repeat_hover == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($top_level_gradient_repeat_hover == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($top_level_gradient_repeat_hover == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($top_level_gradient_repeat_hover == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($top_level_gradient_repeat_hover == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($top_level_gradient_repeat_hover == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="top_level_gradient_opacity_1_hover" id="top_level_gradient_opacity_1_hover">
                <option value="100"<?php if ($top_level_gradient_opacity_1_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_1_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_1_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_1_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_1_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_1_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_1_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_1_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_1_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_1_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_1_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_2_hover" id="top_level_gradient_opacity_2_hover">
                <option value="100"<?php if ($top_level_gradient_opacity_2_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_2_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_2_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_2_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_2_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_2_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_2_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_2_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_2_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_2_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_2_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_3_hover" id="top_level_gradient_opacity_3_hover">
                <option value="100"<?php if ($top_level_gradient_opacity_3_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_3_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_3_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_3_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_3_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_3_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_3_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_3_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_3_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_3_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_3_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_4_hover" id="top_level_gradient_opacity_4_hover">
                <option value="100"<?php if ($top_level_gradient_opacity_4_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_4_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_4_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_4_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_4_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_4_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_4_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_4_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_4_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_4_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_4_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="top_level_gradient_type_down" id="top_level_gradient_type_down" onChange="enable_disable_gradient('top_level_', '_down');">
                <option value="0" class="not_set"<?php if ($top_level_gradient_type_down == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($top_level_gradient_type_down == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($top_level_gradient_type_down == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="top_level_gradient_angle_down" id="top_level_gradient_angle_down">
                <option value="180"<?php if ($top_level_gradient_angle_down == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($top_level_gradient_angle_down == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($top_level_gradient_angle_down == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($top_level_gradient_angle_down == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($top_level_gradient_angle_down == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($top_level_gradient_angle_down == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($top_level_gradient_angle_down == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($top_level_gradient_angle_down == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($top_level_gradient_angle_down == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($top_level_gradient_angle_down == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($top_level_gradient_angle_down == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($top_level_gradient_angle_down == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($top_level_gradient_angle_down == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($top_level_gradient_angle_down == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($top_level_gradient_angle_down == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($top_level_gradient_angle_down == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($top_level_gradient_angle_down == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($top_level_gradient_angle_down == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($top_level_gradient_angle_down == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($top_level_gradient_angle_down == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($top_level_gradient_angle_down == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($top_level_gradient_angle_down == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($top_level_gradient_angle_down == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($top_level_gradient_angle_down == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($top_level_gradient_angle_down == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($top_level_gradient_angle_down == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($top_level_gradient_angle_down == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($top_level_gradient_angle_down == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($top_level_gradient_angle_down == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($top_level_gradient_angle_down == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($top_level_gradient_angle_down == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($top_level_gradient_angle_down == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="top_level_gradient_color_1_down" id="top_level_gradient_color_1_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_1_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_1_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_2_down" id="top_level_gradient_color_2_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_2_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_2_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_3_down" id="top_level_gradient_color_3_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_3_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_3_down');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_4_down" id="top_level_gradient_color_4_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_4_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_4_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
        <?php echo EDIT_CSS_MENU_STYLES_HOVER_ON_DOWN; ?>:
        </td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="top_level_gradient_repeat_down" id="top_level_gradient_repeat_down">
                <option value="0" class="not_set"<?php if ($top_level_gradient_repeat_down == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($top_level_gradient_repeat_down == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($top_level_gradient_repeat_down == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($top_level_gradient_repeat_down == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($top_level_gradient_repeat_down == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($top_level_gradient_repeat_down == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($top_level_gradient_repeat_down == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($top_level_gradient_repeat_down == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($top_level_gradient_repeat_down == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($top_level_gradient_repeat_down == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($top_level_gradient_repeat_down == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($top_level_gradient_repeat_down == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($top_level_gradient_repeat_down == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($top_level_gradient_repeat_down == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($top_level_gradient_repeat_down == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($top_level_gradient_repeat_down == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="top_level_gradient_opacity_1_down" id="top_level_gradient_opacity_1_down">
                <option value="100"<?php if ($top_level_gradient_opacity_1_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_1_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_1_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_1_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_1_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_1_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_1_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_1_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_1_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_1_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_1_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_2_down" id="top_level_gradient_opacity_2_down">
                <option value="100"<?php if ($top_level_gradient_opacity_2_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_2_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_2_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_2_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_2_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_2_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_2_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_2_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_2_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_2_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_2_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_3_down" id="top_level_gradient_opacity_3_down">
                <option value="100"<?php if ($top_level_gradient_opacity_3_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_3_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_3_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_3_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_3_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_3_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_3_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_3_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_3_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_3_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_3_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_4_down" id="top_level_gradient_opacity_4_down">
                <option value="100"<?php if ($top_level_gradient_opacity_4_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_4_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_4_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_4_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_4_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_4_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_4_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_4_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_4_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_4_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_4_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td style="text-align:center;">
        	<input name="top_level_bkgd_gradient_hover_on_down" type="checkbox" id="top_level_bkgd_gradient_hover_on_down" value="1" <?php if ($top_level_bkgd_gradient_hover_on_down == 1) echo "checked='checked'"; ?>>
        </td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="top_level_gradient_type_active" id="top_level_gradient_type_active" onChange="enable_disable_gradient('top_level_', '_active');">
                <option value="0" class="not_set"<?php if ($top_level_gradient_type_active == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($top_level_gradient_type_active == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($top_level_gradient_type_active == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="top_level_gradient_angle_active" id="top_level_gradient_angle_active">
                <option value="180"<?php if ($top_level_gradient_angle_active == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($top_level_gradient_angle_active == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($top_level_gradient_angle_active == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($top_level_gradient_angle_active == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($top_level_gradient_angle_active == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($top_level_gradient_angle_active == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($top_level_gradient_angle_active == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($top_level_gradient_angle_active == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($top_level_gradient_angle_active == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($top_level_gradient_angle_active == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($top_level_gradient_angle_active == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($top_level_gradient_angle_active == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($top_level_gradient_angle_active == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($top_level_gradient_angle_active == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($top_level_gradient_angle_active == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($top_level_gradient_angle_active == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($top_level_gradient_angle_active == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($top_level_gradient_angle_active == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($top_level_gradient_angle_active == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($top_level_gradient_angle_active == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($top_level_gradient_angle_active == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($top_level_gradient_angle_active == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($top_level_gradient_angle_active == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($top_level_gradient_angle_active == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($top_level_gradient_angle_active == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($top_level_gradient_angle_active == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($top_level_gradient_angle_active == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($top_level_gradient_angle_active == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($top_level_gradient_angle_active == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($top_level_gradient_angle_active == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($top_level_gradient_angle_active == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($top_level_gradient_angle_active == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="top_level_gradient_color_1_active" id="top_level_gradient_color_1_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_1_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_1_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_2_active" id="top_level_gradient_color_2_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_2_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_2_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_3_active" id="top_level_gradient_color_3_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_3_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_3_active');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="top_level_gradient_color_4_active" id="top_level_gradient_color_4_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $top_level_gradient_color_4_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_gradient_color_4_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="top_level_gradient_repeat_active" id="top_level_gradient_repeat_active">
                <option value="0" class="not_set"<?php if ($top_level_gradient_repeat_active == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($top_level_gradient_repeat_active == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($top_level_gradient_repeat_active == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($top_level_gradient_repeat_active == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($top_level_gradient_repeat_active == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($top_level_gradient_repeat_active == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($top_level_gradient_repeat_active == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($top_level_gradient_repeat_active == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($top_level_gradient_repeat_active == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($top_level_gradient_repeat_active == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($top_level_gradient_repeat_active == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($top_level_gradient_repeat_active == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($top_level_gradient_repeat_active == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($top_level_gradient_repeat_active == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($top_level_gradient_repeat_active == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($top_level_gradient_repeat_active == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="top_level_gradient_opacity_1_active" id="top_level_gradient_opacity_1_active">
                <option value="100"<?php if ($top_level_gradient_opacity_1_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_1_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_1_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_1_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_1_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_1_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_1_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_1_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_1_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_1_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_1_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_2_active" id="top_level_gradient_opacity_2_active">
                <option value="100"<?php if ($top_level_gradient_opacity_2_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_2_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_2_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_2_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_2_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_2_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_2_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_2_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_2_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_2_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_2_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_3_active" id="top_level_gradient_opacity_3_active">
                <option value="100"<?php if ($top_level_gradient_opacity_3_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_3_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_3_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_3_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_3_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_3_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_3_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_3_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_3_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_3_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_3_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="top_level_gradient_opacity_4_active" id="top_level_gradient_opacity_4_active">
                <option value="100"<?php if ($top_level_gradient_opacity_4_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($top_level_gradient_opacity_4_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($top_level_gradient_opacity_4_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($top_level_gradient_opacity_4_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($top_level_gradient_opacity_4_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($top_level_gradient_opacity_4_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($top_level_gradient_opacity_4_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($top_level_gradient_opacity_4_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($top_level_gradient_opacity_4_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($top_level_gradient_opacity_4_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($top_level_gradient_opacity_4_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
          <td colspan="8" class="bold" style="text-align:center; border-top:thin #000 solid; border-left:thin #000 solid; border-right:thin #000 solid;"><?php echo EDIT_MENU_ITEMS_1ST_SUB_LEVEL; ?></td>
      </tr>
      
      <tr>
      	<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td><td colspan="2">&nbsp;</td>
        <td style="padding-left:25px;" class="bold">1</td><td style="padding-left:25px;" class="bold">2</td><td style="padding-left:25px;" class="bold">3</td><td style="padding-left:25px;" class="bold">4</td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_1_gradient_type" id="sub_level_1_gradient_type" onChange="enable_disable_gradient('sub_level_1_', '');">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_type == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_1_gradient_type == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_type == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_1_gradient_angle" id="sub_level_1_gradient_angle">
                <option value="180"<?php if ($sub_level_1_gradient_angle == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_1_gradient_angle == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_1_gradient_angle == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_1_gradient_angle == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_1_gradient_angle == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_1_gradient_angle == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_1_gradient_angle == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_1_gradient_angle == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_1_gradient_angle == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_1_gradient_angle == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_1_gradient_angle == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_1_gradient_angle == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_1_gradient_angle == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_1_gradient_angle == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_1_gradient_angle == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_1_gradient_angle == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_1_gradient_angle == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_1_gradient_angle == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_1_gradient_angle == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_1_gradient_angle == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_1_gradient_angle == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_1_gradient_angle == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_1_gradient_angle == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_1_gradient_angle == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_1_gradient_angle == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_1_gradient_angle == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_1_gradient_angle == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_1_gradient_angle == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_1_gradient_angle == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_1_gradient_angle == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_1_gradient_angle == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_1_gradient_angle == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_1_gradient_color_1" id="sub_level_1_gradient_color_1" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_1; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_1');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_2" id="sub_level_1_gradient_color_2" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_2; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_2');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_3" id="sub_level_1_gradient_color_3" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_3; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_3');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_4" id="sub_level_1_gradient_color_4" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_4; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_4');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_1_gradient_repeat" id="sub_level_1_gradient_repeat">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_repeat == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_repeat == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_1_gradient_repeat == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_1_gradient_repeat == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_1_gradient_repeat == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_1_gradient_repeat == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_1_gradient_repeat == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_1_gradient_repeat == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_1_gradient_repeat == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_1_gradient_repeat == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_1_gradient_repeat == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_1_gradient_repeat == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_1_gradient_repeat == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_1_gradient_repeat == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_1_gradient_repeat == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_1_gradient_repeat == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_1_gradient_opacity_1" id="sub_level_1_gradient_opacity_1">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_1 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_1 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_1 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_1 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_1 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_1 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_1 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_1 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_1 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_1 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_1 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_2" id="sub_level_1_gradient_opacity_2">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_2 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_2 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_2 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_2 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_2 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_2 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_2 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_2 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_2 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_2 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_2 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_3" id="sub_level_1_gradient_opacity_3">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_3 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_3 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_3 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_3 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_3 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_3 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_3 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_3 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_3 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_3 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_3 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_4" id="sub_level_1_gradient_opacity_4">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_4 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_4 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_4 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_4 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_4 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_4 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_4 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_4 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_4 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_4 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_4 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_1_gradient_type_hover" id="sub_level_1_gradient_type_hover" onChange="enable_disable_gradient('sub_level_1_', '_hover');">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_type_hover == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_1_gradient_type_hover == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_type_hover == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_1_gradient_angle_hover" id="sub_level_1_gradient_angle_hover">
                <option value="180"<?php if ($sub_level_1_gradient_angle_hover == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_1_gradient_angle_hover == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_1_gradient_angle_hover == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_1_gradient_angle_hover == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_1_gradient_angle_hover == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_1_gradient_angle_hover == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_1_gradient_angle_hover == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_1_gradient_angle_hover == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_1_gradient_angle_hover == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_1_gradient_angle_hover == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_1_gradient_angle_hover == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_1_gradient_angle_hover == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_1_gradient_angle_hover == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_1_gradient_angle_hover == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_1_gradient_angle_hover == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_1_gradient_angle_hover == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_1_gradient_angle_hover == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_1_gradient_angle_hover == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_1_gradient_angle_hover == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_1_gradient_angle_hover == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_1_gradient_angle_hover == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_1_gradient_angle_hover == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_1_gradient_angle_hover == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_1_gradient_angle_hover == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_1_gradient_angle_hover == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_1_gradient_angle_hover == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_1_gradient_angle_hover == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_1_gradient_angle_hover == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_1_gradient_angle_hover == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_1_gradient_angle_hover == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_1_gradient_angle_hover == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_1_gradient_angle_hover == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_1_gradient_color_1_hover" id="sub_level_1_gradient_color_1_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_1_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_1_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_2_hover" id="sub_level_1_gradient_color_2_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_2_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_2_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_3_hover" id="sub_level_1_gradient_color_3_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_3_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_3_hover');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_4_hover" id="sub_level_1_gradient_color_4_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_4_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_4_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_1_gradient_repeat_hover" id="sub_level_1_gradient_repeat_hover">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_repeat_hover == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_repeat_hover == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_1_gradient_repeat_hover == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_1_gradient_repeat_hover == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_1_gradient_repeat_hover == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_1_gradient_repeat_hover == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_1_gradient_repeat_hover == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_1_gradient_repeat_hover == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_1_gradient_repeat_hover == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_1_gradient_repeat_hover == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_1_gradient_repeat_hover == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_1_gradient_repeat_hover == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_1_gradient_repeat_hover == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_1_gradient_repeat_hover == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_1_gradient_repeat_hover == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_1_gradient_repeat_hover == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_1_gradient_opacity_1_hover" id="sub_level_1_gradient_opacity_1_hover">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_1_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_1_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_1_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_1_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_1_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_1_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_1_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_1_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_1_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_1_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_1_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_2_hover" id="sub_level_1_gradient_opacity_2_hover">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_2_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_2_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_2_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_2_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_2_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_2_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_2_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_2_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_2_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_2_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_2_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_3_hover" id="sub_level_1_gradient_opacity_3_hover">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_3_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_3_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_3_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_3_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_3_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_3_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_3_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_3_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_3_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_3_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_3_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_4_hover" id="sub_level_1_gradient_opacity_4_hover">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_4_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_4_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_4_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_4_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_4_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_4_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_4_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_4_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_4_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_4_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_4_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_1_gradient_type_down" id="sub_level_1_gradient_type_down" onChange="enable_disable_gradient('sub_level_1_', '_down');">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_type_down == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_1_gradient_type_down == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_type_down == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_1_gradient_angle_down" id="sub_level_1_gradient_angle_down">
                <option value="180"<?php if ($sub_level_1_gradient_angle_down == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_1_gradient_angle_down == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_1_gradient_angle_down == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_1_gradient_angle_down == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_1_gradient_angle_down == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_1_gradient_angle_down == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_1_gradient_angle_down == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_1_gradient_angle_down == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_1_gradient_angle_down == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_1_gradient_angle_down == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_1_gradient_angle_down == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_1_gradient_angle_down == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_1_gradient_angle_down == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_1_gradient_angle_down == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_1_gradient_angle_down == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_1_gradient_angle_down == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_1_gradient_angle_down == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_1_gradient_angle_down == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_1_gradient_angle_down == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_1_gradient_angle_down == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_1_gradient_angle_down == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_1_gradient_angle_down == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_1_gradient_angle_down == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_1_gradient_angle_down == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_1_gradient_angle_down == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_1_gradient_angle_down == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_1_gradient_angle_down == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_1_gradient_angle_down == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_1_gradient_angle_down == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_1_gradient_angle_down == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_1_gradient_angle_down == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_1_gradient_angle_down == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_1_gradient_color_1_down" id="sub_level_1_gradient_color_1_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_1_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_1_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_2_down" id="sub_level_1_gradient_color_2_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_2_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_2_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_3_down" id="sub_level_1_gradient_color_3_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_3_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_3_down');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_4_down" id="sub_level_1_gradient_color_4_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_4_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_4_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
        <?php echo EDIT_CSS_MENU_STYLES_HOVER_ON_DOWN; ?>:
        </td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_1_gradient_repeat_down" id="sub_level_1_gradient_repeat_down">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_repeat_down == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_repeat_down == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_1_gradient_repeat_down == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_1_gradient_repeat_down == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_1_gradient_repeat_down == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_1_gradient_repeat_down == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_1_gradient_repeat_down == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_1_gradient_repeat_down == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_1_gradient_repeat_down == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_1_gradient_repeat_down == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_1_gradient_repeat_down == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_1_gradient_repeat_down == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_1_gradient_repeat_down == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_1_gradient_repeat_down == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_1_gradient_repeat_down == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_1_gradient_repeat_down == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_1_gradient_opacity_1_down" id="sub_level_1_gradient_opacity_1_down">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_1_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_1_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_1_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_1_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_1_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_1_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_1_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_1_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_1_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_1_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_1_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_2_down" id="sub_level_1_gradient_opacity_2_down">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_2_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_2_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_2_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_2_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_2_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_2_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_2_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_2_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_2_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_2_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_2_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_3_down" id="sub_level_1_gradient_opacity_3_down">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_3_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_3_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_3_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_3_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_3_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_3_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_3_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_3_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_3_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_3_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_3_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_4_down" id="sub_level_1_gradient_opacity_4_down">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_4_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_4_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_4_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_4_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_4_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_4_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_4_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_4_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_4_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_4_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_4_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td style="text-align:center;">
        	<input name="sub_level_1_bkgd_gradient_hover_on_down" type="checkbox" id="sub_level_1_bkgd_gradient_hover_on_down" value="1" <?php if ($sub_level_1_bkgd_gradient_hover_on_down == 1) echo "checked='checked'"; ?>>
        </td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_1_gradient_type_active" id="sub_level_1_gradient_type_active" onChange="enable_disable_gradient('sub_level_1_', '_active');">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_type_active == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_1_gradient_type_active == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_type_active == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_1_gradient_angle_active" id="sub_level_1_gradient_angle_active">
                <option value="180"<?php if ($sub_level_1_gradient_angle_active == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_1_gradient_angle_active == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_1_gradient_angle_active == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_1_gradient_angle_active == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_1_gradient_angle_active == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_1_gradient_angle_active == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_1_gradient_angle_active == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_1_gradient_angle_active == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_1_gradient_angle_active == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_1_gradient_angle_active == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_1_gradient_angle_active == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_1_gradient_angle_active == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_1_gradient_angle_active == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_1_gradient_angle_active == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_1_gradient_angle_active == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_1_gradient_angle_active == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_1_gradient_angle_active == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_1_gradient_angle_active == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_1_gradient_angle_active == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_1_gradient_angle_active == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_1_gradient_angle_active == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_1_gradient_angle_active == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_1_gradient_angle_active == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_1_gradient_angle_active == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_1_gradient_angle_active == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_1_gradient_angle_active == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_1_gradient_angle_active == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_1_gradient_angle_active == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_1_gradient_angle_active == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_1_gradient_angle_active == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_1_gradient_angle_active == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_1_gradient_angle_active == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_1_gradient_color_1_active" id="sub_level_1_gradient_color_1_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_1_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_1_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_2_active" id="sub_level_1_gradient_color_2_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_2_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_2_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_3_active" id="sub_level_1_gradient_color_3_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_3_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_3_active');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_1_gradient_color_4_active" id="sub_level_1_gradient_color_4_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_1_gradient_color_4_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_gradient_color_4_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_1_gradient_repeat_active" id="sub_level_1_gradient_repeat_active">
                <option value="0" class="not_set"<?php if ($sub_level_1_gradient_repeat_active == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_1_gradient_repeat_active == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_1_gradient_repeat_active == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_1_gradient_repeat_active == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_1_gradient_repeat_active == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_1_gradient_repeat_active == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_1_gradient_repeat_active == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_1_gradient_repeat_active == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_1_gradient_repeat_active == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_1_gradient_repeat_active == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_1_gradient_repeat_active == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_1_gradient_repeat_active == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_1_gradient_repeat_active == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_1_gradient_repeat_active == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_1_gradient_repeat_active == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_1_gradient_repeat_active == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_1_gradient_opacity_1_active" id="sub_level_1_gradient_opacity_1_active">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_1_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_1_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_1_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_1_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_1_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_1_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_1_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_1_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_1_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_1_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_1_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_2_active" id="sub_level_1_gradient_opacity_2_active">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_2_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_2_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_2_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_2_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_2_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_2_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_2_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_2_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_2_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_2_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_2_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_3_active" id="sub_level_1_gradient_opacity_3_active">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_3_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_3_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_3_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_3_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_3_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_3_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_3_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_3_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_3_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_3_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_3_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_1_gradient_opacity_4_active" id="sub_level_1_gradient_opacity_4_active">
                <option value="100"<?php if ($sub_level_1_gradient_opacity_4_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_1_gradient_opacity_4_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_1_gradient_opacity_4_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_1_gradient_opacity_4_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_1_gradient_opacity_4_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_1_gradient_opacity_4_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_1_gradient_opacity_4_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_1_gradient_opacity_4_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_1_gradient_opacity_4_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_1_gradient_opacity_4_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_1_gradient_opacity_4_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
          <td colspan="8" class="bold" style="text-align:center; border-top:thin #000 solid; border-left:thin #000 solid; border-right:thin #000 solid;"><?php echo EDIT_MENU_ITEMS_2ND_SUB_LEVEL; ?></td>
      </tr>
      
      <tr>
      	<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td><td colspan="2">&nbsp;</td>
        <td style="padding-left:25px;" class="bold">1</td><td style="padding-left:25px;" class="bold">2</td><td style="padding-left:25px;" class="bold">3</td><td style="padding-left:25px;" class="bold">4</td>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_2_gradient_type" id="sub_level_2_gradient_type" onChange="enable_disable_gradient('sub_level_2_', '');">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_type == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_2_gradient_type == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_type == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_2_gradient_angle" id="sub_level_2_gradient_angle">
                <option value="180"<?php if ($sub_level_2_gradient_angle == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_2_gradient_angle == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_2_gradient_angle == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_2_gradient_angle == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_2_gradient_angle == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_2_gradient_angle == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_2_gradient_angle == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_2_gradient_angle == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_2_gradient_angle == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_2_gradient_angle == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_2_gradient_angle == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_2_gradient_angle == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_2_gradient_angle == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_2_gradient_angle == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_2_gradient_angle == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_2_gradient_angle == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_2_gradient_angle == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_2_gradient_angle == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_2_gradient_angle == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_2_gradient_angle == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_2_gradient_angle == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_2_gradient_angle == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_2_gradient_angle == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_2_gradient_angle == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_2_gradient_angle == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_2_gradient_angle == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_2_gradient_angle == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_2_gradient_angle == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_2_gradient_angle == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_2_gradient_angle == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_2_gradient_angle == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_2_gradient_angle == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_2_gradient_color_1" id="sub_level_2_gradient_color_1" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_1; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_1');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_2" id="sub_level_2_gradient_color_2" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_2; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_2');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_3" id="sub_level_2_gradient_color_3" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_3; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_3');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_4" id="sub_level_2_gradient_color_4" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_4; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_4');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_2_gradient_repeat" id="sub_level_2_gradient_repeat">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_repeat == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_repeat == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_2_gradient_repeat == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_2_gradient_repeat == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_2_gradient_repeat == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_2_gradient_repeat == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_2_gradient_repeat == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_2_gradient_repeat == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_2_gradient_repeat == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_2_gradient_repeat == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_2_gradient_repeat == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_2_gradient_repeat == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_2_gradient_repeat == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_2_gradient_repeat == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_2_gradient_repeat == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_2_gradient_repeat == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_2_gradient_opacity_1" id="sub_level_2_gradient_opacity_1">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_1 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_1 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_1 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_1 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_1 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_1 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_1 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_1 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_1 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_1 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_1 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_2" id="sub_level_2_gradient_opacity_2">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_2 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_2 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_2 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_2 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_2 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_2 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_2 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_2 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_2 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_2 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_2 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_3" id="sub_level_2_gradient_opacity_3">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_3 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_3 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_3 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_3 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_3 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_3 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_3 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_3 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_3 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_3 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_3 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_4" id="sub_level_2_gradient_opacity_4">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_4 == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_4 == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_4 == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_4 == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_4 == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_4 == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_4 == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_4 == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_4 == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_4 == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_4 == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_2_gradient_type_hover" id="sub_level_2_gradient_type_hover" onChange="enable_disable_gradient('sub_level_2_', '_hover');">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_type_hover == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_2_gradient_type_hover == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_type_hover == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_2_gradient_angle_hover" id="sub_level_2_gradient_angle_hover">
                <option value="180"<?php if ($sub_level_2_gradient_angle_hover == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_2_gradient_angle_hover == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_2_gradient_angle_hover == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_2_gradient_angle_hover == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_2_gradient_angle_hover == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_2_gradient_angle_hover == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_2_gradient_angle_hover == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_2_gradient_angle_hover == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_2_gradient_angle_hover == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_2_gradient_angle_hover == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_2_gradient_angle_hover == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_2_gradient_angle_hover == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_2_gradient_angle_hover == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_2_gradient_angle_hover == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_2_gradient_angle_hover == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_2_gradient_angle_hover == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_2_gradient_angle_hover == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_2_gradient_angle_hover == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_2_gradient_angle_hover == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_2_gradient_angle_hover == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_2_gradient_angle_hover == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_2_gradient_angle_hover == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_2_gradient_angle_hover == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_2_gradient_angle_hover == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_2_gradient_angle_hover == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_2_gradient_angle_hover == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_2_gradient_angle_hover == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_2_gradient_angle_hover == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_2_gradient_angle_hover == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_2_gradient_angle_hover == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_2_gradient_angle_hover == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_2_gradient_angle_hover == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_2_gradient_color_1_hover" id="sub_level_2_gradient_color_1_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_1_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_1_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_2_hover" id="sub_level_2_gradient_color_2_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_2_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_2_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_3_hover" id="sub_level_2_gradient_color_3_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_3_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_3_hover');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_4_hover" id="sub_level_2_gradient_color_4_hover" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_4_hover; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_4_hover');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_2_gradient_repeat_hover" id="sub_level_2_gradient_repeat_hover">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_repeat_hover == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_repeat_hover == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_2_gradient_repeat_hover == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_2_gradient_repeat_hover == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_2_gradient_repeat_hover == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_2_gradient_repeat_hover == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_2_gradient_repeat_hover == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_2_gradient_repeat_hover == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_2_gradient_repeat_hover == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_2_gradient_repeat_hover == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_2_gradient_repeat_hover == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_2_gradient_repeat_hover == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_2_gradient_repeat_hover == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_2_gradient_repeat_hover == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_2_gradient_repeat_hover == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_2_gradient_repeat_hover == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_2_gradient_opacity_1_hover" id="sub_level_2_gradient_opacity_1_hover">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_1_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_1_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_1_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_1_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_1_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_1_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_1_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_1_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_1_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_1_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_1_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_2_hover" id="sub_level_2_gradient_opacity_2_hover">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_2_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_2_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_2_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_2_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_2_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_2_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_2_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_2_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_2_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_2_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_2_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_3_hover" id="sub_level_2_gradient_opacity_3_hover">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_3_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_3_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_3_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_3_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_3_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_3_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_3_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_3_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_3_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_3_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_3_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_4_hover" id="sub_level_2_gradient_opacity_4_hover">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_4_hover == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_4_hover == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_4_hover == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_4_hover == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_4_hover == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_4_hover == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_4_hover == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_4_hover == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_4_hover == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_4_hover == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_4_hover == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_DOWN; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_2_gradient_type_down" id="sub_level_2_gradient_type_down" onChange="enable_disable_gradient('sub_level_2_', '_down');">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_type_down == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_2_gradient_type_down == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_type_down == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_2_gradient_angle_down" id="sub_level_2_gradient_angle_down">
                <option value="180"<?php if ($sub_level_2_gradient_angle_down == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_2_gradient_angle_down == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_2_gradient_angle_down == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_2_gradient_angle_down == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_2_gradient_angle_down == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_2_gradient_angle_down == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_2_gradient_angle_down == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_2_gradient_angle_down == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_2_gradient_angle_down == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_2_gradient_angle_down == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_2_gradient_angle_down == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_2_gradient_angle_down == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_2_gradient_angle_down == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_2_gradient_angle_down == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_2_gradient_angle_down == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_2_gradient_angle_down == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_2_gradient_angle_down == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_2_gradient_angle_down == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_2_gradient_angle_down == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_2_gradient_angle_down == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_2_gradient_angle_down == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_2_gradient_angle_down == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_2_gradient_angle_down == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_2_gradient_angle_down == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_2_gradient_angle_down == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_2_gradient_angle_down == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_2_gradient_angle_down == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_2_gradient_angle_down == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_2_gradient_angle_down == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_2_gradient_angle_down == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_2_gradient_angle_down == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_2_gradient_angle_down == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_2_gradient_color_1_down" id="sub_level_2_gradient_color_1_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_1_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_1_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_2_down" id="sub_level_2_gradient_color_2_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_2_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_2_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_3_down" id="sub_level_2_gradient_color_3_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_3_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_3_down');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_4_down" id="sub_level_2_gradient_color_4_down" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_4_down; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_4_down');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
        <?php echo EDIT_CSS_MENU_STYLES_HOVER_ON_DOWN; ?>:
        </td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_2_gradient_repeat_down" id="sub_level_2_gradient_repeat_down">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_repeat_down == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_repeat_down == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_2_gradient_repeat_down == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_2_gradient_repeat_down == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_2_gradient_repeat_down == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_2_gradient_repeat_down == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_2_gradient_repeat_down == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_2_gradient_repeat_down == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_2_gradient_repeat_down == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_2_gradient_repeat_down == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_2_gradient_repeat_down == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_2_gradient_repeat_down == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_2_gradient_repeat_down == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_2_gradient_repeat_down == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_2_gradient_repeat_down == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_2_gradient_repeat_down == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_2_gradient_opacity_1_down" id="sub_level_2_gradient_opacity_1_down">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_1_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_1_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_1_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_1_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_1_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_1_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_1_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_1_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_1_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_1_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_1_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_2_down" id="sub_level_2_gradient_opacity_2_down">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_2_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_2_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_2_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_2_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_2_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_2_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_2_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_2_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_2_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_2_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_2_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_3_down" id="sub_level_2_gradient_opacity_3_down">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_3_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_3_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_3_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_3_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_3_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_3_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_3_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_3_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_3_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_3_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_3_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_4_down" id="sub_level_2_gradient_opacity_4_down">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_4_down == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_4_down == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_4_down == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_4_down == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_4_down == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_4_down == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_4_down == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_4_down == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_4_down == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_4_down == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_4_down == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td style="text-align:center;">
        	<input name="sub_level_2_bkgd_gradient_hover_on_down" type="checkbox" id="sub_level_2_bkgd_gradient_hover_on_down" value="1" <?php if ($sub_level_2_bkgd_gradient_hover_on_down == 1) echo "checked='checked'"; ?>>
        </td>
      </tr>
      
      <tr>
      	<td class="bold" style="text-align:right;"><?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?></td><td colspan="7">&nbsp;</td>
    </tr>
    <tr>
        <td>
            <?php echo TYPE_WORD; ?>:
            <select name="sub_level_2_gradient_type_active" id="sub_level_2_gradient_type_active" onChange="enable_disable_gradient('sub_level_2_', '_active');">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_type_active == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="1"<?php if ($sub_level_2_gradient_type_active == 1) echo " selected='selected'"; ?>><?php echo LINEAR_WORD; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_type_active == 2) echo " selected='selected'"; ?>><?php echo RADIAL_WORD; ?></option>
             </select>
        </td>
        <td>
            <?php echo ANGLE_WORD; ?>:
            <select name="sub_level_2_gradient_angle_active" id="sub_level_2_gradient_angle_active">
                <option value="180"<?php if ($sub_level_2_gradient_angle_active == 180) echo " selected='selected'"; ?>>180 <?php echo DEGREES_WORD . " (" . TOP_TO_BOTTOM . ")"; ?></option>
                <option value="170"<?php if ($sub_level_2_gradient_angle_active == 170) echo " selected='selected'"; ?>>170 <?php echo DEGREES_WORD; ?></option>
                <option value="160"<?php if ($sub_level_2_gradient_angle_active == 160) echo " selected='selected'"; ?>>160 <?php echo DEGREES_WORD; ?></option>
                <option value="150"<?php if ($sub_level_2_gradient_angle_active == 150) echo " selected='selected'"; ?>>150 <?php echo DEGREES_WORD; ?></option>
                <option value="135"<?php if ($sub_level_2_gradient_angle_active == 135) echo " selected='selected'"; ?>>135 <?php echo DEGREES_WORD . " (" . TOP_LEFT_TO_BOTTOM_RIGHT . ")"; ?></option>
                <option value="120"<?php if ($sub_level_2_gradient_angle_active == 120) echo " selected='selected'"; ?>>120 <?php echo DEGREES_WORD; ?></option>
                <option value="110"<?php if ($sub_level_2_gradient_angle_active == 110) echo " selected='selected'"; ?>>110 <?php echo DEGREES_WORD; ?></option>
                <option value="100"<?php if ($sub_level_2_gradient_angle_active == 100) echo " selected='selected'"; ?>>100 <?php echo DEGREES_WORD; ?></option>
                <option value="90"<?php if ($sub_level_2_gradient_angle_active == 90) echo " selected='selected'"; ?>>90 <?php echo DEGREES_WORD . " (" . LEFT_TO_RIGHT . ")"; ?></option>
                <option value="80"<?php if ($sub_level_2_gradient_angle_active == 80) echo " selected='selected'"; ?>>80 <?php echo DEGREES_WORD; ?></option>
                <option value="70"<?php if ($sub_level_2_gradient_angle_active == 70) echo " selected='selected'"; ?>>70 <?php echo DEGREES_WORD; ?></option>
                <option value="60"<?php if ($sub_level_2_gradient_angle_active == 60) echo " selected='selected'"; ?>>60 <?php echo DEGREES_WORD; ?></option>
                <option value="45"<?php if ($sub_level_2_gradient_angle_active == 45) echo " selected='selected'"; ?>>45 <?php echo DEGREES_WORD . " (" . BOTTOM_LEFT_TO_TOP_RIGHT . ")"; ?></option>
                <option value="30"<?php if ($sub_level_2_gradient_angle_active == 30) echo " selected='selected'"; ?>>30 <?php echo DEGREES_WORD; ?></option>
                <option value="20"<?php if ($sub_level_2_gradient_angle_active == 20) echo " selected='selected'"; ?>>20 <?php echo DEGREES_WORD; ?></option>
                <option value="10"<?php if ($sub_level_2_gradient_angle_active == 10) echo " selected='selected'"; ?>>10 <?php echo DEGREES_WORD; ?></option>
                <option value="0"<?php if ($sub_level_2_gradient_angle_active == 0) echo " selected='selected'"; ?>>0 <?php echo DEGREES_WORD . " (" . BOTTOM_TO_TOP . ")"; ?></option>
                <option value="350"<?php if ($sub_level_2_gradient_angle_active == 350) echo " selected='selected'"; ?>>350 <?php echo DEGREES_WORD; ?></option>
                <option value="340"<?php if ($sub_level_2_gradient_angle_active == 340) echo " selected='selected'"; ?>>340 <?php echo DEGREES_WORD; ?></option>
                <option value="330"<?php if ($sub_level_2_gradient_angle_active == 330) echo " selected='selected'"; ?>>330 <?php echo DEGREES_WORD; ?></option>
                <option value="315"<?php if ($sub_level_2_gradient_angle_active == 315) echo " selected='selected'"; ?>>315 <?php echo DEGREES_WORD . " (" . BOTTOM_RIGHT_TO_TOP_LEFT . ")"; ?></option>
                <option value="300"<?php if ($sub_level_2_gradient_angle_active == 300) echo " selected='selected'"; ?>>300 <?php echo DEGREES_WORD; ?></option>
                <option value="290"<?php if ($sub_level_2_gradient_angle_active == 290) echo " selected='selected'"; ?>>290 <?php echo DEGREES_WORD; ?></option>
                <option value="280"<?php if ($sub_level_2_gradient_angle_active == 280) echo " selected='selected'"; ?>>280 <?php echo DEGREES_WORD; ?></option>
                <option value="270"<?php if ($sub_level_2_gradient_angle_active == 270) echo " selected='selected'"; ?>>270 <?php echo DEGREES_WORD . " (" . RIGHT_TO_LEFT . ")"; ?></option>
                <option value="260"<?php if ($sub_level_2_gradient_angle_active == 260) echo " selected='selected'"; ?>>260 <?php echo DEGREES_WORD; ?></option>
                <option value="250"<?php if ($sub_level_2_gradient_angle_active == 250) echo " selected='selected'"; ?>>250 <?php echo DEGREES_WORD; ?></option>
                <option value="240"<?php if ($sub_level_2_gradient_angle_active == 240) echo " selected='selected'"; ?>>240 <?php echo DEGREES_WORD; ?></option>
                <option value="225"<?php if ($sub_level_2_gradient_angle_active == 225) echo " selected='selected'"; ?>>225 <?php echo DEGREES_WORD . " (" . TOP_RIGHT_TO_BOTTOM_LEFT . ")"; ?></option>
                <option value="210"<?php if ($sub_level_2_gradient_angle_active == 210) echo " selected='selected'"; ?>>210 <?php echo DEGREES_WORD; ?></option>
                <option value="200"<?php if ($sub_level_2_gradient_angle_active == 200) echo " selected='selected'"; ?>>200 <?php echo DEGREES_WORD; ?></option>
                <option value="190"<?php if ($sub_level_2_gradient_angle_active == 190) echo " selected='selected'"; ?>>190 <?php echo DEGREES_WORD; ?></option>
             </select>
        </td>
        <td><?php echo COLOR_WORD; ?>:</td>
        <td>	
            <input type="text" name="sub_level_2_gradient_color_1_active" id="sub_level_2_gradient_color_1_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_1_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_1_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_2_active" id="sub_level_2_gradient_color_2_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_2_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_2_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_3_active" id="sub_level_2_gradient_color_3_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_3_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_3_active');"> <?php echo RGB_WORD; ?></span>
            
        </td>
        <td>
            <input type="text" name="sub_level_2_gradient_color_4_active" id="sub_level_2_gradient_color_4_active" style="width:60px;" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" value="<?php echo $sub_level_2_gradient_color_4_active; ?>" />
            <span class="small_message fake_link" onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_gradient_color_4_active');"> <?php echo RGB_WORD; ?></span>
        </td>
        <td>&nbsp;</td>
     </tr>
     <tr>
        <td>&nbsp;</td>
        <td>
            <?php echo REPEAT_WORD; ?>:
            <select name="sub_level_2_gradient_repeat_active" id="sub_level_2_gradient_repeat_active">
                <option value="0" class="not_set"<?php if ($sub_level_2_gradient_repeat_active == 0) echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                <option value="2"<?php if ($sub_level_2_gradient_repeat_active == 2) echo " selected='selected'"; ?>>2</option>
                <option value="3"<?php if ($sub_level_2_gradient_repeat_active == 3) echo " selected='selected'"; ?>>3</option>
                <option value="4"<?php if ($sub_level_2_gradient_repeat_active == 4) echo " selected='selected'"; ?>>4</option>
                <option value="5"<?php if ($sub_level_2_gradient_repeat_active == 5) echo " selected='selected'"; ?>>5</option>
                <option value="6"<?php if ($sub_level_2_gradient_repeat_active == 6) echo " selected='selected'"; ?>>6</option>
                <option value="7"<?php if ($sub_level_2_gradient_repeat_active == 7) echo " selected='selected'"; ?>>7</option>
                <option value="8"<?php if ($sub_level_2_gradient_repeat_active == 8) echo " selected='selected'"; ?>>8</option>
                <option value="9"<?php if ($sub_level_2_gradient_repeat_active == 9) echo " selected='selected'"; ?>>9</option>
                <option value="10"<?php if ($sub_level_2_gradient_repeat_active == 10) echo " selected='selected'"; ?>>10</option>
                <option value="20"<?php if ($sub_level_2_gradient_repeat_active == 20) echo " selected='selected'"; ?>>20</option>
                <option value="30"<?php if ($sub_level_2_gradient_repeat_active == 30) echo " selected='selected'"; ?>>30</option>
                <option value="40"<?php if ($sub_level_2_gradient_repeat_active == 40) echo " selected='selected'"; ?>>40</option>
                <option value="50"<?php if ($sub_level_2_gradient_repeat_active == 50) echo " selected='selected'"; ?>>50</option>
                <option value="100"<?php if ($sub_level_2_gradient_repeat_active == 100) echo " selected='selected'"; ?>>100</option>
                <option value="200"<?php if ($sub_level_2_gradient_repeat_active == 200) echo " selected='selected'"; ?>>200</option>
             </select>
        </td>
        <td><?php echo OPACITY_WORD; ?>:</td><td>
            <select name="sub_level_2_gradient_opacity_1_active" id="sub_level_2_gradient_opacity_1_active">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_1_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_1_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_1_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_1_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_1_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_1_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_1_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_1_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_1_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_1_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_1_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_2_active" id="sub_level_2_gradient_opacity_2_active">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_2_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_2_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_2_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_2_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_2_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_2_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_2_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_2_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_2_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_2_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_2_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_3_active" id="sub_level_2_gradient_opacity_3_active">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_3_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_3_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_3_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_3_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_3_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_3_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_3_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_3_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_3_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_3_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_3_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>
            <select name="sub_level_2_gradient_opacity_4_active" id="sub_level_2_gradient_opacity_4_active">
                <option value="100"<?php if ($sub_level_2_gradient_opacity_4_active == 100) echo " selected='selected'"; ?>>100%</option>
                <option value="90"<?php if ($sub_level_2_gradient_opacity_4_active == 90) echo " selected='selected'"; ?>>90%</option>
                <option value="80"<?php if ($sub_level_2_gradient_opacity_4_active == 80) echo " selected='selected'"; ?>>80%</option>
                <option value="70"<?php if ($sub_level_2_gradient_opacity_4_active == 70) echo " selected='selected'"; ?>>70%</option>
                <option value="60"<?php if ($sub_level_2_gradient_opacity_4_active == 60) echo " selected='selected'"; ?>>60%</option>
                <option value="50"<?php if ($sub_level_2_gradient_opacity_4_active == 50) echo " selected='selected'"; ?>>50%</option>
                <option value="40"<?php if ($sub_level_2_gradient_opacity_4_active == 40) echo " selected='selected'"; ?>>40%</option>
                <option value="30"<?php if ($sub_level_2_gradient_opacity_4_active == 30) echo " selected='selected'"; ?>>30%</option>
                <option value="20"<?php if ($sub_level_2_gradient_opacity_4_active == 20) echo " selected='selected'"; ?>>20%</option>
                <option value="10"<?php if ($sub_level_2_gradient_opacity_4_active == 10) echo " selected='selected'"; ?>>10%</option>
                <option value="0"<?php if ($sub_level_2_gradient_opacity_4_active == 0) echo " selected='selected'"; ?>>0%</option>
            </select>
        </td>
        <td>&nbsp;</td>
      </tr>
      
   </table>
   
  </td>
</tr>
</table>

<table width="90%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr><td colspan="3">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <div class='button_console_preview' style="width:110px;" onClick="PreviewPageSelect();"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
          <input type="hidden" name="operation" id="operation" />
		</td>
        <td align="center">
          <div class='button_console_save' style="width:110px;" onClick="SaveMenuStyles();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
		</td>
	  </tr>
</table>
</form>
</div>

<div id="page_select_div" style="display:none;">
<?php echo EDIT_CSS_SELECT_PAGE_FOR_PREVIEW; ?>:<br />
<select id="page_select" onChange="Preview(this.value, 0);">
<?php
	$query = "SELECT page_name FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "		<option value='$page_name'>$page_name</option>\n";
	}
?>
</select>
<div id="preview_go" onClick="Preview(document.getElementById('page_select').value, 0);">&nbsp;</div>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	enable_disable_controls();
	popup_msg.HidePopupMsg();
</script>

</body>
</html>