<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 6/15/2007
// Added head_name and WHERE clause for editing different head content.
// Revised: 3/26/2010	ELL
// Changed "Submit" to "Save"
// Fixed bug with ecape codes.
// Revised: 10/12/2010	ELL
// Added revision datetime tracking.
// Revised: 11/9/2010	ELL
// Added persitence of last head edited.
// Revised: 1/16/2012	ELL
// Added "Publish" button and changed "Save" button function to save to draft.  Also added "Revert" so that draft can be discarded.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added reference to user files folder constant.
// Revised: 7/29/2014	ELL
// Converted save functions to JQuery AJAX operations.
// Revised: 10/20/2014	ELL
// Converted editor for simple text area to CKEditor is source view.
// Revised: 11/21/2014	ELL
// Added delete head.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Added "Save As"
// Revised: 1/22/2015	ELL
// Updated CKEditor from version 4.4.5 to version 4.4.6.

	
	include ("check_session.php");
		
	$head_name = $_REQUEST['head_name'];
	$_SESSION['last_head_edited'] = $head_name;
	
	if (BWB_BASE_DIR == '')
		$path = "../" . BWB_WEBPAGE_DIR . "/index.php";
	else
		$path = "../" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/index.php";

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "options_selected WHERE option_name='CodeMirrorTheme'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))	{
		$CodeMirrorTheme = $row['option_value'];
		if (strpos($CodeMirrorTheme, "solarized") !== false)
			$CodeMirrorCSS = "solarized";
		else
			$CodeMirrorCSS = $row['option_value'];
	}
	else	{
		$CodeMirrorTheme = "rubyblue";
		$CodeMirrorCSS = "rubyblue";
	}
?>
<html>
<head>
<title><?php echo $head_name; ?> - Editing | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="../ckeditor/plugins/codemirror/theme/<?php echo $CodeMirrorCSS; ?>.css">

<script type="text/javascript" src="js/jquery.min.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/edit_head.js"></script>
<script language="javascript" type="text/javascript" src="../ckeditor/ckeditor.js"></script>

<script>
	var head_name = "<?php echo $head_name; ?>";
	
	var saved = true;
 
	var browser = BrowserDetect.browser;
	var browser_version = BrowserDetect.version;
	
<?php
	echo "	var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "	var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
	echo "	var EDITOR_REVERT_HEAD_CONFIRM_1_MSG = \"" . EDITOR_REVERT_HEAD_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_REVERT_HEAD_CONFIRM_2_MSG = \"" . EDITOR_REVERT_HEAD_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_REVERTING_MSG = \"" . EDITOR_REVERTING_MSG . "\";\n";
	echo "	var EDITOR_REVERT_COMPLETE_MSG = \"" . EDITOR_REVERT_COMPLETE_MSG . "\";\n";
	echo "	var EDITOR_REVERT_ERR = \"" . EDITOR_REVERT_ERR . "\";\n";
	echo "	var EDITOR_HEAD_NOT_SAVED_MSG = \"" . EDITOR_HEAD_NOT_SAVED_MSG . "\";\n";
	echo "	var EDITOR_HEAD_BLANK_ERR = \"" . EDITOR_HEAD_BLANK_ERR . "\";\n";
	echo "	var EDITOR_HEAD_ALREADY_EXISTS_1_ERR = \"" . EDITOR_HEAD_ALREADY_EXISTS_1_ERR . "\";\n";
	echo "	var EDITOR_HEAD_ALREADY_EXISTS_2_ERR = \"" . EDITOR_HEAD_ALREADY_EXISTS_2_ERR . "\";\n";
	echo "	var EDITOR_DELETE_HEAD_CONFIRM_1_MSG = \"" . EDITOR_DELETE_HEAD_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_DELETE_HEAD_CONFIRM_2_MSG = \"" . EDITOR_DELETE_HEAD_CONFIRM_2_MSG . "\";\n";
	echo "	var SAVE_AS_WORD = \"" . SAVE_AS_WORD . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var OK_WORD = \"" . OK_WORD . "\";\n";
	echo "	var CANCEL_WORD = \"" . CANCEL_WORD . "\";\n";
?>
</script>

</head>

<body id="workspace_body">
<div style='text-align:center;'>
<form name="frmEditHead" id="frmEditHead" action="save_head.php" method="post">

	<div style="height:93%; width:100%;" id="editorContainer" name="editorContainer"></div>

	<script type="text/javascript" language="javascript">
    //<![CDATA[
		CKEDITOR_BASEPATH = '../ckeditor/';
		
		CKEDITOR.replace( 'editorContainer', { contentsCss : ['/ckeditor/contents.css'] });

		CKEDITOR.config.language = '<?php echo BWB_LANG; ?>';
		CKEDITOR.config.extraPlugins = 'codemirror';
		CKEDITOR.config.skin = 'kama';
		CKEDITOR.config.allowedContent = true;
		
		CKEDITOR.config.toolbarGroups = [
    { name: 'document',    groups: [ 'mode', 'document', 'doctools' ] },
    { name: 'editing',     groups: [ 'find', 'selection' ] },
    { name: 'tools' },
    { name: 'others' },
    { name: 'about' }
];
		
	CKEDITOR.config.removePlugins = 'newpage,print,templates,showblocks';
	CKEDITOR.config.removeButtons = 'Source';
	
	var editorElem = document.getElementById("editorContainer");
	CKEDITOR.config.width = '99%';

	if ((browser == "Explorer") && (browser_version <= 7))
		CKEDITOR.config.height = document.body.clientHeight - 169;
	else if ((browser == "Opera") && (browser_version < 13))
		CKEDITOR.config.height = window.innerHeight - 144;
	else if ((browser == "Explorer") && (browser_version == 8))
		CKEDITOR.config.height = document.body.clientHeight - 144;
	else
		CKEDITOR.config.height = editorElem.clientHeight - 74;
	CKEDITOR.config.resize_enabled = false;

	CKEDITOR.config.startupMode = 'source';

	CKEDITOR.config.codemirror = {
		 // Set this to the theme you wish to use (codemirror themes)
		theme: '<?php echo $CodeMirrorTheme; ?>',
		// Whether or not you want Brackets to automatically close themselves
		autoCloseBrackets: true,
		 // Whether or not you want tags to automatically close themselves
		autoCloseTags: true,
		 // Whether or not to automatically format code should be done when the editor is loaded
		autoFormatOnStart: true, 
		// Whether or not to automatically format code which has just been uncommented
		autoFormatOnUncomment: true,
		// Whether or not to continue a comment when you press Enter inside a comment block
		continueComments: true,
		 // Whether or not you wish to enable code folding (requires 'lineNumbers' to be set to 'true')
		enableCodeFolding: true,
		// Whether or not to enable code formatting
		enableCodeFormatting: true,
		// Whether or not to enable search tools, CTRL+F (Find), CTRL+SHIFT+F (Replace), CTRL+SHIFT+R (Replace All), CTRL+G (Find Next), CTRL+SHIFT+G (Find Previous)
		enableSearchTools: true,
		// Whether or not to highlight all matches of current word/selection
		highlightMatches: true,
		 // Whether, when indenting, the first N*tabSize spaces should be replaced by N tabs
		indentWithTabs: false,
		 // Whether or not you want to show line numbers
		lineNumbers: true,
		// Whether or not you want to use line wrapping
		lineWrapping: true,
		 // Define the language specific mode 'htmlmixed' for html  including (css, xml, javascript), 'application/x-httpd-php' for php mode including html, or 'text/javascript' for using java script only 
		mode: 'htmlmixed',
		// Whether or not you want to highlight matching braces
		matchBrackets: true,
		// Whether or not you want to highlight matching tags
		matchTags: true,
		// Whether or not to show the showAutoCompleteButton   button on the toolbar
		showAutoCompleteButton: true,
		 // Whether or not to show the comment button on the toolbar
		showCommentButton: true,
		// Whether or not to show the format button on the toolbar
		showFormatButton: true,
		 // Whether or not to show the search Code button on the toolbar
		showSearchButton: true,
		 // Whether or not to show Trailing Spaces
		showTrailingSpace: true,
		// Whether or not to show the uncomment button on the toolbar
		showUncommentButton: true,
		 // Whether or not to highlight the currently active line
		styleActiveLine: true,
		// "Whether or not to use Beautify for auto formatting
		useBeautify: false
	};
			
	var bwb_ckeditor = CKEDITOR.instances['editorContainer'];

	function somethingChanged()	{
		if ( bwb_ckeditor.checkDirty() && !lockoutChangeCheck )
		{
			saved = false;
			window.parent.SetWorkSavedNotSaved(saved);
			try	{
				bwb_ckeditor.commands.save.enable();
			}
			catch(err)	{
				err = 0;
			}
		}
	}

	function somethingHappened(e)	{
//			alert(e.data.name);
		if ( bwb_ckeditor.checkDirty() && !lockoutChangeCheck )
			window.parent.SetWorkSavedNotSaved(true);
			
		if (e.data.name == "newpage")
		{
			e.data.command = null;
			//ClearContent();
		}
		else if (e.data.name == "preview")
		{
			e.data.command = null;
//				Save('Preview');
		}
		else if (e.data.name == "save")
		{
			e.data.command = null;
			Save('Save');
			try	{
				bwb_ckeditor.commands.save.disable();
			}
			catch(err)	{
				err = 0;
			}
			bwb_ckeditor.resetDirty();
		}
		else if (e.data.name == "source")
		{
			e.data.command = null;
		}
	}
	
	bwb_ckeditor.on( 'saveSnapshot', function(e) { somethingChanged(); });
	bwb_ckeditor.on( 'beforeCommandExec', function(e) { somethingHappened(e); });
	
//]]>
</script>
 
  <table width="90%" align="center" id="btn_table"><tr>
  <td align="left" class="medium_message" width="9%">
  <span id="page_name_label"><?php echo EDITOR_HEAD_NAME; ?>:<br /><?php echo $head_name; ?></span>
  </td>
  <td align="center">
  <div class='button_console_preview_sm' style="width:110px;" onClick="Preview('<?php echo $head_name; ?>', 0);"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
  </td>
  <td align="center">
  <div class='button_console_save' style="width:110px;" onClick="Save('Save');"><span class='button_console_text_w_icon'><?php echo EDITOR_SAVE; ?></span></div>
  </td>
  <td align="center">
  <div class='button_console_save' style="width:110px;" onClick="ShowSaveAsMsg();"><span class='button_console_text_w_icon'><?php echo EDITOR_SAVE_AS; ?></span></div>
  </td>
  <td align="center">
  <div class='button_console_save' style="width:110px;" onClick="Save('Publish');"><span class='button_console_text_w_icon'><?php echo EDITOR_PUBLISH; ?></span></div>
  </td>
  <td align="center">
  <div class='button_console_cancel' style="width:110px;" onClick="RevertConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_REVERT; ?></span></div>
  </td>
<?php if (($access_level == "admin") || ($access_level == "power_user")) { ?>
  <td align="center">
  <div class='button_console_delete' style="width:110px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
  </td>
<?php } ?>
  <td align="center">
  <div class='button_console_preview' style="width:110px;" onClick="window.open('<?php echo $path; ?>', '_blank');"><span class='button_console_text_w_icon'><?php echo EDITOR_SEE_SITE; ?></span></div>
  </td>
  <td align="right" width="10%"><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></td>
  </tr></table>
      
</form>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
	popup_msg.HidePopupMsg();
	mTimer3 = setTimeout("LoadHead();", 1500);
	
	if (document.body.scrollWidth > document.body.clientWidth)
		CKEDITOR.config.height = CKEDITOR.config.height - 30;
</script>

</body>
</html>
