<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 9/11/2008
// Revised: 10/13/2009	ELL
// Added capability to look through multiple menu-item tables.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added references to website files folder configurations.
// Revised: 8/10/2014	ELL
// Fixed bug with extra slash appearing in URL when both base dir and webpage dir are blank.
// Added disallows to robots.txt file for Breeze system folders.
// Added SEF URL switching.
// Added checking of existing entries from other menus to avoid duplicate entries.
// Added checking of all pages to include pages not found in menues.
// Modified: 12/2/2016	ELL
// Consolidated all menu items tables into menu_items.
//

	// for testing //
	//include "../connect/db_connection.php";
	// for testing //
	if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
		$website_file_path = "";
	elseif (BWB_BASE_DIR == '')
		$website_file_path = "/" . BWB_WEBPAGE_DIR;
	else
		$website_file_path = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR;
		
	$special_chars = array("/", "?", "&", "=", ":");
	
	$site_map_string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
	$previous_level = 0;
	$indent = '   ';
	$website = $_SERVER['SERVER_NAME'];
	$priority = 0.8;
	$pages = array();
	$query_menus = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus";
	$result_menus = $bwb_dbh->query($query_menus);
	while ($row_menus = $result_menus->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row_menus['menu_name'];
		
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_items WHERE menu='" . $menu_name . "' ORDER BY sort_order";
//		echo "$query<br>";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() > 0)
		{
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				//$item_text = $row["item_text"];
				$level = $row["level"];
				$URL = $row["URL"];
				//$target = $row["target"];
				
				//$item_text = stripslashes($item_text);
				$URL = stripslashes($URL);
				//$target = stripslashes($target);
				
				// Don't map links to other sites.
				if (strcasecmp(substr($URL, 0, 4), "http") != 0) 
				{
					$page_name = substr($URL, 0, strlen($URL) - 4);
					if (in_array($page_name, $pages) === false)
					{
						$pages[] = $page_name;
						
						$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "meta_tags` WHERE page_name = '$page_name'";
						$result2 = $bwb_dbh->query($query);
						if ($result2->rowCount() > 0)
						{
							$row2 = $result2->fetch(PDO::FETCH_ASSOC);
							$robots_index = $row2['robots_index'];
							$robots_follow = $row2['robots_follow'];
							$robots_revisit = $row2['robots_revisit'];
						}
						else
						{
							$robots_index = 1;
							$robots_follow = 1;
							$robots_revisit = 30;
						}
						if ($robots_index == 1)
						{
							if (SEF_URL == 1)
							{
								$found_special_char = false;
								foreach ($special_chars as $char)
								{
									if (strpos($URL, $chars) !== false)
										$found_special_char = true;
								}
								if ($found_special_char === false)
									$URL = $page_name;
							}
							
							$query = "SELECT `revised`, `login_required` FROM `" . BWB_TABLE_PREFIX . "page_data` WHERE page_name = '$page_name'";
							$result2 = $bwb_dbh->query($query);
							$row2 = $result2->fetch(PDO::FETCH_ASSOC);
							$login_required = $row2['login_required'];
							if ($login_required == 0)
							{
								$revised = trim($row2['revised']);
								
								switch	($robots_revisit)	{
									case 1:
										$changefreq = "daily";
										break;
									case 7:
										$changefreq = "weekly";
										break;
									case 30:
										$changefreq = "monthly";
										break;
									case 365:
										$changefreq = "yearly";
										break;
									default :
										$changefreq = "monthly";
								}
	
								$date_time_parts = explode(" ", $revised);
								$date_revised = $date_time_parts[0];
									
								if ($previous_level < $level)	//Nesting
								{
									if ($priority > 0.2)
										$priority = $priority - 0.2;
								}
								elseif ($previous_level > $level)	//Un-nesting
								{
									if ($priority < 0.8)
										$priority = $priority + 0.2;
								}
								
								$site_map_string .= $indent . "<url>\n";
								$site_map_string .= $indent . $indent . "<loc>http://" . $website . $website_file_path . "/" . $URL . "</loc>\n";
								$site_map_string .= $indent . $indent . "<lastmod>$date_revised</lastmod>\n";
								$site_map_string .= $indent . $indent . "<changefreq>$changefreq</changefreq>\n";
								if (($URL == "index.php") || ($URL == "index"))	// Special case: Make home page top priority.
									$site_map_string .= $indent . $indent . "<priority>1.0</priority>\n";
								else
									$site_map_string .= $indent . $indent . "<priority>$priority</priority>\n";
								$site_map_string .= $indent . "</url>\n";
								
								$previous_level = $level;
							}
						}
					}
				}
			}
		}
	}	// While menu items found
	
	// Look for pages not found in menues.
	if (count($pages) < 1)
		$priority = 0.8;
	else
		$priority = 0.2;
		
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		if (in_array($page_name, $pages) === false)
		{
			$login_required = $row['login_required'];
			$revised = $row['revised'];
			
			if ($login_required == 0)
			{
				$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "meta_tags` WHERE page_name = '$page_name'";
				$result2 = $bwb_dbh->query($query);
				if ($result2->rowCount() > 0)
				{
					$row2 = $result2->fetch(PDO::FETCH_ASSOC);
					$robots_index = $row2['robots_index'];
					$robots_follow = $row2['robots_follow'];
					$robots_revisit = $row2['robots_revisit'];
				}
				else
				{
					$robots_index = 1;
					$robots_follow = 1;
					$robots_revisit = 30;
				}
				
				if ($robots_index == 1)
				{
					switch	($robots_revisit)	{
						case 1:
							$changefreq = "daily";
							break;
						case 7:
							$changefreq = "weekly";
							break;
						case 30:
							$changefreq = "monthly";
							break;
						case 365:
							$changefreq = "yearly";
							break;
						default :
							$changefreq = "monthly";
					}
						
					$date_time_parts = explode(" ", $revised);
					$date_revised = $date_time_parts[0];
					if (SEF_URL == 1)
						$URL = $page_name;
					else
						$URL = $page_name . ".php";
					
					$site_map_string .= $indent . "<url>\n";
					$site_map_string .= $indent . $indent . "<loc>http://" . $website . $website_file_path . "/" . $URL . "</loc>\n";
					$site_map_string .= $indent . $indent . "<lastmod>$date_revised</lastmod>\n";
					$site_map_string .= $indent . $indent . "<changefreq>$changefreq</changefreq>\n";
					if (($URL == "index.php") || ($URL == "index"))	// Special case: Make home page top priority.
						$site_map_string .= $indent . $indent . "<priority>1.0</priority>\n";
					else
						$site_map_string .= $indent . $indent . "<priority>$priority</priority>\n";
					$site_map_string .= $indent . "</url>\n";
				}
			}
		}
	}
			
	$site_map_string .= "</urlset>";
	
	////////////////////////////////////////////////////////
	/// Write menu items to sitemap.xml file /////////////
	//Test to see if file already exists.
	$msg = GENERATE_SITE_MAP_ERROR_CREATING_SITEMAP_ERR;
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$file_name = $document_root . $website_file_path . "/sitemap.xml";
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo GENERATE_SITE_MAP_COULD_NOT_RENAME_1_ERR . " $file_name " . GENERATE_SITE_MAP_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		else
			$msg = GENERATE_SITE_MAP_SITEMAP_REBUILD_COMPLETE;
		@chmod($bkup_file_name, 0644);
	}
	
	// Create sitemap.xml file.
	$fh = fopen($file_name, 'x') or die(GENERATE_SITE_MAP_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $site_map_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	if ($msg != GENERATE_SITE_MAP_SITEMAP_REBUILD_COMPLETE)
		$msg = GENERATE_SITE_MAP_SITEMAP_CREATION_COMPLETE;
	
	// Create robots.txt file.
	$robots_string = "# robots.txt generated by the Breeze Website Builder\n";
	$robots_string .= "User-agent: *\n";
	$robots_string .= "Disallow: /cgi-bin/\n";
	$robots_string .= "Disallow: /connect/\n";
	$robots_string .= "Disallow: /manage/\n";
	$robots_string .= "Disallow: /ckeditor/\n";
	$robots_string .= "Disallow: /kfm/\n";
	$robots_string .= "Disallow: /php/\n";
	// Google needs to see JavaScirpt and images, so the next 2 lines have been commented out.
//	$robots_string .= "Disallow: /scripts/\n";
//	$robots_string .= "Disallow: /css/\n";
	if (file_exists($document_root . "/wizard"))
		$robots_string .= "Disallow: /wizard/\n";
	$robots_string .= "Sitemap: http://" . $website . $website_file_path . "/sitemap.xml";
	$file_name = $document_root . $website_file_path . "/robots.txt";
	if (!file_exists($file_name))
	{
		$fh = fopen($file_name, 'x') or die(GENERATE_SITE_MAP_CANT_CREATE_ERR . " $file_name: $php_errormsg");
		$result = (fputs($fh, $robots_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
	}
	$file_name2 = $document_root . "/robots.txt";
	// Copy robots.txt to site root.
	if (file_exists($file_name2) && (trim($file_name) != trim($file_name2)))	{
		unlink($file_name2);
		copy($file_name, $file_name2);
	}
	$msg .= "<br /><br />" . GENERATE_SITE_MAP_ROBOT_FILE_CREATED;
?>
