/////////////////////////////////////////////
// Backup/Restore /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/13/2016	ELL

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#backup_restore", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////

function SubmitLogin()
{
	var password = document.getElementById("password_input").value;
	var hash = Sha256.hash(password);
	document.getElementById("password").value = hash;
	document.getElementById("password_input").value = '';
	document.forms["formLogin"].submit();
}

function checkForEnter(e) {
	if (e.keyCode == 13) {
		SubmitLogin();
	}
}

function GetBackups()
{
	$.post( "get_backups.php", { } ).done(CompleteGetBackups) ;
}
function CompleteGetBackups(data)
{
	if (data == "-no data-")	{
		document.getElementById("backups_div").innerHTML = "&nbsp;";
		document.getElementById("or").style.display = "none";
		return;
	}
		
	var files = data.split("@@@@@");
	var JSON_row;
		
	var html = "<table style='margin-left:21px; margin-right:-21px; padding:0;' cellpadding='0' cellspacing='0'>\n<tr>\n<td colspan='2'>\n<div class='button_heading_sub_level_1' style='width:502px;'>\n<div class='button_heading_text_sub_level_1' style='width:90%;'>" + BACKUP_RESTORE_SELECT_BACKUP + "</div>\n</div>\n</td>\n</tr>\n";
	for (var i = 0; i < files.length; i++)
	{
		JSON_row = JSON.parse(files[i]);
		
		html = html + "<tr>\n<td>\n<div class='button_sub_level_1' onClick=\"RestoreConfirm('" + JSON_row.file_name + "');\" style='width:500px;'><span class='button_text_sub_level_1' style='width:90%;'>" + JSON_row.file_name + " --- " + JSON_row.file_date + "</span></div>\n</td>\n<td style='width:40px;' align='right'>\n<img src='theme/" + theme + "/images/delete.png' alt='" + BACKUP_RESTORE_DELETE_BACKUP + "' border='0' onClick=\"DeleteConfirm('" + JSON_row.file_name + "');\" style='cursor:pointer;' />\n</td>\n</tr>";
	}
	html = html + "\n</table>\n";
	
	document.getElementById("backups_div").innerHTML = html;
}

function RestoreConfirm(backup_file)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = BACKUP_RESTORE_RESTORE_CONFIRM_1_MSG + " <b>" + backup_file + "</b> " + BACKUP_RESTORE_RESTORE_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { Restore(backup_file); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}
function Restore(backup_file)
{
	window.location = "restore_site.php?backup_file=" + backup_file + "&password=" + pss + "&retain_media=" + document.getElementById("retain_media").value;
}

function DeleteConfirm(backup_file)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = BACKUP_RESTORE_DELETE_BACKUP_CONFIRM_MSG + " <b>" + backup_file + "</b> " + BACKUP_RESTORE_RESTORE_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteBackup(backup_file); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}
function DeleteBackup(backup_file)
{
	popup_msg.HidePopupMsg();
	
	$.post( "delete_file.php", { file: backup_file, path: "../backup/" } ).done(CompleteDeleteBackup) ;
}
function CompleteDeleteBackup(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (data == 1)
		popup_msg.status_msg = BACKUP_RESTORE_DELETE_BACKUP_SUCCESS_MSG;
	else
		popup_msg.status_msg = BACKUP_RESTORE_DELETE_BACKUP_ERROR_ERR;
	popup_msg.ShowPopupMsg();
	
	GetBackups();
}

function SetRetainMedia(retain_media)
{
	if (retain_media == true)
		document.getElementById("retain_media").value = 1;
	else
		document.getElementById("retain_media").value = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved border area.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}