///////////////////////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	3/9/2013	ELL
// Revised: 5/14/2013	ELL
// Added URL escaping and unescaping of URL itself.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/22/2013	ELL
// Restored ability to check for saved and prompt user for action.
// Revised: 10/22/2016	ELL
// Added handling of mega menus.
// Revised: 4/13/2017	ELL
// Added code to update HTML on every change because JavaScript ignores form entry.
//

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

function Indent(level)
{
	var indent = "";
	for (var i = 0; i < level; i++)
	{
		indent = indent + "   ";
	}
	return indent;
}

////////////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_menu_items", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm(item_text, ID, i)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDIT_MENU_ITEMS_DELETE_ITEM_CONFIRM_1_MSG + " <b>" + item_text + "</b> " + EDIT_MENU_ITEMS_DELETE_ITEM_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteMenuItem(ID); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteMenuItem(IDRemove)
{
	var params = "";

	popup_msg.HidePopupMsg();
	menu = document.getElementById("selectMenu").value;
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDIT_MENU_ITEMS_STARTING_DELETE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","delete_menu_item.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Delete");
		
		params = "menu=" + document.getElementById("selectMenu").value;
		params = params + "&IDRemove=" + IDRemove;
//		alert(params);
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMenuItem(ID, i)
{
	if (update_all)
	{
		UpdateAll();
		return;
	}
	var params = "";
	var ID_ctl = "ID" + i;
	var item_text_ctl = "item_text" + i;
	var level_ctl = "level" + i;
	var URL_ctl = "URL" + i;
	var target_ctl = "target" + i;
	var mega_menu_ctl = "mega_menu" + i;
	var sort_order_ctl = "sort_order" + i;
	var item_text = "";
	var URL = "";
	
	if (ID == -1)
		unsaved_new_item = false;

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_menu_item.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Update");
		
		// Escape URL string
		item_text = document.getElementById(item_text_ctl).value;
		item_text = EscapeURL(item_text);
		URL = document.getElementById(URL_ctl).value;
		URL = EscapeURL(URL);
		
		params = "menu=" + document.getElementById("selectMenu").value;
		params = params + "&ID=" + ID;
		params = params + "&item_text=" + item_text;
		params = params + "&level=" + document.getElementById(level_ctl).value;
		params = params + "&URL=" + URL;
		params = params + "&target=" + document.getElementById(target_ctl).value;
		params = params + "&mega_menu=" + document.getElementById(mega_menu_ctl).value;
		params = params + "&sort_order=" + document.getElementById(sort_order_ctl).value;
		//alert(params);
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateAll()
{
	var params = "";
	var ID_ctl;
	var item_text_ctl;
	var level_ctl;
	var URL_ctl;
	var target_ctl;
	var mega_menu_ctl;
	var sort_order_ctl;
	var item_text;
	var URL;

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_menu_items.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "UpdateAll");
		
		params = "menu=" + document.getElementById("selectMenu").value;
		var cnt = document.getElementById("nCount").value;
		params = params + "&cnt=" + cnt;
		for (i = 0; i < cnt; i++)
		{
			ID_ctl = "ID" + i;
			item_text_ctl = "item_text" + i;
			level_ctl = "level" + i;
			URL_ctl = "URL" + i;
			target_ctl = "target" + i;
			mega_menu_ctl = "mega_menu" + i;
			sort_order_ctl = "sort_order" + i;
			
			params = params + "&ID" + i + "=" + document.getElementById(ID_ctl).value;
			// Escape URL string
			item_text = document.getElementById(item_text_ctl).value;
			item_text = EscapeURL(item_text);
			params = params + "&item_text" + i + "=" + item_text;
			params = params + "&level" + i + "=" + document.getElementById(level_ctl).value;
			URL = document.getElementById(URL_ctl).value;
			URL = EscapeURL(URL);
			params = params + "&URL" + i + "=" + URL;
			params = params + "&target" + i + "=" + document.getElementById(target_ctl).value;
			params = params + "&mega_menu" + i + "=" + document.getElementById(mega_menu_ctl).value;
			params = params + "&sort_order" + i + "=" + document.getElementById(sort_order_ctl).value;
		}
//		alert(params);
		xmlhttp.send(params);
	}
	unsaved_new_item = false;
	window.parent.SetWorkSavedNotSaved(true);
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, Source)
{
	var query_complete_no_record = QUERY_COMPLETE_NO_RECORD_FOUND;
	var query_complete = "<b>" + QUERY_COMPLETE + "<\/b><br/>\n";
	var query_read_to_send = QUERY_READY_TO_SEND;
	var query_sent = QUERY_SENT;
	var query_starting = EDIT_MENU_ITEMS_LOCATING_MENU_ITEMS_MSG;
	if (Source == "Delete")
	{
		query_complete_no_record = EDIT_MENU_ITEMS_COULD_NOT_DELETE_ITEM_MSG;
		query_complete = "<b>" + EDIT_MENU_ITEMS_MENU_ITEM_DELETED_MSG + "<\/b><br/>\n";
		query_starting = EDIT_MENU_ITEMS_DELETING_MENU_ITEM_MSG;
	}
	else if (Source == "Update")
	{
		query_complete_no_record = EDIT_MENU_ITEMS_COULD_NOT_UPDATE_ITEM_MSG;
		query_complete = "<b>" + EDIT_MENU_ITEMS_MENU_ITEM_UPDATED_MSG + "<\/b><br/>\n";
		query_starting = EDIT_MENU_ITEMS_UPDATING_MENU_ITEM_MSG;
	}
	else if (Source == "UpdateAll")
	{
		query_complete_no_record = EDIT_MENU_ITEMS_COULD_NOT_UPDATE_ITEMS_MSG;
		query_complete = "<b>" + EDIT_MENU_ITEMS_MENU_ITEMS_UPDATED_MSG + "<\/b><br/>\n";
		query_starting = EDIT_MENU_ITEMS_UPDATING_MENU_ITEMS_MSG;
	}
	
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var rows_str = xmlhttp.responseText;
//				alert(rows_str);
				if (rows_str == "-no data-")
					popup_msg.status_msg = query_complete_no_record;
				else
					popup_msg.status_msg = query_complete;
				if ((Source == "Populate") || (Source == "Delete") || (Source == "UpdateAll"))
					PopulateTable(rows_str);
			}
			else
				popup_msg.status_msg = query_complete_no_record;

			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = query_read_to_send;
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = query_sent;
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = query_starting;
			
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

////////////////////////////////////////////////////////////////////////////////////
function AddMenuItem(i)
{
	if (unsaved_new_item === true)	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = EDIT_MENU_ITEMS_ADD_BEFORE_SAVE_NEW_MSG;
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.ShowPopupMsg();
		return;
	}
	
	update_all = true;
	window.parent.SetWorkSavedNotSaved(false);
	unsaved_new_item = true;
	
	var html = document.getElementById("MenuItemsTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var d = 0;
	var srch_str;
	
	if ((browser == "Explorer") && (browser_version < 9))
		srch_str = "<TR id=row" + i;
	else
		srch_str = "<tr id=\"row" + i + "\"";
		
	var html_arr = new Array();
	html_arr = html.split(srch_str);
	var html_top = html_arr[0];
	var html_bottom = html.substring(html_top.length);

	var bgclr = "#FFFF99";
	var new_row = "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/indent_remove.png' border=0 alt='Indent Remove' name='IndentRemove' id='IndentRemove" + i + "' onClick=\"IndentItemRemove(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/indent.png' border=0 alt='Indent' name='Indent' id='Indent" + i + "' onClick=\"IndentItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'><input type='hidden' name='ID" + i + "' id='ID" + i + "' value='-1'>\n";
	new_row = new_row + "<input type='text' name='item_text" + i + "' id='item_text" + i + "' value='' onchange=\"SetElementValue('item_text" + i + "', -1);\" onmouseout=\"SetElementVal('item_text" + i + "');\" onkeypress=\"SetCurrentItem('item_text" + i + "', -1);\"><\/td>\n";
		
	new_row = new_row + "<td>\n";
	new_row = new_row + "<input type='hidden' id='level" + i + "' value='' />\n";
	new_row = new_row + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_TOP_LEVEL + "<\/span>\n";
	new_row = new_row + "<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='selectPage" + i + "' id='selectPage" + i + "' onChange=\"PopulatePage(" + i + ");\">\n";
	new_row = new_row + "<option value=''>" + _NOT_SELECTED_ + "<\/option>\n";
	for (var k = 0; k < page_cnt; k++)
	{
		new_row = new_row + "<option value='" + pages[k] + "'>" + pages[k] + "<\/option>\n";
	}
	new_row = new_row + "<\/select>\n";
	new_row = new_row + "<input type='text' name='URL" + i + "' id='URL" + i + "' value='' onchange=\"SetElementValue('URL" + i + "', -1);\"><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='target_select" + i + "' id='target_select" + i + "' onChange=\"PopulateTarget(" + i + ");\">\n";
	new_row = new_row + "<option value='_self'>" + SELF_NORMAL + "<\/option>\n";
	new_row = new_row + "<option value='_blank'>" + NEW_WINDOW + "<\/option>\n";
	new_row = new_row + "<option value='" + ENTER_FRAME_NAME + "'>" + NAMED_FRAME + "<\/option>\n";
	new_row = new_row + "<\/select>\n";
	new_row = new_row + "<input type='hidden' name='target" + i + "' id='target" + i + "' value='' onclick=\"if (this.value == '" + ENTER_FRAME_NAME + "') this.value = '';\"><\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n";
	new_row = new_row + "<select name='mega_menu" + i + "' id='mega_menu" + i + "' onchange=\"SetElementValue(-1, 'mega_menu" + i + "');\">\n";
	new_row = new_row + "<option value=''>" + _NOT_SELECTED_ + "<\/option>\n";
	for (var k = 0; k < mega_menu_cnt; k++)
	{
		new_row = new_row + "<option value='" + mega_menus[k] + "'>" + mega_menus[k] + "<\/option>\n";
	}
	new_row = new_row + "<\/select>\n</td>\n";
	
	new_row = new_row + "<td valign='top'>\n<input type='hidden' id='sort_order" + i + "' name='sort_order" + i + "' value='' />\n";
	new_row = new_row + "<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateMenuItem(-1, " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddMenuItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id='MoveUp" + i + "' onClick=\"MoveItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	d = parseInt(i) + 1;
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/arrow-down.png' border=0 alt='Move Down' name='MoveDown' id='MoveDown" + i + "' onClick=\"MoveItemDown(" + d + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<td valign='top'>\n<img src='theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm('', -1, " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	
	new_row = new_row + "<\/tr>\n";

	var n = i - 1;
	var rplc_str;
	for (var j = cnt; j >= i; j--)
	{
		k = j + 1;
		srch_str = "row" + j;
		rplc_str = "row" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "ID" + j;
		rplc_str = "ID" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "item_text" + j;
		rplc_str = "item_text" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "level" + j;
		rplc_str = "level" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "level_text" + j;
		rplc_str = "level_text" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "selectPage" + j;
		rplc_str = "selectPage" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "PopulatePage(" + j;
		rplc_str = "PopulatePage(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "URL" + j;
		rplc_str = "URL" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "target_select" + j;
		rplc_str = "target_select" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "PopulateTarget(" + j;
		rplc_str = "PopulateTarget(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "target" + j;
		rplc_str = "target" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "sort_order" + j;
		rplc_str = "sort_order" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "mega_menu" + j;
		rplc_str = "mega_menu" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "UpdateMenuItem(-1, " + j;
		rplc_str = "UpdateMenuItem(-1, " + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "AddMenuItem(" + j;
		rplc_str = "AddMenuItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "DeleteConfirm('', -1, " + j;
		rplc_str = "DeleteConfirm('', -1, " + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveUp" + j;
		rplc_str = "MoveUp" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveDown" + j;
		rplc_str = "MoveDown" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveItem(" + j;
		rplc_str = "MoveItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "MoveItemDown(" + j;
		rplc_str = "MoveItemDown(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "Indent" + j;
		rplc_str = "Indent" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "IndentRemove" + j;
		rplc_str = "IndentRemove" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "IndentItem(" + j;
		rplc_str = "IndentItem(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
		srch_str = "IndentItemRemove(" + j;
		rplc_str = "IndentItemRemove(" + k;
		html_bottom = html_bottom.replace(srch_str,rplc_str);
	}
	html = html_top + new_row + html_bottom;
	document.getElementById("MenuItemsTable").innerHTML = html;
	cnt++;
	document.getElementById("nCount").value = cnt;
	
	if (n > 0)
	{
		var m = n + 1
		var nesting_level_ctl = "level" + m;
		var parent_nesting_level_ctl = "level" + n;
		var nesting_level_text_ctl = "level_text" + m;
		var parent_nesting_text_level_ctl = "level_text" + n;
		document.getElementById(nesting_level_ctl).value = document.getElementById(parent_nesting_level_ctl).value;
		document.getElementById(nesting_level_text_ctl).innerHTML = document.getElementById(parent_nesting_text_level_ctl).innerHTML;
	}
	else
	{
		document.getElementById("level0").value = 0;
		document.getElementById("level_text0").innerHTML = EDIT_MENU_ITEMS_TOP_LEVEL;
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById("MoveUp1").style.display = "table-row";
		document.getElementById("Indent0").style.display = "none";
		document.getElementById("Indent1").style.display = "table-row";
		document.getElementById("IndentRemove0").style.display = "none";
		document.getElementById("IndentRemove1").style.display = "table-row";
	}
}

////////////////////////////////////////////////////////////////////////////////////
function RetrieveMenuItems()
{
	if ((document.getElementById("selectMenu").value) == "-not selected-")
	{
		document.getElementById("MenuItemsTable").innerHTML ="&nbsp;\n";
		document.getElementById("update").style.display = "none";
		document.getElementById("select_menu_msg_div").style.display = "block";
		return;
	}
	else
	{
		document.getElementById("update").style.display = "block";
		document.getElementById("update").style.width = "130px";
		document.getElementById("select_menu_msg_div").style.display = "none";
	}
		
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDIT_MENU_ITEMS_RETRIEVING_MENU_ITEMS_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_menu_items.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "Populate");
		var params = "menu=" + document.getElementById("selectMenu").value;
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateTable(rows_str)
{
	var rows = new Array();
	var fields = new Array();
	var d = 0;
	var tmp;
	
	var output_str = "<table width='90%' align='center'>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + EDIT_MENU_ITEMS_ITEM_TEXT + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + EDIT_MENU_ITEMS_NESTING_LEVEL + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + EDIT_MENU_ITEMS_URL + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + EDIT_MENU_ITEMS_TARGET_WINDOW + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + EDIT_MENU_ITEMS_MEGA_MENU + "<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<td colspan='2'>&nbsp;<\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	
	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no menu items yet (first time).
		var i = 0;
	else	// Create rows for menu items.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			if (bgclr == "#dddddd")
				bgclr = "#eeeeee";
			else
				bgclr = "#dddddd";
				
			output_str = output_str + "<tr id=\"row" + i + "\" bgcolor=\"" + bgclr + "\">\n";
				
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/indent_remove.png' border=0 alt='Indent Remove' name='IndentRemove' id='IndentRemove" + i + "' onClick=\"IndentItemRemove(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/indent.png' border=0 alt='Indent' name='Indent' id='Indent" + i + "' onClick=\"IndentItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
				
			output_str = output_str + "<td valign='top'><input type='hidden' name='ID" + i + "' id='ID" + i + "' value='" + JSON_row.ID + "'>\n";
			output_str = output_str + "<input type='text' name='item_text" + i + "' id='item_text" + i + "' value='" + Indent(JSON_row.level) + JSON_row.item_text + "' onchange=\"SetElementValue('item_text" + i + "', -1);\" onmouseout=\"SetElementVal('item_text" + i + "');\" onkeypress=\"SetCurrentItem('item_text" + i + "', -1);\"><\/td>\n";
				
			output_str = output_str + "<td>\n";
			output_str = output_str + "<input type='hidden' id='level" + i + "' value='" + JSON_row.level + "' />\n";
			if ((JSON_row.level == 0) || !JSON_row.level)
				output_str = output_str + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_TOP_LEVEL + "<\/span>\n";
			else if (JSON_row.level == 1)
				output_str = output_str + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_1ST_SUB_LEVEL + "<\/span>\n";
			else if (JSON_row.level == 2)
				output_str = output_str + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_2ND_SUB_LEVEL + "<\/span>\n";
			else if (JSON_row.level == 3)
				output_str = output_str + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_3RD_SUB_LEVEL + "<\/span>\n";
			else if (JSON_row.level == 4)
				output_str = output_str + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_4TH_SUB_LEVEL + "<\/span>\n";
			else if (JSON_row.level == 5)
				output_str = output_str + "<span id='level_text" + i + "'>" + EDIT_MENU_ITEMS_5TH_SUB_LEVEL + "<\/span>\n";
			output_str = output_str + "<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='selectPage" + i + "' id='selectPage" + i + "' onChange=\"PopulatePage(" + i + ");\">\n";
			output_str = output_str + "<option value=''>-not selected-<\/option>\n";
			
			for (var j = 0; j < page_cnt; j++)
			{
				if (pages_full[j] == JSON_row.URL)
					output_str = output_str + "<option value='" + pages[j] + "' selected='selected'>" + pages[j] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + pages[j] + "'>" + pages[j] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n";
			
			output_str = output_str + "<input type='text' name='URL" + i + "' id='URL" + i + "' value='" + JSON_row.URL + "' onchange=\"SetElementValue('URL" + i + "', -1);\"><\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='target_select" + i + "' id='target_select" + i + "' onChange=\"PopulateTarget(" + i + ");\">\n";
			if (!JSON_row.target)
				JSON_row.target = "_self";
			if (JSON_row.target == "_self")
				output_str = output_str + "<option value='_self' selected='selected'>" + SELF_NORMAL + "<\/option>\n";
			else
				output_str = output_str + "<option value='_self'>" + SELF_NORMAL + "<\/option>\n";
			if (JSON_row.target == "_blank")
				output_str = output_str + "<option value='_blank' selected='selected'>" + NEW_WINDOW + "<\/option>\n";
			else
				output_str = output_str + "<option value='_blank'>" + NEW_WINDOW + "<\/option>\n";
			if ((JSON_row.target != "_blank") && (JSON_row.target != "_self"))
				output_str = output_str + "<option value='" + ENTER_FRAME_NAME + "' selected='selected'>" + NAMED_FRAME + "<\/option>\n";
			else
				output_str = output_str + "<option value='" + ENTER_FRAME_NAME + "'>" + NAMED_FRAME + "<\/option>\n";
			output_str = output_str + "<\/select>\n";
			if ((JSON_row.target == "_blank") || (JSON_row.target == "_self"))
				output_str = output_str + "<input type='hidden' name='target" + i + "' id='target" + i + "' value='" + JSON_row.target + "' onclick=\"if (this.value == '" + ENTER_FRAME_NAME + "') this.value = '';\"><\/td>\n";
			else
				output_str = output_str + "<input type='text' name='target" + i + "' id='target" + i + "' value='" + JSON_row.target + "' onclick=\"if (this.value == '" + ENTER_FRAME_NAME + "') this.value = '';\"><\/td>\n";
				
			output_str = output_str + "<td valign='top'>\n";
			output_str = output_str + "<select name='mega_menu" + i + "' id='mega_menu" + i + "' onchange=\"SetElementValue(-1, 'mega_menu" + i + "');\">\n";
			output_str = output_str + "<option value=''>" + _NOT_SELECTED_ + "<\/option>\n";
			for (var k = 0; k < mega_menu_cnt; k++)
			{
				if (mega_menus[k] == JSON_row.mega_menu)
					output_str = output_str + "<option value='" + mega_menus[k] + "' selected='selected'>" + mega_menus[k] + "<\/option>\n";
				else
					output_str = output_str + "<option value='" + mega_menus[k] + "'>" + mega_menus[k] + "<\/option>\n";
			}
			output_str = output_str + "<\/select>\n</td>\n";
			
			output_str = output_str + "<td valign='top'>\n<input type='hidden' id='sort_order" + i + "' name='sort_order" + i + "' value='" + JSON_row.sort_order + "' />\n";
			
			output_str = output_str + "<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"UpdateMenuItem(" + JSON_row.ID + ", " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddMenuItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id='MoveUp" + i + "' onClick=\"MoveItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			d = parseInt(i) + 1;
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/arrow-down.png' border=0 alt='Move Down' name='MoveDown'  id='MoveDown" + i + "' onClick=\"MoveItemDown(" + d + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			tmp = JSON_row.item_text;
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			tmp = tmp.replace("&#39;", "");
			output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/delete.png' border=0 alt='Delete' name='Delete' onClick=\"DeleteConfirm('" + tmp + "', " + JSON_row.ID + ", " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
			output_str = output_str + "<\/tr>\n";
		}
		i++;
	}
	if (bgclr == "#dddddd")
		bgclr = "#eeeeee";
	else
		bgclr = "#dddddd";
	output_str = output_str + "<tr id=\"row" + i + "\" bgcolor='" + bgclr + "'>\n";
	output_str = output_str + "<td colspan='7'>&nbsp;<\/td>\n";
	output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/plus.png' border=0 alt='Insert Above' name='Insert' onClick=\"AddMenuItem(" + i + ");\" style='cursor:pointer;' />\n<\/td>\n";
	output_str = output_str + "<td colspan='3'>&nbsp;<\/td>\n";
	output_str = output_str + "<\/tr>\n";
	output_str = output_str + "<\/table>\n";
	
	document.getElementById("MenuItemsTable").innerHTML = output_str;
	document.getElementById("nCount").value = i;
	
	if (rows[0] != "-no data-")
	{
		var LastMoveDown = "MoveDown" + (i - 1);
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById("Indent0").style.display = "none";
		document.getElementById("IndentRemove0").style.display = "none";
	}
}

///////////////////////////////////////////////////////////////////////////////////
function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = EDIT_MENU_ITEMS_NOT_SAVED_CONFIRM_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	UpdateAll();
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

////////////////////////////////////////////////////////////////////////////////////////
function MoveItem(i)
{
	update_all = true;
	window.parent.SetWorkSavedNotSaved(false);
	
	var html = document.getElementById("MenuItemsTable").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var t = i - 1;
	var b = i + 1;
	var srch_str_t;
	var srch_str_b;
	var srch_str_i;
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		srch_str_t = "<TR id=row" + t;
		srch_str_b = "<TR id=row" + b;
		srch_str_i = "<TR id=row" + i;
	}
	else
	{
		srch_str_t = "<tr id=\"row" + t + "\"";
		srch_str_b = "<tr id=\"row" + b + "\"";
		srch_str_i = "<tr id=\"row" + i + "\"";
	}
	
	// Get top part of table.
	var html_top = html.substring(0, html.indexOf(srch_str_t));
	
	// Get bottom part of table.
	var html_bottom = html.substring(html.indexOf(srch_str_b));
	
	// Get row to move down.
	var html_move_down = html.substring(html_top.length, html.indexOf(srch_str_i));
	
	// Get row to move up.
	var html_move_up = html.substring(html_top.length + html_move_down.length, html.indexOf(srch_str_b));
	
	var rplc_str;
	srch_str = "row" + t;
	rplc_str = "row" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "ID" + t;
	rplc_str = "ID" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "item_text" + t;
	rplc_str = "item_text" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "level" + t;
	rplc_str = "level" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "level_text" + t;
	rplc_str = "level_text" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "selectPage" + t;
	rplc_str = "selectPage" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "PopulatePage(" + t;
	rplc_str = "PopulatePage(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "URL" + t;
	rplc_str = "URL" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "target_select" + t;
	rplc_str = "target_select" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "PopulateTarget(" + t;
	rplc_str = "PopulateTarget(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "target" + t;
	rplc_str = "target" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "sort_order" + t;
	rplc_str = "sort_order" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "UpdateMenuItem(-1, " + t;
	rplc_str = "UpdateMenuItem(-1, " + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "AddMenuItem(" + t;
	rplc_str = "AddMenuItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "DeleteConfirm('', -1, " + t;
	rplc_str = "DeleteConfirm('', -1, " + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveUp" + t;
	rplc_str = "MoveUp" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveDown" + t;
	rplc_str = "MoveDown" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItem(" + t;
	rplc_str = "MoveItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItemDown(" + i;
	rplc_str = "MoveItemDown(" + b;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "Indent" + t;
	rplc_str = "Indent" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "IndentRemove" + t;
	rplc_str = "IndentRemove" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "IndentItem(" + t;
	rplc_str = "IndentItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "IndentItemRemove(" + t;
	rplc_str = "IndentItemRemove(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	
	var topclr = "#aaffaa";
	var botclr = "#ffaaaa";
	var bgclr1 = "#dddddd";
	var bgclr2 = "#eeeeee";
	html_move_up = html_move_up.replace(bgclr1,topclr);
	html_move_up = html_move_up.replace(bgclr2,topclr);
	html_move_down = html_move_down.replace(bgclr1,botclr);
	html_move_down = html_move_down.replace(bgclr2,botclr);
			
	html = html_top + html_move_up + html_move_down + html_bottom;
	
	var cnt_1 = cnt - 1;
	var cnt_2 = cnt - 2;
	LastMoveDown = "MoveDown" + cnt_1;
	NextToLastMoveDown = "MoveDown" + cnt_2;
	
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		// This next block of code is intenended to fix an id attribute issue with IE, but does not work.
		srch_str = "id=" + LastMoveDown;
		rplc_str = "id='" + LastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		srch_str = "id=" + NextToLastMoveDown;
		rplc_str = "id='" + NextToLastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		html = html.replace("id=MoveUp0","id=\"MoveUp0\"");
		html = html.replace("id=MoveUp1","id=\"MoveUp1\"");
		html = html.replace("id=IndentRemove0","id=\"IndentRemove0\"");
		html = html.replace("id=IndentRemove1","id=\"IndentRemove1\"");
		
		// Note the order in which the HTML is added to the element.
		document.getElementById("MenuItemsTable").innerHTML = html;
		
		// Since the trick above for fixing the ids did not work, just update everthing now which will refresh the page.
		UpdateAll();
	}
	else
	{
		// Note the order in which the HTML is added to the element.
		document.getElementById("MenuItemsTable").innerHTML = html;
		
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById(NextToLastMoveDown).style.display = "table-row";
		document.getElementById("MoveUp1").style.display = "table-row";
		document.getElementById("Indent0").style.display = "none";
		document.getElementById("Indent1").style.display = "table-row";
		document.getElementById("IndentRemove0").style.display = "none";
		document.getElementById("IndentRemove1").style.display = "table-row";
	}
}

function MoveItemDown(i)
{
	MoveItem(i);
}

///////////////////////////////////////////////////////////////////////////////////
function IndentItem(i)
{	
	var j = i - 1;
	var nesting_level_ctl = "level" + i;
	var parent_nesting_level_ctl = "level" + j;
	var nesting_level = document.getElementById(nesting_level_ctl).value;
	var parent_nesting_level = document.getElementById(parent_nesting_level_ctl).value;
	var indent = "   ";
	
	if ((nesting_level < 5) && (nesting_level <= parent_nesting_level))
	{
		window.parent.SetWorkSavedNotSaved(false);
		
		nesting_level++;
		var item_text_ctl = "item_text" + i;
		document.getElementById(item_text_ctl).value = indent + document.getElementById(item_text_ctl).value;
		document.getElementById(nesting_level_ctl).value = nesting_level;
		var nesting_level_text_ctl = "level_text" + i;
		if (nesting_level == 0)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_TOP_LEVEL;
		else if (nesting_level == 1)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_1ST_SUB_LEVEL;
		else if (nesting_level == 2)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_2ND_SUB_LEVEL;
		else if (nesting_level == 3)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_3RD_SUB_LEVEL;
		else if (nesting_level == 4)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_4TH_SUB_LEVEL;
		else if (nesting_level == 5)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_5TH_SUB_LEVEL;
	}
}

function IndentItemRemove(i)
{	
	var j = i - 1;
	var nesting_level_ctl = "level" + i;
	var parent_nesting_level_ctl = "level" + j;
	var nesting_level = document.getElementById(nesting_level_ctl).value;
	var parent_nesting_level = document.getElementById(parent_nesting_level_ctl).value;
	
	if (nesting_level > 0)
	{
		window.parent.SetWorkSavedNotSaved(false);
		
		nesting_level--;
		var item_text_ctl = "item_text" + i;
		var item_text = document.getElementById(item_text_ctl).value;
		item_text = item_text.trim();
		
		document.getElementById(nesting_level_ctl).value = nesting_level;
		var nesting_level_text_ctl = "level_text" + i;
		if (nesting_level == 0)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_TOP_LEVEL;
		else if (nesting_level == 1)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_1ST_SUB_LEVEL;
		else if (nesting_level == 2)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_2ND_SUB_LEVEL;
		else if (nesting_level == 3)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_3RD_SUB_LEVEL;
		else if (nesting_level == 4)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_4TH_SUB_LEVEL;
		else if (nesting_level == 5)
			document.getElementById(nesting_level_text_ctl).innerHTML = EDIT_MENU_ITEMS_5TH_SUB_LEVEL;

		document.getElementById(item_text_ctl).value = Indent(nesting_level) + item_text;
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function PopulatePage(i)
{
	var pageSelect_ctl = "selectPage" + i;
	var URL_ctl = "URL" + i;
	var url = "";
	if (document.getElementById(pageSelect_ctl).value != "")
		url = document.getElementById(pageSelect_ctl).value + ".php";
	document.getElementById(URL_ctl).value = url;

	window.parent.SetWorkSavedNotSaved(false);

	SetElementValue(URL_ctl, pageSelect_ctl);
}

function PopulateTarget(i)
{
	var target_select_ctl = "target_select" + i;
	var target_ctl = "target" + i;
	var target = document.getElementById(target_select_ctl).value;
	document.getElementById(target_ctl).value = target;
	
	if ((target != "_self") && (target != "_blank"))
		document.getElementById(target_ctl).type = "text";
	else
		document.getElementById(target_ctl).type = "hidden";
	
	window.parent.SetWorkSavedNotSaved(false);
	
	SetElementValue(target_ctl, target_select_ctl);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function SetElementValue(el_id, el_id_2)
{
	var html = document.getElementById("MenuItemsTable").innerHTML;

	if (el_id != -1)	{
		var val = document.getElementById(el_id).value;
		var srch = "id=\"" + el_id;
		var pos1 = html.indexOf(srch, 0);
		if (pos1 == -1)	{
			srch = "id='" + el_id;
			pos1 = html.indexOf(srch, 0);
		}
		srch = "value=";
		var pos2 = html.indexOf(srch, pos1);
		srch = "\"";
		var pos3 = html.indexOf(srch, pos2);
		if (pos3 == -1)	{	// In case browser replaced single quotes with double quotes.
			srch = "'";
			pos3 = html.indexOf(srch, pos2);
		}
		var pos4 = html.indexOf(srch, pos3 + 1);
		var html_start = html.substr(0, pos2);
		var html_end = html.substr(pos4 + 1);
		html = html_start + "value='" + val + "'" + html_end;
	}

	if (el_id_2 != -1)	{
		var val = document.getElementById(el_id_2).value;
		var srch = "id=\"" + el_id_2;
		var pos1 = html.indexOf(srch, 0);
		if (pos1 == -1)	{
			srch = "id='" + el_id_2;
			pos1 = html.indexOf(srch, 0);
		}
		// Get position of next id to compare in case nothing is selected.
		srch = "id=";
		var pos5 = html.indexOf(srch, pos1 + 1);
		// First remove selected option.
		srch = "selected="
		var pos2 = html.indexOf(srch, pos1);
		if ((pos2 < pos5) && (pos2 > -1))	{	// If not true, then nothing selected.
			var html_start = html.substr(0, pos2);
			var html_end = html.substr(pos2 + 19);
			html = html_start + html_end;
		}
		// Now go ahead and insert selected option.
		srch = "value=\"" + val;
		pos2 = html.indexOf(srch, pos1);
		if (pos2 == -1)	{	// In case browser replaced single quotes with double quotes.
			srch = "value='" + val;
			pos2 = html.indexOf(srch, pos1);
		}
		srch = "\"";
		var pos3 = html.indexOf(srch, pos2 + 7);
		if (pos3 == -1)	{
			srch = "'";
			pos3 = html.indexOf(srch, pos2);
		}
		srch = ">"
		var pos4 = html.indexOf(srch, pos3);
		html_start = html.substr(0, pos3 + 1);
		html_end = html.substr(pos4);
		html = html_start + " selected='selected'" + html_end;
	}
	
	document.getElementById("MenuItemsTable").innerHTML = html;

	curr_item_under_edit = "";
}

function SetElementVal(el_id)
{
	if (el_id == curr_item_under_edit)	{
		SetElementValue(el_id, -1);
	}
}

function SetCurrentItem(el_id)
{
	curr_item_under_edit = el_id;
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}