/////////////////////////////////////////////
// Manage Head /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 7/1/2013	ELL
// Revised: 11/21/2014	ELL
// Added "redirect" to DeleteHead call.
// Revised: 11/12/2015	ELL
// Converted from HTML/PHP POST application to AJAX application.
// Added list of pages to auto-populate suffix for new head content to make creating head content with meaningful names as default behavior,
// and to allow for automatic assignment at head content creation.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var head_names = new Array();

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_head", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function UpdateSuffix(suffix)
{
	document.getElementById("suffix").value = suffix;
	if (suffix == "")
		GetNextIndex();
}

function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_HEAD_DELETE_HEAD_CONFIRM_1_MSG + " <b>" + document.getElementById("head_name_delete").value + "</b> " + MANAGE_HEAD_DELETE_HEAD_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteHead(); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteHead()
{
	var head_name = document.getElementById("head_name_delete").value;
	popup_msg.HidePopupMsg();
	$.post( "delete_head.php", { head_name: head_name, redirect: "-no redirect-" } ).done(CompleteDeleteHead) ;
}
function CompleteDeleteHead(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = MANAGE_HEAD_DELETED_1_MSG + " <b>" + data_arr[1] + "</b> " + MANAGE_HEAD_DELETED_2_MSG;
	else
		popup_msg.status_msg = MANAGE_HEAD_DELETED_ERR + " <b>" + data_arr[1] + "</b>.";
		
	popup_msg.ShowPopupMsg();
	
	GetNextIndex();
	GetHeads();
	GetHeadAssignments();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetHeads()
{
	$.post( "get_rows.php", { table: "head", order_by: "head_name" } ).done(PopulateHeads) ;
}
function PopulateHeads(data)
{
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")
		alert(MANAGE_HEAD_NO_HEADS_FOUND_ERR);
	else
	{
		head_names = [];
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			head_names[i] = JSON_row.head_name;
		}
		
		head_old_name_el = document.getElementById("head_old_name");
		head_name_delete_el = document.getElementById("head_name_delete");
		for (i = head_old_name_el.length - 1; i >= 0; i--)	{
			  head_old_name_el.remove(i);
		}
		for (i = head_name_delete_el.length - 1; i >= 0; i--)	{
			  head_name_delete_el.remove(i);
		}

		for (var i in head_names)
		{
			if (head_names[i] != "head")
			{
				var elOpt1 = document.createElement('option');
				elOpt1.text = head_names[i];
				elOpt1.value = head_names[i];
				
				try {
					head_old_name_el.add(elOpt1, null); // standards compliant; doesn't work in IE
				}
				catch(ex) {
					head_old_name_el.add(elOpt1); // IE only
				}
				
				var elOpt2 = document.createElement('option');
				elOpt2.text = head_names[i];
				elOpt2.value = head_names[i];
				
				try {
					head_name_delete_el.add(elOpt2, null); // standards compliant; doesn't work in IE
				}
				catch(ex) {
					head_name_delete_el.add(elOpt2); // IE only
				}
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetHeadAssignments()
{
	// Note: get_border_area_assignments.php works fine for head assignments too.
	$.post( "get_border_area_assignments.php", { } ).done(PopulateHeadAssignmentTable) ;
}
function PopulateHeadAssignmentTable(data)
{
	var rows = new Array();
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")
		alert(MANAGE_HEAD_NO_HEADS_FOUND_ERR);
	else
	{	
		var html = "<table width='100%' class='layout_box_table' align='center'>\n";
		html = html + "<tr bgcolor='#CCCCCC'>\n";
  		html = html + "<td colspan='3'><span class='sub_title'>" + MANAGE_HEAD_ASSIGN_HEAD_CONTENT_TO_PAGE + "</span></td></tr>\n";
		var bgcolor = "#EEEEEE";
  
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			
			html = html +  "<tr bgcolor='" + bgcolor + "'>\n";
			html = html +  "<td>" + JSON_row.page_name + "</td>";
			
			/////////////////////////////////////////
			//Test to see if file already exists.
			if (JSON_row.file_exists == 0)
			{
				html = html + ERROR_WORD + ": " + JSON_row.file_name + " " + CLICK_WORD + " " + MANAGE_HEAD_NOT_FOUND_1_ERR + " <a href=\"manage_head.php\" title=\"" + HERE_WORD + "\">" + HERE_WORD + "</a> " + MANAGE_HEAD_NOT_FOUND_2_ERR;
			}
			/////////////////////////////////////////
				
			html = html + "<td>\n";
			
				html = html + "<select name='head_name' id='head_name" + i + "'>\n";
				for (var j in head_names)
				{
					if (head_names[j] == JSON_row.head_name)
						html = html + "<option value='" + head_names[j] + "' selected='selected'>" + head_names[j] + "</option>\n";
					else
						html = html +  "<option value='" + head_names[j] + "'>" + head_names[j] + "</option>\n";
				}
				html = html +  "</select>\n";
			
			html = html +  "</td>\n";
			
			html = html + "<td>\n";
			
			html = html + "<div class='button_console_edit' style='width:110px;' onClick=\"AssignHead('" + JSON_row.page_name + "', " + i + ");\"><span class='button_console_text_w_icon'>" + ASSIGN_WORD + "</span></div>\n";
			
			html = html + "</td>\n";
			html = html + "</tr>\n";
			if (bgcolor == "#EEEEEE")
				bgcolor = "#DDDDDD";
			else
				bgcolor = "#EEEEEE";
		}
		html = html + "</table>\n";
		
		document.getElementById("head_assignment_table").innerHTML = html;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function AssignHead(page_name, i)
{
	var head_name_el = "head_name" + i;
	
	var head_name = document.getElementById(head_name_el).value;
	
	$.post( "assign_head.php", { page_name: page_name, head_name: head_name } ).done(AssignHeadComplete) ;
}
function AssignHeadComplete(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = "<b>" + data_arr[1] + "</b> " + MANAGE_HEAD_ASSIGNED_1_MSG + " <b>" + data_arr[2] + "</b> " + MANAGE_HEAD_ASSIGNED_2_MSG;
	else if (data_arr[0] == 0)
		popup_msg.status_msg = MANAGE_HEAD_ALREADY_ASSIGNED_1_ERR + " <b>" + data_arr[1] + "</b> " + MANAGE_HEAD_ASSIGNED_2_ERR + " <b>" + data_arr[2] + "</b> " + MANAGE_HEAD_ALREADY_ASSIGNED_3_ERR;
	else
		popup_msg.status_msg = MANAGE_HEAD_ASSIGNED_1_ERR + " <b>" + data_arr[1] + "</b> " + MANAGE_HEAD_ASSIGNED_2_ERR + " <b>" + data_arr[2] + "</b> " + MANAGE_HEAD_ASSIGNED_3_ERR;
		
	popup_msg.ShowPopupMsg();

}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetNextIndex()
{
	$.post( "get_next_index_head.php", { } ).done(PopulateIndex) ;
}
function PopulateIndex(data)
{
	document.getElementById("suffix").value = data;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function AddHead()
{	
	var suffix = document.getElementById("suffix").value;
	var assign_head = 0;
	if (document.getElementById("suffix").value == document.getElementById("new_head_suffix").value)
		assign_head = 1;
	if ((head_names.indexOf("head_" + suffix)) < 0)
		$.post( "add_head.php", { suffix: suffix, assign_head: assign_head } ).done(CompleteAddHead) ;
	else	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 300;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 3000;
		popup_msg.status_msg = MANAGE_HEAD_PAGE_ALREADY_EXISTS_1_ERR + " <b>head_" + suffix + "</b> " + MANAGE_HEAD_PAGE_ALREADY_EXISTS_2_ERR;
		popup_msg.ShowPopupMsg();
		document.getElementById("suffix").className = "highlight";
	}
}
function CompleteAddHead(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = MANAGE_HEAD_ADDED_1_MSG + " <b>" + data_arr[1] + "</b> " + MANAGE_HEAD_ADDED_2_MSG;
	else
		popup_msg.status_msg = MANAGE_HEAD_ADDED_ERR + " <b>" + data_arr[1] + "</b>.";
		
	popup_msg.ShowPopupMsg();
	GetNextIndex();
	GetHeads();
	GetHeadAssignments();
}

function ClearHighlight(el)
{
	if (el.className == "highlight")
		el.className = "";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function RenameHead()
{
	var head_old_name = document.getElementById("head_old_name").value;
	var name_prefix = document.getElementById("name_prefix").value;
	var name_suffix = document.getElementById("name_suffix").value;
	$.post( "rename_head.php", { head_old_name: head_old_name, name_prefix: name_prefix, name_suffix: name_suffix } ).done(CompleteRenameHead) ;
}
function CompleteRenameHead(data)
{
	data_arr = data.split("@@@@@");
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (data_arr[0] > 0)
		popup_msg.status_msg = " <b>" + data_arr[1] + "</b> " + MANAGE_CUSTOM_BORDER_AREA_RENAMED_MSG + " <b>" + data_arr[2] + "</b>.";
	else
		popup_msg.status_msg = MANAGE_CUSTOM_BORDER_AREA_RENAMED_ERR + " <b>" + data_arr[1] + "</b> " + TO_WORD + " <b>" + data_arr[2] + "</b>.";
		
	popup_msg.ShowPopupMsg();
	
	GetNextIndex();
	GetHeads();
	GetHeadAssignments();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function InitializeConsole()
{
	GetHeads();
	GetHeadAssignments();
	GetNextIndex();
}

///////////////////////////////////////////////////////////////////////////////////////
function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}