/////////////////////////////////////////////
// Restrict Editing Access /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/30/2013	ELL
// Revised: 5/1/2017	ELL
// Changed from defining pages as either being editable by restricted users or not to ability to assign which restricted users have ability to edit any particular page.
// 
// 
//
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#restrict_editing", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function AddAll()
{
	var users_str = users.join(",");
	var frm = document.getElementById('frm_restrict_editing');
	for (var i =0; i < frm.elements.length; i++) 
	{
		frm.elements[i].value = users_str;
	}
}

function ClearAll()
{
	var frm = document.getElementById('frm_restrict_editing');
	for (var i =0; i < frm.elements.length; i++) 
	{
		frm.elements[i].value = "";
	}
}

function AddUser(el_id, user)
{
	if (user != "")
	{
		var page_user_list_el = document.getElementById(el_id);
		var page_user_list = page_user_list_el.value;
		var page_user_list_arr = page_user_list.split(",");
		if (page_user_list_arr.indexOf(user) < 0)	{
			if (page_user_list == "")
				page_user_list = user;
			else
				page_user_list = page_user_list + "," + user;
			page_user_list_el.value = page_user_list;
		}
	}	
}

function SaveAssignments()
{
	$.ajax({type:'POST', url: 'save_restrict_editing.php', data:$('#frm_restrict_editing').serialize(), success: function(response) {
		CompleteSaveAssignments(response);
	}});
}
function CompleteSaveAssignments(response)
{
	if (response == 1)	{
		popup_msg.top_offset = 100;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 3000;
		popup_msg.status_msg = RESTRICT_PAGE_EDITING_RESTRICTIONS_SAVED_MSG;
		popup_msg.ShowPopupMsg();
	}
}