<?php
/////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Build string for site.css file /////
// Revised: 10/8/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 11/21/2010	ELL
// Fixed bug of "not valid mysql resource" by checking for whether or not $result_build_string is set.
//
// Revised: 9/30/2011	ELL
// Added building of download files for open-source customers who purchase templates.
// Mode will switch based on whether or not wizard is enabled in options_selected table.
// If wizard is enabled, setup_site.php copies files to perspective folders and runs
// SQL directly on tables just as originally designed.  If wizard is not enabled,
// setup_site.php creates SQL file from all of the SQL commands, copies all of the
// other necessary files to a temp location, zips these files into a single file, and
// initiates download of zip file to customer.  Open-source customers will then upload
// this zip file into their Breeze Website Builder which will then unpack the files and
// apply template to their site automatically by running the SQL commands in the SQL file
// and copying the perspective files to the correct locations.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear and min/max prefix for width and height.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 12/9/2014	ELL
// Added implementation of custom site and custom mobile site CSS.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
// Revised: 2/14/2015	ELL
// Added visibility.
// Added full compliment of font-size units.
// Added full compliment of length units to border.
// Added full compliment of length units to all paddings.
// Added full compliment of length units to existing unit fields.
// Revised: 5/15/2015	ELL
// Added background transparancy.
// Added overflow-x and overflow-y.
// Modified handling of border style in cases of no border width specified.  If border style = none, then set border to either none
// or border style to none depending on circumstances.
// Added text-indent attribute.
// Revised: 10/20/2016	ELL
// Added handing of custom CSS delimiter to allow splitting of custom CSS around regular CSS.
// Revised: 11/3/2016	ELL
// Added ability to set both min and max widths simultaneously, and both min and max heights simultaneously.
// Revised: 11/3/2016	ELL
// Added ability to set both min and max widths simultaneously, and both min and max heights simultaneously.
// Added lookup and prepend style sheet attributes (@charset, @import, @media).
// Revised: 11/10/2016	ELL
// Modified custom CSS editing to allow for any number of custom CSS records associated with custom style sheets.
// Modified: 12/1/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Revised: 2/2/2017	ELL
// Modified to utilize separate browser reset table for browser reset CSS.
// Revised: 3/29/2017	ELL
// Removed custom font code which now resides in add/delete custom font modules.
// Revised: 4/23/2017	ELL
// Added background RGBA labeled as "Foreground Opaque".
// Revised: 5/22/2017	ELL
// Added justify-content.
// Added various transition, flex and content attributes.
// Added text-transform.
// Revised: 7/12/2017	ELL
// Added ability to set !important based on table entries in site_css_important.
// Revised: 8/24/2017	ELL
// Added background gradient capability.
//
//
function GetLengthUnitsStr($units_index)
{
	switch ($units_index)
	{
		case 0:
			$units = "px";
			break;
		case 1:
			$units = "%";
			break;
		case 2:
			$units = "em";
			break;
		case 3:
			$units = "pt";
			break;
		case 4:
			$units = "pc";
			break;
		case 5:
			$units = "cm";
			break;
		case 6:
			$units = "mm";
			break;
		case 7:
			$units = "in";
			break;
		case 8:
			$units = "rem";
			break;
		case 9:
			$units = "vw";
			break;
		case 10:
			$units = "vh";
			break;
		case 11:
			$units = "vmin";
			break;
		case 12:
			$units = "vmax";
			break;
		case 13:
			$units = "ch";
			break;
		default:
			$units = "px";
	}
	return ($units);
}

function BuildCSSString($style_sheet, $dbh, $base_dir, $image_dir, $bwb = "", $template_id = -1)
{
	if ($base_dir == "")
		$image = "/" . $image_dir . "/";
	else
		$image = "/" . $base_dir . "/" . $image_dir . "/";
		
	$css_string = "";
		
	if ($style_sheet != "browser_reset")
	{
		///////////////////// Get Style Sheet Attributes /////////////////////
		$query_style_sheet_attrib = "SELECT * FROM " . $bwb . "style_sheets WHERE `name` = '" . $style_sheet . "'";
		if ($template_id > -1)
			$query_style_sheet_attrib .= " AND template_id = " . $template_id;
			
		$result_style_sheet_attrib = $dbh->query($query_style_sheet_attrib);
		$row_style_sheet_attrib = $result_style_sheet_attrib->fetch(PDO::FETCH_ASSOC);
		$show_custom_styles = $row_style_sheet_attrib['show_custom_styles'];
		$charset = $row_style_sheet_attrib['charset'];
		$import = $row_style_sheet_attrib['import'];
		$media_type = $row_style_sheet_attrib['media_type'];
		$media_feature = $row_style_sheet_attrib['media_feature'];
		$media_feature_value = $row_style_sheet_attrib['media_feature_value'];
		$media_type_modifier = $row_style_sheet_attrib['media_type_modifier'];
		
		if (isset($charset) && ($charset != ""))
			$css_string .= "@charset \"$charset\";\n\n";
			
		if (isset($import) && ($import != ""))
			$css_string .= "@import url(\"$import\");\n\n";
		
		if (isset($media_type) && ($media_type != ""))	{
			$css_string .= "@media";
			if ($media_type_modifier == 1)
				$css_string .= " not";
			elseif ($media_type_modifier == 2)
				$css_string .= " only";
				
			$css_string .= " $media_type";
				
			if (isset($media_feature) && ($media_feature != ""))	{
				$css_string .= " and ($media_feature";
				if (isset($media_feature_value) && ($media_feature_value != ""))
					$css_string .= ": $media_feature_value)	{\n\n";
				else
					$css_string .= ")	{\n\n";
			}
		}
		//////////////////////////////////////////////////////////////////////
	}
		
	$query_build_string = "SELECT * FROM " . $bwb . "site_css INNER JOIN " . $bwb . "site_classes ON " . $bwb . "site_css.class = " . $bwb . "site_classes.class WHERE " . $bwb . "site_css.style_sheet = '" . $style_sheet . "'";

	if ($template_id > -1)
		$query_build_string .= " AND " . $bwb . "site_css.template_id=" . $template_id;
		
	$query_build_string .= " GROUP BY " . $bwb . "site_classes.class ORDER BY " . $bwb . "site_classes.sort_order ASC, " . $bwb . "site_classes.subclass_sort_order ASC";

	$result_build_string = $dbh->query($query_build_string);
	if ($result_build_string)
	{
		$no_length_arr = array("xx-small","x-small","small","medium","large","x-large","xx-large","smaller","larger","initial","inherit");
		$integer_length_arr = array("px","%");
		while ($row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC))
		{
			if (!is_null($row_bs["use_table_data"])) $use_table_data = $row_bs["use_table_data"];
			else $use_table_data = 0;
			
			if ($use_table_data == 1)
			{
				$class = $row_bs["class"];
				
				if ($row_bs["font"]) $font = $row_bs["font"];
				else $font = "-not selected-";
				if ($row_bs["font2"]) $font2 = $row_bs["font2"];
				else $font2 = "-not selected-";
				if ($row_bs["font3"]) $font3 = $row_bs["font3"];
				else $font3 = "-not selected-";
				if (!is_null($row_bs["font_size"])) $font_size = $row_bs["font_size"];
				else $font_size = -1;
				if (!is_null($row_bs["font_size_units"])) $font_size_units = $row_bs["font_size_units"];
				else $font_size_units = "px";
				if ($row_bs["text_color"]) $text_color = $row_bs["text_color"];
				else $text_color = "-not set-";
				
				if (!is_null($row_bs["padding_top"])) $padding_top = $row_bs["padding_top"];
				else $padding_top = -1;
				if (!is_null($row_bs["padding_right"])) $padding_right = $row_bs["padding_right"];
				else $padding_right = -1;
				if (!is_null($row_bs["padding_bottom"])) $padding_bottom = $row_bs["padding_bottom"];
				else $padding_bottom = -1;
				if (!is_null($row_bs["padding_left"])) $padding_left = $row_bs["padding_left"];
				else $padding_left = -1;
				if (!is_null($row_bs["padding_top_units"])) $padding_top_units = $row_bs["padding_top_units"];
				else $padding_top_units = 0;
				if (!is_null($row_bs["padding_right_units"])) $padding_right_units = $row_bs["padding_right_units"];
				else $padding_right_units = 0;
				if (!is_null($row_bs["padding_bottom_units"])) $padding_bottom_units = $row_bs["padding_bottom_units"];
				else $padding_bottom_units = 0;
				if (!is_null($row_bs["padding_left_units"])) $padding_left_units = $row_bs["padding_left_units"];
				else $padding_left_units = 0;
				
				if ($row_bs["weight"]) $weight = $row_bs["weight"];
				else $weight = "-not selected-";
				if (!is_null($row_bs["italic"])) $italic = $row_bs["italic"];
				else $italic = 0;
				if (!is_null($row_bs["underline"])) $underline = $row_bs["underline"];
				else $underline = 0;
				if (!is_null($row_bs["overline"])) $overline = $row_bs["overline"];
				else $overline = 0;
				if (!is_null($row_bs["blink"])) $blink = $row_bs["blink"];
				else $blink = 0;
				if ($row_bs["linethrough"]) $linethrough = $row_bs["linethrough"];
				else $linethrough = 0;
				if ($row_bs["letter_spacing"]) $letter_spacing = $row_bs["letter_spacing"];
				else $letter_spacing = -1000000;
				if (isset($row_bs["letter_spacing_units"])) $letter_spacing_units = $row_bs["letter_spacing_units"];
				else $letter_spacing_units = -1;
				if ($row_bs["oblique"]) $oblique = $row_bs["oblique"];
				else $oblique = 0;
				if ($row_bs["small_caps"]) $small_caps = $row_bs["small_caps"];
				else $small_caps = 0;
				if ($row_bs["no_text_decoration"]) $no_text_decoration = $row_bs["no_text_decoration"];
				else $no_text_decoration = 0;
				if ($row_bs["shadow"]) $shadow = $row_bs["shadow"];
				else $shadow = 0;
				if ($row_bs["shadow_color"]) $shadow_color = $row_bs["shadow_color"];
				else $shadow_color = "-not set-";
				if ($row_bs["shadow_x_offset"]) $shadow_x_offset = $row_bs["shadow_x_offset"];
				else $shadow_x_offset = 0;
				if ($row_bs["shadow_y_offset"]) $shadow_y_offset = $row_bs["shadow_y_offset"];
				else $shadow_y_offset = 0;
				if ($row_bs["shadow_blur"]) $shadow_blur = $row_bs["shadow_blur"];
				else $shadow_blur = 0;
				if (!is_null($row_bs["line_height"])) $line_height = $row_bs["line_height"];
				else $line_height = -1;
				if (!is_null($row_bs["line_height_units"])) $line_height_units = $row_bs["line_height_units"];
				else $line_height_units = -1;
				if (!is_null($row_bs["text_indent"])) $text_indent = $row_bs["text_indent"];
				else $text_indent = -1000000;
				if (!is_null($row_bs["text_indent_units"])) $text_indent_units = $row_bs["text_indent_units"];
				else $text_indent_units = -1;
				
				if ($row_bs["align"]) $align = $row_bs["align"];
				else $align = "-not selected-";
				if (!is_null($row_bs["vertical_align"])) $vertical_align = $row_bs["vertical_align"];
				else $vertical_align = "-not selected-";
				if ($row_bs["bkgd_color"]) $bkgd_color = $row_bs["bkgd_color"];
				else $bkgd_color = "-not set-";
				if ($row_bs["bkgd_transparent"]) $bkgd_transparent = $row_bs["bkgd_transparent"];
				else $bkgd_transparent = 0;
				if (!is_null($row_bs["bkgd_opacity"])) $bkgd_opacity = $row_bs["bkgd_opacity"];
				else $bkgd_opacity = -1;
				if ($row_bs["bkgd_rgba"]) $bkgd_rgba = $row_bs["bkgd_rgba"];
				else $bkgd_rgba = 0;
				if (!is_null($row_bs["border"])) $border = $row_bs["border"];
				else $border = -1;
				if (!is_null($row_bs["border_units"])) $border_units = $row_bs["border_units"];
				else $border_units = 0;
				if ($row_bs["border_color"]) $border_color = $row_bs["border_color"];
				else $border_color = "-not set-";
				if ($row_bs["border_style"]) $border_style = $row_bs["border_style"];
				else $border_style = "-not selected-";
				if ($row_bs["outline_style"]) $outline_style = $row_bs["outline_style"];
				else $outline_style = "-not selected-";
				if ($row_bs["border_collapse"]) $border_collapse = $row_bs["border_collapse"];
				else $border_collapse = "-not selected-";
				if (!is_null($row_bs["border_sides"])) $border_sides = $row_bs["border_sides"];
				else $border_sides = 15;
				
				if (!is_null($row_bs["margin_top"])) $margin_top = $row_bs["margin_top"];
				else $margin_top = -1000000;
				if (!is_null($row_bs["margin_right"])) $margin_right = $row_bs["margin_right"];
				else $margin_right = -1000000;
				if (!is_null($row_bs["margin_left"])) $margin_left = $row_bs["margin_left"];
				else $margin_left = -1000000;
				if (!is_null($row_bs["margin_bottom"])) $margin_bottom = $row_bs["margin_bottom"];
				else $margin_bottom = -1000000;
				if ($row_bs["display"]) $display = $row_bs["display"];
				else $display = "-not selected-";
				if (!is_null($row_bs["width"])) $width = $row_bs["width"];
				else $width = -1;
				if ($row_bs["width_units"]) $width_units = $row_bs["width_units"];
				else $width_units = 0;
				if ($row_bs["width_prefix"]) $width_prefix = $row_bs["width_prefix"];
				else $width_prefix = "-not selected-";
				if (!is_null($row_bs["max_width"])) $max_width = $row_bs["max_width"];
				else $max_width = -1;
				if ($row_bs["max_width_units"]) $max_width_units = $row_bs["max_width_units"];
				else $max_width_units = 0;
				if (!is_null($row_bs["height"])) $height = $row_bs["height"];
				else $height = -1;
				if ($row_bs["height_units"]) $height_units = $row_bs["height_units"];
				else $height_units = 0;
				if ($row_bs["height_prefix"]) $height_prefix = $row_bs["height_prefix"];
				else $height_prefix = "-not selected-";
				if (!is_null($row_bs["max_height"])) $max_height = $row_bs["max_height"];
				else $max_height = -1;
				if ($row_bs["max_height_units"]) $max_height_units = $row_bs["max_height_units"];
				else $max_height_units = 0;
				if ($row_bs["background_image"]) $background_image = $row_bs["background_image"];
				else $background_image = "-not selected-";
				if ($row_bs["background_attachment"]) $background_attachment = $row_bs["background_attachment"];
				else $background_attachment = "-not selected-";
				if ($row_bs["background_repeat"]) $background_repeat = $row_bs["background_repeat"];
				else $background_repeat = "-not selected-";
				if ($row_bs["background_position"]) $background_position = $row_bs["background_position"];
				else $background_position = "-not selected-";
				if ($row_bs["background_position_x"]) $background_position_x = $row_bs["background_position_x"];
				else $background_position_x = 0;
				if ($row_bs["background_position_y"]) $background_position_y = $row_bs["background_position_y"];
				else $background_position_y = 0;
				if ($row_bs["background_position_units"]) $background_position_units = $row_bs["background_position_units"];
				else $background_position_units = 0;
				
				if ($row_bs["margin_top_units"]) $margin_top_units = $row_bs["margin_top_units"];
				else $margin_top_units = 0;
				if ($row_bs["margin_top_auto"]) $margin_top_auto = $row_bs["margin_top_auto"];
				else $margin_top_auto = 0;
				if ($row_bs["margin_right_units"]) $margin_right_units = $row_bs["margin_right_units"];
				else $margin_right_units = 0;
				if ($row_bs["margin_right_auto"]) $margin_right_auto = $row_bs["margin_right_auto"];
				else $margin_right_auto = 0;
				if ($row_bs["margin_left_units"]) $margin_left_units = $row_bs["margin_left_units"];
				else $margin_left_units = 0;
				if ($row_bs["margin_left_auto"]) $margin_left_auto = $row_bs["margin_left_auto"];
				else $margin_left_auto = 0;
				if ($row_bs["margin_bottom_units"]) $margin_bottom_units = $row_bs["margin_bottom_units"];
				else $margin_bottom_units = 0;
				if ($row_bs["margin_bottom_auto"]) $margin_bottom_auto = $row_bs["margin_bottom_auto"];
				else $margin_bottom_auto = 0;
				
				if ($row_bs["position"]) $position = $row_bs["position"];
				else $position = "-not selected-";
				if (!is_null($row_bs["position_left"])) $position_left = $row_bs["position_left"];
				else $position_left = -1000000;
				if ($row_bs["position_left_units"]) $position_left_units = $row_bs["position_left_units"];
				else $position_left_units = 0;
				if (!is_null($row_bs["position_top"])) $position_top = $row_bs["position_top"];
				else $position_top = -1000000;
				if ($row_bs["position_top_units"]) $position_top_units = $row_bs["position_top_units"];
				else $position_top_units = 0;
				if (!is_null($row_bs["position_right"])) $position_right = $row_bs["position_right"];
				else $position_right = -1000000;
				if ($row_bs["position_right_units"]) $position_right_units = $row_bs["position_right_units"];
				else $position_right_units = 0;
				if (!is_null($row_bs["position_bottom"])) $position_bottom = $row_bs["position_bottom"];
				else $position_bottom = -1000000;
				if ($row_bs["position_bottom_units"]) $position_bottom_units = $row_bs["position_bottom_units"];
				else $position_bottom_units = 0;
				if ($row_bs["z_index"]) $z_index = $row_bs["z_index"];
				else $z_index = 0;
				if ($row_bs["overflow"]) $overflow = $row_bs["overflow"];
				else $overflow = "-not selected-";
				if ($row_bs["overflow_x"]) $overflow_x = $row_bs["overflow_x"];
				else $overflow_x = "-not selected-";
				if ($row_bs["overflow_y"]) $overflow_y = $row_bs["overflow_y"];
				else $overflow_y = "-not selected-";
				if (!is_null($row_bs["clip_top"])) $clip_top = $row_bs["clip_top"];
				else $clip_top = -1;
				if (!is_null($row_bs["clip_top_units"])) $clip_top_units = $row_bs["clip_top_units"];
				else $clip_top_units = -1;
				if (!is_null($row_bs["clip_right"])) $clip_right = $row_bs["clip_right"];
				else $clip_right = -1;
				if (!is_null($row_bs["clip_right_units"])) $clip_right_units = $row_bs["clip_right_units"];
				else $clip_right_units = -1;
				if (!is_null($row_bs["clip_bottom"])) $clip_bottom = $row_bs["clip_bottom"];
				else $clip_bottom = -1;
				if (!is_null($row_bs["clip_bottom_units"])) $clip_bottom_units = $row_bs["clip_bottom_units"];
				else $clip_bottom_units = -1;
				if (!is_null($row_bs["clip_left"])) $clip_left = $row_bs["clip_left"];
				else $clip_left = -1;
				if (!is_null($row_bs["clip_left_units"])) $clip_left_units = $row_bs["clip_left_units"];
				else $clip_left_units = -1;
				if ($row_bs["float"]) $float = $row_bs["float"];
				else $float = "-not selected-";
				if ($row_bs["white_space"]) $white_space = $row_bs["white_space"];
				else $white_space = "-not selected-";
				
				if ($row_bs["list_style_type"]) $list_style_type = $row_bs["list_style_type"];
				else $list_style_type = "-not selected-";
				if ($row_bs["list_style_position"]) $list_style_position = $row_bs["list_style_position"];
				else $list_style_position = "-not selected-";
				if ($row_bs["list_style_image"]) $list_style_image = $row_bs["list_style_image"];
				else $list_style_image = "-not selected-";
				
				if ($row_bs["table_layout"]) $table_layout = $row_bs["table_layout"];
				else $table_layout = "-not selected-";
				if ($row_bs["clear"]) $clear = $row_bs["clear"];
				else $clear = "-not selected-";
				
				if ($row_bs["radius_top_left"]) $radius_top_left = $row_bs["radius_top_left"];
				else $radius_top_left = 0;
				if ($row_bs["radius_top_left_units"]) $radius_top_left_units = $row_bs["radius_top_left_units"];
				else $radius_top_left_units = 0;
				if ($row_bs["radius_top_right"]) $radius_top_right = $row_bs["radius_top_right"];
				else $radius_top_right = 0;
				if ($row_bs["radius_top_right_units"]) $radius_top_right_units = $row_bs["radius_top_right_units"];
				else $radius_top_right_units = 0;
				if ($row_bs["radius_bottom_right"]) $radius_bottom_right = $row_bs["radius_bottom_right"];
				else $radius_bottom_right = 0;
				if ($row_bs["radius_bottom_right_units"]) $radius_bottom_right_units = $row_bs["radius_bottom_right_units"];
				else $radius_bottom_right_units = 0;
				if ($row_bs["radius_bottom_left"]) $radius_bottom_left = $row_bs["radius_bottom_left"];
				else $radius_bottom_left = 0;
				if ($row_bs["radius_bottom_left_units"]) $radius_bottom_left_units = $row_bs["radius_bottom_left_units"];
				else $radius_bottom_left_units = 0;
				
				if (isset($row_bs["box_shadow_horizontal"])) $box_shadow_horizontal = $row_bs["box_shadow_horizontal"];
				else $box_shadow_horizontal = -1000000;
				if (isset($row_bs["box_shadow_vertical"])) $box_shadow_vertical = $row_bs["box_shadow_vertical"];
				else $box_shadow_vertical = -1000000;
				if (isset($row_bs["box_shadow_blur"])) $box_shadow_blur = $row_bs["box_shadow_blur"];
				else $box_shadow_blur = -1;
				if (isset($row_bs["box_shadow_spread"])) $box_shadow_spread = $row_bs["box_shadow_spread"];
				else $box_shadow_spread = -1000000;
				if (isset($row_bs["box_shadow_color"])) $box_shadow_color = $row_bs["box_shadow_color"];
				else $box_shadow_color = "-not set-";
				if (isset($row_bs["box_shadow_inset"])) $box_shadow_inset = $row_bs["box_shadow_inset"];
				else $box_shadow_inset = 0;
				
				if ($row_bs["cursor"]) $cursor = $row_bs["cursor"];
				else $cursor = "-not selected-";
				
				if ($row_bs["background_size"]) $background_size = $row_bs["background_size"];
				else $background_size = "-not selected-";
				if ($row_bs["background_width"]) $background_width = $row_bs["background_width"];
				else $background_width = -1;
				if ($row_bs["background_width_units"]) $background_width_units = $row_bs["background_width_units"];
				else $background_width_units = 0;
				if ($row_bs["background_height"]) $background_height = $row_bs["background_height"];
				else $background_height = -1;
				if ($row_bs["background_height_units"]) $background_height_units = $row_bs["background_height_units"];
				else $background_height_units = 0;
				
				if ($row_bs["visibility"]) $visibility = $row_bs["visibility"];
				else $visibility = "-not selected-";
				
				if ($row_bs["justify_content"]) $justify_content = $row_bs["justify_content"];
				else $justify_content = "-not selected-";
				
				if ($row_bs["content"]) $content = $row_bs["content"];
				else $content = "-not selected-";
				
				if ($row_bs["content_text"]) $content_text  = $row_bs["content_text"];
				else $content_text  = "";
				
				if ($row_bs["text_transform"]) $text_transform = $row_bs["text_transform"];
				else $text_transform = "-not selected-";
				
				if ($row_bs["transition_property"]) $transition_property = $row_bs["transition_property"];
				else $transition_property = "-not selected-";
				
				if ($row_bs["transition_timing_function"]) $transition_timing_function = $row_bs["transition_timing_function"];
				else $transition_timing_function = "-not selected-";
				
				if ($row_bs["transition_duration"]) $transition_duration = $row_bs["transition_duration"];
				else $transition_duration = -1;
				if ($row_bs["transition_duration_units"]) $transition_duration_units = $row_bs["transition_duration_units"];
				else $transition_duration_units = 0;
				
				if ($row_bs["transition_delay"]) $transition_delay = $row_bs["transition_delay"];
				else $transition_delay = -1;
				if ($row_bs["transition_delay_units"]) $transition_delay_units = $row_bs["transition_delay_units"];
				else $transition_delay_units = 0;
				
				if ($row_bs["flex_basis"]) $flex_basis = $row_bs["flex_basis"];
				else $flex_basis = "-not selected-";
				if ($row_bs["flex_basis_length"]) $flex_basis_length = $row_bs["flex_basis_length"];
				else $flex_basis_length = -1;
				if ($row_bs["flex_basis_length_units"]) $flex_basis_length_units = $row_bs["flex_basis_length_units"];
				else $flex_basis_length_units = 0;
				
				if ($row_bs["flex_grow"]) $flex_grow = $row_bs["flex_grow"];
				else $flex_grow = -1;
				if ($row_bs["flex_shrink"]) $flex_shrink = $row_bs["flex_shrink"];
				else $flex_shrink = -1;
				
				if ($row_bs["flex_direction"]) $flex_direction = $row_bs["flex_direction"];
				else $flex_direction = "-not selected-";
				if ($row_bs["flex_wrap"]) $flex_wrap = $row_bs["flex_wrap"];
				else $flex_wrap = "-not selected-";
				
				if (!is_null($row_bs["gradient_type"])) $gradient_type = $row_bs["gradient_type"];
				else $gradient_type = 0;
				if (!is_null($row_bs["gradient_angle"])) $gradient_angle = $row_bs["gradient_angle"];
				else $gradient_angle = 0;
				if ($row_bs["gradient_colors"]) $gradient_colors = $row_bs["gradient_colors"];
				else $gradient_colors = "-not set-";
				if ($row_bs["gradient_opacities"]) $gradient_opacities = $row_bs["gradient_opacities"];
				else $gradient_opacities = "-not set-";
				if (!is_null($row_bs["gradient_repeat"])) $gradient_repeat = $row_bs["gradient_repeat"];
				else $gradient_repeat = 0;
			
				///////////////// Get !important attributes list //////////////////
				if (isset($important))
					unset($important);
				$important = array();
					
				$query_important_attrib = "SELECT * FROM " . $bwb . "site_css_important WHERE `style_sheet` = '" . $style_sheet . "' AND `class` = '" . $class . "'";
				if ($template_id > -1)
					$query_important_attrib .= " AND template_id = " . $template_id;
				$result_important_attrib = $dbh->query($query_important_attrib);
				while ($row_important_attrib = $result_important_attrib->fetch(PDO::FETCH_ASSOC))	{
					$important[] = $row_important_attrib['attribute'];
				}
				///////////////// Get !important attributes list //////////////////
		
				$css_string .= $class . " {\n";
					
				if ($font != "-not selected-")
				{
					$css_string .= "   font-family: " . $font;
					if ($font2 != "-not selected-")
					{
						$css_string .= ", " . $font2;
						if ($font3 != "-not selected-")
							$css_string .= ", " . $font3;
					}
					if (in_array('font', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($font_size != -1)
				{
					if (in_array($font_size_units, $no_length_arr))
						$css_string .= "   font-size: " . $font_size_units;
					else
					{
						if (in_array($font_size_units, $integer_length_arr))
							$font_size = intval($font_size);
						$css_string .= "   font-size: " . $font_size . $font_size_units;
					}
					if (in_array('font_size', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($text_color != "-not set-")
				{
					$css_string .= "   color: " . $text_color;
					if (in_array('text_color', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($padding_top != -1)
				{
					if ($padding_top_units == 0)
						$padding_top = intval($padding_top);
					elseif (($padding_top_units == 1) && ((float)$padding_top == (int)$padding_top))
						$padding_top = intval($padding_top);
					else
						$padding_top = floatval($padding_top);
					$units = GetLengthUnitsStr($padding_top_units);
					$css_string .= "   padding-top: " . $padding_top . $units;
					if (in_array('padding_top', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($padding_right != -1)
				{
					if ($padding_right_units == 0)
						$padding_right = intval($padding_right);
					elseif (($padding_right_units == 1) && ((float)$padding_right == (int)$padding_right))
						$padding_right = intval($padding_right);
					else
						$padding_right = floatval($padding_right);
					$units = GetLengthUnitsStr($padding_right_units);
					$css_string .= "   padding-right: " . $padding_right . $units;
					if (in_array('padding_right', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($padding_bottom != -1)
				{
					if ($padding_bottom_units == 0)
						$padding_bottom = intval($padding_bottom);
					elseif (($padding_bottom_units == 1) && ((float)$padding_bottom == (int)$padding_bottom))
						$padding_bottom = intval($padding_bottom);
					else
						$padding_bottom = floatval($padding_bottom);
					$units = GetLengthUnitsStr($padding_bottom_units);
					$css_string .= "   padding-bottom: " . $padding_bottom . $units;
					if (in_array('padding_bottom', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($padding_left != -1)
				{
					if ($padding_left_units == 0)
						$padding_left = intval($padding_left);
					elseif (($padding_left_units == 1) && ((float)$padding_left == (int)$padding_left))
						$padding_left = intval($padding_left);
					else
						$padding_left = floatval($padding_left);
					$units = GetLengthUnitsStr($padding_left_units);
					$css_string .= "   padding-left: " . $padding_left . $units;
					if (in_array('padding_left', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($weight != "-not selected-")
				{
					$css_string .= "   font-weight: " . $weight;
					if (in_array('weight', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if (($italic != 0) || ($oblique != 0))
				{
					$css_string .= "   font-style:";
					if ($italic == 1)
						$css_string .= " italic";
					if ($oblique == 1)
						$css_string .= " oblique";
					if ((in_array('italic', $important) && ($italic == 1)) || (in_array('oblique', $important) && ($oblique == 1)))
						$css_string .= " !important;\n";
					elseif (($italic == 1) || ($oblique == 1))
						$css_string .= ";\n";
				}
				
				if ((($underline != 0) || ($overline != 0) || ($blink != 0) || ($linethrough != 0)) && ($no_text_decoration != 1))
				{
					$css_string .= "   text-decoration:";
					if ($underline == 1)
						$css_string .= " underline";
					if ($overline == 1)
						$css_string .= " overline";
					if ($blink == 1)
						$css_string .= " blink";
					if ($linethrough == 1)
						$css_string .= " linethrough";
					if ((in_array('underline', $important) && ($underline == 1)) || (in_array('overline', $important) && ($overline == 1)) || (in_array('blink', $important) && ($blink == 1)) || (in_array('linethrough', $important) && ($linethrough == 1)))
						$css_string .= " !important;\n";
					elseif (($underline == 1) || ($overline == 1) || ($blink == 1) || ($linethrough == 1))
						$css_string .= ";\n";
				}
				elseif ($no_text_decoration == 1)
				{
					$css_string .= "   text-decoration: none";
					if (in_array('no_text_decoration', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($text_transform != "-not selected-")
				{
					$css_string .= "   text-transform: " . $text_transform;
					if (in_array('text_transform', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($shadow == 1)
				{
					if ((float)$shadow_x_offset == (int)$shadow_x_offset)
						$shadow_x_offset = intval($shadow_x_offset);
					else
						$shadow_x_offset = floatval($shadow_x_offset);
						
					if ((float)$shadow_y_offset == (int)$shadow_y_offset)
						$shadow_y_offset = intval($shadow_y_offset);
					else
						$shadow_y_offset = floatval($shadow_y_offset);
						
					if ((float)$shadow_blur == (int)$shadow_blur)
						$shadow_blur = intval($shadow_blur);
					else
						$shadow_blur = floatval($shadow_blur);
						
					if ($shadow_color != "-not set-")
						$css_string .= "   text-shadow: " . $shadow_color . " " . $shadow_x_offset . "px " . $shadow_y_offset . "px " . $shadow_blur . "px";
					else
						$css_string .= "   text-shadow: " . $shadow_x_offset . "px " . $shadow_y_offset . "px " . $shadow_blur . "px";
						
					if (in_array('shadow', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($line_height_units != -1)
				{
					if ($line_height_units == 0)
						$css_string .= "   line-height: normal";
					elseif (($line_height_units == 1) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height;
					elseif (($line_height_units == 2) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "px";
					elseif (($line_height_units == 3) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "%";
					elseif (($line_height_units == 4) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "em";
					elseif (($line_height_units == 5) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "pt";
					elseif (($line_height_units == 6) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "pc";
					elseif (($line_height_units == 7) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "cm";
					elseif (($line_height_units == 8) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "mm";
					elseif (($line_height_units == 9) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "in";
					elseif (($line_height_units == 10) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "rem";
					elseif (($line_height_units == 11) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vw";
					elseif (($line_height_units == 12) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vh";
					elseif (($line_height_units == 13) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vmin";
					elseif (($line_height_units == 14) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vmax";
					elseif (($line_height_units == 15) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "ch";
					elseif ($line_height_units == 16)
						$css_string .= "   line-height: inherit";
					elseif ($line_height_units == 17)
						$css_string .= "   line-height: initial";
						
					if (($line_height != -1) || ($line_height_units == 0) || ($line_height_units > 15))	{
						if (in_array('line_height', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
									
				if ($letter_spacing_units != -1)
				{
					if ($letter_spacing_units == 0)
						$css_string .= "   letter-spacing: normal";
					elseif (($letter_spacing_units == 1) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . intval($letter_spacing) . "px";
					elseif (($letter_spacing_units == 2) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . intval($letter_spacing) . "%";
					elseif (($letter_spacing_units == 3) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "em";
					elseif (($letter_spacing_units == 4) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "pt";
					elseif (($letter_spacing_units == 5) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "pc";
					elseif (($letter_spacing_units == 6) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "cm";
					elseif (($letter_spacing_units == 7) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "mm";
					elseif (($letter_spacing_units == 8) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "in";
					elseif (($letter_spacing_units == 9) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "rem";
					elseif (($letter_spacing_units == 10) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vw";
					elseif (($letter_spacing_units == 11) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vh";
					elseif (($letter_spacing_units == 12) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vmin";
					elseif (($letter_spacing_units == 13) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vmax";
					elseif (($letter_spacing_units == 14) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "ch";
					elseif ($letter_spacing_units == 15)
						$css_string .= "   letter-spacing: initial";
					elseif ($letter_spacing_units == 15)
						$css_string .= "   letter-spacing: inherit";
						
					if (($letter_spacing != -1000000) || ($letter_spacing_units == 0) || ($letter_spacing_units > 14))	{
						if (in_array('letter_spacing', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}		   
					
				if ($small_caps == 1)	{
					$css_string .= "   font-variant: small-caps";
					if (in_array('small_caps', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($align != "-not selected-")	{
					$css_string .= "   text-align: " . $align;
					if (in_array('align', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if (($vertical_align != "-not selected-") && ($vertical_align != "") && isset($vertical_align))	{
					$css_string .= "   vertical-align: " . $vertical_align;
					if (in_array('vertical_align', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($bkgd_transparent == 1)
				{
					$css_string .= "   background: transparent";
					if (in_array('bkgd_transparent', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				else
				{
					if (($bkgd_color != "-not set-") && ($bkgd_rgba != 1))	{
						$css_string .= "   background-color: " . $bkgd_color;
						if (in_array('bkgd_color', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
						
					if (($bkgd_opacity != -1) && ($bkgd_rgba != 1))
					{
						$css_string .= "   filter: alpha(opacity=" . $bkgd_opacity . ")";
						if (in_array('bkgd_opacity', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						$css_string .= "   -moz-opacity: " . $bkgd_opacity . "%";
						if (in_array('bkgd_opacity', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						$bkgd_opacity = $bkgd_opacity/100;
						$css_string .= "   opacity: " . $bkgd_opacity;
						if (in_array('bkgd_opacity', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
					elseif (($bkgd_opacity != -1) && ($bkgd_rgba == 1))
					{
						$bkgd_color = str_replace("#", "", $bkgd_color);
						if ($bkgd_color == "-not set-")
							list($r, $g, $b) = array_map('hexdec', str_split("FFFFFF", 2));
						else	{
							if (strlen($bkgd_color) < 4)
								$bkgd_color = substr($bkgd_color,0,1) . substr($bkgd_color,0,1) . substr($bkgd_color,1,1) . substr($bkgd_color,1,1) . substr($bkgd_color,2,1) . substr($bkgd_color,2,1);
							list($r, $g, $b) = array_map('hexdec', str_split($bkgd_color, 2));
						}
						$bkgd_opacity = $bkgd_opacity/100;
						$css_string .= "   background: rgba($r, $g, $b, $bkgd_opacity)";
						if (in_array('bkgd_opacity', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
				
				if ($border > -1)
				{
					if ($border_units == 0)
						$border = intval($border);
					elseif (($border_units == 1) && ((float)$border == (int)$border))
						$border = intval($border);
					else
						$border = floatval($border);
					$units = GetLengthUnitsStr($border_units);
						
					if ($border_sides == 15) // All sides selected.
					{
						if ($border_style == "-not selected-") $border_style_str = "solid";
						else $border_style_str = $border_style;
						
						if ($border == 0)
							$css_string .= "   border: 0";
						elseif ($border_color != "-not set-")
							$css_string .= "   border: " . $border . $units . " " . $border_style_str . " " . $border_color;
						else
							$css_string .= "   border: " . $border . $units . " " . $border_style_str;
						if (in_array('border', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
					else  // Not all sides selected.  Look for each side.
					{
						if (($border_sides & 8) == 8)
						{
							$border_side_str = "-top";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color;
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color;
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str;
							if (in_array('border', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						}
						if (($border_sides & 4) == 4)
						{
							$border_side_str = "-bottom";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color;
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color;
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str;
							if (in_array('border', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						}
						if (($border_sides & 2) == 2)
						{
							$border_side_str = "-left";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color;
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color;
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str;
							if (in_array('border', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						}
						if (($border_sides & 1) == 1)
						{
							$border_side_str = "-right";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color;
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color;
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str;
							if (in_array('border', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						}
					}
				}
				
				if (($border_style != "-not selected-") && ($border < 0))
				{			
					if ($border_style == "none")
					{
						if ($border_sides == 15) // All sides selected.
							$css_string .= "   border: none";
						else
						{
							if (($border_sides & 8) == 8)
								$css_string .= "   border-top: none";
							if (($border_sides & 4) == 4)
								$css_string .= "   border-bottom: none";
							if (($border_sides & 2) == 2)
								$css_string .= "   border-left: none";
							if (($border_sides & 1) == 1)
								$css_string .= "   border-right: none";
						}
					}
					else
					{
						if ($border_sides == 15) // All sides selected.
							$css_string .= "   border-style: " . $border_style;
						else
						{
							if (($border_sides & 8) == 8)
								$css_string .= "   border-top: " . $border_style;
							if (($border_sides & 4) == 4)
								$css_string .= "   border-bottom: " . $border_style;
							if (($border_sides & 2) == 2)
								$css_string .= "   border-left: " . $border_style;
							if (($border_sides & 1) == 1)
								$css_string .= "   border-right: " . $border_style;
						}
					}
					if (in_array('border', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($outline_style != "-not selected-")	{
					$css_string .= "   outline-style: " . $outline_style;
					if (in_array('outline_style', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($border_collapse != "-not selected-")	{
					$css_string .= "   border-collapse: " . $border_collapse;
					if (in_array('border_collapse', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($margin_top_units == 0)
					$margin_top = intval($margin_top);
				elseif (($margin_top_units == 1) && ((float)$margin_top == (int)$margin_top))
					$margin_top = intval($margin_top);
				else
					$margin_top = floatval($margin_top);
				$units = GetLengthUnitsStr($margin_top_units);
				if (($margin_top != -1000000) && ($margin_top_auto == 0))	{
					$css_string .= "   margin-top: " . $margin_top . $units;
					if (in_array('margin_top', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				elseif ($margin_top_auto == 1)	{
					$css_string .= "   margin-top: auto";
					if (in_array('margin_top', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($margin_right_units == 0)
					$margin_right = intval($margin_right);
				elseif (($margin_right_units == 1) && ((float)$margin_right == (int)$margin_right))
					$margin_right = intval($margin_right);
				else
					$margin_right = floatval($margin_right);
				$units = GetLengthUnitsStr($margin_right_units);
				if (($margin_right != -1000000) && ($margin_right_auto == 0))	{
					$css_string .= "   margin-right: " . $margin_right . $units;
					if (in_array('margin_right', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				elseif ($margin_right_auto == 1)	{
					$css_string .= "   margin-right: auto";
					if (in_array('margin_right', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($margin_left_units == 0)
					$margin_left = intval($margin_left);
				elseif (($margin_left_units == 1) && ((float)$margin_left == (int)$margin_left))
					$margin_left = intval($margin_left);
				else
					$margin_left = floatval($margin_left);
				$units = GetLengthUnitsStr($margin_left_units);
				if (($margin_left != -1000000) && ($margin_left_auto == 0))	{
					$css_string .= "   margin-left: " . $margin_left . $units;
					if (in_array('margin_left', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				elseif ($margin_left_auto == 1)	{
					$css_string .= "   margin-left: auto";
					if (in_array('margin_left', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($margin_bottom_units == 0)
					$margin_bottom = intval($margin_bottom);
				elseif (($margin_bottom_units == 1) && ((float)$margin_bottom == (int)$margin_bottom))
					$margin_bottom = intval($margin_bottom);
				else
					$margin_bottom = floatval($margin_bottom);
				$units = GetLengthUnitsStr($margin_bottom_units);
				if (($margin_bottom != -1000000) && ($margin_bottom_auto == 0))	{
					$css_string .= "   margin-bottom: " . $margin_bottom . $units;
					if (in_array('margin_bottom', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				elseif ($margin_bottom_auto == 1)	{
					$css_string .= "   margin-bottom: auto";
					if (in_array('margin_bottom', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
					
				if ($position != "-not selected-")	{
					$css_string .= "   position: " . $position;
					if (in_array('position', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($position_left_units == 0)
					$position_left = intval($position_left);
				elseif (($position_left_units == 1) && ((float)$position_left == (int)$position_left))
					$position_left = intval($position_left);
				else
					$position_left = floatval($position_left);
				$units = GetLengthUnitsStr($position_left_units);
				if ($position_left != -1000000)	{
					$css_string .= "   left: " . $position_left . $units;
					if (in_array('position_left', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($position_top_units == 0)
					$position_top = intval($position_top);
				elseif (($position_top_units == 1) && ((float)$position_top == (int)$position_top))
					$position_top = intval($position_top);
				else
					$position_top = floatval($position_top);
				$units = GetLengthUnitsStr($position_top_units);
				if ($position_top != -1000000)	{
					$css_string .= "   top: " . $position_top . $units;
					if (in_array('position_top', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($position_right_units == 0)
					$position_right = intval($position_right);
				elseif (($position_right_units == 1) && ((float)$position_right == (int)$position_right))
					$position_right = intval($position_right);
				else
					$position_right = floatval($position_right);
				$units = GetLengthUnitsStr($position_right_units);
				if ($position_right != -1000000)	{
					$css_string .= "   right: " . $position_right . $units;
					if (in_array('position_right', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($position_bottom_units == 0)
					$position_bottom = intval($position_bottom);
				elseif (($position_bottom_units == 1) && ((float)$position_bottom == (int)$position_bottom))
					$position_bottom = intval($position_bottom);
				else
					$position_bottom = floatval($position_bottom);
				$units = GetLengthUnitsStr($position_bottom_units);
				if ($position_bottom != -1000000)	{
					$css_string .= "   bottom: " . $position_bottom . $units;
					if (in_array('position_bottom', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($z_index != -1000000)	{
					$css_string .= "   z-index: " . $z_index;
					if (in_array('z_index', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($overflow != "-not selected-")	{
					$css_string .= "   overflow: " . $overflow;
					if (in_array('overflow', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($overflow_x != "-not selected-")	{
					$css_string .= "   overflow-x: " . $overflow_x;
					if (in_array('overflow_x', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($overflow_y != "-not selected-")	{
					$css_string .= "   overflow-y: " . $overflow_y;
					if (in_array('overflow_y', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($float != "-not selected-")	{
					$css_string .= "   float: " . $float;
					if (in_array('float', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($white_space != "-not selected-")	{
					$css_string .= "   white_space: " . $white_space;
					if (in_array('white_space', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if (($clip_top != -1) && ($clip_right != -1) && ($clip_bottom != -1) && ($clip_left != -1))
				{		
					if ($clip_top_units == 0)
						$clip_top = intval($clip_top);
					elseif (($clip_top_units == 1) && ((float)$clip_top == (int)$clip_top))
						$clip_top = intval($clip_top);
					else
						$clip_top = floatval($clip_top);
					$units_top = GetLengthUnitsStr($clip_top_units);
					if ($clip_right_units == 0)
						$clip_right = intval($clip_right);
					elseif (($clip_right_units == 1) && ((float)$clip_right == (int)$clip_right))
						$clip_right = intval($clip_right);
					else
						$clip_right = floatval($clip_right);
					$units_right = GetLengthUnitsStr($clip_right_units);
					if ($clip_bottom_units == 0)
						$clip_bottom = intval($clip_bottom);
					elseif (($clip_bottom_units == 1) && ((float)$clip_bottom == (int)$clip_bottom))
						$clip_bottom = intval($clip_bottom);
					else
						$clip_bottom = floatval($clip_bottom);
					$units_bottom = GetLengthUnitsStr($clip_bottom_units);
					if ($clip_left_units == 0)
						$clip_left = intval($clip_left);
					elseif (($clip_left_units == 1) && ((float)$clip_left == (int)$clip_left))
						$clip_left = intval($clip_left);
					else
						$clip_left = floatval($clip_left);
					$units_left = GetLengthUnitsStr($clip_left_units);
						
					if ($clip_top != -1)	{
						$css_string .= "   clip: rect(" . $clip_top . $units_top . "," . $clip_right . $units_right . "," . $clip_bottom . $units_bottom . "," . $clip_left . $units_left . ")";
						if (in_array('clip', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
				
				
				if ($display != "-not selected-")	{
					if ($display == "flex")	{
						$css_string .= "   display: -webkit-flex";
						if (in_array('display', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
					if ($display == "inline-flex")	{
						$css_string .= "   display: -webkit-inline-flex";
						if (in_array('display', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
					$css_string .= "   display: " . $display;
					if (in_array('display', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($width != -1)
				{
					if ($width_units == 0)
						$width = intval($width);
					elseif (($width_units == 1) && ((float)$width == (int)$width))
						$width = intval($width);
					else
						$width = floatval($width);
					$units = GetLengthUnitsStr($width_units);
					
					if ($width_prefix == "-not selected-")
						$prefix = "";
					elseif ($width_prefix == "min-max")
						$prefix = "min-";
					else
						$prefix = $width_prefix . "-";
						
					$css_string .= "   " . $prefix . "width: " . $width . $units;
					if (in_array('width', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					
					if (($width_prefix == "min-max") && ($max_width != -1))	{
						if ($max_width_units == 0)
							$max_width = intval($max_width);
						elseif (($max_width_units == 1) && ((float)$max_width == (int)$max_width))
							$max_width = intval($max_width);
						else
							$max_width = floatval($max_width);
						$units = GetLengthUnitsStr($max_width_units);
						$css_string .= "   max-width: " . $max_width . $units;
						if (in_array('max_width', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
				if ($height != -1)
				{
					if ($height_units == 0)
						$height = intval($height);
					elseif (($height_units == 1) && ((float)$height == (int)$height))
						$height = intval($height);
					else
						$height = floatval($height);
					$units = GetLengthUnitsStr($height_units);
					
					if ($height_prefix == "-not selected-")
						$prefix = "";
					elseif ($width_prefix == "min-max")
						$prefix = "min-";
					else
						$prefix = $height_prefix . "-";
						
					$css_string .= "   " . $prefix . "height: " . $height . $units;
					if (in_array('height', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					
					if (($height_prefix == "min-max") && ($max_height != -1))	{
						if ($max_height_units == 0)
							$max_height = intval($max_height);
						elseif (($max_height_units == 1) && ((float)$max_height == (int)$max_height))
							$max_height = intval($max_height);
						else
							$max_height = floatval($max_height);
						$units = GetLengthUnitsStr($max_height_units);
						$css_string .= "   max-height: " . $max_height . $units;
						if (in_array('max_height', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
				
				if (($background_image != "-not set-") && ($background_image != "-not selected-") && ($background_image != ""))	{
					$css_string .= "   background-image: url('" . $image . $background_image . "')";
					if (in_array('background_image', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if (($background_attachment != "-not selected-") && ($background_attachment != ""))	{
					$css_string .= "   background-attachment: " . $background_attachment;
					if (in_array('background_attachment', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if (($background_repeat != "-not selected-") && ($background_repeat != ""))	{
					$css_string .= "   background-repeat: " . $background_repeat;
					if (in_array('background_repeat', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if (($background_position != "-not selected-") && ($background_position != "") && ($background_position != "xpos ypos"))	{
					$css_string .= "   background-position: " . $background_position;
					if (in_array('background_position', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				elseif ($background_position == "xpos ypos")
				{
					if ($background_position_units == 0)	{
						$background_position_x = intval($background_position_x);
						$background_position_y = intval($background_position_y);
					}
					if (($background_position_units == 1) && ((float)$background_position_x == (int)$background_position_x))
						$background_position_x = intval($background_position_x);
					else
						$background_position_x = floatval($background_position_x);
					if (($background_position_units == 1) && ((float)$background_position_y == (int)$background_position_y))
						$background_position_y = intval($background_position_y);
					else
						$background_position_y = floatval($background_position_y);
					
					$units = GetLengthUnitsStr($background_position_units);
					
					$css_string .= "   background-position: " . $background_position_x . $units . " " . $background_position_y . $units;
					if (in_array('background_position', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($list_style_type != "-not selected-")	{
					$css_string .= "   list-style-type: " . $list_style_type;
					if (in_array('list_style_type', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($list_style_position != "-not selected-")	{
					$css_string .= "   list-style-position: " . $list_style_position;
					if (in_array('list_style_position', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if (($list_style_image != "-not set-") && ($list_style_image != "-not selected-") && ($list_style_image != ""))	{
					$css_string .= "   list-style-image: url('" . $image . $list_style_image . "')";
					if (in_array('list_style_image', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($table_layout != "-not selected-")	{
					$css_string .= "   table-layout: " . $table_layout;
					if (in_array('table_layout', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($clear != "-not selected-")	{
					$css_string .= "   clear: " . $clear;
					if (in_array('clear', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($radius_top_left > 0)
				{
					if ($radius_top_left_units == 0)
						$radius_top_left = intval($radius_top_left);
					elseif (($radius_top_left_units == 1) && ((float)$radius_top_left == (int)$radius_top_left))
						$radius_top_left = intval($radius_top_left);
					else
						$radius_top_left = floatval($radius_top_left);
					$units = GetLengthUnitsStr($radius_top_left_units);
					
					$css_string .= "   border-top-left-radius: " . $radius_top_left . $units;
					if (in_array('radius_top_left', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($radius_top_right > 0)
				{
					if ($radius_top_right_units == 0)
						$radius_top_right = intval($radius_top_right);
					elseif (($radius_top_right_units == 1) && ((float)$radius_top_right == (int)$radius_top_right))
						$radius_top_right = intval($radius_top_right);
					else
						$radius_top_right = floatval($radius_top_right);
					$units = GetLengthUnitsStr($radius_top_right_units);
					
					$css_string .= "   border-top-right-radius: " . $radius_top_right . $units;
					if (in_array('radius_top_right', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($radius_bottom_right > 0)
				{
					if ($radius_bottom_right_units == 0)
						$radius_bottom_right = intval($radius_bottom_right);
					elseif (($radius_bottom_right_units == 1) && ((float)$radius_bottom_right == (int)$radius_bottom_right))
						$radius_bottom_right = intval($radius_bottom_right);
					else
						$radius_bottom_right = floatval($radius_bottom_right);
					$units = GetLengthUnitsStr($radius_bottom_right_units);
					
					$css_string .= "   border-bottom-right-radius: " . $radius_bottom_right . $units;
					if (in_array('radius_bottom_right', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				if ($radius_bottom_left > 0)
				{
					if ($radius_bottom_left_units == 0)
						$radius_bottom_left = intval($radius_bottom_left);
					elseif (($radius_bottom_left_units == 1) && ((float)$radius_bottom_left == (int)$radius_bottom_left))
						$radius_bottom_left = intval($radius_bottom_left);
					else
						$radius_bottom_left = floatval($radius_bottom_left);
					$units = GetLengthUnitsStr($radius_bottom_left_units);
					
					$css_string .= "   border-bottom-left-radius: " . $radius_bottom_left . $units;
					if (in_array('radius_bottom_left', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($box_shadow_horizontal != -1000000)
				{
					if ((float)$box_shadow_horizontal == (int)$box_shadow_horizontal)
						$box_shadow_horizontal = intval($box_shadow_horizontal);
					else
						$box_shadow_horizontal = floatval($box_shadow_horizontal);
						
					if ((float)$box_shadow_vertical == (int)$box_shadow_vertical)
						$box_shadow_vertical = intval($box_shadow_vertical);
					else
						$box_shadow_vertical = floatval($box_shadow_vertical);
						
					$css_string .= "   box-shadow: " . $box_shadow_horizontal . "px " . $box_shadow_vertical . "px";
					if ($box_shadow_blur > -1)	{
						if ((float)$box_shadow_blur == (int)$box_shadow_blur)
							$box_shadow_blur = intval($box_shadow_blur);
						else
							$box_shadow_blur = floatval($box_shadow_blur);
						$css_string .= " " . $box_shadow_blur . "px";
					}
					if ($box_shadow_spread != -1000000)	{
						if ((float)$box_shadow_spread == (int)$box_shadow_spread)
							$box_shadow_spread = intval($box_shadow_spread);
						else
							$box_shadow_spread = floatval($box_shadow_spread);
							
						$css_string .= " " . $box_shadow_spread . "px";
					}
					if (isset($box_shadow_color) && ($box_shadow_color != "-not set-"))
						$css_string .= " " . $box_shadow_color;
					if ($box_shadow_inset == 1)
						$css_string .= " inset";
					if (in_array('box_shadow_horizontal', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($cursor != "-not selected-")	{
					$css_string .= "   cursor: " . $cursor;
					if (in_array('cursor', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
					
					
				if ($background_size != "-not selected-")
				{
					if (!(($background_size == "scale") && ($background_width < 0))) // If scale, must have a positive dimension.
					{
						$css_string .= "   background-size: ";
						if (($background_size == "scale") && ($background_width > -1))
						{
							if ($background_width_units == 0)
								$background_width = intval($background_width);
							elseif (($background_width_units == 1) && ((float)$background_width == (int)$background_width))
								$background_width = intval($background_width);
							else
								$background_width = floatval($background_width);
							$units = GetLengthUnitsStr($background_width_units);
							
							$css_string .= $background_width . $units;
								
							if ($background_height > -1)
							{
								if ($background_height_units == 0)
									$background_height = intval($background_height);
								elseif (($background_height_units == 1) && ((float)$background_height == (int)$background_height))
									$background_height = intval($background_height);
								else
									$background_height = floatval($background_height);
								$units = GetLengthUnitsStr($background_height_units);
							
								$css_string .= " " . $background_height . $units;
							}
						}
						elseif ($background_size != "scale")
							$css_string .= $background_size;
						if (in_array('background_size', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
				
				if ($visibility != "-not selected-")	{
					$css_string .= "   visibility: " . $visibility;
					if (in_array('visibility', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($text_indent != -1000000)
				{
					if ($text_indent_units == 0)
						$text_indent = intval($text_indent);
					elseif (($text_indent_units == 1) && ((float)$text_indent == (int)$text_indent))
						$text_indent = intval($text_indent);
					else
						$text_indent = floatval($text_indent);
					$units = GetLengthUnitsStr($text_indent_units);
					$css_string .= "   text-indent: " . $text_indent . $units;
					if (in_array('text_indent', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($justify_content != "-not selected-")	{
					$css_string .= "   -webkit-justify-content: " . $justify_content;
					if (in_array('justify_content', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   justify-content: " . $justify_content;
					if (in_array('justify_content', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($content != "-not selected-")	{
					if (($content != "string") && ($content != "url") && ($content != "attr"))
						$css_string .= "   content: " . $content;
					elseif ($content == "string")
						$css_string .= "   content: '" . $content_text . "'";
					elseif ($content == "url")
						$css_string .= "   content: url(" . $content_text . ")";
					elseif ($content == "attr")
						$css_string .= "   content: attr(" . $content_text . ")";
					if (in_array('content', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
					
				if ($transition_property != "-not selected-")	{
					$css_string .= "   -webkit-transition-property: " . $transition_property;
					if (in_array('transition_property', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   transition-property: " . $transition_property;
					if (in_array('transition_property', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($transition_timing_function != "-not selected-")	{
					$css_string .= "   -webkit-transition-timing-function: " . $transition_timing_function;
					if (in_array('transition_timing_function', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   transition-timing-function: " . $transition_timing_function;
					if (in_array('transition_timing_function', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($transition_duration > -1)	{
					if (transition_duration_units == 0)	{
						$css_string .= "   -webkit-transition-duration: " . $transition_duration . "s";
						if (in_array('transition_duration', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						$css_string .= "   transition-duration: " . $transition_duration . "s";
						if (in_array('transition_duration', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
					elseif (transition_duration_units == 1)	{
						$css_string .= "   -webkit-transition-duration: " . $transition_duration . "ms";
						if (in_array('transition_duration', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						$css_string .= "   transition-duration: " . $transition_duration . "ms";
						if (in_array('transition_duration', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
				
				if ($transition_delay > -1)	{
					if (transition_delay_units == 0)	{
						$css_string .= "    -webkit-transition-delay: " . $transition_delay . "s";
						if (in_array('transition_delay', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						$css_string .= "   transition-delay: " . $transition_delay . "s";
						if (in_array('transition_delay', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
					elseif (transition_delay_units == 1)	{
						$css_string .= "    -webkit-transition-delay: " . $transition_delay . "ms";
						if (in_array('transition_delay', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
						$css_string .= "   transition-delay: " . $transition_delay . "ms";
						if (in_array('transition_delay', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					}
				}
			
				if (($flex_basis != "-not selected-") && ($flex_basis != "length"))	{
					$css_string .= "   -webkit-flex-basis: " . $flex_basis;
					if (in_array('flex_basis', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   flex-basis: " . $flex_basis;
					if (in_array('flex_basis', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				elseif (($flex_basis == "length") && ($flex_basis_length > -1))	{
					if ($flex_basis_length_units == 0)
						$flex_basis_length = intval($flex_basis_length);
					elseif (($flex_basis_length_units == 1) && ((float)$flex_basis_length == (int)$flex_basis_length))
						$flex_basis_length = intval($flex_basis_length);
					else
						$flex_basis_length = floatval($flex_basis_length);
					$units = GetLengthUnitsStr($flex_basis_length_units);
					$css_string .= "   -webkit-flex-basis: " . $flex_basis_length . $units;
					if (in_array('flex_basis', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   flex-basis: " . $flex_basis_length . $units;
					if (in_array('flex_basis', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
				
				if ($flex_grow > -1)	{
					if ((float)$flex_grow == (int)$flex_grow)
						$flex_grow = intval($flex_grow);
					$css_string .= "   -webkit-flex-grow: " . $flex_grow;
					if (in_array('flex_grow', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   flex-grow: " . $flex_grow;
					if (in_array('flex_grow', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($flex_shrink > -1)	{
					if ((float)$flex_shrink == (int)$flex_shrink)
						$flex_shrink = intval($flex_shrink);
					$css_string .= "   -webkit-flex-shrink: " . $flex_shrink;
					if (in_array('flex_shrink', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   flex-shrink: " . $flex_shrink;
					if (in_array('flex_shrink', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($flex_direction != "-not selected-")	{
					$css_string .= "   -webkit-flex-direction: " . $flex_direction;
					if (in_array('flex_direction', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   flex-direction: " . $flex_direction;
					if (in_array('flex_direction', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}
					
				if ($flex_wrap != "-not selected-")	{
					$css_string .= "   -webkit-flex-wrap: " . $flex_wrap;
					if (in_array('flex_wrap', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
					$css_string .= "   flex-wrap: " . $flex_wrap;
					if (in_array('flex_wrap', $important))	$css_string .= " !important;\n";	else	$css_string .= ";\n";
				}

				
				if (($gradient_type > 0) && ($gradient_colors != "-not set-"))
				{
					$gradient_color_arr = explode(",", $gradient_colors);
					$color_cnt = count($gradient_color_arr);
					if ($gradient_angle != 180)
						$gradient_angle_str = $gradient_angle . "deg";
					else
						$gradient_angle_str = "";
						
					$gradient_repeat_arr = array(0 => "");
					if ($gradient_repeat > 1)	{
						$repeat_num = 100 / ($gradient_repeat * ($color_cnt - 1));
						for ($i = 1; $i <= $color_cnt; $i++)
						{
							$gradient_repeat_str = " " . round(($repeat_num * $i), 3) . "%";
							$gradient_repeat_arr[$i] = $gradient_repeat_str;
						}
						$gradient_repeating = "repeating-";
					}
					else	{
						for ($i = 0; $i < $color_cnt; $i++)
						{
							$gradient_repeat_arr[$i] = "";
						}
						$gradient_repeating = "";
					}
					$comma = "";
					
					if ($gradient_type == 1)	{
						$gradient_str_webkit = "   background: -webkit-" . $gradient_repeating . "linear-gradient(" . $gradient_angle_str;
						$gradient_str_opera = "   background: -o-" . $gradient_repeating . "linear-gradient(" . $gradient_angle_str;
						$gradient_str_moz = "   background: -moz-" . $gradient_repeating . "linear-gradient(" . $gradient_angle_str;
						$gradient_str_css3 = "   background: " . $gradient_repeating . "linear-gradient(" . $gradient_angle_str;
						if ($gradient_angle_str != "")
							$comma = ", ";
					}
					elseif ($gradient_type == 2)	{
						$gradient_str_webkit = "   background: -webkit-" . $gradient_repeating . "radial-gradient(";
						$gradient_str_opera = "   background: -o-" . $gradient_repeating . "radial-gradient(";
						$gradient_str_moz = "   background: -moz-" . $gradient_repeating . "radial-gradient(";
						$gradient_str_css3 = "   background: " . $gradient_repeating . "radial-gradient(";
					}
						
					if ($gradient_opacities != "-not set-")	{
						$gradient_opacity_arr = explode(",", $gradient_opacities);
					}
				
					$i = 0;
					foreach ($gradient_color_arr as $key => $color)
					{
						if ($color != "")	{
							$color = str_replace("#", "", $color);
							if (strlen($color) < 4)
								$color = substr($color,0,1) . substr($color,0,1) . substr($color,1,1) . substr($color,1,1) . substr($color,2,1) . substr($color,2,1);
							list($r, $g, $b) = array_map('hexdec', str_split($color, 2));
							
							if ($gradient_opacities != "-not set-")
								$color_str = "rgba($r, $g, $b, " . $gradient_opacity_arr[$i]/100 . ")";
							else
								$color_str = "rgb($r, $g, $b)";
								
							if ($key == 0)	{
								$gradient_str_webkit .= $comma . $color_str;
								$gradient_str_opera .= $comma . $color_str;
								$gradient_str_moz .= $comma . $color_str;
								$gradient_str_css3 .= $comma . $color_str;
							}
							else	{
								$gradient_str_webkit .= $comma . $color_str . $gradient_repeat_arr[$key];
								$gradient_str_opera .= $comma . $color_str . $gradient_repeat_arr[$key];
								$gradient_str_moz .= $comma . $color_str . $gradient_repeat_arr[$key];
								$gradient_str_css3 .= $comma . $color_str . $gradient_repeat_arr[$key];
							}

							$comma = ", ";
						}
						$i++;
					}
					
					if (in_array('gradient_type', $important))	{
						$gradient_str_webkit .= ") !important;\n";
						$gradient_str_opera .= ") !important;\n";
						$gradient_str_moz .= ") !important;\n";
						$gradient_str_css3 .= ") !important;\n";
					}
					else	{
						$gradient_str_webkit .= ");\n";
						$gradient_str_opera .= ");\n";
						$gradient_str_moz .= ");\n";
						$gradient_str_css3 .= ");\n";
					}
					$css_string .= $gradient_str_webkit . $gradient_str_opera . $gradient_str_moz . $gradient_str_css3;
				}
			
				$css_string .= "}\n\n";
			} // end if use table data for tag
		}	// end while
	}
	
	$custom_css_delim = "/*****Custom CSS Delimiter*****/";

	if ($show_custom_styles == 1)
	{
		$query_build_string = "SELECT * FROM `" . $bwb . "custom_site_css` WHERE `name` = '" . $style_sheet . "'";

		if ($template_id > -1)
			$query_build_string .= " AND template_id = " . $template_id;
		$result_build_string = $dbh->query($query_build_string);
		$row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC);
		if ($row_bs["custom_css"])	{
			$custom_css = $row_bs["custom_css"];
			if (strpos($custom_css, $custom_css_delim) === false)
				$css_string .= $custom_css;
			else	{
				$custom_css_arr = explode($custom_css_delim, $custom_css, 2);
				$css_string = $custom_css_arr[0] . $css_string;
				if (isset($custom_css_arr[1]))
					$css_string .= $custom_css_arr[1];
			}
		}
	}

	// If @media rule, close with bracket.
	if (isset($media_type) && ($media_type != ""))
		$css_string .= "\n\n}";

	return ($css_string);
		
}
?>