<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	2/17/2015	ELL
// Modified: 10/1/2015	ELL
// Added layout template selection.
// Added insert default border areas in custom border areas check boxes.
// Added body onload function name as an attribute.
// Modified: 4/27/2016	ELL
// Changed sort from sort_order to use dropdown_sort_order so sorting of templates would actually work.
// Widened layout templete select buttons to handle new longer layout template names.
// Moved attribute setting to new column to accomodate longer layout template list.
// Revised: 5/26/2016	ELL
// Added function string checking to standardize entry of function call.
// 

	include ("check_session.php");
	
	$last_page_edited = $_SESSION['last_page_edited'];
?>

<!doctype html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Manage Page Attributes | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<script src="js/jquery.min.js"></script>
<script src="js/json2.js"></script>
<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/manage_page_attributes.js"></script>

<script>
<?php
	echo "	var MANAGE_PAGE_ATTRIBUTES_ERROR_RETRIEVING_PAGE_ATTRIBUTES_ERR = \"" . MANAGE_PAGE_ATTRIBUTES_ERROR_RETRIEVING_PAGE_ATTRIBUTES_ERR . "\";\n";
	echo "	var MANAGE_PAGE_ATTRIBUTES_PAGE_ATTRIBUTES_SAVED_MSG = \"" . MANAGE_PAGE_ATTRIBUTES_PAGE_ATTRIBUTES_SAVED_MSG . "\";\n";
	echo "	var MANAGE_PAGE_ATTRIBUTES_ERROR_SAVING_PAGE_ATTRIBUTES_ERR = \"" . MANAGE_PAGE_ATTRIBUTES_ERROR_SAVING_PAGE_ATTRIBUTES_ERR . "\";\n";
	echo "	var MANAGE_PAGE_ATTRIBUTES_ERROR_ONLOAD_ERR = \"" . MANAGE_PAGE_ATTRIBUTES_ERROR_ONLOAD_ERR . "\";\n";

	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `dropdown_sort_order`";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo "var layouts = new Array($num_results);\n";
	echo "var images = new Array($num_results);\n";
	for ($i = 0; $i < $num_results; $i++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$option_value = $row["option_value"];
		$option_image = $row["option_image"];
		echo "layouts[$i] = \"$option_value\";\n";
		echo "images[$i] = \"$option_image\";\n";
	}

	$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'Template'";
	$result2 = $bwb_dbh->query($query2);
	$row2 = $result2->fetch(PDO::FETCH_ASSOC);
	$option_value_selected = $row2["option_value"];
	echo "\nvar option_value_selected = '$option_value_selected';\n";
?>
</script>

<style>
#template_options_div	{
	display:block;
	position:absolute;
	top:20px;
	left:310px;
}

#editor_options_div	{
	display:block;
	position:absolute;
	top:250px;
	left:610px;
}

#save_attributes_btn	{
	position:relative;
	display:block;
	top:20px;
	left:100px;
	width:105px;
}

#template_pic_div	{
	display:block;
	position:absolute;
	top:0px;
	left:305px;
}
</style>
</head>

<body onLoad="GetPageAttributes('<?php echo $last_page_edited; ?>', -1); InitializeConsole();">
	<div id="sub_level_1_buttons">
	
        <div class="button_heading_sub_level_1">
        	<div class="button_heading_text_sub_level_1"><?php echo MANAGE_PAGE_ATTRIBUTES_HEADING; ?></div>
        	<div class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div>
        </div><br />
        
        <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo PAGE_1ST_CAP_WORD; ?></div></div>
		<?php
			if ($access_level == "restricted")
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE restricted = 0 ORDER BY page_name";
			else
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			$i = 0;
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$page_name = $row["page_name"];
				if ($page_name == $last_page_edited)
					$selected = " down_sub";
				else
					$selected = "";
				if ($page_name == "index")
					$home = " (Home)";
				else
					$home = "";
				

				echo "<div id='page_name_select$i' class='button_sub_level_1$selected' onClick=\"GetPageAttributes('$page_name', $i);\"><span class='button_text_sub_level_1'>$page_name$home</span></div>\n";
				$i++;
			}
		?>
    </div>
    <form name="frmPageAttributes" id="frmPageAttributes" action="save_page_attributes.php" method="post" enctype="multipart/form-data">
    <div id="template_options_div">
        <div id="select_layout_div">
        <div class="button_heading_sub_level_1" style='width:287px'><div class="button_heading_text_sub_level_1"><?php echo MANAGE_PAGE_ATTRIBUTES_TEMPLATE_HEADING; ?></div></div>
      <?php
        $query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `dropdown_sort_order`";
        $result = $bwb_dbh->query($query);
        $i = 0;
        while ($row = $result->fetch(PDO::FETCH_ASSOC))
        {
            $option_value = $row["option_value"];				
            
            if ($option_value_selected == $option_value)
                echo "<div class='button_sub_level_1 down_sub' id='layout_select$i' style='width:285px;' onClick=\"UpdateTemplateImage($i, true);\" onmouseover=\"UpdateTemplateImage($i, false);\"><span class='button_text_sub_level_1'>$option_value</span></div>\n";
            else
                echo "<div class='button_sub_level_1' id='layout_select$i' style='width:285px;' onClick=\"UpdateTemplateImage($i, true);\" onmouseover=\"UpdateTemplateImage($i, false);\" onmouseout=\"RevertTemplateImage(option_value_selected);\"><span class='button_text_sub_level_1'>$option_value</span></div>\n";
            $i++;
        }
        ?>
    	</div>
     	<input type="hidden" id="template_name" name="template_name" value="<?php echo $option_value_selected; ?>" />
     	<div id="template_pic_div"><img id="template_pic_edit" src="images/<?php echo $option_value_selected; ?>.jpg" border="0"></div>
    </div>
        
    <div id="editor_options_div">
    	<span class="bold"><?php echo MANAGE_PAGE_ATTRIBUTES_PAGE_ATTRIBUTES; ?></span><br /><br />
        
        <input type="checkbox" id="use_table_structure" name="use_table_structure" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_USE_PAGE_TABLE_STRUCTURES; ?><br />
        <input type="checkbox" id="use_table_structure_mobile" name="use_table_structure_mobile" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_USE_PAGE_TABLE_STRUCTURES_FOR_MOBILE; ?><br /><br />
        <input type="checkbox" id="body_onload" name="body_onload" onClick="ClearHighlight();" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_CALL_BODY_ONLOAD_FUNCTION; ?>
        <input type="text"  id="body_onload_function" name="body_onload_function" onChange="CheckFunctionFormat(this.value);" />
        <br /><br />
        <input type="checkbox" id="disable_site_styles" name="disable_site_styles" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_DISABLE_SITE_STYLES_WHEN_EDITING; ?><br /><br />
        
        <input type="checkbox" id="insert_default_head" name="insert_default_head" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_HEAD; ?><br />
        <input type="checkbox" id="insert_default_header" name="insert_default_header" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_HEADER; ?><br />
        <input type="checkbox" id="insert_default_top" name="insert_default_top" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_TOP; ?><br />
        <input type="checkbox" id="insert_default_left" name="insert_default_left" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_LEFT; ?><br />
        <input type="checkbox" id="insert_default_right" name="insert_default_right" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_RIGHT; ?><br />
        <input type="checkbox" id="insert_default_bottom" name="insert_default_bottom" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_BOTTOM; ?><br />
        <input type="checkbox" id="insert_default_footer" name="insert_default_footer" />
        <?php echo MANAGE_PAGE_ATTRIBUTES_INSERT_DEFAULT_FOOTER; ?><br />
        
        <div class='button_console_save' onClick="SavePageAttributes();" id="save_attributes_btn"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
        
        <input type="hidden" name="page_cnt" id="page_cnt" value="<?php echo $num_results; ?>" />
        <input type="hidden" name="page_name" id="selected_page" />
	</div>
    </form>
    
<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
	popup_msg.HidePopupMsg();
</script>
</body>
</html>