////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/5/2016	ELL
// Revised: 5/16/2017	ELL
// Modified to use thumb for thumb display if exists to speed console loading and reduce band width.
//
var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var image_row;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#plugins#photo_gallery", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

//////////////////////////////////////////////////////////////////////////////////////
function ResizeGallery()
{
	var full_width = document.getElementById("full_width").value;
	var full_height = document.getElementById("full_height").value;
	var thumb_width = document.getElementById("thumb_width").value;
	var thumb_height = document.getElementById("thumb_height").value;
	
	var preserve_thumb_aspect;
	if (document.getElementById("preserve_thumb_aspect").checked === true)
		preserve_thumb_aspect = 1;
	else
		preserve_thumb_aspect = 0;
		
	var show_titles;
	if (document.getElementById("show_titles").checked === true)
		show_titles = 1;
	else
		show_titles = 0;
		
	var disable_sort;
	if (document.getElementById("disable_sort").checked === true)
		disable_sort = 1;
	else
		disable_sort = 0;
		
	document.getElementById("uploading_div").style.visibility = "visible";
	document.getElementById("uploading_span").innerHTML = MANAGE_GALLERY_SAVING_PARAMS_MSG;
		
	$.post( "resize_gallery.php", { full_width: full_width, full_height: full_height, thumb_width: thumb_width, thumb_height: thumb_height, preserve_thumb_aspect: preserve_thumb_aspect, show_titles: show_titles, disable_sort: disable_sort } ).done(CompleteResizeGallery) ;
}
function CompleteResizeGallery(data)
{
	document.getElementById("uploading_div").style.visibility = "hidden";
	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	if (data > 0)	{
		popup_msg.status_msg = MANAGE_GALLERY_UPDATE_SUCCESS_MSG;
		popup_msg.popup_timeout = 3000;
	}
	else	{
		popup_msg.status_msg = MANAGE_GALLERY_UPDATE_FAIL_ERR + ": " + data;
		popup_msg.popup_timeout = 5000;
	}
	popup_msg.ShowPopupMsg();
}

function SaveTitle(i)
{
	var image_el = "image" + i;
	var title_el = "title" + i;
	
	var image = document.getElementById(image_el).value;
	var title = document.getElementById(title_el).value;
	
	$.post( "save_gallery_title.php", { image: image, title: title, sort_order: i } ).done(CompleteSaveTitle) ;
}
function CompleteSaveTitle(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_GALLERY_UPDATE_TITLE_SUCCESS_MSG;
	popup_msg.popup_timeout = 3000;
	popup_msg.ShowPopupMsg();
	
	GetGalleryImages();
}

function ShowLargeImage(image_path)
{
	var top_offset = -100;
	var left_offset = 100;
	
	var blowup_img_el = document.getElementById("blowup_img");
	blowup_img_el.src = image_path;
	if (window.innerHeight)	{
		blowup_img_el.style.maxWidth = window.innerWidth + "px";
		blowup_img_el.style.maxHeight = window.innerHeight + "px";
	}
	else	{
		var full_width = document.getElementById("full_width").value;
		var full_height = document.getElementById("full_height").value;
		blowup_img_el.style.maxWidth = full_width + "px";
		blowup_img_el.style.maxHeight = full_height + "px";
	}
	
	var ntop;
	ntop = tempY + top_offset;
	
	if (ntop < 500)
		ntop = ntop + 50;
	else
		ntop = ntop - 200;
	var strtop = ntop + "px";
	var strleft = left_offset + "px";
	
	var blowup_div_el = document.getElementById("blowup_div");
	blowup_div_el.style.display = "block";
	blowup_div_el.style.position = "absolute";
	blowup_div_el.style.top = strtop;
	blowup_div_el.style.left = strleft;
}

function HideLargeImage()
{
	document.getElementById("blowup_div").style.display = "none";
}

function DeleteConfirm(i)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	var image_el = "image" + i;
	var delete_text = document.getElementById(image_el).value;
	popup_msg.popup_msg_cell = MANAGE_GALLERY_DELETE_IMAGE_CONFIRM_1_MSG + " <b>" + delete_text + "</b>" + MANAGE_GALLERY_DELETE_IMAGE_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteImage(i); };
	document.getElementById("popup_button_1_span").onclick = function () { popup_msg.HidePopupMsg(); };
}

function DeleteImage(i)
{
	var image_el = "image" + i;
	var image_delete = document.getElementById(image_el).value;
	image_row = i;
	popup_msg.HidePopupMsg();
	
	$.post( "delete_gallery_image.php", { image: image_delete } ).done(CompleteDeleteImage) ;
}
function CompleteDeleteImage(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	if (data == 1)	{
		popup_msg.status_msg = MANAGE_GALLERY_DELETE_IMAGE_SUCCESS_MSG;
		popup_msg.popup_timeout = 2000;
	}
	else	{
		popup_msg.status_msg = MANAGE_GALLERY_DELETE_IMAGE_FAIL_ERR;
		popup_msg.popup_timeout = 5000;
	}
	popup_msg.ShowPopupMsg();
	
	GetGalleryImages();
}

function ShowUploading()
{
	document.getElementById("uploading_div").style.visibility = "visible";
	document.getElementById("uploading_span").innerHTML = MANAGE_GALLERY_UPLOADING_IMAGES_MSG;
}

function GetGalleryImages()
{
	$.post( "get_gallery_images.php", { } ).done(PopulateGalleryImages) ;
}
function PopulateGalleryImages(data)
{
	var files = data.split("@@@@@");
	var JSON_row;
	
	var preserve_thumb_aspect;
	if (document.getElementById("preserve_thumb_aspect").checked === true)
		preserve_thumb_aspect = 1;
	else
		preserve_thumb_aspect = 0;
	var thumb_width = document.getElementById("thumb_width").value;
	var thumb_height = document.getElementById("thumb_height").value;
	
	var html = "<table align='center' class='image_table'>\n";
	html = html + "<tr style='background-color:#cccccc;'><td>&nbsp;</td><td class='bold'>" + TITLE_WORD + ":</td><td colspan='4'>&nbsp;</td></tr>\n";

	var i = 0;
	var j = 0;
	var bgcolor = "#eeeeee";
	var up_img_style;
	var down_img_style;
	var image_path_rel;
	for (var i = 0; i < files.length; i++)
	{
		JSON_row = JSON.parse(files[i]);
		if (JSON_row.tn == 1)
			image_path_rel = tn_image_path_rel;
		else
			image_path_rel = orig_image_path_rel;
		
		html = html + "<tr id=\"row" + i +"\" style='background-color:" + bgcolor + ";'><td><img src='" + image_path_rel + JSON_row.file + "' width='" + thumb_width + "'";
		if (preserve_thumb_aspect == 0)
			html = html + " height='" + thumb_height + "'";
		html = html + " onclick=\"ShowLargeImage('" + orig_image_path_rel + JSON_row.file + "');\" style='cursor:pointer;' />\n";
		html = html + "<input type='hidden' name=\"image\" id=\"image" + i + "\" value='" + JSON_row.file + "' /></td>\n";
		html = html + "<td align='center'><textarea name=\"title\" id=\"title" + i + "\" class='image_title' value='" + JSON_row.title + "' />" + JSON_row.title + "</textarea>\n";
		j = i + 1;
		html = html + "<br /><span class='small_message'>" + JSON_row.file + "\n<br />" + j + "</span>\n";
		html = html + "<input type='hidden' name=\"sort_order\" id=\"sort_order" + i + "\" class='sort' value=\"" + i + "\" /></td>\n";
		html = html + "<td align='center'><div class='button_console_save_sm' style='width:90px;' onClick=\"SaveTitle(" + i + ");\"><span class='button_console_text_w_sm_icon'>" + EDITOR_SAVE + "</span></div></td>\n";
		
		html = html + "<td align='center'>\n<img src='../theme/" + theme + "/images/arrow-up.png' border=0 alt='Move Up' name='MoveUp' id=\"MoveUp" + i + "\" onClick=\"MoveItem(" + i + ");\" style='cursor:pointer;" + up_img_style + "' />\n<\/td>\n";
			
		d = parseInt(i) + 1;
		html = html + "<td align='center'>\n<img src='../theme/" + theme + "/images/arrow-down.png' border=0 alt='Move Down' name='MoveDown' id=\"MoveDown" + i + "\" onClick=\"MoveItemDown(" + d + ");\" style='cursor:pointer;' />\n<\/td>\n";
			
		html = html + "<td align='center'><img src='../theme/" + theme + "/images/delete.png' alt='" + MANAGE_GALLERY_DELETE_IMAGE + "' border='0' onClick=\"DeleteConfirm(" + i + ");\" style='cursor:pointer;' /></td></tr>\n";
		if (bgcolor == "#eeeeee")
			bgcolor = "#dddddd";
		else
			bgcolor = "#eeeeee";
	}
	html = html + "<tr id=\"row" + i + "\" bgcolor='#cccccc' style='line-height:3px;'>\n";
	html = html + "<td colspan='6'>&nbsp;<\/td>\n<\/tr>\n";
	
	
	html = html + "</table>\n";
	document.getElementById("image_table_div").innerHTML = html;
	document.getElementById("nCount").value = i;
	
	var LastMoveDown = "MoveDown" + (i - 1);
	document.getElementById(LastMoveDown).style.display = "none";
	document.getElementById("MoveUp0").style.display = "none";
}

////////////////////////////////////////////////////////////////////////////////////////
function MoveItem(i)
{
	update_all = true;
	window.parent.SetWorkSavedNotSaved(false);
	
	var html = document.getElementById("image_table_div").innerHTML;
	var cnt = parseInt(document.getElementById("nCount").value);
	var t = i - 1;
	var b = i + 1;
	var srch_str_t;
	var srch_str_b;
	var srch_str_i;
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		srch_str_t = "<TR id=row" + t;
		srch_str_b = "<TR id=row" + b;
		srch_str_i = "<TR id=row" + i;
	}
	else
	{
		srch_str_t = "<tr id=\"row" + t + "\"";
		srch_str_b = "<tr id=\"row" + b + "\"";
		srch_str_i = "<tr id=\"row" + i + "\"";
	}
	
	// Get top part of table.
	var html_top = html.substring(0, html.indexOf(srch_str_t));
	
	// Get bottom part of table.
	var html_bottom = html.substring(html.indexOf(srch_str_b));
	
	// Get row to move down.
	var html_move_down = html.substring(html_top.length, html.indexOf(srch_str_i));
	
	// Get row to move up.
	var html_move_up = html.substring(html_top.length + html_move_down.length, html.indexOf(srch_str_b));
	
	var rplc_str;
	srch_str = "row" + t;
	rplc_str = "row" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "image" + t;
	rplc_str = "image" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "title" + t;
	rplc_str = "title" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "sort_order" + t;
	rplc_str = "sort_order" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "SaveTitle(" + t;
	rplc_str = "SaveTitle(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "DeleteConfirm(" + t;
	rplc_str = "DeleteConfirm(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveUp" + t;
	rplc_str = "MoveUp" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveDown" + t;
	rplc_str = "MoveDown" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItem(" + t;
	rplc_str = "MoveItem(" + i;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	srch_str = "MoveItemDown(" + i;
	rplc_str = "MoveItemDown(" + b;
	html_move_down = html_move_down.replace(srch_str,rplc_str);
	html_move_up = html_move_up.replace(rplc_str,srch_str);
	
	var topclr = "#aaffaa";
	var botclr = "#ffaaaa";
	var bgclr1 = "#dddddd";
	var bgclr2 = "#eeeeee";
	html_move_up = html_move_up.replace(bgclr1,topclr);
	html_move_up = html_move_up.replace(bgclr2,topclr);
	html_move_down = html_move_down.replace(bgclr1,botclr);
	html_move_down = html_move_down.replace(bgclr2,botclr);
			
	html = html_top + html_move_up + html_move_down + html_bottom;
	
	var cnt_1 = cnt - 1;
	var cnt_2 = cnt - 2;
	LastMoveDown = "MoveDown" + cnt_1;
	NextToLastMoveDown = "MoveDown" + cnt_2;
	
	if (navigator.appName == "Microsoft Internet Explorer")
	{
		// This next block of code is intenended to fix an id attribute issue with IE, but does not work.
		srch_str = "id=" + LastMoveDown;
		rplc_str = "id='" + LastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		srch_str = "id=" + NextToLastMoveDown;
		rplc_str = "id='" + NextToLastMoveDown + "'";
		html = html.replace(srch_str,rplc_str);
		html = html.replace("id=MoveUp0","id=\"MoveUp0\"");
		html = html.replace("id=MoveUp1","id=\"MoveUp1\"");
		
		// Note the order in which the HTML is added to the element.
		document.getElementById("image_table_div").innerHTML = html;
		
		// Since the trick above for fixing the ids did not work, just update everthing now which will refresh the page.
		UpdateAll();
	}
	else
	{
		// Note the order in which the HTML is added to the element.
		document.getElementById("image_table_div").innerHTML = html;
		
		document.getElementById(LastMoveDown).style.display = "none";
		document.getElementById("MoveUp0").style.display = "none";
		document.getElementById(NextToLastMoveDown).style.display = "table-row";
		document.getElementById("MoveUp1").style.display = "table-row";
	}
	
	document.getElementById("update_sort_btn").style.display = "block";
}

function MoveItemDown(i)
{
	MoveItem(i);
}

function SaveSortOrder()
{
	var cnt = parseInt(document.getElementById("nCount").value);
	var image_ctl;
	var image_arr = new Array();
	for (var i = 0; i < cnt; i++)
	{
		image_ctl = "image" + i;
		image_arr[i] = document.getElementById(image_ctl).value;
	}
	$.post( "save_gallery_sort_order.php", { 'images[]': image_arr } ).done(CompleteSaveSortOrder) ;
}
function CompleteSaveSortOrder(data)
{	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	if (data > -1)	{
		update_all = false;
		document.getElementById("update_sort_btn").style.display = "none";
		popup_msg.status_msg = MANAGE_GALLERY_SAVE_SORT_ORDER_SUCCESS_MSG;
		popup_msg.popup_timeout = 2000;
	}
	else	{
		popup_msg.status_msg = MANAGE_GALLERY_SAVE_SORT_ORDER_FAIL_ERR;
		popup_msg.popup_timeout = 5000;
	}
	popup_msg.ShowPopupMsg();
	
	update_all = false;
	window.parent.SetWorkSavedNotSaved(true);
	
	GetGalleryImages();
}

function ResizeThumbs()
{
	if (!update_all)
		GetGalleryImages();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = MANAGE_GALLERY_NOT_SAVED_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	SaveSortOrder();
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}