<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 10/12/2010 ELL
// Added order by `revised` descending which is now possible because `revised` field was changed from VARCHAR to TIMESTAMP.
// Revised: 2/3/2011	ELL
// Added selection of page name and filtering by page name to make less cumbersome.
// Revised: 2/9/2012	ELL
// Added table prefix handling.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/4/2014	ELL
// Offloaded preview of content to popup preview page, and added popup code preview.
//
	include ("check_session.php");
	
	$page_name = $_REQUEST['page_name'];
?>
<!DOCTYPE html>
<html>
<head>
<title>Restore Page | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<style>
#help_button_sm	{
	position:inherit;
	width:30px;
	height:28px;
	background-image:url(images/HelpIcon_xsm.png);
}

#popup_msg_div {
   background-color: #FFFFFF;
   border: 3px solid #FEA44E;
   z-index: 1000;
   display: block;
   padding: 5px;
   font-family:Arial, Helvetica, sans-serif;
}

#popup_msg_close_btn	{
	float:right;
}

#popup_button_row	{	height:30px;	}
#popup_msg_row	{	height:30px;	}
.popup_button	{
	background-color:#FFFFFF;
	border-width:medium;
	border-color:#AAAAAA;
	border-style:solid;
	padding-top:2px;
	padding-bottom:2px;
	padding-left:5px;
	padding-right:5px;
}
#popup_msg_table	{
	border:0;
}
#popup_msg_cell	{
	text-align:center;
}
#popup_prompt_cell	{
	text-align:center;
}
#popup_button_1_cell, #popup_button_2_cell	{
	text-align:center;
}

.help_button	{
	width:30px;
	height:30px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 0px 1px;
	background-image:url(images/icon_Info_default.png);
}
.help_button:hover	{
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 0px 1px;
	background-image:url(images/icon_Info_down-state.png);
	cursor:pointer;
}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:210px;
	height:31px;
	width:31px;
	z-index:100;
}

.button_heading_sub_level_1	{
	width:260px;
	height:32px;
	text-align:left;
	vertical-align:middle;
	background-color:#585858;
}
.button_heading_text_sub_level_1	{
	color:#FFFFFF;
	font-family: Helvetica, Arial, Verdana, Sans-Serif;
	font-size:12px;
	font-weight:800;
	display:block;
	position:relative;
	top:8px;
	left:50px;
}

.restore_page_text	{
	font-family: Helvetica, Arial, Verdana, Sans-Serif;
	font-size: 16px;
	font-weight:bold;
}
.restore_page_header	{	/*background-color: #D9D9D9;*/	}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script type="text/javascript" src="js/restore_page_select.js"></script>

<script>
<?php
	echo "	var RESTORE_PAGE_DELETE_BACKUP_CONFIRM_1_MSG = \"" . RESTORE_PAGE_DELETE_BACKUP_CONFIRM_1_MSG . "\";\n";
	echo "	var RESTORE_PAGE_DELETE_BACKUP_CONFIRM_2_MSG = \"" . RESTORE_PAGE_DELETE_BACKUP_CONFIRM_2_MSG . "\";\n";
	echo "	var RESTORE_PAGE_RESTORE_PAGE_CONFIRM_1_MSG = \"" . RESTORE_PAGE_RESTORE_PAGE_CONFIRM_1_MSG . "\";\n";
	echo "	var RESTORE_PAGE_RESTORE_PAGE_CONFIRM_2_MSG = \"" . RESTORE_PAGE_RESTORE_PAGE_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
?>
</script>

</head>

<body id="workspace_body">
<table width="100%"><tr class="restore_page_header">
<td>
<div class="button_heading_sub_level_1" id="restore_page_heading"><div class="button_heading_text_sub_level_1"><?php echo RESTORE_PAGE_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td><span class="restore_page_text"><?php echo RESTORE_PAGE_SELECT_PAGE; ?>:</span> </td>
<td>
<select name="selectPage" onChange="SelectPage(this.value);">
<option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
$query = "SELECT DISTINCT page_name FROM " . BWB_TABLE_PREFIX . "page_data_bkup ORDER BY page_name";
$result = $bwb_dbh->query($query);
while ($row = $result->fetch(PDO::FETCH_ASSOC))
{
	$tmp_page_name = $row['page_name'];
	if ($tmp_page_name == $page_name)
		echo "   <option value='$tmp_page_name' selected='selected'>$tmp_page_name</option>\n";
	else
		echo "   <option value='$tmp_page_name'>$tmp_page_name</option>\n";
}
?>
</select>
</td>
</tr></table>

<table border="1">
	<tr bgcolor='#CCCCCC'>
		<td colspan="2"><?php echo CONTENT_WORD; ?></td><td><?php echo LAST_REVISED; ?></td><td><?php echo DELETED_WORD; ?></td><td><?php echo RESTORE_WORD; ?></td><td><?php echo REMOVE_WORD; ?></td>
	</tr>
<?php
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data_bkup WHERE page_name='$page_name' ORDER BY `revised` DESC";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		if ($bgclr == "#DDDDDD")
			$bgclr = "#EEEEEE";
		else
			$bgclr = "#DDDDDD";
			
		$ID = $row["ID"];
		$page_name = $row["page_name"];
		$page_content = $row["page_content"];
		$revised = $row["revised"];
		$deleted = $row["deleted"];
		echo "<tr bgcolor='$bgclr'>\n";
		echo "<td>\n<div class='button_console_preview_sm' style='min-width:130px;' onClick=\"DisplayArchivedContent(" . $ID . ");\"><span class='button_console_text_w_sm_icon'>" . RESTORE_PAGE_SHOW_CONTENT_BTN . "</span></div>\n</td>\n";
		echo "<td>\n<div class='button_console_preview_sm' style='min-width:130px;' onClick=\"window.open('display_archived_code.php?ID=" . $ID . "', 'PreviewArchive', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000');\"><span class='button_console_text_w_sm_icon'>" . RESTORE_PAGE_SHOW_CODE_BTN . "</span></div>\n</td>\n";
		echo "<td>$revised</td>\n";
		echo "<td>$deleted</td>\n";
		echo "<td><img src='theme/" . $theme . "/images/check.png' border=0 alt='" . RESTORE_WORD . "' name='" . RESTORE_WORD . "' onClick=\"RestoreConfirm('" . $page_name . "', " . $ID . ");\" style='cursor:pointer;' /></td>\n";
		echo "<td><img src='theme/" . $theme . "/images/delete.png' border=0 alt='" . RESTORE_PAGE_DELETE_FROM_HISTORY . "' name='" . RESTORE_PAGE_DELETE_FROM_HISTORY . "' onClick=\"DeleteConfirm('" . $page_name . "', " . $ID . ");\" style='cursor:pointer;' /></td></tr>\n";
		
		$i++;
    }
?>
</table>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	popup_msg.HidePopupMsg();
</script>
</body>
</html>
