<?php
////////////////////////////////////////////////////////////////////////
// Restrict Page Access //
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/9/2010
// Revised: 2/9/2012	ELL
// Added table prefix handling.
// Revised: 5/1/2017	ELL
// Changed from defining pages as either being editable by restricted users or not to ability to assign which restricted users have ability to edit any particular page.
	
	include ("check_session.php");
	
	if ($access_level != "admin")
		exit;
	
	$page_restrictions_saved = $_REQUEST['page_restrictions_saved'];
	$AccessLevel = $_REQUEST['AccessLevel'];
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Restrict Editing Access | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#restrict_page_access_heading	{	width:460px;	}
#button_help	{	left:410px;	}
#select_all_btn	{	width:110px;	}
#clear_all_btn	{	width:110px;	}
#save_restricted_pages_btn	{	width:110px;	}
.user_text_input	{	width:70%;	}
</style>

<script src="js/browser_detect.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/restrict_editing_access.js"></script>

<script>
	var users = new Array();
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "users WHERE AccessLevel = '" . $AccessLevel . "' ORDER BY UserID";
	$result = $bwb_dbh->query($query);
	$users = array();
	$i = 0;
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$users[] = $row['UserID'];
		echo "	users[$i] = '" . $row['UserID'] . "';\n";
		$i++;
	}
	
	echo "	var RESTRICT_PAGE_EDITING_RESTRICTIONS_SAVED_MSG = \"" . RESTRICT_PAGE_EDITING_RESTRICTIONS_SAVED_MSG . "\";\n";
?>
</script>
</head>

<body>

<div align="center">
<table width="80%" border="0"><tr><td>
<div id="restrict_page_access_heading" class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php if ($AccessLevel == "restricted") echo RESTRICT_PAGE_EDITING_HEADING; else echo RESTRICT_BLOG_EDITING_HEADING; ?></div><div id="button_help" class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>

<form action="save_restrict_editing.php" method="post" enctype="multipart/form-data" name="frm_restrict_editing" id="frm_restrict_editing">
<table width="80%" border="0" class="layout_box_table">
<tr bgcolor='#CCCCCC'>
	<td><b><?php echo PAGE_1ST_CAP_WORD; ?></b></td><td><b><?php echo USERS_WORD; ?></b></td>
<?php
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		if ($bgclr == "#DDDDDD")
			$bgclr = "#EEEEEE";
		else
			$bgclr = "#DDDDDD";
			
		$page_name = $row["page_name"];

		echo "<tr bgcolor='$bgclr'>\n<td>$page_name</td>\n<td>\n<select onChange=\"AddUser('" . $page_name . "', this.value);\">\n<option value=''>" . _NOT_SELECTED_ . "</option>\n";
		foreach ($users as $user)
		{
			echo "<option value='$user'>$user</option>\n";
		}
		echo "</select>\n";
		
		echo "<input name='" . $page_name . "' id='" . $page_name . "' type='text' class='user_text_input' value='";
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "users WHERE (AccessLevel = '" . $AccessLevel . "') AND (pages LIKE '%" . $page_name . "%') ORDER BY UserID";
		$result2 = $bwb_dbh->query($query);
		$comma = "";
		while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
		{
			$UserID = $row2['UserID'];
			$pages = explode(",", $row2['pages']);
			if (in_array($page_name, $pages))	{	// Need to check for exact name.
				echo $comma . $UserID;
				$comma = ",";
			}
		}
		echo "' />\n</td>\n</tr>\n";
	}
?>
</tr>
</table>

<input type="hidden" name="AccessLevel" id="AccessLevel" value="<?php echo $AccessLevel; ?>" />

<table width="80%" border="0" cellspacing="0" cellpadding="0">
 <tr>
   <td colspan="5">&nbsp;</td>
 </tr>
 <tr>
   <td align="center">
    <div class='button_console_add' id="select_all_btn" onClick="AddAll();"><span class='button_console_text_w_icon'><?php echo ADD_ALL; ?></span></div>
   </td>
   <td align="center">
    <div class='button_console_delete' id="clear_all_btn" onClick="ClearAll();"><span class='button_console_text_w_icon'><?php echo CLEAR_ALL; ?></span></div>
   </td>
   <td align="center">
	<div class='button_console_save' id="save_restricted_pages_btn" onClick="SaveAssignments();"><span class='button_console_text_w_icon'>
	<?php echo EDITOR_SAVE; ?></span></div>
   </td>
 </tr>
</table>
</form> 
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
	popup_msg.HidePopupMsg();
</script>

</body>
</html>