<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Re-engineered: 4/23/2010		ELL
// Revised: 6/22/2010	ELL
// Modified so that upload image brings form back to class that was selected.
// Added file extension checking to ensure that only images are allowed to be uploaded.
// Revised: 8/30/2010	ELL
// Fixed bug with handling # in HTML by using string replace. Replace ("#", ",", ".", " ") with ("POUND", "COMMA", "PERIOD", "SPACE").
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 2/9/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear and min/max prefix for width and height.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/18/2014	ELL
// Fixed bug with center site button and sticky footers button that got broke when submit_action was implemented inplace of the submit button.
// Revised: 3/5/2014	ELL
// Removed obsolete image Upload as this in now done with "AJAX" image uploader.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
// Revised: 2/14/2015	ELL
// Added visibility.
// Added full compliment of font-size units.
// Added full compliment of length units to border.
// Added full compliment of length units to all paddings.
// Revised: 5/15/2015	ELL
// Added background transparancy.
// Added overflow-x and overflow-y.
// Revised: 9/21/2015	ELL
// Added text-indent attribute.
// Revised: 1/19/2016	ELL
// Elimination of forwarding to CSS preview page. (New preview design.)
// Revised: 11/3/2016	ELL
// Added ability to set both min and max widths simultaneously, and both min and max heights simultaneously.
// Modified: 12/1/2016	ELL
// Consolidated all class tables into site_classes table indexed by style_sheet field.
// Consolidated all CSS tables into site_css table indexed by style_sheet field.
// Revised: 4/22/2017	ELL
// Added background RGBA labeled as "Foreground Opaque".
// Revised: 5/25/2017	ELL
// Added various transition, flex and content attributes.
// Added text-transform.
// Revised: 8/28/2017	ELL
// Added background gradient capability.
// Revised: 12/25/2017	ELL
// Fixed bug with quick setup actions where if no record existed for particular class, setup would fail.  This
// bug was introduced when build_sql_string.php was overhauled to take field array in place of specifying each field.
//
//
	include ("check_session.php");
		
	$style_sheet = $_REQUEST['style_sheet'];
	$css_file = $style_sheet . ".css";
	$show_class_editor = $_REQUEST['show_class_editor'];
	
	include ("lib/build_sql_string.php");
	include("lib/build_css_string.php");
	include ("lib/copy_table.php");

	$submit_action = $_REQUEST['submit_action'];
	if ($submit_action == "Update")
	{
		$site_style_sheet = $style_sheet;
	}
	elseif ($submit_action == "Preview")
	{
		$site_style_sheet = "site_css_preview";
		
		//Start by deleting all old preview data in table for style sheet.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $site_style_sheet . "'";
		$cnt = $bwb_dbh->exec($query);
		
		//Copy styles to preview style sheet..
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_css WHERE style_sheet = '$style_sheet'";
		$result = $bwb_dbh->query($query);
		$comma = ", ";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$sql = "REPLACE INTO " . BWB_TABLE_PREFIX . "site_css SET style_sheet = '" . $site_style_sheet . "'";
			foreach ($row as $field => $val)
			{
				if ($field != "style_sheet")	{
					$sql .= $comma . "`" . $field . "` = '" . $val . "'";
				}
			}
			$cnt = $bwb_dbh->exec($sql);
		}
		
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` = '" . $style_sheet . "'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$show_custom_styles = $row['show_custom_styles'];
		
		if ($show_custom_styles == 1)
		{
			//Get custom site CSS.
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE name = '" . $style_sheet . "'";				
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)	{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$custom_css = addslashes(stripslashes($row["custom_css"]));
			}
			else
				$custom_css = "";
				
			
			//Insert new data into table.
			$today = date("Y-m-d H:i:s");
			
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css WHERE name = 'site_css_preview'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)
				$query = "UPDATE " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "', revised = '" . $today . "' WHERE name = 'site_css_preview'";
			else
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "custom_site_css SET custom_css = '" . $custom_css . "', revised = '" . $today . "', name = 'site_css_preview'";
			
			$cnt = $bwb_dbh->exec($query);
		}
	}

	$class = $_REQUEST['class'];
	$search = array("PERIOD", "POUND", "SPACE", "COMMA", "GREATERTHAN", "GREATERTHAN", "PLUS", "TILDA");
	$replace = array(".", "#", " ", ",", ">", "&gt;", "+", "~");
	$class = str_replace($search, $replace, $class);
			
	if ($_POST["use_table_data"]) $use_table_data = $_POST["use_table_data"];
	else $use_table_data = 0;
	if ($_POST["font"]) $font = $_POST["font"];
	else $font = "-not selected-";
	if ($_POST["font2"]) $font2 = $_POST["font2"];
	else $font2 = "-not selected-";
	if ($_POST["font3"]) $font3 = $_POST["font3"];
	else $font3 = "-not selected-";
	if (is_numeric($_POST["font_size"])) $font_size = $_POST["font_size"];
	else $font_size = -1;
	if ($_POST["font_size_units"]) $font_size_units = $_POST["font_size_units"];
	else $font_size_units = "px";
	if ($_POST["text_color"]) $text_color = $_POST["text_color"];
	else $text_color = "-not set-";
	
	if (is_numeric($_POST["padding_top"])) $padding_top = $_POST["padding_top"];
	else $padding_top = -1;
	if (is_numeric($_POST["padding_right"])) $padding_right = $_POST["padding_right"];
	else $padding_right = -1;
	if (is_numeric($_POST["padding_bottom"])) $padding_bottom = $_POST["padding_bottom"];
	else $padding_bottom = -1;
	if (is_numeric($_POST["padding_left"])) $padding_left = $_POST["padding_left"];
	else $padding_left = -1;
	if (is_numeric($_POST["padding_top_units"])) $padding_top_units = $_POST["padding_top_units"];
	else $padding_top_units = 0;
	if (is_numeric($_POST["padding_right_units"])) $padding_right_units = $_POST["padding_right_units"];
	else $padding_right_units = 0;
	if (is_numeric($_POST["padding_bottom_units"])) $padding_bottom_units = $_POST["padding_bottom_units"];
	else $padding_bottom_units = 0;
	if (is_numeric($_POST["padding_left_units"])) $padding_left_units = $_POST["padding_left_units"];
	else $padding_left_units = 0;
	
	if ($_POST["weight"]) $weight = $_POST["weight"];
	else $weight = "-not selected-";
	if ($_POST["italic"]) $italic = $_POST["italic"];
	else $italic = 0;
	if ($_POST["underline"]) $underline = $_POST["underline"];
	else $underline = 0;
	if ($_POST["overline"]) $overline = $_POST["overline"];
	else $overline = 0;
	if ($_POST["blink"]) $blink = $_POST["blink"];
	else $blink = 0;
	if ($_POST["linethrough"]) $linethrough = $_POST["linethrough"];
	else $linethrough = 0;
	if (is_numeric($_POST["letter_spacing"])) $letter_spacing = $_POST["letter_spacing"];
	else $letter_spacing = -1000000;
	if (is_numeric($_POST["letter_spacing_units"])) $letter_spacing_units = $_POST["letter_spacing_units"];
	else $letter_spacing_units = -1;
	if ($_POST["oblique"]) $oblique = $_POST["oblique"];
	else $oblique = 0;
	if ($_POST["small_caps"]) $small_caps = $_POST["small_caps"];
	else $small_caps = 0;
	if ($_POST["no_text_decoration"]) $no_text_decoration = $_POST["no_text_decoration"];
	else $no_text_decoration = 0;
	if ($_POST["shadow"]) $shadow = $_POST["shadow"];
	else $shadow = 0;
	if ($_POST["shadow_color"]) $shadow_color = $_POST["shadow_color"];
	else $shadow_color = "-not set-";
	if (is_numeric($_POST["shadow_x_offset"])) $shadow_x_offset = $_POST["shadow_x_offset"];
	else $shadow_x_offset = 0;
	if (is_numeric($_POST["shadow_y_offset"])) $shadow_y_offset = $_POST["shadow_y_offset"];
	else $shadow_y_offset = 0;
	if (is_numeric($_POST["shadow_blur"])) $shadow_blur = $_POST["shadow_blur"];
	else $shadow_blur = 0;
	if (is_numeric($_POST["line_height"])) $line_height = $_POST["line_height"];
	else $line_height = -1;
	if (is_numeric($_POST["line_height_units"])) $line_height_units = $_POST["line_height_units"];
	else $line_height_units = -1;
	if (is_numeric($_POST["text_indent"])) $text_indent = $_POST["text_indent"];
	else $text_indent = -1000000;
	if (is_numeric($_POST["text_indent_units"])) $text_indent_units = $_POST["text_indent_units"];
	else $text_indent_units = -1;
	
	if ($_POST["align"]) $align = $_POST["align"];
	else $align = "-not selected-";
	if ($_POST["vertical_align"]) $vertical_align = $_POST["vertical_align"];
	else $vertical_align = "-not selected-";
	if ($_POST["bkgd_color"]) $bkgd_color = $_POST["bkgd_color"];
	else $bkgd_color = "-not set-";
	if ($_POST["bkgd_transparent"]) $bkgd_transparent = $_POST["bkgd_transparent"];
	else $bkgd_transparent = 0;
	if (is_numeric($_POST["bkgd_opacity"])) $bkgd_opacity = $_POST["bkgd_opacity"];
	else $bkgd_opacity = -1;
	if ($_POST["bkgd_rgba"]) $bkgd_rgba = $_POST["bkgd_rgba"];
	else $bkgd_rgba = 0;
	
	if (is_numeric($_POST["border"])) $border = $_POST["border"];
	else $border = -1;
	if (is_numeric($_POST["border_units"])) $border_units = $_POST["border_units"];
	else $border_units = 0;
	if ($_POST["border_color"]) $border_color = $_POST["border_color"];
	else $border_color = "-not set-";
	if ($_POST["border_style"]) $border_style = $_POST["border_style"];
	else $border_style = "-not selected-";
	if ($_POST["outline_style"]) $outline_style = $_POST["outline_style"];
	else $outline_style = "-not selected-";
	if ($_POST["border_collapse"]) $border_collapse = $_POST["border_collapse"];
	else $border_collapse = "-not selected-";
	if (is_numeric($_POST["border_sides"])) $border_sides = $_POST["border_sides"];
	else $border_sides = 15;
	
	if ($_POST["display"]) $display = $_POST["display"];
	else $display = "-not selected-";
	if (is_numeric($_POST["width"])) $width = $_POST["width"];
	else $width = -1;
	if ($_POST["width_units"]) $width_units = $_POST["width_units"];
	else $width_units = 0;
	if ($_POST["width_prefix"]) $width_prefix = $_POST["width_prefix"];
	else $width_prefix = "";
	if (is_numeric($_POST["max_width"])) $max_width = $_POST["max_width"];
	else $max_width = -1;
	if ($_POST["max_width_units"]) $max_width_units = $_POST["max_width_units"];
	else $max_width_units = 0;
	if (is_numeric($_POST["height"])) $height = $_POST["height"];
	else $height = -1;
	if ($_POST["height_units"]) $height_units = $_POST["height_units"];
	else $height_units = 0;
	if ($_POST["height_prefix"]) $height_prefix = $_POST["height_prefix"];
	else $height_prefix = "";
	if (is_numeric($_POST["max_height"])) $max_height = $_POST["max_height"];
	else $max_height = -1;
	if ($_POST["max_height_units"]) $max_height_units = $_POST["max_height_units"];
	else $max_height_units = 0;
	if ($_POST["background_image"]) $background_image = $_POST["background_image"];
	else $background_image = "-not selected-";
	if ($_POST["background_attachment"]) $background_attachment = $_POST["background_attachment"];
	else $background_attachment = "-not selected-";
	if ($_POST["background_repeat"]) $background_repeat = $_POST["background_repeat"];
	else $background_repeat = "-not selected-";
	if ($_POST["background_position"]) $background_position = $_POST["background_position"];
	else $background_position = "-not selected-";
	if (is_numeric($_POST["background_position_x"])) $background_position_x = $_POST["background_position_x"];
	else $background_position_x = 0;
	if (is_numeric($_POST["background_position_y"])) $background_position_y = $_POST["background_position_y"];
	else $background_position_y = 0;
	if ($_POST["background_position_units"]) $background_position_units = $_POST["background_position_units"];
	else $background_position_units = 0;
	
	if (is_numeric($_POST["margin_top"])) $margin_top = $_POST["margin_top"];
	else $margin_top = -1000000;
	if (is_numeric($_POST["margin_right"])) $margin_right = $_POST["margin_right"];
	else $margin_right = -1000000;
	if (is_numeric($_POST["margin_left"])) $margin_left = $_POST["margin_left"];
	else $margin_left = -1000000;
	if (is_numeric($_POST["margin_bottom"])) $margin_bottom = $_POST["margin_bottom"];
	else $margin_bottom = -1000000;
	if ($_POST["margin_top_units"]) $margin_top_units = $_POST["margin_top_units"];
	else $margin_top_units = 0;
	if ($_POST["margin_top_auto"]) $margin_top_auto = $_POST["margin_top_auto"];
	else $margin_top_auto = 0;
	if ($_POST["margin_right_units"]) $margin_right_units = $_POST["margin_right_units"];
	else $margin_right_units = 0;
	if ($_POST["margin_right_auto"]) $margin_right_auto = $_POST["margin_right_auto"];
	else $margin_right_auto = 0;
	if ($_POST["margin_left_units"]) $margin_left_units = $_POST["margin_left_units"];
	else $margin_left_units = 0;
	if ($_POST["margin_left_auto"]) $margin_left_auto = $_POST["margin_left_auto"];
	else $margin_left_auto = 0;
	if ($_POST["margin_bottom_units"]) $margin_bottom_units = $_POST["margin_bottom_units"];
	else $margin_bottom_units = 0;
	if ($_POST["margin_bottom_auto"]) $margin_bottom_auto = $_POST["margin_bottom_auto"];
	else $margin_bottom_auto = 0;
	
	if ($_POST["position"]) $position = $_POST["position"];
	else $position = "-not selected-";
	if (is_numeric($_POST["position_left"])) $position_left = $_POST["position_left"];
	else $position_left = -1000000;
	if ($_POST["position_left_units"]) $position_left_units = $_POST["position_left_units"];
	else $position_left_units = 0;
	if (is_numeric($_POST["position_top"])) $position_top = $_POST["position_top"];
	else $position_top = -1000000;
	if ($_POST["position_top_units"]) $position_top_units = $_POST["position_top_units"];
	else $position_top_units = 0;
	if (is_numeric($_POST["position_right"])) $position_right = $_POST["position_right"];
	else $position_right = -1000000;
	if ($_POST["position_right_units"]) $position_right_units = $_POST["position_right_units"];
	else $position_right_units = 0;
	if (is_numeric($_POST["position_bottom"])) $position_bottom = $_POST["position_bottom"];
	else $position_bottom = -1000000;
	if ($_POST["position_bottom_units"]) $position_bottom_units = $_POST["position_bottom_units"];
	else $position_bottom_units = 0;
	if (is_numeric($_POST["z_index"])) $z_index = $_POST["z_index"];
	else $z_index = -1000000;
	if ($_POST["overflow"]) $overflow = $_POST["overflow"];
	else $overflow = "-not selected-";
	if ($_POST["overflow_x"]) $overflow_x = $_POST["overflow_x"];
	else $overflow_x = "-not selected-";
	if ($_POST["overflow_y"]) $overflow_y = $_POST["overflow_y"];
	else $overflow_y = "-not selected-";
	if (is_numeric($_POST["clip_top"])) $clip_top = $_POST["clip_top"];
	else $clip_top = -1;
	if (is_numeric($_POST["clip_top_units"])) $clip_top_units = $_POST["clip_top_units"];
	else $clip_top_units = -1;
	if (is_numeric($_POST["clip_right"])) $clip_right = $_POST["clip_right"];
	else $clip_right = -1;
	if (is_numeric($_POST["clip_right_units"])) $clip_right_units = $_POST["clip_right_units"];
	else $clip_right_units = -1;
	if (is_numeric($_POST["clip_bottom"])) $clip_bottom = $_POST["clip_bottom"];
	else $clip_bottom = -1;
	if (is_numeric($_POST["clip_bottom_units"])) $clip_bottom_units = $_POST["clip_bottom_units"];
	else $clip_bottom_units = -1;
	if (is_numeric($_POST["clip_left"])) $clip_left = $_POST["clip_left"];
	else $clip_left = -1;
	if (is_numeric($_POST["clip_left_units"])) $clip_left_units = $_POST["clip_left_units"];
	else $clip_left_units = -1;
	if ($_POST["float"]) $float = $_POST["float"];
	else $float = "-not selected-";
	if ($_POST["white_space"]) $white_space = $_POST["white_space"];
	else $white_space = "-not selected-";
	
	if ($_POST["list_style_type"]) $list_style_type = $_POST["list_style_type"];
	else $list_style_type = "-not selected-";
	if ($_POST["list_style_position"]) $list_style_position = $_POST["list_style_position"];
	else $list_style_position = "-not selected-";
	if ($_POST["list_style_image"]) $list_style_image = $_POST["list_style_image"];
	else $list_style_image = "-not selected-";
	
	if ($_POST["table_layout"]) $table_layout = $_POST["table_layout"];
	else $table_layout = "-not selected-";
	if ($_POST["clear"]) $clear = $_POST["clear"];
	else $clear = "-not selected-";

	if (is_numeric($_POST["radius_top_left"])) $radius_top_left = $_POST["radius_top_left"];
	else $radius_top_left = 0;
	if ($_POST["radius_top_left_units"]) $radius_top_left_units = $_POST["radius_top_left_units"];
	else $radius_top_left_units = 0;
	if (is_numeric($_POST["radius_top_right"])) $radius_top_right = $_POST["radius_top_right"];
	else $radius_top_right = 0;
	if ($_POST["radius_top_right_units"]) $radius_top_right_units = $_POST["radius_top_right_units"];
	else $radius_top_right_units = 0;
	if (is_numeric($_POST["radius_bottom_right"])) $radius_bottom_right = $_POST["radius_bottom_right"];
	else $radius_bottom_right = 0;
	if ($_POST["radius_bottom_right_units"]) $radius_bottom_right_units = $_POST["radius_bottom_right_units"];
	else $radius_bottom_right_units = 0;
	if (is_numeric($_POST["radius_bottom_left"])) $radius_bottom_left = $_POST["radius_bottom_left"];
	else $radius_bottom_left = 0;
	if ($_POST["radius_bottom_left_units"]) $radius_bottom_left_units = $_POST["radius_bottom_left_units"];
	else $radius_bottom_left_units = 0;
	
	if (is_numeric($_POST["box_shadow_horizontal"])) $box_shadow_horizontal = $_POST["box_shadow_horizontal"];
	else $box_shadow_horizontal = -1000000;
	if (is_numeric($_POST["box_shadow_vertical"])) $box_shadow_vertical = $_POST["box_shadow_vertical"];
	else $box_shadow_vertical = -1000000;
	if (is_numeric($_POST["box_shadow_blur"])) $box_shadow_blur = $_POST["box_shadow_blur"];
	else $box_shadow_blur = -1;
	if (is_numeric($_POST["box_shadow_spread"])) $box_shadow_spread = $_POST["box_shadow_spread"];
	else $box_shadow_spread = -1000000;
	if ($_POST["box_shadow_color"]) $box_shadow_color = $_POST["box_shadow_color"];
	else $box_shadow_color = "-not set-";
	if ($_POST["box_shadow_inset"]) $box_shadow_inset = $_POST["box_shadow_inset"];
	else $box_shadow_inset = 0;
	
	if ($_POST["cursor"]) $cursor = $_POST["cursor"];
	else $cursor = "-not selected-";
	
	if ($_POST["background_size"]) $background_size = $_POST["background_size"];
	else $background_size = "-not selected-";
	if (is_numeric($_POST["background_width"])) $background_width = $_POST["background_width"];
	else $background_width = -1;
	if ($_POST["background_width_units"]) $background_width_units = $_POST["background_width_units"];
	else $background_width_units = 0;
	if (is_numeric($_POST["background_height"])) $background_height = $_POST["background_height"];
	else $background_height = -1;
	if ($_POST["background_height_units"]) $background_height_units = $_POST["background_height_units"];
	else $background_height_units = 0;
	
	if ($_POST["visibility"]) $visibility = $_POST["visibility"];
	else $visibility = "-not selected-";
	
	if ($_POST["text_transform"]) $text_transform = $_POST["text_transform"];
	else $text_transform = "-not selected-";
	
	if ($_POST["justify_content"]) $justify_content = $_POST["justify_content"];
	else $justify_content = "-not selected-";
	if ($_POST["content"]) $content = $_POST["content"];
	else $content = "-not selected-";
	if ($_POST["content_text"]) $content_text = $_POST["content_text"];
	else $content_text = "";
	
	if ($_POST["transition_property"]) $transition_property = $_POST["transition_property"];
	else $transition_property = "-not selected-";
	if ($_POST["transition_timing_function"]) $transition_timing_function = $_POST["transition_timing_function"];
	else $transition_timing_function = "-not selected-";
	if (is_numeric($_POST["transition_duration"])) $transition_duration = $_POST["transition_duration"];
	else $transition_duration = -1;
	if ($_POST["transition_duration_units"]) $transition_duration_units = $_POST["transition_duration_units"];
	else $transition_duration_units = 0;
	if (is_numeric($_POST["transition_delay"])) $transition_delay = $_POST["transition_delay"];
	else $transition_delay = -1;
	if ($_POST["transition_delay_units"]) $transition_delay_units = $_POST["transition_delay_units"];
	else $transition_delay_units = 0;
				
	if ($_POST["flex_basis"]) $flex_basis = $_POST["flex_basis"];
	else $flex_basis = "-not selected-";
	if (is_numeric($_POST["flex_basis_length"])) $flex_basis_length = $_POST["flex_basis_length"];
	else $flex_basis_length = -1;
	if ($_POST["flex_basis_length_units"]) $flex_basis_length_units = $_POST["flex_basis_length_units"];
	else $flex_basis_length_units = 0;
	if (is_numeric($_POST["flex_grow"])) $flex_grow = $_POST["flex_grow"];
	else $flex_grow = -1;
	if (is_numeric($_POST["flex_shrink"])) $flex_shrink = $_POST["flex_shrink"];
	else $flex_shrink = -1;
	if ($_POST["flex_direction"]) $flex_direction = $_POST["flex_direction"];
	else $flex_direction = "-not selected-";
	if ($_POST["flex_wrap"]) $flex_wrap = $_POST["flex_wrap"];
	else $flex_wrap = "-not selected-";
	
	if ($_POST["gradient_type"]) $gradient_type = $_POST["gradient_type"];
	else $gradient_type = "-not selected-";
	if (is_numeric($_POST["gradient_angle"])) $gradient_angle = $_POST["gradient_angle"];
	else $gradient_angle = 0;
	if ($_POST["gradient_color_1"]) $gradient_color_1 = $_POST["gradient_color_1"];
	else $gradient_color_1 = "-not set-";
	if ($_POST["gradient_color_2"]) $gradient_color_2 = $_POST["gradient_color_2"];
	else $gradient_color_2 = "-not set-";
	if ($_POST["gradient_color_3"]) $gradient_color_3 = $_POST["gradient_color_3"];
	else $gradient_color_3 = "-not set-";
	if ($_POST["gradient_color_4"]) $gradient_color_4 = $_POST["gradient_color_4"];
	else $gradient_color_4 = "-not set-";
	if ($_POST["gradient_color_5"]) $gradient_color_5 = $_POST["gradient_color_5"];
	else $gradient_color_5 = "-not set-";
	if ($_POST["gradient_color_6"]) $gradient_color_6 = $_POST["gradient_color_6"];
	else $gradient_color_6 = "-not set-";
	if ($_POST["gradient_color_7"]) $gradient_color_7 = $_POST["gradient_color_7"];
	else $gradient_color_7 = "-not set-";
	if ($_POST["gradient_color_8"]) $gradient_color_8 = $_POST["gradient_color_8"];
	else $gradient_color_8 = "-not set-";
	if (is_numeric($_POST["gradient_opacity_1"])) $gradient_opacity_1 = $_POST["gradient_opacity_1"];
	else $gradient_opacity_1 = 100;
	if (is_numeric($_POST["gradient_opacity_2"])) $gradient_opacity_2 = $_POST["gradient_opacity_2"];
	else $gradient_opacity_2 = 100;
	if (is_numeric($_POST["gradient_opacity_3"])) $gradient_opacity_3 = $_POST["gradient_opacity_3"];
	else $gradient_opacity_3 = 100;
	if (is_numeric($_POST["gradient_opacity_4"])) $gradient_opacity_4 = $_POST["gradient_opacity_4"];
	else $gradient_opacity_4 = 100;
	if (is_numeric($_POST["gradient_opacity_5"])) $gradient_opacity_5 = $_POST["gradient_opacity_5"];
	else $gradient_opacity_5 = 100;
	if (is_numeric($_POST["gradient_opacity_6"])) $gradient_opacity_6 = $_POST["gradient_opacity_6"];
	else $gradient_opacity_6 = 100;
	if (is_numeric($_POST["gradient_opacity_7"])) $gradient_opacity_7 = $_POST["gradient_opacity_7"];
	else $gradient_opacity_7 = 100;
	if (is_numeric($_POST["gradient_opacity_8"])) $gradient_opacity_8 = $_POST["gradient_opacity_8"];
	else $gradient_opacity_8 = 100;
	if (is_numeric($_POST["gradient_repeat"])) $gradient_repeat = $_POST["gradient_repeat"];
	else $gradient_repeat = 0;
	
	if (($gradient_color_1 == "-not set-") && ($gradient_color_2 == "-not set-") && ($gradient_color_3 == "-not set-") && ($gradient_color_4 == "-not set-") && ($gradient_color_5 == "-not set-") && ($gradient_color_6 == "-not set-") && ($gradient_color_7 == "-not set-") && ($gradient_color_8 == "-not set-"))
		$gradient_colors = "-not set-";
	else	{
		$comma = "";
		$gradient_color == "";
		if ($gradient_color_1 != "-not set-")	{
			$gradient_colors .= $gradient_color_1;
			$comma = ",";
		}
		if ($gradient_color_2 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_2;
			$comma = ",";
		}
		if ($gradient_color_3 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_3;
			$comma = ",";
		}
		if ($gradient_color_4 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_4;
			$comma = ",";
		}
		if ($gradient_color_5 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_5;
			$comma = ",";
		}
		if ($gradient_color_6 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_6;
			$comma = ",";
		}
		if ($gradient_color_7 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_7;
			$comma = ",";
		}
		if ($gradient_color_8 != "-not set-")	{
			$gradient_colors .= $comma . $gradient_color_8;
			$comma = ",";
		}
	}
	
	if (($gradient_opacity_1 == 100) && ($gradient_opacity_2 == 100) && ($gradient_opacity_3 == 100) && ($gradient_opacity_4 == 100) && ($gradient_opacity_5 == 100) && ($gradient_opacity_6 == 100) && ($gradient_opacity_7 == 100) && ($gradient_opacity_7 == 100))
		$gradient_opacities = "-not set-";
	else
		$gradient_opacities = $gradient_opacity_1 . "," . $gradient_opacity_2 . "," . $gradient_opacity_3 . "," . $gradient_opacity_4 . "," . $gradient_opacity_5 . "," . $gradient_opacity_6 . "," . $gradient_opacity_7 . "," . $gradient_opacity_8;


	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . "site_css WHERE `style_sheet` = '" . $site_style_sheet . "' AND `class` = '" . $class . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	$fields = array();
	
	
	if ($_POST['quick_setup'] == 1)
	{
		if ($row_count > 0)
		{
			$fields = array("align", "vertical_align", "bkgd_color", "position", "position_bottom", "position_bottom_units", "position_top", "position_top_units", "position_right", "position_right_units", "position_left", "position_left_units", "width", "width_units", "width_prefix","max_width", "max_width_units", "height", "height_units", "height_prefix", "max_height", "max_height_units", "margin_left","margin_left_units", "margin_left_auto", "margin_right", "margin_right_units", "margin_right_auto", "margin_top", "margin_top_units", "margin_top_auto", "margin_bottom", "margin_bottom_units", "margin_bottom_auto", "overflow", "display", "clear", "background_size", "background_width", "background_width_units", "background_height", "background_height_units", "border", "border_units", "border_sides", "padding_top", "padding_right", "padding_bottom", "padding_left", "padding_top_units", "padding_right_units", "padding_bottom_units", "padding_left_units");
			
			$query = "UPDATE `" . BWB_TABLE_PREFIX . "site_css` SET `use_table_data`=1, ";
		}
		else	// row_count < 1
		{
			$fields = array("style_sheet", "class", "align", "vertical_align", "bkgd_color", "position", "position_bottom", "position_bottom_units", "position_top", "position_top_units", "position_right", "position_right_units", "position_left", "position_left_units", "width", "width_units", "width_prefix","max_width", "max_width_units", "height", "height_units", "height_prefix", "max_height", "max_height_units", "margin_left","margin_left_units", "margin_left_auto", "margin_right", "margin_right_units", "margin_right_auto", "margin_top", "margin_top_units", "margin_top_auto", "margin_bottom", "margin_bottom_units", "margin_bottom_auto", "overflow", "display", "clear", "background_size", "background_width", "background_width_units", "background_height", "background_height_units", "border", "border_units", "border_sides", "padding_top", "padding_right", "padding_bottom", "padding_left", "padding_top_units", "padding_right_units", "padding_bottom_units", "padding_left_units");
			
			$query = "INSERT INTO `" . BWB_TABLE_PREFIX . "site_css` SET `use_table_data`=1, ";
		}
		
		$delim = "";
		foreach ($_POST as $key => $val)
		{
			if (in_array($key, $fields))
			{
				$query .= $delim . "`" . $key . "`='" . $val . "'";
				$delim = ", ";
			}
		}
		
		if ($row_count > 0)
			$query .= " WHERE `style_sheet` = '" . $site_style_sheet . "' AND `class` = '" . $class . "'";
	}
	else
	{
		$fields['use_table_data'] = $use_table_data;
		$fields['font'] = $font;
		$fields['font2'] = $font2;
		$fields['font3'] = $font3;
		$fields['font_size'] = $font_size;
		$fields['font_size_units'] = $font_size_units;
		$fields['text_color'] = $text_color;
		$fields['padding_top'] = $padding_top;
		$fields['padding_right'] = $padding_right;
		$fields['padding_bottom'] = $padding_bottom;
		$fields['padding_left'] = $padding_left;
		$fields['padding_top_units'] = $padding_top_units;
		$fields['padding_right_units'] = $padding_right_units;
		$fields['padding_bottom_units'] = $padding_bottom_units;
		$fields['padding_left_units'] = $padding_left_units;
		$fields['weight'] = $weight;
		$fields['italic'] = $italic;
		$fields['underline'] = $underline;
		$fields['overline'] = $overline;
		$fields['blink'] = $blink;
		$fields['linethrough'] = $linethrough;
		$fields['letter_spacing'] = $letter_spacing;
		$fields['letter_spacing_units'] = $letter_spacing_units;
		$fields['oblique'] = $oblique;
		$fields['small_caps'] = $small_caps;
		$fields['no_text_decoration'] = $no_text_decoration;
		$fields['shadow'] = $shadow;
		$fields['shadow_color'] = $shadow_color;
		$fields['shadow_x_offset'] = $shadow_x_offset;
		$fields['shadow_y_offset'] = $shadow_y_offset;
		$fields['shadow_blur'] = $shadow_blur;
		$fields['line_height'] = $line_height;
		$fields['line_height_units'] = $line_height_units;
		$fields['align'] = $align;
		$fields['vertical_align'] = $vertical_align;
		$fields['text_indent'] = $text_indent;
		$fields['text_indent_units'] = $text_indent_units;
		$fields['bkgd_color'] = $bkgd_color;
		$fields['bkgd_transparent'] = $bkgd_transparent;
		$fields['bkgd_opacity'] = $bkgd_opacity;
		$fields['bkgd_rgba'] = $bkgd_rgba;
		$fields['border'] = $border;
		$fields['border_units'] = $border_units;
		$fields['border_color'] = $border_color;
		$fields['border_style'] = $border_style;
		$fields['outline_style'] = $outline_style;
		$fields['border_collapse'] = $border_collapse;
		$fields['border_sides'] = $border_sides;
		$fields['margin_top'] = $margin_top;
		$fields['margin_top_units'] = $margin_top_units;
		$fields['margin_top_auto'] = $margin_top_auto;
		$fields['margin_right'] = $margin_right;
		$fields['margin_right_units'] = $margin_right_units;
		$fields['margin_right_auto'] = $margin_right_auto;
		$fields['margin_left'] = $margin_left;
		$fields['margin_left_units'] = $margin_left_units;
		$fields['margin_left_auto'] = $margin_left_auto;
		$fields['margin_bottom'] = $margin_bottom;
		$fields['margin_bottom_units'] = $margin_bottom_units;
		$fields['margin_bottom_auto'] = $margin_bottom_auto;
		$fields['display'] = $display;
		$fields['width'] = $width;
		$fields['width_units'] = $width_units;
		$fields['width_prefix'] = $width_prefix;
		$fields['max_width'] = $max_width;
		$fields['max_width_units'] = $max_width_units;
		$fields['height'] = $height;
		$fields['height_units'] = $height_units;
		$fields['height_prefix'] = $height_prefix;
		$fields['max_height'] = $max_height;
		$fields['max_height_units'] = $max_height_units;
		$fields['position'] = $position;
		$fields['position_left'] = $position_left;
		$fields['position_left_units'] = $position_left_units;
		$fields['position_top'] = $position_top;
		$fields['position_top_units'] = $position_top_units;
		$fields['position_right'] = $position_right;
		$fields['position_right_units'] = $position_right_units;
		$fields['position_bottom'] = $position_bottom;
		$fields['position_bottom_units'] = $position_bottom_units;
		$fields['z_index'] = $z_index;
		$fields['overflow'] = $overflow;
		$fields['overflow_x'] = $overflow_x;
		$fields['overflow_y'] = $overflow_y;
		$fields['clip_top'] = $clip_top;
		$fields['clip_top_units'] = $clip_top_units;
		$fields['clip_right'] = $clip_right;
		$fields['clip_right_units'] = $clip_right_units;
		$fields['clip_bottom'] = $clip_bottom;
		$fields['clip_bottom_units'] = $clip_bottom_units;
		$fields['clip_left'] = $clip_left;
		$fields['clip_left_units'] = $clip_left_units;
		$fields['background_image'] = $background_image;
		$fields['background_attachment'] = $background_attachment;
		$fields['background_repeat'] = $background_repeat;
		$fields['background_position'] = $background_position;
		$fields['background_position_x'] = $background_position_x;
		$fields['background_position_y'] = $background_position_y;
		$fields['background_position_units'] = $background_position_units;
		$fields['list_style_type'] = $list_style_type;
		$fields['list_style_position'] = $list_style_position;
		$fields['list_style_image'] = $list_style_image;
		$fields['float'] = $float;
		$fields['white_space'] = $white_space;
		$fields['table_layout'] = $table_layout;
		$fields['clear'] = $clear;
		$fields['box_shadow_horizontal'] = $box_shadow_horizontal;
		$fields['box_shadow_vertical'] = $box_shadow_vertical;
		$fields['box_shadow_blur'] = $box_shadow_blur;
		$fields['box_shadow_spread'] = $box_shadow_spread;
		$fields['box_shadow_color'] = $box_shadow_color;
		$fields['box_shadow_inset'] = $box_shadow_inset;
		$fields['radius_top_left'] = $radius_top_left;
		$fields['radius_top_left_units'] = $radius_top_left_units;
		$fields['radius_top_right'] = $radius_top_right;
		$fields['radius_top_right_units'] = $radius_top_right_units;
		$fields['radius_bottom_right'] = $radius_bottom_right;
		$fields['radius_bottom_right_units'] = $radius_bottom_right_units;
		$fields['radius_bottom_left'] = $radius_bottom_left;
		$fields['radius_bottom_left_units'] = $radius_bottom_left_units;
		$fields['cursor'] = $cursor;
		$fields['background_size'] = $background_size;
		$fields['background_width'] = $background_width;
		$fields['background_width_units'] = $background_width_units;
		$fields['background_height'] = $background_height;
		$fields['background_height_units'] = $background_height_units;
		$fields['visibility'] = $visibility;
		$fields['text_transform'] = $text_transform;
		$fields['justify_content'] = $justify_content;
		$fields['content'] = $content;
		$fields['content_text'] = $content_text;
		$fields['transition_property'] = $transition_property;
		$fields['transition_timing_function'] = $transition_timing_function;
		$fields['transition_duration'] = $transition_duration;
		$fields['transition_duration_units'] = $transition_duration_units;
		$fields['transition_delay'] = $transition_delay;
		$fields['transition_delay_units'] = $transition_delay_units;
		$fields['flex_basis'] = $flex_basis;
		$fields['flex_basis_length'] = $flex_basis_length;
		$fields['flex_basis_length_units'] = $flex_basis_length_units;
		$fields['flex_grow'] = $flex_grow;
		$fields['flex_shrink'] = $flex_shrink;
		$fields['flex_direction'] = $flex_direction;
		$fields['flex_wrap'] = $flex_wrap;
		$fields['gradient_type'] = $gradient_type;
		$fields['gradient_angle'] = $gradient_angle;
		$fields['gradient_colors'] = $gradient_colors;
		$fields['gradient_opacities'] = $gradient_opacities;
		$fields['gradient_repeat'] = $gradient_repeat;
	}
		
  	if ($_POST['quick_setup'] != 1)
	{
		if ($row_count > 0)
		{
			//Update class record.
			$condition = "`style_sheet` = '" . $site_style_sheet . "' AND`class` = '" . $class . "'";
	
			$query = BuildSQLString(BWB_TABLE_PREFIX . "site_css", "UPDATE", $condition, "", $fields);
		}
		else
		{
			//Insert new data into table.
			$insert_key = "`style_sheet` = '" . $site_style_sheet . "', class='" . $class . "', ";
	
			$query = BuildSQLString(BWB_TABLE_PREFIX . "site_css", "INSERT INTO", "", $insert_key, $fields);
		}
	}
//	echo $query;
	$cnt = $bwb_dbh->exec($query);


	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString($site_style_sheet, $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX, -1);

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if ($submit_action == "Update")
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
	else
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/site_preview.css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////////////////
	// Add custom styles to CKEditor style list. ///////////
	if ($submit_action == "Update")	// Do only if really committing to saving styles.
	{
		// Build string for fckstyles.xml file /////
		include("build_jason_style_string.php");
		
		// Rename styles.js file for backup
		$file_name = $document_root . "/ckeditor/styles.js";
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
		$result = (fputs($fh, $jason_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
	}	
?>
