<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 3/29/2017	ELL
// 
	include_once ("check_session.php");

	$query_custom_fonts = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts WHERE (src IS NOT NULL) AND (src <> '')";
	$result_custom_fonts = $bwb_dbh->query($query_custom_fonts);
	
	$css_string = "";
	while ($row_custom_fonts = $result_custom_fonts->fetch(PDO::FETCH_ASSOC))
	{
		$font = $row_custom_fonts['font'];
		$src = $row_custom_fonts['src'];
		$weight = $row_custom_fonts['weight'];
		$style = $row_custom_fonts['style'];
		$stretch = $row_custom_fonts['stretch'];
		
		$css_string .= "@font-face {\n    font-family: " . $font . ";\n";
		if (strpos($src, "'") === false)
			$css_string .= "    src: url('" . $src . "');\n";
		else
			$css_string .= "    src: url(" . $src . ");\n";
		if (isset($weight) && ($weight != ""))
			$css_string .= "	font-weight: " . $weight . ";\n";
		if (isset($style) && ($style != ""))
			$css_string .= "	font-style: " . $style . ";\n";
		if (isset($stretch) && ($stretch != ""))
			$css_string .= "	font-stretch: " . $stretch . ";\n";
		$css_string .= "}\n\n";
	}
	
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/fonts.css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);

?>