/////////////////////////////////////////////
// Mail Contact Form /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/12/2017	ELL
//
function ReadGetVar(variable)
{
	var query = window.location.search.substring(1);
	var vars = query.split("&");
	for (var i=0;i<vars.length;i++) {
	   var pair = vars[i].split("=");
	   if(pair[0] == variable)	{
		   return pair[1];
	   }
	}
	return("");
}

function replaceAll(txt, search_str, replace_str) {
	return txt.replace(new RegExp(search_str, 'g'),replace_str);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function ElExists(el)
{
	if ((document.getElementById(el) != null) && (typeof document.getElementById(el) != "undefined"))
		return true;
	else
		return false;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowPasswordReset()
{ 
	document.getElementById("reset_password_form").style.display="inline";
	
	if ((document.getElementById("captcha_type").value == "recaptcha") && (document.getElementById("use_captcha").value == 1))
	{
		var captcha_challange_url = "http://www.google.com/recaptcha/api/challenge?k=" + recaptcha_public_key;
		var oldScript = document.getElementById("recaptcha_script");
		var script = document.createElement("tmp");        
		script.setAttribute("type","text/javascript");                
		script.setAttribute("id","recaptcha_script");
		script.setAttribute("src",captcha_challange_url);
		
		if (oldScript == null) {               
			document.body.appendChild(script);
		} else {
			document.body.replaceChild(script, oldScript);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////
function InitializeForm()
{ 
	if (ElExists('submit_btn'))
		document.getElementById("submit_btn").style.display = "none";
		
	if (ElExists('form_div_btn'))
		document.getElementById("form_div_btn").style.display = "inline-block";
		
	if (ElExists('create_acct_div_button'))
		document.getElementById("create_acct_div_button").style.display = "inline-block";
		
	var php_path_rel = php_dir_rel + "formmail.php";
	if ((login_required === false) || (logged_in === true))	{
		if (ElExists('frmMailForm'))	{
			if (document.getElementById("frmMailForm").action == "")
				document.getElementById("frmMailForm").action = php_path_rel;
		}
	}
	if (ElExists('frmAccountCreateForm'))	{
		if (document.getElementById("frmAccountCreateForm").action == "")
			document.getElementById("frmAccountCreateForm").action = php_path_rel;
	}
	
	var redirect_path = document.getElementById("redirect").value;
	if (redirect_path == "")
		redirect_path = redirect;
	var redirect_path_arr = redirect_path.split("/");
	var redirect_file = "";
	for(var i in redirect_path_arr)
	{
		if ((redirect_path_arr[i].indexOf(".php")) > 0)
			redirect_file = redirect_path_arr[i];
	}
	redirect_path = webpage_dir + redirect_file;
	document.getElementById("redirect").value = redirect_path;
	
	var alt_go_back = webpage_dir + this_page;
	if (document.getElementById("alt_go_back").value == "")
		document.getElementById("alt_go_back").value = alt_go_back;
		
	if (ElExists('recaptcha_row'))
		document.getElementById("recaptcha_row").style.display = "none";
	if (ElExists('recaptcha2_row'))
		document.getElementById("recaptcha2_row").style.display = "none";
	if (ElExists('wscaptcha_row'))
		document.getElementById("wscaptcha_row").style.display = "none";
	if (ElExists('mollomcaptcha_row'))
		document.getElementById("mollomcaptcha_row").style.display = "none";
	if (document.getElementById("use_captcha").value == 1)
	{
		var element_type;
		if ((document.getElementById("captcha_type").value == "recaptcha") && ElExists('recaptcha_row'))	{
			element_type = document.getElementById("recaptcha_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("recaptcha_row").style.display = "table-row";
			else
				document.getElementById("recaptcha_row").style.display = "inline-block";
		}
		else if ((document.getElementById("captcha_type").value == "recaptcha2") && ElExists('recaptcha2_row'))	{
			element_type = document.getElementById("recaptcha2_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("recaptcha2_row").style.display = "table-row";
			else
				document.getElementById("recaptcha2_row").style.display = "inline-block";
		}
		else if ((document.getElementById("captcha_type").value == "wscaptcha") && ElExists('wscaptcha_row'))	{
			element_type = document.getElementById("wscaptcha_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("wscaptcha_row").style.display = "table-row";
			else
				document.getElementById("wscaptcha_row").style.display = "inline-block";
		}
		else if ((document.getElementById("captcha_type").value == "mollom") && ElExists('mollomcaptcha_row'))	{
			element_type = document.getElementById("mollomcaptcha_row").tagName.toLowerCase();
			if (element_type == "tr")
				document.getElementById("mollomcaptcha_row").style.display = "table-row";
			else
				document.getElementById("mollomcaptcha_row").style.display = "inline-block";
		}
	}
	
	// Go thru all forms and get all elements and check for go-back values to re-populate.
	var frm_cnt = document.forms.length;
	var el_cnt = 0;
	var el;
	var tmp;
	for (i = 0; i < frm_cnt; i++)
	{
		el_cnt = document.forms[i].elements.length;
		for (j = 0; j < el_cnt; j++)
		{
			el = document.forms[i].elements[j];
			if (el.type == "text")	{
				tmp = ReadGetVar(el.name);
				if (tmp != "")
					el.value = replaceAll(tmp, "%20", " ");
				// Special patch for email_confirm.
				if (el.name == "email_confirm")	{
					var tmperr = ReadGetVar("err");
					if(tmperr != "email")	{
						tmp = ReadGetVar("email");
						if (tmp != "")
							el.value = replaceAll(tmp, "%20", "");
					}
				}
				// Special patch for password_confirm
				if (el.name == "password_confirm")	{
					var tmperr = ReadGetVar("err");
					if(tmperr != "no_match")	{
						tmp = ReadGetVar("password");
						if (tmp != "")
							el.value = tmp;
					}
				}
			}
			else if (el.type == "textarea")	{
				tmp = ReadGetVar(el.name);
				if (tmp != "")
					el.innerHTML = replaceAll(tmp, "%20", " ");
			}
			else if (el.type == "checkbox")	{
				if (ReadGetVar(el.name) != "")
					el.checked = true;
			}
			else if (el.type == "radio")	{
				tmp = ReadGetVar(el.name);
				if (ReadGetVar(el.name) != ""){
                    if (el.value == tmp)
					  el.checked = true;
                }
			}
			else if ((el.type == "select-one") || (el.type == "select-multiple"))	{
				tmp = ReadGetVar(el.name);
				if (tmp != "")
					el.value = replaceAll(tmp, "%20", " ");
			}
		}
	}
	
	///////////////////////////////////////////////////
	// Set class on required fields to .required_field
	var required_fields_str = document.getElementById("required_fields").value;
	var required_fields = required_fields_str.split(",");
	var field_name;
	for (i = 0; i < required_fields.length; i++)
	{
		field_name = required_fields[i].trim();
		if (field_name != "")	{
			if (ElExists(field_name))
				document.getElementById(field_name).className = document.getElementById(field_name).className + " required_field";
			else if ((document.getElementsByName(field_name) != null) && (typeof document.getElementsByName(field_name) != "undefined"))	{
				if ((document.getElementsByName(field_name).item(0).type != null) && (typeof document.getElementsByName(field_name).item(0).type != "undefined") && (document.getElementsByName(field_name).item(0).type == "radio"))	{
					if (ElExists(field_name + "_div"))
						document.getElementById(field_name + "_div").className = document.getElementById(field_name + "_div").className + " required_field";
				}
			}

			if (ElExists(field_name))	{
				if ((document.getElementById(field_name).type != null) && (typeof document.getElementById(field_name).type != "undefined") && (document.getElementById(field_name).type == "checkbox"))	{
					if (ElExists(field_name + "_div"))
						document.getElementById(field_name + "_div").className = document.getElementById(field_name + "_div").className + " required_field";
				}
			}
		}
	}
	if (ElExists("email_required") && (document.getElementById("email_required").value == 1))	{
		if (ElExists('email'))
			document.getElementById("email").className = document.getElementById("email").className + " required_field";
		if (ElExists('email_confirm'))
			document.getElementById("email_confirm").className = document.getElementById("email_confirm").className + " required_field";
	}
	if (ElExists("password_required") && (document.getElementById("password_required").value == 1))	{
		if (ElExists('password'))
			document.getElementById("password").className = document.getElementById("password").className + " required_field";
		if (ElExists('password_confirm'))
			document.getElementById("password_confirm").className = document.getElementById("password_confirm").className + " required_field";
	}
	
	// Hide all reqired marks (not needed if JavaScript is running).
	var elems = document.getElementsByTagName('*');
	var matchClass = "required_mark"
	for (i in elems) {
		if((' ' + elems[i].className + ' ').indexOf(' ' + matchClass + ' ') > -1) {
			elems[i].style.display = "none";
		}
		if((' ' + elems[i].className + ' ').indexOf(' required_box ') > -1) {
			elems[i].style.visibility = "visible";
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////////////
	var err = ReadGetVar("err");
	var field;
	var class_name;

	if ((typeof err != "undefined") && (err != ""))
	{
		if (err == "required")	{
			document.getElementById("ErrRequired").style.display = "block";
			field = ReadGetVar("field");
			document.getElementById(field).focus();
			class_name = document.getElementById(field).className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById(field).className = class_name + " field_highlight";
		}
		else if (err == "too_short")	{
			var password_length = ReadGetVar("password_length");
			if (ElExists("password_length_msg"))
				document.getElementById("password_length_msg").innerHTML = password_length;
			document.getElementById("ErrTooShort").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
		}
		else if (err == "too_weak") {
			var password_strength = ReadGetVar("password_strength");
			if (ElExists("password_strength_msg"))	{
				if (password_strength == "medium")
					document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning both letters and numbers.";
				else if (password_strength == "strong")
					document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning letters, numbers and symbols.";
			}
			document.getElementById("ErrTooWeak").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
		}
		else if (err == "no_match")	{
			document.getElementById("ErrNoMatch").style.display = "block";
			document.getElementById("password").focus();
			class_name = document.getElementById("password").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
			document.getElementById("password_confirm").className = class_name + " field_highlight";
		}
		else if(err == "email")	{
			document.getElementById("ErrEmail").style.display="block";
			document.getElementById("email").focus();
			class_name = document.getElementById("email").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email").className = class_name + " field_highlight";
			document.getElementById("email_confirm").className = class_name + " field_highlight";
		}
		else if(err == "bad_email")	{
			document.getElementById("ErrBadEmail").style.display="block";
			document.getElementById("email").focus();
			class_name = document.getElementById("email").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email").className = class_name + " field_highlight";
		}
		else if(err == "duplicate")	{
			document.getElementById("ErrDuplicate").style.display="block";
			field = ReadGetVar("field");
			document.getElementById(field).focus();
			class_name = document.getElementById(field).className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById(field).className = class_name + " field_highlight";
		}
		else if(err == "captcha")	{
			document.getElementById("ErrCaptcha").style.display="block";
			var captcha_type = document.getElementById("captcha_type").value;
			if (captcha_type == "recaptcha")
				document.getElementById("recaptcha_td").className = "field_highlight";
			else  if (captcha_type == "recaptcha2")
				document.getElementById("recaptcha2_td").className = "field_highlight";
			else if (captcha_type == "wscaptcha")
				document.getElementById("wsp_code").className = "field_highlight";
			else if (captcha_type == "mollom")
				document.getElementById("captcha_response_field").className = "field_highlight";
		}
		else if(err == "file_size")	{
			document.getElementById("ErrFileSize").style.display="block";
			document.getElementById("upload_file").focus();
			class_name = document.getElementById("upload_file").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("upload_file").className = class_name + " field_highlight";
		}
		else if(err == "file_type")	{
			document.getElementById("ErrFileType").style.display="block";
			document.getElementById("upload_file").focus();
			class_name = document.getElementById("upload_file").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("upload_file").className = class_name + " field_highlight";
		}
		else if(err == "upload")	{
			document.getElementById("ErrUpload").style.display="block";
			document.getElementById("upload_file").focus();
			class_name = document.getElementById("upload_file").className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("upload_file").className = class_name + " field_highlight";
		}
		else if(err == "bad_phone")	{
			document.getElementById("ErrPhone").style.display="block";
			field = ReadGetVar("field");
			class_name = document.getElementById(field).className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById(field).className = class_name + " field_highlight";
		}
		else if(err == "img_resize")	{
			document.getElementById("ErrImgResize").style.display="block";
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
function CheckForm()
{
	if (ElExists('required_fields'))
	{
		var required_fields_str = document.getElementById("required_fields").value;
		var required_fields = required_fields_str.split(",");
		var field_name;
		var OKtoSend = true;
		var el;
		var class_name;
		var radio_checked;
		document.getElementById("ErrRequired").style.display = "none";
		document.getElementById("ErrEmailBlank").style.display = "none";
		document.getElementById("ErrEmailNoMatch").style.display = "none";
		if (ElExists('ErrPassBlank'))
			document.getElementById("ErrPassBlank").style.display = "none";
		if (ElExists('ErrPassNoMatch'))
			document.getElementById("ErrPassNoMatch").style.display = "none";
		if (ElExists('ErrTooShort'))
			document.getElementById("ErrTooShort").style.display = "none";
		if (ElExists('ErrTooWeak'))
			document.getElementById("ErrTooWeak").style.display = "none";
		for (var i = 0; i < required_fields.length; i++)
		{
			field_name = required_fields[i].trim();
			if (field_name != "")	{
				el = document.getElementById(field_name);
				
				if ((el == null) || (typeof el == "undefined"))	// If radio botton group, select first element by name instead.
					el = document.getElementsByName(field_name).item(0);
	
				if (((el.type == "text") || (el.type == "textarea") || (el.type == "select-one") || (el.type == "select-multiple")) && ((el.value == "") || (el.value == "-not selected-")))
					OKtoSend = false;
				else if (el.type == "radio")	{
					radio_checked = false;
					el = document.getElementById(field_name + "_div");	// Set element back to radio group div.
					for (var j = 0; j < document.getElementsByName(field_name).length; j++)
					{
						if (document.getElementsByName(field_name).item(j).checked == true)
							radio_checked = true;
					}
					if (!radio_checked)
						OKtoSend = false;
				}
				else if ((el.type == "checkbox") && (el.checked == false))	{
					OKtoSend = false;
					class_name = document.getElementById(field_name + "_div").className;
					class_name = class_name.replace(" required_field", "");
					document.getElementById(field_name + "_div").className = class_name + " field_highlight";
				}
				else	{	// Clear previous highlights.
					class_name = el.className;
					class_name = class_name.replace(" field_highlight", "");
					el.className = class_name + " required_field";
				}
	
				if (!OKtoSend)	{
					class_name = el.className;
					class_name = class_name.replace(" required_field", "");
					el.className = class_name + " field_highlight";
					el.focus();
				}
			}
		}
		if (!OKtoSend)
			document.getElementById("ErrRequired").style.display = "block";
	}

	if (ElExists('email_required') && (document.getElementById("email_required").value == 1))	{
		if (ElExists('email') && ((document.getElementById('email').value == "") || (document.getElementById('email').value != document.getElementById('email_confirm').value)))	{
			class_name = document.getElementById('email').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email").className = class_name + " field_highlight";
			if (document.getElementById('email').value == "")
				document.getElementById("ErrEmailBlank").style.display = "block";
			else
				document.getElementById("ErrEmailNoMatch").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("email").focus();
				OKtoSend = false;
			}
		}
		else if (ElExists('email'))	{	// Clear previous highlights.
			class_name = document.getElementById("email").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("email").className = class_name + " required_field";
		}
		if (ElExists('email_confirm') && ((document.getElementById('email_confirm').value == "") || (document.getElementById('email').value != document.getElementById('email_confirm').value)))	{
			class_name = document.getElementById('email_confirm').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("email_confirm").className = class_name + " field_highlight";
			if (document.getElementById('email_confirm').value == "")
				document.getElementById("ErrEmailBlank").style.display = "block";
			else
				document.getElementById("ErrEmailNoMatch").style.display = "block";
			OKtoSend = false;
		}
		else if (ElExists('email_confirm'))	{	// Clear previous highlights.
			class_name = document.getElementById("email_confirm").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("email_confirm").className = class_name + " required_field";
		}
	}
	
	if (ElExists('password_required') && (document.getElementById("password_required").value == 1))	{
		if (ElExists('password') && ((document.getElementById('password').value == "") || (document.getElementById('password').value != document.getElementById('password_confirm').value)))	{
			class_name = document.getElementById('password').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password").className = class_name + " field_highlight";
			if (document.getElementById('password').value == "")
				document.getElementById("ErrPassBlank").style.display = "block";
			else
				document.getElementById("ErrPassNoMatch").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
		else if (ElExists('password'))	{	// Clear previous highlights.
				class_name = document.getElementById("password").className;
				class_name = class_name.replace(" field_highlight", "");
				document.getElementById("password").className = class_name + " required_field";
			}
		if (ElExists('password_confirm') && ((document.getElementById('password_confirm').value == "") || (document.getElementById('password').value != document.getElementById('password_confirm').value)))	{
			class_name = document.getElementById('password_confirm').className;
			class_name = class_name.replace(" required_field", "");
			document.getElementById("password_confirm").className = class_name + " field_highlight";
			if (document.getElementById('password').value == "")
				document.getElementById("ErrPassBlank").style.display = "block";
			else
				document.getElementById("ErrPassNoMatch").style.display = "block";
			OKtoSend = false;
		}
		else if (ElExists('password_confirm'))	{	// Clear previous highlights.
			class_name = document.getElementById("password_confirm").className;
			class_name = class_name.replace(" field_highlight", "");
			document.getElementById("password_confirm").className = class_name + " required_field";
		}
	}
	
	if ((ElExists('password_length')) && (document.getElementById('password_length').value > 0) && (document.getElementById('password').value != ""))
	{
		class_name = document.getElementById('password').className;
		var password_length = document.getElementById('password_length').value;
		if (document.getElementById('password').value.length < password_length)	{
			if (class_name.indexOf("field_highlight") < 0)	{
				class_name = class_name.replace(" required_field", "");
				document.getElementById("password").className = class_name + " field_highlight";
				if (ElExists("password_confirm"))
					document.getElementById("password_confirm").className = class_name + " field_highlight";
			}
			if (ElExists("password_length_msg"))
				document.getElementById("password_length_msg").innerHTML = password_length;
			document.getElementById("ErrTooShort").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
	}

	if ((ElExists('password_strength')) && (document.getElementById('password_strength').value != "") && (document.getElementById('password').value != ""))
	{
		class_name = document.getElementById('password').className;
		
		var password_strength = document.getElementById('password_strength').value;
		if (ElExists("password_strength_msg"))	{
			if (password_strength == "medium")
				document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning both letters and numbers.";
			else if (password_strength == "strong")
				document.getElementById("password_strength_msg").innerHTML = "Please fill in a password contaning letters, numbers and symbols.";
		}

		if (((document.getElementById('password').value.match(/(?:[A-Za-z].*?\d|\d.*?[A-Za-z])/) == null) && (password_strength == "medium")) || ((document.getElementById('password').value.match(/(?=.*\d)(?=.*[a-zA-Z])(?=.*\W)/) == null) && (password_strength == "strong")))	{
			if  (class_name.indexOf("field_highlight") < 0)	{
				class_name = class_name.replace(" required_field", "");
				document.getElementById("password").className = class_name + " field_highlight";
				if (ElExists("password_confirm"))
					document.getElementById("password_confirm").className = class_name + " field_highlight";
			}
			document.getElementById("ErrTooWeak").style.display = "block";
			if (OKtoSend)	{
				document.getElementById("password").focus();
				OKtoSend = false;
			}
		}
	}
		
	return OKtoSend;
}

function SubmitForm(frmID)
{
	if (CheckForm())
		document.getElementById(frmID).submit();
}