CREATE TABLE `bwb_version` (
`version` VARCHAR( 32 ) NOT NULL ,
PRIMARY KEY ( `version` )
) ENGINE = MYISAM ;

INSERT INTO `bwb_version` (`version`) VALUES ('6.6.18');


CREATE TABLE IF NOT EXISTS `bwb_access_levels` (
  `access_level` varchar(64) NOT NULL,
  PRIMARY KEY  (`access_level`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_access_levels` (`access_level`) VALUES
('admin'),
('power_user'),
('restricted'),
('user');


CREATE TABLE IF NOT EXISTS `bwb_blogs` (
  `id` bigint(20) NOT NULL auto_increment,
  `post` longtext,
  `page_name` varchar(255) NOT NULL,
  `owner` varchar(255) NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_blogs_bkup` (
  `ID` bigint(20) NOT NULL auto_increment,
  `blog_id` bigint(20) NOT NULL,
  `page_name` varchar(255) NULL default NULL,
  `post` longtext NULL default NULL,
  `owner` varchar(255)  NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` datetime  NULL default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_blogs_draft` (
  `id` bigint(20) NOT NULL auto_increment,
  `blog_id` bigint(20) NOT NULL,
  `post` longtext NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_captcha` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `challenge` varchar(255) NOT NULL,
  `response` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=96 ;

INSERT INTO `bwb_captcha` (`id`, `challenge`, `response`) VALUES
(7, 'captcha1.png', 'KY5Y'),
(8, 'captcha2.png', 'thtmxs'),
(9, 'captcha3.png', '12444'),
(10, 'captcha4.png', 'gousme'),
(11, 'captcha5.png', 'methro'),
(12, 'captcha6.png', '8AJPRPHV'),
(13, 'captcha7.png', '7W3I'),
(14, 'captcha8.png', 'Pne6F'),
(15, 'captcha9.png', '8BVM'),
(16, 'captcha10.png', 'PhfK8'),
(17, 'captcha11.png', '0K9XB'),
(18, 'captcha12.png', '28iVW'),
(19, 'captcha13.png', 'k4ez'),
(20, 'captcha14.png', 'jw62k'),
(21, 'captcha15.png', 'FH2DE'),
(22, 'captcha16.png', 'gwprp'),
(23, 'captcha17.png', '4D7YS'),
(24, 'captcha18.png', 'e5hb'),
(25, 'captcha19.png', 'xmqki'),
(26, 'captcha20.png', '6ne3'),
(27, 'captcha21.png', 'XDHYN'),
(28, 'captcha22.png', 'q98p'),
(29, 'captcha23.png', 'HRAI'),
(30, 'captcha24.png', '4R3A'),
(31, 'captcha25.png', 'ZYPEB'),
(32, 'captcha26.png', 'N65X'),
(33, 'captcha27.png', 'DYZB2'),
(34, 'captcha28.png', '4ZUDA'),
(35, 'captcha29.png', '243424'),
(36, 'captcha30.png', 'DOGY'),
(37, 'captcha31.png', 'TICA'),
(38, 'captcha32.png', 'AKOF'),
(39, 'captcha33.png', 'IXYCO'),
(40, 'captcha34.png', 'Ministry'),
(41, 'captcha35.png', 'Tried'),
(42, 'captcha36.png', 'ZSf69'),
(43, 'captcha37.png', 'CS6T5'),
(44, 'captcha38.png', 'SXGPT'),
(45, 'captcha39.png', '5GC6R'),
(46, 'captcha40.png', '5S4UG'),
(47, 'captcha41.png', 'RJ28Q'),
(48, 'captcha42.png', '4P3X4'),
(49, 'captcha43.png', 'NOW'),
(50, 'captcha44.png', 'lengrat&'),
(51, 'captcha45.png', 'ideas'),
(52, 'captcha46.png', 'is easy'),
(53, 'captcha47.png', 'just'),
(54, 'captcha48.png', 'use'),
(55, 'captcha49.png', 'Captcha'),
(56, 'captcha50.png', 'Code'),
(57, 'captcha51.png', 'fhrc'),
(58, 'captcha52.png', 'cralsist'),
(59, 'captcha53.png', 'unrexc'),
(60, 'captcha54.png', 'vohte'),
(61, 'captcha55.png', 'dutne'),
(62, 'captcha56.png', 'sondted'),
(63, 'captcha57.png', 'pliaom'),
(64, 'captcha58.png', 'unbadnar'),
(65, 'captcha59.png', 'aphxleci'),
(66, 'captcha60.png', 'tegunt'),
(67, 'captcha61.png', 'ejuje'),
(68, 'captcha62.png', 'unnedou'),
(69, 'captcha63.png', 'vedsho'),
(70, 'captcha64.png', 'trapperb'),
(71, 'captcha65.png', 'wans'),
(72, 'captcha66.png', 'py8894'),
(73, 'captcha67.png', '4TEF'),
(74, 'captcha68.png', 'leopard'),
(75, 'captcha69.png', 'Marks'),
(76, 'captcha70.png', 'nsuldGW'),
(77, 'captcha71.png', 'natural'),
(78, 'captcha72.png', 'Brook'),
(79, 'captcha73.png', 'Reports'),
(80, 'captcha74.png', 'overlooks'),
(81, 'captcha75.png', 'inquiry'),
(82, 'captcha76.png', 'storsce'),
(83, 'captcha77.png', 'Theretr'),
(84, 'captcha78.png', 'them'),
(85, 'captcha79.png', 'urethras'),
(86, 'captcha80.png', 'Mr blocked'),
(88, 'captcha82.png', 'rehiring it'),
(89, 'captcha83.png', 'G5RRP'),
(90, 'captcha84.png', 'KK3J6'),
(91, 'captcha85.png', 'F64FE'),
(92, 'captcha86.png', 'BSXJY'),
(93, 'captcha87.png', 'WZHWR'),
(94, 'captcha88.png', 'VHMB2'),
(95, 'captcha89.png', 'polthed'),
(96, 'captcha11.png', '9K9XB'),
(97, 'captcha11.png', 'QK9XB'),
(98, 'captcha8.png', 'PNe6f'),
(99, 'captcha10.png', 'Phfk8'),
(100, 'captcha10.png', 'phfK8'),
(101, 'captcha10.png', 'phfk8'),
(102, 'captcha12.png', '28ivw'),
(103, 'captcha14.png', 'jw62K'),
(104, 'captcha19.png', 'xmqKi'),
(105, 'captcha19.png', 'xmgki'),
(106, 'captcha19.png', 'xmgKi'),
(107, 'captcha28.png', 'AZUDA'),
(108, 'captcha36.png', 'zsf69'),
(109, 'captcha44.png', 'lencrat&'),
(110, 'captcha44.png', 'lenerat&'),
(111, 'captcha48.png', 'usa'),
(112, 'captcha51.png', 'flirc'),
(113, 'captcha54.png', 'valite'),
(114, 'captcha55.png', 'dultne'),
(115, 'captcha56.png', 'sonated'),
(116, 'captcha57.png', 'plicrom'),
(117, 'captcha58.png', 'unbachar'),
(118, 'captcha61.png', 'ejujle'),
(119, 'captcha65.png', 'wrans'),
(120, 'captcha76.png', 'Storsce'),
(121, 'captcha10.png', 'PhfKB'),
(122, 'captcha10.png', 'PhfkB'),
(123, 'captcha10.png', 'phfKB'),
(124, 'captcha10.png', 'phfkB');


CREATE TABLE `bwb_custom_site_css` (
  `name` varchar(64) NOT NULL default '',
  `custom_css` longtext NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  (`name`)
) ;


CREATE TABLE IF NOT EXISTS `bwb_fonts` (
  `font` varchar(255) NOT NULL default '',
  `websafe` tinyint(4) NOT NULL default '0',
  `src` varchar(255) NOT NULL default '',
  `stretch` VARCHAR( 32 ) NULL default NULL,
  `style` VARCHAR( 16 ) NULL default NULL,
  `weight` VARCHAR( 16 ) NULL default NULL,
  PRIMARY KEY  (`font`, `src`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_fonts` (`font`, `websafe`, `src`, `stretch`, `style`, `weight`) VALUES
('Alba', 0, '/fonts/ALBA.TTF', '', '', ''),
('Algerian', 0, '/fonts/ALGER.TTF', '', '', ''),
('Arial', 1, '', NULL, NULL, NULL),
('Arial Rounded', 0, '/fonts/unicode.arialr.ttf', '', '', ''),
('Bangle', 0, '/fonts/Bangle.ttf', '', '', ''),
('Baskerville Old Face', 0, '/fonts/BASKVILL.TTF', '', '', ''),
('Britannic Bold', 0, '/fonts/BRITANIC.TTF', '', '', ''),
('Broadway', 0, '/fonts/BROADW.TTF', '', '', ''),
('Comic Sans MS', 1, '', NULL, NULL, NULL),
('Edwardian Alternate', 0, '/fonts/EdwardianAlternateBold.ttf', '', '', ''),
('Geneva', 0, '/fonts/GENEVA.ttf', '', '', ''),
('Helvetica', 1, '', NULL, NULL, NULL),
('Tahoma', 1, '', NULL, NULL, NULL),
('Vivaldi', 0, '/fonts/VIVALDII.TTF', '', '', ''),
('Times New Roman', 1, '', NULL, NULL, NULL),
('Verdana', 1, '', NULL, NULL, NULL),
('Open Sans', 0, 'https://fonts.googleapis.com/css?family=Open+Sans', '', '', ''),
('Garamond', 0, '/fonts/GARA.TTF', '', '', ''),
('Bradley Hand', 0, '/fonts/BradleysPen.ttf', '', '', ''),
('Brush Script', 0, '/fonts/BrushScript.ttf', '', '', ''),
('BRADDON', 0, '/fonts/BRADDON Regular.ttf', '', '', ''),
('Amaze', 0, '/fonts/AMAZR___.TTF', '', '', ''),
('Bookman', 0, '/fonts/Bookman.ttf', '', '', ''),
('Century Gothic', 0, '/fonts/GOTHIC.TTF', '', '', ''),
('Cooper Black', 0, '/fonts/COOPBL.TTF', '', '', ''),
('Courier New', 1, '', NULL, NULL, NULL),
('Engravers Becker', 0, '/fonts/engravers_becker.ttf', '', '', ''),
('Franklin Gothic Book', 0, '/fonts/FRABK.TTF', '', '', ''),
('Georgia', 1, '', NULL, NULL, NULL),
('sans-serif', 1, '', NULL, NULL, NULL),
('serif', 1, '', NULL, NULL, NULL),
('monospace', 1, '', NULL, NULL, NULL),
('cursive', 1, '', NULL, NULL, NULL),
('fantasy', 1, '', NULL, NULL, NULL),
('Trebuchet MS', 1, '', NULL, NULL, NULL),
('Lucida Sans', 1, '', NULL, NULL, NULL),
('Arial Black', 1, '', NULL, NULL, NULL),
('Courier', 1, '', NULL, NULL, NULL),
('Impact', 1, '', NULL, NULL, NULL),
('Charcoal', 1, '', NULL, NULL, NULL),
('Lucida Console', 1, '', NULL, NULL, NULL),
('Monaco', 1, '', NULL, NULL, NULL),
('Lucida Sans Unicode', 1, '', NULL, NULL, NULL),
('Lucida Grande', 1, '', NULL, NULL, NULL),
('Palatino Linotype', 1, '', NULL, NULL, NULL),
('Book Antiqua', 1, '', NULL, NULL, NULL),
('Palatino', 1, '', NULL, NULL, NULL),
('Symbol', 1, '', NULL, NULL, NULL),
('Webdings', 1, '', NULL, NULL, NULL),
('Wingdings', 1, '', NULL, NULL, NULL),
('Zapf Dingbats', 1, '', NULL, NULL, NULL),
('New York', 1, '', NULL, NULL, NULL),
('MS Serif', 1, '', NULL, NULL, NULL),
('Agency FB Cyrillic', 0, '/fonts/taxX50l4.ttf', '', '', ''),
('Rhino Forte', 0, '/fonts/RhinoForte.ttf', '', '', ''),
('Lucida Calligraphy', 0, '/fonts/lcallig.ttf', '', '', ''),
('Lucida Handwriting', 0, '/fonts/lhandw.ttf', '', '', ''),
('Magneto', 0, '/fonts/MAGNETOB.TTF', '', '', ''),
('Mistral', 0, '/fonts/MISTRAL.TTF', '', '', ''),
('Short Hand', 0, '/fonts/shorhn.ttf', '', '', ''),
('Stencil', 0, '/fonts/STENCIL.TTF', '', '', ''),
('Westminster', 0, '/fonts/WESTM.TTF', '', '', ''),
('Berlin Sans FB', 0, '/fonts/brlnsr.ttf', '', '', ''),
('BalloonEFDropShadow', 0, '/fonts/balloon_becker_drop_shadow.ttf', '', '', ''),
('Pussycat', 0, '/fonts/PUSSSA.ttf', '', '', ''),
('Rye', 0, '/fonts/Rye-Regular.ttf', '', '', ''),
('Calibri', 0, '/fonts/calibri.ttf', '', '', ''),
('Ravie', 0, '/fonts/RAVIE.TTF', '', '', ''),
('Helvetica Neue', 0, '/fonts/HelveticaNeue.ttf', '', '', ''),
('Helvetica Neue', 0, '/fonts/HelveticaNeueBold.ttf', '', '', 'bold'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueBoldItalic.ttf', '', 'italic', 'bold'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueCondensedBlack.ttf', 'condensed', '', ''),
('Helvetica Neue', 0, '/fonts/HelveticaNeueCondensedBold.ttf', 'condensed', '', 'bold'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueItalic.ttf', '', 'italic', ''),
('Helvetica Neue', 0, '/fonts/HelveticaNeueLight.ttf', '', '', '200'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueLightItalic.ttf', '', 'italic', '200'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueMedium.ttf', '', '', '500'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueUltraLight.ttf', '', '', '100'),
('Helvetica Neue', 0, '/fonts/HelveticaNeueUltraLightItalic.ttf', '', 'italic', '100'),
('Myriad Web Pro', 0, '/fonts/myriad_web_pro.ttf', '', '', ''),
('Myriad Web Pro', 0, '/fonts/myriad_web_pro_bold.ttf', '', '', 'bold'),
('Myriad Web Pro', 0, '/fonts/myriad_web_pro_italic.ttf', '', 'italic', ''),
('Myriad Web Pro', 0, '/fonts/myriad_pro_bold_italic.ttf', '', 'italic', 'bold'),
('Charcoal', 0, '/fonts/charcoal.ttf', '', '', ''),
('Raleway', 0, 'https://fonts.googleapis.com/css?family=Raleway', '', '', ''),
('Yatra One', 0, 'https://fonts.googleapis.com/css?family=Yatra+One', '', '', ''),
('Ubuntu', 0, '/fonts/Ubuntu-B.ttf', '', '', 'bold'),
('Ubuntu', 0, '/fonts/Ubuntu-BI.ttf', '', 'italic', 'bold'),
('Ubuntu', 0, '/fonts/Ubuntu-C.ttf', 'condensed', '', ''),
('Ubuntu', 0, '/fonts/Ubuntu-L.ttf', '', '', '100'),
('Ubuntu', 0, '/fonts/Ubuntu-LI.ttf', '', 'italic', '100'),
('Ubuntu', 0, '/fonts/Ubuntu-M.ttf', '', '', '500'),
('Ubuntu', 0, '/fonts/Ubuntu-MI.ttf', '', 'italic', '500'),
('Ubuntu Monospace', 0, '/fonts/UbuntuMono-B.ttf', '', '', 'bold'),
('Ubuntu Monospace', 0, '/fonts/UbuntuMono-BI.ttf', '', 'italic', 'bold'),
('Ubuntu Monospace', 0, '/fonts/UbuntuMono-R.ttf', '', '', ''),
('Ubuntu Monospace', 0, '/fonts/UbuntuMono-RI.ttf', '', 'italic', ''),
('Ubuntu', 0, '/fonts/Ubuntu-R.ttf', '', '', ''),
('Ubuntu', 0, '/fonts/Ubuntu-RI.ttf', '', 'italic', ''),
('Yellowtail', 0, 'https://fonts.googleapis.com/css?family=Yellowtail', '', '', ''),
('Pacifico', 0, 'https://fonts.googleapis.com/css?family=Pacifico', '', '', ''),
('Condiment', 0, 'https://fonts.googleapis.com/css?family=Condiment', '', '', ''),
('Helvetica Neue Light', 0, '/fonts/HelveticaNeueLight.ttf', '', '', ''),
('Helvetica Neue Bold', 0, '/fonts/HelveticaNeueBold.ttf', '', '', ''),
('Titillium Web', 0, 'https://fonts.googleapis.com/css?family=Titillium+Web', '', '', ''),
('Bookman', 0, '/fonts/BookmanBold.ttf', '', '', 'bold'),
('Bookman', 0, '/fonts/BookmanItalic.ttf', '', 'italic', ''),
('Bookman', 0, '/fonts/BookmanBoldItalic.ttf', '', 'italic', 'bold'),
('Garamond', 0, '/fonts/GARABD.TTF', '', '', 'bold'),
('Garamond', 0, '/fonts/GARAIT.TTF', '', 'italic', ''),
('Franklin Gothic Book', 0, '/fonts/FRABKIT.TTF', '', 'italic', ''),
('Calibri', 0, '/fonts/calibrib.ttf', '', '', 'bold'),
('Calibri', 0, '/fonts/calibrii.ttf', '', 'italic', ''),
('Calibri', 0, '/fonts/calibriz.ttf', '', 'italic', 'bold'),
('Amaze', 0, '/fonts/AMAZB___.TTF', '', '', 'bold'),
('Amaze', 0, '/fonts/Amaze.ttf', '', 'italic', ''),
('Bangle', 0, '/fonts/BANGB___.TTF', '', '', 'bold'),
('Bangle', 0, '/fonts/BANGI___.TTF', '', 'italic', ''),
('Short Hand', 0, '/fonts/SHORHB.ttf', '', '', 'bold'),
('Short Hand', 0, '/fonts/SHORHI.ttf', '', 'italic', ''),
('Geneva', 0, '/fonts/Geneva Bold-Italic.ttf', '', 'italic', 'bold'),
('Geneva', 0, '/fonts/Geneva Normal-Italic.ttf', '', 'italic', ''),
('Berlin Sans FB', 0, '/fonts/brlnsb.ttf', '', '', 'bold'),
('Century Gothic', 0, '/fonts/GOTHICB.TTF', '', '', 'bold'),
('Century Gothic', 0, '/fonts/GOTHICI.TTF', '', 'italic', ''),
('Century Gothic', 0, '/fonts/GOTHICBI.TTF', '', 'italic', 'bold'),
('Satisfy', 0, 'https://fonts.googleapis.com/css?family=Satisfy&display=swap', '', '', ''),
('Nunito Sans', 0, 'https://fonts.googleapis.com/css?family=Nunito+Sans:200,300,400,600,800,900', '', '', ''),
('Arizonia', 0, 'https://fonts.googleapis.com/css?family=Arizonia&display=swap', '', '', ''),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@1,300&display=swap', '', 'italic', '300'),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@300&display=swap', '', '', '300'),
('Tangerine', 0, 'https://fonts.googleapis.com/css2?family=Tangerine:wght@700&display=swap', '', '', 'bold'),
('Tangerine', 0, 'https://fonts.googleapis.com/css2?family=Tangerine&display=swap', '', '', ''),
('Pinyon Script', 0, 'https://fonts.googleapis.com/css2?family=Pinyon+Script&display=swap', '', '', ''),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond&display=swap', '', '', ''),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital@1&display=swap', '', 'italic', ''),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@500&display=swap', '', '', '500'),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@1,500&display=swap', '', 'italic', '500'),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@600&display=swap', '', '', '600'),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@1,600&display=swap', '', 'italic', '600'),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:wght@700&display=swap', '', '', 'bold'),
('Cormorant Garamond', 0, 'https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@1,700&display=swap', '', 'italic', 'bold'),
('Cinzel', 0, 'https://fonts.googleapis.com/css2?family=Cinzel&display=swap', '', '', ''),
('Cinzel Decorative', 0, 'https://fonts.googleapis.com/css2?family=Cinzel+Decorative&display=swap', '', '', ''),
('Cinzel Decorative', 0, 'https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@700&display=swap', '', '', 'bold'),
('Cinzel Decorative', 0, 'https://fonts.googleapis.com/css2?family=Cinzel+Decorative:wght@900&display=swap', '', '', '900'),
('Allura', 0, 'https://fonts.googleapis.com/css2?family=Allura&display=swap', '', '', ''),
('Alex Brush', 0, 'https://fonts.googleapis.com/css2?family=Alex+Brush&display=swap', '', '', '');


CREATE TABLE `bwb_head` (
  `id` int(11) NOT NULL auto_increment,
  `head_name` varchar(255) NULL default NULL,
  `head_content` longtext NULL default NULL,
  `plugins` VARCHAR(64) NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

ALTER TABLE `bwb_head` ADD UNIQUE( `head_name`);

INSERT INTO `bwb_head` (`id`, `head_name`, `head_content`) VALUES
(1, 'head', '<STYLE TYPE=\\"text/css\\">\r\n.pagebreak { page-break-after: always;}\r\n</STYLE>\r\n\r\n');


CREATE TABLE IF NOT EXISTS `bwb_login_attempts` (
  `id` bigint(20) NOT NULL auto_increment,
  `UserID` varchar(50) NOT NULL,
  `IP` varchar(40) NOT NULL,
  `AttemptTimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `Success` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_menus` (
  `menu_name` varchar(64) NOT NULL,
  `description` varchar(255) NULL default NULL,
  `proportional` tinyint(4) NOT NULL default '0',
  `proportional_sub` tinyint(4) NOT NULL default '0',
  `top_down_on_sub_down` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`menu_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_menus` (`menu_name`, `description`, `proportional`, `proportional_sub`, `top_down_on_sub_down`) VALUES
('menu1', 'Menu 1', 0, 0, 0),
('menu1_mobile', 'Menu 1 Mobile', 0, 0, 0),
('menu1_touchscreen', 'Menu 1 Touchscreen', 0, 0, 0),
('menu2', 'Menu 2', 0, 0, 0),
('menu2_mobile', 'Menu 2 Mobile', 0, 0, 0),
('menu2_touchscreen', 'Menu 2 Touchscreen', 0, 0, 0);


CREATE TABLE IF NOT EXISTS `bwb_menu_assignments` (
  `menu_name` varchar(64) NOT NULL,
  `border_area` varchar(64) NOT NULL,
  PRIMARY KEY  (`menu_name`,`border_area`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE `bwb_menu_items` (
  `ID` int(11) NOT NULL auto_increment,
  `menu` varchar(64) NOT NULL default '',
  `item_text` varchar(64) NOT NULL default '',
  `level` int(11) NULL default NULL,
  `URL` varchar(255) NULL default NULL,
  `target` varchar(32) NULL default NULL,
  `name` VARCHAR( 64 ) NULL default NULL,
  `mega_menu` VARCHAR( 255 ) NULL default NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
)  AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_meta_tags` (
  `page_name` varchar(255) NOT NULL default '',
  `owner` varchar(255) NULL default NULL,
  `author` varchar(255) NULL default NULL,
  `lanquage` varchar(255) NULL default NULL,
  `copyright` varchar(255) NULL default NULL,
  `description` longtext NULL default NULL,
  `abstract` longtext NULL default NULL,
  `keywords` longtext NULL default NULL,
  `subject` longtext NULL default NULL,
  `robots_index` tinyint(4) default NULL,
  `robots_follow` tinyint(4) default NULL,
  `robots_revisit` int(11) default NULL,
  PRIMARY KEY  (`page_name`)
) ;

CREATE TABLE `bwb_meta_tags_template` (
  `id` int(11) NOT NULL auto_increment,
  `meta_tags_template` longtext NOT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

INSERT INTO `bwb_meta_tags_template` (`id`, `meta_tags_template`) VALUES
(1, '<?php\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "meta_tags WHERE page_name = ''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$owner = $row["owner"];\r\n		$author = $row["author"];\r\n		$lanquage = $row["lanquage"];\r\n		$copyright = $row["copyright"];\r\n		$description = $row["description"];\r\n		$abstract = $row["abstract"];\r\n		$keywords = $row["keywords"];\r\n		$subject = $row["subject"];\r\n		$robots_index = $row["robots_index"];\r\n		$robots_follow = $row["robots_follow"];\r\n		$robots_revisit = $row["robots_revisit"];\r\n		\r\n		if ($lanquage)\r\n			echo "<META HTTP-EQUIV=\\"LANGUAGE\\" CONTENT=\\"$lanquage\\">\\r\\n";\r\n		if ($owner)\r\n			echo "<meta name=\\"OWNER\\" content=\\"$owner\\">\\r\\n";\r\n		if ($author)\r\n			echo "<META NAME=\\"AUTHOR\\" CONTENT=\\"$author\\">\\r\\n";\r\n			\r\n		if (($robots_index == 1) && ($robots_follow == 1))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"INDEX, FOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 1) && ($robots_follow == 0))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"INDEX, NOFOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 0) && ($robots_follow == 1))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"NOINDEX, FOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 0) && ($robots_follow == 0))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"NOINDEX, NOFOLLOW\\">\\r\\n";\r\n	\r\n		if ($robots_revisit)\r\n			echo "<META NAME=\\"REVISIT-AFTER\\" CONTENT=\\"$robots_revisit days\\">\\r\\n";\r\n		if ($copyright)\r\n			echo "<META NAME=\\"COPYRIGHT\\" CONTENT=\\"$copyright\\">\\r\\n";\r\n		if ($description)\r\n			echo "<META NAME=\\"DESCRIPTION\\" CONTENT=\\"$description\\">\\r\\n";\r\n		if ($abstract)\r\n			echo "<META NAME=\\"ABSTACT\\" CONTENT=\\"$abstract\\">\\r\\n";\r\n		if ($keywords)\r\n			echo "<META NAME=\\"KEYWORDS\\" CONTENT=\\"$keywords\\">\\r\\n";\r\n		if ($subject)\r\n			echo "<META NAME=\\"SUBJECT\\" CONTENT=\\"$subject\\">\\r\\n";\r\n\r\n	}\r\n?>');



CREATE TABLE IF NOT EXISTS `bwb_options` (
  `id` int(11) NOT NULL auto_increment,
  `option_name` varchar(63) NOT NULL default '',
  `option_string` varchar(255) NOT NULL default '',
  `option_string_define` varchar(128) NULL default NULL,
  `option_value` varchar(63) NOT NULL default '',
  `option_image` varchar(255) NULL default NULL,
  `data_type` int(11) NOT NULL default '0',
  `sort_order` int(11) NOT NULL default '0',
  `dropdown_sort_order` int(11) NOT NULL default '0',
  `refresh_main` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_options` (`id`, `option_name`, `option_string`, `option_string_define`, `option_value`, `option_image`, `data_type`, `sort_order`, `dropdown_sort_order`, `refresh_main`) VALUES
(3, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left_right', 'top_bottom_left_right.jpg', 0, 5, 110, 0),
(4, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_left_right', 'top_left_right.jpg', 0, 5, 130, 0),
(5, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top', 'top.jpg', 0, 5, 145, 0),
(6, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_left', 'top_left.jpg', 0, 5, 135, 0),
(7, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'basic', 'basic.jpg', 0, 5, 155, 0),
(8, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom', 'top_bottom.jpg', 0, 5, 140, 0),
(9, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'left', 'left.jpg', 0, 5, 150, 0),
(10, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left', 'top_bottom_left.jpg', 0, 5, 125, 0),
(11, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left_right_alt', 'top_bottom_left_right_alt.jpg', 0, 5, 115, 0),
(21, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'top_bottom_left_right_alt2', 'top_bottom_left_right_alt2.jpg', 0, 5, 120, 0),
(24, 'ForcePageNameToLowerCase', 'Force Page Name To Lower Case', 'OPTIONS_FORCE_PAGE_NAME_TO_LOWER_CASE', '0', NULL, 2, 50, 0, 0),
(26, 'EnableWizard', 'Enable Wizard', 'OPTIONS_ENABLE_WIZARD', '1', NULL, 2, 20, 0, 1),
(28, 'RunWizardLocal', 'Run Wizard Local (Check only if template repository and Breeze installation are on same server.)', 'OPTIONS_RUN_WIZARD_LOCAL', '0', NULL, 2, 25, 0, 1),
(29, 'EnableFileManager', 'Enable File Manager for Restricted Users', 'OPTIONS_ENABLE_FILE_MANAGER_FOR_RESTRICTED_USERS', '0', NULL, 2, 30, 0, 0),
(30, 'ActivateNewUsersAutomatically', 'Activate New Users Automatically', 'OPTIONS_ACTIVATE_NEW_USERS_AUTOMATICALLY', '0', NULL, 2, 40, 0, 0),
(32, 'UseTableStructure', 'Use Table Structure', 'OPTIONS_USE_TABLE_STRUCTURES', '1', NULL, 2, 10, 0, 0),
(33, 'UseTableStructureMobile', 'Use Table Structure on Mobile', 'OPTIONS_USE_TABLE_STRUCTURES_ON_MOBILE', '0', NULL, 2, 15, 0, 0),
(34, 'CreateAcctLinkTxt', 'Create Account Link Text', 'OPTIONS_CREATE_ACCOUNT_LINK_TEXT', 'Create Account', NULL, 1, 100, 0, 0),
(35, 'LoginLinkTxt', 'Login Link Text', 'OPTIONS_LOGIN_LINK_TEXT', 'Login', NULL, 1, 110, 0, 0),
(36, 'MyAcctLinkTxt', 'My Account Link Text', 'OPTIONS_MY_ACCOUNT_LINK_TEXT', 'My Account', NULL, 1, 120, 0, 0),
(37, 'LogoutLinkTxt', 'Logout Link Text', 'OPTIONS_LOGOUT_LINK_TEXT', 'Logout', NULL, 1, 130, 0, 0),
(38, 'CreateAcctLink', 'Create Account Link', 'OPTIONS_CREATE_ACCOUNT_LINK', 'create_account.php', NULL, 1, 140, 0, 0),
(39, 'LoginLink', 'Login Link', 'OPTIONS_LOGIN_LINK', 'create_account_login.php', NULL, 1, 150, 0, 0),
(40, 'MyAcctLink', 'My Account Link', 'OPTIONS_MY_ACCOUNT_LINK', 'my_account.php', NULL, 1, 160, 0, 0),
(42, 'LogoutRedirectOverride', 'Logout Redirect Override', 'OPTIONS_LOGOUT_REDIRECT_OVERRIDE', '', NULL, 1, 135, 0, 0),
(45, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'default', 'default.jpg', 0, 170, 10, 0),
(46, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', '3024-day', '3024-day.jpg', 0, 170, 20, 0),
(47, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', '3024-night', '3024-night.jpg', 0, 170, 20, 0),
(48, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'ambiance', 'ambiance.jpg', 0, 180, 30, 0),
(49, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'base16-dark', 'base16-dark.jpg', 0, 190, 40, 0),
(50, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'base16-light', 'base16-light.jpg', 0, 200, 50, 0),
(51, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'blackboard', 'blackboard.jpg', 0, 210, 60, 0),
(52, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'cobalt', 'cobalt.jpg', 0, 220, 70, 0),
(53, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'eclipse', 'eclipse.jpg', 0, 230, 80, 0),
(54, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'elegant', 'elegant.jpg', 0, 240, 90, 0),
(55, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'erlang-dark', 'erlang-dark.jpg', 0, 250, 100, 0),
(56, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'lesser-dark', 'lesser-dark.jpg', 0, 270, 110, 0),
(57, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'mbo', 'mbo.jpg', 0, 280, 120, 0),
(58, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'mdn-like', 'mdn-like.jpg', 0, 290, 130, 0),
(59, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'midnight', 'midnight.jpg', 0, 300, 140, 0),
(60, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'monokai', 'monokai.jpg', 0, 310, 150, 0),
(61, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'neat', 'neat.jpg', 0, 320, 160, 0),
(62, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'neo', 'neo.jpg', 0, 330, 170, 0),
(63, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'night', 'night.jpg', 0, 340, 180, 0),
(64, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'paraiso-dark', 'paraiso-dark.jpg', 0, 350, 190, 0),
(65, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'paraiso-light', 'paraiso-light.jpg', 0, 360, 200, 0),
(66, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'pastel-on-dark', 'pastel-on-dark.jpg', 0, 370, 210, 0),
(67, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'rubyblue', 'rubyblue.jpg', 0, 380, 220, 0),
(68, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'solarized dark', 'solarized-dark.jpg', 0, 390, 230, 0),
(69, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'solarized light', 'solarized-light.jpg', 0, 400, 240, 0),
(70, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'the-matrix', 'the-matrix.jpg', 0, 410, 250, 0),
(71, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'tomorrow-night-bright', 'tomorrow-night-bright.jpg', 0, 420, 260, 0),
(72, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'tomorrow-night-eighties', 'tomorrow-night-eighties.jpg', 0, 430, 270, 0),
(73, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'twilight', 'twilight.jpg', 0, 440, 280, 0),
(74, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'vibrant-ink', 'vibrant-ink.jpg', 0, 450, 290, 0),
(75, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'xq-dark', 'xq-dark.jpg', 0, 460, 300, 0),
(76, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'xq-light', 'xq-light.jpg', 0, 470, 310, 0),
(77, 'CodeMirrorTheme', 'Editor Source View Theme', 'OPTIONS_EDITOR_SOURCE_VIEW_THEME', 'zenburn', 'zenburn.jpg', 0, 480, 320, 0),
(78, 'Theme', 'Breeze Website Builder Theme', 'OPTIONS_BREEZE_WEBSITE_BUILDER_THEME', 'classic', 'classic_theme.jpg', 0, 500, 5, 0),
(79, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer', 'header_footer.jpg', 0, 5, 55, 0),
(80, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header', 'header.jpg', 0, 5, 105, 0),
(81, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left_right', 'header_footer_top_bottom_left_right.jpg', 0, 5, 10, 0),
(82, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_left_right', 'header_footer_top_left_right.jpg', 0, 5, 30, 0),
(83, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top', 'header_footer_top.jpg', 0, 5, 45, 0),
(84, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_left', 'header_footer_top_left.jpg', 0, 5, 35, 0),
(85, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom', 'header_footer_top_bottom.jpg', 0, 5, 40, 0),
(86, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left_right_alt', 'header_footer_top_bottom_left_right_alt.jpg', 0, 5, 15, 0),
(87, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left_right_alt2', 'header_footer_top_bottom_left_right_alt2.jpg', 0, 5, 20, 0),
(88, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left_right', 'header_top_bottom_left_right.jpg', 0, 5, 60, 0),
(89, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_left_right', 'header_top_left_right.jpg', 0, 5, 80, 0),
(90, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top', 'header_top.jpg', 0, 5, 95, 0),
(91, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_left', 'header_top_left.jpg', 0, 5, 85, 0),
(92, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom', 'header_top_bottom.jpg', 0, 5, 90, 0),
(93, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left_right_alt', 'header_top_bottom_left_right_alt.jpg', 0, 5, 65, 0),
(94, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left_right_alt2', 'header_top_bottom_left_right_alt2.jpg', 0, 5, 70, 0),
(95, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_left', 'header_footer_left.jpg', 0, 5, 50, 0),
(96, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_left', 'header_left.jpg', 0, 5, 100, 0),
(97, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_footer_top_bottom_left', 'header_footer_top_bottom_left.jpg', 0, 5, 25, 0),
(98, 'Template', 'Template', 'OPTIONS_TEMPLATE', 'header_top_bottom_left', 'header_top_bottom_left.jpg', 0, 5, 75, 0),
(99, 'LockoutClearAllCustomCSSClasses', 'Lockout Clear All Custom CSS Classes', 'OPTIONS_LOCKOUT_CLEAR_ALL_CUSTOM_CSS_CLASSES', '1', NULL, 2, 60, 0, 0),
(100, 'LockoutCopyStyleSheetToMobile', 'Lockout Copy Style Sheet to Mobile', 'OPTIONS_LOCKOUT_COPY_STYLE_SHEET_TO_MOBILE', '0', NULL, 2, 70, 0, 0),
(101, 'MinifyJSOnSave', 'Minify JavaScript on Save', 'OPTIONS_MINIFY_JS_ON_SAVE', '0', NULL, 2, 165, 0, 0),
(102, 'MinifyCSSOnSave', 'Minify CSS on Save', 'OPTIONS_MINIFY_CSS_ON_SAVE', '0', NULL, 2, 166, 0, 0),
(105, 'CKEditorSkin', 'Editor Design View Theme', 'OPTIONS_EDITOR_DESIGN_VIEW_THEME', 'breeze', 'breeze_ck_skin.jpg', 0, 490, 10, 0),
(106, 'CKEditorSkin', 'Editor Design View Theme', 'OPTIONS_EDITOR_DESIGN_VIEW_THEME', 'moono-lisa', 'moono_lisa_ck_skin.jpg', 0, 490, 20, 0),
(107, 'CKEditorSkin', 'Editor Design View Theme', 'OPTIONS_EDITOR_DESIGN_VIEW_THEME', 'kama', 'kama_ck_skin.jpg', 0, 490, 30, 0),
(108, 'CreatePageFileExistsHandling', 'How to Handle File Exists Error When Creating Pages', 'OPTIONS_CREATE_PAGE_FILE_EXISTS_HANDLING', 'Disallow Creation of Page', NULL, 0, 167, 10, 0),
(109, 'CreatePageFileExistsHandling', 'How to Handle File Exists Error When Creating Pages', 'OPTIONS_CREATE_PAGE_FILE_EXISTS_HANDLING', 'Keep Existing Page File and Continue', NULL, 0, 167, 20, 0),
(110, 'CreatePageFileExistsHandling', 'How to Handle File Exists Error When Creating Pages', 'OPTIONS_CREATE_PAGE_FILE_EXISTS_HANDLING', 'Overwrite Existing Page File and Continue', NULL, 0, 167, 30, 0);


CREATE TABLE `bwb_options_selected` (
  `option_name` varchar(63) NOT NULL default '0',
  `option_value` varchar(63) NULL default NULL,
  PRIMARY KEY  (`option_name`)
) ;

INSERT INTO `bwb_options_selected` (`option_name`, `option_value`) VALUES
('EnableWizard', '1'),
('EnableFileManager', '0'),
('CreateAcctLinkTxt', 'Create Account'),
('CreateAcctLink', 'create_account.php'),
('ActivateNewUsersAutomatically', '0'),
('ForcePageNameToLowerCase', '1'),
('LoginLink', 'create_account_login.php'),
('LoginLinkTxt', 'Login'),
('LogoutLinkTxt', 'Logout'),
('MyAcctLink', 'my_account.php'),
('MyAcctLinkTxt', 'My Account'),
('RunWizardLocal', '0'),
('Template', 'header_footer_top_bottom_left_right'),
('UseTableStructure', '1'),
('UseTableStructureMobile', '0'),
('LogoutRedirectOverride', ''),
('CodeMirrorTheme', 'rubyblue'),
('Theme', 'classic'),
('LockoutClearAllCustomCSSClasses', '1'),
('LockoutCopyStyleSheetToMobile', '0'),
('MinifyJSOnSave', '0'),
('MinifyCSSOnSave', '0'),
('CreatePageFileExistsHandling', 'Disallow Creation of Page'),
('CKEditorSkin', 'breeze');


CREATE TABLE `bwb_page_cache` (
  `id` int(11) NOT NULL default '0',
  `tmp_page_data` longtext NULL default NULL,
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE `bwb_page_data` (
  `id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext NULL default NULL,
  `template` VARCHAR( 64 ) NULL DEFAULT 'top_bottom_left_right',
  `use_table_structure` TINYINT NOT NULL DEFAULT '0',
  `use_table_structure_mobile` TINYINT NOT NULL DEFAULT '0',
  `login_required` TINYINT NOT NULL DEFAULT '0',
  `user_table` VARCHAR(64) NULL default NULL,
  `AccessLevel` VARCHAR(64) NULL default NULL,
  `login_page` VARCHAR(255) NULL default NULL,
  `show_login_links` TINYINT NOT NULL DEFAULT '0',
  `plugins` VARCHAR(64) NULL default NULL,
  `disable_site_styles` TINYINT NOT NULL DEFAULT '0',
  `body_onload` TINYINT NOT NULL DEFAULT '0',
  `body_onload_function` VARCHAR( 255 ) NULL default NULL,
  `head_name` VARCHAR( 255 ) NOT NULL DEFAULT 'head',
  `header_name` VARCHAR( 255 ) NOT NULL DEFAULT 'header',
  `top_name` VARCHAR( 255 ) NOT NULL DEFAULT 'top',
  `left_name` VARCHAR( 255 ) NOT NULL DEFAULT 'left',
  `right_name` VARCHAR( 255 ) NOT NULL DEFAULT 'right',
  `bottom_name` VARCHAR( 255 ) NOT NULL DEFAULT 'bottom',
  `footer_name` VARCHAR( 255 ) NOT NULL DEFAULT 'footer',
  `insert_default_head` TINYINT NOT NULL DEFAULT '0',
  `insert_default_header` TINYINT NOT NULL DEFAULT '0',
  `insert_default_top` TINYINT NOT NULL DEFAULT '0',
  `insert_default_left` TINYINT NOT NULL DEFAULT '0',
  `insert_default_right` TINYINT NOT NULL DEFAULT '0',
  `insert_default_bottom` TINYINT NOT NULL DEFAULT '0',
  `insert_default_footer` TINYINT NOT NULL DEFAULT '0',
  `minify` TINYINT NOT NULL DEFAULT '0',
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` TINYINT NOT NULL DEFAULT '1',
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

ALTER TABLE `bwb_page_data` ADD UNIQUE( `page_name`);


CREATE TABLE `bwb_page_data_bkup` (
  `ID` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) NULL default NULL,
  `page_content` longtext NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted` DATETIME NULL DEFAULT NULL,
  `source` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_page_data_special` (
  `id` int(11) NOT NULL auto_increment,
  `page_name` varchar(255) NULL default NULL,
  `page_content` longtext NULL default NULL,
  `plugins` VARCHAR(64) NULL default NULL,
  `disable_site_styles` tinyint(4) NOT NULL DEFAULT '0',
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

ALTER TABLE `bwb_page_data_special` ADD UNIQUE( `page_name`);

CREATE TABLE IF NOT EXISTS `bwb_page_data_draft` (
  `id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) NULL default NULL,
  `page_content` longtext NULL default NULL,
  `revised` DATETIME on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `source` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_page_data_special` (`id`, `page_name`, `page_content`) VALUES (1, 'top', 'Top'),
 (2, 'bottom', 'Bottom'),
 (3, 'left', 'Left'),
 (4, 'right', 'Right'),
 (5, 'header', ''),
 (6, 'footer', '');


CREATE TABLE `bwb_page_titles` (
  `page_name` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`page_name`)
) ;


CREATE TABLE IF NOT EXISTS `bwb_plugins` (
  `id` bigint(20) NOT NULL,
  `name` varchar(64) NOT NULL UNIQUE,
  `description` varchar(255) NULL DEFAULT NULL,
  `version` VARCHAR(32) NULL DEFAULT NULL,
  `category` VARCHAR(255) NULL DEFAULT NULL,
  `parent` bigint(20) NOT NULL DEFAULT '-1',
  `default_page_name` VARCHAR( 64 ) NULL DEFAULT NULL,
  `page_name_suffix` VARCHAR( 64 ) NULL DEFAULT NULL,
  `style_sheet` varchar(64) NULL DEFAULT NULL,
  `style_sheet_description` varchar(255) NULL DEFAULT NULL,
  `class_sql` longtext NULL DEFAULT NULL,
  `css_sql` longtext NULL DEFAULT NULL,
  `css_important_sql` longtext NULL DEFAULT NULL,
  `custom_css_sql` longtext NULL DEFAULT NULL,
  `cookie_session_code` longtext NULL DEFAULT NULL,
  `head_code` longtext NULL DEFAULT NULL,
  `head_html` longtext NULL DEFAULT NULL,
  `header_code` longtext NULL DEFAULT NULL,
  `header_html` longtext NULL DEFAULT NULL,
  `top_code` longtext NULL DEFAULT NULL,
  `top_html` longtext NULL DEFAULT NULL,
  `left_code` longtext NULL DEFAULT NULL,
  `left_html` longtext NULL DEFAULT NULL,
  `content_code` longtext NULL DEFAULT NULL,
  `content_html` longtext NULL DEFAULT NULL,
  `right_code` longtext NULL DEFAULT NULL,
  `right_html` longtext NULL DEFAULT NULL,
  `bottom_code` longtext NULL DEFAULT NULL,
  `bottom_html` longtext NULL DEFAULT NULL,
  `footer_code` longtext NULL DEFAULT NULL,
  `footer_html` longtext NULL DEFAULT NULL,
  `console_path` varchar(255) NULL DEFAULT NULL,
  `console_link_text` varchar(128) NULL DEFAULT NULL,
  `console_link_image` varchar(255) NULL DEFAULT NULL,
  `console_link_image_mo` varchar(255) NULL DEFAULT NULL,
  `console_link_image_down` varchar(255) NULL DEFAULT NULL,
  `help_path` varchar(255) NULL DEFAULT NULL,
  `language_folder` varchar(255) NULL DEFAULT NULL,
  `console_link_text_define` varchar(128) NULL DEFAULT NULL,
  `menu_group` varchar(64) NULL DEFAULT NULL,
  `plugin_sql` longtext NULL DEFAULT NULL,
  `AccessLevel` varchar(20) NULL DEFAULT NULL,
  `available` tinyint(4) NOT NULL DEFAULT '1',
  `disable_site_styles` tinyint(4) NOT NULL DEFAULT '0',
  `body_onload` tinyint(4) NOT NULL DEFAULT '0',
  `body_onload_function` varchar(255) NULL DEFAULT NULL,
  `sort_order` bigint(20) NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=30 ;

INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(15, 'Simple Slide Show', 'Simple Slide Show with no navigation controls', 'Slideshows', -1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '<script type=\"text/javascript\">\r\n// Opacity and Fade in script.\r\n// Script copyright (C) 2008 http://www.cryer.co.uk/.\r\n// Script is free to use provided this copyright header is included.\r\nfunction SetOpacity(object,opacityPct)\r\n{\r\n  // IE.\r\n  object.style.filter = \"alpha(opacity=\" + opacityPct + \")\";\r\n  // Old mozilla and firefox\r\n  object.style.MozOpacity = opacityPct/100;\r\n  // Everything else.\r\n  object.style.opacity = opacityPct/100;\r\n}\r\n\r\nfunction ChangeOpacity(id,msDuration,msStart,fromO,toO)\r\n{\r\n  var element=document.getElementById(id);\r\n  var opacity = element.style.opacity * 100;\r\n  var msNow = (new Date()).getTime();\r\n  opacity = fromO + (toO - fromO) * (msNow - msStart) / msDuration;\r\n  if (opacity<0) \r\n    SetOpacity(element,0)\r\n  else if (opacity>100)\r\n    SetOpacity(element,100)\r\n  else\r\n  {\r\n    SetOpacity(element,opacity);\r\n    element.timer = window.setTimeout(\"ChangeOpacity(\'\" + id + \"\',\" + msDuration + \",\" + msStart + \",\" + fromO + \",\" + toO + \")\",1);\r\n  }\r\n}\r\n\r\nfunction FadeIn(id)\r\n{\r\n  var element=document.getElementById(id);\r\n  if (element.timer) window.clearTimeout(element.timer); \r\n  var startMS = (new Date()).getTime();\r\n  element.timer = window.setTimeout(\"ChangeOpacity(\'\" + id + \"\',1000,\" + startMS + \",0,100)\",1);\r\n}\r\n\r\nfunction FadeOut(id)\r\n{\r\n  var element=document.getElementById(id);\r\n  if (element.timer) window.clearTimeout(element.timer); \r\n  var startMS = (new Date()).getTime();\r\n  element.timer = window.setTimeout(\"ChangeOpacity(\'\" + id + \"\',1000,\" + startMS + \",100,0)\",1);\r\n}\r\n\r\nfunction FadeInImage(foregroundID,newImage,backgroundID)\r\n{\r\n  var foreground=document.getElementById(foregroundID);\r\n  if (backgroundID)\r\n  {\r\n    var background=document.getElementById(backgroundID);\r\n    if (background)\r\n    {\r\n      background.style.backgroundImage = \'url(\' + foreground.src + \')\';\r\n      background.style.backgroundRepeat = \'no-repeat\';\r\n    }\r\n  }\r\n  SetOpacity(foreground,0);\r\n  foreground.src = newImage;\r\n  if (foreground.timer) window.clearTimeout(foreground.timer); \r\n  var startMS = (new Date()).getTime();\r\n  foreground.timer = window.setTimeout(\"ChangeOpacity(\'\" + foregroundID + \"\',1000,\" + startMS + \",0,100)\",10);\r\n}\r\n\r\n</script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<script type=\"text/javascript\">\r\nvar last_image = 1;\r\nvar image_cnt = 2;\r\nvar img_width = \"500px\";\r\nvar img_height = \"366px\";\r\nvar delay = 7000;\r\n\r\nfunction ChangeImage()\r\n{\r\n   var base_image_name = \"slide\";\r\n   var image_str;\r\n\r\n   last_image++;\r\n\r\n   image_str = image_dir + base_image_name + last_image + \".jpg\";\r\n   FadeInImage(\"image_banner\", image_str, \"image_banner_bkg\");\r\n   \r\n   if (last_image == image_cnt)\r\n      last_image = 0;\r\n\r\n   mTimer = setTimeout(ChangeImage, delay);\r\n}\r\n\r\nmTimer = setTimeout(ChangeImage, delay);\r\n  \r\n</script>\r\n\r\n<div id=\"image_banner_bkg\" style=\"background-image: url(\"../image/slide1.jpg\");\">\r\n <img id=\"image_banner\" src=\"/images/slide1.jpg\" style=\"border-width: 0px; border-style: solid; margin: 0px;\" />	\r\n</div>\r\n\r\n<script type=\"text/javascript\">\r\ndocument.getElementById(\"image_banner\").style.width = img_width;\r\ndocument.getElementById(\"image_banner\").style.height = img_height;\r\ndocument.getElementById(\"image_banner_bkg\").style.width = img_width;\r\n</script>', NULL, NULL, NULL, NULL, NULL, '<script language=\"JavaScript\" type=\"text/JavaScript\">\r\n	var start_image_path_rel = image_dir_rel + \"slide1.jpg\";\r\n	var start_image_path = image_dir + \"slide1.jpg\";\r\n	document.getElementById(\"image_banner_bkg\").setAttribute(\"url\", start_image_path);\r\n	document.getElementById(\"image_banner\").src = start_image_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#slide_show', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 50);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `cookie_session_code`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(26, 'Contact/Mail Form with CAPTCHA', 'Contact/Mail Form with CAPTCHA, auto-table creation and custom response email and return page.', 'Contact Forms', 26, 'contact', NULL, 'mail_form', 'Mail Form Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon\', \'Generate Password Icon\', 412, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', \'Generate Password Icon: Hover\', 413, 500, 1);\r\n\r\nREPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form_mobile\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form_mobile\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form_mobile\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form_mobile\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form_mobile\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form_mobile\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form_mobile\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form_mobile\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form_mobile\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form_mobile\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form_mobile\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form_mobile\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form_mobile\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form_mobile\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form_mobile\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form_mobile\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form_mobile\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form_mobile\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', \'Generate Password Icon: Hover\', 413, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', \'Generate Password Icon: Hover\', 411, 500, 1);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'.block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#city\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'400.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#first_name\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"file\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"radio\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'10.00\', 0, 0, \'inline-block\', \'75.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha2_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_td *\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'30.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'16.00\', 0, \'15.00\', 0, \'3.00\', 0, \'15.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, 18, 2, \'-1000000.00\', -1, \'#2d5c88\', -1, 0, 0, \'1.00\', 0, \'#0b3a66\', \'solid\', \'-not selected-\', \'-not selected-\', 4, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'33.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.btn_txt\', 1, \'Titillium Web\', \'Arial\', \'sans-serif\', \'18.00\', \'px\', \'#fff\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', 0, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'100.00\', 0, 0, \'30.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'24.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.field_title_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'18.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'5.00\', 0, \'-1.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.gen_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'325.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mailing_list_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'180.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'3.00\', 0, \'6.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'16.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_div\', 1, \'Titillium Web\', \'Arial\', \'sans-serif\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'50.00\', 0, 0, \'-1000000.00\', 0, 0, \'20.00\', 1, 0, \'50.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'15.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'15.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.reveal_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'#recaptcha2_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-130.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'110.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'200.000\', 0, \'-130.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'100.00\', 0, 0, \'30.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'16.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'5.00\', 0, \'-1.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha2_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mailing_list_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'180.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'3.00\', 0, \'6.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'25.00\', 1, 0, \'10.00\', 0, 0, \'inline-block\', \'250.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'18.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'24.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'15.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'15.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.field_title_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'10.00\', 0, 0, \'inline-block\', \'75.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'30.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_td *\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'325.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'70.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'34.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'500.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'6.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'6.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'70.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'500.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'34.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'50.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'400.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'40.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mailing_list_captcha\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'180.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'3.00\', 0, \'6.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'10.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'50.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-100.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'20.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'scale\', \'60.000\', 0, \'60.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.field_title_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'12.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'200.00\', 0, 0, \'60.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'30.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mollom_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'700.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"checkbox\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);', 'REPLACE INTO `bwb_custom_site_css` (`name`, `custom_css`) VALUES\r\n(\'mail_form_mobile\', \'.recaptcha_r7_c1,.recaptcha_r8_c1	{\\n  display: none	!important;\\n}\\n\\n#rc-imageselect, .g-recaptcha {\\n  transform:scale(2.5);\\n  -webkit-transform:scale(2.5);\\n  transform-origin:0 0;\\n  -webkit-transform-origin:0 0;\\n  margin-bottom: 120px;\\n}\'),\r\n(\'mail_form_touchscreen\', \'.recaptcha_r7_c1,.recaptcha_r8_c1	{\\r\\n  	display: none	!important;\\r\\n}\'),\r\n(\'mail_form\', \'.recaptcha_r7_c1,.recaptcha_r8_c1	{\\r\\n  	display: none	!important;\\r\\n}\';\r\n\r\nREPLACE INTO `bwb_site_css_important` (`style_sheet`, `class`, `attribute`) VALUES\r\n(\'mail_form\', \'.gen_pass_icon\', \'display\');\r\nREPLACE INTO `bwb_site_css_important` (`style_sheet`, `class`, `attribute`) VALUES\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', \'display\');', NULL, '<?php\r\nif (($login_required != 1) || ($show_login !== true))\r\n	include_once($captcha_includes_path);\r\n?>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>form_processor.js\"></script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"ErrRequired\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	A required field has not been filled in. Please try again.\r\n</div>\r\n<div id=\"ErrEmail\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	Your email is blank or doesn&#39;t match the confirm. Please try again.\r\n</div>\r\n<div id=\"ErrEmailBlank\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your email is blank. Please try again.\r\n</div>\r\n<div id=\"ErrEmailNoMatch\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your email doesn&#39;t match the confirm. Please try again.\r\n</div>\r\n<div id=\"ErrDuplicate\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	The email address you entered already exists in our system. Please try again.\r\n</div>\r\n<div id=\"ErrBadEmail\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	The email address you entered is not a valid email address. Please try again.\r\n</div>\r\n<div id=\"ErrCaptcha\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	The Captcha you entered does not match. Please try again.\r\n</div>\r\n<div id=\"ErrFileSize\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	The file you are trying to send is too large for email.  Please select a different file.\r\n</div>\r\n<div id=\"ErrFileType\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	The file you are trying to send is of a type that is not allowed to be be emailed.  Please select a different file.\r\n</div>\r\n<div id=\"ErrUpload\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	There was an error uploading your file.  Please try again.\r\n</div>\r\n<div id=\"ErrPhone\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	The phone number you entered is not a valid phone number.  Please re-enter your phone number.\r\n</div>\r\n<div id=\"ErrImgResize\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n	There was an error resizing your image.  Please try again.\r\n</div>\r\n<form name=\"frmMailForm\" id=\"frmMailForm\" method=\"post\" action=\"/php/formmail.php\" enctype=\"multipart/form-data\">\r\n<div class=\"mail_form_div\">\r\n<span class=\"mail_form_heading\">Contact My Company Inc.</span>\r\n      <br />&nbsp;\r\n<span class=\"address_block\">\r\n My Company, Inc.<br />\r\n 123 Anywhere St.<br />\r\n Suite 100<br />\r\n My Town, Ohio, 99999<br />\r\n 123-456-7890\r\n</span>\r\n	<br />&nbsp;\r\n	  <span class=\"mail_form_heading\">Fill out the form below and click &#39;Submit&#39; to contact us:</span>\r\n    <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Name (First, Last): </span>\r\n  </div>\r\n  <input type=\"text\" name=\"first_name\" id=\"first_name\" class=\"medium_txt_field\" />\r\n  <input type=\"text\" name=\"last_name\" id=\"last_name\" class=\"medium_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_first_name\">*</span> <span class=\"required_mark\" id=\"required_mark_last_name\">*</span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Address: </span>\r\n  </div>\r\n  <input name=\"address\" type=\"text\" id=\"address\" class=\"long_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_address\"></span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\">&nbsp;\r\n  </div>\r\n  <input name=\"address2\" type=\"text\" id=\"address2\" class=\"long_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_address2\"></span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">City, State ZIP: </span>\r\n  </div>\r\n  <input name=\"city\" type=\"text\" id=\"city\" class=\"medium_txt_field\" />\r\n  , \r\n  <select name=\"state\" id=\"state\">\r\n    <option >-not selected-</option>\r\n    <option value=\"Alabama\" >Alabama</option>\r\n    <option value=\"Alaska\" >Alaska</option>\r\n    <option value=\"Arizona\" >Arizona</option>\r\n    <option value=\"Arkansas\" >Arkansas</option>\r\n    <option value=\"California\" >California</option>\r\n    <option value=\"Colorado\" >Colorado</option>\r\n    <option value=\"Connecticut\" >Connecticut</option>\r\n    <option value=\"Delaware\" >Delaware</option>\r\n    <option value=\"Dist of Columbia\" >Dist of Columbia</option>\r\n    <option value=\"Florida\" >Florida</option>\r\n    <option value=\"Georgia\" >Georgia</option>\r\n    <option value=\"Hawaii\" >Hawaii</option>\r\n    <option value=\"Idaho\" >Idaho</option>\r\n    <option value=\"Illinois\" >Illinois</option>\r\n    <option value=\"Indiana\" >Indiana</option>\r\n    <option value=\"Iowa\" >Iowa</option>\r\n    <option value=\"Kansas\" >Kansas</option>\r\n    <option value=\"Kentucky\" >Kentucky</option>\r\n    <option value=\"Louisiana\" >Louisiana</option>\r\n    <option value=\"Maine\" >Maine</option>\r\n    <option value=\"Maryland\" >Maryland</option>\r\n    <option value=\"Massachusetts\" >Massachusetts</option>\r\n    <option value=\"Michigan\" >Michigan</option>\r\n    <option value=\"Minnesota\" >Minnesota</option>\r\n    <option value=\"Mississippi\" >Mississippi</option>\r\n    <option value=\"Missouri\" >Missouri</option>\r\n    <option value=\"Montana\" >Montana</option>\r\n    <option value=\"Nebraska\" >Nebraska</option>\r\n    <option value=\"Nevada\" >Nevada</option>\r\n    <option value=\"New Hampshire\" >New Hampshire</option>\r\n    <option value=\"New Jersey\" >New Jersey</option>\r\n    <option value=\"New Mexico\" >New Mexico</option>\r\n    <option value=\"New York\" >New York</option>\r\n    <option value=\"North Carolina\" >North Carolina</option>\r\n    <option value=\"North Dakota\" >North Dakota</option>\r\n    <option value=\"Ohio\" >Ohio</option>\r\n    <option value=\"Oklahoma\" >Oklahoma</option>\r\n    <option value=\"Oregon\" >Oregon</option>\r\n    <option value=\"Pennsylvania\" >Pennsylvania</option>\r\n    <option value=\"Rhode Island\" >Rhode Island</option>\r\n    <option value=\"South Carolina\" >South Carolina</option>\r\n    <option value=\"South Dakota\" >South Dakota</option>\r\n    <option value=\"Tennessee\" >Tennessee</option>\r\n    <option value=\"Texas\" >Texas</option>\r\n    <option value=\"Utah\" >Utah</option>\r\n    <option value=\"Vermont\" >Vermont</option>\r\n    <option value=\"Virginia\" >Virginia</option>\r\n    <option value=\"Washington\" >Washington</option>\r\n    <option value=\"West Virginia\" >West Virginia</option>\r\n    <option value=\"Wisconsin\" >Wisconsin</option>\r\n    <option value=\"Wyoming\" >Wyoming</option>\r\n  </select> \r\n  <input name=\"zip\" type=\"text\" id=\"zip\" class=\"tiny_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_city\"></span> <span class=\"required_mark\" id=\"required_mark_state\"></span> <span class=\"required_mark\" id=\"required_mark_zip\"></span>\r\n  <br />&nbsp;\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Email: </span>\r\n  </div>\r\n  <input name=\"email\" type=\"text\" id=\"email\" class=\"long_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_email\">*</span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Email Confirm: </span>\r\n  </div>\r\n  <input name=\"email_confirm\" type=\"text\" id=\"email_confirm\" class=\"long_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_email_confirm\">*</span>\r\n  <br />&nbsp;\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Home Phone: </span>\r\n  </div>\r\n  <input type=\"text\" name=\"home_phone\" id=\"home_phone\" class=\"short_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_home_phone\"></span>\r\n  <input type=\"radio\" value=\"home\" name=\"preferred_phone\" id=\"preferred_phone[0]\" /><span class=\"mail_form_small_text\"> Preferred Phone</span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Work Phone: </span>\r\n  </div>\r\n  <input type=\"text\" name=\"work_phone\" id=\"work_phone\" class=\"short_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_work_phone\"></span>\r\n  <input type=\"radio\" value=\"work\" name=\"preferred_phone\" id=\"preferred_phone[1]\" /><span class=\"mail_form_small_text\"> Preferred Phone</span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Cell Phone: </span>\r\n  </div>\r\n  <input type=\"text\" name=\"cell_phone\" id=\"cell_phone\" class=\"short_txt_field\" /> <span class=\"required_mark\" id=\"required_mark_cell_phone\"></span>\r\n  <input type=\"radio\" value=\"cell\" name=\"preferred_phone\" id=\"preferred_phone[2]\" /><span  class=\"mail_form_small_text\"> Preferred Phone</span>\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Best time to call: </span>\r\n  </div>\r\n  <div id=\"best_time_div\" class=\"group_div\">\r\n    <input type=\"radio\" name=\"best_time\" id=\"best_time[0]\" value=\"day\" /><span class=\"mail_form_large_text\">Day</span> \r\n    <input type=\"radio\" name=\"best_time\" id=\"best_time[1]\" value=\"evening\" /><span class=\"mail_form_large_text\">Evening</span> <span class=\"required_mark\" id=\"required_mark_best_time\"></span>\r\n  </div>\r\n  <br />&nbsp;\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Comments: </span>\r\n  </div>\r\n  <textarea name=\"comments\" id=\"comments\"></textarea> <span class=\"required_mark\" id=\"required_mark_comments\"></span>\r\n  <br />&nbsp;\r\n  <br />&nbsp;\r\n  <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Select file to upload: </span>\r\n  </div>\r\n  <input type=\"file\" name=\"upload_file\" id=\"upload_file\" /> <span class=\"required_mark\" id=\"required_mark_upload_file\"></span>\r\n  <br />&nbsp;\r\n  <div id=\"recaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"recaptcha_td\">\r\n      <script type=\"text/javascript\" src=\"https://www.google.com/recaptcha/api/challenge?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT\" id=\"recaptcha_script\">\r\n      </script>\r\n      <noscript>\r\n        <iframe src=\"https://www.google.com/recaptcha/api/noscript?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT\"\r\n                height=\"300\" width=\"500\" frameborder=\"0\" id=\"captcha_iframe\">\r\n        </iframe>\r\n        <br>\r\n        <textarea name=\"recaptcha_challenge_field\" rows=\"3\" cols=\"40\">\r\n        </textarea>\r\n        <input type=\"hidden\" name=\"recaptcha_response_field\" id=\"recaptcha_response_field\" value=\"manual_challenge\">\r\n      </noscript>\r\n    </div>\r\n  </div>\r\n  <div id=\"recaptcha2_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"recaptcha2_td\">\r\n      <div class=\"g-recaptcha\" data-sitekey=\"\" id=\"recaptcha2_div\">\r\n      </div>\r\n      <script type=\"text/javascript\" src=\"https://www.google.com/recaptcha/api.js?hl=en\">\r\n      </script>\r\n    </div>\r\n  </div>\r\n  <div id=\"wscaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <table>\r\n      <tr>\r\n        <td width=\"200\">\r\n          <img alt=\"wspcaptcha\" border=\"0\" id=\"wspcaptcha\" src=\"wspcaptcha.php\" /> \r\n        </td>\r\n        <td valign=\"bottom\" align=\"left\" width=\"100%\">\r\n          <a href=\"javascript:void(0);\" onclick=\"document.getElementById(\'wspcaptcha\').src=\'wspcaptcha.php?t=\'+(new Date()).getTime(); return false;\">\r\n            <img alt=\"Reload\" border=\"0\" src=\"/images/reload.gif\" /></a>\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td style=\"vertical-align: bottom;\" colspan=\"2\">\r\n          <input name=\"wsp_code\" id=\"wsp_code\" style=\"width:120px;\" type=\"text\" value=\"\" class=\"text_box\" />\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan=\"2\">\r\n          Type in the letters you see <span class=\"mail_form_large_text\"><span class=\"required_fields\"><b>*</b></span></span>\r\n        </td>\r\n      </tr>\r\n    </table>\r\n  </div>\r\n  <div id=\"mollomcaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"mollom_captcha\">&nbsp;\r\n    </div>\r\n    <input type=\"hidden\" name=\"mollom_session\" id=\"mollom_session\" />\r\n    <input type=\"text\" name=\"captcha_response_field\" id=\"captcha_response_field\" value=\"\" autocomplete=\"off\" />\r\n    <br />&nbsp;\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <span class=\"mail_form_small_text mollom_instructions\">Type the characters you see in this picture</span>\r\n  </div>\r\n  <br />&nbsp;\r\n  <br />&nbsp;\r\n  <div id=\"form_div_btn\" class=\"btn_div\" onClick=\"SubmitForm(\'frmMailForm\');\"><span id=\"form_btn_txt\" class=\"btn_txt\">Submit</span>\r\n  </div>\r\n  <input type=\"submit\" id=\"submit_btn\" value=\"Submit\" class=\"submit_btn\" />\r\n  <div class=\"required_box\">&nbsp;\r\n  </div><span class=\"required_mark\"><b>*</b></span> <span class=\"required_msg\">required fields</span>\r\n  <input type=\"hidden\" name=\"redirect\" id=\"redirect\" value=\"/contact_return.php\" />\r\n  <input type=\"hidden\" name=\"subject\" id=\"subject\" value=\"Information Request\" />\r\n  <input type=\"hidden\" name=\"from\" id=\"from\" value=\"contactform@example.com\" />\r\n  <input type=\"hidden\" name=\"recipient\" id=\"recipient\" value=\"recipient@example.com\" />\r\n  <input type=\"hidden\" name=\"email_required\" id=\"email_required\" value=\"1\" />\r\n  <input type=\"hidden\" name=\"required_fields\" id=\"required_fields\" value=\"first_name,last_name\" />\r\n  <input type=\"hidden\" name=\"html_message_page\" id=\"html_message_page\" value=\"contact_return_message\" />\r\n  <input type=\"hidden\" name=\"table_name\" id=\"table_name\" value=\"contacts\" />\r\n  <input type=\"hidden\" name=\"use_captcha\" id=\"use_captcha\" value=\"0\" />\r\n  <input type=\"hidden\" name=\"captcha_type\" id=\"captcha_type\" value=\"recaptcha2\" />\r\n  <input id=\"alt_go_back\" name=\"alt_go_back\" type=\"hidden\" />\r\n  <input id=\"redirect_err_to_src\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n  <input id=\"use_classic_required_field_marks\" name=\"use_classic_required_field_marks\" type=\"hidden\" value=\"0\" />\r\n</div>\r\n</form>', NULL, NULL, NULL, NULL, '<?php\r\nif (($login_required != 1) || ($show_login !== true))\r\n	include_once($captcha_includes_path2);\r\n?>', '', './plugins/edit_form_recipients.php', 'Edit Form Recipients', './plugins/images/icon_Edit-Email.png', './plugins/images/icon_Edit-Email_mo.png', './plugins/images/icon_Edit-Email_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mail_form', 'manage/plugins/lang/form_recipients', 'FORM_RECIPIENTS_EDIT_FORM_RECIPIENTS_BTN', 'page_functions', 'CREATE TABLE IF NOT EXISTS `form_recipients` (\r\n  `page_name` varchar(255) NOT NULL,\r\n  `recipient` varchar(255) NOT NULL,\r\n  PRIMARY KEY (`page_name`)\r\n) ENGINE=MyISAM DEFAULT CHARSET=latin1;\r\n\r\nREPLACE INTO `bwb_plugins_deployed` (`plugin_id`, `name`, `deployed`) VALUES (\'83\', \'View Form Tables\', \'1\');', NULL, 1, 0, 1, 'InitializeForm();', 30);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `version`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `css_important_sql`, `custom_css_sql`, `cookie_session_code`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(10, 'Lightbox Photo Gallery', 'Lightbox Photo Gallery', '1.0.00', 'Photo Galleries', -1, 'gallery', NULL, 'photo_gallery', 'Photo Gallery Styles', 'REPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery\', `class` = \'#imageDataContainer\', `description` = \'Image Data Container\', `sort_order` = \'265\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery\', `class` = \'#imageDetails\', `description` = \'Image Details\', `sort_order` = \'260\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\n\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#bottomNavClose\', `description` = \'Close Btn\', `sort_order` = \'255\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#bottomNavClose img\', `description` = \'Close Btn: Image\', `sort_order` = \'256\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#caption\', `description` = \'Caption\', `sort_order` = \'245\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#gallery_container\', `description` = \'Gallery Container\', `sort_order` = \'290\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#gallery_container img\', `description` = \'Gallery Container: Image\', `sort_order` = \'291\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#imageDataContainer\', `description` = \'Image Data Container\', `sort_order` = \'265\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#imageDetails\', `description` = \'Image Details\', `sort_order` = \'260\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#lightboxImage\', `description` = \'Lightbox Image\', `sort_order` = \'275\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#nextLink:hover, #nextLink:visited:hover\', `description` = \'Next Button\', `sort_order` = \'280\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#numberDisplay\', `description` = \'Number Display\', `sort_order` = \'250\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#prevLink:hover, #prevLink:visited:hover\', `description` = \'Prev Button\', `sort_order` = \'285\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'img\', `description` = \'Image\', `sort_order` = \'270\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\n\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_touchscreen\', `class` = \'#imageDataContainer\', `description` = \'Image Data Container\', `sort_order` = \'265\', `subclass_sort_order` = \'500\', `custom` = \'1\';\r\nREPLACE INTO bwb_site_classes SET `style_sheet` = \'photo_gallery_touchscreen\', `class` = \'#imageDetails\', `description` = \'Image Details\', `sort_order` = \'260\', `subclass_sort_order` = \'500\', `custom` = \'1\';', 'REPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery\', `class` = \'#imageDataContainer\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'250.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery\', `class` = \'#imageDetails\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'240.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\n\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#bottomNavClose\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'40.00\', `font_size_units` = \'pt\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'42\', `line_height_units` = \'5\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'-1.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#bottomNavClose img\', `use_table_data` = \'1\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'132.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'44.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'relative\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'70.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `justify_content` = \'-not selected-\', `content` = \'-not selected-\', `text_transform` = \'-not selected-\', `transition_property` = \'-not selected-\', `transition_timing_function` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis` = \'-not selected-\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\', `flex_direction` = \'-not selected-\', `flex_wrap` = \'-not selected-\', `gradient_colors` = \'-not set-\', `gradient_opacities` = \'-not set-\', `box_sizing` = \'-not selected-\', `align_content` = \'-not selected-\', `align_items` = \'-not selected-\', `align_self` = \'-not selected-\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#caption\', `use_table_data` = \'1\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'32.00\', `font_size_units` = \'pt\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'35\', `line_height_units` = \'5\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'-1.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#gallery_container img\', `use_table_data` = \'1\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'200.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'200.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#imageDataContainer\', `use_table_data` = \'1\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'800.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#imageDetails\', `use_table_data` = \'1\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'790.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#lightboxImage\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'500.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#nextLink:hover, #nextLink:visited:hover\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'-1.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'scale\', `background_width` = \'120.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#numberDisplay\', `use_table_data` = \'1\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'26.00\', `font_size_units` = \'pt\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'28\', `line_height_units` = \'5\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'-1.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#prevLink:hover, #prevLink:visited:hover\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'-1.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'scale\', `background_width` = \'120.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\n\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_touchscreen\', `class` = \'#imageDataContainer\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'250.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';\r\nREPLACE INTO bwb_site_css SET `style_sheet` = \'photo_gallery_touchscreen\', `class` = \'#imageDetails\', `font` = \'-not selected-\', `font2` = \'-not selected-\', `font3` = \'-not selected-\', `font_size` = \'-1.00\', `font_size_units` = \'px\', `text_color` = \'-not set-\', `padding_top` = \'-1.00\', `padding_right` = \'-1.00\', `padding_bottom` = \'-1.00\', `padding_left` = \'-1.00\', `weight` = \'-not selected-\', `letter_spacing` = \'-1000000.00\', `letter_spacing_units` = \'-1\', `shadow_color` = \'-not set-\', `shadow_x_offset` = \'0.0\', `shadow_y_offset` = \'0.0\', `shadow_blur` = \'0.0\', `text_align` = \'-not selected-\', `vertical_align` = \'-not selected-\', `vertical_align_length` = \'-1000000.00\', `line_height` = \'-1\', `line_height_units` = \'-1\', `text_indent` = \'-1000000.00\', `text_indent_units` = \'-1\', `bkgd_color` = \'-not set-\', `bkgd_opacity` = \'-1\', `border` = \'-1.00\', `border_color` = \'-not set-\', `border_style` = \'-not selected-\', `outline_style` = \'-not selected-\', `border_collapse` = \'-not selected-\', `margin_top` = \'-1000000.00\', `margin_right` = \'-1000000.00\', `margin_left` = \'-1000000.00\', `margin_bottom` = \'-1000000.00\', `display` = \'-not selected-\', `width` = \'240.000\', `min_width` = \'-1.000\', `max_width` = \'-1.000\', `height` = \'-1.000\', `min_height` = \'-1.000\', `max_height` = \'-1.000\', `position` = \'-not selected-\', `position_left` = \'-1000000.000\', `position_top` = \'-1000000.000\', `position_right` = \'-1000000.000\', `position_bottom` = \'-1000000.000\', `z_index` = \'-1000000\', `overflow` = \'-not selected-\', `overflow_x` = \'-not selected-\', `overflow_y` = \'-not selected-\', `clip_top` = \'-1.00\', `clip_top_units` = \'-1\', `clip_right` = \'-1.00\', `clip_right_units` = \'-1\', `clip_bottom` = \'-1.00\', `clip_bottom_units` = \'-1\', `clip_left` = \'-1.00\', `clip_left_units` = \'-1\', `background_image` = \'-not selected-\', `background_attachment` = \'-not selected-\', `background_repeat` = \'-not selected-\', `background_position` = \'-not selected-\', `background_position_x` = \'0.000\', `background_position_y` = \'0.000\', `list_style_type` = \'-not selected-\', `list_style_position` = \'-not selected-\', `list_style_image` = \'-not selected-\', `float` = \'-not selected-\', `white_space` = \'-not selected-\', `table_layout` = \'-not selected-\', `clear` = \'-not selected-\', `box_shadow_horizontal` = \'-1000000.0\', `box_shadow_vertical` = \'-1000000.0\', `box_shadow_blur` = \'-1.0\', `box_shadow_spread` = \'-1000000.0\', `box_shadow_color` = \'-not set-\', `radius_top_left` = \'0.00\', `radius_top_right` = \'0.00\', `radius_bottom_right` = \'0.00\', `radius_bottom_left` = \'0.00\', `cursor` = \'-not selected-\', `background_size` = \'-not selected-\', `background_width` = \'-1.000\', `background_height` = \'-1.000\', `visibility` = \'-not selected-\', `transition_duration` = \'-1\', `transition_delay` = \'-1\', `flex_basis_length` = \'-1.000\', `flex_grow` = \'-1.000\', `flex_shrink` = \'-1.000\';', 'REPLACE INTO bwb_site_css_important SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#bottomNavClose img\', `attribute` = \'height\';\r\nREPLACE INTO bwb_site_css_important SET `style_sheet` = \'photo_gallery_mobile\', `class` = \'#bottomNavClose img\', `attribute` = \'width\';\r\n', 'REPLACE INTO bwb_custom_site_css SET name = \'photo_gallery_mobile\', custom_css = \'#prevLink, #prevLink:hover, #prevLink:visited:hover {\r\n  background: url(../images/lightbox/prevlabel.gif) no-repeat left 0 top 0 !important;\r\n  background-size: 150px !important;\r\n}\r\n\r\n#nextLink, #nextLink:hover, #nextLink:visited:hover {\r\n  background: url(../images/lightbox/nextlabel.gif) no-repeat right 0 top 0 !important;\r\n  background-size: 150px !important;\r\n}\';\r\n\r\nREPLACE INTO bwb_custom_site_css SET name = \'photo_gallery_touchscreen\', custom_css = \'#prevLink, #prevLink:hover, #prevLink:visited:hover {\r\n  background: url(../images/lightbox/prevlabel.gif) no-repeat left 0 top 0 !important;\r\n}\r\n\r\n#nextLink, #nextLink:hover, #nextLink:visited:hover {\r\n  background: url(../images/lightbox/nextlabel.gif) no-repeat right 0 top 0 !important;\r\n}\';', NULL, '<script src=\"<?php echo $scripts_dir_rel; ?>prototype.js\"></script>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>scriptaculous.js?load=effects,builder\"></script>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>lightbox.js\"></script>\r\n\r\n<link rel=\"stylesheet\" href=\"<?php echo $css_dir_rel; ?>lightbox.css\" type=\"text/css\" media=\"screen\" />', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"gallery_container\">\r\n<?php\r\n	$doc_root = getenv(\'DOCUMENT_ROOT\');\r\n	\r\n	if (BWB_BASE_DIR == \'\')\r\n	{\r\n		$full_gallery_path_fs = $doc_root . \"/\" .BWB_IMAGE_DIR . \"/gallery/fs\";\r\n		\r\n		$gallery_path_fs = BWB_IMAGE_DIR . \"/gallery/fs\";\r\n		$gallery_path_tn = BWB_IMAGE_DIR . \"/gallery/tn\";\r\n	}\r\n	else\r\n	{\r\n		$needle = \"/\" . BWB_BASE_DIR . \"/\";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$full_gallery_path_fs = $path_start . \"/\" . BWB_BASE_DIR . \"/\" .BWB_IMAGE_DIR . \"/gallery/fs\";\r\n		\r\n		$gallery_path_fs = \"../\" . BWB_IMAGE_DIR . \"/gallery/fs\";\r\n		$gallery_path_tn = \"../\" . BWB_IMAGE_DIR . \"/gallery/tn\";\r\n	}\r\n	\r\n	$files = array();\r\n	$srch = array(\".jpg\", \".JPG\", \".Jpg\", \".gif\", \".GIF\", \".Gif\", \".png\", \".PNG\", \".Png\");\r\n	if ($handle = opendir(\"$full_gallery_path_fs\")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != \".\") && ($file != \"..\") && (!is_dir(\"$full_gallery_path_fs/\" . $file)))\r\n				$files[] = $file;\r\n		}\r\n		closedir($handle);\r\n	}\r\n	\r\n	$query = \"SELECT * FROM gallery_params\";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$show_titles = $row[\'show_titles\'];\r\n	$disable_sort = $row[\'disable_sort\'];\r\n	\r\n	if ($disable_sort != 1)\r\n		sort($files);\r\n	$images = array();\r\n	$next_sort = 1000000;\r\n	foreach ($files as $file)\r\n	{\r\n		$query = \"SELECT * FROM gallery_titles WHERE image = \'\" . $file . \"\'\";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($result->rowCount() > 0)	{\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$title = $row[\'title\'];\r\n			if ($row[\'sort_order\'] > -1)\r\n				$sort_order = $row[\'sort_order\'];\r\n			else	{\r\n				$sort_order = $next_sort;\r\n				$next_sort++;\r\n			}\r\n		}\r\n		else	{\r\n			$title = \"\";\r\n			$sort_order = $next_sort;\r\n			$next_sort++;\r\n		}\r\n		\r\n		$images[$sort_order] = array($file, $title);\r\n	}\r\n	\r\n	if ($disable_sort != 1)\r\n		ksort($images);\r\n	foreach ($images as $image)\r\n	{\r\n		$file = $image[0];\r\n		$title = $image[1];\r\n		$alt = str_replace($srch, \"\", $file);\r\n		if ($show_titles == 1)	{\r\n			if ($title == \"\")	{\r\n				$file_parts = explode(\".\", $file);\r\n				$file_str = str_replace(\".\" . $file_parts[count($file_parts) - 1], \"\", $file);\r\n				$tile_str = \" title=\\\"\" . str_replace(\"_\", \" \", $file_str) . \"\\\"\";\r\n			}\r\n			else\r\n				$tile_str = \" title=\\\"\" . $title . \"\\\"\";\r\n		}\r\n		echo \"<a href=\'\" . $gallery_path_fs . \"/\" . $file . \"\' rel=\'lightbox[group]\'\" . $tile_str . \"><img src=\'\" . $gallery_path_tn . \"/\" . $file . \"\' alt=\'\" . $alt . \"\' border=\'0\' /></a>\\n\";\r\n	}\r\n?>\r\n</div>', '<h3>The code below is an example on how to build a slide show manually. If you have any more than a few images, it is recommended that you <em>Clear</em> this content and <em>Publish</em> this page.  Then use the <em>Manage Gallery</em> console under <em>SITE MANAGEMENT</em> to create your gallery.</h3>\r\n<p>Single Image</p>\r\n<a href=\"../images/sample1.jpg\" rel=\"lightbox\" title=\"my caption\"><img src=\"../images/sample1_tn.jpg\" alt=\"\" border=\"0\" /></a>\r\n<br>\r\n<br>\r\n<p>Multiple Images</p>\r\n<a href=\"../images/sample1.jpg\" rel=\"lightbox[group]\"><img src=\"../images/sample1_tn.jpg\" alt=\"\" border=\"0\" /></a>\r\n<a href=\"../images/sample2.jpg\" rel=\"lightbox[group]\"><img src=\"../images/sample2_tn.jpg\" alt=\"\" border=\"0\" /></a>\r\n<a href=\"../images/sample3.jpg\" rel=\"lightbox[group]\"><img src=\"../images/sample3_tn.jpg\" alt=\"\" border=\"0\" /></a>\r\n<br>', NULL, NULL, NULL, NULL, NULL, NULL, './plugins/manage_gallery.php', 'Manage Gallery', './plugins/images/icon_gallery.png', './plugins/images/icon_gallery_mo.png', './plugins/images/icon_gallery_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#photo_gallery', 'manage/plugins/lang/gallery', 'MANAGE_GALLERY_MANAGE_GALLERY_BTN', 'content_functions', 'CREATE TABLE IF NOT EXISTS `gallery_params` (\r\n  `id` int(11) NOT NULL AUTO_INCREMENT,\r\n  `thumb_width` int(11) NOT NULL DEFAULT \'100\',\r\n  `thumb_height` int(11) NOT NULL DEFAULT \'100\',\r\n  `full_width` int(11) NOT NULL DEFAULT \'1024\',\r\n  `full_height` int(11) NOT NULL DEFAULT \'768\',\r\n  `preserve_thumb_aspect` tinyint(4) NOT NULL DEFAULT \'0\',\r\n  `show_titles` tinyint(4) NOT NULL DEFAULT \'0\',\r\n  `disable_sort` tinyint(4) NOT NULL DEFAULT \'0\',\r\n  PRIMARY KEY (`id`)\r\n) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;\r\n\r\nINSERT INTO `gallery_params` (`id`, `thumb_width`, `thumb_height`, `full_width`, `full_height`, `preserve_thumb_aspect`, `show_titles`, `disable_sort`) VALUES\r\n(1, 100, 100, 1024, 768, 0, 0, 0);\r\n\r\nCREATE TABLE IF NOT EXISTS `gallery_titles` (\r\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `image` varchar(255) NOT NULL,\r\n  `title` TEXT NOT NULL DEFAULT \'\',\r\n  `sort_order` bigint(20) NOT NULL DEFAULT \'-1\',\r\n  PRIMARY KEY (`id`)\r\n) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;', NULL, 1, 0, 0, NULL, 40);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(18, 'Login Form', 'Login form with hidden password reset form that appears upon request.', 'User Access Forms', 27, 'login', '_login', NULL, NULL, NULL, NULL, NULL, '<?php\r\nif (($login_required != 1) || ($show_login !== true))	{\r\n	include_once($captcha_includes_path);\r\n	echo \"\\n\\n<script src=\'\" . $scripts_dir_rel . \"hash.js\'> </script>\\n\\n\";\r\n}\r\n?>', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"ErrEmail\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    You must fill in the email address. Please try again.\r\n</div>\r\n<div id=\"ErrBadEmail\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    The email address you entered is not a valid email address. Please try again.\r\n</div>\r\n<div id=\"ErrCaptcha\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your CAPTCHA entry is incorrect. Please try again.\r\n</div>\r\n<div id=\"ErrBadPassword\" style=\" display:none;\" class=\"form_submit_error_txt\">\r\n    The password you entered is incorrect. Please try again.\r\n</div>\r\n<div id=\"ErrBadUser\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    The username you entered was not found in our system. Please check it and try again.\r\n</div>\r\n<div id=\"ErrAccessLevel\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    Your account does not have the required access level to access this page. Please contact the system administrator.\r\n</div>\r\n<div id=\"ErrNotActive\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    Your account has not been activated. Please contact the system administrator\r\n</div>\r\n<div id=\"PasswordReset\" style=\"display:none;\" class=\"form_submit_error_txt\">\r\n    A new password has been sent to the email address you provided. Please use it to login.\r\n</div>\r\n            \r\n<form name=\"frmLoginForm\" id=\"frmLoginForm\" method=\"post\" action=\"/php/login_verify.php\">\r\n  <div class=\"mail_form_div\" id=\"login_form\">\r\n    <span class=\"mail_form_heading\">Enter your user ID and password to login.</span>\r\n    <br />&nbsp;\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">User ID: </span></div>\r\n    <input type=\"text\" name=\"userid\" id=\"userid\" class=\"long_txt_field\" />\r\n    <br />&nbsp;\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Password: </span></div>\r\n	<input type=\"password\" name=\"password_input\" id=\"password_input\" class=\"long_txt_field\" onKeyDown=\"checkForEnter(event);\" />\r\n    <input type=\"hidden\" name=\"password\" id=\"password\" />\r\n    <br />&nbsp;\r\n    <br />&nbsp;\r\n    <div id=\"login_div_button\" class=\"btn_div\" onClick=\"SubmitLogin();\"><span id=\"login_button_txt\" class=\"btn_txt\">Submit</span></div>\r\n	\r\n    			<input type=\"hidden\" name=\"redirect\" id=\"redirect\" />\r\n                <input type=\"hidden\" name=\"user_table\" id=\"user_table\" value=\"accounts\" />\r\n                <input type=\"hidden\" name=\"AccessLevel\" id=\"AccessLevel\" />\r\n                <input id=\"alt_go_back\" name=\"alt_go_back\" type=\"hidden\" />\r\n			    <input id=\"redirect_err_to_src\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n    <br />&nbsp;\r\n    <br />&nbsp;\r\n    <span class=\"mail_form_small_text\" onclick=\"ShowPasswordReset();\" id=\"forgot_password_msg\">Click <u style=\"cursor:pointer;\">here</u> if you forgot your password.</span>\r\n  </div>\r\n</form>\r\n\r\n    <br />&nbsp;\r\n    <br />&nbsp;\r\n    <br />&nbsp;\r\n<form name=\"frmResetPassword\" id=\"frmResetPassword\" method=\"post\" action=\"/php/reset_password.php\">\r\n  <div class=\"mail_form_div\" id=\"reset_password_form\" style=\"display:none;\" >\r\n    <span class=\"mail_form_heading\">Enter your email address to reset your password.  Your new temporary password will be sent to your email.</span>\r\n    <br />&nbsp;\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Email: </span></div>\r\n    <input type=\"text\" name=\"email\" id=\"email\" class=\"long_txt_field\" />\r\n    <br />&nbsp;\r\n  	<br />&nbsp;\r\n    <div id=\"recaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"recaptcha_td\">\r\n      <script type=\"text/javascript\" src=\"https://www.google.com/recaptcha/api/challenge?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT\" id=\"recaptcha_script\">\r\n      </script>\r\n      <noscript>\r\n        <iframe src=\"https://www.google.com/recaptcha/api/noscript?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT\"\r\n                height=\"300\" width=\"500\" frameborder=\"0\" id=\"captcha_iframe\">\r\n        </iframe>\r\n        <br>\r\n        <textarea name=\"recaptcha_challenge_field\" rows=\"3\" cols=\"40\">\r\n        </textarea>\r\n        <input type=\"hidden\" name=\"recaptcha_response_field\" id=\"recaptcha_response_field\" value=\"manual_challenge\">\r\n      </noscript>\r\n    </div>\r\n  </div>\r\n  <div id=\"recaptcha2_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"recaptcha2_td\">\r\n      <div class=\"g-recaptcha\" data-sitekey=\"\" id=\"recaptcha2_div\">\r\n      </div>\r\n      <script type=\"text/javascript\" src=\"https://www.google.com/recaptcha/api.js?hl=en\">\r\n      </script>\r\n    </div>\r\n  </div>\r\n  <div id=\"wscaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <table>\r\n      <tr>\r\n        <td width=\"200\">\r\n          <img alt=\"wspcaptcha\" border=\"0\" id=\"wspcaptcha\" src=\"wspcaptcha.php\" /> \r\n        </td>\r\n        <td valign=\"bottom\" align=\"left\" width=\"100%\">\r\n          <a href=\"javascript:void(0);\" onclick=\"document.getElementById(\'wspcaptcha\').src=\'wspcaptcha.php?t=\'+(new Date()).getTime(); return false;\">\r\n            <img alt=\"Reload\" border=\"0\" src=\"/images/reload.gif\" /></a>\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td style=\"vertical-align: bottom;\" colspan=\"2\">\r\n          <input name=\"wsp_code\" id=\"wsp_code\" style=\"width:120px;\" type=\"text\" value=\"\" class=\"text_box\" />\r\n        </td>\r\n      </tr>\r\n      <tr>\r\n        <td colspan=\"2\">\r\n          Type in the letters you see <span class=\"mail_form_large_text\"><span class=\"required_fields\"><b>*</b></span></span>\r\n        </td>\r\n      </tr>\r\n    </table>\r\n  </div>\r\n  <div id=\"mollomcaptcha_row\">\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <div id=\"mollom_captcha\">&nbsp;\r\n    </div>\r\n    <input type=\"hidden\" name=\"mollom_session\" id=\"mollom_session\" />\r\n    <input type=\"text\" name=\"captcha_response_field\" id=\"captcha_response_field\" value=\"\" autocomplete=\"off\" />\r\n    <br />&nbsp;\r\n    <div class=\"field_title_div\">&nbsp;\r\n    </div>\r\n    <span class=\"mail_form_small_text mollom_instructions\">Type the characters you see in this picture</span>\r\n  </div>\r\n  <br />&nbsp;\r\n  <br />&nbsp;\r\n\r\n  <div id=\"reset_pass_div_btn\" class=\"btn_div\" onClick=\"document.getElementById(\'frmResetPassword\').submit();\"><span id=\"reset_pass_btn_txt\" class=\"btn_txt\">Submit</span></div>\r\n  \r\n				<input type=\"hidden\" name=\"redirect\" id=\"redirect2\" />\r\n                <input type=\"hidden\" name=\"user_table\" id=\"user_table2\" value=\"accounts\" />\r\n                <input type=\"hidden\" name=\"subject\" id=\"subject\" value=\"Password Reset Request\" />\r\n                <input type=\"hidden\" name=\"reply_to\" id=\"reply_to\" />\r\n                <input type=\"hidden\" name=\"from\" id=\"from\" />\r\n                <input type=\"hidden\" name=\"html\" id=\"html\" value=\"1\" />\r\n                <input type=\"hidden\" name=\"use_captcha\" id=\"use_captcha\" value=\"0\" />\r\n			    <input type=\"hidden\" name=\"captcha_type\" id=\"captcha_type\" value=\"recaptcha2\" />\r\n                <input id=\"alt_go_back2\" name=\"alt_go_back\" type=\"hidden\" />\r\n			    <input id=\"redirect_err_to_src2\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n                <input id=\"email_link_page\" name=\"email_link_page\" type=\"hidden\" />\r\n                \r\n  </div>\r\n</form>\r\n\r\n<div align=\"center\" class=\"warning_text\" id=\"javascript_warning\">WARNING: JavaScript must be enabled to use this system. Please turn on JavaScipt in your browser.</div>', NULL, NULL, NULL, NULL, '<?php\r\n	if (($login_required != 1) || ($show_login !== true))	{\r\n		include_once($captcha_includes_path2);\r\n		echo \"\\n\\n<script src=\'\" . $scripts_dir_rel . \"acct_mgmt.js\'> </script>\\n\\n\";\r\n		echo \"<script src=\'\" . $scripts_dir_rel . \"acct_mgmt_custom.js\'> </script>\\n\\n\";\r\n	}\r\n?>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#login_form', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 37),
(20, 'Change Password Form', 'Change Password Form.', 'User Access Forms', 27, 'change_password', '_change_password', NULL, NULL, NULL, NULL, NULL, '<script src=\"<?php echo $scripts_dir_rel; ?>generate_password.js\"></script>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>change_password.js\"></script>\r\n', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"ErrTooShort\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password must be at least <span id=\"password_length_msg\">8</span> characters long. Please try again.\r\n</div>\r\n<div id=\"ErrTooWeak\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password is too weak.  <span id=\"password_strength_msg\">Please fill in a password contaning both letters and numbers.</span>\r\n</div>\r\n<div id=\"ErrNoMatch\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password is blank or does not match the confirmation password. Please try again.\r\n</div>\r\n<div id=\"ErrSuccess\" style=\"display: none;\" class=\"form_submit_success_txt\">\r\n    Your password has been successfully changed.\r\n</div>\r\n<div id=\"ErrPassBlank\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password is blank. Please try again.\r\n</div>\r\n<div id=\"ErrPassNoMatch\" style=\"display: none;\" class=\"form_submit_error_txt\">\r\n    Your password doesn&#39;t match the confirm. Please try again.\r\n</div>\r\n\r\n<form name=\"frmChangePasswordForm\" id=\"frmChangePasswordForm\" method=\"post\" action=\"/php/change_password.php\">\r\n  <div class=\"mail_form_div\">\r\n  <span class=\"mail_form_heading\">Enter your new password and re-type it to confirm.  Then click &#39;Submit&#39; to save it:</span>\r\n      <br />&nbsp;\r\n    <div class=\"field_title_div\"><span class=\"mail_form_large_text\">Password, Confirm: </span></div>\r\n    <input type=\"password\" name=\"password\" id=\"password\" autocomplete=\"off\" class=\"medium_txt_field\" />\r\n    <input type=\"password\" name=\"password_confirm\" id=\"password_confirm\" autocomplete=\"off\" class=\"medium_txt_field\" />\r\n    <div onclick=\"convertType(document.getElementById(\'password\')); convertType(document.getElementById(\'password_confirm\'));\" class=\"reveal_pass_icon\">\r\n      &nbsp;\r\n    </div>\r\n    <div onclick=\"convertToTxt(document.getElementById(\'password\')); convertToTxt(document.getElementById(\'password_confirm\')); GeneratePassword();\" class=\"gen_pass_icon\">\r\n      &nbsp;\r\n    </div>\r\n	<br />&nbsp;\r\n    <br />&nbsp;\r\n    <div id=\"reset_pass_div_btn\" class=\"btn_div\" onClick=\"SubmitForm(\'frmChangePasswordForm\');\"><span id=\"reset_pass_btn_txt\" class=\"btn_txt\">Submit</span></div>\r\n    <input type=\"submit\" id=\"reset_pass_submit_btn\" value=\"Submit\" class=\"submit_btn\" />\r\n    \r\n    <input type=\"hidden\" name=\"redirect\" id=\"redirect\" value=\"/change_password_return.php\" />\r\n    <input type=\"hidden\" name=\"UserID\" id=\"UserID\" />\r\n    <input type=\"hidden\" name=\"user_table\" id=\"user_table\" value=\"accounts\" />\r\n    <input type=\"hidden\" name=\"subject\" id=\"subject\" value=\"Change Password\" />\r\n    <input type=\"hidden\" name=\"from\" id=\"from\" value=\"changepasswordform@example.com\" />\r\n    <input type=\"hidden\" name=\"html\" id=\"html\" value=\"1\" />\r\n    <input type=\"hidden\" name=\"password_length\" id=\"password_length\" value=\"8\" />\r\n    <input type=\"hidden\" name=\"password_strength\" id=\"password_strength\" value=\"medium\" />\r\n    <input id=\"alt_go_back\" name=\"alt_go_back\" type=\"hidden\" />\r\n    <input id=\"redirect_err_to_src\" name=\"redirect_err_to_src\" type=\"hidden\" value=\"1\" />\r\n    <input id=\"password_generated\" name=\"password_generated\" type=\"hidden\" />\r\n  </div>\r\n</form>', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#password_change_form', NULL, NULL, NULL, NULL, NULL, 1, 0, 1, 'InitializeForm();', 38),
(21, 'Blog Template', 'Template used for blogging.  This plugin is used automatically when the blog button is clicked.', NULL, -1, NULL, NULL, 'blog', 'Blog Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'blog\', \'.blog_subject\', \'Blog Subject\', 10, 0, 0),\r\n(\'blog\', \'.blog_timestamp\', \'Blog Timestamp\', 20, 0, 0),\r\n(\'blog\', \'.blog_message\', \'Blog Message\', 30, 0, 0),\r\n(\'blog\', \'.blog_author\', \'Blog Author\', 40, 0, 0),\r\n(\'blog\', \'.blog_hr\', \'Blog Horizontal Rule\', 50, 0, 0),\r\n(\'blog_mobile\', \'.blog_subject\', \'Blog Subject\', 10, 0, 0),\r\n(\'blog_mobile\', \'.blog_timestamp\', \'Blog Timestamp\', 20, 0, 0),\r\n(\'blog_mobile\', \'.blog_message\', \'Blog Message\', 30, 0, 0),\r\n(\'blog_mobile\', \'.blog_author\', \'Blog Author\', 40, 0, 0),\r\n(\'blog_mobile\', \'.blog_hr\', \'Blog Horizontal Rule\', 50, 0, 0),\r\n(\'blog_touchscreen\', \'.blog_subject\', \'Blog Subject\', 10, 0, 0),\r\n(\'blog_touchscreen\', \'.blog_timestamp\', \'Blog Timestamp\', 20, 0, 0),\r\n(\'blog_touchscreen\', \'.blog_message\', \'Blog Message\', 30, 0, 0),\r\n(\'blog_touchscreen\', \'.blog_author\', \'Blog Author\', 40, 0, 0),\r\n(\'blog_touchscreen\', \'.blog_hr\', \'Blog Horizontal Rule\', 50, 0, 0);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'blog_touchscreen\', \'.blog_message\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'blog_touchscreen\', \'.blog_subject\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'blog_touchscreen\', \'.blog_timestamp\', 1, \'-not selected-\', \'\', \'\', \'10.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'-40.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'blog_touchscreen\', \'.blog_author\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'blog\', \'.blog_subject\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'blog\', \'.blog_timestamp\', 1, \'-not selected-\', \'\', \'\', \'10.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'-40.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'blog\', \'.blog_message\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'blog\', \'.blog_author\', 1, \'-not selected-\', \'\', \'\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'\', \'\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3 class=\"blog_subject\">Subject</h3> <div class=\"blog_timestamp\">mm/dd/yyyy hh:ii:ss PM</div>\r\n<p class=\"blog_message\">Message</p>\r\n<div class=\"blog_author\">Username</div>\r\n<br />\r\n<hr class=\"blog_hr\" />', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, NULL, 200),
(22, 'HTML Contact Return Message', 'Page template for HTML contact return message.', 'Contact Forms', 26, 'contact_return_message', '_return_message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Request for Information</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Thank you for inquiring about our services.  Someone will get back to you shortly.</p>\r\n<p>Best regards,<br/>\r\nThe Contact Response Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mail_form', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 32),
(23, 'HTML Account Create Return Message', 'Page template for HTML account create return message.', 'User Access Forms', 27, 'create_account_return_message', '_return_message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Creation of New Account</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Thank you for signing up with our company.  Your request for an account will be reviewed by our staff shortly.</p>\r\n<p>Best regards,<br/>\r\nThe Account Management Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 35),
(24, 'HTML New Account Welcome Message', 'Page template for HTML new account welcome message.', 'User Access Forms', 27, 'create_account_welcome_message', '_welcome_message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Account Approved</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Your account has been activated.  You can now login and access your account. Your user ID is [USER_ID] and your password is [PASSWORD].</p>\r\n<p>Best regards,<br/>\r\nThe Account Management Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 36);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(25, 'Horizontal Scrolling Slideshow', 'Horizontal Scrolling Slideshow jQuery Cycle v1 (Works with pictures or text)', 'Slideshows', -1, NULL, NULL, 'scrolling_slideshow', 'Scrolling Slideshow Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'scrolling_slideshow\', \'#slideshow\', \'Slideshow Div\', 10, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow ul\', \'Slideshow UL\', 20, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow ul:after\', \'Slideshow UL:after\', 30, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides\', \'Slideshow Slides\', 40, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides li > img\', \'Slideshow Slide Image\', 45, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides ul\', \'Slideshow Slides UL\', 50, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides li\', \'Slideshow Slides LI\', 60, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides h2\', \'Slideshow Slides H2\', 70, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav\', \'Slideshow Slides Navigation\', 80, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li\', \'Slideshow Slides Navigation LI\', 90, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li a\', \'Slideshow Slides Navigation LI Link\', 100, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li.on\', \'Slideshow Slides Navigation Tab\', 110, 0, 0),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li.on a\', \'Slideshow Slides Navigation Tab Link\', 120, 0, 0),\r\n(\'scrolling_slideshow\', \'#prev\', \'Previous Slide Nav Div\', 130, 500, 0),\r\n(\'scrolling_slideshow\', \'#prev:hover\', \'Previous Slide Nav Div Hover\', 135, 500, 0),\r\n(\'scrolling_slideshow\', \'#next\', \'Next Slide Nav Div\', 140, 500, 0),\r\n(\'scrolling_slideshow\', \'#next:hover\', \'Next Slide Nav Div Hover\', 145, 500, 0),\r\n(\'scrolling_slideshow\', \'#pause\', \'Pause Slideshow Nav Div\', 150, 500, 0),\r\n(\'scrolling_slideshow\', \'#pause:hover\', \'Pause Slideshow Nav Div Hover\', 155, 500, 0),\r\n(\'scrolling_slideshow\', \'#resume\', \'Resume Slideshow Nav Div\', 160, 500, 0),\r\n(\'scrolling_slideshow\', \'#resume:hover\', \'Resume Slideshow Nav Div Hover\', 165, 500, 0),\r\n(\'scrolling_slideshow\', \'#slideshow ul:after\', \'Clear affects of slideshow CSS after slideshow\', 170, 500, 0);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'scrolling_slideshow_touchscreen\', \'#cycle-button-pause\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'scrolling_slideshow_touchscreen\', \'#cycle-button-resume.display-inline, #cycle-button-pause.display-inline\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'#cycle-buttons\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-caption\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#fff\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'15.000\', 0, \'15.000\', 0, 700, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'#cycle-button-resume.display-none, #cycle-button-pause.display-none\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'scrolling_slideshow_touchscreen\', \'.disabled\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', 50, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 1, \'-1000000.00\', 0, 1, \'10.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/spinner.gif\', \'scroll\', \'no-repeat\', \'xpos ypos\', \'50.000\', \'50.000\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-prev:hover, .cycle-next:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', 50, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-prev, .cycle-next\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', 0, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'0.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, 800, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-pager span\', 1, \'Arial\', \'-not selected-\', \'-not selected-\', \'50.00\', \'px\', \'#ddd\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'16.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'16.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-pager span.cycle-pager-active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#D69746\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-paused:after\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#fff\', \'10.00\', 0, \'10.00\', 0, \'10.00\', 0, \'10.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#000\', 50, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'10.000\', 0, \'10.000\', 0, \'-1000000.000\', 0, 500, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'10.00\', 0, \'10.00\', 0, \'10.00\', 0, \'10.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'string\', \'Paused\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow #slide-one img\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-470.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-prev\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'0.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/left.png\', \'scroll\', \'no-repeat\', \'xpos ypos\', \'10.000\', \'50.000\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow #slide-three img\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'110.000\', 9, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-10.000\', 9, \'-510.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow #slide-two img\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-490.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow .cycle-slide\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'0.000\', 0, \'0.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow .cycle-slide:first-child\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'static\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, 100, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-slideshow img\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'100.000\', 9, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-next\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'0.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/right.png\', \'scroll\', \'no-repeat\', \'xpos ypos\', \'90.000\', \'50.000\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-overlay\', 1, \'Tahoma\', \'Arial\', \'-not selected-\', \'-1.00\', \'px\', \'#fff\', \'15.00\', 0, \'15.00\', 0, \'15.00\', 0, \'15.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#000\', 50, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'0.000\', 0, 600, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-pager\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#fff\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'absolute\', \'-1000000.000\', 0, \'250.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, 500, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow_touchscreen\', \'.cycle-pager > *\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'scrolling_slideshow\', \'\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#next\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#pause\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'scrolling_slideshow\', \'#prev\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#resume\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'#eeeeee\', -1, 0, 0, \'1.00\', 0, \'#dddddd\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'960.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, NULL, NULL, \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'960.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides h2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'0.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides li\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'20.00\', 0, \'20.00\', 0, \'20.00\', 0, \'20.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'920.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides ul\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'2880.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#dddddd\', -1, 0, 0, \'2.00\', 0, \'#cccccc\', \'solid\', \'-not selected-\', \'-not selected-\', 8, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 8, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'15.00\', 0, \'20.00\', 0, \'15.00\', 0, \'20.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'none\', \'-not selected-\', 8, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li.on\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#eeeeee\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 8, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides-nav li.on a\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#eeeeee\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 8, \'-4.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow ul\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', NULL, \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'1.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', NULL, NULL, NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'none\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, -1, 0, -1, 0, NULL, \'-1.000\', 0, \'-1.000\', \'-1.000\', NULL, NULL, 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow ul:after\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'0.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'both\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'string\', \'.\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'scrolling_slideshow\', \'#slideshow .slides li > img\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'920.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'160.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);', NULL, '<script src=\"<?php echo $scripts_dir_rel; ?>jquery.min.js\"></script>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>jquery.cycle.js\"></script>\r\n<script src=\"<?php echo $scripts_dir_rel; ?>slideshow.js\"></script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id=\"slideshow\">\r\n	<div id=\"prev\">&lt;</div>\r\n    <div class=\"slides\">\r\n        <ul>\r\n            <li id=\"slide-one\">\r\n                <img src=\"images/sample1.jpg\" alt=\"slide 1\" />\r\n            </li>\r\n            <li id=\"slide-two\">\r\n            	<h2>Slides can contain images or text.</h2>\r\n                <p>\r\n                    Lorem ipsum dolor sit amet, consectetur adipiscing elit.  \r\n                    Donec pretium arcu non velit. Phasellus adipiscing auctor  \r\n                    lorem. Curabitur in urna ut purus consequat sollicitudin.  \r\n                    Phasellus ut diam. Cras magna libero, tempor id, venenatis  \r\n                    sit amet, venenatis et, dui.  \r\n                </p>\r\n                <p>\r\n                    Nam ac nibh sit amet augue ultricies sagittis. Donec sit  \r\n                    amet nunc. Vivamus lacinia, nisi ac tincidunt commodo, purus  \r\n                    nisi condimentum urna, sit amet molestie odio dolor non lectus.  \r\n                    Cum sociis natoque penatibus et magnis dis parturient montes,  \r\n                    nascetur ridiculus mus.  \r\n                </p>\r\n            </li>\r\n            <li id=\"slide-three\">\r\n                <img src=\"images/sample2.jpg\" alt=\"slide 3\" />\r\n            </li>\r\n        </ul>\r\n    </div>\r\n    <ul class=\"slides-nav\">\r\n        <li><a href=\"#slide-one\">Slide one</a></li>\r\n        <li><a href=\"#slide-two\">Slide two</a></li>\r\n        <li><a href=\"#slide-three\">Slide three</a></li>\r\n    </ul>\r\n    <div id=\"next\">&gt;</div>\r\n	<div id=\"pause\">||</div>\r\n	<div id=\"resume\">&rarr;</div>\r\n</div>', NULL, NULL, NULL, NULL, NULL, '<script language=\"javascript\" type=\"text/javascript\">\r\n    $(function() {  \r\n        // add a \"js\" class to the body  \r\n        $(\"body\").addClass(\"js\");  \r\n        // initialise the slideshow when the DOM is ready  \r\n        $slideshow.init();  \r\n    });  \r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#horizontal_scrolling', NULL, NULL, NULL, NULL, NULL, 1, 0, 0, NULL, 55);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `parent`, `default_page_name`, `page_name_suffix`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `custom_css_sql`, `cookie_session_code`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `language_folder`, `console_link_text_define`, `menu_group`, `plugin_sql`, `AccessLevel`, `available`, `disable_site_styles`, `body_onload`, `body_onload_function`, `sort_order`) VALUES
(27, 'Account Creation Form', 'Account Creation Form with user ID and password fields, auto-table creation, CAPTCHA, and custom response email and return page.', 'User Access Forms', 27, 'create_account', NULL, 'mail_form', 'Mail Form Styles', 'REPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', \'Reveal Password Icon: Hover\', 411, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon\', \'Generate Password Icon\', 412, 500, 1),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', \'Generate Password Icon: Hover\', 413, 500, 1);\r\n\r\nREPLACE INTO `bwb_site_classes` (`style_sheet`, `class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(\'mail_form_mobile\', \'.mail_form_div *:not(option)\', \'All Objects in Mail Form Div except Option\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_table\', \'Mail Form Table\', 10, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td\', \'Mail Form Table Cell\', 20, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_td_field_title\', \'Mail Form Cell for Field Title\', 30, 0, 1),\r\n(\'mail_form_mobile\', \'.mail_form_heading\', \'Mail Form Heading\', 35, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_large_text\', \'Mail Form Text\', 40, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_small_text\', \'Mail Form Text (small)\', 50, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div\', \'Mail Form Div\', 5, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_div\', \'Submit Button\', 60, 0, 0),\r\n(\'mail_form_mobile\', \'.btn_txt\', \'Submit Button Text\', 70, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div\', \'User Account Link\', 80, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:link\', \'User Account Link Link\', 82, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:visited\', \'User Account Lisk Visited\', 84, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:hover\', \'User Account Link Hover\', 86, 0, 0),\r\n(\'mail_form_mobile\', \'.link_div a:active\', \'User Account Link Active\', 88, 0, 0),\r\n(\'mail_form_mobile\', \'.link_txt\', \'User Account Link Text\', 90, 0, 0),\r\n(\'mail_form_mobile\', \'#form_div_btn\', \'Form Submit Button\', 100, 0, 0),\r\n(\'mail_form_mobile\', \'#form_btn_txt\', \'Form Submit Button Text\', 110, 0, 0),\r\n(\'mail_form_mobile\', \'#login_logout\', \'Login Logout Div\', 120, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', \'Logout Button\', 130, 0, 0),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', \'Logout Button Text\', 140, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', \'Create Account Button\', 150, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_btn_txt\', \'Create Account Button Text\', 155, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_div_button\', \'Create Account Form Button\', 160, 0, 0),\r\n(\'mail_form_mobile\', \'#create_acct_button_txt\', \'Create Account Form Button Text\', 165, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', \'Generate Password Button\', 170, 0, 0),\r\n(\'mail_form_mobile\', \'#generate_pass_btn_txt\', \'Generate Password Button Text\', 175, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_btn\', \'Login Button\', 180, 0, 0),\r\n(\'mail_form_mobile\', \'#login_btn_txt\', \'Login Button Text\', 185, 0, 0),\r\n(\'mail_form_mobile\', \'#login_div_button\', \'Login Form Button\', 190, 0, 0),\r\n(\'mail_form_mobile\', \'#login_button_txt\', \'Login Form Button Text\', 195, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_div_btn\', \'Reset Password Button\', 200, 0, 0),\r\n(\'mail_form_mobile\', \'#reset_pass_btn_txt\', \'Reset Password Button Text\', 210, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', \'My Account Button\', 220, 0, 0),\r\n(\'mail_form_mobile\', \'#my_account_btn_txt\', \'My Account Button Text\', 230, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_error_txt\', \'Form Submit Error Text\', 240, 0, 0),\r\n(\'mail_form_mobile\', \'.field_highlight\', \'Form Submit Field Highlight\', 250, 0, 0),\r\n(\'mail_form_mobile\', \'.form_submit_success_txt\', \'Form Submit Success Text\', 255, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_image\', \'Mollom CAPTCHA Image\', 260, 0, 0),\r\n(\'mail_form_mobile\', \'.mollom_instructions\', \'Mollom CAPTCHA Instructions\', 262, 0, 0),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', \'Text Field, Tiny\', 265, 0, 0),\r\n(\'mail_form_mobile\', \'.short_txt_field\', \'Text Field, Short\', 270, 0, 0),\r\n(\'mail_form_mobile\', \'.medium_txt_field\', \'Text Field, Medium\', 275, 0, 0),\r\n(\'mail_form_mobile\', \'.long_txt_field\', \'Text Field, Long\', 280, 0, 0),\r\n(\'mail_form_mobile\', \'.field_title_div\', \'Mail Form Div for Field Title\', 285, 0, 0),\r\n(\'mail_form_mobile\', \'.required_field\', \'Required Field Highlight\', 290, 0, 0),\r\n(\'mail_form_mobile\', \'.required_box\', \'Required Field Example Box\', 292, 0, 0),\r\n(\'mail_form_mobile\', \'.required_mark\', \'Required Field Mark\', 294, 0, 0),\r\n(\'mail_form_mobile\', \'.required_msg\', \'Required Field Message\', 296, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', \'reCAPTCHA Row\', 300, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', \'reCAPTCHA API 2 Row\', 310, 0, 0),\r\n(\'mail_form_mobile\', \'#wscaptcha_row\', \'WS CAPTCHA Row\', 315, 0, 0),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', \'Mollom CAPTCHA Row\', 320, 0, 0),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', \'Mollom CAPTCHA\', 321, 0, 0),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', \'CAPTCHA Response Field\', 322, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td\', \'reCAPTCHA Cell\', 325, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_td *\', \'All Elements in reCAPTCHA Cell\', 330, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_widget_div\', \'reCAPTCHA Widget Div\', 335, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', \'reCAPTCHA Area\', 340, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table\', \'reCAPTCHA Table\', 345, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tbody\', \'reCAPTCHA Table Body\', 350, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table tr\', \'reCAPTCHA Table Row\', 355, 0, 0),\r\n(\'mail_form_mobile\', \'#recaptcha_table td\', \'reCAPTCHA Table Cell\', 360, 0, 0),\r\n(\'mail_form_mobile\', \'.group_div\', \'Radio or Checkbox Group Div\', 365, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div textarea\', \'Text Area\', 370, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', \'Select Dropdown List\', 375, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"radio\"]\', \'Radio Button\', 380, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"checkbox\"]\', \'Checkbox\', 385, 0, 0),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\"file\"]\', \'File Upload\', 390, 0, 0),\r\n(\'mail_form_mobile\', \'#city\', \'City Text Field\', 395, 0, 0),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', \'Forgot Password Message\', 400, 0, 0),\r\n(\'mail_form_mobile\', \'.address_block\', \'Company Address Block\', 405, 0, 0),\r\n(\'mail_form_mobile\', \'.gen_pass_icon\', \'Reveal Password Icon\', 412, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon\', \'Reveal Password Icon\', 410, 500, 1),\r\n(\'mail_form_mobile\', \'.gen_pass_icon:hover\', \'Generate Password Icon: Hover\', 413, 500, 1),\r\n(\'mail_form_mobile\', \'.reveal_pass_icon:hover\', \'Generate Password Icon: Hover\', 411, 500, 1);', 'REPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'.block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#city\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'400.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#first_name\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"file\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div input[type=\\\"radio\\\"]\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.mail_form_div select\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'0.00\', 0, 0, \'10.00\', 0, 0, \'inline-block\', \'75.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha2_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table tbody\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-cell\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_widget_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_table tr\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'table-row\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#recaptcha_td *\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'collapse\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'initial\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#total\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'22.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'76.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'30.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#reset_pass_submit_btn\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.btn_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'16.00\', 0, \'15.00\', 0, \'3.00\', 0, \'15.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, 18, 2, \'-1000000.00\', -1, \'#2d5c88\', -1, 0, 0, \'1.00\', 0, \'#0b3a66\', \'solid\', \'-not selected-\', \'-not selected-\', 4, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'33.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.btn_txt\', 1, \'Titillium Web\', \'Arial\', \'sans-serif\', \'18.00\', \'px\', \'#fff\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', 0, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'100.00\', 0, 0, \'30.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.field_highlight\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#FF0000\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.field_required\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'2.00\', 0, \'#8DD9F4\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'4.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'.form_submit_success_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'24.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.field_title_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'5.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'top\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'0.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.form_submit_error_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'18.00\', \'px\', \'#ff0000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 1, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFF88\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'5.00\', 0, \'-1.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:active\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#550000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.gen_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:visited\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:hover\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, 0, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000055\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 1, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_div a:link\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'#000000\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_txt\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:active\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.long_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'325.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:link\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#006400\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.link_text a:visited\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'#00B4CC\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 1, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mailing_list_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'180.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'3.00\', 0, \'6.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'16.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_div\', 1, \'Titillium Web\', \'Arial\', \'sans-serif\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'50.00\', 0, 0, \'-1000000.00\', 0, 0, \'20.00\', 1, 0, \'50.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.medium_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_large_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mollomcaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_mark\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.mollom_instructions\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'10.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_box\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'3.00\', 0, \'#888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'1.00\', 1, 0, \'10.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'15.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'15.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.required_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'#F00\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_touchscreen\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.reveal_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.short_txt_field	\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.submit_btn_txt\', 1, \'Arial\', \'Verdana\', \'sans-serif\', \'14.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_touchscreen\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'#recaptcha2_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-130.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'110.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'relative\', \'200.000\', 0, \'-130.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#form_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#form_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#generate_pass_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.gen_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.gen_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_dice_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'.reveal_pass_icon:hover\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm_mo.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.reveal_pass_icon\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, 20, 2, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'20.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'icons/icon_eye_sm.png\', \'scroll\', \'no-repeat\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.address_block\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'14.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'100.00\', 0, 0, \'30.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#generate_pass_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#login_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#create_acct_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#forgot_password_msg\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_heading\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'16.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'bold\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'5.00\', 0, 0, \'20.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#create_acct_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_table\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#wscaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#comments\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'800.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'300.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'35.00\', 1, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_div textarea\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'345.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#login_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#login_logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'160.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout_btn_txt\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout_submit_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#logout_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'10.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'right\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#mollomcaptcha_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'none\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'\', \'\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.short_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.title_width\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'26.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.submit_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'3.00\', 0, \'6.00\', 0, \'3.00\', 0, \'6.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'#FFFFFF\', -1, 0, 0, \'2.00\', 0, \'#888888\', \'solid\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'2.0\', \'2.0\', \'2.0\', \'1.0\', \'#888888\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'5.00\', 0, \'pointer\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.third_party\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'100.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.tiny_txt_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'40.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'3.00\', 0, 0, \'-not selected-\', \'150.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.group_div\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'5.00\', 0, \'-1.00\', 0, \'3.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#mollom_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'10.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'right\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#paypal_image\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'60.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#my_account_div_btn\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'5.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'\', \'\', \'\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'left\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha2_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form_mobile\', \'#recaptcha2_row\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_area\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#recaptcha_row\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.title_width2\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'49.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'.title_width1\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'60.000\', 1, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'\', \'\', \'\', \'\', \'\', \'\', -1, 0, -1, 0, \'\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'\', \'\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mailing_list_captcha\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'180.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'hidden\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'3.00\', 0, \'6.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, \'-not set-\', \'-not set-\', 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form_mobile\', \'#captcha_response_field\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'45.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'10.00\', 0, 0, \'0.00\', 0, 0, \'25.00\', 1, 0, \'10.00\', 0, 0, \'inline-block\', \'250.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'50.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL);\r\n\r\nREPLACE INTO `bwb_site_css` (`style_sheet`, `class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `font_size_units`, `text_color`, `padding_top`, `padding_top_units`, `padding_right`, `padding_right_units`, `padding_bottom`, `padding_bottom_units`, `padding_left`, `padding_left_units`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `text_shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `text_align`, `vertical_align`, `vertical_align_length`, `vertical_align_length_units`, `line_height`, `line_height_units`, `text_indent`, `text_indent_units`, `bkgd_color`, `bkgd_opacity`, `bkgd_transparent`, `bkgd_rgba`, `border`, `border_units`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `min_width`, `min_width_units`, `max_width`, `max_width_units`, `height`, `height_units`, `min_height`, `min_height_units`, `max_height`, `max_height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `overflow_x`, `overflow_y`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`, `visibility`, `justify_content`, `content`, `content_text`, `text_transform`, `transition_property`, `transition_timing_function`, `transition_duration`, `transition_duration_units`, `transition_delay`, `transition_delay_units`, `flex_basis`, `flex_basis_length`, `flex_basis_length_units`, `flex_grow`, `flex_shrink`, `flex_direction`, `flex_wrap`, `gradient_type`, `gradient_angle`, `gradient_colors`, `gradient_opacities`, `gradient_repeat`, `box_sizing`, `align_content`, `align_items`, `align_self`) VALUES\r\n(\'mail_form\', \'.mail_form_div *:not(option)\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'inline-block\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_div\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'center\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, 0, 0, 0, \'-not selected-\', \'0.000\', 0, \'0.000\', \'0.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'.mail_form_small_text\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'12.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'normal\', 0, 0, 0, 0, 0, \'0.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 15, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, \'-1000000.000\', 0, -1000000, \'-not selected-\', \'-not selected-\', \'-not selected-\', NULL, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-1.00\', -1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'0.000\', \'0.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1000000.0\', \'-1000000.0\', \'-1.0\', \'-1000000.0\', \'-not set-\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'0.00\', 0, \'-not selected-\', \'-not selected-\', \'-1.000\', 0, \'-1.000\', 0, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'\', \'-not selected-\', \'-not selected-\', \'-not selected-\', -1, 0, -1, 0, \'-not selected-\', \'-1.000\', 0, \'-1.000\', \'-1.000\', \'-not selected-\', \'-not selected-\', 0, 0, NULL, NULL, 0, NULL, NULL, NULL, NULL),\r\n(\'mail_form\', \'#recaptcha_td\', 1, \'-not selected-\', \'-not selected-\', \'-not selected-\', \'-1.00\', \'px\', \'-not set-\', \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-1.00\', 0, \'-not selected-\', 0, 0, 0, 0, 0, \'-1000000.00\', -1, 0, 0, 0, 0, \'-not set-\', \'0.0\', \'0.0\', \'0.0\', \'-not selected-\', \'-not selected-\', \'-1000000.00\', 0, -1, -1, \'-1000000.00\', -1, \'-not set-\', -1, 0, 0, \'-1.00\', 0, \'-not set-\', \'-not selected-\', \'-not selected-\', \'-not selected-\', 0, \'-1000000.00\', 0, 0, \'-1000000.00\', 0, 0, \'150.00\', 0, 0, \'-1000000.00\', 0, 0, \'block\', \