CREATE TABLE IF NOT EXISTS `height_lookup` (
  `height` double NOT NULL default '0',
  PRIMARY KEY  (`height`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `search_terms` (
  `search_term` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`search_term`),
  UNIQUE KEY `search_term` (`search_term`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `users` (
  `UserID` varchar(50) NOT NULL default '',
  `Password` varchar(255) default NULL,
  `view_id` int(11) default NULL,
  PRIMARY KEY  (`UserID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `users` (`UserID`, `Password`, `view_id`) VALUES
('admin', '000000000077757B', 1),
('user', '00000000747474', 2),
('manager', '5B545A525554', 1),
('reseller', '43574051595A', 3);

CREATE TABLE IF NOT EXISTS `view_fields` (
  `vf_id` int(11) NOT NULL auto_increment,
  `view_ID` int(11) NOT NULL default '0',
  `vf_DisplayName` varchar(100) NOT NULL default '',
  `vf_ColumnName` varchar(100) NOT NULL default '',
  `vf_Order` int(11) default NULL,
  `vf_DataQuery` varchar(255) default NULL,
  `vf_FieldType` enum('text','textarea','select','multiselect','hidden','checkbox') default NULL,
  PRIMARY KEY  (`vf_id`),
  UNIQUE KEY `vf_id` (`vf_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=115 ;

CREATE TABLE IF NOT EXISTS `view_names` (
  `view_ID` int(10) unsigned NOT NULL auto_increment,
  `view_Name` varchar(50) NOT NULL default '',
  `view_Users` set('Manager','Associate') NOT NULL default '',
  `view_Criteria` varchar(255) default NULL,
  PRIMARY KEY  (`view_ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

INSERT INTO `view_names` (`view_ID`, `view_Name`, `view_Users`, `view_Criteria`) VALUES
(1, 'Default', 'Manager', NULL),
(2, 'Associate', 'Associate', '');

CREATE TABLE IF NOT EXISTS `width_lookup` (
  `width` double NOT NULL default '0',
  PRIMARY KEY  (`width`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
